//---------------------------------------------------------------------------

#ifndef StudySpeedControl_FormH
#define StudySpeedControl_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>

#include "Environment.h"
#include <Grids.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#define MAX_SPEED_BACKUP_COUNT				100

#define _STUDY_MS_SPEED_INDEX 7
#define _STUDY_MS_SHAPE_INDEX 7
#define _STUDY_SPEED_CONTROL_INDEX  0

//---------------------------------------------------------------------------
class TStudySpeedControlForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel8;
	TTntGroupBox *GroupBox1;
	TTntLabel *Label7;
	TTntLabel *Label8;
	TTntLabel *Label9;
	TTntLabel *Label10;
	TTntLabel *BFIDSpeedLabel;
	TTntLabel *BFODInSpeedLabel;
	TTntLabel *VDSpeedLabel;
	TTntPanel *MotorSpeedPanel1;
	TTntButton *MotorSpeedResetButton;
	TTntLabel *Label1;
	TTntButton *FeederInnerDiscSpeedUpButton;
	TTntButton *FeederInnerDiscSpeedDownButton;
	TTntButton *RotationInSpeedUpButton;
	TTntButton *RotationInSpeedDownButton;
	TTntButton *VacuumDiscSpeedUpButton;
	TTntButton *VacuumDiscSpeedDownButton;
	TTntPanel *Panel3;
	TTntPanel *FeederSpeedControlPanel;
	TTntGroupBox *GroupBox2;
	TTntPanel *VFSpeedAutoTrainingPanel;
	TTntPanel *VFSpeedManualTrainingPanel;
	TTntPanel *SpeedControlPanel;
	TTntPanel *Panel5;
	TTntButton *ApplyMachineSpeedButton;
	TTntBitBtn *OkBitBtn;
	TTntBitBtn *CancelBitBtn;
	TTntGroupBox *VFManualModeGroupBox;
	TTntLabel *Label5;
	TTntLabel *Label12;
	TTntLabel *Label13;
	TTntLabel *Label14;
	TTntEdit *VibMaxSpeedEdit;
	TTntEdit *VFManualSensorRatioEdit;
	TTntComboBox *VFManualSensorComboBox;
	TTntLabel *Label3;
	TTntGroupBox *VFAutoModeGroupBox;
	TTntLabel *Label4;
	TTntLabel *Label2;
	TTntLabel *Label6;
	TTntLabel *Label11;
	TTntLabel *Label15;
	TTntLabel *Label16;
	TTntEdit *VFAutoSensor1RatioEdit;
	TTntEdit *VFAutoSensor2RatioEdit;
	TTntEdit *VFAutoStartSpeedEdit;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntLabel *TntLabel3;
  TTntComboBox *VFManualLimitSensorComboBox;
  TTntEdit *VFManualLimitSensorRatioEdit;
  TTntEdit *VibLimitSpeedEdit;
  TTntLabel *TntLabel4;
  TTntLabel *TntLabel5;
  TPanel *SimpleVDPanel;
  TPanel *VDSpeedLabelPanel;
  TTntLabel *VDSimpleSpeedLabel;
	TTntLabel *TntLabel6;
	TTntLabel *BFODOutSpeedLabel;
	TTntButton *RotationOutSpeedUpButton;
	TTntButton *RotationOutSpeedDownButton;
	void __fastcall MotorSpeedResetButtonClick(TObject *Sender);
	void __fastcall MotorSpeedPanelClick(TObject *Sender);
	void __fastcall OkBitBtnClick(TObject *Sender);
	void __fastcall FeederInnerDiscSpeedUpButtonClick(TObject *Sender);
	void __fastcall FeederInnerDiscSpeedDownButtonClick(TObject *Sender);
	void __fastcall RotationInSpeedUpButtonClick(TObject *Sender);
	void __fastcall RotationInSpeedDownButtonClick(TObject *Sender);
	void __fastcall VacuumDiscSpeedUpButtonClick(TObject *Sender);
	void __fastcall VacuumDiscSpeedDownButtonClick(TObject *Sender);
	void __fastcall VFSpeedAutoTrainingPanelClick(TObject *Sender);
	void __fastcall VFSpeedManualTrainingPanelClick(TObject *Sender);
	void __fastcall ApplyMachineSpeedButtonClick(TObject *Sender);
  void __fastcall NumEdit(TObject *Sender);
	void __fastcall RotationOutSpeedUpButtonClick(TObject *Sender);
	void __fastcall RotationOutSpeedDownButtonClick(TObject *Sender);
private:	// User declarations
	int CurrentMotorSpeedIndex;
    int CurrentMotorSpeedList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
	int CurrentMotorSpeedRatioList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
	int SpeedBackupDataIndex;
	bool VFSpeedAutoTraining;

  int CurrentSimpleSpeedIndex[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];

    int OldVFAutoTrainingMode;
    int OldVFManualSpeed;
    int OldVFManualSensorIndex;
    int OldVFManualSensorActiveRatio;
    int OldVFManualLimitSpeed;
    int OldVFManualLimitSensorIndex;
    int OldVFManualLimitSensorActiveRatio;
    int OldVFSensor1Ratio;
    int OldVFSensor2Ratio;
    int OldVFStartSpeed;

	void __fastcall ApplyMotorSpeed(void);
	bool __fastcall ApplyMachineSpeedChange(void);
	void __fastcall SaveVFSpeedParam(void);
  void __fastcall TStudySpeedControlForm::GetDefaultString();
public:		// User declarations
	__fastcall TStudySpeedControlForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TStudySpeedControlForm *StudySpeedControlForm;
//---------------------------------------------------------------------------
#endif
