//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SystemInfo_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TSystemInfoForm *SystemInfoForm;

//---------------------------------------------------------------------------
__fastcall TSystemInfoForm::TSystemInfoForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	this->Caption = SYSTEMINFOFORM_FORM_CAPTION_01;

    Panel3->Caption 		= SYSTEMINFOFORM_LABEL_CAPTION_10;
    TntPanel1->Caption 	= SYSTEMINFOFORM_LABEL_CAPTION_11;
    Panel5->Caption 		= SYSTEMINFOFORM_LABEL_CAPTION_12;
    TntPanel2->Caption 	= SYSTEMINFOFORM_LABEL_CAPTION_13;
    TntPanel3->Caption 	= SYSTEMINFOFORM_LABEL_CAPTION_14;
    TntPanel4->Caption 	= SYSTEMINFOFORM_LABEL_CAPTION_15;

	HCBConnected = false;
	HCBVersionValid = false;
  
	for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
	{
		SPBConnected[spbIndex] = false;
		SPBVersionValid[spbIndex] = false;
	}

	ReadTPB_BoardExistInfo();


}
//---------------------------------------------------------------------------
void __fastcall TSystemInfoForm::FormCreate(TObject *Sender)
{
	OkButton->Caption = SYSTEMMONITORFORM_BUTTON_CAPTION_01;
	ReadProgramVersion();
	ShowProgramVersion();
}
//---------------------------------------------------------------------------
void __fastcall TSystemInfoForm::ReadProgramVersion(void)
{
  int  test_val = 0;

	if (Comm_IsConnected(COMM_HCB))
	{
		HCBConnected = true;
		if (Comm_Request(COMM_HCB, CMD_VERSION_INFO, NULL, 0, &HCBVersion, sizeof(TProgramVersion)))
		{
			HCBVersionValid = true;
			Comm_Request(COMM_HCB, CMD_READ_COMPATIBILITY, NULL, 0, &HCBCompatibility, sizeof(THCBCompatibility));
		}
		else
		{
			HCBVersionValid = false;
		}
	}
	else
	{
		HCBConnected = false;
		HCBVersionValid = false;
	}

	for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
	{
		if (Comm_IsConnected(COMM_SPB + spbIndex))
		{
			SPBConnected[spbIndex] = true;
			if (Comm_Request(COMM_SPB + spbIndex, CMD_VERSION_INFO, NULL, 0, &SPBVersion[spbIndex], sizeof(TProgramVersion)))
			{
				SPBVersionValid[spbIndex] = true;
				Comm_Request(COMM_SPB + spbIndex, CMD_FPGA_VERSION_INFO, NULL, 0, &SPBFPGAVersion[spbIndex], sizeof(TSPBFPGAVersion));
				Comm_Request(COMM_SPB + spbIndex, CMD_READ_COMPATIBILITY, NULL, 0, &SPBCompatibility[spbIndex], sizeof(TSPBCompatibility));
			}
			else
			{
				SPBVersionValid[spbIndex] = false;
			}
		}
		else
		{
			SPBConnected[spbIndex] = false;
			SPBVersionValid[spbIndex] = false;
		}
	}

	if (Comm_IsConnected(COMM_TPB))
	{
		TPBConnected = true;
		if (Comm_Request(COMM_TPB, CMD_VERSION_INFO, NULL, 0, &TPBVersion, sizeof(TProgramVersion)))
		{
			TPBVersionValid = true;

			if(Comm_Request(COMM_TPB, CMD_FPGA_VERSION_INFO, NULL, 0, &TPBFPGAVersion, sizeof(TSPBFPGAVersion)))
        TPB_FPGAVersionValid = true;
      else
        TPB_FPGAVersionValid = false;

      if(Comm_Request(COMM_TPB, CMD_READ_COMPATIBILITY, NULL, 0, &TPBCompatibility, sizeof(TSPBCompatibility)))
        TPB_CPBVersionValid = true;
      else
        TPB_CPBVersionValid = false;
		}
		else
		{
			TPBVersionValid = false;
		}
	}
	else
	{
		TPBConnected = false;
		TPBVersionValid = false;
    TPB_FPGAVersionValid = false;
    TPB_CPBVersionValid = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TSystemInfoForm::ShowProgramVersion(void)
{
  WideString tmpWStr;
  tmpWStr.SetLength(100);

  wsprintfW(tmpWStr, L"%d.%d.%d.%c", ProgramVersion.MajorVersion, ProgramVersion.MinorVersion, ProgramVersion.Date, ProgramVersion.Type & 0xFF);
  PCVersionLabel->Caption = tmpWStr;

	if (HCBConnected)
	{
		HCBConnectLabel->Font->Color = clLime;
		HCBConnectLabel->Caption = "O";
	}
	else
	{
		HCBConnectLabel->Font->Color = clRed;
		HCBConnectLabel->Caption = "X";
	}

	if (HCBVersionValid)
	{
    HCBVersionLabel->Font->Color = clYellow;
    wsprintfW(tmpWStr, L"%d.%d.%d.%c", HCBVersion.MajorVersion, HCBVersion.MinorVersion, HCBVersion.Date, HCBVersion.Type & 0xFF);
    HCBVersionLabel->Caption = tmpWStr;
	}
	else
	{
		HCBVersionLabel->Font->Color = clRed;
		HCBVersionLabel->Caption = "UNKNOWN";
	}

  for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
	{
    TPanel *connectLabel = (TPanel *) FindComponent("SPBConnectLabel" + IntToStr(spbIndex + 1));
		TPanel *versionLabel = (TPanel *) FindComponent("SPBVersionLabel" + IntToStr(spbIndex + 1));
		TPanel *fpgaVersionLabel = (TPanel *) FindComponent("SPBFPGAVersionLabel" + IntToStr(spbIndex + 1));
		TPanel *cpbVersionLabel = (TPanel *) FindComponent("CPBVersionLabel" + IntToStr(spbIndex + 1));
    TPanel *SystemCompatibilityLabel = (TPanel *) FindComponent("SystemCompatibilityFromIPB" + IntToStr(spbIndex + 1));
    TTntLabel *IPBIDPanel = (TTntLabel *) FindComponent("IPBIDPanel" + IntToStr(spbIndex + 1));

    if(spbIndex < MachineSetupData.IPB_BoardCount)
    {
      connectLabel->Visible = true;
      versionLabel->Visible = true;
      fpgaVersionLabel->Visible = true;
      cpbVersionLabel->Visible = true;
      SystemCompatibilityLabel->Visible = true;
      IPBIDPanel->Visible = true;
    }
    else
    {
      connectLabel->Visible = false;
      versionLabel->Visible = false;
      fpgaVersionLabel->Visible = false;
      cpbVersionLabel->Visible = false;
      SystemCompatibilityLabel->Visible = false;
      IPBIDPanel->Visible = false;
    }
  }

	for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
	{
    TPanel *connectLabel = (TPanel *) FindComponent("SPBConnectLabel" + IntToStr(spbIndex + 1));
		TPanel *versionLabel = (TPanel *) FindComponent("SPBVersionLabel" + IntToStr(spbIndex + 1));
		TPanel *fpgaVersionLabel = (TPanel *) FindComponent("SPBFPGAVersionLabel" + IntToStr(spbIndex + 1));
		TPanel *cpbVersionLabel = (TPanel *) FindComponent("CPBVersionLabel" + IntToStr(spbIndex + 1));

		if (connectLabel)
		{
			if (SPBConnected[spbIndex])
			{
				connectLabel->Font->Color = clLime;
				connectLabel->Caption = "O";
			}
			else
			{
				connectLabel->Font->Color = clRed;
				connectLabel->Caption = "X";
			}
		}

		if (versionLabel)
		{
			if (SPBVersionValid[spbIndex])
			{
        versionLabel->Font->Color = clYellow;
        wsprintfW(tmpWStr, L"%d.%d.%d.%c", SPBVersion[spbIndex].MajorVersion, SPBVersion[spbIndex].MinorVersion, SPBVersion[spbIndex].Date, SPBVersion[spbIndex].Type & 0xFF);
        versionLabel->Caption = tmpWStr;
			}
			else
			{
				versionLabel->Font->Color = clRed;
				versionLabel->Caption = "UNKNOWN";
			}
		}
		if (fpgaVersionLabel)
		{
			if (SPBVersionValid[spbIndex])
			{
        fpgaVersionLabel->Font->Color = clYellow;
        wsprintfW(tmpWStr, L"%d.%d.%d", SPBFPGAVersion[spbIndex].VersionH & 0x0F, (SPBFPGAVersion[spbIndex].VersionL & 0xF0) >> 4, SPBFPGAVersion[spbIndex].VersionL & 0x0F);
        fpgaVersionLabel->Caption = tmpWStr;
			}
      else
      {
        fpgaVersionLabel->Font->Color = clRed;
        fpgaVersionLabel->Caption = "UNKNOWN";
      }
		}

		if (cpbVersionLabel)
		{
			if (SPBVersionValid[spbIndex])
			{
        cpbVersionLabel->Font->Color = clYellow;
        wsprintfW(tmpWStr, L"%d.%d.%d.%c", SPBCompatibility[spbIndex].CPBAlgMajorVersion, SPBCompatibility[spbIndex].CPBAlgMinorVersion, SPBCompatibility[spbIndex].CPBAlgReleaseDate, SPBCompatibility[spbIndex].CPBAlgTargetSystem & 0xFF);
        cpbVersionLabel->Caption = tmpWStr;
			}
			else
			{
        cpbVersionLabel->Font->Color = clRed;
        cpbVersionLabel->Caption = "UNKNOWN";
			}
		}
	}

  if(TPBSystemInfo.boardExist)
  {
		if (TPBConnectLabel)
		{
			if (TPBConnected)
			{
				TPBConnectLabel->Font->Color = clLime;
				TPBConnectLabel->Caption = "O";
			}
			else
			{
				TPBConnectLabel->Font->Color = clRed;
				TPBConnectLabel->Caption = "X";
			}
		}

		if (TPBVersionLabel)
		{
			if (TPBVersionValid)
			{
				TPBVersionLabel->Font->Color = clYellow;
				wsprintfW(tmpWStr, L"%d.%d.%d.%c", TPBVersion.MajorVersion, TPBVersion.MinorVersion, TPBVersion.Date, TPBVersion.Type & 0xFF);
				TPBVersionLabel->Caption = tmpWStr;
			}
			else
			{
				TPBVersionLabel->Font->Color = clRed;
				TPBVersionLabel->Caption = "UNKNOWN";
			}
		}
		
		if (TPB_FPGAVersionLabel)
		{
			if (TPB_FPGAVersionValid)
			{
				TPB_FPGAVersionLabel->Font->Color = clYellow;
				wsprintfW(tmpWStr, L"%d.%d.%d", TPBFPGAVersion.VersionH & 0x0F, (TPBFPGAVersion.VersionL & 0xF0) >> 4, TPBFPGAVersion.VersionL & 0x0F);
				TPB_FPGAVersionLabel->Caption = tmpWStr;
			}
			else
			{
				TPB_FPGAVersionLabel->Font->Color = clRed;
				TPB_FPGAVersionLabel->Caption = "UNKNOWN";
			}
		}

		if (CPBVersionLabelTPB)
		{
			if (TPB_CPBVersionValid)
			{
				CPBVersionLabelTPB->Font->Color = clYellow;
				wsprintfW(tmpWStr, L"%d.%d.%d.%c", TPBCompatibility.CPBAlgMajorVersion, TPBCompatibility.CPBAlgMinorVersion, TPBCompatibility.CPBAlgReleaseDate, TPBCompatibility.CPBAlgTargetSystem & 0xFF);
				CPBVersionLabelTPB->Caption = tmpWStr;
			}
			else
			{
				CPBVersionLabelTPB->Font->Color = clRed;
				CPBVersionLabelTPB->Caption = "UNKNOWN";
			}
		}
  }
  else
  {
    TPBIDPanel->Visible = false;
    TPBConnectLabel->Visible = false;
    TPBVersionLabel->Visible = false;
    TPB_FPGAVersionLabel->Visible = false;
    CPBVersionLabelTPB->Visible = false;
    SystemCompatibilityFromTPB->Visible = false;
  }

  CheckSystemCompatibility();
}
//---------------------------------------------------------------------------
void __fastcall TSystemInfoForm::CheckSystemCompatibility(void)
{
  // ȣȯ üũ
  AnsiString result;

  result = "Good";
  if(result == "Good")
  {
    if (HCBConnected)
    {
      if((ProgramVersion.MajorVersion != HCBVersion.MajorVersion) ||
          (ProgramVersion.MinorVersion != HCBVersion.MinorVersion) ||
          (ProgramVersion.Date != HCBVersion.Date) ||
          (ProgramVersion.Type != HCBVersion.Type))
      {
        result = "Invalid PC - HCB";
      }
    }
  }

  if(result == "Good")
  {
    for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
    {
      if (SPBConnected[spbIndex])
      {
        if((ProgramVersion.MajorVersion != SPBVersion[spbIndex].MajorVersion) ||
              (ProgramVersion.MinorVersion != SPBVersion[spbIndex].MinorVersion) ||
              (ProgramVersion.Date != SPBVersion[spbIndex].Date) ||
              (ProgramVersion.Type != SPBVersion[spbIndex].Type))
        {
          result = "Invalid PC - IPB" + IntToStr(spbIndex + 1);
          break;
        }
      }
    }
  }

  if(result == "Good")
  {
    for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
    {
      if (SPBConnected[spbIndex])
      {
          if((ProgramVersion.MajorVersion != SPBCompatibility[spbIndex].CPBAlgMajorVersion) ||
              (ProgramVersion.MinorVersion != SPBCompatibility[spbIndex].CPBAlgMinorVersion) ||
              (ProgramVersion.Date != SPBCompatibility[spbIndex].CPBAlgReleaseDate) ||
              (ProgramVersion.Type != SPBCompatibility[spbIndex].CPBAlgTargetSystem))
        {
          result = "Invalid PC - CPB(IPB" + IntToStr(spbIndex + 1) + ")";
          break;
        }
      }
    }
  }

  if(result == "Good")
  {
      if (TPBConnected)
      {
        if((ProgramVersion.MajorVersion != TPBVersion.MajorVersion) ||
              (ProgramVersion.MinorVersion != TPBVersion.MinorVersion) ||
              (ProgramVersion.Date != TPBVersion.Date) ||
              (ProgramVersion.Type != TPBVersion.Type))
        {
          result = "Invalid PC - TPB";
        }
      }
  }

  if(result == "Good")
  {
      if (TPBConnected)
      {
          if((ProgramVersion.MajorVersion != TPBCompatibility.CPBAlgMajorVersion) ||
              (ProgramVersion.MinorVersion != TPBCompatibility.CPBAlgMinorVersion) ||
              (ProgramVersion.Date != TPBCompatibility.CPBAlgReleaseDate) ||
              (ProgramVersion.Type != TPBCompatibility.CPBAlgTargetSystem))
        {
          result = "Invalid PC - CPB(TPB)";
        }
      }
  }

  if(result == "Good")
  {
    SystemCompatibilityFromPC->Font->Color = clLime;
  }
  else if(result == "UNKNOWN")
  {
    SystemCompatibilityFromPC->Font->Color = clRed;
  }
  else
  {
    SystemCompatibilityFromPC->Font->Color = clYellow;
  }
  SystemCompatibilityFromPC->Caption = result;

  result = "Good";
  if (!HCBConnected)
  {
    result = "UNKNOWN";
  }

  if(result == "Good")
  {
    if (HCBConnected)
    {
      if((ProgramVersion.MajorVersion != HCBVersion.MajorVersion) ||
          (ProgramVersion.MinorVersion != HCBVersion.MinorVersion) ||
          (ProgramVersion.Date != HCBVersion.Date) ||
          (ProgramVersion.Type != HCBVersion.Type))
      {
        result = "Invalid HCB - PC";
      }
    }
  }

  if(result == "Good")
  {
    for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
    {
      if (SPBConnected[spbIndex] && HCBConnected)
      {
        if((HCBVersion.MajorVersion != SPBVersion[spbIndex].MajorVersion) ||
            (HCBVersion.MinorVersion != SPBVersion[spbIndex].MinorVersion) ||
            (HCBVersion.Date != SPBVersion[spbIndex].Date) ||
            (HCBVersion.Type != SPBVersion[spbIndex].Type))
        {
          result = "Invalid HCB - IPB" + IntToStr(spbIndex + 1);
          break;
        }
      }
    }
  }

  if(result == "Good")
  {
      if (TPBConnected && HCBConnected)
      {
        if((HCBVersion.MajorVersion != TPBVersion.MajorVersion) ||
            (HCBVersion.MinorVersion != TPBVersion.MinorVersion) ||
            (HCBVersion.Date != TPBVersion.Date) ||
            (HCBVersion.Type != TPBVersion.Type))
        {
          result = "Invalid HCB - TPB";
        }
      }
  }

  if(result == "Good")
  {
    SystemCompatibilityFromHCB->Font->Color = clLime;
  }
  else if(result == "UNKNOWN")
  {
    SystemCompatibilityFromHCB->Font->Color = clRed;
  }
  else
  {
    SystemCompatibilityFromHCB->Font->Color = clYellow;
  }
  SystemCompatibilityFromHCB->Caption = result;

  for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
  {
    TPanel *SystemCompatibilityFromIPB = (TPanel *) FindComponent("SystemCompatibilityFromIPB" + IntToStr(spbIndex + 1));
    if(SystemCompatibilityFromIPB)
    {
      result = "Good";
      if (!SPBConnected[spbIndex])
      {
        result = "UNKNOWN";
      }

      if(result == "Good")
      {
        if((ProgramVersion.MajorVersion != SPBVersion[spbIndex].MajorVersion) ||
            (ProgramVersion.MinorVersion != SPBVersion[spbIndex].MinorVersion) ||
            (ProgramVersion.Date != SPBVersion[spbIndex].Date) ||
            (ProgramVersion.Type != SPBVersion[spbIndex].Type))
        {
          result = "Invalid IPB - PC";
        }
      }

      if(result == "Good")
      {
        if(HCBConnected)
        {
          if((SPBVersion[spbIndex].MajorVersion != HCBVersion.MajorVersion) ||
              (SPBVersion[spbIndex].MinorVersion != HCBVersion.MinorVersion) ||
              (SPBVersion[spbIndex].Date != HCBVersion.Date) ||
              (SPBVersion[spbIndex].Type != HCBVersion.Type))
          {
            result = "Invalid IPB - HCB";
          }
        }
      }

      if(result == "Good")
      {
        if((SPBVersion[spbIndex].MajorVersion != SPBCompatibility[spbIndex].CPBAlgMajorVersion) ||
            (SPBVersion[spbIndex].MinorVersion != SPBCompatibility[spbIndex].CPBAlgMinorVersion) ||
            (SPBVersion[spbIndex].Date != SPBCompatibility[spbIndex].CPBAlgReleaseDate) ||
            (SPBVersion[spbIndex].Type != SPBCompatibility[spbIndex].CPBAlgTargetSystem))
        {
          result = "Invalid IPB - CPB";
        }
      }

      if(result == "Good")
      {
        SystemCompatibilityFromIPB->Font->Color = clLime;
      }
      else if(result == "UNKNOWN")
      {
        SystemCompatibilityFromIPB->Font->Color = clRed;
      }
      else
      {
        SystemCompatibilityFromIPB->Font->Color = clYellow;
      }
      SystemCompatibilityFromIPB->Caption = result;
    }
  }



    if(SystemCompatibilityFromTPB)
    {
      result = "Good";
      if (!TPBConnected)
      {
        result = "UNKNOWN";
      }

      if(result == "Good")
      {
        if((ProgramVersion.MajorVersion != TPBVersion.MajorVersion) ||
            (ProgramVersion.MinorVersion != TPBVersion.MinorVersion) ||
            (ProgramVersion.Date != TPBVersion.Date) ||
            (ProgramVersion.Type != TPBVersion.Type))
        {
          result = "Invalid TPB - PC";
        }
      }

      if(result == "Good")
      {
        if(HCBConnected)
        {
          if((TPBVersion.MajorVersion != HCBVersion.MajorVersion) ||
              (TPBVersion.MinorVersion != HCBVersion.MinorVersion) ||
              (TPBVersion.Date != HCBVersion.Date) ||
              (TPBVersion.Type != HCBVersion.Type))
          {
            result = "Invalid TPB - HCB";
          }
        }
      }

      if(result == "Good")
      {
        if((TPBVersion.MajorVersion != TPBCompatibility.CPBAlgMajorVersion) ||
            (TPBVersion.MinorVersion != TPBCompatibility.CPBAlgMinorVersion) ||
            (TPBVersion.Date != TPBCompatibility.CPBAlgReleaseDate) ||
            (TPBVersion.Type != TPBCompatibility.CPBAlgTargetSystem))
        {
          result = "Invalid TPB - CPB";
        }
      }

      if(result == "Good")
      {
        SystemCompatibilityFromTPB->Font->Color = clLime;
      }
      else if(result == "UNKNOWN")
      {
        SystemCompatibilityFromTPB->Font->Color = clRed;
      }
      else
      {
        SystemCompatibilityFromTPB->Font->Color = clYellow;
      }
      SystemCompatibilityFromTPB->Caption = result;
    }
}



