//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "SystemMonitor_Form.h"
#include "Environment.h"
#include "Keyboard_Form.h"
#include "CalendarDialog_Form.h"
#include "Message_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TSystemMonitorForm *SystemMonitorForm;
//---------------------------------------------------------------------------
__fastcall TSystemMonitorForm::TSystemMonitorForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  PressureChart->Title->Text->Strings[0] = SYSTEMMONITORFORM_LABEL_CAPTION_17;
  PressureChart->BottomAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_20;
  PressureChart->LeftAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_17;

  SavedPressureChart->Title->Text->Strings[0] = SYSTEMMONITORFORM_LABEL_CAPTION_17;
  SavedPressureChart->BottomAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_20;
  SavedPressureChart->LeftAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_17;

  ThermometerChart->Title->Text->Strings[0] = SYSTEMMONITORFORM_GROUPBOX_CAPTION_03;
  ThermometerChart->BottomAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_20;
  ThermometerChart->LeftAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_18;
  ThermometerChart->RightAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_19;

  SavedThermometerChart->Title->Text->Strings[0] = SYSTEMMONITORFORM_GROUPBOX_CAPTION_03;
  SavedThermometerChart->BottomAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_20;
  SavedThermometerChart->LeftAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_18;
  SavedThermometerChart->RightAxis->Title->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_19;

  MonitorUnitSelectionPanel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_07;
  SavedMonitorUnitSelectionPanel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_07;
  MonitorUnitSelectionPanel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_08;
  SavedMonitorUnitSelectionPanel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_08;

  GetDefaultString();

	for (int unitIndex = 0; unitIndex < RS485_UNIT_COUNT; unitIndex++)
	{
		LastCommTime[unitIndex] = Now();
		CommStatus[unitIndex] = COMM_STATUS_IDLE;
	}
//	CurrentCommUnitIndex = 0;
	ComAddress[0] = 1;
	ComAddress[1] = 2;
	ComAddress[2] = 3;
	ComAddress[3] = 4;
	ComAddress[4] = 5;
	ComAddress[5] = 6;
	ComAddress[6] = 10;
	ComAddress[7] = 11;

	CurrentMonitorUnitIndex = 0;
	CurrentSavedMonitorUnitIndex = 0;
	LastRecordedTime = Now();

	unsigned short year, month, day;
	Now().DecodeDate(&year, &month, &day);
	ReadYearEdit->Text = IntToStr(year);
	ReadMonthEdit->Text = IntToStr(month);
	ReadDayEdit->Text = IntToStr(day);

	SystemMonitorInfo.CurrentTemperature[0] = 0;
	SystemMonitorInfo.CurrentHumidity[0] = 0;
	SystemMonitorInfo.CurrentTemperature[1] = 0;
	SystemMonitorInfo.CurrentHumidity[1] = 0;
	SystemMonitorInfo.CurrentTemperature[2] = 0;
	SystemMonitorInfo.CurrentHumidity[2] = 0;
	SystemMonitorInfo.InverterSpeed[0] = 0;
	SystemMonitorInfo.InverterSpeed[1] = 0;
  SystemMonitorInfo.InverterSpeed[2] = 0;
	SystemMonitorInfo.Pressure[0] = 0;
	SystemMonitorInfo.Pressure[1] = 0;
	SystemMonitorInfo.Pressure[2] = 0;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    TntLabel3->Visible = true;
    InverterRPMLabel3->Visible = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::GetDefaultString()
{
  CloseButton->Caption = SYSTEMMONITORFORM_BUTTON_CAPTION_01;
  CalendarSelectionButton->Caption = SYSTEMMONITORFORM_BUTTON_CAPTION_02;
  ReadSavedDataButton->Caption = SYSTEMMONITORFORM_BUTTON_CAPTION_03;
  this->Caption = SYSTEMMONITORFORM_FORM_CAPTION_01;
  GroupBox4->Caption = SYSTEMMONITORFORM_GROUPBOX_CAPTION_01;
  GroupBox3->Caption = SYSTEMMONITORFORM_GROUPBOX_CAPTION_02;
  GroupBox1->Caption = SYSTEMMONITORFORM_GROUPBOX_CAPTION_03;
  GroupBox2->Caption = SYSTEMMONITORFORM_GROUPBOX_CAPTION_04;
  Label4->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_01;
  TemperatueLabel1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  HumidityLabel1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  TemperatueLabel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  HumidityLabel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  TemperatueLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  HumidityLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  InverterRPMLabel1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  InverterRPMLabel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  InverterRPMLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureLabel1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureHPLabel1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureLPLabel1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureLabel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureHPLabel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureLPLabel2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureHPLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  PressureLPLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_02;
  Label3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_03;
  Label7->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_04;
  Label11->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_05;
  Label1->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_06;
  Label5->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_07;
  Label9->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_08;
  Label6->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_09;
  Label13->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_10;
  Label14->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_11;
  TntLabel3->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_16;
  Label8->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_12;
  Label2->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_13;
  Label17->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_15;
  MonitorUnitSelectionPanel4->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_01;
  SavedMonitorUnitSelectionPanel4->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_01;
  Label15->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_01;
  MonitorUnitSelectionPanel1->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_02;
  SavedMonitorUnitSelectionPanel1->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_02;
  //MonitorUnitSelectionPanel2->Cption = SYSTEMMONITORFORM_PANEL_CAPTION_03;
  //SavedMonitorUnitSelectionPanel2->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_03;
  //MonitorUnitSelectionPanel3->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_04;
  //SavedMonitorUnitSelectionPanel3->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_04;
  MonitorUnitSelectionPanel5->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_05;
  SavedMonitorUnitSelectionPanel5->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_05;
  Label10->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_05;
  MonitorUnitSelectionPanel6->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_06;
  SavedMonitorUnitSelectionPanel6->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_06;
  Label27->Caption = SYSTEMMONITORFORM_PANEL_CAPTION_06;

  //add
  Label22->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_15;
  Label29->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_15;

  GroupBox5->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_17;

  Label18->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_24;
  Label23->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_24;
  Label30->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_24;

  Label19->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_25;
  Label24->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_25;
  Label31->Caption = SYSTEMMONITORFORM_LABEL_CAPTION_25;
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::CommTimerTimer(TObject *Sender)
{
  if(!bSystemStatusCheckSW) return;
  
	CommTimer->Enabled = false;
/*
	struct
	{
		int RXStatus;
		int RXLength;
		int TXStatus;
		int TXLength;
	} rs485StatusData;

	if (CommStatus[CurrentCommUnitIndex] == COMM_STATUS_IDLE)
	{
		unsigned short elapsedHour, elapsedMin, elaspsedSec, elaspsedMSec;
		(Now() - LastCommTime[CurrentCommUnitIndex]).DecodeTime(&elapsedHour, &elapsedMin, &elaspsedSec, &elaspsedMSec);

		if (elapsedMin > 0 || elaspsedSec > 5)
		{
			Comm_Request(COMM_HCB, CMD_RS485_STATUS, NULL, 0, &rs485StatusData, sizeof(rs485StatusData));
			if (rs485StatusData.TXStatus == RS485_TX_STATUS_READY)
			{
				MakeTXData();
				Comm_Request(COMM_HCB, CMD_RS485_TEST, TXData, TXLength);
				CommStatus[CurrentCommUnitIndex] = COMM_STATUS_POLLING;
			}
		}
		else
		{
			CurrentCommUnitIndex++;
			if (CurrentCommUnitIndex >= RS485_UNIT_COUNT)
			{
				CurrentCommUnitIndex = 0;
			}
		}
	}
	else if (CommStatus[CurrentCommUnitIndex] == COMM_STATUS_POLLING)
	{
		Comm_Request(COMM_HCB, CMD_RS485_STATUS, NULL, 0, &rs485StatusData, sizeof(rs485StatusData));
		if (rs485StatusData.RXStatus == RS485_RX_STATUS_RECEIVED)
		{
			RXLength = rs485StatusData.RXLength;

			Comm_Request(COMM_HCB, CMD_RS485_RX_DATA, NULL, 0, RXData, 128);
			if (DecodePacket())
			{
				LastCommTime[CurrentCommUnitIndex] = Now();
			}
			CommStatus[CurrentCommUnitIndex] = COMM_STATUS_IDLE;
			CurrentCommUnitIndex++;
			if (CurrentCommUnitIndex >= RS485_UNIT_COUNT)
			{
				CurrentCommUnitIndex = 0;
			}
		}
	}
*/
	TMonitoringInfo monitoringInfo;

	if (Comm_Request(COMM_HCB, CMD_MONITORING_DATA, NULL, 0, &monitoringInfo, sizeof(TMonitoringInfo)))
	{
		for (int thermometerIndex = 0; thermometerIndex < SYSTEM_MAX_THERMOMETER_COUNT; thermometerIndex++)
		{
			TTntLabel *temperatureLabel = (TTntLabel *) FindComponent("TemperatueLabel" + IntToStr(thermometerIndex + 1));
			TTntLabel *humidityLabel = (TTntLabel *) FindComponent("HumidityLabel" + IntToStr(thermometerIndex + 1));
			if (temperatureLabel)
			{
				temperatureLabel->Caption = FloatToStr(monitoringInfo.TemperatureData[thermometerIndex] / 100.0) + "";
			}
			if (humidityLabel)
			{
				humidityLabel->Caption = FloatToStr(monitoringInfo.HumidityData[thermometerIndex] / 100.0) + "%Rh";
			}

			unsigned short currentHour, currentMin, currentSec, currentMSec;
			Now().DecodeTime(&currentHour, &currentMin, &currentSec, &currentMSec);

			TemperatureData[thermometerIndex][currentHour * 60 + currentMin] = monitoringInfo.TemperatureData[thermometerIndex];
			HumidityData[thermometerIndex][currentHour * 60 + currentMin] = monitoringInfo.HumidityData[thermometerIndex];

				SystemMonitorInfo.CurrentTemperature[thermometerIndex] = monitoringInfo.TemperatureData[thermometerIndex];
			SystemMonitorInfo.CurrentHumidity[thermometerIndex] = monitoringInfo.HumidityData[thermometerIndex];
		}
		for (int pressureMeterIndex = 0; pressureMeterIndex < SYSTEM_MAX_PRESSURE_METER_COUNT; pressureMeterIndex++)
		{
			short pressure = monitoringInfo.Pressure[pressureMeterIndex];
			short dotPos = monitoringInfo.DotPos[pressureMeterIndex];
			double realPressure;
			TTntLabel *pressureLabel = (TTntLabel *) FindComponent("PressureLabel" + IntToStr(pressureMeterIndex + 1));
			if (dotPos >= 0 && dotPos < 10)
			{
				realPressure = pressure / pow(10, dotPos);
			}
			else
			{
				realPressure = 0;
			}
			if (pressureLabel)
			{
				pressureLabel->Caption = FloatToStr(realPressure) + "kPa";
			}

			unsigned short currentHour, currentMin, currentSec, currentMSec;
			Now().DecodeTime(&currentHour, &currentMin, &currentSec, &currentMSec);

			PressureData[pressureMeterIndex][currentHour * 60 + currentMin] = monitoringInfo.Pressure[pressureMeterIndex];

			SystemMonitorInfo.Pressure[pressureMeterIndex] = realPressure;
		}
		for (int inverterIndex = 0; inverterIndex < SYSTEM_MAX_INVERTER_COUNT; inverterIndex++)
		{
			short rpm = monitoringInfo.InverterRPM[inverterIndex];
			TTntLabel *inverterRPMLabel = (TTntLabel *) FindComponent("InverterRPMLabel" + IntToStr(inverterIndex + 1));
			if (inverterRPMLabel)
			{
				inverterRPMLabel->Caption = FloatToStr((rpm / 3) / 10.0) + "HZ";
			}
			SystemMonitorInfo.InverterSpeed[inverterIndex] = rpm;
		}


		unsigned short elapsedHour, elapsedMin, elaspsedSec, elaspsedMSec;
		(Now() - LastRecordedTime).DecodeTime(&elapsedHour, &elapsedMin, &elaspsedSec, &elaspsedMSec);
		if (elapsedMin > 0)
		{
			RecordThermoMeterData();
			LastRecordedTime = Now();
			ApplyChart();
		}
	}

	CommTimer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::MakeTXData(void)
{
/*
	TXLength = 0;
	if (CurrentCommUnitIndex < 3)		// /
	{
		TXLength = 8;
		TXData[0] = ComAddress[CurrentCommUnitIndex];
		TXData[1] = 4;
		TXData[2] = 0;
		TXData[3] = 0;
		TXData[4] = 0;
		TXData[5] = 2;
		unsigned short crc16 = Generate_CRC16(TXData, 6);
		TXData[6] = (crc16 >> 8) & 0xFF;
		TXData[7] = crc16 & 0xFF;
	}
	else if (CurrentCommUnitIndex < 6)		// ǳڸŸ
	{
		TXLength = 8;
		TXData[0] = ComAddress[CurrentCommUnitIndex];
		TXData[1] = 4;
		TXData[2] = 0;
		TXData[3] = 0;
		TXData[4] = 0;
		TXData[5] = 4;
		unsigned short crc16 = Generate_CRC16(TXData, 6);
		TXData[6] = (crc16 >> 8) & 0xFF;
		TXData[7] = crc16 & 0xFF;
	}
	else	// ι
	{
		TXLength = 8;
		TXData[0] = ComAddress[CurrentCommUnitIndex];
		TXData[1] = 4;
		TXData[2] = 0xA1;
		TXData[3] = 0x08;
		TXData[4] = 0x00;
		TXData[5] = 0x01;
		unsigned short crc16 = Generate_CRC16(TXData, 6);
		TXData[6] = (crc16 >> 8) & 0xFF;
		TXData[7] = crc16 & 0xFF;
	}
*/	
}
//---------------------------------------------------------------------------
bool __fastcall TSystemMonitorForm::DecodePacket(void)
{
/*
	bool bValidPacket = false;
	if (RXLength > 2 && RXLength < 128)
	{
		int DataCount = RXData[2];
		if (DataCount > 123) return false;
		int ValidDataLength = DataCount + 3 + 2;
		unsigned short crc16 = Generate_CRC16(RXData, ValidDataLength - 2);
		if ((RXData[ValidDataLength - 2] == ((crc16 >> 8) & 0xFF)) && (RXData[ValidDataLength - 1] == ((crc16 >> 0) & 0xFF)))
		{
			if (ComAddress[CurrentCommUnitIndex] == RXData[0])
			{
				bValidPacket = true;
				if (CurrentCommUnitIndex < 3)		// /
				{
					int temperature = (int)RXData[3] * 256 + (int) RXData[4];
					int humidity = (int)RXData[5] * 256 + (int) RXData[6];
					TTntLabel *temperatureLabel = (TTntLabel *) FindComponent("TemperatueLabel" + IntToStr(CurrentCommUnitIndex + 1));
					TTntLabel *humidityLabel = (TTntLabel *) FindComponent("HumidityLabel" + IntToStr(CurrentCommUnitIndex + 1));
					if (temperatureLabel)
					{
						temperatureLabel->Caption = FloatToStr(temperature / 100.0) + "";
					}
					if (humidityLabel)
					{
						humidityLabel->Caption = FloatToStr(humidity / 100.0) + "%Rh";
					}

					unsigned short currentHour, currentMin, currentSec, currentMSec;
					Now().DecodeTime(&currentHour, &currentMin, &currentSec, &currentMSec);

					TemperatureData[CurrentCommUnitIndex - 0][currentHour * 60 + currentMin] = temperature;
					HumidityData[CurrentCommUnitIndex - 0][currentHour * 60 + currentMin] = humidity;

					SystemMonitorInfo.CurrentTemperature[CurrentCommUnitIndex - 0] = temperature;
					SystemMonitorInfo.CurrentHumidity[CurrentCommUnitIndex - 0] = humidity;
				}
				else if (CurrentCommUnitIndex < 6)		// ǳڸŸ
				{
					short pressure = (int)RXData[3] * 256 + (int)RXData[4];
					//int dotPos = (int)RXData[5] * 256 + (int) RXData[6];
					int dotPos = (int)RXData[6];
					int hiPeak = (int)RXData[7] * 256 + (int)RXData[8];
					int loPeak = (int)RXData[9] * 256 + (int)RXData[10];
					TTntLabel *pressureLabel = (TTntLabel *) FindComponent("PressureLabel" + IntToStr(CurrentCommUnitIndex - 2));
					if (pressureLabel)
					{
						pressureLabel->Caption = FloatToStr(pressure / pow(10, dotPos)) + "kPa";
					}
					TTntLabel *pressureHPLabel = (TTntLabel *) FindComponent("PressureHPLabel" + IntToStr(CurrentCommUnitIndex - 2));
					if (pressureHPLabel)
					{
						pressureHPLabel->Caption = FloatToStr(hiPeak / pow(10, dotPos)) + "kPa";
					}
					TTntLabel *pressureLPLabel = (TTntLabel *) FindComponent("PressureLPLabel" + IntToStr(CurrentCommUnitIndex - 2));
					if (pressureLPLabel)
					{
						pressureLPLabel->Caption = FloatToStr(loPeak / pow(10, dotPos)) + "kPa";
					}
					SystemMonitorInfo.Pressure[CurrentCommUnitIndex - 3] = pressure / pow(10, dotPos);
				}
				else	// ι
				{
					int rpm = (int)RXData[3] * 256 + (int) RXData[4];
					TTntLabel *inverterRPMLabel = (TTntLabel *) FindComponent("InverterRPMLabel" + IntToStr(CurrentCommUnitIndex - 5));
					if (inverterRPMLabel)
					{
						inverterRPMLabel->Caption = FloatToStr((rpm / 3) / 10.0) + "HZ";
					}
					SystemMonitorInfo.InverterSpeed[CurrentCommUnitIndex - 6] = rpm;
				}
			}
		}
	}

	return bValidPacket;
*/	
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::FormCreate(TObject *Sender)
{
	unsigned short year, month, day;
	AnsiString monitorLogFolderName = ProgramPath.Log + "\\Monitoring Log";
	if (!DirectoryExists(monitorLogFolderName)) ForceDirectories(monitorLogFolderName);
	Now().DecodeDate(&year, &month, &day);
	CurrentYear = year;
	CurrentMonth = month;
	CurrentDay = day;
	AnsiString temperatureDataFileName = monitorLogFolderName + temperatureDataFileName.sprintf("\\%04d-%02d-%02d.tpr", CurrentYear, CurrentMonth, CurrentDay);
	if (!FileExists(temperatureDataFileName))
	{
		for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
		{
			memset(TemperatureData[thermoUnitIndex], 0, 24 * 60 * sizeof(unsigned short));
		}
	}
	else
	{
		TFileStream *aFileStream = new TFileStream(temperatureDataFileName, fmOpenRead);
		if (aFileStream)
		{
			for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
			{
				aFileStream->Read(TemperatureData[thermoUnitIndex], 24 * 60 * sizeof(unsigned short));
			}
			delete aFileStream;
		}
	}

	AnsiString humidityDataFileName = monitorLogFolderName + temperatureDataFileName.sprintf("\\%04d-%02d-%02d.hmd", CurrentYear, CurrentMonth, CurrentDay);
	if (!FileExists(humidityDataFileName))
	{
		for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
		{
			memset(HumidityData[thermoUnitIndex], 0, 24 * 60 * sizeof(unsigned short));
		}
	}
	else
	{
		TFileStream *aFileStream = new TFileStream(humidityDataFileName, fmOpenRead);
		if (aFileStream)
		{
			for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
			{
				aFileStream->Read(HumidityData[thermoUnitIndex], 24 * 60 * sizeof(unsigned short));
			}
			delete aFileStream;
		}
	}

	AnsiString pressureDataFileName = monitorLogFolderName + temperatureDataFileName.sprintf("\\%04d-%02d-%02d.psr", CurrentYear, CurrentMonth, CurrentDay);
	if (!FileExists(pressureDataFileName))
	{
		for (int pressureUnitIndex = 0; pressureUnitIndex < PANELMETER_UNIT_COUNT; pressureUnitIndex++)
		{
			memset(PressureData[pressureUnitIndex], 0, 24 * 60 * sizeof(unsigned short));
		}
	}
	else
	{
		TFileStream *aFileStream = new TFileStream(pressureDataFileName, fmOpenRead);
		if (aFileStream)
		{
			for (int pressureUnitIndex = 0; pressureUnitIndex < PANELMETER_UNIT_COUNT; pressureUnitIndex++)
			{
				aFileStream->Read(PressureData[pressureUnitIndex], 24 * 60 * sizeof(unsigned short));
			}
			delete aFileStream;
		}
	}

	ApplyChart();
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::ApplyChart(void)
{
	double chartList[24 * 60 / 5 + 1];
	if (CurrentMonitorUnitIndex < THERMOMETER_UNIT_COUNT)
	{
		ThermometerChart->Series[0]->Clear();
		ThermometerChart->Series[1]->Clear();
		for (int listIndex = 0; listIndex < 24 * 60 / 5; listIndex++)
		{
			chartList[listIndex] = TemperatureData[CurrentMonitorUnitIndex - 0][listIndex * 5] / 100.0;
		}
		chartList[24 * 60 / 5] = 0;
		ThermometerChart->Series[0]->AddArray(chartList, 24 * 60 / 5);
		for (int listIndex = 0; listIndex < 24 * 60 / 5; listIndex++)
		{
			chartList[listIndex] = HumidityData[CurrentMonitorUnitIndex - 0][listIndex * 5] / 100.0;
		}
		chartList[24 * 60 / 5] = 0;
		ThermometerChart->Series[1]->AddArray(chartList, 24 * 60 / 5);
	}
	else
	{
		PressureChart->Series[0]->Clear();
		for (int listIndex = 0; listIndex < 24 * 60 / 5; listIndex++)
		{
			chartList[listIndex] = PressureData[CurrentMonitorUnitIndex - THERMOMETER_UNIT_COUNT][listIndex * 5] / 10.0;
		}
		chartList[24 * 60 / 5] = 0;
		PressureChart->Series[0]->AddArray(chartList, 24 * 60 / 5);
	}
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::MonitorUnitSelectionPanelClick(TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *) Sender;
	CurrentMonitorUnitIndex = thePanel->Tag;
	for (int unitIndex = 0; unitIndex < RECODING_UNIT_COUNT; unitIndex++)
	{
		TTntPanel *aPanel = (TTntPanel *) FindComponent("MonitorUnitSelectionPanel" + IntToStr(unitIndex + 1));
		if (aPanel)
		{
			if (unitIndex == CurrentMonitorUnitIndex)
			{
				aPanel->Color = clBlue;
			}
			else
			{
				aPanel->Color = clBlack;
			}
		}
	}

	if (CurrentMonitorUnitIndex < THERMOMETER_UNIT_COUNT)
	{
		ThermometerChart->Visible = true;
		PressureChart->Visible = false;
	}
	else
	{
		PressureChart->Visible = true;
		ThermometerChart->Visible = false;
	}

	ApplyChart();
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::RecordThermoMeterData(void)
{
	unsigned short year, month, day;
	AnsiString monitorLogFolderName = ProgramPath.Log + "\\Monitoring Log";
	Now().DecodeDate(&year, &month, &day);
	if (year != CurrentYear || month != CurrentMonth || day != CurrentDay)		// if a day passed
	{
		CurrentYear = year;
		CurrentMonth = month;
		CurrentDay = day;
		for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
		{
			memset(HumidityData[thermoUnitIndex], 0, 60 * 24 * sizeof(unsigned short));
			memset(TemperatureData[thermoUnitIndex], 0, 60 * 24 * sizeof(unsigned short));
		}
		for (int pressureUnitIndex = 0; pressureUnitIndex < PANELMETER_UNIT_COUNT; pressureUnitIndex++)
		{
			memset(PressureData[pressureUnitIndex], 0, 24 * 60 * sizeof(unsigned short));
		}		
	}
	else
	{
		AnsiString temperatureDataFileName = monitorLogFolderName + temperatureDataFileName.sprintf("\\%04d-%02d-%02d.tpr", CurrentYear, CurrentMonth, CurrentDay);
		//AnsiString temperatureDataFileName = monitorLogFolderName +  "\\" + IntToStr(CurrentYear) + "-" + IntToStr(CurrentMonth) + "-" + IntToStr(CurrentDay) + ".tpr";
		TFileStream *temperatureFileStream = new TFileStream(temperatureDataFileName, fmCreate);
		if (temperatureFileStream)
		{
			for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
			{
				temperatureFileStream->Write(TemperatureData[thermoUnitIndex], 60 * 24 * sizeof(unsigned short));
			}
			delete temperatureFileStream;
		}
//		AnsiString humidityDataFileName = monitorLogFolderName +  "\\" + IntToStr(CurrentYear) + "-" + IntToStr(CurrentMonth) + "-" + IntToStr(CurrentDay) + ".hmd";
		AnsiString humidityDataFileName = monitorLogFolderName + humidityDataFileName.sprintf("\\%04d-%02d-%02d.hmd", CurrentYear, CurrentMonth, CurrentDay);
		TFileStream *humidityFileStream = new TFileStream(humidityDataFileName, fmCreate);
		if (humidityFileStream)
		{
			for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
			{
				humidityFileStream->Write(HumidityData[thermoUnitIndex], 60 * 24 * sizeof(unsigned short));
			}
			delete humidityFileStream;
		}

		AnsiString pressureDataFileName = monitorLogFolderName + pressureDataFileName.sprintf("\\%04d-%02d-%02d.psr", CurrentYear, CurrentMonth, CurrentDay);
		TFileStream *pressureFileStream = new TFileStream(pressureDataFileName, fmCreate);
		if (pressureFileStream)
		{
			for (int pressureUnitIndex = 0; pressureUnitIndex < PANELMETER_UNIT_COUNT; pressureUnitIndex++)
			{
				pressureFileStream->Write(PressureData[pressureUnitIndex], 24 * 60 * sizeof(unsigned short));
			}
			delete pressureFileStream;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

void __fastcall TSystemMonitorForm::CalendarSelectionButtonClick(
      TObject *Sender)
{
	TDateTime browseTime;
	unsigned short year, month, day;

	TCalendarDialogForm *calendarDialogForm = new TCalendarDialogForm(this);
	if (mrOk == calendarDialogForm->ShowModal())
	{
		browseTime = calendarDialogForm->MonthCalendar->Date;
		browseTime.DecodeDate(&year, &month, &day);
		ReadYearEdit->Text = IntToStr(year);
		ReadMonthEdit->Text = IntToStr(month);
		ReadDayEdit->Text = IntToStr(day);
	}
	delete calendarDialogForm;
}
//---------------------------------------------------------------------------

void __fastcall TSystemMonitorForm::ReadSavedDataButtonClick(
      TObject *Sender)
{
	unsigned short year, month, day;
	AnsiString monitorLogFolderName = ProgramPath.Log + "\\Monitoring Log";

	try
	{
		unsigned short year, month, day;
		year = StrToInt(ReadYearEdit->Text);
		month = StrToInt(ReadMonthEdit->Text);
		day = StrToInt(ReadDayEdit->Text);

		AnsiString temperatureDataFileName = monitorLogFolderName + temperatureDataFileName.sprintf("\\%04d-%02d-%02d.tpr", year, month, day);
		if (!FileExists(temperatureDataFileName))
		{
			for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
			{
				memset(SavedTemperatureData[thermoUnitIndex], 0, 24 * 60 * sizeof(unsigned short));
			}
			ShowMessageFA(SYSTEMMONITORFORM_MSG_03);
		}
		else
		{
			TFileStream *aFileStream = new TFileStream(temperatureDataFileName, fmOpenRead);
			if (aFileStream)
			{
				for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
				{
					aFileStream->Read(SavedTemperatureData[thermoUnitIndex], 24 * 60 * sizeof(unsigned short));
				}
				delete aFileStream;
			}
		}

		AnsiString humidityDataFileName = monitorLogFolderName + humidityDataFileName.sprintf("\\%04d-%02d-%02d.hmd", year, month, day);
		if (!FileExists(humidityDataFileName))
		{
			for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
			{
				memset(SavedHumidityData[thermoUnitIndex], 0, 24 * 60 * sizeof(unsigned short));
			}
			ShowMessageFA(SYSTEMMONITORFORM_MSG_01);
		}
		else
		{
			TFileStream *aFileStream = new TFileStream(humidityDataFileName, fmOpenRead);
			if (aFileStream)
			{
				for (int thermoUnitIndex = 0; thermoUnitIndex < THERMOMETER_UNIT_COUNT; thermoUnitIndex++)
				{
					aFileStream->Read(SavedHumidityData[thermoUnitIndex], 24 * 60 * sizeof(unsigned short));
				}
				delete aFileStream;
			}
		}

		AnsiString pressureDataFileName = monitorLogFolderName + pressureDataFileName.sprintf("\\%04d-%02d-%02d.psr", year, month, day);
		if (!FileExists(pressureDataFileName))
		{
			for (int pressureUnitIndex = 0; pressureUnitIndex < PANELMETER_UNIT_COUNT; pressureUnitIndex++)
			{
				memset(SavedPressureData[pressureUnitIndex], 0, 24 * 60 * sizeof(short));
			}
			ShowMessageFA(SYSTEMMONITORFORM_MSG_02);
		}
		else
		{
			TFileStream *aFileStream = new TFileStream(pressureDataFileName, fmOpenRead);
			if (aFileStream)
			{
				for (int pressureUnitIndex = 0; pressureUnitIndex < PANELMETER_UNIT_COUNT; pressureUnitIndex++)
				{
					aFileStream->Read(SavedPressureData[pressureUnitIndex], 24 * 60 * sizeof(short));
				}
				delete aFileStream;
			}
		}

		ApplySavedDataChart();
	}
	catch (Exception &ec)
	{
		ShowMessageFA(ec.Message);
	}
}
//---------------------------------------------------------------------------
void __fastcall TSystemMonitorForm::ApplySavedDataChart(void)
{
	double chartList[24 * 60 / 5 + 1];
	if (CurrentSavedMonitorUnitIndex < THERMOMETER_UNIT_COUNT)
	{
		SavedThermometerChart->Series[0]->Clear();
		SavedThermometerChart->Series[1]->Clear();
		for (int listIndex = 0; listIndex < 24 * 60 / 5; listIndex++)
		{
			chartList[listIndex] = SavedTemperatureData[CurrentSavedMonitorUnitIndex - 0][listIndex * 5] / 100.0;
		}
		chartList[24 * 60 / 5] = 0;
		SavedThermometerChart->Series[0]->AddArray(chartList, 24 * 60 / 5);
		for (int listIndex = 0; listIndex < 24 * 60 / 5; listIndex++)
		{
			chartList[listIndex] = SavedHumidityData[CurrentSavedMonitorUnitIndex - 0][listIndex * 5] / 100.0;
		}
		chartList[24 * 60 / 5] = 0;
		SavedThermometerChart->Series[1]->AddArray(chartList, 24 * 60 / 5);
	}
	else
	{
		SavedPressureChart->Series[0]->Clear();
		for (int listIndex = 0; listIndex < 24 * 60 / 5; listIndex++)
		{
			chartList[listIndex] = SavedPressureData[CurrentSavedMonitorUnitIndex - THERMOMETER_UNIT_COUNT][listIndex * 5] / 10.0;
		}
		chartList[24 * 60 / 5] = 0;
		SavedPressureChart->Series[0]->AddArray(chartList, 24 * 60 / 5);
	}
}
//---------------------------------------------------------------------------

void __fastcall TSystemMonitorForm::SavedMonitorUnitSelectionPanelClick(TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *) Sender;
	CurrentSavedMonitorUnitIndex = thePanel->Tag;
	for (int unitIndex = 0; unitIndex < RECODING_UNIT_COUNT; unitIndex++)
	{
		TTntPanel *aPanel = (TTntPanel *) FindComponent("SavedMonitorUnitSelectionPanel" + IntToStr(unitIndex + 1));
		if (aPanel)
		{
			if (unitIndex == CurrentSavedMonitorUnitIndex)
			{
				aPanel->Color = clBlue;
			}
			else
			{
				aPanel->Color = clBlack;
			}
		}
	}


	if (CurrentSavedMonitorUnitIndex < THERMOMETER_UNIT_COUNT)
	{
		SavedThermometerChart->Visible = true;
		SavedPressureChart->Visible = false;
	}
	else
	{
		SavedPressureChart->Visible = true;
		SavedThermometerChart->Visible = false;
	}

	ApplySavedDataChart();
}
//---------------------------------------------------------------------------


