//---------------------------------------------------------------------------

#ifndef SystemMonitor_FormH
#define SystemMonitor_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Chart.hpp>
#include <ExtCtrls.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
#define RS485_UNIT_COUNT			8
#define THERMOMETER_UNIT_COUNT		3
#define PANELMETER_UNIT_COUNT		3

#define COMM_STATUS_IDLE			0
#define COMM_STATUS_POLLING			1

#define RS485_TX_STATUS_READY		1
#define RS485_RX_STATUS_RECEIVED	3

#define RECODING_UNIT_COUNT			6
//---------------------------------------------------------------------------
class TSystemMonitorForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntGroupBox *GroupBox1;
	TTntLabel *Label1;
	TTntLabel *TemperatueLabel1;
	TTntLabel *Label3;
	TTntLabel *HumidityLabel1;
	TTntLabel *Label5;
	TTntLabel *TemperatueLabel2;
	TTntLabel *Label7;
	TTntLabel *HumidityLabel2;
	TTntLabel *Label9;
	TTntLabel *TemperatueLabel3;
	TTntLabel *Label11;
	TTntLabel *HumidityLabel3;
	TTntGroupBox *GroupBox2;
	TTntLabel *Label13;
	TTntLabel *Label14;
	TTntGroupBox *GroupBox3;
	TChart *ThermometerChart;
	TLineSeries *Series3;
	TLineSeries *Series1;
	TTimer *CommTimer;
	TTntLabel *InverterRPMLabel1;
	TTntLabel *InverterRPMLabel2;
  TTntLabel *InverterRPMLabel3;
	TTntButton *CloseButton;
	TTntPanel *MonitorUnitSelectionPanel1;
	TTntPanel *MonitorUnitSelectionPanel2;
	TTntPanel *MonitorUnitSelectionPanel3;
	TTntGroupBox *GroupBox4;
	TTntLabel *Label2;
	TTntLabel *Label4;
	TTntLabel *Label6;
	TTntLabel *Label8;
	TTntEdit *ReadYearEdit;
	TTntEdit *ReadMonthEdit;
	TTntEdit *ReadDayEdit;
	TTntButton *CalendarSelectionButton;
	TTntButton *ReadSavedDataButton;
	TTntPanel *SavedMonitorUnitSelectionPanel1;
	TTntPanel *SavedMonitorUnitSelectionPanel2;
	TTntPanel *SavedMonitorUnitSelectionPanel3;
	TChart *SavedThermometerChart;
	TLineSeries *LineSeries1;
	TLineSeries *LineSeries2;
	TTntGroupBox *GroupBox5;
	TTntLabel *Label15;
	TTntLabel *PressureLabel1;
	TTntLabel *Label17;
	TTntLabel *Label18;
	TTntLabel *Label19;
	TTntLabel *PressureHPLabel1;
	TTntLabel *PressureLPLabel1;
	TTntLabel *Label10;
	TTntLabel *PressureLabel2;
	TTntLabel *Label22;
	TTntLabel *Label23;
	TTntLabel *Label24;
	TTntLabel *PressureHPLabel2;
	TTntLabel *PressureLPLabel2;
	TTntLabel *Label27;
	TTntLabel *PressureLabel3;
	TTntLabel *Label29;
	TTntLabel *Label30;
	TTntLabel *Label31;
	TTntLabel *PressureHPLabel3;
	TTntLabel *PressureLPLabel3;
	TTntPanel *MonitorUnitSelectionPanel5;
	TTntPanel *MonitorUnitSelectionPanel6;
	TTntPanel *MonitorUnitSelectionPanel4;
	TTntPanel *SavedMonitorUnitSelectionPanel5;
	TTntPanel *SavedMonitorUnitSelectionPanel6;
	TTntPanel *SavedMonitorUnitSelectionPanel4;
	TChart *PressureChart;
	TLineSeries *LineSeries3;
	TChart *SavedPressureChart;
	TLineSeries *LineSeries4;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntLabel *TntLabel3;
	void __fastcall CommTimerTimer(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall MonitorUnitSelectionPanelClick(TObject *Sender);
	void __fastcall NumEditClick(TObject *Sender);
	void __fastcall CalendarSelectionButtonClick(TObject *Sender);
	void __fastcall ReadSavedDataButtonClick(TObject *Sender);
	void __fastcall SavedMonitorUnitSelectionPanelClick(TObject *Sender);
private:	// User declarations
	TDateTime LastCommTime[RS485_UNIT_COUNT];
	TDateTime LastRecordedTime;
	int CommStatus[RS485_UNIT_COUNT];
	unsigned char ComAddress[RS485_UNIT_COUNT];
//	int CurrentCommUnitIndex;
	unsigned char RXData[128];
	unsigned char TXData[128];
	int TXLength;
	int RXLength;

	int CurrentMonitorUnitIndex;
	int CurrentSavedMonitorUnitIndex;

	unsigned short CurrentYear, CurrentMonth, CurrentDay;
	unsigned short TemperatureData[THERMOMETER_UNIT_COUNT][24 * 60];
	unsigned short HumidityData[THERMOMETER_UNIT_COUNT][24 * 60];
	short PressureData[PANELMETER_UNIT_COUNT][24 * 60];

	unsigned short SavedTemperatureData[THERMOMETER_UNIT_COUNT][24 * 60];
	unsigned short SavedHumidityData[THERMOMETER_UNIT_COUNT][24 * 60];
	short SavedPressureData[THERMOMETER_UNIT_COUNT][24 * 60];

	void __fastcall MakeTXData(void);
	bool __fastcall DecodePacket(void);
	void __fastcall ApplyChart(void);
	void __fastcall RecordThermoMeterData(void);
	void __fastcall ApplySavedDataChart(void);
  void __fastcall GetDefaultString();
public:		// User declarations
	__fastcall TSystemMonitorForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TSystemMonitorForm *SystemMonitorForm;
//---------------------------------------------------------------------------
#endif
