//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SystemProcessInfo_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PERFGRAP"
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma resource "*.dfm"
TSystemProcessInfoForm *SystemProcessInfoForm;
//---------------------------------------------------------------------------
__fastcall TSystemProcessInfoForm::TSystemProcessInfoForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  if(DefaultLCID == 1042 || DefaultLCID == 2066)
  {
    HCBPerformanceChart1->LeftAxis->Title->Caption = "";
    HCBPerformanceChart1->BottomAxis->Title->Caption = "ð";

    HCBPerformanceChart2->LeftAxis->Title->Caption = "";
    HCBPerformanceChart2->BottomAxis->Title->Caption = "ð";

    HCBPerformanceChart3->LeftAxis->Title->Caption = "";
    HCBPerformanceChart3->BottomAxis->Title->Caption = "ð";             
  }
  else
  {
    HCBPerformanceChart1->LeftAxis->Title->Caption = "Quantity";
    HCBPerformanceChart1->BottomAxis->Title->Caption = "Time";

    HCBPerformanceChart2->LeftAxis->Title->Caption = "Quantity";
    HCBPerformanceChart2->BottomAxis->Title->Caption = "Time";

    HCBPerformanceChart3->LeftAxis->Title->Caption = "Quantity";
    HCBPerformanceChart3->BottomAxis->Title->Caption = "Time";
  }

  CloseBitBtn->Caption = SYSTEMPROCESSINFOFORM_BITBTN_CAPTION_01;
	DeactivateSpeedButton->Caption =SYSTEMPROCESSINFOFORM_BUTTON_CAPTION_01;
	ActivateSpeedButton->Caption = SYSTEMPROCESSINFOFORM_BUTTON_CAPTION_02;

	RecordHCBStartTime = 0;
	memset(HCBIdleTimeList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
	memset(HCBMin50usCountList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
	memset(HCBMax50usCountList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));

	CurrentCommBoard = COMM_HCB;
}
//---------------------------------------------------------------------------
void __fastcall TSystemProcessInfoForm::PerformanceCheckTimerTimer(TObject *Sender)
{
	PerformanceCheckTimer->Enabled = false;
	TIdleProcessData hcbIdleProcessData;
	if (Comm_Request(CurrentCommBoard, CMD_IDLE_PROCESS_INFO, NULL, 0,&hcbIdleProcessData, sizeof(TIdleProcessData)))
	{
		unsigned hcbStartTime = hcbIdleProcessData.CurrentTime;
		unsigned int hcbDataStartTime = hcbStartTime - HCB_RECORD_DATA_COUNT - 1;
		unsigned int newRecordStartTime = 0;
		if (hcbStartTime >= HCB_RECORD_DATA_COUNT - 1)
		{
			newRecordStartTime = hcbStartTime - HCB_RECORD_DATA_COUNT - 1;
		}
		if (newRecordStartTime > RecordHCBStartTime)
		{
			for (int recordedDataIndex = 0; recordedDataIndex < HCB_RECORD_DATA_COUNT; recordedDataIndex++)
			{
				if (recordedDataIndex + newRecordStartTime - RecordHCBStartTime < HCB_RECORD_DATA_COUNT)
				{
					HCBIdleTimeList[recordedDataIndex] = HCBIdleTimeList[recordedDataIndex + newRecordStartTime - RecordHCBStartTime];
					HCBMin50usCountList[recordedDataIndex] = HCBMin50usCountList[recordedDataIndex + newRecordStartTime - RecordHCBStartTime];
					HCBMax50usCountList[recordedDataIndex] = HCBMax50usCountList[recordedDataIndex + newRecordStartTime - RecordHCBStartTime];
				}
				else
				{
					HCBIdleTimeList[recordedDataIndex] = 0;
					HCBMin50usCountList[recordedDataIndex] = 0;
					HCBMax50usCountList[recordedDataIndex] = 0;
				}
			}
		}


		RecordHCBStartTime = newRecordStartTime;
		for (int hcbDataIndex = 0; hcbDataIndex < IDLE_PROCESS_LIST_COUNT; hcbDataIndex++)
		{
			if (hcbIdleProcessData.Time[hcbDataIndex] - RecordHCBStartTime >= 0 &&
				hcbIdleProcessData.Time[hcbDataIndex] - RecordHCBStartTime < HCB_RECORD_DATA_COUNT)
			{
				HCBIdleTimeList[hcbIdleProcessData.Time[hcbDataIndex] - RecordHCBStartTime] = hcbIdleProcessData.TimeCounter[hcbDataIndex];
				HCBMin50usCountList[hcbIdleProcessData.Time[hcbDataIndex] - RecordHCBStartTime] = hcbIdleProcessData.Min50usCount[hcbDataIndex];
				HCBMax50usCountList[hcbIdleProcessData.Time[hcbDataIndex] - RecordHCBStartTime] = hcbIdleProcessData.Max50usCount[hcbDataIndex];
			}
		}
		HCBPerformanceChart1->Series[0]->Clear();
		HCBPerformanceChart1->Series[0]->AddArray(HCBIdleTimeList, HCB_RECORD_DATA_COUNT - 1);
		HCBPerformanceChart2->Series[0]->Clear();
		HCBPerformanceChart2->Series[0]->AddArray(HCBMax50usCountList, HCB_RECORD_DATA_COUNT - 1);
		HCBPerformanceChart3->Series[0]->Clear();
		HCBPerformanceChart3->Series[0]->AddArray(HCBMin50usCountList, HCB_RECORD_DATA_COUNT - 1);		
	}
	PerformanceCheckTimer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TSystemProcessInfoForm::CloseBitBtnClick(TObject *Sender)
{
	PerformanceCheckTimer->Enabled = false;
	this->Hide();
}
//---------------------------------------------------------------------------
void __fastcall TSystemProcessInfoForm::ActivateSpeedButtonClick(
	  TObject *Sender)
{
	PerformanceCheckTimer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TSystemProcessInfoForm::DeactivateSpeedButtonClick(
	  TObject *Sender)
{
	PerformanceCheckTimer->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TSystemProcessInfoForm::HCBSpeedButtonClick(
      TObject *Sender)
{
	if (CurrentCommBoard != COMM_HCB)
	{
		RecordHCBStartTime = 0;
		memset(HCBIdleTimeList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
		memset(HCBMin50usCountList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
		memset(HCBMax50usCountList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
	}
	CurrentCommBoard = COMM_HCB;
}
//---------------------------------------------------------------------------

void __fastcall TSystemProcessInfoForm::SPBSpeedButtonClick(TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	int spbIndex = theSpeedButton->Tag;
	int newCommBoard = COMM_SPB + spbIndex;

	if (CurrentCommBoard != newCommBoard)
	{
		RecordHCBStartTime = 0;
		memset(HCBIdleTimeList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
		memset(HCBMin50usCountList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
		memset(HCBMax50usCountList, 0, HCB_RECORD_DATA_COUNT * sizeof(double));
	}
	CurrentCommBoard = newCommBoard;
}
//---------------------------------------------------------------------------

