//---------------------------------------------------------------------------

#ifndef SystemProcessInfo_FormH
#define SystemProcessInfo_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include "PERFGRAP.h"
#include <Chart.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
#define HCB_RECORD_DATA_COUNT			600			// 600 * 100ms
//---------------------------------------------------------------------------
class TSystemProcessInfoForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntSpeedButton *ActivateSpeedButton;
	TTntSpeedButton *DeactivateSpeedButton;
	TTntBitBtn *CloseBitBtn;
	TTntPanel *Panel2;
	TTimer *PerformanceCheckTimer;
	TChart *HCBPerformanceChart1;
	TLineSeries *Series3;
	TChart *HCBPerformanceChart2;
	TLineSeries *LineSeries1;
	TChart *HCBPerformanceChart3;
	TLineSeries *LineSeries4;
	TTntSpeedButton *HCBSpeedButton;
	TTntSpeedButton *SPBSpeedButton1;
	TTntSpeedButton *SPBSpeedButton2;
	TTntSpeedButton *SPBSpeedButton3;
	TTntSpeedButton *SPBSpeedButton4;
  TTntSpeedButton *TntSpeedButton1;
  TTntSpeedButton *TntSpeedButton2;
	void __fastcall PerformanceCheckTimerTimer(TObject *Sender);
	void __fastcall CloseBitBtnClick(TObject *Sender);
	void __fastcall ActivateSpeedButtonClick(TObject *Sender);
	void __fastcall DeactivateSpeedButtonClick(TObject *Sender);
	void __fastcall HCBSpeedButtonClick(TObject *Sender);
	void __fastcall SPBSpeedButtonClick(TObject *Sender);
private:	// User declarations
	int CurrentCommBoard;

	double HCBIdleTimeList[HCB_RECORD_DATA_COUNT];
	double HCBMin50usCountList[HCB_RECORD_DATA_COUNT];
	double HCBMax50usCountList[HCB_RECORD_DATA_COUNT];
	unsigned int RecordHCBStartTime;
public:		// User declarations
	__fastcall TSystemProcessInfoForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TSystemProcessInfoForm *SystemProcessInfoForm;
//---------------------------------------------------------------------------
#endif
