//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <registry.hpp>
#pragma hdrstop

#include "SystemSetting_Form.h"
#include "Download_Form.h"
#include "SetPath_Form.h"
#include "CPBSetting_Form.h"
#include "MCBSPTest_Form.h"
#include "HPITest_Form.h"
#include "MachineParamSetting_Form.h"
#include "LogViewer_Form.h"
#include "CalibrationMenu_Form.h"
#include "RS485Test_Form.h"
#include "SystemProcessInfo_Form.h"
#include "MultiLanguage.h"
#include "Capture_Form.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TSystemSettingForm *SystemSettingForm;
//---------------------------------------------------------------------------
__fastcall TSystemSettingForm::TSystemSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  this->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_01;
  DownloadButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_02;
  SetPathButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_03;
  CalibrationButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_04;
  ViewLogButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_05;
  MachineSettingButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_08;
  CPBSettingButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_09;
  MCBSPTestButton->Caption 	= SYSTEMSETTINGFORM_FORM_CAPTION_10;
  CloseButton->Caption 		= SYSTEMSETTINGFORM_FORM_CAPTION_11;


	if (!SimulationMode)
	{
		VirtualMachineModeButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_06;
	}
	else
	{
		VirtualMachineModeButton->Caption = SYSTEMSETTINGFORM_FORM_CAPTION_07;
	}
  OnUserChange();
}
//---------------------------------------------------------------------------
void __fastcall TSystemSettingForm::DownloadButtonClick(TObject *Sender)
{
	DownloadForm = new TDownloadForm(this);
	DownloadForm->ShowModal();
    delete DownloadForm;
    DownloadForm = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TSystemSettingForm::SetPathButtonClick(TObject *Sender)
{
	SetPathForm = new TSetPathForm(this);
	SetPathForm->ShowModal();
    delete SetPathForm;
    SetPathForm = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TSystemSettingForm::CloseButtonClick(TObject *Sender)
{
    this->Close();    
}
//---------------------------------------------------------------------------


void __fastcall TSystemSettingForm::CPBSettingButtonClick(TObject *Sender)
{
	CPBSettingForm = new TCPBSettingForm(this);
    CPBSettingForm->ShowModal();
    delete CPBSettingForm;
    CPBSettingForm = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TSystemSettingForm::MCBSPTestButtonClick(TObject *Sender)
{
	MCBSPTestForm = new TMCBSPTestForm(this);
	MCBSPTestForm->ShowModal();
    delete MCBSPTestForm;
    MCBSPTestForm = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TSystemSettingForm::HPITestButtonClick(TObject *Sender)
{
	HPITestForm = new THPITestForm(this);
	HPITestForm->ShowModal();
    delete HPITestForm;
    HPITestForm = NULL;
}
//---------------------------------------------------------------------------


void __fastcall TSystemSettingForm::MachineSettingButtonClick(
      TObject *Sender)
{
	MachineParamSettingForm = new TMachineParamSettingForm(this);
    MachineParamSettingForm->ShowModal();
    delete MachineParamSettingForm;
    MachineParamSettingForm = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TSystemSettingForm::ViewLogButtonClick(TObject *Sender)
{
	TLogViewerForm *logViewerForm = new TLogViewerForm(this);
	logViewerForm->ShowModal();
	delete logViewerForm;	
}
//---------------------------------------------------------------------------

void __fastcall TSystemSettingForm::CalibrationButtonClick(TObject *Sender)
{
  TCaptureForm *captureForm = new TCaptureForm(this);
	captureForm->ShowModal();
	delete captureForm;
}
//---------------------------------------------------------------------------
void __fastcall TSystemSettingForm::OnUserChange(void)
{
  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MAINFORM_SYSTEM_SETUP])
  {
    DownloadButton->Visible = true;
    SetPathButton->Visible = true;
    CalibrationButton->Visible = true;
    ViewLogButton->Visible = true;
    CPBSettingButton->Visible = true;
    RS485TestButton->Visible = true;
    HPITestButton->Visible = true;
    SystemProcessInfoButton->Visible = true;
    MCBSPTestButton->Visible = true;
    VirtualMachineModeButton->Visible = true;
  }
  else
  {
    DownloadButton->Visible = false;
    SetPathButton->Visible = false;
    CalibrationButton->Visible = false;
    ViewLogButton->Visible = false;
    CPBSettingButton->Visible = false;
    RS485TestButton->Visible = false;
    HPITestButton->Visible = false;
    SystemProcessInfoButton->Visible=false;
    MCBSPTestButton->Visible = false;
    VirtualMachineModeButton->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TSystemSettingForm::RS485TestButtonClick(TObject *Sender)
{
	TRS485TestForm *rs485TestForm = new TRS485TestForm(this);
	rs485TestForm->ShowModal();
	delete rs485TestForm;
}
//---------------------------------------------------------------------------
void __fastcall TSystemSettingForm::VirtualMachineModeButtonClick(
	  TObject *Sender)
{
	if (SimulationMode)
	{
		if (MessageDlgFA(SYSTEMSETTINGFORM_MSG_02, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			SimulationMode = false;
			TRegIniFile *regIniFile = new TRegIniFile("Application");
			if (regIniFile)
			{
				regIniFile->RootKey = HKEY_LOCAL_MACHINE;
				regIniFile->OpenKey(PROGRAM_REGISTRY_KEY, true);

				regIniFile->WriteBool("SYSTEM", "SIM MODE", SimulationMode);
				delete regIniFile;
			}
		}
	}
	else
	{
		if (MessageDlgFA(SYSTEMSETTINGFORM_MSG_01, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			SimulationMode = true;
			TRegIniFile *regIniFile = new TRegIniFile("Application");
			if (regIniFile)
			{
				regIniFile->RootKey = HKEY_LOCAL_MACHINE;
				regIniFile->OpenKey(PROGRAM_REGISTRY_KEY, true);

				regIniFile->WriteBool("SYSTEM", "SIM MODE", SimulationMode);
				delete regIniFile;
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TSystemSettingForm::SystemProcessInfoButtonClick(
      TObject *Sender)
{
	SystemProcessInfoForm->Show();
}
//---------------------------------------------------------------------------
