//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#include <inifiles.hpp>

#pragma hdrstop
#pragma package(smart_init)

#include "SystemSetup.h"
#include "Environment.h"

//---------------------------------------------------------------------------
bool __fastcall SendSystemSetupData(void)
{
	bool returnValue = true;
	unsigned int data[2];
	unsigned int programID;
	int time;

	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		SPBSystemSetupData[spbIndex].DefaultCPBProgramID = PID_CPB_TABLET_5;

		time = Now().FileDate();
		programID = PID_ENVIRONMENT;

		memcpy(&data[0], &programID, sizeof(unsigned int));
		memcpy(&data[1], &time, sizeof(int));

		if (Comm_IsConnected(COMM_SPB + spbIndex))
		{
			Comm_SetMaxWaitingTime(COMM_SPB + spbIndex, 30000);
			if (!Comm_RequestEx(COMM_SPB + spbIndex, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int), &SPBSystemSetupData[spbIndex], sizeof(TSPBSystemSetupData)))
			{
				returnValue = false;
			}
			Comm_SetDefaultMaxWaitingTime(COMM_SPB + spbIndex);
		}

	}
	return returnValue;
}


//---------------------------------------------------------------------------

