//---------------------------------------------------------------------------

#ifndef SystemSimulation_FormH
#define SystemSimulation_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "processing.h"
#include "ErrorList_Form.h"
#include <Grids.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include "TntButtons.hpp"
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>

#define MAX_IMAGE_WIDTH 640
#define MAX_IMAGE_HEIGHT 480

typedef struct{
    int buff[3];
    unsigned char processedImg[64 * 48];
}TCPBProcessingData;

typedef struct{
	unsigned int TabletNumber;
	int Result;
	int State;
	unsigned int ProcessStartTime;
	
	unsigned char CameraEnabled[SYSTEM_SPB_CAMERA_COUNT];
	unsigned short CapturedTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ImageSendTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned short CPBProcessingTime[SYSTEM_SPB_CAMERA_COUNT];
	int	ProcessingResult[SYSTEM_SPB_CAMERA_COUNT];
	

	unsigned char TabletAssignSW;
	unsigned char ProcessingDataSetSW;
}TSPBProcessedData;

typedef struct{
	unsigned int TabletNumber;
	int Result;
  
  unsigned short CapturedTime[SYSTEM_SPB_CAMERA_COUNT];

  int currentTabletNumber;
}TSPBSimpleProcessedData;

typedef struct{
    unsigned int TabletNumber;
    int CaptureStatus[4];
    int CapturedTime[4];
    unsigned char ProcessingState;
    unsigned char ProcessingResult[4];
}TSPBProcessingData;

typedef struct{
    unsigned int TabletGoodCount;
    unsigned int TabletDefectCount;
    unsigned int TabletUnInsCount;
    unsigned int UnIns_NoneCount;
    unsigned int UnIns_ProcessingCount;
    unsigned int UnIns_ImageBufferFull;
    unsigned int UnIns_Number_UnDefined;
    unsigned int UnIns_Wrong_Number;
    unsigned int UnIns_Capture_Timeout;
    unsigned int UnIns_Capture_Not_Ready;
    unsigned int UnIns_Processing_Timeout;
    unsigned int UnIns_Processing_Error;
    unsigned int UnIns_CPB_Full;
    unsigned int UnIns_Closed_Tablet;
    unsigned int UnIns_Position_Error;
    unsigned int UnIns_Brightness_Drop;
    unsigned int UnIns_Brightness_Chase;
}TTabletInspectionResult;

#define	SPB_TABLET_RESULT_NONE								              0
#define	SPB_TABLET_RESULT_PROCESSING						            1
#define	SPB_TABLET_RESULT_GOOD								              2
#define	SPB_TABLET_RESULT_DEFECT							              3
#define	SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL			      4
#define	SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED		  5
#define	SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER			    6
#define	SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT				      7
#define	SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY			      8
#define	SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT			    9
#define	SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR			      10
#define	SPB_TABLET_RESULT_UNINS_CPB_FULL					          11
#define	SPB_TABLET_RESULT_UNINS_CLOSED_TABLET				        12
#define	SPB_TABLET_RESULT_UNINS_TABLET_POSITION				      13
#define	SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED			    14
#define	SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE			      15

//---------------------------------------------------------------------------
class TSystemSimulationForm : public TTntForm
{
__published:	// IDE-managed Components
  TButton *CloseButton;
  TButton *InspectionStartButton;
  TLabel *ProcessingStatusLabel;
  TTimer *ImageControlTimer;
  TButton *StopBtn;
  TButton *SetupBtn;
  TPanel *Panel1;
  TLabel *Label1;
  TTimer *Timer1;
  TButton *SetProcessingImageButton;
  TImage *SPBImage1;
  TImage *SPBImage2;
  TImage *SPBImage4;
  TImage *SPBImage3;
  TStringGrid *CPBResultStringGrid1;
  TLabel *Label12;
  TPanel *Panel111;
  TStringGrid *CPBStatusGrid1;
  TLabel *Label5;
  TStringGrid *CPBStatusGrid2;
  TLabel *Label6;
  TStringGrid *CPBStatusGrid3;
  TLabel *Label7;
  TStringGrid *CPBStatusGrid4;
  TLabel *Label8;
  TButton *Button2;
  TButton *Button3;
  TButton *Button4;
  TGroupBox *GroupBox1;
  TCheckBox *CheckBox1;
  TLabel *Label10;
  TEdit *Edit2;
  TBitBtn *BitBtn1;
  TPanel *Panel3;
  TLabel *Label3;
  TImage *CapturedImage1;
  TImage *CapturedImage2;
  TImage *CapturedImage4;
  TImage *CapturedImage3;
  TTimer *CapturedImageTimer;
  TProgressBar *ImageLoadProgressBar1;
  TProgressBar *ImageLoadProgressBar2;
  TProgressBar *ImageLoadProgressBar3;
  TProgressBar *ImageLoadProgressBar4;
  TLabel *ImageCountLabel1;
  TLabel *ImageCountLabel2;
  TLabel *ImageCountLabel4;
  TLabel *ImageCountLabel3;
  TLabel *Label9;
  TLabel *Label14;
  TStringGrid *CPBResultStringGrid2;
  TLabel *Label16;
  TStringGrid *CPBResultStringGrid3;
  TLabel *Label4;
  TStringGrid *CPBResultStringGrid4;
  TPanel *Panel2;
  TLabel *Label15;
  TImage *ProcessingImageCam2_1;
  TImage *ProcessingImageCam2_2;
  TImage *ProcessingImageCam2_3;
  TImage *ProcessingImageCam2_4;
  TImage *ProcessingImageCam2_5;
  TImage *ProcessingImageCam2_6;
  TImage *ProcessingImageCam2_7;
  TImage *ProcessingImageCam2_8;
  TImage *ProcessingImageCam2_9;
  TImage *ProcessingImageCam2_10;
  TImage *ProcessingImageCam2_11;
  TImage *ProcessingImageCam2_12;
  TImage *ProcessingImageCam2_13;
  TImage *ProcessingImageCam2_14;
  TImage *ProcessingImageCam2_15;
  TImage *ProcessingImageCam2_16;
  TImage *ProcessingImageCam2_17;
  TImage *ProcessingImageCam2_18;
  TImage *ProcessingImageCam2_19;
  TImage *ProcessingImageCam2_20;
  TImage *ProcessingImageCam2_21;
  TImage *ProcessingImageCam2_22;
  TImage *ProcessingImageCam2_23;
  TImage *ProcessingImageCam2_24;
  TPanel *Panel4;
  TLabel *Label17;
  TImage *ProcessingImageCam3_1;
  TImage *ProcessingImageCam3_2;
  TImage *ProcessingImageCam3_3;
  TImage *ProcessingImageCam3_4;
  TImage *ProcessingImageCam3_5;
  TImage *ProcessingImageCam3_6;
  TImage *ProcessingImageCam3_7;
  TImage *ProcessingImageCam3_8;
  TImage *ProcessingImageCam3_9;
  TImage *ProcessingImageCam3_10;
  TImage *ProcessingImageCam3_11;
  TImage *ProcessingImageCam3_12;
  TImage *ProcessingImageCam3_13;
  TImage *ProcessingImageCam3_14;
  TImage *ProcessingImageCam3_15;
  TImage *ProcessingImageCam3_16;
  TImage *ProcessingImageCam3_17;
  TImage *ProcessingImageCam3_18;
  TImage *ProcessingImageCam3_19;
  TImage *ProcessingImageCam3_20;
  TImage *ProcessingImageCam3_21;
  TImage *ProcessingImageCam3_22;
  TImage *ProcessingImageCam3_23;
  TImage *ProcessingImageCam3_24;
  TPanel *Panel5;
  TLabel *Label18;
  TImage *ProcessingImageCam4_1;
  TImage *ProcessingImageCam4_2;
  TImage *ProcessingImageCam4_3;
  TImage *ProcessingImageCam4_4;
  TImage *ProcessingImageCam4_5;
  TImage *ProcessingImageCam4_6;
  TImage *ProcessingImageCam4_7;
  TImage *ProcessingImageCam4_8;
  TImage *ProcessingImageCam4_9;
  TImage *ProcessingImageCam4_10;
  TImage *ProcessingImageCam4_11;
  TImage *ProcessingImageCam4_12;
  TImage *ProcessingImageCam4_13;
  TImage *ProcessingImageCam4_14;
  TImage *ProcessingImageCam4_15;
  TImage *ProcessingImageCam4_16;
  TImage *ProcessingImageCam4_17;
  TImage *ProcessingImageCam4_18;
  TImage *ProcessingImageCam4_19;
  TImage *ProcessingImageCam4_20;
  TImage *ProcessingImageCam4_21;
  TImage *ProcessingImageCam4_22;
  TImage *ProcessingImageCam4_23;
  TImage *ProcessingImageCam4_24;
  TPanel *Panel6;
  TLabel *Label2;
  TImage *ProcessingImageCam1_1;
  TImage *ProcessingImageCam1_2;
  TImage *ProcessingImageCam1_3;
  TImage *ProcessingImageCam1_4;
  TImage *ProcessingImageCam1_5;
  TImage *ProcessingImageCam1_6;
  TImage *ProcessingImageCam1_7;
  TImage *ProcessingImageCam1_8;
  TImage *ProcessingImageCam1_9;
  TImage *ProcessingImageCam1_10;
  TImage *ProcessingImageCam1_11;
  TImage *ProcessingImageCam1_12;
  TImage *ProcessingImageCam1_13;
  TImage *ProcessingImageCam1_14;
  TImage *ProcessingImageCam1_15;
  TImage *ProcessingImageCam1_16;
  TImage *ProcessingImageCam1_17;
  TImage *ProcessingImageCam1_18;
  TImage *ProcessingImageCam1_19;
  TImage *ProcessingImageCam1_20;
  TImage *ProcessingImageCam1_21;
  TImage *ProcessingImageCam1_22;
  TImage *ProcessingImageCam1_23;
  TImage *ProcessingImageCam1_24;
  TPageControl *PageControl1;
  TTabSheet *TabSheet1;
  TTabSheet *TabSheet2;
  TPanel *Panel7;
  TStringGrid *StringGrid1;
  TPanel *Panel8;
  TPanel *Panel9;
  TLabel *Label13;
  TPanel *Panel10;
  TLabel *Label19;
  TLabel *Label20;
  TLabel *Label22;
  TLabel *Label23;
  TLabel *GoodCountLabel;
  TLabel *DefectCountLabel;
  TLabel *UnInsCountLabel;
  TGroupBox *GroupBox2;
  TLabel *Label27;
  TLabel *UICount1;
  TLabel *Label29;
  TLabel *UICount2;
  TLabel *UICount3;
  TLabel *Label32;
  TLabel *Label33;
  TLabel *UICount4;
  TLabel *Label35;
  TLabel *UICount5;
  TLabel *Label37;
  TLabel *UICount6;
  TLabel *Label39;
  TLabel *UICount7;
  TLabel *Label41;
  TLabel *UICount8;
  TLabel *Label43;
  TLabel *UICount10;
  TLabel *Label45;
  TLabel *UICount11;
  TLabel *Label47;
  TLabel *UICount12;
  TLabel *Label49;
  TLabel *UICount13;
  TLabel *UICount14;
  TLabel *Label52;
  TLabel *Label24;
  TLabel *UICount9;
  TLabel *TotalCount;
  TLabel *Label25;
  TCheckBox *CheckBox2;
  TLabel *Label21;
  TLabel *Label26;
  TRadioGroup *RadioGroup1;
  TTntSpeedButton *SPBSelectButton1;
  TTntSpeedButton *SPBSelectButton2;
  TTntSpeedButton *SPBSelectButton3;
  TTntSpeedButton *SPBSelectButton4;
  TGroupBox *GroupBox3;
  TCheckBox *CameraSelectCheckBox1;
  TCheckBox *CameraSelectCheckBox2;
  TCheckBox *CameraSelectCheckBox4;
  TCheckBox *CameraSelectCheckBox3;
        TEdit *Edit1;
  TTntSpeedButton *SPBSelectButton5;
  TTntSpeedButton *SPBSelectButton6;
  TEdit *Edit3;
  TLabel *Label11;
  TTntSpeedButton *SPBSelectButton8;
  TTntSpeedButton *SPBSelectButton7;
  TLabel *Label28;
  TCheckBox *GradeSendChkBox;
  TEdit *Edit4;
  TLabel *Label30;
  TCheckBox *CheckBox3;
  TOpenPictureDialog *OpenPictureDialog1;
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall ImageControlTimerTimer(TObject *Sender);
  void __fastcall StopBtnClick(TObject *Sender);
  void __fastcall SetupBtnClick(TObject *Sender);
  void __fastcall InspectionStartButtonClick(TObject *Sender);
  void __fastcall Timer1Timer(TObject *Sender);
  void __fastcall FormDestroy(TObject *Sender);
  void __fastcall SetProcessingImageButtonClick(TObject *Sender);
  void __fastcall BitBtn1Click(TObject *Sender);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall Button2Click(TObject *Sender);
  void __fastcall Button3Click(TObject *Sender);
  void __fastcall FormKeyPress(TObject *Sender, char &Key);
  void __fastcall Button4Click(TObject *Sender);
  void __fastcall CapturedImageTimerTimer(TObject *Sender);
  void __fastcall SPBSelectButton1Click(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
private:	// User declarations
  int EnabledSPBMask;
  int globalSPBIndex;

  unsigned char BayerImage[SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT];

  void __fastcall Setup();
  bool __fastcall GetProcessResult();

  TErrorListForm *pErrorListForm;

  int globalReadSW;

  int previousTabletNumber;
  int CurrentTabletNumber;

  int SourceImageWidth[2];
  int SourceImageHeight[2];

  unsigned long lastChecktime;

  void __fastcall RefreshCameraInfo(int cameraIndex);
  void __fastcall SendInspectionReadyCommand(int disk1TargetSpeed, int disk1BaseSpeed, int disk2TargetSpeed, int disk2BaseSpeed, bool *cameraEnabled);
  void __fastcall RefreshInspectionCount();
  void __fastcall RefreshEnabledCamera();

  TTabletInspectionResult TabletInspectionResult;

public:		// User declarations
  __fastcall TSystemSimulationForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TSystemSimulationForm *SystemSimulationForm;
//---------------------------------------------------------------------------
#endif

