//---------------------------------------------------------------------------

#ifndef TabletCounter_FormH
#define TabletCounter_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "PERFGRAP.h"
#include <Buttons.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#define MAX_INTERVAL_LIST_SIZE		2048

using namespace std;
//---------------------------------------------------------------------------
typedef struct
{
    unsigned int OnInterval;
	unsigned int OffInterval;
} TIntervalUnit;
//---------------------------------------------------------------------------
class TIntervalList
{
private:
	int FirstIntervalIndex;
	TIntervalUnit IntervalCQueue[MAX_INTERVAL_LIST_SIZE];
    int StartQueueIndex;
    int QueueCount;
    int CurrentQueueIndex;
    TIntervalUnit *FCurrent;
public:
	__fastcall TIntervalList();
    void __fastcall First(void);
    bool __fastcall IsLast(void);
    void __fastcall Next(void);
    bool __fastcall IsFull(void);
	__property TIntervalUnit *Current = {read = FCurrent};

    void __fastcall Reset(void);
    void __fastcall SetValue(int index, int offInterval, int onInterval);
};
//---------------------------------------------------------------------------
class TTabletCounterForm : public TTntForm
{
__published:	// IDE-managed Components
	TTimer *Timer1;
	TTntButton *StartCountButton;
	TTntButton *StopCountButton;
	TTntButton *ResetCountButton;
	TTntLabel *CountLabel;
	TTimer *TabletCountTimer;
	TTntPanel *Panel1;
    TTntScrollBar *ImageScrollBar;
	TTntImage *Image;
	TTntGroupBox *GroupBox1;
	TTntSpeedButton *ScaleSpeedButton1;
	TTntSpeedButton *ScaleSpeedButton2;
	TTntSpeedButton *ScaleSpeedButton3;
	TTntSpeedButton *ScaleSpeedButton4;
	TTntSpeedButton *ScaleSpeedButton5;
	TTntSpeedButton *ScaleSpeedButton6;
	TTntSpeedButton *ScaleSpeedButton7;
	TTntLabel *CPSLabel;
	TTntLabel *CPMLabel;
	TTntLabel *CPHLabel;
	TTntLabel *Label1;
	TTntLabel *Label2;
	TTntLabel *WCPSLabel;
	TTntLabel *WCPMLabel;
	TTntLabel *WCPHLabel;
	TTntSpeedButton *SimpleModeSpeedButton;
	TTntSpeedButton *SpeedButton2;
	void __fastcall StartCountButtonClick(TObject *Sender);
	void __fastcall StopCountButtonClick(TObject *Sender);
	void __fastcall ResetCountButtonClick(TObject *Sender);
	void __fastcall TabletCountTimerTimer(TObject *Sender);
    void __fastcall ImageScrollBarChange(TObject *Sender);
	void __fastcall ScaleSpeedButtonClick(TObject *Sender);
private:	// User declarations
    int ImageStartPosition;
    TIntervalList IntervalList;		// circular queue ó Ѵ.
    int IntervalListStartIndex;
    int IntervalListMaxValue;
    int Scale;
//    int IntervalListInsertPosition;
//    int IntervalListLastIndexValue;
//    unsigned int DataIndexTable[1024];
//    unsigned int OnInterval[1024];
//    unsigned int OffInterval[1024];

    void __fastcall DrawImage(void);
    void __fastcall IntervalListReset(void);
public:		// User declarations
	__fastcall TTabletCounterForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TTabletCounterForm *TabletCounterForm;
//---------------------------------------------------------------------------
#endif
