//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "TabletDataLog_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TTabletDataLogForm *TabletDataLogForm;
//---------------------------------------------------------------------------
__fastcall TTabletDataLogForm::TTabletDataLogForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  Button1->Caption = TABLETDATALOGFORM_BUTTON_CAPTION_01;
	RestoreButton->Caption = TABLETDATALOGFORM_BUTTON_CAPTION_02;
	Panel6->Caption = TABLETDATALOGFORM_PANEL_CAPTION_01;
	Panel1->Caption = TABLETDATALOGFORM_PANEL_CAPTION_02;
}
//---------------------------------------------------------------------------

void __fastcall TTabletDataLogForm::FormCreate(TObject *Sender)
{
	TabletDataLogStringGrid->ColCount = 6;
	TabletDataLogStringGrid->Cells[0][0] = TABLETDATALOGFORM_STRGRID_CELL_04;
	TabletDataLogStringGrid->Cells[1][0] = TABLETDATALOGFORM_STRGRID_CELL_05;
	TabletDataLogStringGrid->Cells[2][0] = TABLETDATALOGFORM_STRGRID_CELL_07;
	TabletDataLogStringGrid->Cells[3][0] = TABLETDATALOGFORM_STRGRID_CELL_02;
	TabletDataLogStringGrid->Cells[4][0] = TABLETDATALOGFORM_STRGRID_CELL_01;
	TabletDataLogStringGrid->Cells[5][0] = TABLETDATALOGFORM_STRGRID_CELL_06;

	TabletDataLogStringGrid->ColWidths[0] = 240;

	SearchProductDataLog();
	UpdateProductDataLogStringGrid();
}
//---------------------------------------------------------------------------
void __fastcall TTabletDataLogForm::SearchProductDataLog(void)
{
	AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
	AnsiString backupPath = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Backup";
	if (!DirectoryExists(backupPath))
	{
		return;
	}

	TSearchRec sr;
	int iAttributes = faAnyFile;
	if (FindFirst(backupPath + "\\*.dat", iAttributes, sr) == 0)
	{
		do
		{
			TProudctDataLogListUnit productDataLogUnit;
			productDataLogUnit.BackupFileName = backupPath + "\\" + sr.Name;
			TIniFile *iniFile = new TIniFile(productDataLogUnit.BackupFileName);
			if (iniFile)
			{
				productDataLogUnit.BackupDate = iniFile->ReadFloat("Backup Info", "Backup Date", Now().Val);
				productDataLogUnit.BackupReason = iniFile->ReadInteger("Backup Info", "Backup Reason", 0);
				productDataLogUnit.TabletInfoModified = iniFile->ReadBool("Backup Info", "Tablet Info Modified", false);
				productDataLogUnit.MachineInfoModified = iniFile->ReadBool("Backup Info", "Machine Info Modified", false);
				productDataLogUnit.InspectionInfoModified = iniFile->ReadBool("Backup Info", "Inspection Info Modified", false);
				productDataLogUnit.OperatorName = iniFile->ReadString("Backup Info", "Operator Name", "Unknown");
				delete iniFile;
			}
			ProductDataLogList.push_back(productDataLogUnit);
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}

	// sort
	if (ProductDataLogList.size() < 2) return;
	vector<TProudctDataLogListUnit>::iterator it1, it2;
	for (it1 = ProductDataLogList.end() - 1; it1 >= ProductDataLogList.begin(); it1--)
	{
		for (it2 = ProductDataLogList.begin(); it2 < it1; it2++)
		{
			if (it2->BackupDate < (it2 + 1)->BackupDate)
			{
				swap(*it2, *(it2 + 1));
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TTabletDataLogForm::UpdateProductDataLogStringGrid(void)
{
	vector<TProudctDataLogListUnit>::iterator it;
	TabletDataLogStringGrid->RowCount = ProductDataLogList.size() + 1;
	int row = 1;
	for (it = ProductDataLogList.begin(); it < ProductDataLogList.end(); it++)
	{
		TabletDataLogStringGrid->Cells[0][row] = TDateTime(it->BackupDate).DateTimeString();
		TabletDataLogStringGrid->Cells[1][row] = GetBackupReasonString(it->BackupReason);
		TabletDataLogStringGrid->Cells[2][row] = it->TabletInfoModified ? "O" : "X";
		TabletDataLogStringGrid->Cells[3][row] = it->MachineInfoModified ? "O" : "X";
		TabletDataLogStringGrid->Cells[4][row] = it->InspectionInfoModified ? "O" : "X";
		TabletDataLogStringGrid->Cells[5][row] = it->OperatorName;
		row++;
	}
}
//---------------------------------------------------------------------------
WideString __fastcall TTabletDataLogForm::GetBackupReasonString(EProductDataBackupReason reason)
{
	WideString returnStr = TABLETDATALOGFORM_RETURNSTR_02;
	switch (reason)
	{
		case EPDBR_MACHINE_SETUP:
			returnStr = TABLETDATALOGFORM_RETURNSTR_01;
			break;
		case EPDBR_MACHINE_SETTING_CHANGE:
			returnStr = TABLETDATALOGFORM_STRGRID_CELL_03;
			break;
		case EPDBR_PRODUCT_INFO_CHANGE:
			returnStr = TABLETDATALOGFORM_RETURNSTR_04;
			break;
		case EPDBR_DATA_RESTORE:
			returnStr = TABLETDATALOGFORM_RETURNSTR_03;
			break;
	}
	return returnStr;
}
//---------------------------------------------------------------------------
void __fastcall TTabletDataLogForm::FormDestroy(TObject *Sender)
{
	ProductDataLogList.clear();	
}
//---------------------------------------------------------------------------

void __fastcall TTabletDataLogForm::TabletDataLogStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	bool tiModified = false, miModified = false, iiModified = false;

	DetailInfoMemo->Clear();
	if (ARow - 1 < 0 || ARow - 1 >= ProductDataLogList.size()) return;
	vector<TProudctDataLogListUnit>::iterator it;
	TProductData tempProductData;
	WCHAR addText[100];
	AnsiString fileName = ProductDataLogList[ARow - 1].BackupFileName;
	ReadProductData(fileName, tempProductData, MachineParams, MachineSetupData);

	if (tempProductData.TabletType != ProductData.TabletType) tiModified = true;
	if (tempProductData.TabletShape != ProductData.TabletShape) tiModified = true;
	if (tempProductData.TabletLength != ProductData.TabletLength)
	{
		WideString addText;
    wsprintfW(addText, TABLETDATALOGFORM_MEMO_ADD_06, FloatToStrF(ProductData.TabletLength, ffFixed, 10, 2), FloatToStrF(tempProductData.TabletLength, ffFixed, 10, 2));
		DetailInfoMemo->Lines->Add(addText);
	}
	if (tempProductData.TabletWidth != ProductData.TabletWidth) tiModified = true;
	if (tempProductData.TabletThick != ProductData.TabletThick) tiModified = true;
	if (tempProductData.TabletSideThick != ProductData.TabletSideThick) tiModified = true;
	if (tempProductData.EngraveType != ProductData.EngraveType) tiModified = true;
	if (tempProductData.EngravePos != ProductData.EngravePos) tiModified = true;
//	if (tempProductData.PrintBrightness != ProductData.PrintBrightness) tiModified = true;
	if (tempProductData.TabletColorCode != ProductData.TabletColorCode) tiModified = true;
	if (tempProductData.PrintColorCode != ProductData.PrintColorCode) tiModified = true;
	//int MotorSpeedList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
	//int ProductionCount;
	if (tempProductData.PlateTablet != ProductData.PlateTablet) tiModified = true;
	if (tempProductData.TabletLayerCount != ProductData.TabletLayerCount) tiModified = true;
	//TColor MultiLayeredTabletColor[MAX_TABLET_LAYER_COUNT];

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if (tempProductData.BoundaryLeft[globalCameraIndex] != ProductData.BoundaryLeft[globalCameraIndex]) iiModified = true;
		if (tempProductData.BoundaryTop[globalCameraIndex] != ProductData.BoundaryTop[globalCameraIndex]) iiModified = true;
		if (tempProductData.BoundaryRight[globalCameraIndex] != ProductData.BoundaryRight[globalCameraIndex]) iiModified = true;
		if (tempProductData.BoundaryBottom[globalCameraIndex] != ProductData.BoundaryBottom[globalCameraIndex]) iiModified = true;
		if (tempProductData.ShutterSpeed[globalCameraIndex] != ProductData.ShutterSpeed[globalCameraIndex]) iiModified = true;
		if (tempProductData.ThresholdFor3D[globalCameraIndex] != ProductData.ThresholdFor3D[globalCameraIndex]) iiModified = true;
	}

	if (tempProductData.MachineRunOption.MaxSpeedTrainingMode != ProductData.MachineRunOption.MaxSpeedTrainingMode) miModified = true;
	if (tempProductData.MachineRunOption.ManualMaxSpeed != ProductData.MachineRunOption.ManualMaxSpeed) miModified = true;
    if (tempProductData.MachineRunOption.ManualModeSensorIndex != ProductData.MachineRunOption.ManualModeSensorIndex) miModified = true;
    if (tempProductData.MachineRunOption.ManualModeSensorActiveRatio != ProductData.MachineRunOption.ManualModeSensorActiveRatio) miModified = true;	
	if (tempProductData.MachineRunOption.ManualLimitSpeed != ProductData.MachineRunOption.ManualLimitSpeed) miModified = true;
	if (tempProductData.MachineRunOption.ManualModeLimitSensorIndex != ProductData.MachineRunOption.ManualModeLimitSensorIndex) miModified = true;
	if (tempProductData.MachineRunOption.ManualModeLimitSensorActiveRatio != ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio) miModified = true;
	if (tempProductData.MachineRunOption.EmptySensorActiveRatio != ProductData.MachineRunOption.EmptySensorActiveRatio) miModified = true;
	if (tempProductData.MachineRunOption.FullSensorActiveRatio != ProductData.MachineRunOption.FullSensorActiveRatio) miModified = true;
	if (tempProductData.MachineRunOption.SuctionDisk1InverterSpeed != ProductData.MachineRunOption.SuctionDisk1InverterSpeed) miModified = true;
	if (tempProductData.MachineRunOption.SuctionDisk2InverterSpeed != ProductData.MachineRunOption.SuctionDisk2InverterSpeed) miModified = true;
	if (tempProductData.MachineRunOption.AirKnifeSpeed != ProductData.MachineRunOption.AirKnifeSpeed) miModified = true;
	if (tempProductData.StudiedSensor1Length != ProductData.StudiedSensor1Length) miModified = true;
	if (tempProductData.StudiedSensor2Length != ProductData.StudiedSensor2Length) miModified = true;
	if (tempProductData.StudiedSensorIntervalA != ProductData.StudiedSensorIntervalA) miModified = true;
	if (tempProductData.StudiedSensorIntervalB != ProductData.StudiedSensorIntervalB) miModified = true;

	if (tempProductData.NCMotorPos[0] != ProductData.NCMotorPos[0])
	{
    wsprintfW(addText, TABLETDATALOGFORM_MEMO_ADD_04, FloatToStrF(ProductData.NCMotorPos[0], ffFixed, 10, 2), FloatToStrF(tempProductData.NCMotorPos[0], ffFixed, 10, 2));
		DetailInfoMemo->Lines->Add(addText);
	}
	if (tempProductData.NCMotorPos[1] != ProductData.NCMotorPos[1])
	{
    wsprintfW(addText, TABLETDATALOGFORM_MEMO_ADD_03, FloatToStrF(ProductData.NCMotorPos[1], ffFixed, 10, 2), FloatToStrF(tempProductData.NCMotorPos[1], ffFixed, 10, 2));
		DetailInfoMemo->Lines->Add(addText);
	}
	if (tempProductData.NCMotorPos[2] != ProductData.NCMotorPos[2])
	{
    wsprintfW(addText, TABLETDATALOGFORM_MEMO_ADD_01, FloatToStrF(ProductData.NCMotorPos[2], ffFixed, 10, 2), FloatToStrF(tempProductData.NCMotorPos[2], ffFixed, 10, 2));
		DetailInfoMemo->Lines->Add(addText);
	}
	if (tempProductData.NCMotorPos[3] != ProductData.NCMotorPos[3])
	{
    wsprintfW(addText, TABLETDATALOGFORM_MEMO_ADD_02, FloatToStrF(ProductData.NCMotorPos[3], ffFixed, 10, 2), FloatToStrF(tempProductData.NCMotorPos[3], ffFixed, 10, 2));
		DetailInfoMemo->Lines->Add(addText);
	}
	if (tempProductData.NCMotorPos[4] != ProductData.NCMotorPos[4])
	{
    wsprintfW(addText, TABLETDATALOGFORM_MEMO_ADD_05, FloatToStrF(ProductData.NCMotorPos[4], ffFixed, 10, 2), FloatToStrF(tempProductData.NCMotorPos[4], ffFixed, 10, 2));
		DetailInfoMemo->Lines->Add(addText);
	}
}
//---------------------------------------------------------------------------

void __fastcall TTabletDataLogForm::RestoreButtonClick(TObject *Sender)
{
	if (MessageDlgFA(TABLETDATALOGFORM_MSG_04, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		int ARow = TabletDataLogStringGrid->Row;
		if (ARow - 1 < 0 || ARow - 1 >= ProductDataLogList.size())
		{
			ShowMessageFA(TABLETDATALOGFORM_MSG_03);
			return;
		}
		AnsiString backupFileName = ProductDataLogList[ARow - 1].BackupFileName;
		ReadProductData(backupFileName, ProductData, MachineParams, MachineSetupData);
		if (MessageDlgFA(TABLETDATALOGFORM_MSG_02, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			BackupProductData(EPDBR_DATA_RESTORE);
		}
		AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
		CopyFileA(backupFileName.c_str(), fileName.c_str(), FALSE);
		ShowMessageFA(TABLETDATALOGFORM_MSG_01);
		ModalResult = mrOk;
	}
}
//---------------------------------------------------------------------------

