//---------------------------------------------------------------------------

#ifndef TabletDataLog_FormH
#define TabletDataLog_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <ComCtrls.hpp>
#include <vector.h>

#include "Environment.h"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
typedef struct
{
	AnsiString BackupFileName;
	AnsiString OperatorName;
	double BackupDate;
	int BackupReason;
	bool TabletInfoModified;
	bool MachineInfoModified;
	bool InspectionInfoModified;
} TProudctDataLogListUnit;
//---------------------------------------------------------------------------
class TTabletDataLogForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntPanel *Panel2;
	TTntStringGrid *TabletDataLogStringGrid;
	TTntPanel *Panel3;
	TTntPanel *Panel4;
	TTntPanel *Panel5;
	TTntButton *Button1;
	TTntButton *RestoreButton;
	TTntMemo *DetailInfoMemo;
	TTntPanel *Panel6;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall TabletDataLogStringGridSelectCell(TObject *Sender,
          int ACol, int ARow, bool &CanSelect);
	void __fastcall RestoreButtonClick(TObject *Sender);
private:	// User declarations
	vector<TProudctDataLogListUnit> ProductDataLogList;

	void __fastcall SearchProductDataLog(void);
	void __fastcall UpdateProductDataLogStringGrid(void);
	WideString __fastcall GetBackupReasonString(EProductDataBackupReason reason);
public:		// User declarations
	__fastcall TTabletDataLogForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TTabletDataLogForm *TabletDataLogForm;
//---------------------------------------------------------------------------
#endif
