//---------------------------------------------------------------------------

#ifndef ThreeDImageViewer_FormH
#define ThreeDImageViewer_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <GL/glu.h>
//---------------------------------------------------------------------------
class TThreeDImageViewerForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *ImagePanel;
	TTntPanel *Panel1;
	TTntButton *PositionResetButton;
	TTntButton *CloseButton;
	TTntButton *DefectAreaButton;
	TTimer *RedrawTimer;
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormActivate(TObject *Sender);
	void __fastcall ImagePanelMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall ImagePanelMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
	void __fastcall FormPaint(TObject *Sender);
	void __fastcall PositionResetButtonClick(TObject *Sender);
	void __fastcall DefectAreaButtonClick(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);
	void __fastcall RedrawTimerTimer(TObject *Sender);
	void __fastcall FormHide(TObject *Sender);
private:	// User declarations
	HDC	GHDC;
	HGLRC GLRC;
	GLfloat Angle, Angle2;
	int StartX, StartY;
	unsigned char colorB, colorG, colorR;
	bool ShowDefectArea;

	bool __fastcall SetupPixelFormat(HDC hdc);
	void __fastcall RedrawGL(void);
public:		// User declarations
	void __fastcall Set3DImage(Graphics::TBitmap *bitmap,
		unsigned char tabletColorB, unsigned char tabletColorG, unsigned char tabletColorR,
		int defectLeft, int defectTop, int defectRight, int defectBottom);
	__fastcall TThreeDImageViewerForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TThreeDImageViewerForm *ThreeDImageViewerForm;
//---------------------------------------------------------------------------
#endif
