//---------------------------------------------------------------------------

#ifndef ThreeDLineScanFrequencyStudy_FormH
#define ThreeDLineScanFrequencyStudy_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>

#include "Environment.h"
#include "Keyboard_Form.h"
#include "command.h"
#include "common.h"
#include "MotorSetting_Form.h"
#include "IOSetting_Form.h"
#include "MotorSpeedSelection_Form.h"
#include "Keyboard_Form.h"
#include "Message_Form.h"
#include "MultiLanguage.h"
#include "TntExtCtrls.hpp"
#include <Graphics.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include <ComCtrls.hpp>
#include <Grids.hpp>

#define MIN_VALID_DISK_PERCENTAGE 20
#define MAX_VALID_DISK_PERCENTAGE 200

#define MAX_LABEL_COUNT 2000
#define MAX_MOTOR_SPEED_PERCENTAGE  350
//---------------------------------------------------------------------------
class TThreeDLineScanFrequencyStudyForm : public TTntForm
{
__published:	// IDE-managed Components
  TPanel *Panel3;
  TLabel *HelpLabel1;
  TLabel *HelpLabel2;
  TPanel *Panel1;
  TButton *CloseButton;
  TLabel *HelpLabel3;
  TGroupBox *GroupBox1;
  TButton *MachineRunBtn;
  TButton *MachineStopBtn;
  TGroupBox *GroupBox2;
  TLabel *Label4;
  TLabel *Label5;
  TLabel *Label2;
  TLabel *Label3;
  TLabel *Disk1ExpectedRPMLabel;
  TLabel *Disk1RealRPMLabel;
  TLabel *Disk2ExpectedRPMLabel;
  TLabel *Disk2RealRPMLabel;
  TGroupBox *GroupBox3;
  TLabel *Label10;
  TLabel *DiskSpeedPercentageLabel;
  TLabel *Label12;
  TEdit *DiskMinSpeedEdit;
  TLabel *Label13;
  TEdit *DiskMaxSpeedEdit;
  TLabel *Label14;
  TLabel *Label15;
  TLabel *Label6;
  TTimer *MotorSpeedControlTimer;
  TTimer *MachineStatusTimer;
  TPanel *ReadyPanel;
  TPanel *Panel2;
  TTimer *CaptureTimer;
  TLabel *Label7;
  TEdit *TabletLengthEdit;
  TLabel *Label8;
  TGroupBox *GroupBox4;
  TLabel *Label16;
  TLabel *Label17;
  TLabel *SD1StdLSFLabel;
  TLabel *SD2StdLSFLabel;
  TLabel *Disk1SpeedLabel;
  TLabel *Disk2SpeedLabel;
  TLabel *SD2CurrentLSFLabel;
  TLabel *SD1CurrentLSFLabel;
  TLabel *Label22;
  TLabel *Label23;
  TGroupBox *GroupBox5;
  TLabel *Label9;
  TLabel *MortorStatusLabel;
  TLabel *CameraStatusLabel;
  TLabel *Label19;
  TLabel *Label11;
  TEdit *LSFRangeEdit;
  TLabel *Label18;
  TEdit *LSFShfitEdit;
  TPageControl *PageControl1;
  TTabSheet *TabSheet1;
  TTabSheet *TabSheet2;
  TStringGrid *Disk2LSFTableStringGrid;
  TStringGrid *Disk1LSFTableStringGrid;
  TGroupBox *GroupBox6;
  TLabel *SD1ParamsLabel;
  TImage *SD1ThreeDImage;
  TTntShape *sd1ImageRefresh;
  TLabel *SD2ParamsLabel;
  TImage *SD2ThreeDImage;
  TTntShape *sd2ImageRefresh;
  TGroupBox *GroupBox7;
  TImage *SD1BestCaseThreeDImage;
  TImage *SD2BestCaseThreeDImage;
  TLabel *SD1BestParamsLabel;
  TLabel *SD2BestParamsLabel;
  TLabel *SD1MatchingRateLabel;
  TLabel *SD2MatchingRateLabel;
  TButton *Button1;
  TImage *Image1;
  TTabSheet *TabSheet3;
  TButton *LoadResultButton;
  TImage *SD1ResultImage;
  TImage *SD2ResultImage;
  TImage *ModelingImage;
  TGroupBox *GroupBox8;
  TCheckBox *CheckBox1;
  TCheckBox *CheckBox2;
  TCheckBox *CheckBox3;
  TStringGrid *ResultStringGrid;
  TPanel *Panel4;
  TImage *LSFResultImage;
  TLabel *Label20;
  TLabel *Label1;
  TButton *ApplyLSFModelBtn;
  TCheckBox *StudyResultTestCheckBox;
  TCheckBox *SystemParamsCheckBox;
  void __fastcall DiskMinSpeedEditKeyPress(TObject *Sender, char &Key);
  void __fastcall DiskMinSpeedEditClick(TObject *Sender);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall MachineRunBtnClick(TObject *Sender);
  void __fastcall MachineStopBtnClick(TObject *Sender);
  void __fastcall MotorSpeedControlTimerTimer(TObject *Sender);
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall MachineStatusTimerTimer(TObject *Sender);
  void __fastcall CaptureTimerTimer(TObject *Sender);
  void __fastcall TabletLengthEditClick(TObject *Sender);
  void __fastcall LSFRangeEditClick(TObject *Sender);
  void __fastcall LSFShfitEditClick(TObject *Sender);
  void __fastcall LSFRangeEditKeyPress(TObject *Sender, char &Key);
  void __fastcall Button1Click(TObject *Sender);
  void __fastcall LoadResultButtonClick(TObject *Sender);
  void __fastcall CheckBox1Click(TObject *Sender);
  void __fastcall ResultStringGridSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
  void __fastcall ApplyLSFModelBtnClick(TObject *Sender);
  void __fastcall StudyResultTestCheckBoxClick(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
private:	// User declarations
  void __fastcall RefreshDiskSpeed(int DiskPercentage, float Disk1ExpectedRPM, float Disk1RealRPM, float Disk2ExpectedRPM, float Disk2RealRPM);
  void __fastcall RefreshComponentStatus(bool machineActive);
  void __fastcall RunMotor();
  bool __fastcall SendSPBCaptureSetupForStudy(unsigned int globalCamMask, float tabletHalfLength, int *shutterSpeedList, int disk1TargetSpeed, int disk1BaseSpeed,
                                                                        int disk2TargetSpeed, int disk2BaseSpeed, int TestSubsamplingMode, int option, int frameBufferCount, int triggerFreq_SD1, int triggerFreq_SD2);

  void __fastcall RefreshLSFValue(int DiskPercentage, int Disk1StdLSF, int Disk2StdLSF, int Disk1LSF, int Disk2LSF);
  void __fastcall SetBlankImage(TImage *dstImage, int option);
  void __fastcall RefreshCameraInfo(int cameraIndex);
  int __fastcall GetThreeDImageInfo(TImage *DestImage);
  int __fastcall LabellingForTabletImage(short *label_Image, unsigned char *smallSizeBinaryImage, int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);
  bool __fastcall ReadDiskLSFTable(AnsiString fileName);
  bool __fastcall WriteDiskLSFTable(AnsiString fileName);
  void __fastcall MakeDefaultTable(TStringGrid *tempGrid);
  void __fastcall SetTableValue(TStringGrid *tempGrid, int *value, bool All);
  void __fastcall CurrentCheckingPosDisplay(TStringGrid *tempGrid);
  void __fastcall LSFModelingFunc();
  void __fastcall ViewStudyResult(bool bNavigatorSW, int nX, int nY);
  void __fastcall SetResultTable(bool Default);

  int currentSpeed;
  int firstSpeed;
  bool bMotorStop;
  bool cleaningWaitingSW;
  bool bCaptureSW;
  bool bThreeDLSFStudySW;
  bool bSetCaptureCommandSW;

  float Disk1prevRealRPM;
  float Disk2prevRealRPM;

  float Disk1IncreaseRPM;
  float Disk2IncreaseRPM;

  bool bRPMIncreaseWaitingSW;
  double checkTimeForMaximumIncrease;
  double checkTimeForInActive;
  double captureStartTime;
  double motorSpeedIncreaseTime;

  int FirstThreeDCameraIndex;
  int SecondThreeDCameraIndex;
  int SD1StandardLineScanFrq, SD2StandardLineScanFrq;

  int SD1MinLSF, SD2MinLSF;
  int SD1MaxLSF, SD2MaxLSF;
  
  int SD1LSFPosition, SD2LSFPosition;

  int LSFCheckComplete[SYSTEM_TOTAL_CAMERA_COUNT];

  unsigned char CaptureData[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
  unsigned char ThreeDImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
  unsigned char ShapeBinaryImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
  unsigned char smallBinaryImage[(SYSTEM_CAMERA_WIDTH / 2) * (SYSTEM_CAMERA_HEIGHT / 2)];
  short HalfLabelImage[(SYSTEM_CAMERA_WIDTH / 2) * (SYSTEM_CAMERA_HEIGHT / 2)];

  int SD1LineScanFrequencyTable[MAX_MOTOR_SPEED];
  int SD2LineScanFrequencyTable[MAX_MOTOR_SPEED];
  int LSFModelingTable[MAX_MOTOR_SPEED];
  int modelingCount[MAX_MOTOR_SPEED];

  int SD1MaxMatchingValue;
  int SD2MaxMatchingValue;
  int SD1BestMatchingLSF;
  int SD2BestMatchingLSF;

  int globalDefaultLSFRange;

  int globalLSFMaxValue;

public:		// User declarations
  __fastcall TThreeDLineScanFrequencyStudyForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TThreeDLineScanFrequencyStudyForm *ThreeDLineScanFrequencyStudyForm;
//---------------------------------------------------------------------------
#endif
