//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, Ϸ
// Camera Index  CPB ˰   
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ThreeDPrintMask_Form.h"
#include "Keyboard_Form.h"    
#include "MultiLanguage.h"
#include "Environment.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TThreeDPrintMaskForm *ThreeDPrintMaskForm;
//---------------------------------------------------------------------------
__fastcall TThreeDPrintMaskForm::TThreeDPrintMaskForm(TComponent* Owner)
  : TForm(Owner)
{
  if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
}
//---------------------------------------------------------------------------
void __fastcall TThreeDPrintMaskForm::FormActivate(TObject *Sender)
{
  memcpy(&dstTabletSetupData, srcTabletSetupData, sizeof(TTabletSetupData));

  memcpy(MaskImage[0][0], srcTabletSetupData->ThreeDExceptEngraveData[0][0],640 * 480);
  memcpy(MaskImage[0][1], srcTabletSetupData->ThreeDExceptEngraveData[0][1],640 * 480);
  memcpy(MaskImage[1][0], srcTabletSetupData->ThreeDExceptEngraveData[1][0],640 * 480);
  memcpy(MaskImage[1][1], srcTabletSetupData->ThreeDExceptEngraveData[1][1],640 * 480);

  imageClick = false;

  brushType = BRUSH_DRAW;

  GroupBox1->DoubleBuffered = true;

  CurrentDisk = CurrentPrint = -1;

  maskSize = 4;

  BitBtn7->Caption = THREED_PRINT_MASK_FORM_BUTTON_01;
  TntBitBtn1->Caption = THREED_PRINT_MASK_FORM_BUTTON_02;
  TntBitBtn2->Caption = THREED_PRINT_MASK_FORM_BUTTON_03;
  TntBitBtn3->Caption = THREED_PRINT_MASK_FORM_BUTTON_04;
  Button2->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_14;
  Button1->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_20;
  Button3->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_23;
  modeBtn->Caption = TABLETCHARACTEREXTRACTFORM_GROUPBOX_CAPTION_15;
  RadioButton1->Caption = TABLETCHARACTEREXTRACTFORM_BUTTON_CAPTION_02;
  RadioButton2->Caption = TABLETCHARACTEREXTRACTFORM_BUTTON_CAPTION_05 ;
  Label1->Caption = GRADESETTING_TEXT_CAPTION_07;
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::ShowMaskImage()
{
  memset(tempImage, 0, 640 * 480);

  int n;
  int tempX, tempY;
  int tempAddress;
  int m;

  for(n = 0; n < srcTablet3DSetupData->printLabelCount[CurrentDisk][CurrentPrint]; n++)
  {
    for(m = 0; m < srcTablet3DSetupData->printLabelDataCnt[CurrentDisk][CurrentPrint][n]; m++)
    {
      tempX = srcTablet3DSetupData->printLabelData[CurrentDisk][CurrentPrint][n][m][0];
      tempY = srcTablet3DSetupData->printLabelData[CurrentDisk][CurrentPrint][n][m][1];

      tempAddress = 640 * tempY + tempX;

      tempImage[tempAddress] = 255;
    }

    for(m = 0; m < srcTablet3DSetupData->printLabelDataCntForExpandMasking[CurrentDisk][CurrentPrint][n]; m++)
    {
      tempX = srcTablet3DSetupData->printLabelDataForExpandMasking[CurrentDisk][CurrentPrint][n][m][0];
      tempY = srcTablet3DSetupData->printLabelDataForExpandMasking[CurrentDisk][CurrentPrint][n][m][1];

      tempAddress = 640 * tempY + tempX;

      tempImage[tempAddress] = 255;
    }
  }

  int x, y;

  for(y = 0; y < 480; y++)
  {
    for(x = 0; x < 640; x++)
    {
      tempAddress = 640 * y + x;

      if(MaskImage[CurrentDisk][CurrentPrint][tempAddress] == 255)
      {
        tempImage[tempAddress]= 128;
      }
      else if(MaskImage[CurrentDisk][CurrentPrint][tempAddress] == 128)
      {
        tempImage[tempAddress]= 64;
      }
    }
  }

  memset(extensionImage, 0, 640 * 2 * 480 * 2 * 3);

  int tempAddress2;

  for(y = 0; y < 480; y++)
  {
    for(x = 70; x < 570; x++)
    {
      tempAddress = 640 * y + x;

      if(tempImage[tempAddress] == 255)
      {
        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;
      }
      else if(tempImage[tempAddress] == 128 || tempImage[tempAddress] == 64)
      {
        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;
      }
    }
  }


  Graphics::TBitmap *sImage = new Graphics::TBitmap;
  sImage->Width = 640 * 2;
  sImage->Height = 480 * 2;
  sImage->PixelFormat = pf24bit;

  Byte *ptr;

  int i, j;

  for(y = 0; y < 480 * 2; y++)
  {
    ptr = (Byte*) sImage->ScanLine[y];
    for(x = 0; x < 640 * 2; x++)
    {
      tempAddress = 1280 * y + x;

      ptr[3*x + 0] = extensionImage[tempAddress * 3 + 0];
      ptr[3*x + 1] = extensionImage[tempAddress * 3 + 1];
      ptr[3*x + 2] = extensionImage[tempAddress * 3 + 2];
    }
  }

  Image1->Picture->Bitmap->Assign(sImage);
  Image1->Repaint();

  delete sImage;
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::TntBitBtn3Click(TObject *Sender)
{
  TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;

  if(theSpeedButton->Tag == 0)
  {
    CurrentDisk = 0;
    CurrentPrint = 0;
  }
  else if(theSpeedButton->Tag == 1)
  {
    CurrentDisk = 0;
    CurrentPrint = 1;
  }
  else if(theSpeedButton->Tag == 2)
  {
    CurrentDisk = 1;
    CurrentPrint = 0;
  }
  else if(theSpeedButton->Tag == 3)
  {
    CurrentDisk = 1;
    CurrentPrint = 1;
  }

  ShowMaskImage();
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::Button2Click(TObject *Sender)
{
  if(CurrentDisk >= 0 && CurrentPrint >= 0 && CurrentDisk < 2 && CurrentPrint < 2)
  {
    memset(MaskImage[CurrentDisk][CurrentPrint], 0, 640 * 480);
  	ShowMaskImage();
  }
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::Button1Click(TObject *Sender)
{
  saveFlag = true;
  
  memcpy(dstTabletSetupData.ThreeDExceptEngraveData[0][0], MaskImage[0][0], 640 * 480);
  memcpy(dstTabletSetupData.ThreeDExceptEngraveData[0][1], MaskImage[0][1], 640 * 480);
  memcpy(dstTabletSetupData.ThreeDExceptEngraveData[1][0], MaskImage[1][0], 640 * 480);
  memcpy(dstTabletSetupData.ThreeDExceptEngraveData[1][1], MaskImage[1][1], 640 * 480);

  this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::RadioButton1Click(TObject *Sender)
{
  if(RadioButton1->Checked)
  {
    brushType = BRUSH_DRAW;
  }
  else if(RadioButton2->Checked)
  {
    brushType = BRUSH_ERASE;
  }  
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::Image1MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  imageClick = true;

  if(imageClick && brushType != BRUSH_NONE)
  {
    if(brushType == BRUSH_DRAW)
      ImageMaskingDrawMode(X, Y);
    else if(brushType == BRUSH_ERASE)
      ImageMaskingEraseMode(X, Y);
  }

  LoadPrintData();
  cursorDisplay(X, Y);
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::Image1MouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
  if(imageClick && brushType != BRUSH_NONE)
  {
    if(brushType == BRUSH_DRAW)
      ImageMaskingDrawMode(X, Y);
    else if(brushType == BRUSH_ERASE)
      ImageMaskingEraseMode(X, Y);
  }

  LoadPrintData();
  cursorDisplay(X, Y);
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::Image1MouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  imageClick = false;
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::cursorDisplay(int x, int y)
{
  int startX, endX, startY, endY;

  maskSize = StrToInt(Edit1->Text);
  
  startX = (x - maskSize);
  endX = (x + maskSize);
  startY = (y - maskSize);
  endY = (y + maskSize);

  Image1->Canvas->Pen->Width = 1;
  Image1->Canvas->Pen->Color = clGreen;
  Image1->Canvas->Brush->Style = bsClear;
  Image1->Canvas->Rectangle(startX, startY, endX, endY);
  Image1->Repaint();
}

//---------------------------------------------------------------------------
void __fastcall TThreeDPrintMaskForm::LoadPrintData()
{
  memset(extensionImage, 0, 640 * 2 * 480 * 2 * 3);

  int x, y;
  int tempAddress;
  int tempAddress2;

  for(y = 0; y < 480; y++)
  {
    for(x = 70; x < 570; x++)
    {
      tempAddress = 640 * y + x;

      if(tempImage[tempAddress] == 255)
      {
        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 255;
        extensionImage[tempAddress2 * 3 + 1] = 255;
        extensionImage[tempAddress2 * 3 + 2] = 255;
      }
      else if(tempImage[tempAddress] == 128 || tempImage[tempAddress] == 64)
      {
        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 0);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 0) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;

        tempAddress2 = 1280 * (y * 2 + 1) + ((x - 70) * 2 + 1);

        extensionImage[tempAddress2 * 3 + 0] = 0;
        extensionImage[tempAddress2 * 3 + 1] = 0;
        extensionImage[tempAddress2 * 3 + 2] = 255;
      }
    }
  }

  Graphics::TBitmap *sImage = new Graphics::TBitmap;
  sImage->Width = 640 * 2;
  sImage->Height = 480 * 2;
  sImage->PixelFormat = pf24bit;

  Byte *ptr;

  int i, j;

  for(y = 0; y < 480 * 2; y++)
  {
    ptr = (Byte*) sImage->ScanLine[y];
    for(x = 0; x < 640 * 2; x++)
    {
      tempAddress = 1280 * y + x;

      ptr[3*x + 0] = extensionImage[tempAddress * 3 + 0];
      ptr[3*x + 1] = extensionImage[tempAddress * 3 + 1];
      ptr[3*x + 2] = extensionImage[tempAddress * 3 + 2];
    }
  }

  Image1->Picture->Bitmap->Assign(sImage);
  Image1->Repaint();

  delete sImage;
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::ImageMaskingDrawMode(int x, int y)
{
  int startX, endX, startY, endY;
  int i, j;
  int tempAddress;
  int tempAddress2;

  maskSize = StrToInt(Edit1->Text);
  
  startX = (x - maskSize) / 2;
  endX = (x + maskSize) / 2;
  startY = (y - maskSize) / 2;
  endY = (y + maskSize) / 2;

  if(startX < 0)
    startX = 0;
  if(endX > 640)
    endX = 640;
  if(startY < 0)
    startY = 0;
  if(endY > 480)
    endY = 480;

  for(j = startY; j <= endY; j++)
  {
    for(i = startX; i <= endX; i++)
    {
      tempAddress = 640 * j + (i + 70);
      if(tempImage[tempAddress] == 255)
      {
        tempImage[tempAddress] = 128;

        MaskImage[CurrentDisk][CurrentPrint][tempAddress] = 255;
      }
      else if(tempImage[tempAddress] == 0)
      {
        tempImage[tempAddress] = 64;

        MaskImage[CurrentDisk][CurrentPrint][tempAddress] = 128;
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::ImageMaskingEraseMode(int x, int y)
{
  int startX, endX, startY, endY;
  int i, j;
  int tempAddress;
  int tempAddress2;

  maskSize = StrToInt(Edit1->Text);
  
  startX = (x - maskSize) / 2;
  endX = (x + maskSize) / 2;
  startY = (y - maskSize) / 2;
  endY = (y + maskSize) / 2;
  
  if(startX < 0)
    startX = 0;
  if(endX > 640)
    endX = 640;
  if(startY < 0)
    startY = 0;
  if(endY > 480)
    endY = 480;

  for(j = startY; j <= endY; j++)
  {
    for(i = startX; i <= endX; i++)
    {
      tempAddress = 640 * j + (i + 70);
      if(tempImage[tempAddress] == 128)
      {
        tempImage[tempAddress] = 255;

        MaskImage[CurrentDisk][CurrentPrint][tempAddress] = 0;
      }
      else if(tempImage[tempAddress] == 64)
      {
        tempImage[tempAddress] = 0;

        MaskImage[CurrentDisk][CurrentPrint][tempAddress] = 0;
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TThreeDPrintMaskForm::Edit1Click(TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *)Sender;

  KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    if(StrToInt(KeyboardForm->Text) < 1)
      KeyboardForm->Text = "1";
    else if(StrToInt(KeyboardForm->Text) > 10)
      KeyboardForm->Text = "10";

    theEdit->Text = KeyboardForm->Text;

    maskSize = StrToInt(theEdit->Text);
  }
}
//---------------------------------------------------------------------------

void __fastcall TThreeDPrintMaskForm::Button3Click(TObject *Sender)
{
  saveFlag = false;

  this->Close();  
}
//---------------------------------------------------------------------------

