//---------------------------------------------------------------------------

#ifndef ThreeDPrintMask_FormH
#define ThreeDPrintMask_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "processing.h"
#include <ExtCtrls.hpp>
#include "TntButtons.hpp"
#include <Buttons.hpp>
#include "TntStdCtrls.hpp"

#define BRUSH_NONE 0
#define BRUSH_DRAW 1
#define BRUSH_ERASE 2
//---------------------------------------------------------------------------
class TThreeDPrintMaskForm : public TForm
{
__published:	// IDE-managed Components
  TTntBitBtn *BitBtn7;
  TTntBitBtn *TntBitBtn1;
  TTntBitBtn *TntBitBtn2;
  TTntBitBtn *TntBitBtn3;
  TButton *Button1;
  TButton *Button2;
  TGroupBox *modeBtn;
  TTntRadioButton *RadioButton1;
  TTntRadioButton *RadioButton2;
  TGroupBox *GroupBox1;
  TImage *Image1;
  TLabel *Label1;
  TEdit *Edit1;
  TButton *Button3;
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall TntBitBtn3Click(TObject *Sender);
  void __fastcall Button2Click(TObject *Sender);
  void __fastcall Button1Click(TObject *Sender);
  void __fastcall RadioButton1Click(TObject *Sender);
  void __fastcall Image1MouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall Image1MouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall Image1MouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall Edit1Click(TObject *Sender);
  void __fastcall Button3Click(TObject *Sender);
private:	// User declarations
  void __fastcall ShowMaskImage();
  void __fastcall cursorDisplay(int x, int y);
  void __fastcall LoadPrintData();
  void __fastcall ImageMaskingDrawMode(int x, int y);
  void __fastcall ImageMaskingEraseMode(int x, int y);

  bool imageClick;
  unsigned char MaskImage[2][2][640 * 480]; // [disk][print]

  unsigned char tempImage[640 * 480];
public:		// User declarations
  TTablet3DSetupData *srcTablet3DSetupData;
  TTabletSetupData *srcTabletSetupData;
  TTabletSetupData dstTabletSetupData;

  bool saveFlag;
  int CurrentDisk;
  int CurrentPrint;
  int brushType;
  int maskSize;

  unsigned char extensionImage[640 * 2 * 480 * 2 * 3];

  __fastcall TThreeDPrintMaskForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TThreeDPrintMaskForm *ThreeDPrintMaskForm;
//---------------------------------------------------------------------------
#endif
