//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "USBMessage_Form.h"
#include "Message_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TUSBMessageForm *USBMessageForm;
//---------------------------------------------------------------------------
__fastcall TUSBMessageForm::TUSBMessageForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  IgnoreButton->Caption = USBMESSAGEFORM_BUTTON_CAPTION_01;
  Button1->Caption = USBMESSAGEFORM_BUTTON_CAPTION_02;
  CancelButton->Caption = USBMESSAGEFORM_BUTTON_CAPTION_03;

  Label5->Caption = USBMESSAGEFORM_LABEL_CAPTION_01;
	Label3->Caption = USBMESSAGEFORM_LABEL_CAPTION_02;
	Label2->Caption = USBMESSAGEFORM_LABEL_CAPTION_03;
	Label1->Caption = USBMESSAGEFORM_LABEL_CAPTION_04;

}
//---------------------------------------------------------------------------
int __fastcall TUSBMessageForm::ShowMessage(AnsiString boardName, AnsiString message)
{
	BoardNameLabel->Caption = WideString(boardName);
	ErrorMessageLabel->Caption = WideString(message);
	return this->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TUSBMessageForm::IgnoreButtonClick(TObject *Sender)
{
	if (MessageDlgFA(USBMESSAGEFORM_MSG_01, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		ModalResult = mrIgnore;
	}
}
//---------------------------------------------------------------------------

void __fastcall TUSBMessageForm::FormCreate(TObject *Sender)
{
		IgnoreButton->Visible = true;
		CancelButton->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TUSBMessageForm::SetPacketHeader(TUSBDataHeader *txHeader, TUSBDataHeader *rxHeader)
{
  WCHAR TempString[100];

  wsprintfW(TempString, L"0x%X", txHeader->Header);
  TXHeaderLabel->Caption = TempString;

  wsprintfW(TempString, L"[%c][%c]", (txHeader->Command >> 8) & 0xFF, (txHeader->Command >> 0) & 0xFF);
  TXCommandLabel->Caption = TempString;

  wsprintfW(TempString, L"%d", txHeader->RequestKind);
  TXRequestKindLabel->Caption = TempString;

  wsprintfW(TempString, L"%d", txHeader->SmallDataLength);
  TXSmallLengthLabel->Caption = TempString;

  wsprintfW(TempString, L"%d", txHeader->LargeDataLength);
  TXLargeLengthLabel->Caption = TempString;



  wsprintfW(TempString, L"0x%X", rxHeader->Header);
  RXHeaderLabel->Caption = TempString;

  wsprintfW(TempString, L"[%c][%c]", (rxHeader->Command >> 8) & 0xFF, (rxHeader->Command >> 0) & 0xFF);
  RXCommandLabel->Caption = TempString;

  wsprintfW(TempString, L"%d", rxHeader->RequestKind);
  RXRequestKindLabel->Caption = TempString;

  wsprintfW(TempString, L"%d", rxHeader->SmallDataLength);
  RXSmallLengthLabel->Caption = TempString;

  wsprintfW(TempString, L"%d", rxHeader->LargeDataLength);
  RXLargeLengthLabel->Caption = TempString;
}
//---------------------------------------------------------------------------


void __fastcall TUSBMessageForm::TntFormActivate(TObject *Sender)
{  
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
    SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
    SetForegroundWindow(Handle);
}
//---------------------------------------------------------------------------

