//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "USBTest_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TUSBTestForm *USBTestForm;
//---------------------------------------------------------------------------
__fastcall TUSBTestForm::TUSBTestForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");

	//TestUSBConnection = NULL;
	TestCommIndex = 0xFF;

    bLoopTransfer = false;
}
//---------------------------------------------------------------------------
void __fastcall TUSBTestForm::sbBoardClick(TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	int boardIndex = theSpeedButton->Tag;
    if (boardIndex == 16)
    {
		//TestUSBConnection = &HCBConnection;
		TestCommIndex = COMM_HCB;
    }
    else
    {
		//TestUSBConnection = &(SPBConnection[boardIndex]);
		TestCommIndex = COMM_SPB + boardIndex;
    }

    TestPanel->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TUSBTestForm::btnRepeatShortDataClick(TObject *Sender)
{
	int transCount = 0;
    int errorCount = 0;
    AnsiString errorMsg;
    unsigned int startTime;
    unsigned int spendSpeed;
	if (bLoopTransfer)
    {
    	bLoopTransfer = false;
    }
    else
    {
		bLoopTransfer = true;
    }
    startTime = GetTickCount();

    int sendNum = 0;
    int receivedNum;

    //TUSBConnection *theUSBConnection = TestUSBConnection;

    while (bLoopTransfer)
    {
        sendNum++;
		transCount++;

		if (!Comm_Request(TestCommIndex, CMD_ECHO, &sendNum, 4, &receivedNum, 4))
		{
			//errorMsg = theUSBConnection->GetLastErrorMessage();
			//LogMemo->Lines->Add(errorMsg);
		}

		if (sendNum != receivedNum) errorCount++;
		if (transCount % 10 == 0)
		{
			unsigned int currentTime = GetTickCount();
			if (currentTime > startTime)
			{
        WCHAR TempString[100];
        wsprintfW(TempString, USBTESTFORM_LABEL_CAPTION_01, transCount, transCount * 1000 / (currentTime - startTime), FloatToStrF((float)errorCount * 100 / transCount, ffFixed, 10, 2));
        Label1->Caption = TempString;

				//Label1->Caption = IntToStr(transCount) + "ȸ  Ϸ " + "<1ʴ  Ƚ = " + IntToStr(transCount * 1000 / (currentTime - startTime))
				// + " > <  = " + FloatToStr((float)errorCount * 100 / transCount) + "% >";
			}
			Application->ProcessMessages();
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TUSBTestForm::btnRepeatLongDataClick(TObject *Sender)
{
	int num = 0;
	int transCount = 0;
	int errorCount = 0;
	unsigned int time;
	unsigned int startTime;
	unsigned int sendDelay;
    unsigned int receiveDelay;
    unsigned int meanSendDelay;
    unsigned int meanReceiveDelay;
    AnsiString errorMsg;
	if (bLoopTransfer)
    {
    	bLoopTransfer = false;
    }
    else
    {
		bLoopTransfer = true;
    }
    startTime = GetTickCount();
    unsigned int timeDelay = 0;
    unsigned int throughput;

    char long_text[95 * 1024];
    char received_text[95 * 1024];

    //TUSBConnection *theUSBConnection = TestUSBConnection;

    while (bLoopTransfer)
    {
        num = (num + 1) % 1000;
        transCount++;
        
	    int randomValue = random(GetTickCount());
	    for (int i = 0; i < 95 * 1024 - 1; i++)
	    {
	        long_text[i] = 'a' + (randomValue + i) % 26;
	    }
		long_text[95 * 1024 - 1] = '\0';

        time = GetTickCount();
		//if (!theUSBConnection->RequestCommandEx(CMD_ECHO, NULL, 0, long_text, 95 * 1024,
	    //	received_text, 95 * 1024))
//		if (!Comm_RequestEx(TestCommIndex, CMD_ECHO, NULL, 0, long_text, 95 * 1024,
//			received_text, 95 * 1024))
		if (!Comm_RequestEx(TestCommIndex, CMD_ECHO, long_text, 95 * 1024, NULL, 0,
			received_text, 95 * 1024))
	    {
			//errorMsg = theUSBConnection->GetLastErrorMessage();
			//LogMemo->Lines->Add(errorMsg);
	    }
        timeDelay += (GetTickCount() - time);

		bool bCheck = true;
        char *pOrg = long_text;
        char *pRet = received_text;
	    for (int i = 0; i < 95 * 1024; i++)
	    {
			if (long_text[i] != received_text[i])
	        {
				bCheck = false;
	            break;
	        }
	    }
	    if (!bCheck)
	    {
        	errorCount++;
	    }

//        if (transCount % 10 == 0)
        {
			if (timeDelay / 1000 > 0)
            {
            	throughput = transCount * 2 * 95 / ((double)timeDelay / 1000);
              WCHAR TempString[100];
              wsprintfW(TempString, USBTESTFORM_LABEL_CAPTION_03, transCount, throughput, FloatToStrF((float)errorCount / transCount * 100, ffFixed, 10, 2));
              Label1->Caption = TempString;
				      //Label1->Caption = IntToStr(transCount) + "ȸ  Ϸ " + "<Throughput = " + IntToStr(throughput) +
              //  	"Kbytes/sec > <  = " + FloatToStr((float)errorCount / transCount * 100) + "% >";
            }
            Application->ProcessMessages();
        }
    }	
}
//---------------------------------------------------------------------------
void __fastcall TUSBTestForm::btnRepeatHugeDataClick(TObject *Sender)
{
	int num = 0;
    int transCount = 0;
    int errorCount = 0;
    unsigned int time;
    unsigned int startTime;
    unsigned int sendDelay;
    unsigned int receiveDelay;
    unsigned int meanSendDelay;
    unsigned int meanReceiveDelay;
    AnsiString errorMsg;
	if (bLoopTransfer)
    {
    	bLoopTransfer = false;
    }
    else
    {
		bLoopTransfer = true;
    }
    startTime = GetTickCount();
    unsigned int timeDelay = 0;
    unsigned int throughput;

    unsigned char *long_text = new char[4 * 1024 * 1024];
    unsigned char *received_text = new char[4 * 1024 * 1024];

	//TUSBConnection *theUSBConnection = TestUSBConnection;

	while (bLoopTransfer)
	{
		num = (num + 1) % 1000;
		transCount++;

		//int randomValue = random(GetTickCount());
		int randomValue = 0;
		for (int i = 0; i < 4 * 1024 * 1024 - 1; i++)
		{
			long_text[i] = (randomValue + i) & 0xFF;
		}
		long_text[4 * 1024 * 1024 - 1] = '\0';

		time = GetTickCount();
		if (!Comm_RequestEx(TestCommIndex, CMD_ECHO, NULL, 0, long_text, 4 * 1024 * 1024 - 4,
			received_text, 4 * 1024 * 1024 - 4))
		{
			//errorMsg = theUSBConnection->GetLastErrorMessage();
			//LogMemo->Lines->Add(errorMsg);
		}
		timeDelay += (GetTickCount() - time);

		bool bCheck = true;
		char *pOrg = long_text;
		char *pRet = received_text;
		for (int i = 0; i < 4 * 1024 * 1024 - 4; i++)
	    {
			if (long_text[i] != received_text[i])
	        {
				bCheck = false;
	            break;
	        }
	    }
	    if (!bCheck)
		{
        	errorCount++;
	    }

//        if (transCount % 10 == 0)
        {
			if (timeDelay / 1000 > 0)
            {
            	throughput = transCount * 8 * 1024 / ((double)timeDelay / 1000);
				Label1->Caption = IntToStr(transCount) + "ȸ  Ϸ " + "<Throughput = " + IntToStr(throughput) +
                	"Kbytes/sec > <  = " + FloatToStr((float)errorCount / transCount * 100) + "% >";
            }
            Application->ProcessMessages();
        }
    }

    delete[] long_text;
    delete[] received_text;	
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::DeviceRecoverButtonClick(TObject *Sender)
{
	//TUSBConnection *theUSBConnection = TestUSBConnection;
	//if (!theUSBConnection->RecoverDevice())
	if (!Comm_Recover(TestCommIndex))
	{
		//ShowMessageW(theUSBConnection->GetLastErrorMessage());
    }
}
//---------------------------------------------------------------------------
void __fastcall TUSBTestForm::IncrementPacketSizeTestButtonClick(
      TObject *Sender)
{
    int transCount = 0;
    int errorCount = 0;
    AnsiString errorMsg;
    unsigned int startTime;
    unsigned int spendSpeed;
	if (bLoopTransfer)
    {
    	bLoopTransfer = false;
    }
    else
    {
		bLoopTransfer = true;
    }
    startTime = GetTickCount();

    int sendNum[256];
    int receivedNum[256];
    int baseNum = 0;

	//TUSBConnection *theUSBConnection = TestUSBConnection;

	int dataSize = 4;
	while (bLoopTransfer)
	{
		transCount++;
/*
		baseNum++;


		for (int dataIndex = 0; dataIndex < dataSize / 4; dataIndex++)
		{
			sendNum[dataIndex] = baseNum;
		}
*/
		if (!Comm_RequestEx(TestCommIndex, CMD_ECHO, sendNum, dataSize, NULL, 0, receivedNum, dataSize))
		{
			//errorMsg = theUSBConnection->GetLastErrorMessage();
			//LogMemo->Lines->Add(errorMsg);
            //ShowMessageW(errorMsg);
            bLoopTransfer = false;
	    }
/*
		bool bSame = true;
        for (int dataIndex = 0; dataIndex < dataSize / 4; dataIndex++)
        {
            if (receivedNum[dataIndex] != sendNum[dataIndex])
            {
                errorCount++;
                bSame = false;
                break;
            }
        }
*/        
        if (transCount % 10 == 0)
        {
        	unsigned int currentTime = GetTickCount();
            if (currentTime > startTime)
            {
              WCHAR TempString[100];
              wsprintfW(TempString, USBTESTFORM_LABEL_CAPTION_02, transCount, transCount * 1000 / (currentTime - startTime), FloatToStrF((float)errorCount * 100 / transCount, ffFixed, 10, 2), dataSize);
              Label1->Caption = TempString;

				    //Label1->Caption = IntToStr(transCount) + "ȸ  Ϸ " + "<1ʴ  Ƚ = " + IntToStr(transCount * 1000 / (currentTime - startTime))
	          //   + " > <  = " + FloatToStr((float)errorCount * 100 / transCount) + "% > <Packet Size = " + IntToStr(dataSize) + ">";
            }
            Application->ProcessMessages();
        }
        dataSize = dataSize + 4;
        if (dataSize > 256) dataSize = 4;
    }
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::DecrementPacketSizeTestButtonClick(
      TObject *Sender)
{
    int transCount = 0;
    int errorCount = 0;
    AnsiString errorMsg;
    unsigned int startTime;
    unsigned int spendSpeed;
	if (bLoopTransfer)
    {
    	bLoopTransfer = false;
    }
    else
    {
		bLoopTransfer = true;
    }
    startTime = GetTickCount();

    int sendNum[256];
    int receivedNum[256];
    int baseNum = 0;

	//TUSBConnection *theUSBConnection = TestUSBConnection;

	int dataSize = 256;
	while (bLoopTransfer)
	{
		transCount++;
/*
		baseNum++;


		for (int dataIndex = 0; dataIndex < dataSize / 4; dataIndex++)
		{
			sendNum[dataIndex] = baseNum;
		}
*/
		if (!Comm_RequestEx(TestCommIndex, CMD_ECHO, sendNum, dataSize, NULL, 0, receivedNum, dataSize))
		{
			//errorMsg = theUSBConnection->GetLastErrorMessage();
			//LogMemo->Lines->Add(errorMsg);
			//ShowMessageW(errorMsg);
			bLoopTransfer = false;
		}
/*
		bool bSame = true;
		for (int dataIndex = 0; dataIndex < dataSize / 4; dataIndex++)
		{
			if (receivedNum[dataIndex] != sendNum[dataIndex])
			{
				errorCount++;
                bSame = false;
                break;
            }
        }
*/        
        if (transCount % 10 == 0)
        {
        	unsigned int currentTime = GetTickCount();
            if (currentTime > startTime)
            {
				Label1->Caption = IntToStr(transCount) + "ȸ  Ϸ " + "<1ʴ  Ƚ = " + IntToStr(transCount * 1000 / (currentTime - startTime))
	             + " > <  = " + FloatToStr((float)errorCount * 100 / transCount) + "% > <Packet Size = " + IntToStr(dataSize) + ">";
            }
            Application->ProcessMessages();
        }
        dataSize = dataSize - 4;
        if (dataSize <= 0) dataSize = 256;
    }
}
//---------------------------------------------------------------------------



void __fastcall TUSBTestForm::Button2Click(TObject *Sender)
{
    int transCount = 0;
    int errorCount = 0;
    AnsiString errorMsg;
    unsigned int startTime;
    unsigned int spendSpeed;
	if (bLoopTransfer)
    {
    	bLoopTransfer = false;
    }
    else
    {
		bLoopTransfer = true;
    }
    startTime = GetTickCount();

    int sendNum = 0;
    int receivedNum;

	//TUSBConnection *theUSBConnection = TestUSBConnection;

	while (bLoopTransfer)
	{
		if (!Comm_RequestEx(TestCommIndex, CMD_ECHO, &sendNum, 4, &receivedNum, 4))
		{
			//errorMsg = theUSBConnection->GetLastErrorMessage();
			//ShowMessageW(errorMsg);
            break;
	    }
        sendNum++;
        if ((sendNum & 0x7F) == 0)
		{
        	Label1->Caption = IntToStr(sendNum);
	        Application->ProcessMessages();
        }
    }
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::Button3Click(TObject *Sender)
{
	unsigned char *long_text = new char[4 * 1024 * 1024];
	unsigned char *received_text = new char[4 * 1024 * 1024];
	Comm_RequestEx(TestCommIndex, CMD_ECHO, long_text, 4 * 1024 * 1024, NULL, 0,
			received_text, 4 * 1024 * 1024);
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::Button4Click(TObject *Sender)
{
	//TUSBConnection *theUSBConnection = TestUSBConnection;
	//theUSBConnection->RequestStallTest(1);
	Comm_RequestStallTest(TestCommIndex, 1);
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::FormActivate(TObject *Sender)
{
bool anyConnected = false;

	if (Comm_IsConnected(COMM_HCB))
    {
		sbHCB1->Enabled = true;
        if (!anyConnected)
        {
			sbHCB1->Down = true;
            sbHCB1->Click();
            anyConnected = true;
        }
    }
    else
    {
		sbHCB1->Enabled = false;
	}
	if (Comm_IsConnected(COMM_SPB_1))
	{
		sbSPB1->Enabled = true;
		if (!anyConnected)
		{
			sbSPB1->Down = true;
			sbSPB1->Click();
			anyConnected = true;
		}
	}
	else
	{
		sbSPB1->Enabled = false;
	}
	if (Comm_IsConnected(COMM_SPB_2))
	{
		sbSPB2->Enabled = true;
		if (!anyConnected)
		{
			sbSPB2->Down = true;
			sbSPB2->Click();
			anyConnected = true;
		}
	}
	else
	{
		sbSPB2->Enabled = false;
	}
	if (Comm_IsConnected(COMM_SPB_3))
	{
		sbSPB3->Enabled = true;
		if (!anyConnected)
		{
			sbSPB3->Down = true;
			sbSPB3->Click();
			anyConnected = true;
		}
	}
	else
	{
		sbSPB3->Enabled = false;
	}
	if (Comm_IsConnected(COMM_SPB_4))
	{
		sbSPB4->Enabled = true;
		if (!anyConnected)
		{
			sbSPB4->Down = true;
			sbSPB4->Click();
			anyConnected = true;
		}
	}
	else
	{
		sbSPB4->Enabled = false;
	}	
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::Button5Click(TObject *Sender)
{
	CommControlForm->Show();	
}
//---------------------------------------------------------------------------

void __fastcall TUSBTestForm::Button6Click(TObject *Sender)
{
	unsigned int func;
	func = 1;
	Comm_Request(TestCommIndex, CMD_USB_TEST, &func, sizeof(unsigned int));
}
//---------------------------------------------------------------------------

