//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "UnmanedOperation_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TUnmanedOperationForm *UnmanedOperationForm;

//---------------------------------------------------------------------------
__fastcall TUnmanedOperationForm::TUnmanedOperationForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	ActivateSpeedButton->Caption = UNMANEDOPERATIONFORM_BUTTON_CAPTION_01;
	DeactivateSpeedButton->Caption = UNMANEDOPERATIONFORM_BUTTON_CAPTION_02;
	InspectionStopMachinePowerOffCheckBox->Caption = UNMANEDOPERATIONFORM_CHECKBOX_CAPTION_01;
	InspectionStopBuzzerOnCheckBox->Caption = UNMANEDOPERATIONFORM_CHECKBOX_CAPTION_02;
	InspectionSuspendTimerCheckBox->Caption = UNMANEDOPERATIONFORM_CHECKBOX_CAPTION_03;
	this->Caption = UNMANEDOPERATIONFORM_FORM_CAPTION_01;
	GroupBox1->Caption = UNMANEDOPERATIONFORM_GROUPBOX_CAPTION_01;
	GroupBox3->Caption = UNMANEDOPERATIONFORM_GROUPBOX_CAPTION_02;
	GroupBox2->Caption = UNMANEDOPERATIONFORM_GROUPBOX_CAPTION_03;
	Label2->Caption = UNMANEDOPERATIONFORM_LABEL_CAPTION_01;
	Label1->Caption = UNMANEDOPERATIONFORM_LABEL_CAPTION_02;
	BuzzerTemporaryOnRadioButton->Caption = UNMANEDOPERATIONFORM_RADIOBTN_CAPTION_01;
	BuzzerContinuousOnRadioButton->Caption = UNMANEDOPERATIONFORM_RADIOBTN_CAPTION_02;

	UnmanedOperationActivated = false;
	OperationTextIndex = 0;
	OperationText[0] = UNMANEDOPERATIONFORM_TEXT_VALIABLE_01;
	OperationText[1] = UNMANEDOPERATIONFORM_TEXT_VALIABLE_02;
	OperationText[2] = UNMANEDOPERATIONFORM_TEXT_VALIABLE_03;
	OperationText[3] = UNMANEDOPERATIONFORM_TEXT_VALIABLE_04;

  StatusPanel->Caption = UNMANEDOPERATIONFORM_PANEL_CAPTION_02;
}
//---------------------------------------------------------------------------
void __fastcall TUnmanedOperationForm::ActivateSpeedButtonClick(
	  TObject *Sender)
{
	if (MessageDlgFA(UNMANEDOPERATIONFORM_MSG_01, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		try
		{
			TUnmanedOperationData unmanedOperationData;
			unmanedOperationData.InspectionStopBuzzerOn = InspectionStopBuzzerOnCheckBox->Checked ? 1 : 0;
			unmanedOperationData.InspectionStopMachinePowerOff = InspectionStopMachinePowerOffCheckBox->Checked ? 1 : 0;

      if(StrToInt(MachinePowerOffDelayEdit->Text) < 30)
      {
        MachinePowerOffDelayEdit->Text = "30";
        unmanedOperationData.MachinePowerOffDelay = 30;
      }
      else
      {
         unmanedOperationData.MachinePowerOffDelay = StrToInt(MachinePowerOffDelayEdit->Text);
      }


			if (BuzzerContinuousOnRadioButton->Checked)
			{
				unmanedOperationData.BuzzerOnTime = 0;
			}
			else
			{
				unmanedOperationData.BuzzerOnTime = StrToInt(BuzzerOnTimeEdit->Text);
			}
			unmanedOperationData.TimerEnabled = InspectionSuspendTimerCheckBox->Checked;
			unmanedOperationData.InspectionStopTimer = StrToInt(TimerHourEdit->Text) * 3600 + StrToInt(TimerMinEdit->Text) * 60;

			unmanedOperationData.Activated = true;
			Comm_Request(COMM_HCB, CMD_UNMANED_OPERATION, &unmanedOperationData, sizeof(TUnmanedOperationData));

			UnmanedOperationSettingPanel->Enabled = false;
			ActivateSpeedButton->Enabled = false;
			DeactivateSpeedButton->Enabled = true;

			TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\UserSetting.ini");
			if (iniFile)
			{
				iniFile->WriteBool("Unmaned Operation", "Inspection Stop Buzzer On", InspectionStopBuzzerOnCheckBox->Checked);
				iniFile->WriteBool("Unmaned Operation", "Inspection Stop Power Off", InspectionStopMachinePowerOffCheckBox->Checked);
				iniFile->WriteInteger("Unmaned Operation", "Power Off Delay", unmanedOperationData.MachinePowerOffDelay);
				iniFile->WriteInteger("Unmaned Operation", "Buzzer On Time", unmanedOperationData.BuzzerOnTime);
				if (InspectionSuspendTimerCheckBox->Checked)
				{
					iniFile->WriteInteger("Unmaned Operation", "Stop Timer Hour", StrToInt(TimerHourEdit->Text));
					iniFile->WriteInteger("Unmaned Operation", "Stop Timer Min", StrToInt(TimerMinEdit->Text));
				}
				delete iniFile;
			}
			UnmanedOperationActivated = true;
		}
		catch (Exception &ec)
		{
			ShowMessageFA(ec.Message);
			DeactivateSpeedButton->Down = true;
			ActivateSpeedButton->Down = false;
			UnmanedOperationActivated = false;
		}
	}
	else
	{
		DeactivateSpeedButton->Down = true;
		ActivateSpeedButton->Down = false;
		UnmanedOperationActivated = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TUnmanedOperationForm::DeactivateSpeedButtonClick(
	  TObject *Sender)
{
	UnmanedOperationSettingPanel->Enabled = true;
	TUnmanedOperationData unmanedOperationData;
	unmanedOperationData.Activated = false;
	ActivateSpeedButton->Enabled = true;
  unmanedOperationData.TimerEnabled =false;
  unmanedOperationData.InspectionStopTimer = false;

	Comm_Request(COMM_HCB, CMD_UNMANED_OPERATION, &unmanedOperationData, sizeof(TUnmanedOperationData));
	UnmanedOperationActivated = false;
	this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TUnmanedOperationForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------
void __fastcall TUnmanedOperationForm::FormCreate(TObject *Sender)
{
	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\UserSetting.ini");
	if (iniFile)
	{
		InspectionStopBuzzerOnCheckBox->Checked = iniFile->ReadBool("Unmaned Operation", "Inspection Stop Buzzer On", true);
		InspectionStopMachinePowerOffCheckBox->Checked = iniFile->ReadBool("Unmaned Operation", "Inspection Stop Power Off", false);
		MachinePowerOffDelayEdit->Text = IntToStr(iniFile->ReadInteger("Unmaned Operation", "Power Off Delay", 600));
		int buzzerOnTime = iniFile->ReadInteger("Unmaned Operation", "Buzzer On Time", 60);
		if (buzzerOnTime == 0)
		{
			BuzzerContinuousOnRadioButton->Checked = true;
		}
		else
		{
			BuzzerOnTimeEdit->Text = IntToStr(buzzerOnTime);
			BuzzerTemporaryOnRadioButton->Checked = true;
		}
		TimerHourEdit->Text = IntToStr(iniFile->ReadInteger("Unmaned Operation", "Stop Timer Hour", 1));
		TimerMinEdit->Text = IntToStr(iniFile->ReadInteger("Unmaned Operation", "Stop Timer Min", 0));
		delete iniFile;
	}
}
//---------------------------------------------------------------------------
void __fastcall TUnmanedOperationForm::CheckTimerTimer(TObject *Sender)
{
	if (UnmanedOperationActivated)
	{
		if (InspectionSuspendTimerCheckBox->Checked)
		{
			TUnmanedOperationData unmanedOperationData;
			Comm_Request(COMM_HCB, CMD_READ_UNMANED_OPERATION_INFO, NULL, 0, &unmanedOperationData, sizeof(TUnmanedOperationData));
			int timeLeftMin = unmanedOperationData.InspectionStopTimer / 60;
			int timeLeftSec = unmanedOperationData.InspectionStopTimer % 60;
      WCHAR TempString[100];

      wsprintfW(TempString, UNMANEDOPERATIONFORM_PANEL_CAPTION_01, OperationText[0], timeLeftMin, timeLeftSec);
      StatusPanel->Caption = TempString;
		}
		else
		{
      OperationTextIndex = (OperationTextIndex + 1) % OPERATION_TEXT_COUNT;
			StatusPanel->Caption = OperationText[OperationTextIndex];
		}
	}
	else
	{
		StatusPanel->Caption = UNMANEDOPERATIONFORM_PANEL_CAPTION_02;
	}
}
//---------------------------------------------------------------------------
