//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <inifiles.hpp>
#include "UserAuthoritySetting_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TUserAuthoritySettingForm *UserAuthoritySettingForm;
//---------------------------------------------------------------------------
__fastcall TUserAuthoritySettingForm::TUserAuthoritySettingForm(TComponent* Owner)
  : TForm(Owner)
{
  AuthorityListRadioBox->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_01;
}
//---------------------------------------------------------------------------
void __fastcall TUserAuthoritySettingForm::OKBtnClick(TObject *Sender)
{
  bool bSaveFail = false;
  for(int idIndex = 0; idIndex < userIDList->Count; idIndex++)
  {
    if(accessLevelList->Strings[idIndex] == IntToStr(SYSTEM_ACCESS_LEVEL_ANONYMOUS))
    {
      bSaveFail = true;
      break;
    }
  }

  if(bSaveFail)
  {
    ShowMessageFA(USER_AUTHORITY_SETTING_FORM_TEXT_04);
    return;
  }

  TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\user.ini");
    
  if (iniFile)
  {
    for(int idIndex = 0; idIndex < userIDList->Count; idIndex++)
    {
      iniFile->WriteInteger(userIDList->Strings[idIndex], "Access Level", StrToInt(accessLevelList->Strings[idIndex]));
    }
  }

  delete iniFile;

  ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TUserAuthoritySettingForm::CancelBtnClick(TObject *Sender)
{
  ModalResult = mrCancel;  
}
//---------------------------------------------------------------------------

void __fastcall TUserAuthoritySettingForm::SetIDList(bool init)
{
  UserIDStringGrid->ColWidths[1] = UserIDStringGrid->Width - UserIDStringGrid->ColWidths[0] - 30;
  UserIDStringGrid->RowCount = userIDList->Count + 1;

  UserIDStringGrid->Cells[0][0] = USER_AUTHORITY_SETTING_FORM_TEXT_01;
  UserIDStringGrid->Cells[1][0] = USER_AUTHORITY_SETTING_FORM_TEXT_02;

  int AccessLevel;

  if(init)
  {
    TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\user.ini");
    
    if (iniFile)
    {
      for(int idIndex = 0; idIndex < userIDList->Count; idIndex++)
      {
        AccessLevel = iniFile->ReadInteger(userIDList->Strings[idIndex], "Access Level", SYSTEM_ACCESS_LEVEL_ANONYMOUS);

        UserIDStringGrid->Cells[0][idIndex + 1] = userIDList->Strings[idIndex];

        if(AccessLevel == SYSTEM_ACCESS_LEVEL_ANONYMOUS || !(AccessLevel >= 1 && AccessLevel < MAX_AUTHORITY_COUNT))
        {
          UserIDStringGrid->Cells[1][idIndex + 1] = USER_AUTHORITY_SETTING_FORM_TEXT_03;
          accessLevelList->Strings[idIndex] = IntToStr(SYSTEM_ACCESS_LEVEL_ANONYMOUS);
        }
        else
        {
          if(AccessLevel >= tempProgramAccessAuthorityData.SystemAuthorityCount)
          {
            UserIDStringGrid->Cells[1][idIndex + 1] = USER_AUTHORITY_SETTING_FORM_TEXT_03;
            accessLevelList->Strings[idIndex] = IntToStr(SYSTEM_ACCESS_LEVEL_ANONYMOUS);
          }
          else
          {
            UserIDStringGrid->Cells[1][idIndex + 1] = tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AccessLevel];
            accessLevelList->Strings[idIndex] = IntToStr(AccessLevel);
          }
        }
      }
    }

    activeUserNum = 0;

    UserIDStringGrid->Row = 1;

    AccessLevel = StrToInt(accessLevelList->Strings[UserIDStringGrid->Row - 1]);

    if(AccessLevel == SYSTEM_ACCESS_LEVEL_ANONYMOUS)
    {
      AuthorityListRadioBox->ItemIndex = 0;
    }
    else
    {
      AuthorityListRadioBox->ItemIndex = AccessLevel;
    }


    WCHAR TempString[100];
    wsprintfW(TempString, USER_AUTHORITY_SETTING_FORM_TEXT_05, WideString(userIDList->Strings[UserIDStringGrid->Row - 1]));
    WideString returnStr = WideString(TempString);

    AuthorityListRadioBox->Caption = returnStr;

    delete iniFile;
  }
  else
  {
    try
    {
      for(int idIndex = 0; idIndex < userIDList->Count; idIndex++)
      {
        AccessLevel = StrToInt(accessLevelList->Strings[idIndex]);

        if(AccessLevel == SYSTEM_ACCESS_LEVEL_ANONYMOUS || !(AccessLevel >= 1 && AccessLevel < MAX_AUTHORITY_COUNT))
        {
          UserIDStringGrid->Cells[1][idIndex + 1] = USER_AUTHORITY_SETTING_FORM_TEXT_03;
        }
        else
        {
          UserIDStringGrid->Cells[1][idIndex + 1] = tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AccessLevel];
        }
      }
    }
    catch(...)
    {

    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TUserAuthoritySettingForm::FormDestroy(TObject *Sender)
{
  delete userIDList;
  delete accessLevelList;
}
//---------------------------------------------------------------------------

void __fastcall TUserAuthoritySettingForm::FormActivate(TObject *Sender)
{
  if(userIDList != NULL)
  {
    delete userIDList;
  }

  if(accessLevelList != NULL)
  {
    delete accessLevelList;
  }
  
  userIDList = new TStringList;
  accessLevelList = new TStringList;
  
  TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\user.ini");

  if (iniFile)
  {
    iniFile->ReadSections(userIDList);
    iniFile->ReadSections(accessLevelList);
  }

  AuthorityListRadioBox->Items->Add(USER_AUTHORITY_SETTING_FORM_TEXT_03);

  for(int athID = 1; athID < tempProgramAccessAuthorityData.SystemAuthorityCount; athID++)
  {
    AuthorityListRadioBox->Items->Add(tempProgramAccessAuthorityData.ProgramAccessAuthorityName[athID]);
  }

  SetIDList(true);
}
//---------------------------------------------------------------------------

void __fastcall TUserAuthoritySettingForm::UserIDStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  try
  {
    int AccessLevel;

    activeUserNum = ARow - 1;
    AccessLevel = StrToInt(accessLevelList->Strings[ARow - 1]);

    if(AccessLevel == SYSTEM_ACCESS_LEVEL_ANONYMOUS)
    {
      AuthorityListRadioBox->ItemIndex = 0;
    }
    else
    {
      AuthorityListRadioBox->ItemIndex = AccessLevel;
    }

    WCHAR TempString[100];
    wsprintfW(TempString, USER_AUTHORITY_SETTING_FORM_TEXT_05, WideString(userIDList->Strings[ARow - 1]));
    WideString returnStr = WideString(TempString);

    AuthorityListRadioBox->Caption = returnStr;
  }
  catch(...)
  {

  }
}
//---------------------------------------------------------------------------


void __fastcall TUserAuthoritySettingForm::AuthorityListRadioBoxClick(
      TObject *Sender)
{
  if(AuthorityListRadioBox->ItemIndex == 0)
  {
    accessLevelList->Strings[activeUserNum] = IntToStr(SYSTEM_ACCESS_LEVEL_ANONYMOUS);
  }
  else
  {                                                                               
    accessLevelList->Strings[activeUserNum] = AuthorityListRadioBox->ItemIndex;
  }

  SetIDList(false);
}
//---------------------------------------------------------------------------

