//---------------------------------------------------------------------------

#ifndef UserRegister_FormH
#define UserRegister_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <vector.h>
#include <Grids.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include "TntGrids.hpp"

//---------------------------------------------------------------------------
#define PASSWORD_ADD_VALUE              100

typedef struct
{
	  bool 		Editable;
    int			Key;
    int 		Index;
    int 		AccessLevel;
    AnsiString  ID;
    AnsiString  Password;
    bool FirstLogin;
    bool AcDeactive;
} TUser;

extern TUser User;

typedef struct
{
    int count;
    TUser *user;
} TModifyUserData;
//---------------------------------------------------------------------------
class TUserRegisterForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *ClientPanel;
	TTntPanel *RegistrationPanel;
	TTntPanel *RegistrationHeaderPanel;
	TTntLabel *Label19;
	TTntLabel *Label14;
	TTntLabel *Label15;
	TTntLabel *Label16;
	TTntEdit *RegistrationIDEdit;
	TEdit *RegistrationPasswordEdit;
	TEdit *RegistrationPasswordConfirmEdit;
	TTntPanel *RegistrationClientPanel;
	TTntPanel *RegistrationButtonPanel;
	TTntBitBtn *RegistrationApplyBitBtn;
	TTntPanel *DeletePanel;
	TTntPanel *DeleteHeaderPanel;
	TTntLabel *Label18;
	TTntPanel *DeleteButtonPanel;
	TTntBitBtn *DeleteApplyBitBtn;
	TTntPanel *DeleteClientPanel;
	TTntLabel *Label1;
	TTntEdit *DeleteIDEdit;
	TTntPanel *ModifyPanel;
	TTntPanel *ModifyClientPanel;
	TTntLabel *Label13;
	TTntLabel *Label8;
	TTntLabel *Label11;
	TEdit *ModifyNewPasswordEdit;
	TEdit *ModifyNewRecheckEdit;
	TEdit *ModifyOldPasswordEdit;
	TTntPanel *ModifyButtonPanel;
	TTntBitBtn *ModifyApplyBitBtn;
	TTntPanel *LeftPanel;
	TTntPanel *LeftClientPanel;
	TTntPanel *ExitPanel;
	TTntBitBtn *CloseBitBtn;
	TTntPanel *SelectButtonPanel;
	TTntSpeedButton *ModifySpeedButton;
	TTntSpeedButton *DeleteSpeedButton;
	TTntSpeedButton *RegistrationSpeedButton;
    TTntPanel *ModifyHeaderPanel;
    TTntLabel *Label9;
	TTntStringGrid *DeleteListStringGrid;
        TTntPanel *RightPanel;
        TTntStringGrid *AuthorityListGrid;
        TTntRadioGroup *RegistrationGradeRadioGroup;
  TPanel *Panel1;
  TTntSpeedButton *UserUnlockButton;
  TTntPanel *UserUnlockPanel;
  TTntPanel *TntPanel3;
  TTntLabel *TntLabel1;
  TTntStringGrid *UserUnlockStringGrid;
  TTntPanel *TntPanel5;
  TTntBitBtn *UnlockBitBtn;
  TTntPanel *ActiveUserPanel;
  TTntPanel *TntPanel6;
  TTntLabel *ActiveNameLabel;
  TTntStringGrid *ActiveUserStringGrid;
  TTntPanel *TntPanel7;
  TTntBitBtn *DeActiveBtn;
  TTntBitBtn *ActiveBtn;
  TTntPanel *TntPanel1;
	void __fastcall ModifySpeedButtonClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall RegistrationApplyBitBtnClick(TObject *Sender);
	void __fastcall RegistrationIDEditClick(TObject *Sender);
	void __fastcall PasswordEditClick(TObject *Sender);
    void __fastcall DeleteSpeedButtonClick(TObject *Sender);
    void __fastcall DeleteApplyBitBtnClick(TObject *Sender);
    void __fastcall ModifyApplyBitBtnClick(TObject *Sender);
	void __fastcall DeleteStringGridClick(TObject *Sender);
        void __fastcall RegistrationSpeedButtonClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
  void __fastcall RegistrationGradeRadioGroupClick(TObject *Sender);
  void __fastcall UserUnlockButtonClick(TObject *Sender);
  void __fastcall UserUnlockStringGridClick(TObject *Sender);
  void __fastcall UnlockBitBtnClick(TObject *Sender);
  void __fastcall ActiveUserStringGridClick(TObject *Sender);
  void __fastcall DeActiveBtnClick(TObject *Sender);
private:	// User declarations
  WideString MsgList[11];
	int selectedPanel;
  int enableCount;
  bool userExist;

//    TModifyUserData userInfo;
	vector<TUser> UserList;

//    int *enableList;
    int ModifySelectedIndex;
    int DeleteSelectedIndex;
    int UnlockSelectedIndex;

    void __fastcall InitializeUserData(void);
    void __fastcall ModifyPanels(void);
    void __fastcall ModifyDeletePanel(void);
    void __fastcall ModifyRegistPanel(void);
    void __fastcall ModifyGradePanel1(void);
    void __fastcall ModifyUserUnlockPanel(void);
    void __fastcall ModifyUserActivePanel(void);
    void __fastcall DisplayModifyEdit(void);
    void __fastcall DisplayDeleteEdit(void);
    bool __fastcall IsExistID(AnsiString newID);
    bool __fastcall RegisterNewID(AnsiString id, AnsiString password, int AccessLevel);
    bool __fastcall DeleteID(AnsiString id);
    bool __fastcall ChangePassword(AnsiString id, AnsiString password);
    void __fastcall GetDefaultString(void);
    bool __fastcall ChangeGrade(void);
    void __fastcall WriteLastPassword(String section, String password);
    int __fastcall CheckLastPassword(String section, String password);

public:		// User declarations
	__fastcall TUserRegisterForm(TComponent* Owner);
        void __fastcall ShowAuthority(int AccessLevel);
	void __fastcall OnUserChange(void);
	bool CurrentUserRemoved;

};
//---------------------------------------------------------------------------
AnsiString __fastcall GetUserPassword(AnsiString ID);
AnsiString __fastcall PasswordToText(AnsiString password);
AnsiString __fastcall TextToPassword(AnsiString text);
int __fastcall CheckUserNameAndPassword(AnsiString id, AnsiString password);
bool __fastcall CheckPasswordExpiration(AnsiString id, double timeLimit);
bool __fastcall LoadUserInfo(AnsiString id);
//---------------------------------------------------------------------------
extern PACKAGE TUserRegisterForm *UserRegisterForm;
//---------------------------------------------------------------------------
#endif
