//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#include <FileCtrl.hpp>
#pragma hdrstop

#include "VirtualImageControl_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TVirtualImageControlForm *VirtualImageControlForm;
//---------------------------------------------------------------------------
__fastcall TVirtualImageControlForm::TVirtualImageControlForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  SelectDirButton->Caption = VIRTUALIMAGECONTROLFORM_BUTTON_CAPTION_01;
  CancelButton->Caption = VIRTUALIMAGECONTROLFORM_BUTTON_CAPTION_02;
  OKButton->Caption = VIRTUALIMAGECONTROLFORM_BUTTON_CAPTION_03;
  Label1->Caption = VIRTUALIMAGECONTROLFORM_LABEL_CAPTION_01;

	FOptionCpatureMode = false;
}
//---------------------------------------------------------------------------
void __fastcall TVirtualImageControlForm::FormCreate(TObject *Sender)
{
	TIniFile *iniFile = new TIniFile(ProgramPath.Root + "\\Virtual\\Virtual.ini");
	if (iniFile)
	{
		VirtualImageDir = iniFile->ReadString("Recent", "Virtual Image Path", "");
		FOptionCpatureMode = iniFile->ReadBool("Recent", "Option Capture", false);
		FNewImageVersion = iniFile->ReadBool("Recent", "New Image", false);
		delete iniFile;
	}
	else
	{
		VirtualImageDir = "";
	}
	OptionModeCheckBox->Checked = FOptionCpatureMode;
	NewImageVersionCheckBox->Checked = FNewImageVersion;
	VirtualImagePathEdit->Text = VirtualImageDir;
}
//---------------------------------------------------------------------------
void __fastcall TVirtualImageControlForm::SelectDirButtonClick(
	  TObject *Sender)
{
	AnsiString virtualCaputreDir;
	if (SelectDirectory("Select Path", "", virtualCaputreDir))
	{
		VirtualImageDir = virtualCaputreDir;
	}
	VirtualImagePathEdit->Text = VirtualImageDir;
}
//---------------------------------------------------------------------------
void __fastcall TVirtualImageControlForm::OKButtonClick(TObject *Sender)
{
	FOptionCpatureMode = OptionModeCheckBox->Checked;
	FNewImageVersion = NewImageVersionCheckBox->Checked;
	VirtualImageDir = VirtualImagePathEdit->Text;
	TIniFile *iniFile = new TIniFile(ProgramPath.Root + "\\Virtual\\Virtual.ini");
	if (iniFile)
	{
 		iniFile->WriteString("Recent", "Virtual Image Path", VirtualImageDir);
		iniFile->WriteBool("Recent", "Option Capture", FOptionCpatureMode);
		iniFile->WriteBool("Recent", "New Image", FNewImageVersion);
		delete iniFile;
	}
}
//---------------------------------------------------------------------------
