//---------------------------------------------------------------------------

#ifndef VirtualMachine_FormH
#define VirtualMachine_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <vector.h>

#include "TcpComm.h"
#include "common.h"
#include "command.h"
#include "processing.h"
#include "SPB_Processing.h"
#include <ExtCtrls.hpp>
#include "TntForms.hpp"
//---------------------------------------------------------------------------
typedef struct
{
	int TargetPos;
} TStepMotorData;
//---------------------------------------------------------------------------
#define MAIN_CONTROL_STATE_NONE				0
#define MAIN_CONTROL_STATE_STOP				1
#define MAIN_CONTROL_STATE_RUN				2
#define MAIN_CONTROL_STATE_CLEANING			3
#define MAIN_CONTROL_STATE_ATTACHING		4
#define MAIN_CONTROL_STATE_DETACHING		5
#define MAIN_CONTROL_STATE_STARTING			6
#define MAIN_CONTROL_STATE_STOPPING			7
#define MAIN_CONTROL_STATE_EMERGENCY_STOP	0xFF

#define MAIN_CONTROL_POS_STATE_NONE			0
#define MAIN_CONTROL_POS_STATE_CLEANING		1
#define MAIN_CONTROL_POS_STATE_READY		2

#define MAIN_CONTROL_MODE_NONE			0
#define MAIN_CONTROL_MODE_TEST			1
#define MAIN_CONTROL_MODE_CAPTURE		2
#define MAIN_CONTROL_MODE_STUDY			3
#define MAIN_CONTROL_MODE_INSPECTION	4

typedef struct
{
	char State;
	char SubState;
	char Func;
	char Mode;
	char PrevState;	// for emergency state
	char PosState;
//	int PosState;
	int MotorSpeed[MAX_SERVO_MOTOR_COUNT];
	char AirKnifeSpeed;
//	char TabletSizeMode;
	unsigned char SuctionDisk1InverterSpeed;
	unsigned char SuctionDisk2InverterSpeed;
	unsigned int EjectorWarmUpStartTime;
	char HomeDetected;
	char HomeDetectionFailed;
	int NCPos[MAX_STEP_MOTOR_COUNT];
} TMainControlData;

typedef struct
{
	AnsiString ContainerFileName;
	AnsiString FileName;
} TVirtualCaptureUnit;

typedef struct
{
	bool OnCapture;
	bool OptionCaptureMode;
	int CurrentCaptureIndex[SYSTEM_SPB_CAMERA_COUNT];
	int TotalCaptureCount[SYSTEM_SPB_CAMERA_COUNT];
	vector<TVirtualCaptureUnit> VirtualCaptureList[SYSTEM_SPB_CAMERA_COUNT];
	unsigned char *CaptureBuffer;
} TCaptureStatus;


#define PROCESSING_MODE_NONE			0
#define PROCESSING_MODE_STUDY			1
#define PROCESSING_MODE_INSPECTION		2

#define SPB_RESULT_HEAP_TABLE_SIZE		256
#define SPB_RESULT_HEAP_MASK			255

typedef struct
{
	int TabletNumber;
	int InspectionResult;
//	unsigned char PrintResult[3];
	char PrintResult;
	char ThickErrorSW;
	char Front_Rear;
} TSPBResultHeapUnit;

//---------------------------------------------------------------------------
class TVirtualMachineForm : public TTntForm
{
__published:	// IDE-managed Components
	TTimer *VirtualMachineTimer;
	void __fastcall VirtualMachineTimerTimer(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
private:	// User declarations
	TMachineStatus MachineStatus;
	TStepMotorData StepMotorData[MAX_STEP_MOTOR_COUNT];
	int TimerCount;

	TCaptureStatus CaptureStatus[SYSTEM_SPB_MAX_COUNT];
	bool VirtualCaptureOn;
	bool VirtualOptionCaptureMode;
	bool VirtualNewCaptureMode;
	AnsiString VirtualCaptureDir;

//	TSPBProcessingSetupInfo SPBProcessingSetupInfo;
	TMainControlData MainControlData;
//	THCBStatusList HCBStatusList;
	TMachineWarningState MachineWarningState;
	TMachineAlarmState MachineAlarmState;
//	TMainMachineStatus MainMachineStatus;
	THCBProgramHeader HCBProgramHeader;
	THCBDBHeader HCBDBHeader;
	THCBProgramHeader SPBProgramHeader;
	THCBMachineSpecificHeader HCBMachineSpecificHeader;
	TInspectionResultTable InspectionResultTable;
	TTabletInspectInfo TabletInspectInfo;
	TTabletInfo TabletInfo;
	TMachineCaptureSetupData MachineCaputreSetupData;

	unsigned int LastCheckCount;
	TIdleProcessData IdleProcessData;

	int PollingInspectionResultTabletNumber;
	THCBInspectionOption InspectionOption;

	struct
	{
		TSPBResultHeapUnit ResultList[SPB_RESULT_HEAP_TABLE_SIZE];
	} SPBResultHeap[SYSTEM_SPB_MAX_COUNT];

	void __fastcall MC_StepMotorControl(TMachineControlData_StepMotor *stepMotorData);
	void __fastcall MC_Step_Motor_MovePos(int motorIndex, int targetEncoderPosition);
	void __fastcall MC_GeneralControl(int action, int *value);
	void __fastcall MC_MainControl_Cleaning(void);
	void __fastcall MC_Procedure(TMachineControlData_Procedure *procedureData);
	void __fastcall MC_HomePositionSetup(void);
	void __fastcall ApplyVirtualCapture(void);
	void __fastcall ApplyVirtualNewCapture(void);
	void __fastcall PollingInspectionResult(void);
	unsigned char *GetCurrentCaptureBuffer(int spbIndex, int camIndex);
	unsigned char *GetCurrentNewCaptureBuffer(int spbIndex, int camIndex);
	void FlushCurrentImageBuffer(int spbIndex, int camIndex);
public:		// User declarations
	__fastcall TVirtualMachineForm(TComponent* Owner);

	bool __fastcall CommRequest(int commIndex, unsigned short command, void *data, unsigned int dataLength,
		void *receiveBuffer, unsigned int receiveBufferMaxSize);
	bool __fastcall CommRequestEx(int commIndex, unsigned short command, void *shortData, unsigned int shortDataLength,
		void *longData, unsigned int longDataLength, void *receiveBuffer, unsigned int receiveBufferMaxSize,
		TUSBCompletionRoutine CompletionRoutine, TOverlapIOStr *OverlapIOStr);
};
//---------------------------------------------------------------------------
extern PACKAGE TVirtualMachineForm *VirtualMachineForm;
//---------------------------------------------------------------------------
#endif
