//---------------------------------------------------------------------------

#ifndef Virtual_CPB_FormH
#define Virtual_CPB_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "common.h"
#include "processing.h"
#include <ExtCtrls.hpp>
#include "TntExtCtrls.hpp"
#include "TntForms.hpp"


//---------------------------------------------------------------------------
class TVirtualCPB
{
public:
	TTabletSetupData LocalTabletSetupData;

};
//---------------------------------------------------------------------------
class TVirtualCPBForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntImage *SourceImage;
	TTntImage *InspectionAreaImage;
private:	// User declarations
	TCPBSystemSetupData LocalCPBSystemSetupData[SYSTEM_SPB_MAX_COUNT][SYSTEM_CPB_COUNT];
	TTabletStudyData LocalTabletStudyData[SYSTEM_SPB_MAX_COUNT][SYSTEM_CPB_COUNT];
	TDefectData LocalDefectData[SYSTEM_SPB_MAX_COUNT][SYSTEM_CPB_COUNT];
	TDefectInformation LocalDefectInformation[SYSTEM_SPB_MAX_COUNT][SYSTEM_CPB_COUNT];
	TVirtualCPB VirtualCPB[SYSTEM_TOTAL_CAMERA_COUNT];
	int CurrentVirtualCPBIndex;

	void __fastcall SwapCPB(int spbIndex, int cpbIndex);
	void __fastcall InvalidateCPB(void);
public:		// User declarations
	__fastcall TVirtualCPBForm(TComponent* Owner);
	int HPI_ReadData(unsigned int indicator, void *data_address, int data_size, int spbIndex, int cpbIndex);
	int HPI_WriteData(unsigned int indicator, void *data_address, int data_size, int spbIndex, int cpbIndex);
};
//---------------------------------------------------------------------------
extern PACKAGE TVirtualCPBForm *VirtualCPBForm;
//---------------------------------------------------------------------------
void Set_Processing_Status(int status);

void ReadStartHPITempBuffer();
void ReadL2DataFromHPITempBuffer(void *data, int size);

int Virtual_HPI_ReadData(unsigned int indicator, void *data_address, int data_size, int spbIndex, int cpbIndex);
int Virtual_HPI_WriteData(unsigned int indicator, void *data_address, int data_size, int spbIndex, int cpbIndex);

int Virtual_HPI_ReadData_2DImageTo2D(unsigned int sec_indicator, void *data_address,
	int left, int top, int width, int height, int arrayWidth, int cpbIndex);
int Virtual_HPI_ReadData_2DImageTo2D_Rotate(unsigned int sec_indicator, void *data_address,
	int left, int top, int width, int height, int arrayWidth, int cpbIndex);
//---------------------------------------------------------------------------
#endif
