//---------------------------------------------------------------------------

#ifndef Virtual_SPB_FormH
#define Virtual_SPB_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "common.h"
#include "processing.h"
#include "spb_processing.h"
#include <ExtCtrls.hpp>
#include <vector.h>
#include "TntForms.hpp"
#include "Virtual_SPB_System.h"
//---------------------------------------------------------------------------
typedef struct
{
	unsigned char CameraEnable[4];
	unsigned short ShutterSpeed[4];
	unsigned short ShutterDelay[4];
	unsigned short TriggerFreq[4];
	unsigned int CaptureMode;	
	int FrameBufferCount;
} TCameraSetupData;

//---------------------------------------------------------------------------
#define DEFECT_QUEUE_SIZE		256
#define DEFECT_QUEUE_MASK		255


class TVirtualSPB
{
private:

	int CaptureTabletIndex[SYSTEM_SPB_CAMERA_COUNT];
	TCameraSetupData CameraSetupData;

	bool __fastcall IsAvailableCPB(int cpbIndex);
	void __fastcall ClearCaptureProcessingData(void);
public:
	bool OnProcessing;

	TProcessingData LocalProcessingData;
	TStudyResultData_SPB LocalStudyResultData_SPB[SYSTEM_SPB_CAMERA_COUNT];
	TSPBTabletProcessInfo LocalSPBTabletProcessInfo;
	TSPBSystemSetupData LocalSPBSystemSetupData;
	TSPBProcessingSetupInfo LocalSPBProcessingSetupInfo;

	TProcessingImageInfo LocalProcessingImageInfo;
	TDefectData_SPB LocalDefectDataList[MAX_IMAGE_BLOCK_INDEX][IMAGE_BUFFER_COUNT];

	char LocalCPBStep[SYSTEM_CPB_COUNT];
	int LocalCPBCamIndex[SYSTEM_CPB_COUNT];
	int LocalCPBProcessingTabletListIndex[SYSTEM_CPB_COUNT];
	unsigned int LocalCPBProcessingStartTime[SYSTEM_CPB_COUNT];

	unsigned short LocalDefectQueueList[DEFECT_QUEUE_SIZE];
	int LocalDefectQueueStart, LocalDefectQueueEnd;

	__fastcall TVirtualSPB();
	void __fastcall Virtual_SPB_Setup_Start(int mode);
	void __fastcall Virtual_SPB_Study_Ready(void);
	void __fastcall Virtual_SPB_Inspection_Ready(void);
	void __fastcall MainLoop(void);
	void __fastcall Init_Tablet_Capture_StudyMode(void);
	void __fastcall Init_Tablet_Capture_InspectionMode(unsigned char cameraMask);
	void __fastcall Tablet_Capture(int camIndex);
};
//---------------------------------------------------------------------------
typedef struct
{
	AnsiString ContainerFileName;
	AnsiString FileName;
} TVirtualCaptureUnit2;

typedef struct
{
	bool OnCapture;
	bool OptionCaptureMode;
	int CurrentCaptureIndex[SYSTEM_SPB_CAMERA_COUNT];
	int TotalCaptureCount[SYSTEM_SPB_CAMERA_COUNT];
	vector<TVirtualCaptureUnit2> VirtualCaptureList[SYSTEM_SPB_CAMERA_COUNT];
	unsigned char *CaptureBuffer;
} TCaptureStatus2;
//---------------------------------------------------------------------------
class TVirtualSPBForm : public TTntForm
{
__published:	// IDE-managed Components
	TTimer *VirtualSPBTimer;
private:	// User declarations
	int CurrentSPB;
	bool VirtualNewCaptureMode;
	bool VirtualOptionCaptureMode;
	AnsiString VirtualCaptureDir;
	TVirtualSPB VirtualSPB[SYSTEM_SPB_MAX_COUNT];
	TCaptureStatus2 CaptureStatus[SYSTEM_SPB_MAX_COUNT];

	void __fastcall SwapSPB(int spbIndex);
	void __fastcall InvalidateSPB(void);
public:		// User declarations
	__fastcall TVirtualSPBForm(TComponent* Owner);
	unsigned char * __fastcall ReadVirtualCapture(int captureIndex, int camIndex);
	unsigned char *GetCurrentCaptureBuffer(int spbIndex, int captureIndex, int camIndex);
	unsigned char *GetCurrentNewCaptureBuffer(int spbIndex, int captureIndex, int camIndex);
	void __fastcall Tablet_Capture_Setup(int spbIndex, TTabletCaptureSetupData *tabletCaptureSetupData);
	void __fastcall SPB_Setup_Start(int spbIndex, int mode);
	void __fastcall SPB_Study_Ready(int spbIndex);
	void __fastcall SPB_Inspection_Ready(int spbIndex);
	void __fastcall Init_Tablet_Capture_StudyMode(int spbIndex);
	void __fastcall Init_Tablet_Capture_InspectionMode(int spbIndex, unsigned char cameraMask);
	void __fastcall TabletCapture(int spbIndex, int camIndex);
	void __fastcall SystemSetup(int spbIndex, TSPBSystemSetupData *spbSystemSetupData);
	void __fastcall ApplyVirtualCapture(AnsiString virtualCaptureDir);
	void __fastcall ApplyVirtualNewCapture(AnsiString virtualCaptureDir);
	TSPBProcessingSetupInfo * __fastcall GetSPBProcessingSetupInfo(int spbIndex);
	TStudyResultData_SPB* __fastcall GetVirtualStudyResultData(int spbIndex, int camIndex);
	void __fastcall VirtualSearchDefectImage(int spbIndex, int minDefectTabletNumber, TDefectImageInfo *defectImageInfo);
	void __fastcall VirtualDiscardDefectImage(int spbIndex);
	unsigned char * __fastcall GetDefectImageAddr(int spbIndex, int camIndex);
	unsigned char * __fastcall GetDefectDataAddr(int spbIndex, int camIndex);
};
//---------------------------------------------------------------------------
extern PACKAGE TVirtualSPBForm *VirtualSPBForm;

void __fastcall Virtual_SPB_Tablet_Capture_Setup(int spbIndex, TTabletCaptureSetupData *tabletCaptureSetupData);
void __fastcall Virtual_SPB_Setup_Start(int spbIndex, int mode);
void __fastcall Virtual_SPB_Study_Ready(int spbIndex);
void __fastcall Virtual_SPB_Inspection_Ready(int spbIndex);
void __fastcall Virtual_SPB_Init_Tablet_Capture_StudyMode(int spbIndex);
void __fastcall Virtual_SPB_Init_Tablet_Capture_InspectionMode(int spbIndex, unsigned char cameraMask);

void __fastcall VirtualSystemSetup(int spbIndex, TSPBSystemSetupData *spbSystemSetupData);
TSPBProcessingSetupInfo* __fastcall GetSPBProcessingSetupInfo(int spbIndex);
TStudyResultData_SPB* __fastcall GetVirtualStudyResultData(int spbIndex, int camIndex);
void __fastcall Virtual_SPB_SearchDefectImage(int spbIndex, int minDefectTabletNumber, TDefectImageInfo *defectImageInfo);
void __fastcall Virtual_SPB_DiscardDefectImage(int spbIndex);
unsigned char * __fastcall Virtual_GetDefectImageAddr(int spbIndex, int camIndex);
unsigned char * __fastcall Virtual_GetDefectDataAddr(int spbIndex, int camIndex);
//---------------------------------------------------------------------------
#endif
