//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <mem.h>
#pragma hdrstop

#include "Virtual_SPB_System.h"
#include "data_indicator.h"
#include "Virtual_CPB_Form.h"

//---------------------------------------------------------------------------
// spb source code  spb_system.c  image_control.c  ȭϴ κ̴.
//---------------------------------------------------------------------------

#pragma package(smart_init)

TDefectData_SPB DefectDataList[MAX_IMAGE_BLOCK_INDEX][IMAGE_BUFFER_COUNT];
TSPBTabletProcessInfo SPBTabletProcessInfo;
TSPBSystemSetupData SystemSetupData;
unsigned int Board1MSTmr;
unsigned short BoardID;
TCPBStatus CPBStatus[SYSTEM_CPB_COUNT];
unsigned int CPB_StatusList[SYSTEM_CPB_MAX_COUNT];	// read from cpb
TSPBSubSystem SPBSubSystem;
TProcessingImageInfo ProcessingImageInfo;

TOnReadVirtualCapture OnReadVirtualCapture;

int CurrentSPBIndex = 0;

unsigned short DefectQueueList[DEFECT_QUEUE_SIZE];
int DefectQueueStart, DefectQueueEnd;

TSPBProcessingResultData SPBProcessingResultData[SYSTEM_SPB_MAX_COUNT];
//---------------------------------------------------------------------------
int IsAvailableCPB(int cpbIndex)
{
	if (!CPBStatus[cpbIndex].IsDown)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}
//---------------------------------------------------------------------------
void ClearCPBStatus(void)
{
	int cpbIndex;
	for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
	{
		CPB_StatusList[cpbIndex] = 0;
//		CPBFirstCheck[cpbIndex] = 0;
//		CPBFirstCheckTime[cpbIndex] = 0;
	}

	for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_COUNT; cpbIndex++)
	{
		SPBSubSystem.CPBInfo[cpbIndex].ProcessingState = CPB_PROCESSING_READY;
	}
}
//---------------------------------------------------------------------------
void ClearInspectImage(void)
{
	int imageIndex;

	for (imageIndex = 0; imageIndex < ProcessingImageInfo.ImageCount; imageIndex++)
	{
		ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_EMPTY;
	}

	ProcessingImageInfo.DefectUploadIndex = 0;
	ProcessingImageInfo.CaptureImageIndex = -1;
	ProcessingImageInfo.ProcessingBufferFindingIndex = 0;
	DefectQueueStart = DefectQueueEnd = 0;
}
//---------------------------------------------------------------------------
int Request_SendData(unsigned short indicator, void *data_address, int data_size, int cpbIndex, unsigned int dst_address)
{
	int returnValue = 0;
	returnValue = Virtual_HPI_SendData(indicator, data_address, data_size, cpbIndex);
	if (!returnValue)
	{
		CPBStatus[cpbIndex].IsDown = 1;
	}
	return returnValue;
}
//---------------------------------------------------------------------------
int Request_SendPartialImage(int camIndex, int captureIndex, int left, int top, int width, int height, int cpbIndex)
{
	int returnValue;
	if (SystemSetupData.CameraKind[camIndex] == CAMERA_KIND_CIS)
	{
		//if (camIndex == 1) return 1;
		// load image
		ProcessingImageInfo.ImageBuffer[captureIndex][camIndex] = OnReadVirtualCapture(captureIndex, camIndex);

		returnValue = Virtual_HPI_SendData_2DImageTo2D(IND_IMAGE_BUFFER_1, ProcessingImageInfo.ImageBuffer[captureIndex][camIndex],
			left, top, width, height, SYSTEM_CAMERA_WIDTH, cpbIndex);
	}
	else
	{
		// load image
		ProcessingImageInfo.ImageBuffer[captureIndex][camIndex] = OnReadVirtualCapture(captureIndex, camIndex);

		//returnValue = Virtual_HPI_SendData_2DImageTo2D_Rotate(IND_IMAGE_BUFFER_3D, ProcessingImageInfo.ImageBuffer[captureIndex][camIndex],
		returnValue = Virtual_HPI_SendData_2DImageTo2D(IND_IMAGE_BUFFER_1, ProcessingImageInfo.ImageBuffer[captureIndex][camIndex],
			left, top, width, height, SYSTEM_CAMERA_WIDTH_3D, cpbIndex);
	}
	return returnValue;
}
//---------------------------------------------------------------------------
int Request_ReceiveData(unsigned short indicator, void *data_address, unsigned int data_size, int cpbIndex)
{
	int returnValue;
	returnValue = Virtual_HPI_ReceiveData(indicator, data_address, data_size, cpbIndex);
	return returnValue;
}
//---------------------------------------------------------------------------
void Request_CopyData(void *dst_address, void *src_address, int size)
{
	memcpy(dst_address, src_address, size);
}
//---------------------------------------------------------------------------
void CPBProcessingCheckStart(int cpbIndex)
{
	SPBSubSystem.CPBInfo[cpbIndex].ProcessingState = CPB_PROCESSING_RUNNING;
}
//---------------------------------------------------------------------------
int Check_Process_Finished(int cpbIndex)
{
	return 1;
}
//---------------------------------------------------------------------------
TErrorCode ErrorUnit_Put(unsigned short troubleBoard, unsigned short type, unsigned int code,
	unsigned int value1, unsigned int value2, unsigned int value3)
{

}
//---------------------------------------------------------------------------

int Virtual_HPI_SendData(unsigned int sec_indicator, void *data_address, int data_size, int cpbIndex)
{
	return Virtual_HPI_ReadData(sec_indicator, data_address, data_size, CurrentSPBIndex, cpbIndex);
}
//---------------------------------------------------------------------------
int Virtual_HPI_SendData_2DImageTo2D(unsigned int sec_indicator, void *data_address,
	int left, int top, int width, int height, int arrayWidth, int cpbIndex)
{
	return Virtual_HPI_ReadData_2DImageTo2D(sec_indicator, data_address, left, top, width, height,
		arrayWidth, cpbIndex);
}
//---------------------------------------------------------------------------
int Virtual_HPI_SendData_2DImageTo2D_Rotate(unsigned int sec_indicator, void *data_address,
	int srcLeft, int srcTop, int srcWidth, int srcHeight, int srcArrayWidth, int cpbIndex)
{
	return Virtual_HPI_ReadData_2DImageTo2D_Rotate(sec_indicator, data_address, srcTop, srcLeft, srcHeight, srcWidth,
		srcArrayWidth, cpbIndex);
}
//---------------------------------------------------------------------------
int Virtual_HPI_ReceiveData(unsigned int sec_indicator, void *data_address,
	unsigned int data_size, int cpbIndex)
{
	return Virtual_HPI_WriteData(sec_indicator, data_address, data_size, CurrentSPBIndex, cpbIndex);
}
//---------------------------------------------------------------------------
void InitVirtualSPBSystem(void)
{

}
//---------------------------------------------------------------------------
void ClearCPBDownState(void)
{
	int cpbIndex;
	for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_COUNT; cpbIndex++)
	{
		if (CPBStatus[cpbIndex].Enabled)
		{
			CPBStatus[cpbIndex].IsDown = FALSE;
		}
	}
}
//---------------------------------------------------------------------------
void InitProcessingResultData(void)
{

}
//---------------------------------------------------------------------------
void CheckSPBProcessingStatus(void)
{
}
//---------------------------------------------------------------------------

void VirtualSPBTimerProcess(void)
{
	int spbCamIndex;
	TSPBTabletUnit *tabletUnit;
	int bProcessing, bProcessingAll;

	if (SPBTabletProcessInfo.ProcessingMode == TABLET_PROCESSING_MODE_INSPECTION ||
		SPBTabletProcessInfo.ProcessingMode == TABLET_PROCESSING_MODE_STUDY)
	{
		for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_COUNT; spbCamIndex++)
		{
			tabletUnit = &(SPBTabletProcessInfo.TabletList[SPBTabletProcessInfo.ProcessingTabletListIndex[spbCamIndex]]);
			if (tabletUnit->State == SPB_TABLET_STATE_ON_CAPTURE || tabletUnit->State == SPB_TABLET_STATE_CAPTURED)
			{
				if (tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_CAPTURED)
				{
					if (tabletUnit->Result == SPB_TABLET_RESULT_NONE)
					{
						tabletUnit->Result = SPB_TABLET_RESULT_PROCESSING;
					}
					tabletUnit->ProcessingStartTime[spbCamIndex] = Board1MSTmr;
					tabletUnit->InspectionState[spbCamIndex] = TABLET_INSPECTION_STATE_PROCESSING_READY;
				}			
				else if (tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_PASSED ||
					tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_CAPTURE_ERROR ||
					tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_PROCESSING ||
					tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_PROCESSING_ERROR)
				{
					SPBTabletProcessInfo.ProcessingTabletListIndex[spbCamIndex] = (SPBTabletProcessInfo.ProcessingTabletListIndex[spbCamIndex] + 1) & SPB_TABLET_LIST_MASK;
				}
			}
			else if (tabletUnit->State == SPB_TABLET_STATE_ERROR)
			{
				SPBTabletProcessInfo.ProcessingTabletListIndex[spbCamIndex] = (SPBTabletProcessInfo.ProcessingTabletListIndex[spbCamIndex] + 1) & SPB_TABLET_LIST_MASK;
			}
		}

		tabletUnit = &(SPBTabletProcessInfo.TabletList[SPBTabletProcessInfo.ProcessingAllTabletListIndex]);
		if (tabletUnit->State == SPB_TABLET_STATE_ERROR)
		{
			SPBTabletProcessInfo.ProcessingAllTabletListIndex = (SPBTabletProcessInfo.ProcessingAllTabletListIndex + 1) & SPB_TABLET_LIST_MASK;
		}
		else if (tabletUnit->State == SPB_TABLET_STATE_CAPTURED)
		{
			bProcessingAll = 1;
			for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_COUNT; spbCamIndex++)
			{
				if (tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_CAPTURED ||
					tabletUnit->InspectionState[spbCamIndex] == TABLET_INSPECTION_STATE_PROCESSING_READY)
				{
					bProcessingAll = 0;
				}
			}

			if (bProcessingAll)
			{
				tabletUnit->State = SPB_TABLET_STATE_PROCESSING;
				SPBTabletProcessInfo.ProcessingAllTabletListIndex = (SPBTabletProcessInfo.ProcessingAllTabletListIndex + 1) & SPB_TABLET_LIST_MASK;
			}
		}


	}

	int bInspectComplete;
	int bDefect, errorID, captureImageIndex;
	if (SPBTabletProcessInfo.ProcessingMode == TABLET_PROCESSING_MODE_INSPECTION)
	{

		tabletUnit = &(SPBTabletProcessInfo.TabletList[SPBTabletProcessInfo.ProcessingResultCheckingListIndex]);
		if (tabletUnit->State == SPB_TABLET_STATE_ERROR)
		{
			if (tabletUnit->ImageFrameIndex != -1)
			{
				//ProcessingImageBuffer_Clear(tabletUnit->ImageFrameIndex);
				//ProcessingTimeList[SPBTabletProcessInfo.ProcessingResultCheckingListIndex].CompleteTime = Board1MSTmr;
			}
			SPBTabletProcessInfo.ProcessingResultCheckingListIndex = (SPBTabletProcessInfo.ProcessingResultCheckingListIndex + 1) & SPB_TABLET_LIST_MASK;
		}
		else if (tabletUnit->State == SPB_TABLET_STATE_PROCESSING)
		{
			bInspectComplete = 1;
			bDefect = 0;
			errorID = 0;
			captureImageIndex = tabletUnit->ImageFrameIndex;
			for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_COUNT; spbCamIndex++)
			{
				if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_UNKNOWN)
				{
					bInspectComplete = 0;
					break;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_DEFECT)
				{
					ProcessingImageInfo.TabletNumber[captureImageIndex] = tabletUnit->TabletNumber;
					ProcessingImageInfo.ImageInspectState[captureImageIndex][spbCamIndex] = IMAGE_RESULT_DEFECT;
					bDefect = 1;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_ERROR)
				{
					errorID = 1;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_CPB_FULL)
				{
					errorID = 2;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_CLOSED_TABLET)
				{
					ProcessingImageInfo.TabletNumber[captureImageIndex] = tabletUnit->TabletNumber;
					ProcessingImageInfo.ImageInspectState[captureImageIndex][spbCamIndex] = IMAGE_RESULT_DEFECT;
					errorID = 3;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_UNINS_TABLET_POSITION)
				{
					ProcessingImageInfo.TabletNumber[captureImageIndex] = tabletUnit->TabletNumber;
					ProcessingImageInfo.ImageInspectState[captureImageIndex][spbCamIndex] = IMAGE_RESULT_DEFECT;
					errorID = 4;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_UNINS_BRIGHTNESS_DROPPED)
				{
					ProcessingImageInfo.TabletNumber[captureImageIndex] = tabletUnit->TabletNumber;
					ProcessingImageInfo.ImageInspectState[captureImageIndex][spbCamIndex] = IMAGE_RESULT_DEFECT;
					errorID = 5;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_UNINS_BRIGHTNESS_CHASE)
				{
					//ProcessingImageInfo.TabletNumber[captureImageIndex] = tabletUnit->TabletNumber;
					//ProcessingImageInfo.ImageInspectState[captureImageIndex][camIndex] = IMAGE_RESULT_DEFECT;
					errorID = 6;
				}
				else if (tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_THIN_TABLET ||
					tabletUnit->ProcessingResult[spbCamIndex] == TABLET_PROCESSING_RESULT_FAT_TABLET)
				{
					ProcessingImageInfo.TabletNumber[captureImageIndex] = tabletUnit->TabletNumber;
					ProcessingImageInfo.ImageInspectState[captureImageIndex][spbCamIndex] = IMAGE_RESULT_DEFECT;
					errorID = 7;
				}
			}
			if (bInspectComplete)
			{
				if (errorID == 1)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR;
					ProcessingImageBuffer_Clear(captureImageIndex);
				}
				else if (errorID == 2)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_UNINS_CPB_FULL;
					ProcessingImageBuffer_Clear(captureImageIndex);
				}
				else if (errorID == 3)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_UNINS_CLOSED_TABLET;
					ProcessingImageBuffer_MarkDefect(captureImageIndex);
				}
				else if (errorID == 4)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_UNINS_TABLET_POSITION;
					ProcessingImageBuffer_MarkDefect(captureImageIndex);
				}
				else if (errorID == 5)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED;
					ProcessingImageBuffer_MarkDefect(captureImageIndex);
				}
				else if (errorID == 6)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE;
					ProcessingImageBuffer_Clear(captureImageIndex);
				}
				else if (errorID == 7)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_GOOD;
					ProcessingImageBuffer_MarkDefect(captureImageIndex);
				}
				else if (bDefect)
				{
					tabletUnit->Result = SPB_TABLET_RESULT_DEFECT;
					ProcessingImageBuffer_MarkDefect(captureImageIndex);
				}
				else
				{
					tabletUnit->Result = SPB_TABLET_RESULT_GOOD;
					ProcessingImageBuffer_Clear(captureImageIndex);
				}
				tabletUnit->State = SPB_TABLET_STATE_PROCESSING_COMPLETE;
				//ProcessingTimeList[SPBTabletProcessInfo.ProcessingResultCheckingListIndex].CompleteTime = Board1MSTmr;
				SPBTabletProcessInfo.ProcessingResultCheckingListIndex = (SPBTabletProcessInfo.ProcessingResultCheckingListIndex + 1) & SPB_TABLET_LIST_MASK;
			}
		}
	}
}
//---------------------------------------------------------------------------

void MakeProcessingResultData(int spbIndex)
{
	int listIndex, i, camIndex;
	TSPBTabletUnit *tabletUnit;
	TSPBProcessingResultData tempProcessingResultData;
	unsigned int gie;

	//listIndex = SPBTabletProcessInfo.ProcessingTabletListIndex;
//	listIndex = (SPBTabletProcessInfo.ProcessingResultCheckingListIndex + 4)  & SPB_TABLET_LIST_MASK;
	listIndex = SPBTabletProcessInfo.PollingCaptureAllEndListIndex;

	if (SPBTabletProcessInfo.TabletList[SPBTabletProcessInfo.PollingCaptureAllEndListIndex].State == SPB_TABLET_STATE_PROCESSING_COMPLETE)
	{
		SPBTabletProcessInfo.PollingCaptureAllEndListIndex = (SPBTabletProcessInfo.PollingCaptureAllEndListIndex + 1) & SPB_TABLET_LIST_MASK;
	}

	tempProcessingResultData.CompleteCount = 0;
	for (i = 0; i < SPB_TABLET_LIST_COUNT; i++)
	{
		tabletUnit = &(SPBTabletProcessInfo.TabletList[listIndex]);
		if (tabletUnit->State > SPB_TABLET_STATE_CAPTURED && tabletUnit->State <= SPB_TABLET_STATE_PROCESSING_COMPLETE)
		{
			tempProcessingResultData.ProcessedTabletNumber[tempProcessingResultData.CompleteCount] = tabletUnit->TabletNumber;
			tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] = tabletUnit->Result;
/*
			if (tabletUnit->PrintResult[0])
			{
				tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |= SPB_TABLET_RESULT_PRINT_IS_CAM1;
			}
			if (tabletUnit->PrintResult[1])
			{
				tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |= SPB_TABLET_RESULT_PRINT_IS_CAM2;
			}
			if (tabletUnit->PrintResult[2])
			{
				tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |= SPB_TABLET_RESULT_PRINT_IS_CAM3;
			}
*/
			for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
			{
				if (tabletUnit->InspectionState[camIndex] != TABLET_INSPECTION_STATE_PROCESSING_COMPLETE)
				{
					continue;
				}
				if (SystemSetupData.CameraKind[camIndex] == CAMERA_KIND_RANGER_3D)
				{
					if (tabletUnit->ThickErrorSW[camIndex] != 0)
					{
						tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |= SPB_TABLET_RESULT_THICKERROR_MASK;
					}
//					tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |=
//						((tabletUnit->ThickErrorSW[camIndex] << SPB_TABLET_RESULT_PRINT_THICKERROR_SHIFT) & SPB_TABLET_RESULT_THICKERROR_MASK);
				}

				if (SystemSetupData.GlobalCameraIndex[camIndex] == 0 || SystemSetupData.GlobalCameraIndex[camIndex] == 5)
				{
					if (tabletUnit->PrintResult[camIndex] != 0)
					{
						tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |= SPB_TABLET_RESULT_PRINT_IS_MASK;
					}
					if (tabletUnit->Front_Rear[camIndex] == FRONT_FACE_FOR_COLOR)
					{
						tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] |= SPB_TABLET_RESULT_FRONT_FACE_MASK;
					}
				}
			}

			tempProcessingResultData.CompleteCount++;
			if (tempProcessingResultData.CompleteCount == SPB_PROCESSING_RESULT_COUNT) break;
		}
		else if (tabletUnit->State == SPB_TABLET_STATE_ERROR)
		{
			tempProcessingResultData.ProcessedTabletNumber[tempProcessingResultData.CompleteCount] = tabletUnit->TabletNumber;
			tempProcessingResultData.ProcessingResult[tempProcessingResultData.CompleteCount] = tabletUnit->Result;
			tempProcessingResultData.CompleteCount++;
			if (tempProcessingResultData.CompleteCount == SPB_PROCESSING_RESULT_COUNT) break;
		}
		listIndex = (listIndex - 1) & SPB_TABLET_LIST_MASK;
	}  

	memcpy(&SPBProcessingResultData[spbIndex], &tempProcessingResultData, sizeof(TSPBProcessingResultData));
}

//---------------------------------------------------------------------------
void SearchDefectImage(int minDefectTabletNumber, TDefectImageInfo *defectImageInfo)
{
	int camIndex;
	int anyDefectExist;
	int imageIndex;
	unsigned int gie;

	anyDefectExist = 0;

	for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
	{
		defectImageInfo->DefectCameraMask[camIndex] = 0;
	}

	// make uploding status complete
	if (DefectQueueStart != DefectQueueEnd)
	{
		imageIndex = DefectQueueList[DefectQueueStart];
		if (ProcessingImageInfo.ImageState[imageIndex] == IMAGE_STATE_UPLOADING)
		{
			ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_EMPTY;
			DefectQueueStart = (DefectQueueStart + 1) & DEFECT_QUEUE_MASK;
		}
	}


	//if (DefectQueueStart != DefectQueueEnd)
	while (DefectQueueStart != DefectQueueEnd)
	{
		imageIndex = DefectQueueList[DefectQueueStart];

		if (ProcessingImageInfo.TabletNumber[imageIndex] < minDefectTabletNumber)
		{
			ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_EMPTY;
			DefectQueueStart = (DefectQueueStart + 1) & DEFECT_QUEUE_MASK;
		}
		else
		{
			for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
			{
				if (ProcessingImageInfo.ImageInspectState[imageIndex][camIndex] == IMAGE_RESULT_DEFECT)
				{
					defectImageInfo->DefectCameraMask[camIndex] = 1;
					anyDefectExist = 1;
				}
			}

			if (!anyDefectExist)
			{
				DefectQueueStart = (DefectQueueStart + 1) & DEFECT_QUEUE_MASK;
				ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_EMPTY;
			}
			else
			{
				break;
			}
		}
	}

	if (anyDefectExist)
	{			
		defectImageInfo->DefectExists = 1;
		defectImageInfo->DefectTabletNumber = ProcessingImageInfo.TabletNumber[imageIndex];
//		ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_UPLOADING;
		ProcessingImageInfo.DefectUploadIndex = imageIndex;
	}
	else
	{
		defectImageInfo->DefectExists = 0;
		defectImageInfo->DefectTabletNumber = 0;
	}
}
//---------------------------------------------------------------------------
void DiscardDefectImage(void)
{
	ProcessingImageInfo.ImageState[ProcessingImageInfo.DefectUploadIndex] = IMAGE_STATE_EMPTY;
	DefectQueueStart = (DefectQueueStart + 1) & DEFECT_QUEUE_MASK;
}
//---------------------------------------------------------------------------
void ProcessingImageBuffer_Clear(int imageIndex)
{
	ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_EMPTY;
}
//---------------------------------------------------------------------------
void ProcessingImageBuffer_MarkCaptured(int imageIndex)
{
	ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_CAPTURED;
}
//---------------------------------------------------------------------------
void ProcessingImageBuffer_MarkDefect(int imageIndex)
{
	ProcessingImageInfo.ImageState[imageIndex] = IMAGE_STATE_DEFECT;
	DefectQueueList[DefectQueueEnd] = imageIndex;
	DefectQueueEnd = (DefectQueueEnd + 1) & DEFECT_QUEUE_MASK;
	if (DefectQueueEnd == DefectQueueStart)	// overflow
	{
		ProcessingImageInfo.ImageState[DefectQueueList[DefectQueueStart]] = IMAGE_STATE_EMPTY;
		DefectQueueStart = (DefectQueueStart + 1) & DEFECT_QUEUE_MASK;
	}
}
//---------------------------------------------------------------------------




