//---------------------------------------------------------------------------

#ifndef Virtual_SPB_SystemH
#define Virtual_SPB_SystemH

#include "common.h"
#include "processing.h"
#include "Virtual_SPB_Heap_Control.h"

#define MAX_IMAGE_BLOCK_INDEX			256
#define IMAGE_BUFFER_COUNT				3


typedef unsigned char * __fastcall (__closure *TOnReadVirtualCapture) (int captureIndex, int camIndex);

extern TOnReadVirtualCapture OnReadVirtualCapture;

extern TDefectData_SPB DefectDataList[MAX_IMAGE_BLOCK_INDEX][IMAGE_BUFFER_COUNT];
extern TSPBTabletProcessInfo SPBTabletProcessInfo;
extern TSPBSystemSetupData SystemSetupData;
extern unsigned int Board1MSTmr;
extern unsigned short BoardID;
extern TCPBStatus CPBStatus[SYSTEM_CPB_COUNT];
extern unsigned int CPB_StatusList[SYSTEM_CPB_MAX_COUNT];	// read from cpb

typedef struct
{
	unsigned char ProcessingState;
} TSSCPBInfo;

typedef struct
{
	TSSCPBInfo CPBInfo[SYSTEM_CPB_COUNT];
} TSPBSubSystem;

extern TSPBSubSystem SPBSubSystem;

typedef struct
{
//	int Filled[MAX_IMAGE_BLOCK_INDEX];
	int ImageState[MAX_IMAGE_BLOCK_INDEX];
	int ImageInspectState[MAX_IMAGE_BLOCK_INDEX][IMAGE_BUFFER_COUNT];
	int TabletNumber[MAX_IMAGE_BLOCK_INDEX];
//	unsigned int TabletIndex[MAX_IMAGE_BLOCK_INDEX];
	int ImageCount;
	int CaptureImageIndex;
//	int DefectImageIndex;
	int DefectUploadIndex;
	int ProcessingBufferFindingIndex;
	unsigned char *ImageBuffer[MAX_IMAGE_BLOCK_INDEX][IMAGE_BUFFER_COUNT];
	unsigned char *DummyBuffer[IMAGE_BUFFER_COUNT];
} TProcessingImageInfo;

extern TProcessingImageInfo ProcessingImageInfo;

extern int CurrentSPBIndex;

extern TSPBProcessingResultData SPBProcessingResultData[SYSTEM_SPB_MAX_COUNT];

#define DEFECT_QUEUE_SIZE		256
#define DEFECT_QUEUE_MASK		255

extern unsigned short DefectQueueList[DEFECT_QUEUE_SIZE];
extern int DefectQueueStart, DefectQueueEnd;
//---------------------------------------------------------------------------
int IsAvailableCPB(int cpbIndex);
void ClearCPBStatus(void);
void ClearInspectImage(void);
int Request_SendData(unsigned short indicator, void *data_address, int data_size, int cpbIndex, unsigned int dst_address);
int Request_SendPartialImage(int camIndex, int captureIndex, int left, int top, int width, int height, int cpbIndex);
int Request_ReceiveData(unsigned short indicator, void *data_address, unsigned int data_size, int cpbIndex);
void Request_CopyData(void *dst_address, void *src_address, int size);
void CPBProcessingCheckStart(int cpbIndex);
int Check_Process_Finished(int cpbIndex);

TErrorCode ErrorUnit_Put(unsigned short troubleBoard, unsigned short type, unsigned int code,
	unsigned int value1, unsigned int value2, unsigned int value3);

int Virtual_HPI_SendData(unsigned int sec_indicator, void *data_address, int data_size, int cpbIndex);
int Virtual_HPI_SendData_2DImageTo2D(unsigned int sec_indicator, void *data_address,
	int left, int top, int width, int height, int arrayWidth, int cpbIndex);
int Virtual_HPI_SendData_2DImageTo2D_Rotate(unsigned int sec_indicator, void *data_address,
	int srcLeft, int srcTop, int srcWidth, int srcHeight, int srcArrayWidth, int cpbIndex);
int Virtual_HPI_ReceiveData(unsigned int sec_indicator, void *data_address,
	unsigned int data_size, int cpbIndex);
void InitVirtualSPBSystem(void);
void ClearCPBDownState(void);
void InitProcessingResultData(void);
void VirtualSPBTimerProcess(void);
void MakeProcessingResultData(int spbIndex);
void SearchDefectImage(int minDefectTabletNumber, TDefectImageInfo *defectImageInfo);
void DiscardDefectImage(void);

void ProcessingImageBuffer_Clear(int imageIndex);
void ProcessingImageBuffer_MarkCaptured(int imageIndex);
void ProcessingImageBuffer_MarkDefect(int imageIndex);
//---------------------------------------------------------------------------
#endif
