//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Waiting_Form.h"
#include "Message_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"

#define MACHINE_TIMEOUT			30000
#define TEXT_BLANK				50
#define MIN_FORM_SIZE			360
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TWaitingForm *WaitingForm;
//---------------------------------------------------------------------------
__fastcall TWaitingForm::TWaitingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

}
//---------------------------------------------------------------------------
int __fastcall TWaitingForm::WaitingMachineStop(void)
{
	TCursor oldCursor;
    oldCursor = this->Cursor;
    this->Cursor = crHourGlass;  
	WaitingResult = 0;
	WaitingMode = EWM_MACHINE_STOP;

    WaitingStartTime = GetTickCount();
    StatusCheckTimer->Enabled = true;
    ShowWaitingMessage(WAITINGFORM_MSG_02);
	this->Cursor = oldCursor;
	return WaitingResult;
}
//---------------------------------------------------------------------------
void __fastcall TWaitingForm::ShowWaitingMessage(WideString msg)
{
	MessageLabel->Caption = msg;

	int formWidth = MessageLabel->Canvas->TextWidth(msg) + 2 * TEXT_BLANK;
	if (formWidth < MIN_FORM_SIZE) formWidth = MIN_FORM_SIZE;

	this->Width = formWidth;
	MessageLabel->Left = (formWidth - MessageLabel->Canvas->TextWidth(msg)) / 2;
	this->Height = 70;

	this->Position = poScreenCenter;

	if (!this->Visible)
	{
		this->ShowModal();
	}
}
//---------------------------------------------------------------------------
void __fastcall TWaitingForm::StatusCheckTimerTimer(TObject *Sender)
{
	if ((int)(GetTickCount() - WaitingStartTime) > MACHINE_TIMEOUT)
	{
		StatusCheckTimer->Enabled = false;
		ShowMessageFA(WAITINGFORM_MSG_01);
		WaitingResult = 0;
		ModalResult = mrCancel;
		return;
	}

	if (WaitingMode == EWM_MACHINE_STOP)
	{
		if (Machine.Status.OperationState == MACHINE_STATE_STOP ||
			Machine.Status.OperationState == MACHINE_STATE_CLEANING)
		{
			WaitingResult = 1;
			StatusCheckTimer->Enabled = false;
			ModalResult = mrOk;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TWaitingForm::SetMessage(WideString msg)
{
	MessageLabel->Caption = msg;

	int formWidth = MessageLabel->Canvas->TextWidth(msg) + 2 * TEXT_BLANK;
	if (formWidth < MIN_FORM_SIZE) formWidth = MIN_FORM_SIZE;

	this->Width = formWidth;
	MessageLabel->Left = (formWidth - MessageLabel->Canvas->TextWidth(msg)) / 2;
	this->Height = 70;

	this->Position = poScreenCenter;
}
//---------------------------------------------------------------------------

