#include "common.h"
#include "timer.h"
#include "machineControl.h"
#include "capture.h"
#include "system_setup.h"
#include "HCB_System_Process.h"
#include "hardware.h"
#include "tablet_control.h"

#define CAPTURE_STEP_NONE			0
#define CAPTURE_STEP_READY			1
#define CAPTURE_STEP_LED_ON			2
#define CAPTURE_STEP_WAITING		3
#define CAPTURE_STEP_LED_WAITING	4


#define CAPTURE_MODE_SINGLE		0
#define CAPTURE_MODE_MULTI		1
#define LED_ON_DELAY				4

TMachineCaptureInfo MachineCaptureInfo;

struct
{
	unsigned int Enabled;
	int FrameTime;
	int LEDMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int LEDDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int LEDOnTime[SYSTEM_MACHINE_CAPTURE_COUNT];
	int LEDState[SYSTEM_MACHINE_CAPTURE_COUNT];
	int ShutterDelay;
	unsigned int CaptureStartTime;
	int CaptureStep;
	int CaptureMode;
	int ContinuousCapture;
	int CaptureStartDelay;
} HCBCaptureInfo;

TTPBCaptureInfo TPBCaptureInfo;
struct
{
	int LEDMask[SYSTEM_TOTAL_LED_COUNT];
	int CaptureMask[SYSTEM_TOTAL_LED_COUNT];
	int LEDOnTime[SYSTEM_TOTAL_LED_COUNT];
	int LEDPeriod[SYSTEM_TOTAL_LED_COUNT];
}HCBLedInfo;

#define SENSOR_CAPTURE_STATE_NONE		0
#define SENSOR_CAPTURE_STATE_READY		1
#define SENSOR_CAPTURE_STATE_ACTIVE		2

#define TPB_CAPTTURE_OFF					0
#define TPB_CAPTTURE_ON					1
#define TPB_CAPTTURE_PAUSE					2

#define TPB_CAPTTURE_PAUSE_TIME			60000	// 3sec
#define CAPTURE_TIME_LIMIT				200		// 10 ms,    sjm Not Use



struct
{
	int State1;
	int SensorState1;
	unsigned int SensorTime1;
	int CaptureTime1;
	int CameraState1[3];
	int LEDState1[3];
	int State2;	
	int SensorState2;
	unsigned int SensorTime2;
	int CaptureTime2;
	int CameraState2[3];
	int LEDState2[3];
	int Enabled;
} SensorCaptureInfo;

int TPBProcess_flag = 0;
int test_isr[10]={0,0,0,0,0,0,0,0,0,0};

void HCB_Caputre_LEDOn(int ledMask, int ledOnTime);

void HCB_Capture_Init(void)
{
	int captureIndex;

	HCBCaptureInfo.Enabled = 0;
	HCBCaptureInfo.FrameTime = 0;
	HCBCaptureInfo.CaptureStartDelay = 0;
	HCBCaptureInfo.ContinuousCapture = 0;
	HCBCaptureInfo.CaptureStep = CAPTURE_STEP_NONE;

	for (captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
	{
		HCBCaptureInfo.LEDDelay[captureIndex] = 0;
		HCBCaptureInfo.LEDOnTime[captureIndex] = 0;
		HCBCaptureInfo.LEDMask[captureIndex] = 0;
	}

	SensorCaptureInfo.Enabled = 0;
	SensorCaptureInfo.State1 = SENSOR_CAPTURE_STATE_NONE;
	SensorCaptureInfo.State2 = SENSOR_CAPTURE_STATE_NONE;
}

void HCB_Capture_Ready(int frameTime, int *ledMask, int *ledDelay, int *ledOnTime, int shutterDelay)
{
	HCBCaptureInfo.ShutterDelay 		= shutterDelay/20;
	HCBCaptureInfo.LEDDelay[0] 			= 0;
	HCBCaptureInfo.LEDOnTime[0] 		= ledOnTime[0];
	HCBCaptureInfo.LEDMask[0] 			= ledMask[0];
	HCBCaptureInfo.FrameTime 			= frameTime;
	HCBCaptureInfo.CaptureStartDelay 	= HCBCaptureInfo.FrameTime ;
	HCBCaptureInfo.Enabled 				= 1;
	HCBCaptureInfo.CaptureMode 			= CAPTURE_MODE_SINGLE;
	HCBCaptureInfo.CaptureStep 			= CAPTURE_STEP_READY;
	if (frameTime > 0)
	{
		HCBCaptureInfo.ContinuousCapture = 1;
	}
	else
	{
		HCBCaptureInfo.ContinuousCapture = 0;
	}
	HCB_TPB_Capture_Stop();
}

void HCB_Capture_Ready_Multi(int frameTime, int *ledMask, int *ledDelay, int *ledOnTime, int shutterDelay)
{
	int captureIndex;
	HCBCaptureInfo.ShutterDelay = shutterDelay;
	for (captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
	{
		HCBCaptureInfo.LEDDelay[captureIndex] = 0; //ledDelay[captureIndex];
		HCBCaptureInfo.LEDOnTime[captureIndex] = ledOnTime[captureIndex];
		HCBCaptureInfo.LEDMask[captureIndex] = ledMask[captureIndex];
		HCBCaptureInfo.LEDState[captureIndex] = 0;
	}
	HCBCaptureInfo.FrameTime = frameTime / 20;
	HCBCaptureInfo.CaptureStartDelay = 	HCBCaptureInfo.FrameTime;
	HCBCaptureInfo.Enabled = 1;
	HCBCaptureInfo.CaptureMode = CAPTURE_MODE_MULTI;
	HCBCaptureInfo.CaptureStep = CAPTURE_STEP_READY;	

	if (frameTime > 0)
	{
		HCBCaptureInfo.ContinuousCapture = 1;
	}
	else
	{
		HCBCaptureInfo.ContinuousCapture = 0;
	}
}

void HCB_Capture_Stop(void)
{
	HCBCaptureInfo.FrameTime = 0;
	HCBCaptureInfo.Enabled = 0;
}

void HCB_TPB_Capture_Start(int frameTime, int *ledMask, int *ledDelay, int *ledOnTime, int shutterDelay)
{
	TPBCaptureInfo.ShutterDelay 			= shutterDelay;
	TPBCaptureInfo.LEDDelay				= 0;
	TPBCaptureInfo.LEDOnTime 			= ledOnTime[0];
	TPBCaptureInfo.LEDMask	 			= ledMask[0];
	TPBCaptureInfo.FrameTime 			= frameTime;
	TPBCaptureInfo.FrameTimeCount 		= frameTime;
	TPBCaptureInfo.Enabled= 1;
	TPBCaptureInfo.status = TPB_CAPTTURE_PAUSE;
	TPBCaptureInfo.lastSensorTime = 0;
}
void HCB_TPB_Capture_Stop(void)
{
	TPBCaptureInfo.Enabled = 0;
	TPBCaptureInfo.FrameTime = 0;
	TPBCaptureInfo.lastSensorTime = 0;
	TPBCaptureInfo.status = TPB_CAPTTURE_OFF;
}

void HCB_Capture_Process_1ms(void)		// per 1ms
{
	unsigned int elapsedTime;
	int captureIndex;
	int captureComplete;

	if (HCBCaptureInfo.Enabled)
	{
		if (HCBCaptureInfo.CaptureMode == CAPTURE_MODE_SINGLE)
		{
			if (HCBCaptureInfo.CaptureStep == CAPTURE_STEP_READY)
			{	
				HCB_Caputre_LEDOn(HCBCaptureInfo.LEDMask[0], HCBCaptureInfo.LEDOnTime[0]);
				HCBCaptureInfo.CaptureStartTime = board50usTmr;
				HCBCaptureInfo.CaptureStep = CAPTURE_STEP_LED_ON;
			}
			else if (HCBCaptureInfo.CaptureStep == CAPTURE_STEP_LED_ON)
			{
				if (board50usTmr - HCBCaptureInfo.CaptureStartTime >= HCBCaptureInfo.ShutterDelay)//HCBCaptureInfo.ShutterDelay) //ͷƮ  !!
				{
					SendCaptureInt(SUCTION_DISK_NUM1 -1);
					SendCaptureInt(SUCTION_DISK_NUM2 -1);
					if (HCBCaptureInfo.ContinuousCapture)
					{
						HCBCaptureInfo.CaptureStep = CAPTURE_STEP_WAITING;
					}
					else
					{
						HCBCaptureInfo.CaptureStep = CAPTURE_STEP_NONE;
						HCBCaptureInfo.Enabled = 0;
					}
				}
			}
			else if (HCBCaptureInfo.CaptureStep == CAPTURE_STEP_WAITING)
			{
				HCBCaptureInfo.CaptureStartDelay--;
				if (HCBCaptureInfo.CaptureStartDelay <= 0)
				{
					HCBCaptureInfo.CaptureStep = CAPTURE_STEP_READY;
					HCBCaptureInfo.CaptureStartDelay = HCBCaptureInfo.FrameTime;
				}
			}
		}
		else
		{
			if (HCBCaptureInfo.CaptureStep == CAPTURE_STEP_READY)
			{				
				SendCaptureInt(SUCTION_DISK_NUM1 -1);
				SendCaptureInt(SUCTION_DISK_NUM2 -1);
				HCBCaptureInfo.CaptureStartTime = board50usTmr;
				HCBCaptureInfo.CaptureStep = CAPTURE_STEP_LED_WAITING;
			}
			else if (HCBCaptureInfo.CaptureStep == CAPTURE_STEP_LED_WAITING)
			{
				captureComplete = 1;
				elapsedTime = board50usTmr - HCBCaptureInfo.CaptureStartTime;				
				for (captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
				{
					if (HCBCaptureInfo.LEDState[captureIndex] == 0)
					{
						if (HCBCaptureInfo.LEDDelay[captureIndex] <= elapsedTime)
						{
							HCB_Caputre_LEDOn(HCBCaptureInfo.LEDMask[captureIndex], HCBCaptureInfo.LEDOnTime[captureIndex]);
							HCBCaptureInfo.LEDState[captureIndex] = 1;
						}
						else
						{
							captureComplete = 0;
						}
					}
				}			
				if (captureComplete)
				{
					if (HCBCaptureInfo.ContinuousCapture)
					{
						HCBCaptureInfo.CaptureStep = CAPTURE_STEP_WAITING;
					}
					else
					{
						HCBCaptureInfo.CaptureStep = CAPTURE_STEP_NONE;
						HCBCaptureInfo.Enabled = 0;
					}
				}
			}
			else if (HCBCaptureInfo.CaptureStep == CAPTURE_STEP_WAITING)
			{
				HCBCaptureInfo.CaptureStartDelay--;
				if (HCBCaptureInfo.CaptureStartDelay <= 0)
				{
					HCBCaptureInfo.CaptureStep = CAPTURE_STEP_READY;
					HCBCaptureInfo.CaptureStartDelay = HCBCaptureInfo.FrameTime;
				}
			}
		}
	}
}

void HCB_Caputre_LEDOn(int ledMask, int ledOnTime)
{
	int ledIndex;
	for (ledIndex = 0; ledIndex < SYSTEM_TOTAL_LED_COUNT; ledIndex++)
	{
		if (ledMask & (0x0001 << ledIndex))
		{
			if(MachineStatus.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET && MachineStatus.SuctionDisk2LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
			{
				if(ledIndex == 2 || ledIndex == 8)    //side 1
				{
					HCBLedInfo.LEDOnTime[ledIndex] = board50usTmr+(0*LAMP_SUGAR_TABLET_DELAY)+LED_ON_DELAY ;
				}
				else if(ledIndex == 3 || ledIndex == 9) 	//side 2
				{
					HCBLedInfo.LEDOnTime[ledIndex] = board50usTmr+(1*LAMP_SUGAR_TABLET_DELAY)+LED_ON_DELAY;
				}	
				else if(ledIndex == 0 || ledIndex == 1 || ledIndex == 6 || ledIndex == 7)		//front disk1
				{
					HCBLedInfo.LEDOnTime[ledIndex] = board50usTmr+(2*LAMP_SUGAR_TABLET_DELAY)+LED_ON_DELAY;
				}
				else if(ledIndex == 4 || ledIndex == 10)	//side 3
				{
					HCBLedInfo.LEDOnTime[ledIndex] = board50usTmr+(3*LAMP_SUGAR_TABLET_DELAY)+LED_ON_DELAY;
				}	
				else if(ledIndex == 5 || ledIndex == 11)	//side 4
				{
					HCBLedInfo.LEDOnTime[ledIndex] = board50usTmr+(4*LAMP_SUGAR_TABLET_DELAY)+LED_ON_DELAY;
				}					
			}
			else
			{
				HCBLedInfo.LEDOnTime[ledIndex] = board50usTmr+LED_ON_DELAY;
			}
			HCBLedInfo.LEDPeriod[ledIndex] = ledOnTime;
			HCBLedInfo.LEDMask[ledIndex] = 1;
		}
	}
}

	
void HCB_LEDControl_Process(void)
{
	int ledIndex = 0;
	
	for (ledIndex = 0; ledIndex < SYSTEM_TOTAL_LED_COUNT; ledIndex++)
	{
		if(HCBLedInfo.LEDMask[ledIndex] == 1)
		{	
			if(board50usTmr > HCBLedInfo.LEDOnTime[ledIndex])
			{
				if(MachineStatus.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET && MachineStatus.SuctionDisk2LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
				{
					if(HCBCaptureInfo.Enabled)
					{
						MC_LED_On(ledIndex, LED_TYPE_FLASH, HCBLedInfo.LEDPeriod[ledIndex], 0);
					}
					else 
					{
						MC_LED_On(ledIndex, LED_TYPE_FLASH, 8, 0);
					}
				}
				else
				{
					MC_LED_On(ledIndex, LED_TYPE_FLASH, HCBLedInfo.LEDPeriod[ledIndex], 0);
				}
				HCBLedInfo.LEDMask[ledIndex] = 0;
			}
		}
	}
}
void HCB_TPB_Capture_Process(void)
{
	int ledIndex = 0;

	if(TPBCaptureInfo.Enabled)
	{
		if(TabletControlData.Func != TABLET_CONTROL_FUNC_NONE)
		{
			if ((THREED_CAMERA_SENSOR&0x8))
			{
				HCB_Caputre_LEDOn(TPBCaptureInfo.LEDMask, TPBCaptureInfo.LEDOnTime);
			}
		}
		else
		{
			if ((THREED_CAMERA_SENSOR&0x8))
			{
				HCB_Caputre_LEDOn(TPBCaptureInfo.LEDMask, TPBCaptureInfo.LEDOnTime);
			}		
		}
	}

}

void HCB_Capture_LEDChange(int ledMask)
{
	HCBCaptureInfo.LEDMask[0] = ledMask;
}
void ApplyMachineCaptureSetupData(TMachineCaptureInfo *machineCaptureInfo)
{
	memcpy(&MachineCaptureInfo, machineCaptureInfo, sizeof(TMachineCaptureInfo));
}

void TPB_Initialize()
{
	memset(TPBCaptureInfo, 0, sizeof(TPBCaptureInfo));
}
