#ifndef _ENVIRONMENT_H_
#define _ENVIRONMENT_H_

#include "common.h"
#include "command.h"


#define OPR_LEVEL_0		0
#define OPR_LEVEL_1		1
#define OPR_LEVEL_2		2
#define OPR_LEVEL_3		3
#define OPR_LEVEL_4		4

extern THCBProgramHeader HCBProgramHeader;
extern THCBDBHeader HCBDBHeader;
extern THCBMachineSpecificHeader HCBMachineSpecificHeader;
extern THCBCompatibility HCBCompatibility;

extern unsigned short BoardID;
extern unsigned int packetID;
extern TPcUiFlag PCUIFlag;
//extern THCBStatusList HCBStatusList;
/*
typedef struct
{
	unsigned int data[TOTAL_CLIENT_COUNT];
} TStatusList;

extern TStatusList statusList;
*/

#define DOWNLOAD_MAX_SIZE		0x00300000		// 3MB
#define CODE_MAX_SIZE			0x00180000
extern unsigned char ProgramBuffer[DOWNLOAD_MAX_SIZE];

#define EXPECTED_COM_START_TIME			100000		// after 300sec
#define MIN_BLACKOUT_CHECK_TIME			20000  //60000
typedef struct
{
	unsigned int MasterLastComTime;
	int BlackoutOccured;
	int BlackoutStep;
	int TabletPassWaitingTime;
	int MachineStopDelay;
	int PCWaitingDelay;
} TBlackoutInfo;

//sjm Add Safety mode Select
typedef struct
{
	char InactivityLogoutEnabled;
	int InactivityTimeout;
	char PasswordExpirationEnabled;
	int PasswordExpirationTime;
	int PasswordMinLength;
    char FirstLoginChangePW;
} TComputerSystemInfo;
extern TComputerSystemInfo ComputerSystemInfo;


extern TProgramVersion ProgramVersion;
extern TBlackoutInfo BlackoutInfo;
extern int ServoMotorBaseSpeed[MAX_SERVO_MOTOR_COUNT];

extern TPortStatus PortStatus;

#endif
