#ifndef _FM_SPANSION_H_
#define _FM_SPANSION_H_

#include "hardware.h"

#define FLASH_PAGESIZE			0x00010000			//64k         
#define FLASH_BASE               		( 0xB0000000 +(FLASH_PAGESIZE*8))
#define FLASH_END_OR_RANGE	( 0xC0000000 )

#define MFG_SPANSION                0x01
#define DEV_S29GL032N_1		0x01
#define DEV_S29GL032N_2          	0x1A
#define DEV_S29GL032N_3          	0x01
#define DEV_S29GL032N_SIZE       	0x00400000

#define FLASH_PAGES                 56
#define FLASH_SUPPORT               1

#define FLASH_BASE_PTR8         *( volatile Uint8* ) FLASH_BASE
#define FLASH_CTL555            *( volatile Uint8* )( FLASH_BASE + 0x555 )
#define FLASH_CTLAAA            *( volatile Uint8* )( FLASH_BASE + 0xAAA )

#define FLASH_RESET                         0xF0
#define FLASH_CMD_AA                        0xAA
#define FLASH_CMD_55                        0x55
#define FLASH_ID                            0x90
#define FLASH_PROGRAM                       0xA0
#define FLASH_WRITE_BUFFER                  0x25
#define FLASH_PROGRAM_BUFFER                0x29
#define FLASH_ERASE                         0x80
#define FLASH_ERASE_CHIP                    0x10
#define FLASH_ERASE_SECTOR                  0x30
#define FLASH_ERASE_SUSPEND                 0xB0
#define FLASH_ERASE_RESUME                  0x10
#define FLASH_CFI_QUERY                     0x98

#define READ_STATUS_REGISTER_ISMS           0x80 // WRITE STATE MACHINE
#define READ_STATUS_REGISTER_ESS            0x40 // ERASE SUSPEND
#define READ_STATUS_REGISTER_ECLBS          0x20 // ERASE & CLEAR LOCK BITS
#define READ_STATUS_REGISTER_PSLBS          0x10 // PROGRAM & SET LOCK BIT
#define READ_STATUS_REGISTER_VPENS          0x08 // PROGRAMMING VOLTAGE
#define READ_STATUS_REGISTER_PSS            0x04 // PROGRAM SUSPEND
#define READ_STATUS_REGISTER_DPS            0x02 // DEVICE PROTECT

int FLASH_read( Uint32 dst, Uint32 page, Uint32 length );
int FLASH_write( Uint32 write_data, Uint32 page, Uint32 length );
int FLASH_erase( int block);
Uint32 FLASH_checksum( Uint32 start, Uint32 length );
Uint32 FLASH_getTotalPages( Uint16 num_flash_device );
int FLASH_ReadPage(unsigned char *dst, int page, int count);
int FLASH_WritePage(unsigned char *dst, int page, int count);
/* Internal functions */
Int32  _FLASH_getMfg                ( );
Int32  _FLASH_getPageLength         ( );
Uint32 _FLASH_nextPage              ( Uint32 addr );

Int16 _FLASH_waitWhileErasing       ( Uint32 addr, Int32 timeout );
Int16 _FLASH_waitWhileProgramming( Uint32 addr, Uint8 data, Int32 timeout );

   
	
#endif

