#ifndef _HARDWARE_H_
#define _HARDWARE_H_


#include "common.h"

#include <csl_gpio.h>


/* Flash memory */

#define FM_K9F2808

/* Register for Flash control */
#define FLASH_CONTROL		*(volatile short int *)0xC0000000
#define FLASH_DATA	  		*(volatile short int *)0xA0000000
#define FLASH_STATUS  		*(volatile short int *)0xC0000008

#define FLASH_ENVIRONMENT	0
#define SDRAM_REFRESH_RATE         (0x0000079Eu)
//#define FLASH_PROGRAM		20

// ӽ÷ HCB Ʈ ߻ 
#define CAPTURE_INT_TRIG	*(volatile unsigned short *)0xC000000A

// Lamp
#define LAMP1		  		*(volatile short int *)0xC0000002  
#define LAMP2		  		*(volatile short int *)0xC0000004

#define FPGA_PROGRAM_RIVISION_VER	  		*(volatile short int *)0xD000004C  
#define FPGA_BOARD_CHECKSUM_VER			*(volatile short int *)0xD000004E  
// SPI board Selection
#define SPI_BOARD_SELECTION *(volatile short int *)0xC000000C // 0xAFFFBF6C // add

#define INVERTER_TYPE_IG5A		0
#define INVERTER_TYPE_G100		1

void LampInit(void);

void Lamp1On(void);
void Lamp1Off(void);
void Lamp1Toggle(void);

void Lamp2On(void);
void Lamp2Off(void);
void Lamp2Toggle(void);

void HARDWARE_LampShift();


// Watchdog

#define WHDOG 		  		*(volatile short int *)0xC0000006  	// bit 0 => whdog(0:disable or clear, 1:enable) 


// DIP Switch

#define DIPSW  		  						*(volatile short int *)0xC0000008 	// bit 7,6,5,4 dip switch, bit 3: cpu id, bit 2: M_prg, bit 1: flash busy
#define THREED_CAMERA_SENSOR				*(volatile short int *)0xD0000064 //bit 0 = disk1, bit1 = disk2
#define LASER_TRIGER_ENCODER_SET			*(volatile short int *)0xD0000066				
#define LASERTRIGER_ENCODER_VALUE_L		*(volatile short int *)0xD0000068	
#define LASERTRIGER_ENCODER_VALUE_H		*(volatile short int *)0xD000006A	
#define SENSOR_ENCODER_VALUE_L			*(volatile short int *)0xD000006C	
#define SENSOR_ENCODER_VALUE_H			*(volatile short int *)0xD000006E	
#define MPRG				0x04
#define RS232_CHECK			0x08		

typedef struct
{
	unsigned char WriteFlag;
	unsigned char Speed;
	unsigned char WriteRetryCount;
	int InverterType;
}TInverterParmInfo;
extern TInverterParmInfo InverterParmInfo[2]; // inverter 1 & 2 

extern CSL_GpioHandle hGpio;
extern int valGpio;
extern int GPIO_USB;
extern int GPIO_DISK1_THREED_SENSOR;
extern int GPIO_DISK2_THREED_SENSOR;
extern int GPIO_MCBSP_2_RS485;
extern int GPIO_SPB_INT;
void HARDWARE_InitGPIO();
void SetGPIOVal(CSL_GpioPinNum pinNum);
void ResetGPIOVal(CSL_GpioPinNum pinNum);

#endif
