#include <csl_intc.h>
#include <csl_intcAux.h>
#include "machineControl.h"
#include "common.h"
#include "timer.h"
#include "port.h"
#include "command.h"
#include "environment.h"
#include "system_setup.h"
#include "syslib.h"
#include "servo_motor.h"
#include "tablet_control.h"
#include "hcb_system_process.h"
#include "step_motor.h"
#include "manual_encoder.h"
#include "rs485master.h"
#include "hardware.h"

#define	SD1_RING_BLOWER_INDEX						0
#define	SD2_RING_BLOWER_INDEX						1
#define	SD_DUST_RING_BLOWER_INDEX					2

#define	SERVO_MOTOR_EMERGENCY_STOP_TIME				1000
//#define	INSPECTION_MACHINE_STOP_DELAY				60000

unsigned int MSTimer100msCounter;


#define	VF_SPEED_LIST_COUNT							16
#define	VF_SPEED_LIST_MASK							15
short VFSpeedList[VF_SPEED_LIST_COUNT];
int	CurrentVFUpdateIndex;

#define	VF_RATIO_LIST_COUNT							16
#define	VF_RATIO_LIST_MASK							15

short VFLowSensorRatioList[VF_RATIO_LIST_COUNT];
short VFHighSensorRatioList[VF_RATIO_LIST_COUNT];
int	CurrentVFRatio;


int	CurrentVFUpdateIndex;

//static int Sensor2_Count =0;
static int BeforeStudySpeed=40;


#pragma	DATA_ALIGN(VibratorInfo, 8)
TVibratorInfo VibratorInfo;

//#pragma DATA_ALIGN(VibratorInfo, 8)
//TVibratorInfo	VibratorInfo;



#define	POWER_OFF_SW_VALID_TIME					100
#define	PC_ON_CHECKING_LIMIT					20000//10000
#define	PC_OFF_CHECKING_LIMIT					60000
#define	PC_OFF_CHECKING_TIMEOUT					600000
#define	MACHINE_STOP_WAITING_LIMIT				60000
TPowerControlData PowerControlData;

#pragma	DATA_ALIGN(MachineWarningState,	8)
#pragma	DATA_ALIGN(MachineAlarmState, 8)
TMachineWarningState MachineWarningState;
TMachineAlarmState MachineAlarmState;
TInspectionAlarmState InspectionAlarmState;

TBowlFeederSensorInfo BowlFeederSensorInfo;

// vibrator	control
#define	VIBRATOR_MODE_ALWAYS_OFF				0
#define	VIBRATOR_MODE_ALWAYS_ON					1
#define	VIBRATOR_MODE_AUTO						2

#define	VIBRATOR_STATE_OFF						0
#define	VIBRATOR_STATE_ON						1
#define	VIBRATOR_STATE_DO_ON					2
#define	VIBRATOR_STATE_EMERGENCY_STOP			0xFF

#define	Monitering				  				1
#define	VF_RATIO_LIST_COUNT						16
#define	VF_RATIO_LIST_MASK						15
#define	VF_INDEX_MASK  							7

TVibratorControlData VibratorControlData;

struct
{
	int	MaxSpeedTrainingMode;
	int	ManualMaxSpeed;
	int	ManualModeSensorIndex;
	int	ManualModeSensorActiveRatio;
	int	ManualLimitSpeed;
	int	ManualModeLimitSensorIndex;
	int	ManualModeLimitSensorActiveRatio;
	int	Sensor1Ratio;
	int	Sensor2Ratio;
	int	StartSpeed;
	int	DisplayMode;
	int	StartSpeedMode;
	float Width;
} VFControlInfo;

int	CurrentVFRatio;

typedef	struct
{
	unsigned char OPIndex;
	unsigned char IsPhysicalPort;
	unsigned char State;
	int	OnInterval;
	int	OffInterval;
	int	TimeRemain;
} TOPTestUnit;

struct
{

	int	Enabled;
	TOPTestUnit	TestOPList[MAX_OP_TEST_COUNT];
	int	OPTestUnitCount;
} OPTestData;

///////////////////////	LED	control
#define	MAX_LED_COUNT 							12

#define	LED_STATE_NONE							0
#define	LED_STATE_ALWAYS_ON						1
#define	LED_STATE_FLASH							2
#define	LED_STATE_BLINK							3
#define	LED_STATE_OFF							4

struct
{
	short State;			// control state
	short OnOffState;		// on /	off
	char EyeProtectionEnabled;
	int	EypeProtectionOffCount;
	int	OPIndex;
	int	OnInterval;
	int	OffInterval;
	int	TimeRemain;
} LEDControlData[MAX_LED_COUNT];


TEjectorInfo EjectorSetupData;
TLasercomplexerInfo LasercomplexerInfo;
TLEDInfo LEDControlSetupData;
TAlarmSetupInfo	AlarmSetupData;
TBuzzerInfo	BuzzerSetupData;
int	MachineControlMode;
int	EmissionSensingTime;

#define RS485_ALARM_CEHCEK_DELAY    60000   // 60sec
#define RS485_ALARM_CEHCEK_DELAY_DOMESTIC 6000
#define RS485_ALARM_TEMP_CEHCEK_DELAY    60000   // 60sec
int RS485PressureErrorTime[3]; 
int RS485TempErrorTime[3];
int test_count_eject[5];
int last_encoder_time = 0;
#define	MAX_EJECTOR_QUEUE_COUNT		128

struct
{
	int	Enabled;
	int	Mode;	
	unsigned int Mask;
	int	MaskCount;
	int	SensorState;
	int	CurrentMaskIndex;
	int	CurrentSenorQueueIndex;
	int	CurrentSensorOnTime;
	int	testCount;
	unsigned int SensorOnTime;
	int SensorOnEncoder;
	int EncoderLength;

} EjectorTestData;   //Q  ߰.


#define	MISEJECT_QUEUE_SIZE		64
#define	MISEJECT_QUEUE_MASK		63

struct
{
	int	Enabled;
	unsigned char SensorState;
	int	ActiveDelay;
	int	DurationTime;
	int	DurationRemainTime;
	int Timer1ms;
} MisejectTestData;




///////////////////////	bowl feeder	procedure
#define	BOWL_FEEDER_STATE_NONE						0
#define	BOWL_FEEDER_STATE_RUN						1
#define	BOWL_FEEDER_STATE_STOP						2
#define	BOWL_FEEDER_STATE_OUTER_ACC					6
#define	BOWL_FEEDER_STATE_INNER_ACC					7
#define	BOWL_FEEDER_STATE_INNER_DEC					8
#define	BOWL_FEEDER_STATE_OUTER_DEC					9
#define	BOWL_FEEDER_STATE_EMERGENCY_STOP			0xFF

#define	BOWL_FEEDER_COMMAND_NONE					0
#define	BOWL_FEEDER_COMMAND_RUN						1
#define	BOWL_FEEDER_COMMAND_STOP					2

struct
{
	int	State;
	int	Command;

	int InnerDiskSpeed;
	int OuterDisk1Speed;
	int OuterDisk2Speed;

	unsigned int OuterDiskAccStartTime;
	unsigned int InnerDiskAccStartTime;
	unsigned int InnerDiskDecStartTime;
	unsigned int OuterDiskDecStartTime;
	char AirKnifeSpeed;
} BowlFeederProcedureData;



#define	SD_STABLE_CHECK_DELAY						7000
TSuctionDiskProcedureData SuctionDiskProcedureData;

#define	MAIN_CONTROL_FUNC_NONE						0
#define	MAIN_CONTROL_FUNC_RUN						1
#define	MAIN_CONTROL_FUNC_STOP						2
#define	MAIN_CONTROL_FUNC_READY						3
#define	MAIN_CONTROL_FUNC_CLEANING					4
#define	MAIN_CONTROL_FUNC_EMERGENCY_RESET			0xFE
#define	MAIN_CONTROL_FUNC_EMERGENCY_STOP			0xFF


#define	MAIN_CONTROL_MODE_NONE						0
#define	MAIN_CONTROL_MODE_TEST						1
#define	MAIN_CONTROL_MODE_CAPTURE					2
#define	MAIN_CONTROL_MODE_STUDY						3
#define	MAIN_CONTROL_MODE_INSPECTION				4


TMainControlData MainControlData;
unsigned int TabletTransferWaitingTime;
TTPBMisejectProcess TPB_MisejectProcess;

#define	DUST_BLOW_SOL_COUNT							5

struct
{
	int	Enabled;
	int	Interval[DUST_BLOW_SOL_COUNT];
	int	RunTime[DUST_BLOW_SOL_COUNT];
	int	IntervalRemain[DUST_BLOW_SOL_COUNT];
	int	RunRemain[DUST_BLOW_SOL_COUNT];
	unsigned char Port[DUST_BLOW_SOL_COUNT];
} DustBlowerSolControlData;		// solenoid


#define	EMERGENCY_STATE_NONE		0
#define	EMERGENCY_STATE_OCCURED		1

int	EmergencyState;

int	MACHINE_STOP_SENSOR_EMPTY_LIMIT;    //й.
int	INSPECTION_MACHINE_STOP_DELAY;      //й.
//int	MACHINE_STOP_SENSOR_EMPTY_LIMIT;

//#define	MACHINE_STOP_SENSOR_EMPTY_LIMIT		30000

struct
{
	int	BFSensor1OffCount;
	int	BFSensor2OffCount;
	int	BFSensor3OffCount;
} MachineStopSensorState;


#define	MAX_LAMP_COUNT						3

#define	LAMP_STATE_OFF						0
#define	LAMP_STATE_ON						1
#define	LAMP_STATE_BLINK					2

#define	LAMP_RED_INDEX						0
#define	LAMP_YELLOW_INDEX					1
#define	LAMP_GREEN_INDEX					2

#define	LAMP_BLINKING_INTERVAL				500
struct
{
	char LampState[MAX_LAMP_COUNT];
	char LampBlinkOn[MAX_LAMP_COUNT];
	unsigned char LampOP[MAX_LAMP_COUNT];
	int	LampToggleCounter[MAX_LAMP_COUNT];
	int	LampBlinkInterval[MAX_LAMP_COUNT];
} LampControlData;

#define LASER_TRIG_STATE_OFF			0
#define LASER_TRIG_STATE_ON			1


struct
{
	unsigned int LaserTrigerState[2];
	unsigned int LaserTrigerInterVal[2];
} LaserTrigerControlData;



#define	MAX_BLOWER_REMAIN				20000	//200000  => 50000	// 10 sec

#define	EJECTOR_WARM_UP_TIME			1000	// 1 sec

#define	SUCTION_READY_TIME				1000	// 5 sec

struct
{
	int				DefectEjectorQueueStart;
	int				DefectEjectorQueueEnd;
	int				UnInsEjectorQueueStart;
	int				UnInsEjectorQueueEnd;

	int				UnInsEjectorAOQueueStart;
	int				UnInsEjectorAOQueueEnd;

	unsigned int 	DefectEjectorTimeQueue[EJECTOR_QUEUE_SIZE];
	int				DefectEjectorDelayQueue[EJECTOR_QUEUE_SIZE];
	unsigned int 	UnInsEjectorTimeQueue[EJECTOR_QUEUE_SIZE];
	int				UnInsEjectorDelayQueue[EJECTOR_QUEUE_SIZE];
	unsigned int 	UnInsEjectorAOTimeQueue[EJECTOR_QUEUE_SIZE];

	int				MisejectQueueStart;
	int				MisejectQueueEnd;
	unsigned int 	MisejectTimeQueue[EJECTOR_QUEUE_SIZE];
	int				MisejectDelayQueue[EJECTOR_QUEUE_SIZE];

	int				MisejectActiveRemain;

	int				DefectBlowerRemain;
	int				UnInsBlowerRemain;

    //Q
    int				GoodEjectorQueueStart;
	int				GoodEjectorQueueEnd;
    unsigned int 	GoodEjectorTimeQueue[EJECTOR_QUEUE_SIZE];
	int				GoodEjectorDelayQueue[EJECTOR_QUEUE_SIZE];
    int				GoodBlowerRemain;
} EjectorControlData;


#pragma DATA_SECTION(DefectEjectorQueue, ".sdram");
#pragma DATA_ALIGN(DefectEjectorQueue, 8);

#pragma DATA_SECTION(UnInsEjectorQueue, ".sdram");
#pragma DATA_ALIGN(UnInsEjectorQueue, 8);


#pragma DATA_SECTION(GoodEjectorQueue, ".sdram");
#pragma DATA_ALIGN(GoodEjectorQueue, 8);

#pragma DATA_SECTION(MissEjectorQueue, ".sdram");
#pragma DATA_ALIGN(MissEjectorQueue, 8);

EjectorQueueData DefectEjectorQueue;
EjectorQueueData UnInsEjectorQueue;
EjectorQueueData GoodEjectorQueue;
EjectorQueueData MissEjectorQueue;

struct
{
	int DefectEjectorOnEncoder;
	int DefectEjectorOnLenght;
	int UnInsEjectorOnEncoder;
	int UnInsEjectorOnLenght;	
	int GoodEjectorOnEncoder;
	int GoodEjectorOnLenght;
	int MissEjectorOnEncoder;
	int MissEjectorOnLenght;	
}EjectorEncoderControlData;

struct
{
	int	DoorInterlockEnabled;
	int	DoorOpen;
	int DoorInterlockSolEnabled;
} InterlockData;

int	AbnormalTerminationDetected;
TTerminationInfo TerminationInfo;
int	TerminationInfoSaveWaitingTime;



TMonitorSwitchControlData MonitorSwitchControlData;
TOperationInfo OperationInfo;


#define	NC_HOME_SEARCH_STATE_NONE						0
#define	NC_HOME_SEARCH_STATE_FIRST_STAGE				1
#define	NC_HOME_SEARCH_STATE_SECOND_STAGE				2

#define	NC_CONTROL_COMMAND_NONE							0
#define	NC_CONTROL_COMMAND_READY						1
#define	NC_CONTROL_COMMAND_CLEANING						2

#define	NC_CONTROL_STATE_IDLE							0
#define	NC_CONTROL_STATE_ATTACHING						1
#define	NC_CONTROL_STATE_DETACHING						2
#define	NC_CONTROL_STATE_ERROR							3

#define	NC_CONTROL_POS_STATE_NONE						0
#define	NC_CONTROL_POS_STATE_READY						1
#define	NC_CONTROL_POS_STATE_CLEANING					2
struct
{
	unsigned char Command;
	unsigned char State;
	unsigned char HomeSearchState;
	unsigned char PosState;
	unsigned char ControlState;
	char HomeDetectionFailed;
	char HomeDetected;
} NCControlInfo;


struct
{
	unsigned int PCSwitchDelay;
	unsigned int PCSwitchState;
} ToggleControlData;

struct
{
	unsigned char SilenceMode;
	unsigned char AlarmOn;
	unsigned char AlarmBuzzerOn;
	unsigned char NotifyBuzzerOn;
	unsigned char SuspendBuzzerOn;
	unsigned short BuzzerContinuousOn;
	unsigned short BuzzerOnTime;
	unsigned int BuzzerOnStartTime;
	unsigned int NotifyBuzzerDurationTime;
} BuzzerControlData;


struct
{
	unsigned char MachineStopped;
	unsigned char PowerOff;
	unsigned short TimerCounter;
	unsigned int MachineStopTime;
} UnmanedOperationControlData;

int DoorInterlock = 0; // 0 : Ͷ  , 1 : Ͷ  
int DoorInterlockPushTime = 0;

int CurrentMisejectActive = 0;
int MisejectActionCheckTimer = 0;

#pragma	DATA_ALIGN(UnmanedOperationData, 8)
TUnmanedOperationData UnmanedOperationData;
int	WarningAlarmCnt;
int	HopperEmptyEnable;
int WaitStop_State;
int USBCommAlarmCheck; // Debug 

int RingBlowerStatus[2] ={0,};
int PrevQueueStart = 0;

//---------------------------------------------------------------------------
// L0 Operations
//---------------------------------------------------------------------------
void MC_OPTest_Init(void);
void MC_OPTest_Start(int opTestCount, unsigned char	*opList, unsigned char *isPhysicalPort,	int	*delayIntervalList,	int	*onIntervalList, int *offIntervalList);
void MC_OPTest_Stop(void);

//---------------------------------------------------------------------------
// L1 Operations
//---------------------------------------------------------------------------
void MC_RingBlower_Off(int rbIndex);
void MC_RingBlower_On(int rbIndex, int speed);
void MC_DustBlower_On(void);
void MC_DustBlower_Off(void);
void MC_Power_SwitchOff(void);
void MC_RoomLightControl_On(void);
void MC_RoomLightControl_Off(void);
void MC_VFControl(int speed);
//---------------------------------------------------------------------------
// L2 Operations
//---------------------------------------------------------------------------
void MC_Vibrator_Init(void);
void MC_Vibrator_Off(void);
void MC_Vibrator_On(int	speed);
void MC_Vibrator_Auto(void);

void MC_Vibrator_ManualSpeedChange(int speed, int limitspeed);
void MC_Vibrator_ControlChange(char	trainingMode,
								int	speed, int sensorIndex,	int	sensorRatio,
								int	LimitSpeed,	int	LimitsensorIndex, int LimitsensorRatio,
								int	sensor1Ratio, int sensor2Ratio,	int	startSpeed);
void MC_Vibrator_EmergencyStop(void);
void MC_Vibrator_EmergencyReset(void);
void MC_Vibrator_Process(void);
void MC_Vibrator_ManualProcess(void);

void MC_SuctionDisk_Init(void);
void MC_SuctionDisk_Run(int	disc1Speed,	int	disc2Speed,	unsigned char inverter1Speed, unsigned char	inverter2Speed);
void MC_SuctionDisk_Stop(void);
void MC_SuctionDisk_MotorStop(void);
void MC_SuctionDisk_EmergencyStop(void);
void MC_SuctionDisk_EmergencyReset(void);
void MC_SuctionDisk_Process(void);

void MC_BowlFeeder_Init(void);
void MC_BowlFeeder_Run(int innerDiskSpeed, int outerDisk1Speed, int outerDisk2Speed, char AirKnifeSpeed);
void MC_BowlFeeder_SpeedChange(int innerDiskSpeed, int outerDisk1Speed, int outerDisk2Speed);
void MC_BowlFeeder_Stop(void);
void MC_BowlFeeder_AKControl(char speed);
void MC_BowlFeeder_Reset(void);
void MC_BowlFeeder_EmergencyStop(void);
void MC_BowlFeeder_EmergencyReset(void);
void MC_BowlFeeder_Process(void);

void MC_NC_Control_Init(void);
void MC_NC_HomePositionSetup(void);
void MC_NC_CleaningMoveBegin(void);
void MC_NC_ReadyMoveBegin(void);
void MC_NC_HomeSearch_Process(void);
void MC_NC_Control_Processs(void);


void MC_LED_Init(void);
void MC_LED_On(int ledIndex, int type, int param1, int param2);
void MC_LED_Off(int	ledIndex);
void MC_LED_AllOn(int type,	int	param1,	int	param2);
void MC_LED_AllOff(void);
void MC_LED_Process(void);
void MC_LASER_Trigger_On(int diskNum, int interval);
void MC_LASER_Trigger_Process(void);
void MC_EnableEyeProtection(void);
void MC_DisableEyeProtection(void);

void MC_LampControl_Init(void);
void MC_LampControl_On(int lampIndex);
void MC_LampControl_Off(int	lampIndex);
void MC_LampControl_Blink(int lampIndex, int blinkInterval);
void MC_LampControl_Process(void);

void MC_BuzzerControl_Init(void);
void MC_BuzzerControl_InspectionStopAlarmOn(void);
void MC_BuzzerControl_AlarmOn(void);
void MC_BuzzerControl_AlarmOff(void);
void MC_BuzzerControl_Stop(void);
void MC_BuzzerControl_NotifyBuzzerOn(int durationTime);
void MC_BuzzerControl_Process(void);

void MC_Ejector_Init(void);
void MC_Ejector_Stop(void);
void AddUnInsEjectorAOQueue(unsigned int ejectorTime);
void AddMisejectActiveQueue(unsigned int ejectorTime, int ejectorLength);
void MC_Ejector_Process_Encoder(void);
#ifdef SELMA
void MC_Pressure_Regulator_Set(int strength);
#endif
void MC_ToggleControl_Init(void);
void MC_ToggleControl_Process(void);
void MC_PC_Switch_Activate(void);
void MC_PC_Switch_Forced_Off(void);

void MC_SwitchControl_Init(void);
void MC_SwitchControl_Process(void);

void MC_Emergency_MachineStop(void);

void MC_Alarm_Reset(void);

//---------------------------------------------------------------------------
// L3 Operations
//---------------------------------------------------------------------------
void MC_CleaningStart(void);
void MC_ReadyStart(void);

void MC_MainControl_Init(void);
void MC_MainControl_Run(void);
void MC_MainControl_Stop(void);
void MC_MainControl_WaitStop(int Type);
void MC_MainControl_Ready(int *ncPos);
void MC_MainControl_Cleaning(void);
void MC_MainControl_EmergencyStop(void);
void MC_MainControl_EmergencyReset(void);
void MC_Main_Control_Process(void);

void MC_DustBlowerSol_Init(void);
void MC_DustBlowerSol_On(void);
void MC_DustBlowerSol_Off(void);
void MC_DustBlowerSol_Process(void);

void MC_PowerControl_Init(void);
void MC_PowerControl_Off(void);
void MC_PowerControl_On(void);
void MC_PowerControl_PC_Off(void);
void MC_PowerControl_Process_100ms(void);

void MC_EjectorTest_Init(void);
void MC_Ejector_Test_Run(int ejectorIndex, unsigned	int	ejectorMask, int ejectorMaskCount);
void MC_Ejector_Test_Stop(int ejectorIndex);
void MC_Ejector_Test_Process(void);

void MC_Miseject_Test_Init(void);
void MC_Miseject_Test_Run(int activeDelay, int durationTime);
void MC_Miseject_Test_Stop(void);
void MC_Miseject_Process_1ms(void);
void MisEjectActive(void);
void MisEjectStop(void);

void MC_Blackout_Init(void);
void MC_Blackout_Process(void);

void MC_DoorLockControl_Process_100ms(void);
void MC_UnmanedOperation_Process_100ms(void);

//---------------------------------------------------------------------------
// command decoder
//---------------------------------------------------------------------------
void MC_BowlFeederControl(TMachineControlData_BowlFeeder *bfData);
void MC_RingBlowerControl(unsigned char	rbIndex, char action, unsigned char	speed1,	unsigned char speed2);
void MC_ServoMotorControl(TMachineControlData_ServoMotor *servoMotorData);
void MC_StepMotorControl(TMachineControlData_StepMotor *stepMotorData);
void MC_VibratorControl(TMachineControlData_VibrationFeeder	*vibratorData);
void SungChulControl(TMachineControlData_SungChulData *SungChulData);
void MC_GeneralControl(int action, int *value);
void MC_Procedure(TMachineControlData_Procedure	*procedureData);

//---------------------------------------------------------------------------
// other fuctions
//---------------------------------------------------------------------------
void CheckMachineStatus(void);
void SaveTerminationInfo(void);
void Bowl_Feeder_Sensor_Info_Init(void);
void Bowl_Feeder_Sensor_Process(void);

//---------------------------------------------------------------------------
// TPB fuctions
//---------------------------------------------------------------------------
void TPB_Miseject_Process(void);

void TPB_MisejectProcessInit(void)
{
	TPB_MisejectProcess.validCnt = 0;
	TPB_MisejectProcess.openFlag = 0;
	TPB_MisejectProcess.saveOpenTimeFlag = 0;
}

void MachineControl_Init(void)
{
	int	servoMotorIndex;
	EmissionSensingTime	= 0;
	memset(RS485PressureErrorTime,0,sizeof(int)*3);
	memset(RS485TempErrorTime,0,sizeof(int)*3);
	UnmanedOperationControlData.PowerOff = 0;
	// alarm state init
	memset(&MachineWarningState, 0,	sizeof(TMachineWarningState));
	memset(&MachineAlarmState, 0, sizeof(TMachineAlarmState));
	memset(&InspectionAlarmState, 0, sizeof(TInspectionAlarmState));

	MC_OPTest_Init();

	MC_Vibrator_Init();
	MC_SuctionDisk_Init();
	MC_BowlFeeder_Init();
	MC_NC_Control_Init();
	MC_LED_Init();
	MC_LampControl_Init();
	MC_BuzzerControl_Init();
	MC_Ejector_Init();
	MC_ToggleControl_Init();
	MC_SwitchControl_Init();

	MC_MainControl_Init();
	MC_DustBlowerSol_Init();
	MC_PowerControl_Init();

	MC_EjectorTest_Init();
	MC_Miseject_Test_Init();

	MC_Blackout_Init();
	Bowl_Feeder_Sensor_Info_Init();

	EmergencyState = 0;


	MachineStatus.OperationState = MACHINE_STATE_STOP;
	MachineStatus.Suspended	= 0;


	UnmanedOperationData.Activated = 0;		// not activated


	AbnormalTerminationDetected	= 0;

	for	(servoMotorIndex = 0; servoMotorIndex <	MAX_SERVO_MOTOR_COUNT; servoMotorIndex++)
	{
		OperationInfo.ServoMotorSpeed[servoMotorIndex] = SERVO_MOTOR_MAX_SPEED_VALUE;
	}


	MachineControlMode = MACHINE_MODE_FREE;

	MSTimer100msCounter	= 0;

	WarningAlarmCnt	= 0;
	
	LaserTrigerControlData.LaserTrigerState[0] = LASER_TRIG_STATE_OFF;
	LaserTrigerControlData.LaserTrigerInterVal[0] = 0;
	LaserTrigerControlData.LaserTrigerState[1] = LASER_TRIG_STATE_OFF;
	LaserTrigerControlData.LaserTrigerInterVal[1] = 0;	

	MachineStatus.MachineOff = 0;		
}


void MC_InitialMove(void)
{	
	if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		if(MachineSetupData.Qualis_Machine1_CutomOption==0)
		{
			PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_SELECT, 0); // QJP WANT TO MACHINE START ONLY 0
			PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_RESET, 1);	
			SafetyResetFlag = 1;
		}
		PORT_ModifyOutPort(OP_UNLOCK_SWITCH_LAMP_ON, 1);
		MisEjectActive();
	}
	else
	{
		MisEjectStop();
	}
	
	MC_BuzzerControl_NotifyBuzzerOn(1000);

	

#ifdef SELMA
    // 2й
    PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
    PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
#endif
    PORT_ModifyOutPort(OP_IONIZER_ON, 1);
    PORT_ModifyOutPort(OP_GOOD_BLOWER, 0);
    PORT_ModifyOutPort(OP_DEFECT_BLOWER, 0);
	PORT_ModifyOutPort(OP_UNINSPECTED_BLOWER, 0);
    PORT_ModifyOutPort(OP_GOOD_BLOWER, 0);

}
//---------------------------------------------------------------------------
// L0 Operations
//---------------------------------------------------------------------------
void MC_OPTest_Init(void)
{
	// op test init
	OPTestData.OPTestUnitCount = 0;
	OPTestData.Enabled = 0;
}
//---------------------------------------------------------------------------
void MC_OPTest_Start(int opTestCount, unsigned char	*opList, unsigned char *isPhysicalPort,	int	*delayIntervalList,	int	*onIntervalList, int *offIntervalList)
{
	int	testIndex;
	if (opTestCount	< 0	|| opTestCount >= MAX_OP_TEST_COUNT)
	{
		OPTestData.Enabled = 0;
		return;
	}
    //Q ߰  OP28 ̴.
	for	(testIndex = 0;	testIndex <	opTestCount; testIndex++)
	{
		OPTestData.TestOPList[testIndex].OPIndex        = opList[testIndex];
		OPTestData.TestOPList[testIndex].IsPhysicalPort	= isPhysicalPort[testIndex];
		OPTestData.TestOPList[testIndex].OnInterval	    = onIntervalList[testIndex];
		OPTestData.TestOPList[testIndex].OffInterval    = offIntervalList[testIndex];
		OPTestData.TestOPList[testIndex].State          = 0;
		OPTestData.TestOPList[testIndex].TimeRemain	    = delayIntervalList[testIndex];
	}
	OPTestData.OPTestUnitCount  = opTestCount;
	OPTestData.Enabled          = 1;
}
//---------------------------------------------------------------------------
void MC_OPTest_Stop(void)
{
	int	testIndex;
	if (OPTestData.Enabled)
	{
		for	(testIndex = 0;	testIndex <	OPTestData.OPTestUnitCount;	testIndex++)
		{
			if (OPTestData.TestOPList[testIndex].IsPhysicalPort)
			{
				PORT_ModifyPhysicalOutPort(OPTestData.TestOPList[testIndex].OPIndex, 0);
			}
			else
			{
				PORT_ModifyOutPort(OPTestData.TestOPList[testIndex].OPIndex, 0);
			}
		}
	}
	OPTestData.Enabled = 0;
}
//---------------------------------------------------------------------------
void MC_OP_Test_Process(void)
{
	int	testIndex;
	for	(testIndex = 0;	testIndex <	OPTestData.OPTestUnitCount;	testIndex++)
	{
		if (OPTestData.TestOPList[testIndex].TimeRemain	== 0)
		{
			if (OPTestData.TestOPList[testIndex].State == 0)
			{
				if (OPTestData.TestOPList[testIndex].OnInterval	> 0)
				{
					if (OPTestData.TestOPList[testIndex].IsPhysicalPort)
					{
						PORT_ModifyPhysicalOutPort(OPTestData.TestOPList[testIndex].OPIndex, 1);
					}
					else
					{
						PORT_ModifyOutPort(OPTestData.TestOPList[testIndex].OPIndex, 1);
					}
					OPTestData.TestOPList[testIndex].State = 1;
					OPTestData.TestOPList[testIndex].TimeRemain	= OPTestData.TestOPList[testIndex].OnInterval -	1;
				}
			}
			else
			{
				if (OPTestData.TestOPList[testIndex].OffInterval > 0)
				{
					if (OPTestData.TestOPList[testIndex].IsPhysicalPort)
					{
						PORT_ModifyPhysicalOutPort(OPTestData.TestOPList[testIndex].OPIndex, 0);
					}
					else
					{
						PORT_ModifyOutPort(OPTestData.TestOPList[testIndex].OPIndex, 0);
					}
					OPTestData.TestOPList[testIndex].State = 0;
					OPTestData.TestOPList[testIndex].TimeRemain	= OPTestData.TestOPList[testIndex].OffInterval - 1;
				}
			}
		}
		else
		{
			OPTestData.TestOPList[testIndex].TimeRemain--;
		}
	}
}
//---------------------------------------------------------------------------
// L1 Operations
//---------------------------------------------------------------------------
void MC_RingBlower_Off(int rbIndex)
{
	
	if (rbIndex	== 0)
	{
		PORT_ModifyOutPort(OP_RB1_ON, 0);
	}
	else if	(rbIndex ==	1)
	{
		PORT_ModifyOutPort(OP_RB2_ON, 0);
	}
	else if	(rbIndex ==	2)
	{
		PORT_ModifyOutPort(OP_RB3_ON, 0);
	}

}
//---------------------------------------------------------------------------
void MC_RingBlower_On(int rbIndex, int speed)
{
	if (rbIndex	== 0)
	{
		if(MachineSetupData.CompanyID == DOMESTIC_MACHINE3)
		{
			SetInverterSpeed(rbIndex,speed);
		}
		else
			PORT_ModifyAOValue(INVERTER_1_SPEED_AO_INDEX, speed);

		PORT_ModifyOutPort(OP_RB1_ON, 1);
	}
	else if	(rbIndex ==	1)
	{
		if(MachineSetupData.CompanyID == DOMESTIC_MACHINE3)
		{
			SetInverterSpeed(rbIndex,speed);
		}
		else
			PORT_ModifyAOValue(INVERTER_2_SPEED_AO_INDEX, speed);

		PORT_ModifyOutPort(OP_RB2_ON, 1);
	}
	else if	(rbIndex ==	2)
	{
		//PORT_ModifyAOValue(INVERTER_3_SPEED_AO_INDEX, speed);
		PORT_ModifyOutPort(OP_RB3_ON, 1);
	}
}
//---------------------------------------------------------------------------
void MC_DustBlower_On(void)
{
	PORT_ModifyOutPort(OP_DUST_SUCTION_ON, 1);
}
//---------------------------------------------------------------------------
void MC_DustBlower_Off(void)
{
	PORT_ModifyOutPort(OP_DUST_SUCTION_ON, 0);
}
//---------------------------------------------------------------------------
void MC_Power_SwitchOff(void)
{
	PORT_ModifyOutPort(OP_POWER_OFF, 1);
}
//---------------------------------------------------------------------------
void MC_RoomLightControl_On(void)
{
	PORT_ModifyOutPort(OP_ROOM_LAMP_ON,	1);
	//PORT_ModifyOutPort(OP_MAGIC_SCREEN_ON, 1);
}
//---------------------------------------------------------------------------
void MC_RoomLightControl_Off(void)
{
	PORT_ModifyOutPort(OP_ROOM_LAMP_ON,	0);
	//PORT_ModifyOutPort(OP_MAGIC_SCREEN_ON, 0);
}
//---------------------------------------------------------------------------
// L2 Operations
//---------------------------------------------------------------------------
void MC_Vibrator_Init(void)
{
	int	qIndex;
	int	vfIndex;

	// vibrator	init
	VibratorControlData.Mode = VIBRATOR_MODE_ALWAYS_OFF;
	VibratorControlData.State =	VIBRATOR_STATE_OFF;
	VibratorControlData.MechanicalMinSpeed = 0;
	VibratorControlData.MechanicalMaxSpeed = 0;

	VFControlInfo.StartSpeed = 40;
	VFControlInfo.StartSpeedMode = 40;
	VFControlInfo.Sensor1Ratio = 50;
	VFControlInfo.Sensor2Ratio = 50;
	VFControlInfo.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
	VFControlInfo.ManualMaxSpeed = 0;
	VFControlInfo.ManualLimitSpeed = 0;

	PORT_ModifyAOValue(VF_SPEED_AO_INDEX, 100);	// VF  ʱ⿡	   ʴ	 ..

	VibratorInfo.CurrentListIndex =	0;
	VibratorInfo.SetRatio1 = 0;
	VibratorInfo.SetRatio2 = 0;
	VibratorInfo.Sensor1ON_NowRatio	= 0;
	VibratorInfo.Sensor2ON_NowRatio	= 0;
	VibratorInfo.NowSpeed =	0;

	for	(vfIndex = 0; vfIndex <	VFINFO_LIST_COUNT; vfIndex++)
	{
		VibratorInfo.VFSpeedList[vfIndex] =	0;
		VibratorInfo.VFMaxSpeedList[vfIndex] = 0;
		VibratorInfo.VFSensor1RatioList[vfIndex] = 0;
		VibratorInfo.VFSensor2RatioList[vfIndex] = 0;
		VibratorInfo.NowSpeedList[vfIndex] = 0;
		VibratorInfo.AverageSpeedList[vfIndex] = 0;
		VibratorInfo.AverageSensor1RatioList[vfIndex] =	0;
		VibratorInfo.AverageSensor2RatioList[vfIndex] =	0;
	}

	VibratorControlData.BeforeSensor1Ratio = VFControlInfo.Sensor1Ratio;
	VibratorControlData.BeforeSensor2Ratio = VFControlInfo.Sensor2Ratio;


	for	( qIndex = 0 ; qIndex <	4; qIndex++	)
	{
	//	QueueRatioList[Qindex] = VibratorControlData.Sensor1RatioList[Qindex+1];
		VibratorControlData.Sensor1RatioList[qIndex] = 0;
	}
}
//---------------------------------------------------------------------------
void MC_VFControl(int speed)
{
	if (speed >	0)
	{
		VibratorControlData.State =	VIBRATOR_STATE_ON;

		PORT_ModifyAOValue(VF_SPEED_AO_INDEX, (unsigned	short) speed);
		PORT_ModifyOutPort(OP_VF_ON, 1);	
		
		PORT_ModifyOutPort(OP_HOPER_AIR,1);
	}
	else
	{
		VibratorControlData.State =	VIBRATOR_STATE_OFF;
		
		PORT_ModifyAOValue(VF_SPEED_AO_INDEX, (unsigned	short) speed);
		PORT_ModifyOutPort(OP_VF_ON, 0);

		PORT_ModifyOutPort(OP_HOPER_AIR,0);
	}

	if(MachineSetupData.CompanyID == DOMESTIC_MACHINE3)
	{
		if(VibratorControlData.Mode == VIBRATOR_MODE_AUTO)
		{
			if(PORT_ReadInPort(IP_VB_SENSOR) && PORT_ReadOutPort(OP_VF2_ON))
			{
				PORT_ModifyAOValue(VF_HOPPER_SPPED_AO_INDEX, (unsigned	short) speed);
				PORT_ModifyOutPort(OP_VF2_ON, 0);	
			}
			else if(!PORT_ReadInPort(IP_VB_SENSOR) && !PORT_ReadOutPort(OP_VF2_ON))
			{
				PORT_ModifyAOValue(VF_HOPPER_SPPED_AO_INDEX, (unsigned	short) 255);
				PORT_ModifyOutPort(OP_VF2_ON, 1);
			}
		}
		else
		{
			if(VibratorControlData.Mode == VIBRATOR_MODE_ALWAYS_ON)
			{
				PORT_ModifyAOValue(VF_HOPPER_SPPED_AO_INDEX, (unsigned	short) 255);
				PORT_ModifyOutPort(OP_VF2_ON, 1);
			}
			else if(VibratorControlData.Mode == VIBRATOR_MODE_ALWAYS_OFF)
			{
				PORT_ModifyAOValue(VF_HOPPER_SPPED_AO_INDEX, (unsigned	short) speed);
				PORT_ModifyOutPort(OP_VF2_ON, 0);
			}	
		}
	}

	VibratorControlData.CurrentSpeed = speed;
}
//---------------------------------------------------------------------------
void MC_Vibrator_On(int	speed)
{
	unsigned short speedValue;

	if (VibratorControlData.State != VIBRATOR_STATE_EMERGENCY_STOP)
	{
		if (speed <	0)
		{
			speedValue = 0;
		}
		else
		{
			speedValue = speed;
		}
		VibratorControlData.Mode = VIBRATOR_MODE_ALWAYS_ON;
		MC_VFControl(speedValue);
		//PORT_ModifyOutPort(OP_MAGNET_ON, 1);
	}
}
//---------------------------------------------------------------------------
void MC_Vibrator_Off(void)
{
	if (VibratorControlData.State != VIBRATOR_STATE_EMERGENCY_STOP)
	{
		VibratorControlData.Mode = VIBRATOR_MODE_ALWAYS_OFF;
		MC_VFControl(0);
	}
}
//---------------------------------------------------------------------------
void MC_Vibrator_Auto(void)
{
	int	vfListIndex;

	if (VibratorControlData.State != VIBRATOR_STATE_EMERGENCY_STOP)
	{
		CurrentVFUpdateIndex = 1;
		CurrentVFRatio = 0;

		for	(vfListIndex = 0; vfListIndex <	VFINFO_LIST_COUNT; vfListIndex++)
		{
			VibratorInfo.NowSpeedList[vfListIndex] = VibratorControlData.MechanicalMinSpeed;
			VibratorInfo.AverageSpeedList[vfListIndex] = VibratorControlData.MechanicalMinSpeed;
			VibratorInfo.AverageSensor1RatioList[vfListIndex] =	0;
			VibratorInfo.AverageSensor2RatioList[vfListIndex] =	0;
		}
		//VibratorInfo.CurrentManualListIndex =	0;
		VibratorInfo.CurrentListIndex =	0;

		VibratorControlData.Mode = VIBRATOR_MODE_AUTO;

		//Sensor2_Count =0;

		VibratorControlData.On_AverageSensor1Ratio = 0;
		VibratorControlData.On_AverageSensor2Ratio = 0;

		if((VFControlInfo.StartSpeedMode>0)	&& (VFControlInfo.StartSpeedMode<256))
		{
			VibratorControlData.StudySpeed =VFControlInfo.StartSpeedMode;
			VibratorInfo.test1 = 1;
		}
		else
		{
			//VibratorControlData.StudySpeed	= VibratorControlData.MechanicalMinSpeed;
			VibratorControlData.StudySpeed	=BeforeStudySpeed;
			VibratorInfo.test1 = 2;
		}

		MC_VFControl(0);
		//PORT_ModifyOutPort(OP_MAGNET_ON, 1);
	}
}
//---------------------------------------------------------------------------

void MC_Vibrator_ManualSpeedChange(int speed,int limitspeed)
{
	if (VibratorControlData.Mode !=	VIBRATOR_MODE_AUTO)
	{
		MC_Vibrator_Auto();
	}
	//VibratorControlData.StableSpeed =	speed;
	VFControlInfo.ManualMaxSpeed = speed;
	VFControlInfo.ManualLimitSpeed = limitspeed;
}

void MC_Vibrator_ControlChange(char	trainingMode,
											   int speed, int sensorIndex, int sensorRatio,
											   int LimitSpeed, int LimitsensorIndex, int LimitsensorRatio,
											   int sensor1Ratio, int sensor2Ratio,
											   int startSpeed)
{
	//if (VibratorControlData.State	== VIBRATOR_MODE_AUTO)
	//{
		VFControlInfo.MaxSpeedTrainingMode = trainingMode;
		if (VFControlInfo.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
		{
			VFControlInfo.Sensor1Ratio = sensor1Ratio;
			VFControlInfo.Sensor2Ratio = sensor2Ratio;
			VFControlInfo.StartSpeed = startSpeed;
			VibratorControlData.StudySpeed = startSpeed;  //sjm	Add
		}
		else//manual mode
		{
			VFControlInfo.ManualMaxSpeed = speed;
			VFControlInfo.ManualModeSensorIndex	= sensorIndex;
			VFControlInfo.ManualModeSensorActiveRatio =	sensorRatio;
			VFControlInfo.ManualLimitSpeed = LimitSpeed;
			VFControlInfo.ManualModeLimitSensorIndex = LimitsensorIndex;
			VFControlInfo.ManualModeLimitSensorActiveRatio = LimitsensorRatio;
		}
	//}
}



//---------------------------------------------------------------------------
void Park_Sensor1RatioChange(unsigned char Ratio, char Mode)
{
	VFControlInfo.Sensor1Ratio = Ratio;
	VFControlInfo.DisplayMode =	Mode;
}

void Park_Sensor2RatioChange(unsigned char Ratio)
{
	VFControlInfo.Sensor2Ratio = Ratio;
}

void Park_StartSpeedModeChange(	int	Mode)
{
	VFControlInfo.StartSpeedMode = Mode;
}

//---------------------------------------------------------------------------

void MC_Vibrator_EmergencyStop(void)
{
	VibratorControlData.State =	VIBRATOR_STATE_EMERGENCY_STOP;
	VibratorControlData.Mode = VIBRATOR_MODE_ALWAYS_OFF;
	PORT_ModifyOutPort(OP_VF_ON, 0);
	PORT_ModifyOutPort(OP_VF2_ON, 0);
	PORT_ModifyOutPort(OP_HOPER_AIR, 0);
}
//---------------------------------------------------------------------------
void MC_Vibrator_EmergencyReset(void)
{
	VibratorControlData.State =	VIBRATOR_STATE_OFF;
}
//---------------------------------------------------------------------------
void Bowl_Feeder_Sensor_Info_Init(void)
{
	BowlFeederSensorInfo.Sensor1OnCount	= 0;
	BowlFeederSensorInfo.Sensor2OnCount	= 0;
	BowlFeederSensorInfo.Sensor1OnRatio	= 0;
	BowlFeederSensorInfo.Sensor2OnRatio	= 0;
}
//---------------------------------------------------------------------------
void Bowl_Feeder_Sensor_Process(void)               //5msec  ==> 2msec
{
	static int sensorCount = 0;
	//static int SensorState1[5] = {0, 0,	0, 0, 0};

	if (PORT_ReadInPort(IP_BF_SENSOR_1))
	{
        BowlFeederSensorInfo.Sensor1OnCount++;
	}

	if(	PORT_ReadInPort(IP_BF_SENSOR_2))
	{
		BowlFeederSensorInfo.Sensor2OnCount++;
	}

	sensorCount++;
	if (sensorCount	== 200)
	{
		BowlFeederSensorInfo.Sensor1OnRatio	= BowlFeederSensorInfo.Sensor1OnCount *	100	/ sensorCount;
		BowlFeederSensorInfo.Sensor2OnRatio	= BowlFeederSensorInfo.Sensor2OnCount *	100	/ sensorCount;
		BowlFeederSensorInfo.Sensor1OnCount	= 0;
		BowlFeederSensorInfo.Sensor2OnCount	= 0;
		sensorCount	= 0;
	}
}
//---------------------------------------------------------------------------
void MC_Vibrator_Process(void)              //1000 msec  ==> 20msec
{
	//
	int	Qindex;
	int	RatioListIndex;
	int	Sensor1RatioSum=0, Sensor2RatioSum=0;
	int	BeforeSensor1Ratio,	BeforeSensor2Ratio;

	if ( (VibratorControlData.Mode == VIBRATOR_MODE_AUTO) || (VFControlInfo.DisplayMode	== Monitering) )
	{
		if(MachineSetupData.CompanyID == DOMESTIC_MACHINE3)
		{
			if(PORT_ReadInPort(IP_VB_SENSOR) && PORT_ReadOutPort(OP_VF2_ON))
			{
				PORT_ModifyAOValue(VF_HOPPER_SPPED_AO_INDEX, (unsigned	short) 110);
				PORT_ModifyOutPort(OP_VF2_ON, 0);	
			}
			else if(!PORT_ReadInPort(IP_VB_SENSOR) && !PORT_ReadOutPort(OP_VF2_ON))
			{
				PORT_ModifyAOValue(VF_HOPPER_SPPED_AO_INDEX, (unsigned	short) 255);
				PORT_ModifyOutPort(OP_VF2_ON, 1);
			}
		}
		if(	VFControlInfo.DisplayMode == Monitering	)
		{
			VibratorInfo.VFMode	= 1;
			VibratorInfo.SetRatio2 = VFControlInfo.Sensor2Ratio;
		}
		else
		{
			VibratorInfo.VFMode	= 2;
		}

		/********************************************************************************************/
		//								Sensor1, Sensor2 Average Filter								//
		/********************************************************************************************/
		for	( Qindex = 0 ; Qindex <	3; Qindex++	)
		{
			VibratorControlData.Sensor1RatioList[Qindex] = VibratorControlData.Sensor1RatioList[Qindex+1];
			VibratorControlData.Sensor2RatioList[Qindex] = VibratorControlData.Sensor2RatioList[Qindex+1];
            //VibratorControlData.Sensor1RatioList[Qindex] = BowlFeederSensorInfo.Sensor1OnCount;     //All 0
			//VibratorControlData.Sensor2RatioList[Qindex] = BowlFeederSensorInfo.Sensor2OnCount;
		}

		VibratorControlData.Sensor1RatioList[3]	= BowlFeederSensorInfo.Sensor1OnRatio;
		VibratorControlData.Sensor2RatioList[3]	= BowlFeederSensorInfo.Sensor2OnRatio;

		for(  RatioListIndex = 0 ; RatioListIndex <4; RatioListIndex++)
		{
			Sensor1RatioSum += VibratorControlData.Sensor1RatioList[RatioListIndex];
			Sensor2RatioSum += VibratorControlData.Sensor2RatioList[RatioListIndex];
		}

		BeforeSensor1Ratio = VibratorControlData.On_AverageSensor1Ratio;
		BeforeSensor2Ratio = VibratorControlData.On_AverageSensor2Ratio;

		VibratorInfo.BeforeSensor1Ratio = BeforeSensor1Ratio;
		VibratorInfo.BeforeSensor2Ratio = BeforeSensor2Ratio;

		VibratorControlData.On_AverageSensor1Ratio = Sensor1RatioSum / 4;
		VibratorControlData.On_AverageSensor2Ratio = Sensor2RatioSum / 4;

		VibratorInfo.AverageSensor1Ratio = VibratorControlData.On_AverageSensor1Ratio;
		VibratorInfo.AverageSensor2Ratio = VibratorControlData.On_AverageSensor2Ratio;	
		/********************************************************************************************/

		if ((VibratorControlData.Mode == VIBRATOR_MODE_AUTO)
            && ((VibratorControlData.StudySpeed >= 0) && (VibratorControlData.StudySpeed < 256)))
		{
			if(VFControlInfo.Sensor1Ratio != 100)
			{
				if(VFControlInfo.Sensor1Ratio > VibratorControlData.On_AverageSensor1Ratio && (VFControlInfo.Sensor1Ratio < (VFControlInfo.Sensor2Ratio + 100)) )
				{
		 			if (BeforeSensor1Ratio >= VibratorControlData.On_AverageSensor1Ratio)
		 			{
		 				VibratorControlData.StudySpeed += (int)((VFControlInfo.Sensor1Ratio - VibratorControlData.On_AverageSensor1Ratio) * 2 / VFControlInfo.Sensor1Ratio);
						if(VibratorControlData.StudySpeed >= VFControlInfo.StartSpeed)  VibratorControlData.StudySpeed	= VFControlInfo.StartSpeed; //255 ==> VFControlInfo.StartSpeed;

                        if(VibratorControlData.On_AverageSensor1Ratio >= VFControlInfo.Sensor1Ratio)	MC_VFControl(0);
                        else                                                                            MC_VFControl(VibratorControlData.StudySpeed);
		 			}
                    else if(BeforeSensor1Ratio < VibratorControlData.On_AverageSensor1Ratio)
                    {                        
                        MC_VFControl(0);
                    }
				}
				else if(VFControlInfo.Sensor1Ratio <= VibratorControlData.On_AverageSensor1Ratio)
				{
		 			if (BeforeSensor1Ratio <= VibratorControlData.On_AverageSensor1Ratio)
		 			{
						VibratorControlData.StudySpeed -= (int)((VibratorControlData.On_AverageSensor1Ratio - VFControlInfo.Sensor1Ratio) * 5 / VFControlInfo.Sensor1Ratio); //10 => 5
						if(VibratorControlData.StudySpeed <	VFControlInfo.StartSpeed) 	VibratorControlData.StudySpeed = VFControlInfo.StartSpeed;

						if(VibratorControlData.On_AverageSensor1Ratio >= VFControlInfo.Sensor1Ratio)	MC_VFControl(0);
						else									                                        MC_VFControl(VibratorControlData.StudySpeed);
		 			}
                    else if(BeforeSensor1Ratio > VibratorControlData.On_AverageSensor1Ratio)
                    {
                        //MC_VFControl(VibratorControlData.StudySpeed);  
                        MC_VFControl(0);
                    }
                    
				}
			}
			else
			{
				if(VFControlInfo.Sensor2Ratio > VibratorControlData.On_AverageSensor2Ratio)
				{
		 			if (BeforeSensor2Ratio >= VibratorControlData.On_AverageSensor2Ratio)
		 			{
		 				VibratorControlData.StudySpeed += (int)((VFControlInfo.Sensor2Ratio - VibratorControlData.On_AverageSensor2Ratio) * 2 / VFControlInfo.Sensor2Ratio);
						if(VibratorControlData.StudySpeed >=  VFControlInfo.StartSpeed) 	VibratorControlData.StudySpeed = VFControlInfo.StartSpeed; //255 ==> VFControlInfo.StartSpeed

                        if(VibratorControlData.On_AverageSensor2Ratio >= 100)	MC_VFControl(0);
                        else                            						MC_VFControl(VibratorControlData.StudySpeed);
		 			}
                    else if(BeforeSensor2Ratio < VibratorControlData.On_AverageSensor2Ratio)
                    {                        
                        MC_VFControl(0);
                    }
				}
				else if(VFControlInfo.Sensor2Ratio <= VibratorControlData.On_AverageSensor2Ratio)
				{
		 			if (BeforeSensor2Ratio <= VibratorControlData.On_AverageSensor2Ratio)
		 			{
		 				VibratorControlData.StudySpeed -= (int)((VibratorControlData.On_AverageSensor2Ratio - VFControlInfo.Sensor2Ratio) * 5 / VFControlInfo.Sensor2Ratio); //10 => 5
						if(VibratorControlData.StudySpeed <	VFControlInfo.StartSpeed) 	VibratorControlData.StudySpeed = VFControlInfo.StartSpeed;

                        if(VibratorControlData.On_AverageSensor2Ratio >= 100)	MC_VFControl(0);
                        else                            						MC_VFControl(VibratorControlData.StudySpeed);
		 			}
                    else if(BeforeSensor2Ratio > VibratorControlData.On_AverageSensor2Ratio)
                    {
                        MC_VFControl(VibratorControlData.StudySpeed);  
                    }
				}
			}
		}

		if(VibratorControlData.StudySpeed > 255 || VibratorControlData.AverageSpeed > 255)
		{
			//VibratorControlData.StudySpeed=VFControlInfo.ManualMaxSpeed;
			//VibratorControlData.StudySpeed=BeforeStudySpeed;

			//sjm Chg (s) Ʒó 	.
			if(VibratorControlData.Mode	== VIBRATOR_MODE_AUTO)
			{
				VibratorControlData.StudySpeed = VFControlInfo.StartSpeed;
			}
			else
			{
				VibratorControlData.StudySpeed=VFControlInfo.ManualMaxSpeed;
			} // Chg (e)

			VibratorControlData.AverageSpeed = 0 ;
		}

		//н  
		VibratorInfo.NowSpeed                                               = VibratorControlData.StudySpeed;
		VibratorInfo.NowSpeedList[VibratorInfo.CurrentListIndex]            = VibratorControlData.StudySpeed;	//VFSpeedList[CurrentVFUpdateIndex];

		VibratorInfo.AverageSpeedList[VibratorInfo.CurrentListIndex]        = VibratorControlData.AverageSpeed;  //VFSpeedList[CurrentVFUpdateIndex];
		VibratorInfo.AverageSensor1RatioList[VibratorInfo.CurrentListIndex]	= VibratorControlData.On_AverageSensor1Ratio;
		VibratorInfo.AverageSensor2RatioList[VibratorInfo.CurrentListIndex]	= VibratorControlData.On_AverageSensor2Ratio;
		VibratorInfo.VFSensor1RatioList[VibratorInfo.CurrentListIndex]      = BowlFeederSensorInfo.Sensor1OnRatio;
		VibratorInfo.VFSensor2RatioList[VibratorInfo.CurrentListIndex]      = BowlFeederSensorInfo.Sensor2OnRatio;

		//VibratorInfo.Sensor1ON_NowRatio =	BowlFeederSensorInfo.Sensor1OnRatio;
		//VibratorInfo.Sensor2ON_NowRatio =	BowlFeederSensorInfo.Sensor2OnRatio;
		VibratorInfo.Sensor1ON_NowRatio	= VibratorControlData.On_AverageSensor1Ratio;
		VibratorInfo.Sensor2ON_NowRatio	= VibratorControlData.On_AverageSensor2Ratio;

		VibratorInfo.SetRatio1 = VFControlInfo.Sensor1Ratio;
		VibratorInfo.SetRatio2 = VFControlInfo.Sensor2Ratio;

		VibratorInfo.CurrentListIndex =	(VibratorInfo.CurrentListIndex + 1)	& VFINFO_LIST_MASK;

		CurrentVFRatio          = (CurrentVFRatio + 1) & VF_RATIO_LIST_MASK;
		CurrentVFUpdateIndex    = (CurrentVFUpdateIndex + 1) &	VF_SPEED_LIST_MASK;
		BeforeStudySpeed        = VibratorControlData.StudySpeed;
	}
}
//---------------------------------------------------------------------------
void MC_Vibrator_ManualProcess(void)
{
	if (VibratorControlData.Mode ==	VIBRATOR_MODE_AUTO)
	{
		VibratorControlData.ManualSensorRatio =	(!VFControlInfo.ManualModeSensorIndex)?	// real	sensor data	ratio
													BowlFeederSensorInfo.Sensor1OnRatio	: BowlFeederSensorInfo.Sensor2OnRatio;
		VibratorControlData.ManualLimitSensorRatio = (!VFControlInfo.ManualModeLimitSensorIndex)?
														BowlFeederSensorInfo.Sensor1OnRatio	: BowlFeederSensorInfo.Sensor2OnRatio;

		if(VFControlInfo.ManualModeSensorIndex == VFControlInfo.ManualModeLimitSensorIndex)	//same senser index?
		{
			if(VFControlInfo.ManualModeSensorActiveRatio <=	VFControlInfo.ManualModeLimitSensorActiveRatio)	//error	compansation
			{
				if(VFControlInfo.ManualModeSensorActiveRatio ==	VFControlInfo.ManualModeLimitSensorActiveRatio)	//same ratio setting?
				{
					VibratorControlData.ManualModeControlSpeed = (VFControlInfo.ManualModeSensorActiveRatio	> VibratorControlData.ManualSensorRatio) ?
																			VFControlInfo.ManualMaxSpeed: 0;
				}
				else //different ratio setting?
				{
					if(VFControlInfo.ManualModeSensorActiveRatio > VibratorControlData.ManualSensorRatio)
					{
						VibratorControlData.ManualModeControlSpeed = VFControlInfo.ManualMaxSpeed;
					}
					else if(VFControlInfo.ManualModeLimitSensorActiveRatio > VibratorControlData.ManualLimitSensorRatio)
					{
						VibratorControlData.ManualModeControlSpeed = VFControlInfo.ManualLimitSpeed;
					}
					else
					{
						VibratorControlData.ManualModeControlSpeed = 0;
					}
				}
			}
			else
			{
				VibratorControlData.ManualModeControlSpeed = 0;
			}
		}
		else
		{
			if(VFControlInfo.ManualModeSensorIndex < VFControlInfo.ManualModeLimitSensorIndex) //First speed Index -> Sensor1, Second speed(Low	speed) Index ->	Sensor2
			{
				if(VFControlInfo.ManualModeSensorActiveRatio > VibratorControlData.ManualSensorRatio)
				{
					VibratorControlData.ManualModeControlSpeed = VFControlInfo.ManualMaxSpeed;
				}
				else if(VFControlInfo.ManualModeLimitSensorActiveRatio > VibratorControlData.ManualLimitSensorRatio)
				{
					VibratorControlData.ManualModeControlSpeed = VFControlInfo.ManualLimitSpeed;
				}
				else
				{
					VibratorControlData.ManualModeControlSpeed = 0;
				}
			}
			else  //First speed	Index -> Sensor2, Second speed(Low speed) Index	-> Sensor1
			{
				if(VFControlInfo.ManualModeSensorActiveRatio > VFControlInfo.ManualModeLimitSensorActiveRatio)
				{
					// 1ӵ 2 	 2ӵ 1 	 Ŭ
					VibratorControlData.ManualModeControlSpeed = (VFControlInfo.ManualModeSensorActiveRatio	> VibratorControlData.ManualSensorRatio)?
																  VFControlInfo.ManualMaxSpeed : 0;
				}
				else
				{
					if(VFControlInfo.ManualModeSensorActiveRatio > VibratorControlData.ManualSensorRatio)
					{
						VibratorControlData.ManualModeControlSpeed = VFControlInfo.ManualMaxSpeed;
					}
					else if(VFControlInfo.ManualModeLimitSensorActiveRatio > VibratorControlData.ManualLimitSensorRatio)
					{
						VibratorControlData.ManualModeControlSpeed = VFControlInfo.ManualLimitSpeed;
					}
					else
					{
						VibratorControlData.ManualModeControlSpeed = 0;
					}
				}
			}
		}

		if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_NONE	|| BowlFeederProcedureData.State ==	BOWL_FEEDER_STATE_STOP
				|| BowlFeederProcedureData.State ==	BOWL_FEEDER_STATE_EMERGENCY_STOP)
		{
			MC_VFControl(0);
		}
		else
		{
			MC_VFControl(VibratorControlData.ManualModeControlSpeed);
		}

		VibratorInfo.VFSpeedList[VibratorInfo.CurrentListIndex]	= VibratorControlData.ManualModeControlSpeed;
		VibratorInfo.VFMaxSpeedList[VibratorInfo.CurrentListIndex] = VFControlInfo.ManualMaxSpeed;
		VibratorInfo.VFLimitSpeedList[VibratorInfo.CurrentListIndex] = VFControlInfo.ManualLimitSpeed;
		VibratorInfo.VFSensor1RatioList[VibratorInfo.CurrentListIndex] = BowlFeederSensorInfo.Sensor1OnRatio;
		VibratorInfo.VFSensor2RatioList[VibratorInfo.CurrentListIndex] = BowlFeederSensorInfo.Sensor2OnRatio;
		VibratorInfo.CurrentListIndex =	(VibratorInfo.CurrentListIndex + 1)	& VFINFO_LIST_MASK;
	}
}

//---------------------------------------------------------------------------

void MC_SuctionDisk_Init(void)
{
	SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
	SuctionDiskProcedureData.State = SD_STATE_STOP;
	SuctionDiskProcedureData.Disk1Speed	= SERVO_MOTOR_MAX_SPEED_VALUE;
	SuctionDiskProcedureData.Disk2Speed	= SERVO_MOTOR_MAX_SPEED_VALUE;
	SuctionDiskProcedureData.Inverter1Speed	= 0;
	SuctionDiskProcedureData.Inverter2Speed	= 0;
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_Run(int	disk1Speed,	int	disk2Speed,	unsigned char inverter1Speed, unsigned char	inverter2Speed)
{
	if (SuctionDiskProcedureData.State != SD_STATE_EMERGENCY_STOP)
	{
		OperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX] = disk1Speed;
		OperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX] = disk2Speed;

		SuctionDiskProcedureData.Disk1Speed	= disk1Speed;
		SuctionDiskProcedureData.Disk2Speed	= disk2Speed;
		SuctionDiskProcedureData.Inverter1Speed	= inverter1Speed;
		SuctionDiskProcedureData.Inverter2Speed	= inverter2Speed;
		SuctionDiskProcedureData.Command = SD_COMMAND_RUN;
	}
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_SpeedChange(int	disk1Speed,	int	disk2Speed)
{
	if (SuctionDiskProcedureData.State != SD_STATE_EMERGENCY_STOP)
	{
		OperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX] = disk1Speed;
		OperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX] = disk2Speed;

		SuctionDiskProcedureData.Disk1Speed	= disk1Speed;
		SuctionDiskProcedureData.Disk2Speed	= disk2Speed;
		if (SuctionDiskProcedureData.State == SD_STATE_RUN)
		{
			SuctionDiskProcedureData.Command = SD_COMMAND_RUN;
		}
	}
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_Stop(void)
{
	if (SuctionDiskProcedureData.State != SD_STATE_EMERGENCY_STOP)
	{
		SuctionDiskProcedureData.Command = SD_COMMAND_STOP;
	}
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_MotorStop(void)
{
	Servo_Motor_Stop(SD1_MOTOR_INDEX);
	Servo_Motor_Stop(SD2_MOTOR_INDEX);
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_EmergencyStop(void)
{
	Servo_Motor_Stop_Param(SD1_MOTOR_INDEX,	SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(SD2_MOTOR_INDEX,	SERVO_MOTOR_EMERGENCY_STOP_TIME);
	SuctionDiskProcedureData.PrevState = SuctionDiskProcedureData.State;
	SuctionDiskProcedureData.State = SD_STATE_EMERGENCY_STOP;
	SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_EmergencyReset(void)
{
	MC_RingBlower_Off(SD1_RING_BLOWER_INDEX);
	MC_RingBlower_Off(SD2_RING_BLOWER_INDEX);
	MC_RingBlower_Off(SD_DUST_RING_BLOWER_INDEX);

	// suction disk	nozzle off
	PORT_ModifyOutPort(OP_SD1_AIR, 0);
	PORT_ModifyOutPort(OP_SD2_AIR, 0);

	SuctionDiskProcedureData.State = SD_STATE_STOP;
	SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
}
//---------------------------------------------------------------------------
void MC_SuctionDisk_Process(void)		// per 1ms
{
	if (SuctionDiskProcedureData.Command ==	SD_COMMAND_NONE)
	{
		if (SuctionDiskProcedureData.State == SD_STATE_RUN || SuctionDiskProcedureData.State ==	SD_STATE_STOP)
		{
			return;
		}
		else if	(SuctionDiskProcedureData.State	== SD_STATE_SUCTION_WAITING)
		{
			if (Board1MSTmr	- SuctionDiskProcedureData.SuctionOnStartTime >	SUCTION_READY_TIME)
			{
				Servo_Motor_Run(SD1_MOTOR_INDEX, SuctionDiskProcedureData.Disk1Speed);
				Servo_Motor_Run(SD2_MOTOR_INDEX, SuctionDiskProcedureData.Disk2Speed);
				SuctionDiskProcedureData.DiskAccStartTime =	Board1MSTmr;
				SuctionDiskProcedureData.State = SD_STATE_ACC;
			}
		}
		else if	(SuctionDiskProcedureData.State	== SD_STATE_ACC)
		{
			if (Servo_Motor_CheckRun(SD1_MOTOR_INDEX) && Servo_Motor_CheckRun(SD2_MOTOR_INDEX))
			{
				MC_RingBlower_On(SD1_RING_BLOWER_INDEX,	SuctionDiskProcedureData.Inverter1Speed);
				MC_RingBlower_On(SD2_RING_BLOWER_INDEX,	SuctionDiskProcedureData.Inverter2Speed);
				MC_RingBlower_On(SD_DUST_RING_BLOWER_INDEX,	0);
				// suction disk	nozzle on
				PORT_ModifyOutPort(OP_SD1_AIR, 1);
				PORT_ModifyOutPort(OP_SD2_AIR, 1);
				//Pressure Regulator set for Ejector : cik add
				MC_Pressure_Regulator_Set(MainControlData.adjustEjectorWindStrength);
				SuctionDiskProcedureData.StableCheckStartTime =	Board1MSTmr	+ SD_STABLE_CHECK_DELAY;
				SuctionDiskProcedureData.State = SD_STATE_RUN;
			}
		}
		else if	(SuctionDiskProcedureData.State	== SD_STATE_DEC1)
		{
			if (Servo_Motor_CheckStopped(SD1_MOTOR_INDEX))
			{
				Servo_Motor_Stop(SD2_MOTOR_INDEX);
				SuctionDiskProcedureData.DiskDecStartTime[1] = Board1MSTmr;
				SuctionDiskProcedureData.State = SD_STATE_DEC2;
			}
		}
		else if	(SuctionDiskProcedureData.State	== SD_STATE_DEC2)
		{
			if (Servo_Motor_CheckStopped(SD2_MOTOR_INDEX))
			{
				if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					if(WaitStop_State != PROCEDURE_MODE_WAITSTOP2)
					{
						MC_RingBlower_Off(SD1_RING_BLOWER_INDEX);
						MC_RingBlower_Off(SD2_RING_BLOWER_INDEX);
						MC_RingBlower_Off(SD_DUST_RING_BLOWER_INDEX);
						PORT_ModifyOutPort(OP_SD1_AIR, 0);
						PORT_ModifyOutPort(OP_SD2_AIR, 0);
					}
				}
				else
				{
					MC_RingBlower_Off(SD1_RING_BLOWER_INDEX);
					MC_RingBlower_Off(SD2_RING_BLOWER_INDEX);
					MC_RingBlower_Off(SD_DUST_RING_BLOWER_INDEX);
					PORT_ModifyOutPort(OP_SD1_AIR, 0);
					PORT_ModifyOutPort(OP_SD2_AIR, 0);
				}
				
				SuctionDiskProcedureData.State = SD_STATE_STOP;
			}
		}
	}
	else if	(SuctionDiskProcedureData.Command == SD_COMMAND_RUN)
	{
		if (SuctionDiskProcedureData.State == SD_STATE_STOP	|| SuctionDiskProcedureData.State == SD_STATE_SUCTION_WAITING)
		{
/*
			MC_RingBlower_On(SD1_RING_BLOWER_INDEX,	SuctionDiskProcedureData.Inverter1Speed);
			MC_RingBlower_On(SD2_RING_BLOWER_INDEX,	SuctionDiskProcedureData.Inverter2Speed);
			MC_RingBlower_On(SD_DUST_RING_BLOWER_INDEX,	0);
			// suction disk	nozzle on
			PORT_ModifyOutPort(OP_SD1_AIR, 1);
			PORT_ModifyOutPort(OP_SD2_AIR, 1);
			//Pressure Regulator set for Ejector : cik add
			MC_Pressure_Regulator_Set(MainControlData.adjustEjectorWindStrength);
*/
			SuctionDiskProcedureData.SuctionOnStartTime	= Board1MSTmr;
			SuctionDiskProcedureData.State = SD_STATE_SUCTION_WAITING;
			SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
		}
		else if	(SuctionDiskProcedureData.State	== SD_STATE_DEC1 ||
			SuctionDiskProcedureData.State == SD_STATE_DEC2	||
			SuctionDiskProcedureData.State == SD_STATE_ACC ||
			SuctionDiskProcedureData.State == SD_STATE_RUN)
		{
/*
			MC_RingBlower_On(SD1_RING_BLOWER_INDEX,	SuctionDiskProcedureData.Inverter1Speed);	// for suction speed change
			MC_RingBlower_On(SD2_RING_BLOWER_INDEX,	SuctionDiskProcedureData.Inverter2Speed);
			MC_RingBlower_On(SD_DUST_RING_BLOWER_INDEX,	1);
*/
			Servo_Motor_Run(SD1_MOTOR_INDEX, SuctionDiskProcedureData.Disk1Speed);
			Servo_Motor_Run(SD2_MOTOR_INDEX, SuctionDiskProcedureData.Disk2Speed);
			SuctionDiskProcedureData.DiskAccStartTime =	Board1MSTmr;
			SuctionDiskProcedureData.State = SD_STATE_ACC;
			SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
		}
		else
		{
			SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
		}
		WaitStop_State = 0;
	}
	else if	(SuctionDiskProcedureData.Command == SD_COMMAND_STOP)
	{
		if (SuctionDiskProcedureData.State == SD_STATE_STOP	|| SuctionDiskProcedureData.State == SD_STATE_SUCTION_WAITING)
		{
			if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				if(WaitStop_State != PROCEDURE_MODE_WAITSTOP2)
				{
					MC_RingBlower_Off(SD1_RING_BLOWER_INDEX);
					MC_RingBlower_Off(SD2_RING_BLOWER_INDEX);
					MC_RingBlower_Off(SD_DUST_RING_BLOWER_INDEX);
					PORT_ModifyOutPort(OP_SD1_AIR, 0);
					PORT_ModifyOutPort(OP_SD2_AIR, 0);
				}
			}
			else
			{
				MC_RingBlower_Off(SD1_RING_BLOWER_INDEX);
				MC_RingBlower_Off(SD2_RING_BLOWER_INDEX);
				MC_RingBlower_Off(SD_DUST_RING_BLOWER_INDEX);
				PORT_ModifyOutPort(OP_SD1_AIR, 0);
				PORT_ModifyOutPort(OP_SD2_AIR, 0);
			}
			SuctionDiskProcedureData.State = SD_STATE_STOP;
			SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
		}
		else if	(SuctionDiskProcedureData.State	== SD_STATE_RUN	|| SuctionDiskProcedureData.State == SD_STATE_ACC)
		{
			Servo_Motor_Stop(SD1_MOTOR_INDEX);
			SuctionDiskProcedureData.DiskDecStartTime[0] = Board1MSTmr;
			SuctionDiskProcedureData.State = SD_STATE_DEC1;
			SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
		}
		else
		{
			SuctionDiskProcedureData.Command = SD_COMMAND_NONE;
		}
	}
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_Init(void)
{
	// bowl	feeder init
	BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_NONE;
	BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_STOP;

	BowlFeederProcedureData.InnerDiskSpeed = SERVO_MOTOR_MAX_SPEED_VALUE;
	BowlFeederProcedureData.OuterDisk1Speed = SERVO_MOTOR_MAX_SPEED_VALUE;
	BowlFeederProcedureData.OuterDisk2Speed = SERVO_MOTOR_MAX_SPEED_VALUE;
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_Run(int innerDiskSpeed, int outerDisk1Speed, int outerDisk2Speed, char airKnifeSpeed)
{
	if (BowlFeederProcedureData.State != BOWL_FEEDER_STATE_EMERGENCY_STOP)
	{
		OperationInfo.ServoMotorSpeed[BF_ID_MOTOR_INDEX] = innerDiskSpeed;
		OperationInfo.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX] = outerDisk1Speed;
		OperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX] = outerDisk2Speed;

		BowlFeederProcedureData.InnerDiskSpeed = innerDiskSpeed;
		BowlFeederProcedureData.OuterDisk1Speed = outerDisk1Speed;
		BowlFeederProcedureData.OuterDisk2Speed = outerDisk2Speed;
		BowlFeederProcedureData.AirKnifeSpeed =	airKnifeSpeed;
		BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_RUN;
	}
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_SpeedChange(int innerDiskSpeed, int outerDisk1Speed, int outerDisk2Speed)
{
	if (BowlFeederProcedureData.State != BOWL_FEEDER_STATE_EMERGENCY_STOP)
	{
		OperationInfo.ServoMotorSpeed[BF_ID_MOTOR_INDEX] = innerDiskSpeed;
		OperationInfo.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX] = outerDisk1Speed;
		OperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX] = outerDisk2Speed;

		BowlFeederProcedureData.InnerDiskSpeed = innerDiskSpeed;
		BowlFeederProcedureData.OuterDisk1Speed = outerDisk1Speed;
		BowlFeederProcedureData.OuterDisk2Speed = outerDisk2Speed;
		if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_RUN)
		{
			BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_RUN;
		}
	}
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_Stop(void)
{
	if (BowlFeederProcedureData.State != BOWL_FEEDER_STATE_EMERGENCY_STOP)
	{
		BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_STOP;
	}
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_AKControl(char speed)
{
	BowlFeederProcedureData.AirKnifeSpeed =	speed;
#ifdef SELMA	
    // Air Knife 3 	 ش޶ û .
	//Air Knife	
	if (BowlFeederProcedureData.AirKnifeSpeed == 0x01)
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 1);
	}
	else
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
	}

	if (BowlFeederProcedureData.AirKnifeSpeed == 0x02)
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 1);
	}
	else
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
	}

	if (BowlFeederProcedureData.AirKnifeSpeed == 0x03)
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 1);
	}
	else
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 0);
	}
#else	
	// 1 = 1, 2	= 1, 3=	1+2	==>	1=1,2=1,3=1
	if (BowlFeederProcedureData.AirKnifeSpeed &	0x01)
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 1);
	}
	else
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
	}
	if (BowlFeederProcedureData.AirKnifeSpeed &	0x02)
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 1);
	}
	else
	{
		PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
	}
#endif
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_Reset(void)
{
	BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_STOP;
	BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_NONE;
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_EmergencyStop(void)
{
	BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_NONE;
	Servo_Motor_Stop_Param(BF_ID_MOTOR_INDEX, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(BF_OD_IN_MOTOR_INDEX, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(BF_OD_OUT_MOTOR_INDEX, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
	PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
#ifdef SELMA	
	PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 0);	//Air Knife	3
#endif	
	BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_EMERGENCY_STOP;
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_EmergencyReset(void)
{
	BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_STOP;
	BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_NONE;
}
//---------------------------------------------------------------------------
void MC_BowlFeeder_Process(void)
{
	if (BowlFeederProcedureData.Command	== BOWL_FEEDER_COMMAND_NONE)
	{
		if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_RUN ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_STOP)
		{
			return;
		}
		else if	(BowlFeederProcedureData.State == BOWL_FEEDER_STATE_OUTER_ACC)
		{
			if (Board1MSTmr	- BowlFeederProcedureData.OuterDiskAccStartTime	> ServoMotorInfo[BF_OD_IN_MOTOR_INDEX].AccTime	/ 2)
			{
				Servo_Motor_Run(BF_ID_MOTOR_INDEX, BowlFeederProcedureData.InnerDiskSpeed);
				BowlFeederProcedureData.InnerDiskAccStartTime =	Board1MSTmr;
				BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_INNER_ACC;
			}
		}
		else if	(BowlFeederProcedureData.State == BOWL_FEEDER_STATE_INNER_ACC)
		{
			if (Board1MSTmr	- BowlFeederProcedureData.InnerDiskAccStartTime	> ServoMotorInfo[BF_ID_MOTOR_INDEX].AccTime)
			{
				BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_RUN;
			}
		}
		else if	(BowlFeederProcedureData.State == BOWL_FEEDER_STATE_INNER_DEC)
		{
			if (Board1MSTmr	- BowlFeederProcedureData.InnerDiskDecStartTime	> ServoMotorInfo[BF_ID_MOTOR_INDEX].DecTime	/ 2)
			{
				Servo_Motor_Stop(BF_OD_IN_MOTOR_INDEX);
				Servo_Motor_Stop(BF_OD_OUT_MOTOR_INDEX);
				BowlFeederProcedureData.OuterDiskDecStartTime =	Board1MSTmr;
				BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_OUTER_DEC;
			}
		}
		else if	(BowlFeederProcedureData.State == BOWL_FEEDER_STATE_OUTER_DEC)
		{
			if (Board1MSTmr	- BowlFeederProcedureData.OuterDiskDecStartTime	> ServoMotorInfo[BF_OD_IN_MOTOR_INDEX].DecTime)
			{
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
#ifdef SELMA				
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 0);	//Air Knife	3
#endif				
				BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_STOP;
			}
		}
	}
	else if	(BowlFeederProcedureData.Command ==	BOWL_FEEDER_COMMAND_RUN)
	{
		if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_STOP	||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_RUN ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_OUTER_ACC ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_INNER_ACC ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_INNER_DEC ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_OUTER_DEC)
		{
#ifdef SELMA		    
		    //Air Knife
			if (BowlFeederProcedureData.AirKnifeSpeed == 0x01)
			{
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 1);
			}
			if (BowlFeederProcedureData.AirKnifeSpeed == 0x02)
			{
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 1);
			}
			if (BowlFeederProcedureData.AirKnifeSpeed == 0x03)
			{
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 1);
			}
#else			
			// Air Knife 
			if (BowlFeederProcedureData.AirKnifeSpeed &	0x01)
			{
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 1);
			}
			if (BowlFeederProcedureData.AirKnifeSpeed &	0x02)
			{
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 1);
			}
#endif

			Servo_Motor_Run(BF_OD_IN_MOTOR_INDEX, BowlFeederProcedureData.OuterDisk1Speed);
			Servo_Motor_Run(BF_OD_OUT_MOTOR_INDEX, BowlFeederProcedureData.OuterDisk2Speed);
			BowlFeederProcedureData.OuterDiskAccStartTime =	Board1MSTmr;
			BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_OUTER_ACC;
		}
		BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_NONE;
	}
	else if	(BowlFeederProcedureData.Command ==	BOWL_FEEDER_COMMAND_STOP)
	{
		if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_RUN ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_OUTER_ACC ||
			BowlFeederProcedureData.State == BOWL_FEEDER_STATE_INNER_ACC)
		{
			// stop	motor
			//PORT_ModifyOutPort(OP_BF_AIR_KNIFE, 0);
			Servo_Motor_Stop(BF_ID_MOTOR_INDEX);
			BowlFeederProcedureData.InnerDiskDecStartTime =	Board1MSTmr;
			BowlFeederProcedureData.State =	BOWL_FEEDER_STATE_INNER_DEC;
		}
		BowlFeederProcedureData.Command	= BOWL_FEEDER_COMMAND_NONE;
	}
}
//---------------------------------------------------------------------------
void MC_NC_Control_Init(void)
{
	NCControlInfo.Command =	NC_CONTROL_COMMAND_NONE;
	NCControlInfo.State	= NC_CONTROL_STATE_IDLE;
	NCControlInfo.HomeSearchState =	NC_HOME_SEARCH_STATE_NONE;
	NCControlInfo.PosState = NC_CONTROL_POS_STATE_NONE;
	NCControlInfo.HomeDetectionFailed =	FALSE;
	NCControlInfo.HomeDetected = FALSE;
}
//---------------------------------------------------------------------------
void MC_NC_HomePositionSetup(void)
{
	Step_Motor_HomeSearch(BF_UP_DOWN_MOTOR_INDEX);
	Step_Motor_HomeSearch(SD2_LEFT_RIGHT_MOTOR_INDEX);
	NCControlInfo.HomeDetectionFailed =	FALSE;
	NCControlInfo.HomeSearchState =	NC_HOME_SEARCH_STATE_FIRST_STAGE;
}
//---------------------------------------------------------------------------
void MC_NC_CleaningMoveBegin(void)
{
	if (!NCControlInfo.HomeDetected)
	{
		MC_NC_HomePositionSetup();
		NCControlInfo.ControlState = 0;
	}
	else
	{
		NCControlInfo.ControlState = 1;
	}
	NCControlInfo.Command =	NC_CONTROL_COMMAND_CLEANING;
	NCControlInfo.State	= NC_CONTROL_STATE_DETACHING;
	NCControlInfo.PosState = NC_CONTROL_POS_STATE_NONE;
}
//---------------------------------------------------------------------------
void MC_NC_ReadyMoveBegin(void)
{
	if (MainControlData.State == MAIN_CONTROL_STATE_CLEANING && NCControlInfo.State == NC_CONTROL_STATE_IDLE)
	{
		NCControlInfo.HomeDetected = FALSE;
	}
	if (!NCControlInfo.HomeDetected)
	{
		MC_NC_HomePositionSetup();
		NCControlInfo.ControlState = 0;
	}
	else
	{
		NCControlInfo.ControlState = 1;
	}

	NCControlInfo.Command =	NC_CONTROL_COMMAND_READY;
	NCControlInfo.State	= NC_CONTROL_STATE_ATTACHING;
	NCControlInfo.PosState = NC_CONTROL_POS_STATE_NONE;
}
//---------------------------------------------------------------------------
void MC_NC_Control_EmergencyStop(void)
{
	ManualEncoderInfo.Enabled =	TRUE;
	NCControlInfo.Command =	NC_CONTROL_COMMAND_NONE;
}
//---------------------------------------------------------------------------
void MC_NC_Control_EmergencyReset(void)
{

}
//---------------------------------------------------------------------------
void MC_NC_HomeSearch_Process(void)
{
	int	stepMotorIndex,	homeFinishedCount, errorCount;
	if (NCControlInfo.HomeSearchState == NC_HOME_SEARCH_STATE_FIRST_STAGE)
	{
		if (StepMotorData[BF_UP_DOWN_MOTOR_INDEX].HomeDetected || StepMotorData[BF_UP_DOWN_MOTOR_INDEX].State == STEP_MOTOR_STATE_ERROR)
		{
			Step_Motor_HomeSearch(BF_IN_OUT_MOTOR_INDEX);
			Step_Motor_HomeSearch(VG1_UP_DOWN_MOTOR_INDEX);
			Step_Motor_HomeSearch(VG2_UP_DOWN_MOTOR_INDEX);
			NCControlInfo.HomeSearchState =	NC_HOME_SEARCH_STATE_SECOND_STAGE;
		}
	}
	else if	(NCControlInfo.HomeSearchState == NC_HOME_SEARCH_STATE_SECOND_STAGE)
	{
		homeFinishedCount =	0;
		errorCount = 0;
		for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
		{
			//if (StepMotorData[BF_UP_DOWN_MOTOR_INDEX].HomeDetected ||	StepMotorData[BF_UP_DOWN_MOTOR_INDEX].State	== STEP_MOTOR_STATE_ERROR)
			if (StepMotorData[stepMotorIndex].HomeDetected)
			{
				homeFinishedCount++;
			}
			else if	(StepMotorData[stepMotorIndex].State ==	STEP_MOTOR_STATE_ERROR)
			{
				errorCount++;
			}
		}
		if (errorCount > 0)
		{
			NCControlInfo.HomeDetectionFailed =	TRUE;
			NCControlInfo.HomeSearchState =	NC_HOME_SEARCH_STATE_NONE;
		}
		else if	(homeFinishedCount == MAX_STEP_MOTOR_COUNT)
		{
			NCControlInfo.HomeDetected = TRUE;
			NCControlInfo.HomeSearchState =	NC_HOME_SEARCH_STATE_NONE;
		}
	}
}
//---------------------------------------------------------------------------
void MC_NC_Control_Processs(void)
{
	int	readyMotorCount, errorMotorCount, stepMotorIndex;

	if (NCControlInfo.Command == NC_CONTROL_COMMAND_NONE)
	{
		return;
	}
	else if	(NCControlInfo.Command == NC_CONTROL_COMMAND_CLEANING)
	{
		if (NCControlInfo.ControlState == 0)
		{
			ManualEncoderInfo.Enabled =	FALSE;
			if (NCControlInfo.HomeDetected)
			{
				NCControlInfo.ControlState = 1;
			}
			else if	(NCControlInfo.HomeDetectionFailed)
			{
				NCControlInfo.State	= NC_CONTROL_STATE_ERROR;
				NCControlInfo.ControlState = 100;
			}
		}
		else if	(NCControlInfo.ControlState	== 1)
		{
			ManualEncoderInfo.Enabled =	FALSE;
			Step_Motor_MovePos(BF_UP_DOWN_MOTOR_INDEX, 0);
			Step_Motor_MovePos(SD2_LEFT_RIGHT_MOTOR_INDEX, 0);
			NCControlInfo.ControlState = 2;
		}
		else if	(NCControlInfo.ControlState	== 2)
		{
			ManualEncoderInfo.Enabled =	FALSE;
			readyMotorCount	= 0;
			errorMotorCount	= 0;
			for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
			{
				if (StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_IDLE)
				{
					readyMotorCount++;
				}
				else if	(StepMotorData[stepMotorIndex].State ==	STEP_MOTOR_STATE_ERROR ||
					StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_STALL)
				{
					errorMotorCount++;
				}
			}

			if (errorMotorCount	> 0)
			{
				NCControlInfo.State	= NC_CONTROL_STATE_ERROR;
				NCControlInfo.ControlState = 100;
			}
			else if	(readyMotorCount ==	MAX_STEP_MOTOR_COUNT)
			{
				//Step_Motor_MovePos(BF_IN_OUT_MOTOR_INDEX,	0);
				//Step_Motor_MovePos(VG1_UP_DOWN_MOTOR_INDEX, 0);
				//Step_Motor_MovePos(VG2_UP_DOWN_MOTOR_INDEX, 0);
				NCControlInfo.ControlState = 3;
			}
		}
		else if	(NCControlInfo.ControlState	== 3)
		{
			readyMotorCount	= 0;
			errorMotorCount	= 0;
			for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
			{
				if (StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_IDLE)
				{
					readyMotorCount++;
				}
				else if	(StepMotorData[stepMotorIndex].State ==	STEP_MOTOR_STATE_ERROR ||
					StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_STALL)
				{
					errorMotorCount++;
				}
			}
			if (readyMotorCount	== MAX_STEP_MOTOR_COUNT)
			{
				NCControlInfo.PosState = NC_CONTROL_POS_STATE_CLEANING;
				NCControlInfo.State	= NC_CONTROL_STATE_IDLE;
				NCControlInfo.ControlState = 100;
			}
			else if	(errorMotorCount > 0)
			{
				NCControlInfo.State	= NC_CONTROL_STATE_ERROR;
				NCControlInfo.ControlState = 100;
			}
		}
		else if	(NCControlInfo.ControlState	== 100)	// end function
		{
			ManualEncoderInfo.Enabled =	TRUE;
			NCControlInfo.Command =	NC_CONTROL_COMMAND_NONE;
		}
	}
	else if	(NCControlInfo.Command == NC_CONTROL_COMMAND_READY)
	{
		if (NCControlInfo.ControlState == 0)
		{
			ManualEncoderInfo.Enabled =	FALSE;
			if (NCControlInfo.HomeDetected)
			{
				NCControlInfo.ControlState = 1;
			}
			else if	(NCControlInfo.HomeDetectionFailed)
			{
				NCControlInfo.State	= NC_CONTROL_STATE_ERROR;
				NCControlInfo.ControlState = 100;
			}
		}
		else if	(NCControlInfo.ControlState	== 1)
		{
			ManualEncoderInfo.Enabled =	FALSE;
			Step_Motor_MovePos(BF_IN_OUT_MOTOR_INDEX, MainControlData.NCPos[BF_IN_OUT_MOTOR_INDEX]);
			Step_Motor_MovePos(VG1_UP_DOWN_MOTOR_INDEX,	MainControlData.NCPos[VG1_UP_DOWN_MOTOR_INDEX]);
			Step_Motor_MovePos(VG2_UP_DOWN_MOTOR_INDEX,	MainControlData.NCPos[VG2_UP_DOWN_MOTOR_INDEX]);
			NCControlInfo.ControlState = 2;
		}
		else if	(NCControlInfo.ControlState	== 2)
		{
			readyMotorCount	= 0;
			errorMotorCount	= 0;
			for	(stepMotorIndex	= BF_IN_OUT_MOTOR_INDEX; stepMotorIndex	<= VG2_UP_DOWN_MOTOR_INDEX;	stepMotorIndex++)
			{
				if (StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_IDLE)
				{
					readyMotorCount++;
				}
				else if	(StepMotorData[stepMotorIndex].State ==	STEP_MOTOR_STATE_ERROR ||
					StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_STALL)
				{
					errorMotorCount++;
				}
			}

			if (errorMotorCount	> 0)
			{
				NCControlInfo.State	= NC_CONTROL_STATE_ERROR;
				NCControlInfo.ControlState = 100;
			}
			else if	(readyMotorCount ==	3)
			{
				Step_Motor_MovePos(BF_UP_DOWN_MOTOR_INDEX, MainControlData.NCPos[BF_UP_DOWN_MOTOR_INDEX]);
				Step_Motor_MovePos(SD2_LEFT_RIGHT_MOTOR_INDEX, MainControlData.NCPos[SD2_LEFT_RIGHT_MOTOR_INDEX]);
				NCControlInfo.ControlState = 3;
			}
		}
		else if	(NCControlInfo.ControlState	== 3)
		{
			readyMotorCount	= 0;
			errorMotorCount	= 0;
			for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
			{
				if (StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_IDLE)
				{
					readyMotorCount++;
				}
				else if	(StepMotorData[stepMotorIndex].State ==	STEP_MOTOR_STATE_ERROR ||
					StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_STALL)
				{
					errorMotorCount++;
				}
			}
			if (readyMotorCount	== MAX_STEP_MOTOR_COUNT)
			{
				NCControlInfo.PosState = NC_CONTROL_POS_STATE_READY;
				NCControlInfo.State	= NC_CONTROL_STATE_IDLE;
				NCControlInfo.ControlState = 100;
			}
			else if	(errorMotorCount > 0)
			{
				NCControlInfo.State	= NC_CONTROL_STATE_ERROR;
				NCControlInfo.ControlState = 100;
			}
		}
		else if	(NCControlInfo.ControlState	== 100)	// end function
		{
			ManualEncoderInfo.Enabled =	TRUE;
			NCControlInfo.Command =	NC_CONTROL_COMMAND_NONE;
		}
	}

}
//---------------------------------------------------------------------------
void MC_LED_Init(void)
{
	int	ledIndex;

	// led init
	memset(LEDControlData,0,sizeof(LEDControlData));
	for	(ledIndex =	0; ledIndex	< MAX_LED_COUNT; ledIndex++)
	{
		LEDControlData[ledIndex].State = LED_STATE_OFF;
	}

	LEDControlData[0].OPIndex =	OP_LED_1;
	LEDControlData[1].OPIndex =	OP_LED_2;
	LEDControlData[2].OPIndex =	OP_LED_3;
	LEDControlData[3].OPIndex =	OP_LED_4;
	LEDControlData[4].OPIndex =	OP_LED_5;
	LEDControlData[5].OPIndex =	OP_LED_6;
//	LEDControlData[5].OPIndex =	OP_TPB_LED;
	LEDControlData[6].OPIndex =	OP_LED_7;
	LEDControlData[7].OPIndex =	OP_LED_8;
	LEDControlData[8].OPIndex =	OP_LED_9;
	LEDControlData[9].OPIndex =	OP_LED_10;
	LEDControlData[10].OPIndex = OP_LED_11;
	LEDControlData[11].OPIndex = OP_LED_12;
}
//---------------------------------------------------------------------------
void MC_LED_On(int ledIndex, int type, int param1, int param2)
{
	if (type ==	LED_TYPE_FLASH)
	{
		LEDControlData[ledIndex].State = LED_STATE_FLASH;
		LEDControlData[ledIndex].TimeRemain	= param1;
		
	}
	else if	(type == LED_TYPE_BLINK)
	{
		LEDControlData[ledIndex].State = LED_STATE_BLINK;
		LEDControlData[ledIndex].OnInterval	= param1;
		LEDControlData[ledIndex].OffInterval = param2;
		LEDControlData[ledIndex].TimeRemain	= param1;
	}
	else
	{
		LEDControlData[ledIndex].State = LED_STATE_ALWAYS_ON;
	}
	LEDControlData[ledIndex].OnOffState	= 1;
	PORT_ChangeOutPort(LEDControlData[ledIndex].OPIndex, 1);
	//PORT_ModifyOutPort(LEDControlData[ledIndex].OPIndex, 1);
	LEDControlData[ledIndex].EypeProtectionOffCount	= 0;
}
//---------------------------------------------------------------------------
void MC_LED_Off(int	ledIndex)
{
	LEDControlData[ledIndex].State = LED_STATE_OFF;
	LEDControlData[ledIndex].OnOffState	= 0;
	PORT_ModifyOutPort(LEDControlData[ledIndex].OPIndex, 0);
}
//---------------------------------------------------------------------------
void MC_LED_AllOn(int type,	int	param1,	int	param2)
{
	int	ledIndex;
	for	(ledIndex =	0; ledIndex	< MAX_LED_COUNT; ledIndex++)
	{
		if (type ==	1)
		{
			LEDControlData[ledIndex].State = LED_STATE_FLASH;
			LEDControlData[ledIndex].TimeRemain	= param1;
		}
		else if	(type == 2)
		{
			LEDControlData[ledIndex].State = LED_STATE_BLINK;
			LEDControlData[ledIndex].OnInterval	= param1;
			LEDControlData[ledIndex].OffInterval = param2;
			LEDControlData[ledIndex].TimeRemain	= param1;
		}
		else
		{
			LEDControlData[ledIndex].State = LED_STATE_ALWAYS_ON;
		}
		LEDControlData[ledIndex].OnOffState	= 1;
		PORT_ModifyOutPort(LEDControlData[ledIndex].OPIndex, 1);
	}
}
//---------------------------------------------------------------------------
void MC_LED_AllOff(void)
{
	int	ledIndex;
	for	(ledIndex =	0; ledIndex	< MAX_LED_COUNT; ledIndex++)
	{
		LEDControlData[ledIndex].State = LED_STATE_OFF;
		LEDControlData[ledIndex].OnOffState	= 0;
		PORT_ModifyOutPort(LEDControlData[ledIndex].OPIndex, 0);
	}
}
//---------------------------------------------------------------------------
void MC_LED_Process(void)
{
	int	ledIndex;

	for	(ledIndex =	0; ledIndex	< MAX_LED_COUNT; ledIndex++)
	{
		if (LEDControlData[ledIndex].State == LED_STATE_OFF)
		{
			if (LEDControlData[ledIndex].EyeProtectionEnabled)
			{
				LEDControlData[ledIndex].EypeProtectionOffCount++;
				if (LEDControlData[ledIndex].EypeProtectionOffCount	>= LEDControlSetupData.LEDOffDelay)
				{
					MC_LED_On(ledIndex,	LED_TYPE_FLASH,	LEDControlSetupData.LEDOnTime, 0);
					LEDControlData[ledIndex].EypeProtectionOffCount	= 0;
				}
			}
		}
		else if	(LEDControlData[ledIndex].State	== LED_STATE_FLASH)
		{
			LEDControlData[ledIndex].TimeRemain--;
			//LEDControlData[ledIndex].TimeRemain -= 20;
			if (LEDControlData[ledIndex].TimeRemain	<= 0)
			{
				LEDControlData[ledIndex].State = LED_STATE_OFF;
				LEDControlData[ledIndex].OnOffState	= 0;
				PORT_ChangeOutPort(LEDControlData[ledIndex].OPIndex, 0);
			}
		}
		else if	(LEDControlData[ledIndex].State	== LED_STATE_BLINK)
		{
			LEDControlData[ledIndex].TimeRemain--;
			//LEDControlData[ledIndex].TimeRemain -= 20;
			if (LEDControlData[ledIndex].TimeRemain	<= 0)
			{
				if (LEDControlData[ledIndex].OnOffState	== 0)
				{
					LEDControlData[ledIndex].OnOffState	= 1;
					LEDControlData[ledIndex].TimeRemain	= LEDControlData[ledIndex].OnInterval;
					PORT_ChangeOutPort(LEDControlData[ledIndex].OPIndex, 1);
				}
				else
				{
					LEDControlData[ledIndex].OnOffState	= 0;
					LEDControlData[ledIndex].TimeRemain	= LEDControlData[ledIndex].OffInterval;
					PORT_ChangeOutPort(LEDControlData[ledIndex].OPIndex, 0);
				}
			}
		}
	}
}

void MC_LASER_Trigger_On(int diskNum ,int interval)
{
	LaserTrigerControlData.LaserTrigerState[diskNum]= LASER_TRIG_STATE_ON;
	LaserTrigerControlData.LaserTrigerInterVal[diskNum] = interval;
}

void MC_LASER_Trigger_Process(void)
{

	//suction disk 1
	if(LaserTrigerControlData.LaserTrigerState[SUCTION_DISK_NUM1-1]== LASER_TRIG_STATE_ON)
	{
		PORT_ChangeOutPort(OP_SD1_LASER_PRINT_TRIG, 1);
		LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM1-1]--;
		if(LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM1-1] <= 0)
		{
			LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM1-1] = 0;
			LaserTrigerControlData.LaserTrigerState[SUCTION_DISK_NUM1-1] = LASER_TRIG_STATE_OFF;
		}
	}
	else
	{
		PORT_ChangeOutPort(OP_SD1_LASER_PRINT_TRIG, 0);
		LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM1-1] = 0;
	}

//		//suction disk 2
//		if(LaserTrigerControlData.LaserTrigerState[SUCTION_DISK_NUM2-1]== LASER_TRIG_STATE_ON)
//		{
//			LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM2-1]--;
//			if(LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM2-1] == 0)
//			{
//				PORT_ChangeOutPort(OP_SD2_LASER_PRINT_TRIG, 1);
//				LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM2-1] = 0;
//				LaserTrigerControlData.LaserTrigerState[SUCTION_DISK_NUM2-1] = LASER_TRIG_STATE_OFF;
//			}
//		}
//		else
//		{
//			PORT_ChangeOutPort(OP_SD2_LASER_PRINT_TRIG, 0);
//			LaserTrigerControlData.LaserTrigerInterVal[SUCTION_DISK_NUM2-1] = 0;
//		}
}
//---------------------------------------------------------------------------
void MC_EnableEyeProtection(void)
{
	int	ledIndex;
	for	(ledIndex =	0; ledIndex	< MAX_LED_COUNT; ledIndex++)
	{
		LEDControlData[ledIndex].EyeProtectionEnabled =	1;
	}
}
//---------------------------------------------------------------------------
void MC_DisableEyeProtection(void)
{
	int	ledIndex;
	for	(ledIndex =	0; ledIndex	< MAX_LED_COUNT; ledIndex++)
	{
		LEDControlData[ledIndex].EyeProtectionEnabled =	0;
	}
}
//---------------------------------------------------------------------------
void MC_LampControl_Init(void)
{
	int	lampIndex;
	for	(lampIndex = 0;	lampIndex <	MAX_LAMP_COUNT;	lampIndex++)
	{
		LampControlData.LampState[lampIndex] = LAMP_STATE_OFF;
		LampControlData.LampToggleCounter[lampIndex] = 0;
		LampControlData.LampBlinkInterval[lampIndex] = 0;
	}
	LampControlData.LampOP[0] =	OP_TOWER_LAMP_R_ON;
	LampControlData.LampOP[1] =	OP_TOWER_LAMP_Y_ON;
	LampControlData.LampOP[2] =	OP_TOWER_LAMP_G_ON;

}
//---------------------------------------------------------------------------
void MC_LampControl_On(int lampIndex)
{
	LampControlData.LampState[lampIndex] = LAMP_STATE_ON;
}
//---------------------------------------------------------------------------
void MC_LampControl_Off(int	lampIndex)
{
	LampControlData.LampState[lampIndex] = LAMP_STATE_OFF;
}
//---------------------------------------------------------------------------
void MC_LampControl_Blink(int lampIndex, int blinkInterval)
{
	LampControlData.LampState[lampIndex] = LAMP_STATE_BLINK;
	LampControlData.LampBlinkInterval[lampIndex] = blinkInterval;
}
//---------------------------------------------------------------------------
void MC_LampControl_Process(void)		// per 1ms
{
	int	lampIndex;
	for	(lampIndex = 0;	lampIndex <	MAX_LAMP_COUNT;	lampIndex++)
	{
		if (LampControlData.LampState[lampIndex] ==	LAMP_STATE_OFF)
		{
			PORT_ModifyOutPort(LampControlData.LampOP[lampIndex], 0);
			LampControlData.LampBlinkOn[lampIndex] = 0;
			LampControlData.LampToggleCounter[lampIndex] = 0;
		}
		else if	(LampControlData.LampState[lampIndex] == LAMP_STATE_ON)
		{
			PORT_ModifyOutPort(LampControlData.LampOP[lampIndex], 1);
			LampControlData.LampBlinkOn[lampIndex] = 1;
			LampControlData.LampToggleCounter[lampIndex] = 0;
		}
		else	// blink
		{
			if (LampControlData.LampToggleCounter[lampIndex])
			{
				LampControlData.LampToggleCounter[lampIndex]--;
			}
			else
			{
				if (LampControlData.LampBlinkOn[lampIndex])
				{
					LampControlData.LampBlinkOn[lampIndex] = 0;
					PORT_ModifyOutPort(LampControlData.LampOP[lampIndex], 0);
				}
				else
				{
					LampControlData.LampBlinkOn[lampIndex] = 1;
					PORT_ModifyOutPort(LampControlData.LampOP[lampIndex], 1);
				}
				LampControlData.LampToggleCounter[lampIndex] = LampControlData.LampBlinkInterval[lampIndex]	- 1;
			}
		}
	}
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_Init(void)
{
	BuzzerControlData.SilenceMode =	0;
	BuzzerControlData.AlarmOn =	0;
	BuzzerControlData.AlarmBuzzerOn	= 0;
	BuzzerControlData.NotifyBuzzerOn = 0;
	BuzzerControlData.SuspendBuzzerOn =	0;
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_InspectionStopAlarmOn(void)
{

	PORT_ModifyOutPort(OP_BUZZER_ON, 1);
	PORT_ModifyOutPort(OP_BUZZER_2_ON, 1);

}
//---------------------------------------------------------------------------
void MC_BuzzerControl_AlarmOn(void)
{
	if (BuzzerControlData.AlarmOn == 0)
	{
		if (!BuzzerControlData.SilenceMode)
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 1);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 1);
			BuzzerControlData.BuzzerOnStartTime	= Board1MSTmr;
			BuzzerControlData.AlarmBuzzerOn	= 1;
		}
		BuzzerControlData.AlarmOn =	1;
	}
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_AlarmOff(void)
{
	BuzzerControlData.AlarmOn =	0;
	BuzzerControlData.AlarmBuzzerOn	= 0;
	if (BuzzerControlData.NotifyBuzzerOn ==	0 &&
		BuzzerControlData.SuspendBuzzerOn == 0)
	{
		PORT_ModifyOutPort(OP_BUZZER_ON, 0);
		PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
	}
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_SuspendBuzzerOn(void)
{
	PORT_ModifyOutPort(OP_BUZZER_ON, 1);
	BuzzerControlData.BuzzerOnStartTime	= Board1MSTmr;
	BuzzerControlData.SuspendBuzzerOn =	1;
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_Stop(void)
{
	BuzzerControlData.AlarmBuzzerOn	= 0;
	BuzzerControlData.SuspendBuzzerOn =	0;
	if (BuzzerControlData.NotifyBuzzerOn ==	0)
	{
		PORT_ModifyOutPort(OP_BUZZER_ON, 0);
		PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
	}
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_NotifyBuzzerOn(int durationTime)
{
	BuzzerControlData.NotifyBuzzerDurationTime = durationTime;
	BuzzerControlData.NotifyBuzzerOn = 1;
	PORT_ModifyOutPort(OP_BUZZER_ON, 1);
}
//---------------------------------------------------------------------------
void MC_BuzzerControl_Process(void)
{
	if (BuzzerControlData.AlarmBuzzerOn)
	{
		if (!BuzzerControlData.BuzzerContinuousOn)
		{
			if (Board1MSTmr	- BuzzerControlData.BuzzerOnStartTime >	(int)BuzzerControlData.BuzzerOnTime	* 1000)
			{
				BuzzerControlData.AlarmBuzzerOn	= 0;
				if (BuzzerControlData.NotifyBuzzerOn ==	0)
				{
					PORT_ModifyOutPort(OP_BUZZER_ON, 0);
					PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
				}
			}
		}
	}
	else if	(BuzzerControlData.SuspendBuzzerOn)
	{
		if (!BuzzerControlData.BuzzerContinuousOn)
		{
			if (Board1MSTmr	- BuzzerControlData.BuzzerOnStartTime >	(int)BuzzerControlData.BuzzerOnTime	* 1000)
			{
				BuzzerControlData.SuspendBuzzerOn =	0;
				if (BuzzerControlData.NotifyBuzzerOn ==	0)
				{
					PORT_ModifyOutPort(OP_BUZZER_ON, 0);
					PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
				}
			}
		}
	}
	if (BuzzerControlData.NotifyBuzzerOn)
	{
		BuzzerControlData.NotifyBuzzerDurationTime--;
		if (BuzzerControlData.NotifyBuzzerDurationTime == 0)
		{
			BuzzerControlData.NotifyBuzzerOn = 0;
			if (BuzzerControlData.AlarmBuzzerOn	== 0)
			{
				PORT_ModifyOutPort(OP_BUZZER_ON, 0);
				PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
			}
		}
	}
}
//---------------------------------------------------------------------------
void MC_Ejector_Init(void)
{
	// init	ejector	queue
	EjectorControlData.DefectEjectorQueueStart  = EjectorControlData.DefectEjectorQueueEnd  = 0;
	EjectorControlData.UnInsEjectorQueueStart   = EjectorControlData.UnInsEjectorQueueEnd	= 0;
	EjectorControlData.UnInsEjectorAOQueueStart	= EjectorControlData.UnInsEjectorAOQueueEnd	= 0;
    EjectorControlData.GoodEjectorQueueStart    = EjectorControlData.GoodEjectorQueueEnd    = 0;

	EjectorControlData.DefectBlowerRemain =	0;
	EjectorControlData.UnInsBlowerRemain  = 0;
    EjectorControlData.GoodBlowerRemain   = 0;

	EjectorControlData.MisejectQueueStart   = EjectorControlData.MisejectQueueEnd = 0;
	EjectorControlData.MisejectActiveRemain	= 0;
	memset(DefectEjectorQueue, 0x00, sizeof(EjectorQueueData));
	memset(UnInsEjectorQueue, 0x00, sizeof(EjectorQueueData));
	memset(GoodEjectorQueue, 0x00, sizeof(EjectorQueueData));
	memset(MissEjectorQueue, 0x00, sizeof(EjectorQueueData));
}
//---------------------------------------------------------------------------
void MC_Ejector_Stop(void)
{
	EjectorControlData.DefectBlowerRemain =	0;
	EjectorControlData.UnInsBlowerRemain = 0;
	
	PORT_ModifyOutPort(OP_DEFECT_BLOWER, 0);
	PORT_ModifyOutPort(OP_UNINSPECTED_BLOWER, 0);
    PORT_ModifyOutPort(OP_GOOD_BLOWER, 0);

	EjectorControlData.MisejectActiveRemain	= 0;

	if(MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
		MisEjectStop();
	
}

void AddDefectEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber, int time)
{	
	int listCount, startIndex;
	int i;
	int tempEncoder, tempLangth, tempNumber;
	
	if ((DefectEjectorQueue.EjectorQueueEnd !=	DefectEjectorQueue.EjectorQueueStart) && (TabletNumber >= 0))
	{
		if((DefectEjectorQueue.EjectorNumberQueue[(DefectEjectorQueue.EjectorQueueEnd -1)& EJECTOR_QUEUE_MASK]) < TabletNumber)
		{
			DefectEjectorQueue.EjectorNumberQueue[DefectEjectorQueue.EjectorQueueEnd] = TabletNumber;
			DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueEnd] = EncoderValue;
			DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueEnd] = Length;		
			DefectEjectorQueue.SensorOnTime[DefectEjectorQueue.EjectorQueueEnd] = time;	
			test_count_eject[0]++;
		}
		else
		{
			test_count_eject[1]++;
			DefectEjectorQueue.EjectorNumberQueue[DefectEjectorQueue.EjectorQueueEnd] = TabletNumber;
			DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueEnd] = EncoderValue;
			DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueEnd] = Length;		
			DefectEjectorQueue.SensorOnTime[DefectEjectorQueue.EjectorQueueEnd] = time;	
			
			if(DefectEjectorQueue.EjectorQueueEnd - DefectEjectorQueue.EjectorQueueStart > 0 ) 
			{
				listCount = DefectEjectorQueue.EjectorQueueEnd - DefectEjectorQueue.EjectorQueueStart;
			}
			else
			{
				listCount = DefectEjectorQueue.EjectorQueueEnd - DefectEjectorQueue.EjectorQueueStart+EJECTOR_QUEUE_MASK;
			}
			startIndex = DefectEjectorQueue.EjectorQueueStart;

			for(i = 0 ; i < listCount; i++)
			{
				if(DefectEjectorQueue.EjectorNumberQueue[startIndex] > DefectEjectorQueue.EjectorNumberQueue[DefectEjectorQueue.EjectorQueueEnd])
				{
					tempNumber = DefectEjectorQueue.EjectorNumberQueue[startIndex];
					tempEncoder = DefectEjectorQueue.EjectorEncoderQueue[startIndex];
					tempLangth = DefectEjectorQueue.EjectorLengthQueue[startIndex];
					
					DefectEjectorQueue.EjectorNumberQueue[startIndex] = DefectEjectorQueue.EjectorNumberQueue[DefectEjectorQueue.EjectorQueueEnd];
					DefectEjectorQueue.EjectorEncoderQueue[startIndex] = DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueEnd];
					DefectEjectorQueue.EjectorLengthQueue[startIndex] =DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueEnd];
					
					DefectEjectorQueue.EjectorNumberQueue[DefectEjectorQueue.EjectorQueueEnd] = tempNumber;
					DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueEnd] = tempEncoder;
					DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueEnd] = tempLangth;
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
				else 
				{
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
			}
		}	
	}
	else
	{
		test_count_eject[2]++;
		DefectEjectorQueue.EjectorNumberQueue[DefectEjectorQueue.EjectorQueueEnd] = TabletNumber;
		DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueEnd] = EncoderValue;
		DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueEnd] = Length;
		DefectEjectorQueue.SensorOnTime[DefectEjectorQueue.EjectorQueueEnd] = time;	

	}
	DefectEjectorQueue.EjectorQueueEnd= (DefectEjectorQueue.EjectorQueueEnd + 1) & EJECTOR_QUEUE_MASK;
}
void AddUninsEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber)
{
	int listCount, startIndex;
	int i;
	int tempEncoder, tempLangth, tempNumber;
	if ((UnInsEjectorQueue.EjectorQueueEnd !=	UnInsEjectorQueue.EjectorQueueStart) && (TabletNumber >= 0))
	{
		if((UnInsEjectorQueue.EjectorNumberQueue[(UnInsEjectorQueue.EjectorQueueEnd -1)& EJECTOR_QUEUE_MASK]) < TabletNumber)
		{
			UnInsEjectorQueue.EjectorNumberQueue[UnInsEjectorQueue.EjectorQueueEnd] = TabletNumber;
			UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueEnd] = EncoderValue;
			UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueEnd] = Length;		
		}
		else
		{
			UnInsEjectorQueue.EjectorNumberQueue[UnInsEjectorQueue.EjectorQueueEnd] = TabletNumber;
			UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueEnd] = EncoderValue;
			UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueEnd] = Length;		
			
			if(UnInsEjectorQueue.EjectorQueueEnd > UnInsEjectorQueue.EjectorQueueStart  ) 
			{
				listCount = UnInsEjectorQueue.EjectorQueueEnd - UnInsEjectorQueue.EjectorQueueStart;
			}
			else
			{
				listCount = UnInsEjectorQueue.EjectorQueueEnd - UnInsEjectorQueue.EjectorQueueStart+EJECTOR_QUEUE_MASK;
			}
			startIndex = UnInsEjectorQueue.EjectorQueueStart;

			for(i = 0; i < listCount ; i++)
			{
				if(UnInsEjectorQueue.EjectorNumberQueue[startIndex] > UnInsEjectorQueue.EjectorNumberQueue[UnInsEjectorQueue.EjectorQueueEnd])
				{
					tempNumber = UnInsEjectorQueue.EjectorNumberQueue[startIndex];
					tempEncoder = UnInsEjectorQueue.EjectorEncoderQueue[startIndex];
					tempLangth = UnInsEjectorQueue.EjectorLengthQueue[startIndex];
					
					UnInsEjectorQueue.EjectorNumberQueue[startIndex] = UnInsEjectorQueue.EjectorNumberQueue[UnInsEjectorQueue.EjectorQueueEnd];
					UnInsEjectorQueue.EjectorEncoderQueue[startIndex] = UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueEnd];
					UnInsEjectorQueue.EjectorLengthQueue[startIndex] =UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueEnd];
					
					UnInsEjectorQueue.EjectorNumberQueue[UnInsEjectorQueue.EjectorQueueEnd] = tempNumber;
					UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueEnd] = tempEncoder;
					UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueEnd] = tempLangth;
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
				else 
				{
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
			}
		}	
	}
	else
	{
		UnInsEjectorQueue.EjectorNumberQueue[UnInsEjectorQueue.EjectorQueueEnd] = TabletNumber;
		UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueEnd] = EncoderValue;
		UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueEnd] = Length;
	}
	UnInsEjectorQueue.EjectorQueueEnd= (UnInsEjectorQueue.EjectorQueueEnd + 1) & EJECTOR_QUEUE_MASK;
}
void AddGoodEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber)
{
		int listCount, startIndex;
	int i;
	int tempEncoder, tempLangth, tempNumber;
	if ((GoodEjectorQueue.EjectorQueueEnd !=	GoodEjectorQueue.EjectorQueueStart) && (TabletNumber >= 0))
	{
		if((GoodEjectorQueue.EjectorNumberQueue[(GoodEjectorQueue.EjectorQueueEnd -1)& EJECTOR_QUEUE_MASK]) < TabletNumber)
		{
			GoodEjectorQueue.EjectorNumberQueue[GoodEjectorQueue.EjectorQueueEnd] = TabletNumber;
			GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueEnd] = EncoderValue;
			GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueEnd] = Length;		
		}
		else
		{
			GoodEjectorQueue.EjectorNumberQueue[GoodEjectorQueue.EjectorQueueEnd] = TabletNumber;
			GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueEnd] = EncoderValue;
			GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueEnd] = Length;		
			
			if(GoodEjectorQueue.EjectorQueueEnd > GoodEjectorQueue.EjectorQueueStart ) 
			{
				listCount = GoodEjectorQueue.EjectorQueueEnd - GoodEjectorQueue.EjectorQueueStart;
			}
			else
			{
				listCount = GoodEjectorQueue.EjectorQueueEnd - GoodEjectorQueue.EjectorQueueStart+EJECTOR_QUEUE_MASK;
			}
			startIndex = GoodEjectorQueue.EjectorQueueStart;

			for(i = 0 ; i < listCount ; i++)
			{
				if(GoodEjectorQueue.EjectorNumberQueue[startIndex] > GoodEjectorQueue.EjectorNumberQueue[GoodEjectorQueue.EjectorQueueEnd])
				{
					tempNumber = GoodEjectorQueue.EjectorNumberQueue[startIndex];
					tempEncoder = GoodEjectorQueue.EjectorEncoderQueue[startIndex];
					tempLangth = GoodEjectorQueue.EjectorLengthQueue[startIndex];
					
					GoodEjectorQueue.EjectorNumberQueue[startIndex] = GoodEjectorQueue.EjectorNumberQueue[GoodEjectorQueue.EjectorQueueEnd];
					GoodEjectorQueue.EjectorEncoderQueue[startIndex] = GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueEnd];
					GoodEjectorQueue.EjectorLengthQueue[startIndex] =GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueEnd];
					
					GoodEjectorQueue.EjectorNumberQueue[GoodEjectorQueue.EjectorQueueEnd] = tempNumber;
					GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueEnd] = tempEncoder;
					GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueEnd] = tempLangth;
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
				else 
				{
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
			}
		}	
	}
	else
	{
		GoodEjectorQueue.EjectorNumberQueue[GoodEjectorQueue.EjectorQueueEnd] = TabletNumber;
		GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueEnd] = EncoderValue;
		GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueEnd] = Length;

	}
	GoodEjectorQueue.EjectorQueueEnd= (GoodEjectorQueue.EjectorQueueEnd + 1) & EJECTOR_QUEUE_MASK;
}

void AddMissEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber)
{
	int listCount, startIndex;
	int i;
	int tempEncoder, tempLangth, tempNumber;
	if ((MissEjectorQueue.EjectorQueueEnd !=	MissEjectorQueue.EjectorQueueStart) && (TabletNumber >= 0))
	{
		if((MissEjectorQueue.EjectorNumberQueue[(MissEjectorQueue.EjectorQueueEnd -1)& EJECTOR_QUEUE_MASK]) < TabletNumber)
		{
			MissEjectorQueue.EjectorNumberQueue[MissEjectorQueue.EjectorQueueEnd] = TabletNumber;
			MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueEnd] = EncoderValue;
			MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueEnd] = Length;		
		}
		else
		{
			MissEjectorQueue.EjectorNumberQueue[MissEjectorQueue.EjectorQueueEnd] = TabletNumber;
			MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueEnd] = EncoderValue;
			MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueEnd] = Length;		
			
			if(MissEjectorQueue.EjectorQueueEnd > MissEjectorQueue.EjectorQueueStart ) 
			{
				listCount = MissEjectorQueue.EjectorQueueEnd - MissEjectorQueue.EjectorQueueStart;
			}
			else
			{
				listCount = MissEjectorQueue.EjectorQueueEnd - MissEjectorQueue.EjectorQueueStart+EJECTOR_QUEUE_MASK;
			}
			startIndex = MissEjectorQueue.EjectorQueueStart;

			for(i = 0 ; i < listCount ; i++)
			{
				if(MissEjectorQueue.EjectorNumberQueue[startIndex] > MissEjectorQueue.EjectorNumberQueue[MissEjectorQueue.EjectorQueueEnd])
				{
					tempNumber = MissEjectorQueue.EjectorNumberQueue[startIndex];
					tempEncoder = MissEjectorQueue.EjectorEncoderQueue[startIndex];
					tempLangth = MissEjectorQueue.EjectorLengthQueue[startIndex];
					
					MissEjectorQueue.EjectorNumberQueue[startIndex] = MissEjectorQueue.EjectorNumberQueue[MissEjectorQueue.EjectorQueueEnd];
					MissEjectorQueue.EjectorEncoderQueue[startIndex] = MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueEnd];
					MissEjectorQueue.EjectorLengthQueue[startIndex] =MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueEnd];
					
					MissEjectorQueue.EjectorNumberQueue[MissEjectorQueue.EjectorQueueEnd] = tempNumber;
					MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueEnd] = tempEncoder;
					MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueEnd] = tempLangth;
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
				else 
				{
					startIndex= (startIndex + 1) & EJECTOR_QUEUE_MASK;
				}
			}
		}	
	}
	else
	{
		MissEjectorQueue.EjectorNumberQueue[MissEjectorQueue.EjectorQueueEnd] = TabletNumber;
		MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueEnd] = EncoderValue;
		MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueEnd] = Length;

	}
	MissEjectorQueue.EjectorQueueEnd= (MissEjectorQueue.EjectorQueueEnd + 1) & EJECTOR_QUEUE_MASK;
}

//---------------------------------------------------------------------------
void AddMisejectActiveQueue(unsigned int ejectorTime, int ejectorLength)
{
	EjectorControlData.MisejectTimeQueue[EjectorControlData.MisejectQueueEnd] =	ejectorTime;
	EjectorControlData.MisejectDelayQueue[EjectorControlData.MisejectQueueEnd] = ejectorLength;
	EjectorControlData.MisejectQueueEnd	= (EjectorControlData.MisejectQueueEnd + 1)	& EJECTOR_QUEUE_MASK;
}
//---------------------------------------------------------------------------
void MisEjectActive(void)
{
	PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_ON,	 1);
	PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_OFF, 0);
	CurrentMisejectActive = 1;
	MisejectActionCheckTimer = 0;
}
//---------------------------------------------------------------------------
void MisEjectStop(void)
{
	PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_ON,	 0);
	PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_OFF, 1);
	CurrentMisejectActive = 0;
	MisejectActionCheckTimer = 0;
}
//---------------------------------------------------------------------------
void MisEjectDefActive(void)
{
	if(EjectorSetupData.Special_InspectionActive !=	1)
	{
		PORT_ChangeOutPort(OP_DEFECT_BLOWER, 1);// 
	}
}
//---------------------------------------------------------------------------
void MisEjectDefStop(void)
{
	PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);
}
//---------------------------------------------------------------------------
void MisEjectInsActive(void)
{
	PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER,1);
	PORT_ChangeOutPort(OP_DEFECT_BLOWER, 1);
}
//---------------------------------------------------------------------------
void MisEjectInsStop(void)
{
	PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER,0);
	PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);
}
//---------------------------------------------------------------------------
void MC_Ejector_Process_Encoder(void)		// per 50us
{
	CSL_IntcGlobalEnableState 	state;
	CSL_intcGlobalDisable(&state);
	if(DefectEjectorQueue.EjectorQueueStart != DefectEjectorQueue.EjectorQueueEnd)
	{
		if(Disk2Encoder_value_sum >= DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueStart])
		{
			if(Disk2Encoder_value_sum -DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueStart] >= DEFECT_EJECTOR_POSITION + TabletControlData.DefectEjectorEncoderDelay) 
			{
				EjectorEncoderControlData.DefectEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.DefectEjectorOnLenght= DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueStart];
				DefectEjectorQueue.BlowTime[DefectEjectorQueue.EjectorQueueStart] = board50usTmr - DefectEjectorQueue.SensorOnTime[DefectEjectorQueue.EjectorQueueStart];
				DefectEjectorQueue.BlowEncoder[DefectEjectorQueue.EjectorQueueStart] = Disk2Encoder_value_sum - DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueStart];
				DefectEjectorQueue.check[DefectEjectorQueue.EjectorQueueStart] = board50usTmr- last_encoder_time;
				DefectEjectorQueue.EjectorQueueStart = (DefectEjectorQueue.EjectorQueueStart + 1) &	EJECTOR_QUEUE_MASK;
			}
		}
		else
		{
			
			if((Disk2Encoder_value_sum+ENCODER_MASK) - DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueStart] >= DEFECT_EJECTOR_POSITION + TabletControlData.DefectEjectorEncoderDelay) 
			{
				
				EjectorEncoderControlData.DefectEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.DefectEjectorOnLenght= DefectEjectorQueue.EjectorLengthQueue[DefectEjectorQueue.EjectorQueueStart];
				DefectEjectorQueue.BlowTime[DefectEjectorQueue.EjectorQueueStart] = board50usTmr - DefectEjectorQueue.SensorOnTime[DefectEjectorQueue.EjectorQueueStart];
				DefectEjectorQueue.BlowEncoder[DefectEjectorQueue.EjectorQueueStart] = (Disk2Encoder_value_sum+ENCODER_MASK) - DefectEjectorQueue.EjectorEncoderQueue[DefectEjectorQueue.EjectorQueueStart];
				DefectEjectorQueue.check[DefectEjectorQueue.EjectorQueueStart] = board50usTmr- last_encoder_time;			
				DefectEjectorQueue.EjectorQueueStart = (DefectEjectorQueue.EjectorQueueStart + 1) &EJECTOR_QUEUE_MASK;
			}			
		}	
	}	
	if(UnInsEjectorQueue.EjectorQueueStart != UnInsEjectorQueue.EjectorQueueEnd)
	{
		if(Disk2Encoder_value_sum >= UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueStart])
		{
			if(Disk2Encoder_value_sum -UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueStart] >= UNINS_EJECTOR_POSITION + TabletControlData.UnInsEjectorEncoderDelay) 
			{
				EjectorEncoderControlData.UnInsEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.UnInsEjectorOnLenght= UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueStart];
				UnInsEjectorQueue.EjectorQueueStart = (UnInsEjectorQueue.EjectorQueueStart + 1) &EJECTOR_QUEUE_MASK;
			}
		}
		else
		{
			
			if((Disk2Encoder_value_sum+ENCODER_MASK) - UnInsEjectorQueue.EjectorEncoderQueue[UnInsEjectorQueue.EjectorQueueStart] >= UNINS_EJECTOR_POSITION + TabletControlData.UnInsEjectorEncoderDelay) 
			{
				EjectorEncoderControlData.UnInsEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.UnInsEjectorOnLenght= UnInsEjectorQueue.EjectorLengthQueue[UnInsEjectorQueue.EjectorQueueStart];
				UnInsEjectorQueue.EjectorQueueStart = (UnInsEjectorQueue.EjectorQueueStart + 1) &EJECTOR_QUEUE_MASK;
			}			
		}
				
	}	
	if(GoodEjectorQueue.EjectorQueueStart != GoodEjectorQueue.EjectorQueueEnd)
	{
		if(Disk2Encoder_value_sum >= GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueStart])
		{
			if(Disk2Encoder_value_sum -GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueStart] >= GOOD_EJECTOR_POSITION + TabletControlData.GoodEjectorEncoderDelay) 
			{
				EjectorEncoderControlData.GoodEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.GoodEjectorOnLenght= GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueStart];
				GoodEjectorQueue.EjectorQueueStart = (GoodEjectorQueue.EjectorQueueStart + 1)&EJECTOR_QUEUE_MASK;
			}
		}
		else
		{
			if((Disk2Encoder_value_sum+ENCODER_MASK) - GoodEjectorQueue.EjectorEncoderQueue[GoodEjectorQueue.EjectorQueueStart] >= GOOD_EJECTOR_POSITION + TabletControlData.GoodEjectorEncoderDelay) 
			{
				EjectorEncoderControlData.GoodEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.GoodEjectorOnLenght= GoodEjectorQueue.EjectorLengthQueue[GoodEjectorQueue.EjectorQueueStart];
				GoodEjectorQueue.EjectorQueueStart = (GoodEjectorQueue.EjectorQueueStart + 1)&EJECTOR_QUEUE_MASK;
			}			
		}
				
	}	
	/*
	if(MissEjectorQueue.EjectorQueueStart != MissEjectorQueue.EjectorQueueEnd)
	{
		if(Disk2Encoder_value_sum >= MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueStart])
		{
			if(Disk2Encoder_value_sum -MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueStart] >= TabletControlData.MisejectEncoderDelay) 
			{
				EjectorEncoderControlData.MissEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.MissEjectorOnLenght= MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueStart];
				MissEjectorQueue.EjectorQueueStart = (MissEjectorQueue.EjectorQueueStart + 1)&EJECTOR_QUEUE_MASK;
			}
		}
		else
		{
			if((Disk2Encoder_value_sum+ENCODER_MASK) - MissEjectorQueue.EjectorEncoderQueue[MissEjectorQueue.EjectorQueueStart] >= TabletControlData.MisejectEncoderDelay) 
			{
				EjectorEncoderControlData.MissEjectorOnEncoder = Disk2Encoder_value_sum;
				EjectorEncoderControlData.MissEjectorOnLenght= MissEjectorQueue.EjectorLengthQueue[MissEjectorQueue.EjectorQueueStart];
				MissEjectorQueue.EjectorQueueStart = (MissEjectorQueue.EjectorQueueStart + 1)&EJECTOR_QUEUE_MASK;
			}			
		}
				
	}	
      */
	if(EjectorEncoderControlData.DefectEjectorOnEncoder > 0)
	{
		if(Disk2Encoder_value_sum >= EjectorEncoderControlData.DefectEjectorOnEncoder)
		{
			if(Disk2Encoder_value_sum -EjectorEncoderControlData.DefectEjectorOnEncoder < EjectorEncoderControlData.DefectEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_DEFECT_BLOWER, 1);
				
			}
			else
			{
				PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);
				EjectorEncoderControlData.DefectEjectorOnEncoder = -1;
				
			}
		}
		else
		{
			if((Disk2Encoder_value_sum+ENCODER_MASK) -EjectorEncoderControlData.DefectEjectorOnEncoder < EjectorEncoderControlData.DefectEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_DEFECT_BLOWER, 1);
				
			}
			else
			{
				PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);
				EjectorEncoderControlData.DefectEjectorOnEncoder = -1;
			}			
		}
	}
	if(EjectorEncoderControlData.UnInsEjectorOnEncoder > 0)
	{
		if(Disk2Encoder_value_sum >= EjectorEncoderControlData.UnInsEjectorOnEncoder)
		{
			if(Disk2Encoder_value_sum -EjectorEncoderControlData.UnInsEjectorOnEncoder < EjectorEncoderControlData.UnInsEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 1);
			}
			else
			{
				PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 0);
				EjectorEncoderControlData.UnInsEjectorOnEncoder = -1;
			}
		}
		else
		{
			if((Disk2Encoder_value_sum+ENCODER_MASK) -EjectorEncoderControlData.UnInsEjectorOnEncoder < EjectorEncoderControlData.UnInsEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 1);
			}
			else
			{
				PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 0);
				EjectorEncoderControlData.UnInsEjectorOnEncoder = -1;
			}			
		}
	}
	if(EjectorEncoderControlData.GoodEjectorOnEncoder > 0)
	{
		if(Disk2Encoder_value_sum >= EjectorEncoderControlData.GoodEjectorOnEncoder)
		{
			if(Disk2Encoder_value_sum -EjectorEncoderControlData.GoodEjectorOnEncoder < EjectorEncoderControlData.GoodEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_GOOD_BLOWER, 1);
			}
			else
			{
				PORT_ChangeOutPort(OP_GOOD_BLOWER, 0);
				EjectorEncoderControlData.GoodEjectorOnEncoder = -1;
			}
		}
		else
		{
			if((Disk2Encoder_value_sum+ENCODER_MASK) -EjectorEncoderControlData.GoodEjectorOnEncoder < EjectorEncoderControlData.GoodEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_GOOD_BLOWER, 1);
			}
			else
			{
				PORT_ChangeOutPort(OP_GOOD_BLOWER, 0);
				EjectorEncoderControlData.GoodEjectorOnEncoder = -1;
			}			
		}
	}	
/*	
	if(EjectorEncoderControlData.MissEjectorOnEncoder > 0)
	{
		if(Disk2Encoder_value_sum >= EjectorEncoderControlData.MissEjectorOnEncoder)
		{
			if(Disk2Encoder_value_sum -EjectorEncoderControlData.MissEjectorOnEncoder <= EjectorEncoderControlData.MissEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_ON, 1);
			}
			else
			{
				PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_ON, 0);
				EjectorEncoderControlData.MissEjectorOnEncoder = -1;
			}
		}
		else
		{
			if((Disk2Encoder_value_sum+ENCODER_MASK) -EjectorEncoderControlData.MissEjectorOnEncoder <= EjectorEncoderControlData.MissEjectorOnLenght)
			{
				PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_ON,1);
			}
			else
			{
				PORT_ChangeOutPort(OP_MISEJECT_ACTUATOR_ON,0);
				EjectorEncoderControlData.MissEjectorOnEncoder = -1;
			}			
		}
	}
*/	
	last_encoder_time = board50usTmr;
	CSL_intcGlobalEnable(&state);
}

//---------------------------------------------------------------------------
void MC_ToggleControl_Init(void)
{
	ToggleControlData.PCSwitchDelay	= 0;
	ToggleControlData.PCSwitchState	= 0;
}
//---------------------------------------------------------------------------
void MC_ToggleControl_Process(void)
{
	if (ToggleControlData.PCSwitchState	!= 0 &&	ToggleControlData.PCSwitchDelay	!= 0)
	{
		ToggleControlData.PCSwitchDelay--;
		if (ToggleControlData.PCSwitchDelay	== 0)
		{
			PORT_ModifyOutPort(OP_PC_POWER_SW, 0);
			ToggleControlData.PCSwitchState	= 0;
		}
	}
}
//---------------------------------------------------------------------------
void MC_PC_Switch_Activate(void)
{
	PORT_ModifyOutPort(OP_PC_POWER_SW, 1);
	ToggleControlData.PCSwitchState	= 1;
	ToggleControlData.PCSwitchDelay	= 500;
}
//---------------------------------------------------------------------------
void MC_PC_Switch_Forced_Off(void)
{
	PORT_ModifyOutPort(OP_PC_POWER_SW, 1);
	ToggleControlData.PCSwitchState	= 1;
	ToggleControlData.PCSwitchDelay	= 500;
}
//---------------------------------------------------------------------------
void MC_SwitchControl_Init(void)
{
	MonitorSwitchControlData.DownState = 0;
	MonitorSwitchControlData.LightOn = 1;
}
//---------------------------------------------------------------------------
void MC_RoomLight_On(void)
{
	MC_RoomLightControl_On();
	MonitorSwitchControlData.LightOn = 0;
}
//---------------------------------------------------------------------------
void MC_RoomLight_Off(void)
{
	MC_RoomLightControl_Off();
	MonitorSwitchControlData.LightOn = 1;
}
//---------------------------------------------------------------------------
void MC_SwitchControl_Process(void)
{
	if (PORT_ReadInPort(IP_MONITOR_SWITCH_ON))
	{
		if (MonitorSwitchControlData.DownState == 0)
		{
			MonitorSwitchControlData.DownState = 1;
			MonitorSwitchControlData.DownStartTime = Board1MSTmr;
		}
		else if	(MonitorSwitchControlData.DownState	== 1)
		{
			if (Board1MSTmr	- MonitorSwitchControlData.DownStartTime > 3000)
			{
				if (MachineAlarmState.AlarmExist)
				{
					if (BuzzerControlData.SilenceMode == 0)
					{
						BuzzerControlData.SilenceMode =	1;
						PORT_ModifyOutPort(OP_BUZZER_ON, 0);
						PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
					}
					else
					{
						BuzzerControlData.SilenceMode =	0;
					}
					MonitorSwitchControlData.DownState = 2;
				}
				else if	(BuzzerControlData.SilenceMode == 1)
				{
					BuzzerControlData.SilenceMode =	0;
					MonitorSwitchControlData.DownState = 2;
				}
			}
		}
	}
	else
	{
		if (MonitorSwitchControlData.DownState == 1)
		{
			if (MonitorSwitchControlData.LightOn)
			{
				MonitorSwitchControlData.LightOn = 0;
				MC_RoomLightControl_On();
			}
			else
			{
				MonitorSwitchControlData.LightOn = 1;
				MC_RoomLightControl_Off();
			}
			MonitorSwitchControlData.DownState = 0;
		}
		else
		{
			MonitorSwitchControlData.DownState = 0;
		}
	}
}
//---------------------------------------------------------------------------
void MC_Emergency_MachineStop(void)
{
	MC_Vibrator_Off();
	Servo_Motor_Stop_Param(0, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(1, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(2, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(3, SERVO_MOTOR_EMERGENCY_STOP_TIME);
}

//---------------------------------------------------------------------------
// L3 Operations
//---------------------------------------------------------------------------
void MC_CleaningStart(void)
{
	// nc control cleaning
	MC_NC_CleaningMoveBegin();

	// etc control
	//PORT_ModifyOutPort(OP_MAGNET_ON, 0);
	PORT_ModifyOutPort(OP_AIR_BRUSH_1_ACTUATOR,	0);
	PORT_ModifyOutPort(OP_AIR_BRUSH_2_ACTUATOR,	0);
}
//---------------------------------------------------------------------------
void MC_ReadyStart(void)
{
	// nc control ready
	MC_NC_ReadyMoveBegin();

	// etc control
	PORT_ModifyOutPort(OP_AIR_BRUSH_1_ACTUATOR,	1);
	PORT_ModifyOutPort(OP_AIR_BRUSH_2_ACTUATOR,	1);


	if(MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
		MisEjectStop();
	
}
//---------------------------------------------------------------------------
void MC_MainControl_Init(void)
{
	int	stepMotorIndex;

	MainControlData.State =	MAIN_CONTROL_STATE_CLEANING;
	MainControlData.Mode = MAIN_CONTROL_MODE_NONE;
	MainControlData.PosState = MAIN_CONTROL_POS_STATE_NONE;

#ifdef SELMA
	//sjm
	MainControlData.applyEjectorDelay 	= 0;
	MainControlData.adjustUnInsDelay 	= 0;
	MainControlData.adjustDefectDelay 	= 0;
	MainControlData.adjustEjectorWindStrength =	0;
#endif

	for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
	{
		MainControlData.NCPos[stepMotorIndex] =	0;
	}
	
	EjectorEncoderControlData.DefectEjectorOnEncoder = -1;
	EjectorEncoderControlData.UnInsEjectorOnEncoder = -1;
	EjectorEncoderControlData.GoodEjectorOnEncoder = -1;
	EjectorEncoderControlData.MissEjectorOnEncoder = -1;
	memset(test_count_eject,0,sizeof(test_count_eject));
		
}
//---------------------------------------------------------------------------
void MC_MainControl_Run(void)
{
	MachineStopSensorState.BFSensor1OffCount = 0;
	MachineStopSensorState.BFSensor2OffCount = 0;
	MachineStopSensorState.BFSensor3OffCount = 0;
		
	if (MainControlData.State != MAIN_CONTROL_STATE_EMERGENCY_STOP)
	{
		if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
		{
			if (!MachineAlarmState.AlarmExist)
			{						
				if(MachineSetupData.Qualis_Machine1_CutomOption == 1)
				{
					if(!(InterlockData.DoorInterlockEnabled &&	InterlockData.DoorOpen))
						MainControlData.Func = MAIN_CONTROL_FUNC_RUN;
				}
				else
				{
					if(!(InterlockData.DoorOpen))
						MainControlData.Func = MAIN_CONTROL_FUNC_RUN;
				}
			}
		}
		else if(MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
		{
			if (!MachineAlarmState.AlarmExist &&!(InterlockData.DoorInterlockEnabled &&	InterlockData.DoorOpen))
			{
				PORT_ModifyOutPort(OP_INTERLOCK_SOLENOID, 1);
						
				MainControlData.Func = MAIN_CONTROL_FUNC_RUN;
			}
		}
	}
}
//---------------------------------------------------------------------------
void MC_MainControl_Stop(void)
{
	if (MainControlData.State != MAIN_CONTROL_STATE_EMERGENCY_STOP)
	{
		if(MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
				PORT_ModifyOutPort(OP_INTERLOCK_SOLENOID, 0);

		MainControlData.Func = MAIN_CONTROL_FUNC_STOP;

		EjectorTestData.Enabled	= 0;	
	}
}
//---------------------------------------------------------------------------
void MC_MainControl_WaitStop(int Type)
{
	switch(Type)
	{
		case PROCEDURE_MODE_WAITSTOP1 :
		case PROCEDURE_MODE_WAITSTOP2 :
			WaitStop_State = Type;
			MC_MainControl_Stop();
			break;
		case PROCEDURE_MODE_WAITSTOP_RESUME:
			WaitStop_State = 0;
			MC_MainControl_Run();		
			break;
	}
}
//---------------------------------------------------------------------------
void MC_MainControl_Ready(int *ncPos)
{
	int	stepMotorIndex;
	if (MainControlData.State != MAIN_CONTROL_STATE_EMERGENCY_STOP)
	{
		for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
		{
			MainControlData.NCPos[stepMotorIndex] =	ncPos[stepMotorIndex];
		}
		MainControlData.Func = MAIN_CONTROL_FUNC_READY;
	}
}
//---------------------------------------------------------------------------
void MC_MainControl_Cleaning(void)
{
	if (MainControlData.State != MAIN_CONTROL_STATE_EMERGENCY_STOP)
	{
		MainControlData.Func = MAIN_CONTROL_FUNC_CLEANING;
	}
}
//---------------------------------------------------------------------------
void MC_MainControl_EmergencyStop(void)
{
	MainControlData.PrevState =	MainControlData.State;
	MainControlData.State =	MAIN_CONTROL_STATE_EMERGENCY_STOP;
	MainControlData.PosState = MAIN_CONTROL_POS_STATE_NONE;
	MainControlData.Func = MAIN_CONTROL_FUNC_EMERGENCY_STOP;
}
//---------------------------------------------------------------------------
void MC_MainControl_EmergencyReset(void)
{
	MainControlData.State =	MAIN_CONTROL_STATE_STOP;
	MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
}
//---------------------------------------------------------------------------
void MC_Main_Control_Process(void)
{
	if (MainControlData.Func ==	MAIN_CONTROL_FUNC_RUN)
	{
		if (MainControlData.State == MAIN_CONTROL_STATE_STOP ||
			MainControlData.State == MAIN_CONTROL_STATE_CLEANING)
		{
			if (MainControlData.PosState ==	MAIN_CONTROL_POS_STATE_READY)
			{
				MC_DustBlower_On();
				MC_DustBlowerSol_On();
#ifdef SELMA
				//Pressure Regulator set for Ejector : cik add
				MC_Pressure_Regulator_Set(MainControlData.adjustEjectorWindStrength);
#endif
				if (MainControlData.Mode ==	MAIN_CONTROL_MODE_INSPECTION)
				{
					MainControlData.EjectorWarmUpStartTime = Board1MSTmr;
					PORT_ChangeOutPort(OP_DEFECT_BLOWER, 1);
					PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 1);					
					MainControlData.SubState = 0;                  
				}
				else
				{
					MainControlData.SubState = 1;
				}
				MC_SuctionDisk_Run(MainControlData.MotorSpeed[0], MainControlData.MotorSpeed[1],MainControlData.SuctionDisk1InverterSpeed, MainControlData.SuctionDisk2InverterSpeed);
				MainControlData.State =	MAIN_CONTROL_STATE_STARTING;
				MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
			}
			else
			{
				MainControlData.State =	MAIN_CONTROL_STATE_ATTACHING;
				MC_ReadyStart();
			}
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_RUN)
		{
			// TO DO: implement	re-run
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_ATTACHING)
		{
			if (MainControlData.PosState ==	MAIN_CONTROL_POS_STATE_READY)
			{
				MC_DustBlower_On();
				MC_DustBlowerSol_On();
#ifdef SELMA				
				//Pressure Regulator set for Ejector : cik add
				MC_Pressure_Regulator_Set(MainControlData.adjustEjectorWindStrength);
#endif				
				if (MainControlData.Mode ==	MAIN_CONTROL_MODE_INSPECTION)
				{
					MainControlData.EjectorWarmUpStartTime = Board1MSTmr;					
					PORT_ChangeOutPort(OP_DEFECT_BLOWER, 1); 

                    if(EjectorSetupData.Special_InspectionActive ==	0)
    				{
    					PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 1);

                    }
					MainControlData.SubState = 0;
				}
				else
				{
					MainControlData.SubState = 1;
				}
				MC_SuctionDisk_Run(MainControlData.MotorSpeed[0], MainControlData.MotorSpeed[1],MainControlData.SuctionDisk1InverterSpeed, MainControlData.SuctionDisk2InverterSpeed);
				MainControlData.State =	MAIN_CONTROL_STATE_STARTING;
				MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
			}
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_DETACHING)
		{
			MainControlData.State =	MAIN_CONTROL_STATE_ATTACHING;
			MC_ReadyStart();
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_STARTING || MainControlData.State == MAIN_CONTROL_STATE_STOPPING)
		{
			//wait until run or	stop
		}
		else
		{
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		WaitStop_State = 0;
	}
	else if	(MainControlData.Func == MAIN_CONTROL_FUNC_STOP)
	{
		if (MainControlData.State == MAIN_CONTROL_STATE_RUN)
		{
			MC_Vibrator_Off();
			MC_BowlFeeder_Stop();
			MainControlData.SubState = 0;
			MainControlData.State =	MAIN_CONTROL_STATE_STOPPING;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_STARTING)
		{
			// forced stop
			MC_Vibrator_Off();
			MC_BowlFeeder_Stop();
			if (MainControlData.SubState ==	0)
			{
				if (MainControlData.Mode ==	MAIN_CONTROL_MODE_INSPECTION)
				{
					PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);
					PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 0);
                    PORT_ChangeOutPort(OP_GOOD_BLOWER, 0);

				}
			}
			MainControlData.SubState = 0;
			MainControlData.State =	MAIN_CONTROL_STATE_STOPPING;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_ATTACHING)
		{
			MC_DustBlower_Off();
			MC_DustBlowerSol_Off();
			MainControlData.State =	MAIN_CONTROL_STATE_STOP;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else
		{
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
	}
	else if	(MainControlData.Func == MAIN_CONTROL_FUNC_READY)
	{
		if (MainControlData.State == MAIN_CONTROL_STATE_STOP ||
			MainControlData.State == MAIN_CONTROL_STATE_CLEANING ||
			MainControlData.State == MAIN_CONTROL_STATE_DETACHING)
		{
			MC_ReadyStart();
			MainControlData.PosState = MAIN_CONTROL_POS_STATE_NONE;
			MainControlData.State =	MAIN_CONTROL_STATE_ATTACHING;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else
		{
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
	}
	else if	(MainControlData.Func == MAIN_CONTROL_FUNC_CLEANING)
	{
		if (MainControlData.State == MAIN_CONTROL_STATE_STOP ||
			MainControlData.State == MAIN_CONTROL_STATE_ATTACHING ||
			MainControlData.State == MAIN_CONTROL_STATE_CLEANING)
		{
			MC_CleaningStart();
			MainControlData.PosState = MAIN_CONTROL_POS_STATE_NONE;
			MainControlData.State =	MAIN_CONTROL_STATE_DETACHING;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_RUN ||
			MainControlData.State == MAIN_CONTROL_STATE_STARTING ||
			MainControlData.State == MAIN_CONTROL_STATE_STOPPING)
		{
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
		else
		{
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
	}
	else if	(MainControlData.Func == MAIN_CONTROL_FUNC_EMERGENCY_STOP)
	{
		MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
	}


	if (MainControlData.State == MAIN_CONTROL_STATE_ATTACHING)
	{
		if (NCControlInfo.PosState == NC_CONTROL_POS_STATE_READY)
		{
			MainControlData.PosState = MAIN_CONTROL_POS_STATE_READY;
			MainControlData.State =	MAIN_CONTROL_STATE_STOP;
		}
		else if	(NCControlInfo.State ==	NC_CONTROL_STATE_ERROR)
		{
			MainControlData.PosState = MAIN_CONTROL_POS_STATE_NONE;
			MainControlData.State =	MAIN_CONTROL_STATE_STOP;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
	}
	else if	(MainControlData.State == MAIN_CONTROL_STATE_DETACHING)
	{
		if (NCControlInfo.PosState == NC_CONTROL_POS_STATE_CLEANING)
		{
			MainControlData.PosState = MAIN_CONTROL_POS_STATE_CLEANING;
			MainControlData.State =	MAIN_CONTROL_STATE_CLEANING;
		}
		else if	(NCControlInfo.State ==	NC_CONTROL_STATE_ERROR)
		{
			MainControlData.PosState = MAIN_CONTROL_POS_STATE_NONE;
			MainControlData.State =	MAIN_CONTROL_STATE_CLEANING;
			MainControlData.Func = MAIN_CONTROL_FUNC_NONE;
		}
	}
	else if	(MainControlData.State == MAIN_CONTROL_STATE_STARTING)
	{
		if (MainControlData.SubState ==	0)
		{
			if ((int) (Board1MSTmr - MainControlData.EjectorWarmUpStartTime) > EJECTOR_WARM_UP_TIME)
			{
				PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);
				PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 0);
               		PORT_ChangeOutPort(OP_GOOD_BLOWER, 0);
				MainControlData.SubState = 1;
			}
		}
		else if	(MainControlData.SubState == 1)
		{
			if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				if (SuctionDiskProcedureData.State == SD_STATE_RUN && (int)(Board1MSTmr	- (SuctionDiskProcedureData.StableCheckStartTime+ MachineSetupData.DiskStartDelay*1000)) > 0)
				{
					MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
					SuctionDiskProcedureData.StableCheckStartTime = 0;
					MainControlData.SubState = 2;
				}
			}
			else
			{
				if (SuctionDiskProcedureData.State == SD_STATE_RUN && (int)(Board1MSTmr	- SuctionDiskProcedureData.StableCheckStartTime) > 0)
				{
					MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
					SuctionDiskProcedureData.StableCheckStartTime = 0;
					MainControlData.SubState = 2;
				}
			}
		}
		else if	(MainControlData.SubState == 2)
		{
			if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_RUN)
			{
				MC_Vibrator_Auto();
				MainControlData.State =	MAIN_CONTROL_STATE_RUN;
			}
		}
	}
	else if	(MainControlData.State == MAIN_CONTROL_STATE_STOPPING)
	{
		if (MainControlData.SubState ==	0)
		{
			if (BowlFeederProcedureData.State == BOWL_FEEDER_STATE_STOP)
			{
				if (SuctionDiskProcedureData.State == SD_STATE_RUN)
				{
					TabletTransferWaitingTime =	2000 * OperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX] /	ServoMotorBaseSpeed[SD2_MOTOR_INDEX];
					MainControlData.SubState = 1;
				}
				else
				{
					MC_SuctionDisk_Stop();
					MainControlData.SubState = 2;
				}
			}
		}
		else if	(MainControlData.SubState == 1)
		{
			TabletTransferWaitingTime--;
			if (TabletTransferWaitingTime <= 0)
			{
				MC_SuctionDisk_Stop();
				MainControlData.SubState = 2;
			}
		}
		else if	(MainControlData.SubState == 2)
		{
			if (SuctionDiskProcedureData.State == SD_STATE_STOP)
			{
				MC_DustBlower_Off();
				MC_DustBlowerSol_Off();
				MainControlData.State =	MAIN_CONTROL_STATE_STOP;
			}
		}
	}
}
//---------------------------------------------------------------------------
void MC_DustBlowerSol_Init(void)
{
	// init	dust blower	sol	control	data
	DustBlowerSolControlData.Enabled = 0;
}
//---------------------------------------------------------------------------
void MC_DustBlowerSol_On(void)
{

	CSL_intcInterruptDisable(CSL_INTC_VECTID_5);		// disable timer interrupt
	DustBlowerSolControlData.Interval[0] = UserMachineEnv.DustBlower1Interval;
	DustBlowerSolControlData.Interval[1] = UserMachineEnv.DustBlower2Interval;
	DustBlowerSolControlData.Interval[2] = UserMachineEnv.DustBlower3Interval;
	DustBlowerSolControlData.Interval[3] = UserMachineEnv.DustBlower4Interval;
	DustBlowerSolControlData.Interval[4] = UserMachineEnv.DustBlower5Interval;
	DustBlowerSolControlData.RunTime[0]	= UserMachineEnv.DustBlower1BlowTime;
	DustBlowerSolControlData.RunTime[1]	= UserMachineEnv.DustBlower2BlowTime;
	DustBlowerSolControlData.RunTime[2]	= UserMachineEnv.DustBlower3BlowTime;
	DustBlowerSolControlData.RunTime[3]	= UserMachineEnv.DustBlower4BlowTime;
	DustBlowerSolControlData.RunTime[4]	= UserMachineEnv.DustBlower5BlowTime;
	DustBlowerSolControlData.IntervalRemain[0] = UserMachineEnv.DustBlower1Delay;
	DustBlowerSolControlData.IntervalRemain[1] = UserMachineEnv.DustBlower2Delay;
	DustBlowerSolControlData.IntervalRemain[2] = UserMachineEnv.DustBlower3Delay;
	DustBlowerSolControlData.IntervalRemain[3] = UserMachineEnv.DustBlower4Delay;
	DustBlowerSolControlData.IntervalRemain[4] = UserMachineEnv.DustBlower5Delay;
	DustBlowerSolControlData.RunRemain[0] =	0;
	DustBlowerSolControlData.RunRemain[1] =	0;
	DustBlowerSolControlData.RunRemain[2] =	0;
	DustBlowerSolControlData.RunRemain[3] =	0;
	DustBlowerSolControlData.RunRemain[4] =	0;
	DustBlowerSolControlData.Port[0] = OP_DUST_BLOWER_1;
	DustBlowerSolControlData.Port[1] = OP_DUST_BLOWER_2;
	DustBlowerSolControlData.Port[2] = OP_DUST_BLOWER_3;
	DustBlowerSolControlData.Port[3] = OP_DUST_BLOWER_4;
	DustBlowerSolControlData.Port[4] = OP_AIR_BRUSH;
	PORT_ModifyOutPort(OP_DUST_BLOWER_1, 0);
	PORT_ModifyOutPort(OP_DUST_BLOWER_2, 0);
	PORT_ModifyOutPort(OP_DUST_BLOWER_3, 0);
	PORT_ModifyOutPort(OP_DUST_BLOWER_4, 0);
	PORT_ModifyOutPort(OP_AIR_BRUSH, 0);
	DustBlowerSolControlData.Enabled = UserMachineEnv.Enabled;
	PORT_ModifyOutPort(OP_BF_SENSOR_DUST_BLOWER, 1);
	CSL_intcInterruptEnable(CSL_INTC_VECTID_5);
}
//---------------------------------------------------------------------------
void MC_DustBlowerSol_Off(void)
{
	//unsigned int ie;
	CSL_intcInterruptDisable(CSL_INTC_VECTID_5);		// disable timer interrupt
	PORT_ModifyOutPort(OP_DUST_BLOWER_1, 0);
	PORT_ModifyOutPort(OP_DUST_BLOWER_2, 0);
	PORT_ModifyOutPort(OP_DUST_BLOWER_3, 0);
	PORT_ModifyOutPort(OP_DUST_BLOWER_4, 0);
	PORT_ModifyOutPort(OP_AIR_BRUSH, 0);
	DustBlowerSolControlData.Enabled = 0;

	PORT_ModifyOutPort(OP_BF_SENSOR_DUST_BLOWER, 0);
	CSL_intcInterruptEnable(CSL_INTC_VECTID_5);
}
//---------------------------------------------------------------------------
void MC_DustBlowerSol_Process(void)
{
	int	blowerIndex;
	if (DustBlowerSolControlData.Enabled)
	{
		for	(blowerIndex = 0; blowerIndex <	DUST_BLOW_SOL_COUNT; blowerIndex++)
		{
			if (DustBlowerSolControlData.IntervalRemain[blowerIndex] ==	0)
			{
				if (DustBlowerSolControlData.RunTime[blowerIndex] >	0)
				{
					DustBlowerSolControlData.IntervalRemain[blowerIndex] = DustBlowerSolControlData.Interval[blowerIndex];
					DustBlowerSolControlData.RunRemain[blowerIndex]	= DustBlowerSolControlData.RunTime[blowerIndex];
					PORT_ModifyOutPort(DustBlowerSolControlData.Port[blowerIndex], 1);
				}
			}
			else
			{
				DustBlowerSolControlData.IntervalRemain[blowerIndex]--;
			}

			if (DustBlowerSolControlData.RunRemain[blowerIndex]	== 0)
			{
				PORT_ModifyOutPort(DustBlowerSolControlData.Port[blowerIndex], 0);
			}
			else
			{
				DustBlowerSolControlData.RunRemain[blowerIndex]--;
			}
		}
	}
}
//---------------------------------------------------------------------------
void MC_PowerControl_Init(void)
{
	PowerControlData.State = MAIN_POWER_STATE_ON;
	PowerControlData.PCState = PC_POWER_STATE_NONE;
	PowerControlData.PowerSWState =	OFF;
	PowerControlData.PowerSWOffCount = 0;
	PowerControlData.PCOnSwitchTime	= 0;
	PowerControlData.PCOffSwitchTime = 0;
	PowerControlData.PCOffStartTime	= 0;
}
//---------------------------------------------------------------------------
void MC_PowerControl_Off(void)
{
	if (PowerControlData.State != MAIN_POWER_STATE_BEING_OFF &&	PowerControlData.State != MAIN_POWER_STATE_OFF_ALARM)
	{
		if(MainControlData.State == MAIN_CONTROL_STATE_STOP || SuctionDiskProcedureData.State == SD_STATE_STOP)
		{
			if (PowerControlData.PC_Power_Mode == PC_POWER_MODE_AUTO)
			{
				if (!PORT_ReadInPort(IP_PC_ON))			// check pc	power
				{
					PowerControlData.PCState = PC_POWER_STATE_OFF;
				}
				else
				{
					if (PowerControlData.PCState ==	PC_POWER_STATE_NONE	||
						PowerControlData.PCState ==	PC_POWER_STATE_ON ||
						PowerControlData.PCState ==	PC_POWER_STATE_BEING_ON)
					{
						PowerControlData.PCOffSwitchTime = Board1MSTmr;
						PowerControlData.PCOffStartTime	= Board1MSTmr;
						PowerControlData.PCState = PC_POWER_STATE_BEING_OFF;
						MC_PC_Switch_Activate();
					}
				}
			}
			MC_CleaningStart();
			PowerControlData.State = MAIN_POWER_STATE_BEING_OFF;
		}
		if (MainControlData.State == MAIN_CONTROL_STATE_RUN	&& MainControlData.Mode	== MAIN_CONTROL_MODE_INSPECTION)	// abnormal	termination	detected
		{
			AbnormalTerminationDetected	= 1;
		}
		MC_MainControl_Stop();
		PORT_ModifyOutPort(OP_LASER_SHUTTER, 0);
		if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
		{
			MisEjectActive();
		}

		PowerControlData.PowerOffStartTime = Board1MSTmr;
	}
}
//---------------------------------------------------------------------------
void MC_PowerControl_On(void)
{
	if (PowerControlData.PC_Power_Mode == PC_POWER_MODE_AUTO)
	{
		if (PORT_ReadInPort(IP_PC_ON))			// check pc	power
		{
			PowerControlData.PCState = PC_POWER_STATE_ON;
		}
		else
		{
			if (PowerControlData.PCState ==	PC_POWER_STATE_NONE	||
				PowerControlData.PCState ==	PC_POWER_STATE_OFF ||
				PowerControlData.PCState ==	PC_POWER_STATE_BEING_OFF)
			{
				PowerControlData.PCOnSwitchTime	= Board1MSTmr;
				PowerControlData.PCState = PC_POWER_STATE_BEING_ON;
				MC_PC_Switch_Activate();
			}
		}
	}
	PowerControlData.State = MAIN_POWER_STATE_ON;
}
//---------------------------------------------------------------------------
void MC_PowerControl_PC_Off(void)
{
	if (!PORT_ReadInPort(IP_PC_ON))			// check pc	power
	{
		PowerControlData.PCState = PC_POWER_STATE_OFF;
	}
	else
	{
		if (PowerControlData.PCState ==	PC_POWER_STATE_NONE	||
			PowerControlData.PCState ==	PC_POWER_STATE_ON ||
			PowerControlData.PCState ==	PC_POWER_STATE_BEING_ON)
		{
			PowerControlData.PCOffSwitchTime = Board1MSTmr;
			PowerControlData.PCOffStartTime	= Board1MSTmr;
			PowerControlData.PCState = PC_POWER_STATE_BEING_OFF;
			MC_PC_Switch_Activate();
		}
	}
}
//---------------------------------------------------------------------------
void MC_PowerControl_Process_100ms(void)
{
	unsigned int elapsedTime;
	int	portIndex;

	if (PORT_ReadInPort(IP_POWER_ON))
	{
		if(!UnmanedOperationControlData.PowerOff)
		{
//			MachineStatus.OperationState = MACHINE_STATE_INIT;
			PowerControlData.PowerSWOffCount = 0;
			if (PowerControlData.PowerSWState == OFF)
			{
				MC_PowerControl_On();
				PowerControlData.PowerSWState =	ON;
			}
		}
		
	}
	else
	{
		if (PowerControlData.PowerSWState == ON)
		{
			if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable == 1)
			{			
				MachineStatus.OperationState = MACHINE_STATE_TERMINATE;
			}
			PowerControlData.PowerSWOffCount++;
			if (PowerControlData.PowerSWOffCount > POWER_OFF_SW_VALID_TIME)
			{
  				MachineStatus.MachineOff = 1;			
				MC_PowerControl_Off();
				PowerControlData.PowerSWState =	OFF;
			}
		}
	}
	

	if (PORT_ReadInPort(IP_PC_ON))
	{
		if(!UnmanedOperationControlData.PowerOff)
		{
			PowerControlData.PowerSWState = ON;
			if (PowerControlData.PCState ==	PC_POWER_STATE_BEING_ON)
			{
				PowerControlData.PCState = PC_POWER_STATE_ON;
			}
		}
	}
	else
	{
		PowerControlData.PowerSWState = OFF;
		if (PowerControlData.PCState ==	PC_POWER_STATE_BEING_OFF)
		{
			PowerControlData.PCState = PC_POWER_STATE_OFF;
		}
	}

	if (PowerControlData.State == MAIN_POWER_STATE_BEING_OFF)
	{
		if (MainControlData.State == MAIN_CONTROL_STATE_STOP &&	NCControlInfo.HomeDetected)
		{
			MC_MainControl_Cleaning();
		}
		else if	(MainControlData.State == MAIN_CONTROL_STATE_STOP ||
			MainControlData.State == MAIN_CONTROL_STATE_CLEANING ||
			MainControlData.State == MAIN_CONTROL_STATE_EMERGENCY_STOP ||
			(Board1MSTmr - PowerControlData.PowerOffStartTime >	MACHINE_STOP_WAITING_LIMIT))
		{
//			if (PowerControlData.PC_Power_Mode != PC_POWER_MODE_AUTO ||
//				(PowerControlData.PC_Power_Mode	== PC_POWER_MODE_AUTO && PowerControlData.PCState == PC_POWER_STATE_OFF))		// can shut	down
			if (!PORT_ReadInPort(IP_PC_ON))
			{
				if (AbnormalTerminationDetected)
				{
					SaveTerminationInfo();
					TerminationInfoSaveWaitingTime = 10;
					AbnormalTerminationDetected	= 0;
				}
				else
				{
					TerminationInfoSaveWaitingTime = 0;
				}
				if (TerminationInfoSaveWaitingTime)
				{
					TerminationInfoSaveWaitingTime--;
				}
				else
				{
					MachineControlMode = MACHINE_MODE_FREE;	// temp
					PowerControlData.PowerOffAlarmStartTime	= Board1MSTmr;
					PowerControlData.State = MAIN_POWER_STATE_OFF_ALARM;
					MC_BuzzerControl_NotifyBuzzerOn(1000);
				}
			}
		}
	}
	else if	(PowerControlData.State	== MAIN_POWER_STATE_OFF_ALARM)
	{
		elapsedTime	= Board1MSTmr -	PowerControlData.PowerOffAlarmStartTime;
#ifdef SELMA		
		//System Shut Down
		PORT_PLC_OFF();		//SELMA100
		Sleep(3000);		//SELMA100
		for	(portIndex = 0;	portIndex <	MAX_PORT_COUNT;	portIndex++) //SELMA100
		{
			PORT_ModifyOutPort(portIndex, 0);
		}
  		/* ================== */
#endif  		
		if (elapsedTime	> 1000)
		{
			MC_Power_SwitchOff();
			PowerControlData.State = MAIN_POWER_STATE_OFF;
			UnmanedOperationControlData.PowerOff = 0;
		}
	}

	if (PowerControlData.PCState ==	PC_POWER_STATE_BEING_ON	&&
		(Board1MSTmr - PowerControlData.PCOnSwitchTime > PC_ON_CHECKING_LIMIT))
	{
		PowerControlData.PCOnSwitchTime	= Board1MSTmr;
		MC_PC_Switch_Activate();
	}
	if (PowerControlData.PCState ==	PC_POWER_STATE_BEING_OFF &&
		(Board1MSTmr - PowerControlData.PCOffSwitchTime	> PC_OFF_CHECKING_LIMIT))
	{
		PowerControlData.PCOffSwitchTime = Board1MSTmr;
		MC_PC_Switch_Activate();
	}
	if (PowerControlData.PCState ==	PC_POWER_STATE_BEING_OFF &&
		(Board1MSTmr - PowerControlData.PCOffStartTime > PC_OFF_CHECKING_TIMEOUT))
	{
		MC_PC_Switch_Forced_Off();
	}

}
//---------------------------------------------------------------------------
void MC_EjectorTest_Init(void)
{
	EjectorTestData.Enabled = 0;
}
//---------------------------------------------------------------------------
void MC_Ejector_Test_Run(int ejectorIndex, unsigned	int	ejectorMask, int ejectorMaskCount)
{
	int	queueIndex;
	EjectorTestData.Mode = ejectorIndex; 
	EjectorTestData.Mask = ejectorMask;
	EjectorTestData.MaskCount	= ejectorMaskCount;
	EjectorTestData.SensorState =	0;
	EjectorTestData.CurrentMaskIndex = 0;
	EjectorTestData.CurrentSenorQueueIndex = MAX_EJECTOR_QUEUE_COUNT;
	EjectorTestData.Enabled =	1;
	EjectorTestData.testCount = 0;

	PrevQueueStart = 0;
}
//---------------------------------------------------------------------------
void MC_Ejector_Test_Stop(int ejectorIndex)
{
	EjectorTestData.Enabled =	0;
	EjectorTestData.Mode = ejectorIndex;

	if (ejectorIndex == 0)
	{
		PORT_ChangeOutPort(OP_DEFECT_BLOWER, 0);

	}
	else if	(ejectorIndex == 1)
	{
		PORT_ChangeOutPort(OP_UNINSPECTED_BLOWER, 0);

	}
    else if	(ejectorIndex == 2)
	{
		PORT_ChangeOutPort(OP_GOOD_BLOWER, 0);
	}    
	EjectorTestData.testCount =0;
}
//---------------------------------------------------------------------------
void MC_Ejector_Test_Process(void)
{
	int  SensorPortState = 0;
	int	ejectorIndex;
	unsigned int ejectorOnTime;
	int	BlowDelayLengthTime;
	int EjectorCaseSelect = 0; 
	
	int	pollingTableIndex, captureIndex;
	THCBDisk2TabletUnit	*disk2TabletUnit;

#ifdef SELMA
	BlowDelayLengthTime			= 0;
#else
	BlowDelayLengthTime			= 80;
#endif
	
	if(TabletControlData.Func == TABLET_CONTROL_FUNC_EJECTOR_TEST)
	{	
		if (EjectorTestData.Enabled)//TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderLength
		{				
			pollingTableIndex = TabletInfo.PollingResultTabletIndex;
			disk2TabletUnit	= &(TabletInfo.Disk2TabletList[pollingTableIndex]);						

			if(PrevQueueStart != TabletSensorQueue[1].Start)
			{
				if (EjectorTestData.Mask & (0x00000001 <<	EjectorTestData.CurrentMaskIndex))
				{					
					if (EjectorTestData.Mode == 0)
					{
						DefaultDefectEjectorConfig(TabletInfo.PollingResultTabletIndex);
					}
					else if(EjectorTestData.Mode ==	 1)
					{
						DefaultUnInsEjectorConfig(TabletInfo.PollingResultTabletIndex);
					}
					else if(EjectorTestData.Mode ==	 2)
					{
						AddGoodEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+
						(EJECT_ENCODER_LENGTH*EjectorSetupData.GoodEjectorLength), disk2TabletUnit->TabletNumber);
					}
				}

				EjectorTestData.CurrentMaskIndex++;
		
				if (EjectorTestData.CurrentMaskIndex >= EjectorTestData.MaskCount)
				{
					EjectorTestData.CurrentMaskIndex = 0;
				}

				TabletInfo.PollingResultTabletIndex++;

				PrevQueueStart++;
					
			}		
		}
	}
}
//---------------------------------------------------------------------------
#ifdef SELMA
//cik add
void MC_Pressure_Regulator_Set(int strength)
{
	unsigned short nVal;

	nVal = strength;

	PORT_ModifyAOValue(PRESSURE_REGULATOR_AO_INDEX,	nVal);
}
#endif
//---------------------------------------------------------------------------
void MC_Miseject_Test_Init(void)
{
	MisejectTestData.Enabled = 0;
}
//---------------------------------------------------------------------------
void MC_Miseject_Test_Run(int activeDelay, int durationTime)
{
	MisejectTestData.SensorState = 0;
	MisejectTestData.ActiveDelay = activeDelay;
//	MisejectTestData.ActiveQueueStart =	MisejectTestData.ActiveQueueEnd	= 0;
	MisejectTestData.DurationTime =	durationTime;
	MisejectTestData.Enabled = 1;
	MisejectTestData.Timer1ms = Board1MSTmr;
}
//---------------------------------------------------------------------------
void MC_Miseject_Test_Stop(void)
{
	MisejectTestData.Enabled = 0;

	MisEjectStop();
}
//---------------------------------------------------------------------------
void MC_Miseject_Process_1ms(void)
{
	if((MainControlData.State == MAIN_CONTROL_STATE_RUN	&& MainControlData.Mode	== MAIN_CONTROL_MODE_INSPECTION))
	{
		if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1 && MachineSetupData.Qualis_Machine1_CutomOption == 0)
		{
			if(MisejectActionCheckTimer  >= 1000) // History : 1000 X  if(MisejectActionCheckTimer  >= 1500)
			{
				// 0 : close , 1: open
				if(CurrentMisejectActive == 0) 
				{	
					if(!PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_A) && !PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_B) ) // Jam
					{
						InspectionAlarmState.AlarmExist = 1;
						InspectionAlarmState.MisEjectCheck = 1;
					}
					if(!PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_A) && PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_B))
					{
						InspectionAlarmState.AlarmExist = 1;
						InspectionAlarmState.MisEjectCheck = 1;
					}
				}
				else if(CurrentMisejectActive  == 1)
				{
					if(!PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_A) && !PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_B) ) // Jam
					{
						InspectionAlarmState.AlarmExist = 1;
						InspectionAlarmState.MisEjectCheck = 1;
					}
					if(PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_A) && !PORT_ReadInPort(IP_MISEJECT_CHECK_SENEOR_B))
					{
						InspectionAlarmState.AlarmExist = 1;
						InspectionAlarmState.MisEjectCheck = 1;
					}
				}
				MisejectActionCheckTimer++;
			}
		}	
	}
	else
	{
		MisejectActionCheckTimer = 0;
	}

	if (MachineSetupData.EjectorInfo.TPB_MisejectOperationMode == TPB_MISEJECT_NORMAL_MODE)	
	{
		if(MachineSetupData.EjectorInfo.TPB_MisejectActive == 1)
		{
			TPB_Miseject_Process();	
		}
	}
	else
	{
		if(TabletControlData.Func != TABLET_CONTROL_FUNC_INSPECTION)
		{
			if(MachineSetupData.EjectorInfo.TPB_MisejectActive == 1)
			{
				TPB_Miseject_Process();	
			}
		}
	}

}
//---------------------------------------------------------------------------
void TPB_Miseject_Process(void)
{	

	if ((THREED_CAMERA_SENSOR&0x4))
	{	
		TPB_MisejectProcess.detectedActiveCmd = 1;
	}
	else
	{
		TPB_MisejectProcess.detectedActiveCmd = 0;
	}
		
	if(TPB_MisejectProcess.detectedActiveCmd == 1)
	{
		TPB_MisejectProcess.validCnt++;

		if(TPB_MisejectProcess.validCnt >= MachineSetupData.EjectorInfo.TPB_MisCmdValidCnt)
		{
			if(TPB_MisejectProcess.openFlag == 0)
			{
				if(TPB_MisejectProcess.saveOpenTimeFlag == 0)
				{
					TPB_MisejectProcess.OpenDelayTime = Board1MSTmr;
					TPB_MisejectProcess.saveOpenTimeFlag = 1;
				}
							
				if((Board1MSTmr - TPB_MisejectProcess.OpenDelayTime) > MachineSetupData.EjectorInfo.TPB_MisejectOpenDelay)
				{
					MisEjectActive();
					TPB_MisejectProcess.openFlag = 1;
					TPB_MisejectProcess.OpenTime = Board1MSTmr;
				}
			}		
			else
			{
					TPB_MisejectProcess.OpenTime = Board1MSTmr;
			}
		}
	}
	else
	{
	//close time check and close miseject
		if(TPB_MisejectProcess.openFlag == 1)
		{		
			if((Board1MSTmr - TPB_MisejectProcess.OpenTime) > MachineSetupData.EjectorInfo.TPB_MisejectOpenRunTime)
			{
				MisEjectStop();
				TPB_MisejectProcess.openFlag = 0;
				TPB_MisejectProcess.validCnt = 0;
				TPB_MisejectProcess.saveOpenTimeFlag = 0;
				TPB_MisejectProcess.detectedActiveCmd = 0;
			}
		}
	}
}
//---------------------------------------------------------------------------
void MC_Blackout_Init(void)
{
	BlackoutInfo.BlackoutOccured = 0;
	MachineStatus.BlackOut = 0;
}
//---------------------------------------------------------------------------
void MC_Blackout_Process(void)
{
	int	portIndex;

	if (BlackoutInfo.BlackoutOccured)
	{
		if (BlackoutInfo.BlackoutStep == 0)
		{
			MC_RoomLightControl_Off();
			if (MainControlData.State == MAIN_CONTROL_STATE_RUN)
			{
				BlackoutInfo.TabletPassWaitingTime = 3000 *	OperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX] / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];	//    
			}
			else
			{
				BlackoutInfo.TabletPassWaitingTime = 5000;
			}
			BlackoutInfo.BlackoutStep =	1;
		}
		else if	(BlackoutInfo.BlackoutStep == 1)
		{
			if (BlackoutInfo.TabletPassWaitingTime <= 0)
			{
				//MC_MainControl_EmergencyStop();
				//TabletControl_EmergencyStop();
				MC_MainControl_EmergencyStop();
				MC_BowlFeeder_EmergencyStop();
				MC_SuctionDisk_EmergencyStop();
				MC_Vibrator_EmergencyStop();
				MC_StepMotor_EmergencyStop();
				MC_NC_Control_EmergencyStop();
				MC_DustBlower_Off();
				MC_DustBlowerSol_Off();
				BlackoutInfo.BlackoutStep =	2;
				BlackoutInfo.MachineStopDelay =	SERVO_MOTOR_EMERGENCY_STOP_TIME;
			}
			else
			{
				BlackoutInfo.TabletPassWaitingTime--;
			}
		}
		else if	(BlackoutInfo.BlackoutStep == 2)
		{
			if (BlackoutInfo.MachineStopDelay)
			{
				BlackoutInfo.MachineStopDelay--;
			}
			else
			{
				// off all sols
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
#ifdef SELMA				
				PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 0);	//Air Knife	3
#endif				
				PORT_ModifyOutPort(OP_SD1_AIR, 0);
				PORT_ModifyOutPort(OP_SD2_AIR, 0);
				PORT_ModifyOutPort(OP_DEFECT_BLOWER, 0);
				PORT_ModifyOutPort(OP_UNINSPECTED_BLOWER, 0);
                PORT_ModifyOutPort(OP_GOOD_BLOWER, 0);

				//    ǰ  ´.
				if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					MisEjectActive();
				}

				SaveTerminationInfo();
				BlackoutInfo.PCWaitingDelay	= 80000 ;	// sec  5000 ̾ PC α׸  ؼ ð ϰ ʿ
				BlackoutInfo.BlackoutStep =	3;
			}
		}
		else if	(BlackoutInfo.BlackoutStep == 3)
		{
			if (BlackoutInfo.PCWaitingDelay)
			{
				BlackoutInfo.PCWaitingDelay--;
			}
			else
			{
				if (PORT_ReadInPort(IP_PC_ON))
				{
					MC_PowerControl_PC_Off();
					//PowerControlData.State = MAIN_POWER_STATE_BEING_OFF;
					BlackoutInfo.BlackoutStep =	4;
				}
				else
				{
					BlackoutInfo.BlackoutStep =	5;
				}
			}
		}
		else if	(BlackoutInfo.BlackoutStep == 4)
		{
			if (PowerControlData.PCState ==	PC_POWER_STATE_OFF)
			{
				BlackoutInfo.BlackoutStep =	5;
			}
		}
		else if	(BlackoutInfo.BlackoutStep == 5)
		{
#ifdef SELMA		    
			//System Shut Down
			PORT_PLC_OFF();		//SELMA100
			Sleep(2000);		//SELMA100
			for	(portIndex = 0;	portIndex <	MAX_PORT_COUNT;	portIndex++) //SELMA100
			{
				PORT_ModifyOutPort(portIndex, 0);
			}
	  		/* ========================== */
#endif
			MC_Power_SwitchOff();
			BlackoutInfo.BlackoutStep =	6;
		}
	}//	2016.10.30 輺 䱸 Blackout  	.
	else if	(((int)(Board1MSTmr - BlackoutInfo.MasterLastComTime) > MIN_BLACKOUT_CHECK_TIME) && (BlackoutInfo.MasterLastComTime > (int)(EXPECTED_COM_START_TIME+1000)))		// check Blackout
	{
		BlackoutInfo.BlackoutStep =	0;
		//2016.12.23  For  Test
		BlackoutInfo.BlackoutOccured = 1;
		MachineStatus.BlackOut = 1;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	DoorLock ư Check
	 ° Start  Run  ƴҶ ư ۵
	 3    Ǵ 
	  ʾ  ޼ 
	// 2018-06-05 Q û ޹ Ͷ   
*/
void MC_DoorLockControl_Process_100ms(void)
{
	//if ((MainControlData.State == MAIN_CONTROL_STATE_NONE || MainControlData.State == MAIN_CONTROL_STATE_STOP) && WaitStop_State == 0)
	//{
			if(PORT_ReadInPort(IP_INTERLOCK_SWITCH_ON_OFF_EVENT))
			{
				DoorInterlockPushTime++;
			}

			if (DoorInterlockPushTime > 10)
			{
					if(!DoorInterlock)
					{
						PORT_ModifyOutPort(OP_UNLOCK_SWITCH_LAMP_ON, 0);
						PORT_ModifyOutPort(OP_INTERLOCK_SOLENOID, 1);	
						DoorInterlock = 1;
					}
					else
					{
						PORT_ModifyOutPort(OP_UNLOCK_SWITCH_LAMP_ON, 1);
						PORT_ModifyOutPort(OP_INTERLOCK_SOLENOID, 0);
						DoorInterlock = 0;
					}
				DoorInterlockPushTime = 0;
		}
	//}			
}
//---------------------------------------------------------------------------
// command decoder
//---------------------------------------------------------------------------
void MC_BowlFeederControl(TMachineControlData_BowlFeeder *bfData)
{
	if (bfData->Action == 0)
	{
		MC_BowlFeeder_Stop();
	}
	else if	(bfData->Action	== 1)
	{
		MC_BowlFeeder_Run(bfData->InnerDiskSpeed, bfData->OuterDisk1Speed, bfData->OuterDisk2Speed ,bfData->AirKnifeSpeed);
	}
	else if	(bfData->Action	== 2)
	{
		MC_BowlFeeder_AKControl(bfData->AirKnifeSpeed);
	}
	else if	(bfData->Action	== 3)
	{
		MC_BowlFeeder_Reset();
	}
}
//---------------------------------------------------------------------------
void MC_RingBlowerControl(unsigned char	rbIndex, char action, unsigned char	speed1,	unsigned char speed2)
{
	if (rbIndex	== RING_BLOWER_1)
	{
		if (action == RING_BLOWER_OFF)
		{
			MC_RingBlower_Off(RING_BLOWER_1);
		}
		else if	(action	== RING_BLOWER_ON)
		{
			MC_RingBlower_On(RING_BLOWER_1, speed1);
		}
	}
	else if	(rbIndex ==	RING_BLOWER_2)
	{
		if (action == RING_BLOWER_OFF)
		{
			MC_RingBlower_Off(RING_BLOWER_2);
		}
		else if	(action	== RING_BLOWER_ON)
		{
			MC_RingBlower_On(RING_BLOWER_2, speed2);
		}
	}
	else if	(rbIndex ==	RING_BLOWER_3)
	{
		if (action == RING_BLOWER_OFF)
		{
			MC_RingBlower_Off(RING_BLOWER_3);
		}
		else if	(action	== RING_BLOWER_ON)
		{
			MC_RingBlower_On(RING_BLOWER_3, 0);
		}
	}
	else if	(rbIndex ==	RING_BLOWER_ALL)
	{
		if (action == RING_BLOWER_OFF)
		{
			MC_RingBlower_Off(RING_BLOWER_1);
			MC_RingBlower_Off(RING_BLOWER_2);
			MC_RingBlower_Off(RING_BLOWER_3);
		}
		else if	(action	== RING_BLOWER_ON)
		{
			MC_RingBlower_On(RING_BLOWER_1,	speed1);
			MC_RingBlower_On(RING_BLOWER_2,	speed2);
			MC_RingBlower_On(RING_BLOWER_3,	0);
		}
	}

	if(MachineSetupData.AutoDemper == AUTO_DEMPER_ON)
	{
		if((rbIndex == RING_BLOWER_1) || (rbIndex == RING_BLOWER_2))
		{
			if(action == RING_BLOWER_ON)	RingBlowerStatus[rbIndex] = RING_BLOWER_ON;
			else													RingBlowerStatus[rbIndex] = RING_BLOWER_OFF;
		}

		if((RingBlowerStatus[RING_BLOWER_1] == RING_BLOWER_ON) || (RingBlowerStatus[RING_BLOWER_2] == RING_BLOWER_ON))
		{
			MC_RingBlower_On(RING_BLOWER_3, 0);
		}

		if((RingBlowerStatus[RING_BLOWER_1] == RING_BLOWER_OFF) && (RingBlowerStatus[RING_BLOWER_2] == RING_BLOWER_OFF))
		{
			MC_RingBlower_Off(RING_BLOWER_3);
		}	
	}	
}
//---------------------------------------------------------------------------
void MC_ServoMotorControl(TMachineControlData_ServoMotor *servoMotorData)
{
	if (servoMotorData->Action == 0)
	{
		Servo_Motor_Stop_Param(servoMotorData->MotorIndex, servoMotorData->DecTime);
	}
	else if	(servoMotorData->Action	== 1)
	{
		//OperationInfo.ServoMotorSpeed[servoMotorData->MotorIndex]	= servoMotorData->TargetSpeed;
		Servo_Motor_Run_Param(servoMotorData->MotorIndex, servoMotorData->AccTime, servoMotorData->Dir,	servoMotorData->TargetSpeed);
	}
	else if	(servoMotorData->Action	== 2)
	{
		Servo_Motor_ServoOn(servoMotorData->MotorIndex);
	}
	else if	(servoMotorData->Action	== 3)
	{
		Servo_Motor_ServoOff(servoMotorData->MotorIndex);
	}
}
//---------------------------------------------------------------------------
void MC_StepMotorControl(TMachineControlData_StepMotor *stepMotorData)
{
	if (stepMotorData->Action == 1)
	{
		Step_Motor_Run(stepMotorData->MotorIndex, stepMotorData->Dir, stepMotorData->PulseCount);
	}
	else if	(stepMotorData->Action == 2)
	{
		Step_Motor_HomeSearch(stepMotorData->MotorIndex);
	}
	else if	(stepMotorData->Action == 3)
	{
		Step_Motor_MovePos(stepMotorData->MotorIndex, stepMotorData->TargetEncoderPosition);
	}
}
//---------------------------------------------------------------------------
void MC_VibratorControl(TMachineControlData_VibrationFeeder	*vibratorData)
{
	if (vibratorData->Action ==	0)
	{
		MC_Vibrator_Off();
	}
	else if	(vibratorData->Action == 1)
	{
		MC_Vibrator_On(vibratorData->Speed);
	}
	else if	(vibratorData->Action == 2)
	{
		VFControlInfo.MaxSpeedTrainingMode = vibratorData->TrainingMode;
		VFControlInfo.ManualMaxSpeed = vibratorData->Speed;
		VFControlInfo.ManualModeSensorIndex	= vibratorData->ManualModeSensorIndex;
		VFControlInfo.ManualModeSensorActiveRatio =	vibratorData->ManualModeSensorActiveRatio;
		VFControlInfo.ManualLimitSpeed = vibratorData->LimitSpeed;
		VFControlInfo.ManualModeLimitSensorIndex = vibratorData->ManualModeLimitSensorIndex;
		VFControlInfo.ManualModeLimitSensorActiveRatio = vibratorData->ManualModeLimitSensorActiveRatio;
		VFControlInfo.Sensor1Ratio = vibratorData->Sensor1Ratio;
		VFControlInfo.Sensor2Ratio = vibratorData->Sensor2Ratio;
		VFControlInfo.StartSpeed =	vibratorData->StartSpeed;
		MC_Vibrator_Auto();
	}
	else if	(vibratorData->Action == 3)
	{
		MC_Vibrator_ManualSpeedChange(vibratorData->Speed,vibratorData->LimitSpeed);
	}
	else if	(vibratorData->Action == 4)	// general mode	speed change
	{
		MC_Vibrator_ControlChange(vibratorData->TrainingMode,
								  vibratorData->Speed, vibratorData->ManualModeSensorIndex,	vibratorData->ManualModeSensorActiveRatio,
								  vibratorData->LimitSpeed,	vibratorData->ManualModeLimitSensorIndex, vibratorData->ManualModeLimitSensorActiveRatio,
								  vibratorData->Sensor1Ratio, vibratorData->Sensor2Ratio, vibratorData->StartSpeed);
	}
	else if	(vibratorData->Action == 5)
	{
		Park_Sensor1RatioChange(vibratorData->Sensor1Ratio,	vibratorData->DisplayMode);
	}
	else if	(vibratorData->Action == 6)
	{
		Park_Sensor2RatioChange(vibratorData->Sensor2Ratio);
	}
}
//---------------------------------------------------------------------------
void SungChulControl(TMachineControlData_SungChulData *SungChulData)
{
		Park_StartSpeedModeChange(SungChulData->StartSpeedMode);
}

//---------------------------------------------------------------------------
void MC_GeneralControl(int action, int *value)
{
	if (action == 0)
	{
		MC_Emergency_MachineStop();
	}
	else if	(action	== 2)	// solenoid	valve control
	{
		if (value[0] ==	0)
		{
			PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 1);
		}
		else if	(value[0] == 1)
		{
			PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
		}
		else if	(value[0] == 2)
		{
			PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 1);
		}
		else if	(value[0] == 3)
		{
			PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
		}
		else if	(value[0] == 4)
		{
			PORT_ModifyOutPort(OP_SD1_AIR, 1);
		}
		else if	(value[0] == 5)
		{
			PORT_ModifyOutPort(OP_SD1_AIR, 0);
		}
		else if	(value[0] == 6)
		{
			PORT_ModifyOutPort(OP_SD2_AIR, 1);
		}
		else if	(value[0] == 7)
		{
			PORT_ModifyOutPort(OP_SD2_AIR, 0);
		}
		else if	(value[0] == 8)
		{
			PORT_ModifyOutPort(OP_DEFECT_BLOWER, 1);
		}
		else if	(value[0] == 9)
		{
			PORT_ModifyOutPort(OP_DEFECT_BLOWER, 0);
		}
		else if	(value[0] == 10)
		{
			PORT_ModifyOutPort(OP_UNINSPECTED_BLOWER, 1);
		}
		else if	(value[0] == 11)
		{
			PORT_ModifyOutPort(OP_UNINSPECTED_BLOWER, 0);
		}
		else if	(value[0] == 12)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_1, 1);
		}
		else if	(value[0] == 13)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_1, 0);
		}
		else if	(value[0] == 14)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_2, 1);
		}
		else if	(value[0] == 15)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_2, 0);
		}
		else if	(value[0] == 16)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_3, 1);
		}
		else if	(value[0] == 17)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_3, 0);
		}
		else if	(value[0] == 18)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_4, 1);
		}
		else if	(value[0] == 19)
		{
			PORT_ModifyOutPort(OP_DUST_BLOWER_4, 0);
		}
		else if	(value[0] == 20)
		{
			PORT_ModifyOutPort(OP_BF_SENSOR_DUST_BLOWER, 1);
		}
		else if	(value[0] == 21)
		{
			PORT_ModifyOutPort(OP_BF_SENSOR_DUST_BLOWER, 0);
		}
		else if	(value[0] == 22)
		{
			PORT_ModifyOutPort(OP_AIR_BRUSH, 1);
		}
		else if	(value[0] == 23)
		{
			PORT_ModifyOutPort(OP_AIR_BRUSH, 0);
		}
		else if	(value[0] == 24)
		{
			PORT_ModifyOutPort(OP_AIR_BRUSH_1_ACTUATOR,	1);
		}
		else if	(value[0] == 25)
		{
			PORT_ModifyOutPort(OP_AIR_BRUSH_1_ACTUATOR,	0);
		}
		else if	(value[0] == 26)
		{
			PORT_ModifyOutPort(OP_AIR_BRUSH_2_ACTUATOR,	1);
		}
		else if	(value[0] == 27)
		{
			PORT_ModifyOutPort(OP_AIR_BRUSH_2_ACTUATOR,	0);
		}
		else if	(value[0] == 28)
		{
			PORT_ModifyOutPort(OP_MISEJECT_ACTUATOR_ON,	1);
			PORT_ModifyOutPort(OP_MISEJECT_ACTUATOR_OFF, 0);
		}
		else if	(value[0] == 29)
		{
			PORT_ModifyOutPort(OP_MISEJECT_ACTUATOR_ON,	0);
			PORT_ModifyOutPort(OP_MISEJECT_ACTUATOR_OFF, 1);
		}
		else if	(value[0] == 30)
		{
			PORT_ModifyOutPort(OP_MISEJECT_ACTUATOR_ON,	0);
			PORT_ModifyOutPort(OP_MISEJECT_ACTUATOR_OFF, 0);
		}
        //Q
        else if	(value[0] == 31)
		{
			PORT_ModifyOutPort(OP_GOOD_BLOWER, 1);
		}
        else if	(value[0] == 32)
		{
			PORT_ModifyOutPort(OP_GOOD_BLOWER, 0);
		}
		else if	(value[0] == 33)
		{
			PORT_ModifyOutPort(OP_INTERLOCK_SOLENOID, 1);
		}
        else if	(value[0] == 34)
		{
			PORT_ModifyOutPort(OP_INTERLOCK_SOLENOID, 0);
		}
		else if	(value[0] == 35)
		{
			PORT_ModifyOutPort(OP_IONIZER_ON, 1);
		}
        else if	(value[0] == 36)
		{
			PORT_ModifyOutPort(OP_IONIZER_ON, 0);
		}
	}
	else if	(action	== 3)
	{
		if (value[0] ==	0)
		{
			MC_MainControl_Cleaning();
		}
		else if	(value[0] == 2)
		{
			MC_DustBlower_On();
		}
		else if	(value[0] == 3)
		{
			MC_DustBlower_Off();
		}
		else if	(value[0] == 4)
		{
			MC_NC_HomePositionSetup();
		}
	}
	else if	(action	== 4)
	{
		if (value[0] ==	0)
		{
			MC_LampControl_On(LAMP_RED_INDEX);
		}
		else if	(value[0] == 1)
		{
			MC_LampControl_Off(LAMP_RED_INDEX);
		}
		else if	(value[0] == 2)
		{
			MC_LampControl_On(LAMP_YELLOW_INDEX);	 //Y = R + G
		}
		else if	(value[0] == 3)
		{
			MC_LampControl_Off(LAMP_YELLOW_INDEX);  //Y	= R	+ G
		}
		else if	(value[0] == 4)
		{
			MC_LampControl_On(LAMP_GREEN_INDEX);
		}
		else if	(value[0] == 5)
		{
			MC_LampControl_Off(LAMP_GREEN_INDEX);
		}
		else if	(value[0] == 6)	// 1 On
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 1);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
		}
		else if	(value[0] == 7)	// 1 Off
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 0);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
		}
		else if	(value[0] == 8)
		{
			PORT_ModifyOutPort(OP_ROOM_LAMP_ON,	1);
		}
		else if	(value[0] == 9)
		{
			PORT_ModifyOutPort(OP_ROOM_LAMP_ON,	0);
		}
		else if	(value[0] == 14)	// 2 On
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 0);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 1);
		}
		else if	(value[0] == 15)	// 2 Off
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 0);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
		}
		else if	(value[0] == 16)	// 3 On
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 1);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 1);
		}
		else if	(value[0] == 17)	// 3 Off
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 0);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
		}
		else if	(value[0] == 18)	
		{
			PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_RESET, 1);
			SafetyResetFlag = 1;
		}
        else if	(value[0] == 19)
		{
			PORT_ModifyPhysicalOutPort(OP_2DISTRIBUTOR_ON,	0);
			PORT_ModifyPhysicalOutPort(OP_2DISTRIBUTOR_OFF, 1);            
		}
		else if	(value[0] == 20)
		{
			PORT_ModifyPhysicalOutPort(OP_2DISTRIBUTOR_ON,	1);
			PORT_ModifyPhysicalOutPort(OP_2DISTRIBUTOR_OFF, 0); 
		}  
	}
	else if	(action	== 5)
	{
		PORT_PLC_ON();
	}
}
//---------------------------------------------------------------------------
void MC_Procedure(TMachineControlData_Procedure	*procedureData)
{
	int	motorIndex;
	int	stepMotorIndex;

	if (procedureData->Action == 0)		// stop
	{
		//MainMachineStatus.OperationState = MACHINE_STATE_STOP;
		WaitStop_State = 0;
		MC_MainControl_Stop();

	}
	else if	(procedureData->Action == 1)	// run
	{
		WaitStop_State = 0;
		if (procedureData->Mode	== PROCEDURE_MODE_TEST)
		{
			MainControlData.Mode = MAIN_CONTROL_MODE_TEST;
		}
		else if	(procedureData->Mode ==	PROCEDURE_MODE_CAPTURE)
		{
			MainControlData.Mode = MAIN_CONTROL_MODE_CAPTURE;
		}
		else if	(procedureData->Mode ==	PROCEDURE_MODE_STUDY)
		{
			MainControlData.Mode = MAIN_CONTROL_MODE_STUDY;
		}
		else if	(procedureData->Mode ==	PROCEDURE_MODE_INSPECTION)
		{
			MainControlData.Mode = MAIN_CONTROL_MODE_INSPECTION;
			USBCommTimeout = 0;
			USBCommAlarmCheck = 0;
		}
		else
		{
			MainControlData.Mode = MAIN_CONTROL_MODE_NONE;
		}

		for	(motorIndex	= 0; motorIndex	< MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			MainControlData.MotorSpeed[motorIndex] = procedureData->MotorSpeed[motorIndex];
		}


		MainControlData.AirKnifeSpeed 					= procedureData->AirKnifeSpeed;
		MainControlData.SuctionDisk1InverterSpeed 		= procedureData->SuctionDisk1InverterSpeed;
		MainControlData.SuctionDisk2InverterSpeed 		= procedureData->SuctionDisk2InverterSpeed;
#ifdef SELMA		
		MainControlData.adjustEjectorWindStrength		= procedureData->adjustEjectoWindStrength;
		MainControlData.EnabledSensorType               = procedureData->EnabledSensorType;
#endif

		VFControlInfo.MaxSpeedTrainingMode 				= procedureData->MaxSpeedTrainingMode;
		VFControlInfo.ManualMaxSpeed 					= procedureData->ManualMaxSpeed;
		VFControlInfo.ManualModeSensorIndex				= procedureData->ManualModeSensorIndex;
		VFControlInfo.ManualModeSensorActiveRatio 		= procedureData->ManualModeSensorActiveRatio;
		VFControlInfo.ManualLimitSpeed 					= procedureData->ManualLimitSpeed;
		VFControlInfo.ManualModeLimitSensorIndex 		= procedureData->ManualModeLimitSensorIndex;
		VFControlInfo.ManualModeLimitSensorActiveRatio 	= procedureData->ManualModeLimitSensorActiveRatio;
		VFControlInfo.Sensor1Ratio 						= procedureData->EmptySensorActiveRatio;
		VFControlInfo.Sensor2Ratio 						= procedureData->FullSensorActiveRatio;

		for	(stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
		{
			MainControlData.NCPos[stepMotorIndex] =	procedureData->NCMotorPos[stepMotorIndex];
		}
		MC_MainControl_Run();
	}
	else if	(procedureData->Action == 2)	// ready
	{
		MC_MainControl_Ready(procedureData->NCMotorPos);
	}
	else if	(procedureData->Action == 3)	// cleaning
	{
		MC_MainControl_Cleaning();
	}
	else if	(procedureData->Action == 4)	// suspend reset
	{
		if ((MachineStatus.SuspendReason ==	MACHINE_SUSPEND_REASON_VD1_STALL ||
			MachineStatus.SuspendReason	== MACHINE_SUSPEND_REASON_VD2_STALL) &&
			MainControlData.State == MAIN_CONTROL_STATE_EMERGENCY_STOP)
		{
			MC_BowlFeeder_EmergencyReset();
			MC_SuctionDisk_EmergencyReset();
			MC_Vibrator_EmergencyReset();
			MC_MainControl_EmergencyReset();
		}


		BuzzerControlData.SuspendBuzzerOn =	0;
		if (BuzzerControlData.NotifyBuzzerOn ==	0 &&
			BuzzerControlData.SuspendBuzzerOn == 0)
		{
			PORT_ModifyOutPort(OP_BUZZER_ON, 0);
			PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
		}
		MachineStatus.Suspended	= 0;
	}
	else if	(procedureData->Action == 5)
	{
		if (procedureData->MotorSpeed[BF_ID_MOTOR_INDEX] !=	MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX] ||
			procedureData->MotorSpeed[BF_OD_IN_MOTOR_INDEX] !=	MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX] || procedureData->MotorSpeed[BF_OD_OUT_MOTOR_INDEX] !=	MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX])
		{
			MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX] =	procedureData->MotorSpeed[BF_ID_MOTOR_INDEX];
			MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX] =	procedureData->MotorSpeed[BF_OD_IN_MOTOR_INDEX];
			MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX] =	procedureData->MotorSpeed[BF_OD_OUT_MOTOR_INDEX];
			MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
		}
		VFControlInfo.MaxSpeedTrainingMode = procedureData->MaxSpeedTrainingMode;
		VFControlInfo.ManualMaxSpeed = procedureData->ManualMaxSpeed;
	}
	else if	(procedureData->Action == 6) //	L2 oper	speed change
	{
		MC_BowlFeeder_SpeedChange(procedureData->MotorSpeed[BF_ID_MOTOR_INDEX], procedureData->MotorSpeed[BF_OD_IN_MOTOR_INDEX], procedureData->MotorSpeed[BF_OD_OUT_MOTOR_INDEX]);
		MC_SuctionDisk_SpeedChange(procedureData->MotorSpeed[SD1_MOTOR_INDEX], procedureData->MotorSpeed[SD2_MOTOR_INDEX]);
	}
}
//---------------------------------------------------------------------------
void MC_Test_Process_1ms(void)
{
	if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		if (MisejectTestData.Enabled)
		{
			if (PORT_ReadInPort(IP_COUNTER_SENSOR_ON)) 
			{
				MisejectTestData.Timer1ms = Board1MSTmr;

				if (MisejectTestData.SensorState ==	0) 
				{
					MisejectTestData.SensorState = 1;
					MisEjectActive();
				}
			}

			if(MisejectTestData.SensorState)
			{
				if(Board1MSTmr - MisejectTestData.Timer1ms >= MisejectTestData.ActiveDelay) 
				{
					MisejectTestData.SensorState = 0;
					MisEjectStop();
				}	
			}
			
		}
	}
		//MC_Miseject_Process_1ms();	
}
//---------------------------------------------------------------------------
void MC_TimerProcess(void)	// per 1ms
{
	static int Timer_5ms = 0;
	static int Timer_1S	= 0;

	MC_Blackout_Process();
	MC_Main_Control_Process();
	MC_ToggleControl_Process();
	if (OPTestData.Enabled)
	{
		MC_OP_Test_Process();
	}
	Timer_5ms++;
	if (Timer_5ms == 5)
	{
		Timer_5ms =	0;
		Bowl_Feeder_Sensor_Process();
	}

	Timer_1S++;
	if (Timer_1S ==	1000)
	{
		Timer_1S = 0;
		if (VFControlInfo.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_MANUAL)
		{
			MC_Vibrator_ManualProcess();
		}
		else //	if (VFControlInfo.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
		{
			MC_Vibrator_Process();
		}
	}


	MC_BowlFeeder_Process();
	MC_SuctionDisk_Process();

	MC_LampControl_Process();
	MC_SwitchControl_Process();

	MC_DustBlowerSol_Process();
	MC_NC_HomeSearch_Process();
	MC_NC_Control_Processs();
	MC_Miseject_Process_1ms();
	MC_BuzzerControl_Process();

	if (Board1MSTmr	> 2000)
	{
		CheckMachineStatus();
	}	

	// check feeder	empty
	if (MainControlData.State == MAIN_CONTROL_STATE_RUN	&& MainControlData.Mode	== MAIN_CONTROL_MODE_INSPECTION)
	{
		if(MachineSetupData.BowlFeederSensorOption == 1)
		{
			if(MainControlData.EnabledSensorType == 0)
			{
				if (PORT_ReadInPort(IP_DISK_1_CAPTURE_SENSOR))
				{
					MachineStopSensorState.BFSensor1OffCount = 0;
				}
				else
				{
					MachineStopSensorState.BFSensor1OffCount++;
				}
			}
			else
			{
				if (PORT_ReadInPort(IP_DISK_1_CAPTURE_SENSOR_B))
				{
					MachineStopSensorState.BFSensor1OffCount = 0;
				}
				else
				{
					MachineStopSensorState.BFSensor1OffCount++;
				}
			}
		}
		

		if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
		{
		 /*	if(WaitStop_State != PROCEDURE_MODE_WAITSTOP1 && WaitStop_State!= PROCEDURE_MODE_WAITSTOP2)
			{
				if (VFControlInfo.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
				{
					if (MachineStopSensorState.BFSensor1OffCount > MACHINE_STOP_SENSOR_EMPTY_LIMIT)
					{
						MachineStatus.Suspended	= 1;
						MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
						MC_MainControl_Stop();
					}
				}
				else
				{
					if (MachineStopSensorState.BFSensor1OffCount > MACHINE_STOP_SENSOR_EMPTY_LIMIT)
					{
						MachineStatus.Suspended	= 1;
						MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
						MC_MainControl_Stop();
					}
				}

				if ((int)(Board1MSTmr -	TabletControlData.LastTabletSensor2Time) > INSPECTION_MACHINE_STOP_DELAY)
				{
					MachineStatus.Suspended	= 1;
					MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_TIMEOUT;
					MC_MainControl_Stop();
				}
			}*/
		}
		else
		{
			if (VFControlInfo.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
			{
				//if (VibratorControlData.StableSpeed == VIBRATOR_MAX_SPEED_VALUE)
				//if (VibratorControlData.StableSpeed == MachineInfo.VFInfo.MechanicalMaxSpeed)
				//{
					if (MachineStopSensorState.BFSensor1OffCount > MACHINE_STOP_SENSOR_EMPTY_LIMIT)
					{
						MachineStatus.Suspended	= 1;
						//MainMachineStatus.OperationState = MACHINE_STATE_SUSPEND;
						MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
						MC_MainControl_Stop();
					}
				//}
			}
			else
			{
				if (MachineStopSensorState.BFSensor1OffCount > MACHINE_STOP_SENSOR_EMPTY_LIMIT)
				{
					MachineStatus.Suspended	= 1;
					//MainMachineStatus.OperationState = MACHINE_STATE_SUSPEND;
					MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
					MC_MainControl_Stop();
				}
			}

			if(MachineSetupData.BowlFeederSensorOption == 1)
			{
				if ((int)(Board1MSTmr -	TabletControlData.LastTabletSensor2Time) > INSPECTION_MACHINE_STOP_DELAY)
				{
					//if(MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1  && MachineSetupData.CompanyID != DOMESTIC_MACHINE2)
					//{
						MachineStatus.Suspended	= 1;
						MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_TIMEOUT;
						MC_MainControl_Stop();
					//}
				}
			}
		}
		

		if(TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION)
		{
			USBCommTimeout++;
			if(USBCommTimeout >	20000)
			{
				if(USBCommAlarmCheck == 0)
				{
					USBCommAlarmCheck = 1;
					ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,66,66,66);
				}
				//MC_MainControl_Stop();
			}
		}
	}

	if (MSTimer100msCounter	== 0)
	{
		MC_PowerControl_Process_100ms();

		if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			MC_DoorLockControl_Process_100ms(); // Q   Ͷ


		MSTimer100msCounter	= 99;
	}
	else
	{
		if (MSTimer100msCounter	== 50)
		{
			MC_UnmanedOperation_Process_100ms();
		}
		MSTimer100msCounter--;
	}

}
//---------------------------------------------------------------------------
void CheckMachineStatus(void)
{
	char warningExist, alarmExist;
	int	doorOpen = 0;
	int	stepMotorIndex;
	int servoMotorIndex;
	int AcrociaEmsResetWithSafety = 0;
	int checkServoMotorCount = SERVO_MOTOR_COUNT;	
		
	warningExist = alarmExist = 0;

	/*
	if (PORT_ReadInPort(IP_REGULATOR_OVER_5KG))
	{
		MachineWarningState.RegulatorWarning = 0;
	}
	else
	{
		MachineWarningState.RegulatorWarning = 1;
		warningExist = 1;
	}
	*/

	//Q Buzzer/Alarm Reset
	if (PORT_ReadInPort(IP_BUZZER_RESET))
	{
		BuzzerControlData.AlarmBuzzerOn	= 0;
		BuzzerControlData.SuspendBuzzerOn = 0;
		PORT_ModifyOutPort(OP_BUZZER_ON, 0);
		PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
	}
	if (PORT_ReadInPort(IP_ALARM_RESET))
	{

		MC_Alarm_Reset();

		//MC_Alarm_Reset();  SPB ˶ ߻ ϴϱ PC ó ...RingBlower3OL
		//MachineAlarmState.AlarmClear = 1;
		//PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_RESET, 1);
		//SafetyResetFlag = 1;
		//alarmExist = 1;
	}

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		if (PORT_ReadInPort(IP_EMER_ON))
		{
			if (ResetButtonChecker > 500)
				ResetButtonChecker = 0 ;
			if (ResetButtonChecker == 0)
			{
				MachineAlarmState.EmergencyOn = 1;
				alarmExist = 1;
				ResetButtonChecker = 1;
			}
			else
				ResetButtonChecker ++;
		}
	}
	else
	{
		if (PORT_ReadInPort(IP_EMER_ON))
		{
			MachineAlarmState.EmergencyOn = 1;
			alarmExist = 1;
		}
	}




	if (MachineAlarmState.downstream_status || MachineAlarmState.upstream_status
	        || MachineAlarmState.mes_status || MachineAlarmState.Qjp_object_status)
	{
		alarmExist = 1;
	}

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{

		if (DoorInterlock)
		{
			if (MachineSetupData.Qualis_Machine1_CutomOption == 0)
			{
				if (PORT_ReadInPort(IP_INTERLOCK_1))
				{
					MachineWarningState.FrontDoorOpen = 0;
					MachineWarningState.LeftDoorOpen = 0;
					doorOpen = 0;
					warningExist = 0;
				}
				else
				{
					MachineWarningState.FrontDoorOpen = 1;
					MachineWarningState.LeftDoorOpen = 1;
					doorOpen = 1;
					warningExist = 1;
				}
			}
			else if (MachineSetupData.Qualis_Machine1_CutomOption == 1)
			{
				if (PORT_ReadInPort(IP_INTERLOCK_1) && PORT_ReadInPort(IP_INTERLOCK_2))
				{
					MachineWarningState.FrontDoorOpen = 0;
					MachineWarningState.LeftDoorOpen = 0;
					doorOpen = 0;
					warningExist = 0;
				}
				else
				{
					MachineWarningState.FrontDoorOpen = 1;
					MachineWarningState.LeftDoorOpen = 1;
					doorOpen = 1;
					warningExist = 1;
				}
			}


		}
		else
		{
			MachineWarningState.FrontDoorOpen = 1;
			MachineWarningState.LeftDoorOpen = 1;
			doorOpen = 1;
			warningExist = 1;
		}
	}
	else
	{
		if (PORT_ReadInPort(IP_INTERLOCK_1))
		{
			MachineWarningState.FrontDoorOpen = 0;
		}
		else
		{
			MachineWarningState.FrontDoorOpen = 1;
			doorOpen = 1;
			warningExist = 1;
		}
		if (PORT_ReadInPort(IP_INTERLOCK_2))
		{
			MachineWarningState.LeftDoorOpen = 0;
		}
		else
		{
			MachineWarningState.LeftDoorOpen = 1;
			doorOpen = 1;
			warningExist = 1;
		}
	}



	if ((MainControlData.State == MAIN_CONTROL_STATE_RUN	&& MainControlData.Mode	== MAIN_CONTROL_MODE_INSPECTION) && HopperEmptyEnable)
	{
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2 || MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)	//Ÿ.
		{
			if (!PORT_ReadInPort(IP_VB_SENSOR))
			{
				WarningAlarmCnt++;
			}
			else
			{
				WarningAlarmCnt	= 0;
				MachineWarningState.VBFeederEmpty	= 0;
			}
		}
		else
		{
			if (PORT_ReadInPort(IP_HOPPER_EMPTY_SENSOR))
			{
				WarningAlarmCnt++;
			}
			else
			{
				WarningAlarmCnt	= 0;
				MachineWarningState.VBFeederEmpty	= 0;
			}
		}
	}
	else if ((MainControlData.State == MAIN_CONTROL_STATE_STOP && MainControlData.Mode == MAIN_CONTROL_MODE_INSPECTION) && HopperEmptyEnable)
	{
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1 && HopperEmptyEnable)
		{
			if (WaitStop_State == PROCEDURE_MODE_WAITSTOP1 || WaitStop_State == PROCEDURE_MODE_WAITSTOP2)
			{
				if (!PORT_ReadInPort(IP_VB_SENSOR))
				{
					WarningAlarmCnt++;
				}
				else
				{
					WarningAlarmCnt	= 0;
					MachineWarningState.VBFeederEmpty	= 0;
				}
			}
			else
			{
				WarningAlarmCnt	= 0;
			}
		}
	}
	else
	{
		WarningAlarmCnt	= 0;
	}

	if (HopperEmptyEnable)
	{
		if (WarningAlarmCnt > ((MachineSetupData.VFInfo.FeederEmptyAlarmDelayTime * 1000) + 10))
		{
			MachineWarningState.VBFeederEmpty	= 1;
			warningExist = 1;
		}
	}

	if (PORT_ReadInPort(IP_BF_SENSOR_CONNECTED))
	{
		MachineWarningState.BowlFeederSensorDisconnected = 0;
	}
	else
	{
		MachineWarningState.BowlFeederSensorDisconnected = 1;
		warningExist = 1;
	}
	if (PORT_ReadInPort(IP_DISK_1_CAPTURE_LAMP1_CONNECTED) ||
	        PORT_ReadInPort(IP_DISK_2_CAPTURE_LAMP1_CONNECTED))
	{
		MachineWarningState.SuctionDisk1LampDisconnected = 0;
	}
	else
	{
		MachineWarningState.SuctionDisk1LampDisconnected = 1;
		warningExist = 1;
	}
	if (PORT_ReadInPort(IP_DISK_2_CAPTURE_LAMP2_CONNECTED) ||
	        PORT_ReadInPort(IP_DISK_2_CAPTURE_LAMP2_CONNECTED))
	{
		MachineWarningState.SuctionDisk2LampDisconnected = 0;
	}
	else
	{
		MachineWarningState.SuctionDisk2LampDisconnected = 1;
		warningExist = 1;
	}

	MachineWarningState.WarningExist = warningExist;





	if (PORT_ReadInPort(IP_RB_1_OL))
	{
		MachineAlarmState.Inverter1Trip	= 1;
		alarmExist = 1;
	}
	if (PORT_ReadInPort(IP_RB_2_OL))
	{
		MachineAlarmState.Inverter2Trip	= 1;
		alarmExist = 1;
	}
	if (PORT_ReadInPort(IP_RB_3_OL))
	{
		MachineAlarmState.Inverter3Trip	= 1;
		//MachineAlarmState.RingBlower3OL	= 1;
		alarmExist = 1;
	}

	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		checkServoMotorCount = SERVO_MOTOR_COUNT;
	}
	else
	{
		checkServoMotorCount = SERVO_MOTOR_COUNT - 1;
	}

	for (servoMotorIndex = 0; servoMotorIndex < checkServoMotorCount;	servoMotorIndex++)
	{
		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			if(servoMotorIndex==BF_ID_MOTOR_INDEX) continue;
		}
		
		if (ServoMotorInfo[servoMotorIndex].Status == MOTOR_STATUS_RUN && ServoMotorInfo[servoMotorIndex].TargetSpeed != 0)
		{
			if (ServoMotorInfo[servoMotorIndex].MidTermMotorRPM == 0)
			{
				MachineAlarmState.ServoAlarm = 1;
				if (servoMotorIndex == SD1_MOTOR_INDEX)
					MachineAlarmState.Disk1Stall = 1;
				else if (servoMotorIndex == SD2_MOTOR_INDEX)
					MachineAlarmState.Disk2Stall = 1;

				alarmExist = 1;
			}
		}
	}

	for (stepMotorIndex	= 0; stepMotorIndex	< MAX_STEP_MOTOR_COUNT;	stepMotorIndex++)
	{
		if (StepMotorData[stepMotorIndex].State	== STEP_MOTOR_STATE_STALL)
		{
			MachineAlarmState.StepMotorStall[stepMotorIndex] = 1;
			alarmExist = 1;
		}
	}

	if (MainControlData.State == MAIN_CONTROL_STATE_RUN)
	{
		if (AlarmSetupData.PressureAlarmLevel > 0 && MonitoringInfo.Pressure[0] > 0)
		{
			if (MonitoringInfo.Pressure[0] < AlarmSetupData.PressureAlarmLevel)
			{
				RS485PressureErrorTime[0]++;
				if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					if (RS485PressureErrorTime[0] >= RS485_ALARM_CEHCEK_DELAY)
					{
						MachineAlarmState.RegulatorError = 1;
						alarmExist = 1;
					}
				}
				else
				{
					if (RS485PressureErrorTime[0] >= RS485_ALARM_CEHCEK_DELAY_DOMESTIC)
					{
						MachineAlarmState.RegulatorError = 1;
						alarmExist = 1;
					}
				}

			}
			else
			{
				RS485PressureErrorTime[0] = 0;
			}
		}

		if (AlarmSetupData.TemperatureAlarmLevel1 > 0)
		{
			if (MonitoringInfo.TemperatureData[0] > 100* AlarmSetupData.TemperatureAlarmLevel1)
			{
				RS485TempErrorTime[0]++;
				if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					if (RS485TempErrorTime[0] >= RS485_ALARM_CEHCEK_DELAY)
					{
						MachineAlarmState.TemperatureOver[0] = 1;
						alarmExist = 1;
					}
				}
				else
				{
					if (RS485TempErrorTime[0] >= RS485_ALARM_CEHCEK_DELAY_DOMESTIC)
					{
						MachineAlarmState.TemperatureOver[0] = 1;
						alarmExist = 1;
					}
				}
			}
			else
			{
				RS485TempErrorTime[0] = 0;
			}
		}

		if (AlarmSetupData.TemperatureAlarmLevel2 > 0)
		{
			if (MonitoringInfo.TemperatureData[1] > 100* AlarmSetupData.TemperatureAlarmLevel2)
			{
				RS485TempErrorTime[1]++;
				if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					if (RS485TempErrorTime[1] >= RS485_ALARM_CEHCEK_DELAY)
					{
						MachineAlarmState.TemperatureOver[1] = 1;
						alarmExist = 1;
					}
				}
				else
				{
					if (RS485TempErrorTime[1] >= RS485_ALARM_CEHCEK_DELAY_DOMESTIC)
					{
						MachineAlarmState.TemperatureOver[1] = 1;
						alarmExist = 1;
					}
				}

			}
			else
			{
				RS485TempErrorTime[1] = 0;
			}

		}

		if (AlarmSetupData.TemperatureAlarmLevel3 > 0)
		{
			if (MonitoringInfo.TemperatureData[2] > 100* AlarmSetupData.TemperatureAlarmLevel3)
			{
				RS485TempErrorTime[2]++;
				if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					if (RS485TempErrorTime[2] >= RS485_ALARM_CEHCEK_DELAY)
					{
						MachineAlarmState.TemperatureOver[2] = 1;
						alarmExist = 1;
					}
				}
				else if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
				{
					if (RS485TempErrorTime[2] >= RS485_ALARM_TEMP_CEHCEK_DELAY)
					{
						MachineAlarmState.TemperatureOver[2] = 1;
						alarmExist = 1;
					}
				}
				else
				{
					if (RS485TempErrorTime[2] >= RS485_ALARM_CEHCEK_DELAY_DOMESTIC)
					{
						MachineAlarmState.TemperatureOver[2] = 1;
						alarmExist = 1;
					}
				}

			}
			else
			{
				RS485TempErrorTime[2] = 0;
			}
		}
	}


	if (InspectionAlarmState.AlarmExist)
	{
		if (InspectionAlarmState.TotalFull)
		{
			MachineAlarmState.TotalFull = 1;
			alarmExist = 1;
		}
		if (InspectionAlarmState.GPFull)
		{
			MachineAlarmState.GPFull = 1;
			alarmExist = 1;
		}
		if (InspectionAlarmState.DPFull)
		{
			MachineAlarmState.DPFull = 1;
			alarmExist = 1;
		}
		if (InspectionAlarmState.UPFull)
		{
			MachineAlarmState.UPFull = 1;
			alarmExist = 1;
		}
		if (InspectionAlarmState.DPRatioOver)
		{
			MachineAlarmState.DPRatioOver = 1;
			alarmExist = 1;
		}
		if (InspectionAlarmState.UPRatioOver)
		{
			MachineAlarmState.UPRatioOver = 1;
			alarmExist = 1;
		}
		if (LaserTestMode != 1)
		{
			if (InspectionAlarmState.CritDPRatioOver)
			{
				MachineAlarmState.CritDPRatioOver = 1;
				alarmExist = 1;
			}
			if (InspectionAlarmState.CritUPRatioOver)
			{
				MachineAlarmState.CritUPRatioOver = 1;
				alarmExist = 1;
			}
		}
		/*
				if (InspectionAlarmState.Sensor1Error)
				{
					MachineAlarmState.Sensor1Error = 1;
					alarmExist = 1;
				}
				if (InspectionAlarmState.Sensor2Error)
				{
					MachineAlarmState.Sensor2Error = 1;
					alarmExist = 1;
				}
		*/
		if (InspectionAlarmState.BrightnessDown)
		{
			MachineAlarmState.BrightnessDown = 1;
			alarmExist = 1;
		}
		//sjm Add
		if (InspectionAlarmState.MisEjecMultiAction)
		{
			//MachineAlarmState.CheckMisEjector = 1;
			MachineAlarmState.MisEjectFull = 1;
			alarmExist = 1;
		}
		if (InspectionAlarmState.MisEjectCheck)
		{
			MachineAlarmState.CheckMisEjector = 1;
			alarmExist = 1;
		}
		// й
		if (InspectionAlarmState.DistributorDown)
		{
			MachineAlarmState.CheckDistributor = 1;
			alarmExist = 1;
		}
	}


	if (SuctionDiskProcedureData.State == SD_STATE_RUN && (int)(Board1MSTmr	- SuctionDiskProcedureData.StableCheckStartTime - 1000) > 0)
	{
		if (PORT_ReadInPort(IP_EMISSION_SENSOR))
		{
			EmissionSensingTime++;
			if (EmissionSensingTime >= 1000) // 1ʰ 	 ΰ -	1MS	Timer *	1000
			{
				MachineAlarmState.EmissionSensorOn = 1;
				alarmExist = 1;
			}
		}
		else
		{
			EmissionSensingTime = 0;
		}
	}

	if (MainControlData.State == MAIN_CONTROL_STATE_RUN)
	{
		//by   hye	 ˶	߰
		if (AlarmSetupData.VacuumAlarmLevel1 < 0 || AlarmSetupData.VacuumAlarmLevel2 < 0)	 //	 	 ǵũ1 
		{
			if (MonitoringInfo.Pressure[1] < 0)
			{
				//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,MonitoringInfo.Pressure[1],0.1	* AlarmSetupData.VacuumAlarmLevel1,0000);
				if (MonitoringInfo.Pressure[1] > (0.1* AlarmSetupData.VacuumAlarmLevel1))	 //	 pressure[1]	=  1 ǵũ  ġ	      ũ ˶	︲.  ( )
				{
					RS485PressureErrorTime[1]++;
					if (RS485PressureErrorTime[1] >= RS485_ALARM_CEHCEK_DELAY) // 3sec
					{
						MachineAlarmState.Disk1SuctionLow = 1;
						alarmExist = 1;
					}
				}
				else
				{
					RS485PressureErrorTime[1] = 0;
				}
			}
			if (MonitoringInfo.Pressure[2] < 0)
			{
				if (MonitoringInfo.Pressure[2] > (0.1 * AlarmSetupData.VacuumAlarmLevel2))  // pressure[2] = 	2	ǵũ 	ġ       ũ	˶ ︲. ( 	)
				{
					RS485PressureErrorTime[2]++;
					if (RS485PressureErrorTime[2] >= RS485_ALARM_CEHCEK_DELAY)
					{
						MachineAlarmState.Disk2SuctionLow = 1;
						alarmExist = 1;
					}

				}
				else
				{
					RS485PressureErrorTime[2] = 0;
				}
			}
		}

	}

	InterlockData.DoorOpen = doorOpen;
	if (MachineControlMode >= MACHINE_MODE_INTERLOCK)
	{
		// check door interlock
		if (MainControlData.State == MAIN_CONTROL_STATE_RUN	||
		        MainControlData.State == MAIN_CONTROL_STATE_STARTING)
		{
			if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				if (MachineSetupData.Qualis_Machine1_CutomOption == 0)
				{
					if (InterlockData.DoorOpen)
					{
						MachineAlarmState.Interlock	= 1;
						alarmExist = 1;
					}
				}
				else if (MachineSetupData.Qualis_Machine1_CutomOption == 1)
				{
					if (InterlockData.DoorInterlockEnabled && InterlockData.DoorOpen)
					{
						MachineAlarmState.Interlock	= 1;
						alarmExist = 1;
					}
				}


			}
			else
			{
				if (InterlockData.DoorInterlockEnabled && InterlockData.DoorOpen)
				{
					MachineAlarmState.Interlock	= 1;
					alarmExist = 1;
				}
			}
		}
	}

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		if (MachineAlarmState.AlarmExist == 0)
		{
			MachineAlarmState.AlarmExist = alarmExist;
		}

		if (MachineAlarmState.AlarmExist)
		{
			if (WaitStop_State == PROCEDURE_MODE_WAITSTOP1 || WaitStop_State == PROCEDURE_MODE_WAITSTOP2)
			{
				WaitStop_State = 0;
			}
		}
	}
	else
	{
		if (MachineAlarmState.AlarmExist == 0)
		{
			MachineAlarmState.AlarmExist = alarmExist;
		}
	}

	if (MachineControlMode >= MACHINE_MODE_INTERLOCK)
	{
		if ((MachineAlarmState.AlarmExist || BlackoutInfo.BlackoutOccured || MachineWarningState.VBFeederEmpty))
		{
			MC_BuzzerControl_AlarmOn();

			MC_LampControl_Off(LAMP_YELLOW_INDEX);
			MC_LampControl_Blink(LAMP_RED_INDEX, LAMP_BLINKING_INTERVAL);
			MC_LampControl_Off(LAMP_GREEN_INDEX);
		}
		else
		{
			MC_BuzzerControl_AlarmOff();
			MC_LampControl_Off(LAMP_RED_INDEX);

			if (MainControlData.State == MAIN_CONTROL_STATE_RUN || MainControlData.State == MAIN_CONTROL_STATE_STARTING
			        || MainControlData.State == MAIN_CONTROL_STATE_STOPPING)
			{
				if (BuzzerControlData.SilenceMode)
				{
					MC_LampControl_Blink(LAMP_GREEN_INDEX, LAMP_BLINKING_INTERVAL);
				}
				else
				{
					MC_LampControl_On(LAMP_GREEN_INDEX);
				}
				MC_LampControl_Off(LAMP_YELLOW_INDEX);

				if (MainControlData.State != MAIN_CONTROL_STATE_STOPPING)
					WaitStop_State = 0;
			}
			else if (MainControlData.State == MAIN_CONTROL_STATE_STOP)
			{
				if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
				{
					if (BuzzerControlData.SilenceMode)
					{
						MC_LampControl_Blink(LAMP_RED_INDEX, LAMP_BLINKING_INTERVAL);
					}
					else
					{
						if (WaitStop_State == PROCEDURE_MODE_WAITSTOP1 || WaitStop_State == PROCEDURE_MODE_WAITSTOP2)
						{
							MC_LampControl_Off(LAMP_RED_INDEX);
							MC_LampControl_Blink(LAMP_GREEN_INDEX, LAMP_BLINKING_INTERVAL);
						}
						else
						{
							if (BuzzerControlData.SilenceMode)
							{
								MC_LampControl_Blink(LAMP_RED_INDEX, LAMP_BLINKING_INTERVAL);
							}
							else
							{
								MC_LampControl_On(LAMP_RED_INDEX);
							}

							MC_LampControl_Off(LAMP_GREEN_INDEX);
						}
					}
				}
				else
				{
					if (BuzzerControlData.SilenceMode)
					{
						MC_LampControl_Blink(LAMP_YELLOW_INDEX, LAMP_BLINKING_INTERVAL);
					}
					else
					{
						MC_LampControl_On(LAMP_YELLOW_INDEX);
					}

					MC_LampControl_Off(LAMP_GREEN_INDEX);
				}
			}
			else
			{
				if (BuzzerControlData.SilenceMode)
				{
					MC_LampControl_Blink(LAMP_YELLOW_INDEX, LAMP_BLINKING_INTERVAL);
				}
				else
				{
					MC_LampControl_On(LAMP_YELLOW_INDEX);
				}

				MC_LampControl_Off(LAMP_GREEN_INDEX);
			}
		}

		if (MainControlData.State == MAIN_CONTROL_STATE_RUN	||
		        MainControlData.State == MAIN_CONTROL_STATE_STARTING)
		{
			if (MachineAlarmState.AlarmExist && !MachineAlarmState.EmergencyOn &&
			        !MachineAlarmState.Disk1Stall && !MachineAlarmState.Disk2Stall && !MachineAlarmState.ServoAlarm	&&
			        !MachineAlarmState.Interlock && !MachineAlarmState.CheckMisEjector && !MachineAlarmState.RegulatorError)
			{
				WaitStop_State = 0;
				MC_MainControl_Stop();
			}
		}
	}

	if (MonitorSwitchControlData.LightOn)
	{
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			PORT_ModifyOutPort(OP_LIGHT_SWITCH_LAMP_ON, 0);
		else
			PORT_ModifyOutPort(OP_LIGHT_SWITCH_LAMP_ON, 1);
	}
	else
	{
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			PORT_ModifyOutPort(OP_LIGHT_SWITCH_LAMP_ON, 1);
		else
			PORT_ModifyOutPort(OP_LIGHT_SWITCH_LAMP_ON, 0);
	}

	if (MachineAlarmState.EmergencyOn || MachineAlarmState.Disk1Stall || MachineAlarmState.Disk2Stall || MachineAlarmState.ServoAlarm || MachineAlarmState.Interlock ||
	        MachineAlarmState.CheckMisEjector || MachineAlarmState.RegulatorError)
	{
		if (EmergencyState == 0)
		{
			// emergency occured
			// emergency stop all moving part
			MC_MainControl_EmergencyStop();
			MC_BowlFeeder_EmergencyStop();
			MC_SuctionDisk_EmergencyStop();
			MC_Vibrator_EmergencyStop();
			MC_StepMotor_EmergencyStop();
			MC_NC_Control_EmergencyStop();
			MC_DustBlower_Off();
			MC_DustBlowerSol_Off();
			PORT_ChangeOutPort(OP_DH_CONTROL, 0);
			if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				MisEjectActive();
			}
			EmergencyState = 1;
		}
	}
	else
	{
		if (EmergencyState == 1)
		{
			// emergency reset
			MC_BowlFeeder_EmergencyReset();
			MC_SuctionDisk_EmergencyReset();
			MC_Vibrator_EmergencyReset();
			MC_MainControl_EmergencyReset();
			MC_StepMotor_EmergencyReset();
			MC_NC_Control_EmergencyReset();
			if (MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
			{
				MisEjectStop();
			}
			EmergencyState = 0;
			MachineStatus.Suspended = 0;
		}
	}

	InterlockData.DoorOpen = doorOpen;
}


//---------------------------------------------------------------------------
void MC_SetFreeMode(void)
{
	// stop	vibrator
	MC_Vibrator_Off();
	// stop	all	motors
	Servo_Motor_Stop_Param(0, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(1, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(2, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(3, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	// stop	all	blowers
	PORT_ModifyOutPort(OP_SD1_SUCTION_ON, 0);
	PORT_ModifyOutPort(OP_SD2_SUCTION_ON, 0);
	PORT_ModifyOutPort(OP_DUST_SUCTION_ON, 0);
	// off all lamps and buzzer
	MC_LampControl_Off(LAMP_RED_INDEX);
	MC_LampControl_Off(LAMP_YELLOW_INDEX);
	MC_LampControl_Off(LAMP_GREEN_INDEX);
	PORT_ModifyOutPort(OP_BUZZER_ON, 0);
	PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
	MC_LED_AllOff();
}

//---------------------------------------------------------------------------
void MC_SetInterlockMode(void)
{
	// stop	vibrator
	MC_Vibrator_Off();
	// stop	all	motors
	Servo_Motor_Stop_Param(0, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(1, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(2, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	Servo_Motor_Stop_Param(3, SERVO_MOTOR_EMERGENCY_STOP_TIME);
	// stop	all	blowers
	PORT_ModifyOutPort(OP_SD1_SUCTION_ON, 0);
	PORT_ModifyOutPort(OP_SD2_SUCTION_ON, 0);
	PORT_ModifyOutPort(OP_DUST_SUCTION_ON, 0);
	// off all lamps and buzzer
	MC_LampControl_Off(LAMP_RED_INDEX);
	MC_LampControl_Off(LAMP_YELLOW_INDEX);
	MC_LampControl_Off(LAMP_GREEN_INDEX);
	PORT_ModifyOutPort(OP_BUZZER_ON, 0);
	PORT_ModifyOutPort(OP_BUZZER_2_ON, 0);
	// init	sol	states (off	all	sols)
	PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_0, 0);
	PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_1, 0);
#ifdef SELMA	
	PORT_ModifyOutPort(OP_BF_AIR_KNIFE_BIT_2, 0);	//Air Knife	3
#endif	
	PORT_ModifyOutPort(OP_SD1_AIR, 0);
	PORT_ModifyOutPort(OP_SD2_AIR, 0);
	PORT_ModifyOutPort(OP_DEFECT_BLOWER, 0);
	PORT_ModifyOutPort(OP_UNINSPECTED_BLOWER, 0);
    PORT_ModifyOutPort(OP_GOOD_BLOWER, 0);

	MC_LED_AllOff();
	//make	cleaning state
	//MC_CleaningState();
}

//---------------------------------------------------------------------------
void MC_50us_Process(void)	// per 50us
{
    //sjm Add 2017.11.28
	MC_Ejector_Test_Process();
    	MC_Ejector_Process_Encoder();
	MC_LED_Process();
//	MC_Ejector_Process();
	
	MC_LASER_Trigger_Process();
}
//---------------------------------------------------------------------------
void MC_Alarm_Reset(void)
{
	if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		ResetButtonChecker = 1 ;
		MC_LampControl_Off(LAMP_YELLOW_INDEX);
		if(MachineSetupData.Qualis_Machine1_CutomOption == 0)
		{
			PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_RESET, 1);
			PORT_ModifyOutPort(IP_EMER_ON, 0);
			SafetyResetFlag = 1;
		}
		
	}

	memset(&MachineAlarmState, 0, sizeof(TMachineAlarmState));
	memset(&InspectionAlarmState, 0, sizeof(TInspectionAlarmState));
	memset(&MachineWarningState, 0, sizeof(TMachineWarningState));
	MachineStatus.Suspended = 0;

	Step_Motor_Alarm_Reset();

	MC_BuzzerControl_AlarmOff();

	

	EmissionSensingTime	= 0;
	memset(RS485PressureErrorTime,0,sizeof(int)*3);
	memset(RS485TempErrorTime,0,sizeof(int)*3);

	MisEjecCheckCount	= 0;
	Oldboard50usTmr		= 0;
}
//---------------------------------------------------------------------------
void MC_ApplyMachineInfo(TMachineSetupData *machineSetupData)
{
	MachineControlMode = machineSetupData->MachineMode;
	switch (MachineControlMode)
	{
		case MACHINE_MODE_FREE:
			StepMotorControlMode = STEP_MOTOR_CONTROL_MODE_FREE;
			break;
		case MACHINE_MODE_INTERLOCK:
			StepMotorControlMode = STEP_MOTOR_CONTROL_MODE_INTERLOCK;
			break;
		default:
			break;
	}
	
	HARDWARE_InitGPIO(machineSetupData->MachineType);

	PowerControlData.PC_Power_Mode = machineSetupData->PC_Power_Mode;

	InterlockData.DoorInterlockEnabled = machineSetupData->InterlockInfo.DoorInterlockEnabled;

	VibratorControlData.MechanicalMinSpeed = machineSetupData->VFInfo.MechanicalMinSpeed;
	VibratorControlData.MechanicalMaxSpeed = machineSetupData->VFInfo.MechanicalMaxSpeed;

//	VibratorControlData.StableSpeed	= machineSetupData->VFInfo.MechanicalMinSpeed;

//	  VFControlInfo.EmptySensorIndex = machineSetupData->VFInfo.EmptySensorIndex;
	VFControlInfo.Sensor1Ratio = machineSetupData->VFInfo.EmptySensorActiveRatio;
//	  VFControlInfo.FullSensorIndex	= machineSetupData->VFInfo.FullSensorIndex;
	VFControlInfo.Sensor2Ratio = machineSetupData->VFInfo.FullSensorActiveRatio;

	VFControlInfo.MaxSpeedTrainingMode = machineSetupData->VFInfo.MaxSpeedTrainingMode;
	VFControlInfo.ManualMaxSpeed = machineSetupData->VFInfo.MechanicalMinSpeed;		//data init
	VFControlInfo.ManualLimitSpeed = machineSetupData->VFInfo.MechanicalMinSpeed;	//data init

	memcpy(&EjectorSetupData, &(machineSetupData->EjectorInfo),	sizeof(TEjectorInfo));
	memcpy(&LasercomplexerInfo, &(machineSetupData->LasercomplexerInfo),	sizeof(TLasercomplexerInfo));
	memcpy(&LEDControlSetupData, &(machineSetupData->LEDControlInfo), sizeof(TLEDInfo));
	memcpy(&AlarmSetupData,	&(machineSetupData->AlarmSetupInfo), sizeof(TAlarmSetupInfo));
	memcpy(&BuzzerSetupData, &(machineSetupData->BuzzerInfo), sizeof(TBuzzerInfo));

	BuzzerControlData.BuzzerContinuousOn = BuzzerSetupData.BuzzerContinuousOn;
	BuzzerControlData.BuzzerOnTime = BuzzerSetupData.BuzzerOnTime;
	HopperEmptyEnable =	machineSetupData->HopperEmptyEnable;
	SetStepMotorInterlockValue(machineSetupData->InterlockInfo.NCInterlockAValue);
	if(LasercomplexerInfo.Laser_Trig_mode)
	{
		PORT_ModifyOutPort(OP_LASERT_TRIG_CONTROL_MODE, 1);  //0:α׷ , 1:ϵ 
	}
	else 
	{
		PORT_ModifyOutPort(OP_LASERT_TRIG_CONTROL_MODE, 0);  //0:α׷ , 1:ϵ 
	}
}
//---------------------------------------------------------------------------
void SaveTerminationInfo(void)
{
	TerminationInfo.DataValid =	1;
	TerminationInfo.InspectionID = TabletControlData.InspectionID;
	memcpy(&(TerminationInfo.InspectionInfo), &TabletInspectInfo, sizeof(TTabletInspectInfo));
	WriteToFlash(PID_TERMINATION_INFO, (unsigned char *)&TerminationInfo, sizeof(TTerminationInfo),	0);
}
//---------------------------------------------------------------------------
void InvalidateTerminationInfo(void)
{
	TerminationInfo.DataValid =	0;
	WriteToFlash(PID_TERMINATION_INFO, (unsigned char *)&TerminationInfo, sizeof(TTerminationInfo),	0);
}
//---------------------------------------------------------------------------
void MC_SetMachineControlMode(int machineControlMode)
{
	MachineControlMode = machineControlMode;

	switch (MachineControlMode)
	{
		case MACHINE_MODE_FREE:
			MC_SetFreeMode();
			StepMotorControlMode = STEP_MOTOR_CONTROL_MODE_FREE;
			break;
		case MACHINE_MODE_INTERLOCK:
			MC_SetInterlockMode();
			StepMotorControlMode = STEP_MOTOR_CONTROL_MODE_INTERLOCK;
			break;
		default:
			break;
	}
}
//---------------------------------------------------------------------------
void MC_DecodeMachineControl(unsigned char *controlData)
{
	TMachineControlHeader *machineControlHeader;
	machineControlHeader = (TMachineControlHeader *)controlData;
	if (machineControlHeader->Target ==	MACHINE_CONTROL_GENERAL)
	{
		TMachineControlData_General	*generalData;
		generalData	= (TMachineControlData_General *)controlData;
		MC_GeneralControl(generalData->ActionN,	generalData->Value);
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_PROCEDURE)
	{
		TMachineControlData_Procedure *procedureData;
		procedureData =	(TMachineControlData_Procedure *)controlData;
		MC_Procedure(procedureData);
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_BOWL_FEEDER)
	{
		TMachineControlData_BowlFeeder *bfData;
		bfData = (TMachineControlData_BowlFeeder *)controlData;
		MC_BowlFeederControl(bfData);
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_SUCTION_DISK)
	{
		TMachineControlData_SuctionDisk	*vdData;
		vdData = (TMachineControlData_SuctionDisk *)controlData;
		if (vdData->Action == 0)
		{
			MC_SuctionDisk_Stop();
		}
		else if	(vdData->Action	== 1)
		{
			MC_SuctionDisk_Run(vdData->DiscSpeed[0], vdData->DiscSpeed[1],vdData->SuctionDisk1InverterSpeed, vdData->SuctionDisk2InverterSpeed);
		}
		else if	(vdData->Action	== 2)
		{
			MC_SuctionDisk_MotorStop();
		}
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_RINGBLOWER)
	{
		TMachineControlData_RingBlower *ringBlowerData;
		ringBlowerData = (TMachineControlData_RingBlower *)controlData;
		MC_RingBlowerControl(ringBlowerData->BlowerIndex, ringBlowerData->Action, ringBlowerData->Speed1, ringBlowerData->Speed2);
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_SERVOMOTOR)
	{
		TMachineControlData_ServoMotor *servoMotorData;
		servoMotorData = (TMachineControlData_ServoMotor *)controlData;
		MC_ServoMotorControl(servoMotorData);
	}

	else if	(machineControlHeader->Target == MACHINE_CONTROL_VIBRATOR)
	{
		TMachineControlData_VibrationFeeder	*vibratorData;
		vibratorData = (TMachineControlData_VibrationFeeder	*)controlData;
		MC_VibratorControl(vibratorData);
	}
	else if	(machineControlHeader->Target == SungChul_Data)
	{
		TMachineControlData_SungChulData *SungChulData;
		SungChulData = (TMachineControlData_SungChulData *)controlData;
		SungChulControl(SungChulData);
	//	MC_VibratorControl(VFStartData);
	}

	else if	(machineControlHeader->Target == MACHINE_CONTROL_ILLUMINATOR)
	{
		TMachineControlData_Illuminator	*illuminatorData;
		illuminatorData	= (TMachineControlData_Illuminator *)controlData;
		if (illuminatorData->Action	== 0)
		{
			MC_LED_Off(illuminatorData->LEDIndex);
		}
		else if	(illuminatorData->Action ==	1)
		{
			MC_LED_On(illuminatorData->LEDIndex, illuminatorData->Mode,
				illuminatorData->Interval1,	illuminatorData->Interval2);
		}
		else if	(illuminatorData->Action ==	2)
		{
			MC_LED_AllOff();
		}
		else if	(illuminatorData->Action ==	3)
		{
			MC_LED_AllOn(illuminatorData->Mode,	illuminatorData->Interval1,
				illuminatorData->Interval2);
		}
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_EJECTOR)
	{
		TMachineControlData_Ejector	*ejectorData;
		ejectorData	= (TMachineControlData_Ejector *)controlData;

		//ejectorData->Action	== 2 : Regulator input V set only :	cik	add
		if (ejectorData->Action	== 0)
		{
			MC_Ejector_Test_Stop(ejectorData->EjectorIndex);
		}
		else if	(ejectorData->Action ==	1)
		{
			MC_Ejector_Test_Run(ejectorData->EjectorIndex, ejectorData->EjectorMask, ejectorData->EjectorMaskCount);
		}

	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_STEPMOTOR)
	{
		TMachineControlData_StepMotor *stepMotorData;
		stepMotorData =	(TMachineControlData_StepMotor *) controlData;
		MC_StepMotorControl(stepMotorData);
	}
	else if	(machineControlHeader->Target == MACHINE_CONTROL_MISEJECT)
	{
		TMachineControlData_Miseject *misejectData;
		misejectData = (TMachineControlData_Miseject *)	controlData;
		if (misejectData->Action ==	0)
		{
			MC_Miseject_Test_Stop();
		}
		else if	(misejectData->Action == 1)
		{
			MC_Miseject_Test_Run(misejectData->ActiveDelay,	misejectData->DurationTime);
		}

	}

}
//---------------------------------------------------------------------------
void MC_UnmanedOperation(TUnmanedOperationData *unmanedOperationData)
{
	CSL_IntcGlobalEnableState 	state;
	CSL_intcGlobalDisable(&state);
	memcpy(&UnmanedOperationData, unmanedOperationData,	sizeof(TUnmanedOperationData));
	if (UnmanedOperationData.Activated)
	{
		if (UnmanedOperationData.BuzzerOnTime == 0)
		{
			BuzzerControlData.BuzzerContinuousOn = TRUE;
		}
		else
		{
			BuzzerControlData.BuzzerContinuousOn = FALSE;
			BuzzerControlData.BuzzerOnTime = UnmanedOperationData.BuzzerOnTime;
		}
		UnmanedOperationControlData.MachineStopped = FALSE;
		UnmanedOperationControlData.PowerOff = FALSE;
		if (UnmanedOperationData.TimerEnabled)
		{
			UnmanedOperationControlData.TimerCounter = 9;
		}
	}
	else
	{
		BuzzerControlData.BuzzerContinuousOn = BuzzerSetupData.BuzzerContinuousOn;
		BuzzerControlData.BuzzerOnTime = BuzzerSetupData.BuzzerOnTime;
		MC_BuzzerControl_AlarmOff();
		MachineStatus.Suspended = 0;
	}
	CSL_intcGlobalEnable(&state);
}
//---------------------------------------------------------------------------
void MC_UnmanedOperation_Process_100ms(void)
{
	if (UnmanedOperationData.Activated)
	{
		if (!UnmanedOperationControlData.MachineStopped	&&
			(MainControlData.State == MAIN_CONTROL_STATE_STOP || MainControlData.State == MAIN_CONTROL_STATE_EMERGENCY_STOP	||
			MainControlData.State == MAIN_CONTROL_STATE_STOPPING))
		{
			if (UnmanedOperationData.InspectionStopBuzzerOn)
			{
				MC_BuzzerControl_SuspendBuzzerOn();
			}
			//UnmanedOperationControlData.MachineStopTime	= Board1MSTmr;
			UnmanedOperationControlData.MachineStopped = TRUE;
		}

		if (UnmanedOperationControlData.MachineStopped && (MainControlData.State == MAIN_CONTROL_STATE_STOP|| MainControlData.State == MAIN_CONTROL_STATE_EMERGENCY_STOP))
		{
			if (UnmanedOperationData.InspectionStopMachinePowerOff)
			{
				if(TabletControlData.Func != TABLET_CONTROL_FUNC_NONE)
				{
					TabletControl_Stop();
					UnmanedOperationControlData.MachineStopTime	= Board1MSTmr;
				}

				if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable == 1)
				{			
					MachineStatus.OperationState = MACHINE_STATE_TERMINATE;
				}
			}
			

			if (UnmanedOperationData.InspectionStopMachinePowerOff && !UnmanedOperationControlData.PowerOff)
			{
				if (Board1MSTmr	- UnmanedOperationControlData.MachineStopTime >	((UnmanedOperationData.MachinePowerOffDelay *	1000) - 15000))
				{
					MC_PowerControl_Off();
					UnmanedOperationControlData.PowerOff = TRUE;
				}
			}
		}

		if (UnmanedOperationData.TimerEnabled)
		{
			if (UnmanedOperationControlData.TimerCounter ==	0)
			{
				if (UnmanedOperationData.InspectionStopTimer ==	0)
				{
					if (!MachineStatus.Suspended)
					{
						MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_TIME_OVER;
						MachineStatus.Suspended	= 1;
						MC_MainControl_Stop();
					}
				}
				else
				{
					UnmanedOperationData.InspectionStopTimer--;
				}
				UnmanedOperationControlData.TimerCounter = 10;
			}
			UnmanedOperationControlData.TimerCounter--;
		}
	}
}
//--------------------------------------------------------------------------

int MC_DistributorCheckBeforeInspection(void)
{
	int readPortVal = 0;

	readPortVal = PORT_ReadInPort(IP_DH_CONTROL);

	if(readPortVal == 0)
	{
		MachineAlarmState.CheckDistributor = 1;;
		MachineAlarmState.AlarmExist = 1;
		return 1;
	}
	else
	{	
		return 0;
	}
	
}
//---------------------------------------------------------------------------
