#ifndef _MACHINECONTROL_H_
#define _MACHINECONTROL_H_

#include "common.h"

#define PC_POWER_STATE_NONE				0
#define PC_POWER_STATE_ON				1
#define PC_POWER_STATE_OFF				2
#define PC_POWER_STATE_BEING_ON			3
#define PC_POWER_STATE_BEING_OFF		4

#define MAIN_POWER_STATE_NONE			0
#define MAIN_POWER_STATE_ON				1
#define MAIN_POWER_STATE_OFF			2
#define MAIN_POWER_STATE_BEING_ON		3
#define MAIN_POWER_STATE_BEING_OFF		4
#define MAIN_POWER_STATE_OFF_ALARM		5

#define LED_TYPE_ALWAYS_ON		0
#define LED_TYPE_FLASH			1
#define LED_TYPE_BLINK			2

#define SD_COMMAND_NONE					0
#define SD_COMMAND_RUN					1
#define SD_COMMAND_STOP					2

#define SD_STATE_NONE					0
#define SD_STATE_RUN					1
#define SD_STATE_STOP					2
#define SD_STATE_ACC					3
#define SD_STATE_DEC1					4
#define SD_STATE_DEC2					5
#define SD_STATE_SUCTION_WAITING		6
#define SD_STATE_EMERGENCY_STOP			0xFF

#define RING_BLOWER_ON		1
#define RING_BLOWER_OFF		0

#define RING_BLOWER_1			0
#define RING_BLOWER_2			1
#define RING_BLOWER_3			2
#define	RING_BLOWER_ALL		0xFF

#define AUTO_DEMPER_ON	1
#define AUTO_DEMPER_OFF	0

#define	EJECTOR_QUEUE_SIZE				1024
#define	EJECTOR_QUEUE_MASK				1023

#define DEFECT_EJECTOR_POSITION			455750
#define UNINS_EJECTOR_POSITION				403250
#define GOOD_EJECTOR_POSITION				358250
#define MISS_EJECTOR_POSITION				0

#define USEC_50_TO_ENCODER						37.5
#define EJECT_ENCODER_LENGTH					USEC_50_TO_ENCODER * 20*1		

extern int MachineControlMode;

typedef struct
{
	char State;
	char PCState;
	char PC_Power_Mode;
	char PowerSWState;
	unsigned short PowerSWOffCount;
	unsigned int PowerOffAlarmStartTime;	
	unsigned int PowerOffStartTime;
	unsigned int PCOnSwitchTime;
	unsigned int PCOffSwitchTime;
	unsigned int PCOffStartTime;
} TPowerControlData;

extern TPowerControlData PowerControlData;
extern int MACHINE_STOP_SENSOR_EMPTY_LIMIT;
extern int INSPECTION_MACHINE_STOP_DELAY;

typedef struct
{
	int Command;
	int State;
	int PrevState;
	int Disk1Speed;
	int Disk2Speed;
	unsigned int DiskAccStartTime;
	unsigned int DiskDecStartTime[3];
	unsigned int EmergencyResetRunStartTime;
	unsigned char Inverter1Speed;
	unsigned char Inverter2Speed;
	unsigned int StableCheckStartTime;
	unsigned int SuctionOnStartTime;
} TSuctionDiskProcedureData;

extern TSuctionDiskProcedureData SuctionDiskProcedureData;

typedef struct
{
	int Sensor1OnCount;
	int Sensor2OnCount;
	int Sensor1OnRatio;
	int Sensor2OnRatio;
} TBowlFeederSensorInfo;

extern TBowlFeederSensorInfo BowlFeederSensorInfo;

typedef	struct
{
	int				EjectorQueueStart;
	int				EjectorQueueEnd;
	int 	      			EjectorEncoderQueue[EJECTOR_QUEUE_SIZE];
	int 	      			EjectorLengthQueue[EJECTOR_QUEUE_SIZE];
	int 	      			EjectorNumberQueue[EJECTOR_QUEUE_SIZE];
	int 	      			SensorOnTime[EJECTOR_QUEUE_SIZE];
	int 	      			BlowTime[EJECTOR_QUEUE_SIZE];
	int 	      			BlowEncoder[EJECTOR_QUEUE_SIZE];
	int 	      			check[EJECTOR_QUEUE_SIZE];
} EjectorQueueData;



typedef struct
{
	char Mode;
	char State;
//	unsigned int BFStayDelay;
//	unsigned int BFEmptyDelay;
//	unsigned int BFOnDelay;
	int CurrentSpeed;
//	int ManualSensorOnCount;
//	int ManualSensorOffCount;
	int ManualSensorRatio;
	int ManualLimitSensorRatio;
	int ManualModeControlSpeed;
//	int EmptySensorOffCount;
//	int FullSensorOnCount;
//	int FullSensorOffCount;
//	int EmptySensorBeforeRatio;
//	int FullSensorBeforeRatio;
//	int On_EmptySensorRatio;
//	int On_FullSensorRatio;
//	int Off_EmptySensorRatio;
//	int Off_FullSensorRatio;
	
//	int Sensor1_OnCount;
//	int Sensor1_OffCount;
//	int Sensor2_OnCount;
//	int Sensor2_OffCount;

//	int On_Sensor1Ratio;
//	int On_Sensor2Ratio;
//	int Off_Sensor1Ratio;
//	int Off_Sensor2Ratio;

	int On_AverageSensor1Ratio;
	int On_AverageSensor2Ratio;
	unsigned short MechanicalMinSpeed;
	unsigned short MechanicalMaxSpeed;
	short StudySpeed;
	unsigned short AverageSpeed;
	unsigned short AverageRatio;  
	unsigned short AverageSumSpeed;
	unsigned short BeforeSensor1Ratio;
	unsigned short BeforeSensor2Ratio;

	unsigned char BeforeSpeedList[4];
	unsigned char Chul_SpeedList[16];
	unsigned char BeforeRatioList[7];
	unsigned char Sensor1RatioList[4];
	unsigned char Sensor2RatioList[4];
} TVibratorControlData;
extern TVibratorControlData VibratorControlData;


#define MAIN_CONTROL_STATE_NONE				0
#define MAIN_CONTROL_STATE_STOP				1
#define MAIN_CONTROL_STATE_RUN				2
#define MAIN_CONTROL_STATE_CLEANING			3
#define MAIN_CONTROL_STATE_ATTACHING		4
#define MAIN_CONTROL_STATE_DETACHING		5
#define MAIN_CONTROL_STATE_STARTING			6
#define MAIN_CONTROL_STATE_STOPPING			7
#define MAIN_CONTROL_STATE_EMERGENCY_STOP	0xFF

#define MAIN_CONTROL_POS_STATE_NONE			0
#define MAIN_CONTROL_POS_STATE_CLEANING		1
#define MAIN_CONTROL_POS_STATE_READY		2
typedef struct
{	
	char State;
	char SubState;
	char Func;
	char Mode;
	char PrevState;	// for emergency state
	char PosState;
	int MotorSpeed[MAX_SERVO_MOTOR_COUNT];
	char AirKnifeSpeed;
	unsigned char SuctionDisk1InverterSpeed;
	unsigned char SuctionDisk2InverterSpeed;
	unsigned char SuctionDisk3InverterSpeed;
	unsigned int EjectorWarmUpStartTime;
	int NCPos[MAX_STEP_MOTOR_COUNT];
	//sjm
	int applyEjectorDelay;
	int adjustUnInsDelay;
	int adjustDefectDelay;
	int adjustEjectorWindStrength;
	int EnabledSensorType;
} TMainControlData;

typedef struct
{
	int detectedActiveCmd;			
	int validCnt;							
	int openFlag;								
	int saveOpenTimeFlag;				
  	int OpenDelayTime;						
	int OpenTime;						
}TTPBMisejectProcess;


extern TMainControlData MainControlData;
extern TVibratorInfo VibratorInfo;
//extern TChul_VFInfo Chul_VFInfo;
extern TChul_VFData Chul_VFData;

extern TMachineWarningState MachineWarningState;
extern TMachineAlarmState MachineAlarmState;
extern TInspectionAlarmState InspectionAlarmState;

//extern TMainMachineStatus MainMachineStatus;

extern TTerminationInfo TerminationInfo;

typedef struct
{
	unsigned int ServoMotorSpeed[MAX_SERVO_MOTOR_COUNT];
} TOperationInfo;

typedef struct
{
	int DownState;
	int LightOn;
	unsigned int DownStartTime;
}TMonitorSwitchControlData;
	
extern TMonitorSwitchControlData MonitorSwitchControlData;
extern TOperationInfo OperationInfo;
extern TEjectorInfo EjectorSetupData;
extern TLasercomplexerInfo LasercomplexerInfo;
extern TLEDInfo LEDControlSetupData;

extern TUnmanedOperationData UnmanedOperationData;
extern int MisEjecCheckCount;
extern int Oldboard50usTmr;

extern int WaitStop_State;

void AddDefectEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber, int time);
void AddUninsEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber);
void AddGoodEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber);
void AddMissEjectorEncoderQueue(int EncoderValue, int Length, int TabletNumber);
int MC_DistributorCheckBeforeInspection(void);

	

#endif
