#ifndef _PORT_H_
#define _PORT_H_

#include "io_port.h"

/* set EMIF-B (From 0x68000000 to 0x6BFFFFFF) */

#define PORT_LINE_NUMBER			(MAX_PORT_COUNT / 16)

//Port 0~15
#define INPUT_PORT_0				(volatile unsigned short *)0xD0000000
//Port 16~31
#define INPUT_PORT_1				(volatile unsigned short *)0xD0000002
//Port 32~47
#define INPUT_PORT_2				(volatile unsigned short *)0xD0000004
//Port 48~63
#define INPUT_PORT_3				(volatile unsigned short *)0xD0000006
//Port 64~79
#define INPUT_PORT_4				(volatile unsigned short *)0x00000000//reserved
//Port 80~95
#define INPUT_PORT_5				(volatile unsigned short *)0xD0000060

//Port 0~15 		
#define OUTPUT_PORT_0				(volatile unsigned short *)0xD0000010
//Port 16~31 
#define OUTPUT_PORT_1				(volatile unsigned short *)0xD0000012
//Port 32~47
#define OUTPUT_PORT_2				(volatile unsigned short *)0xD0000014
//Port 48~63 
#define OUTPUT_PORT_3				(volatile unsigned short *)0xD0000016
//Port 64~79
#define OUTPUT_PORT_4				(volatile unsigned short *)0xD000005C
//Port 80~95
#define OUTPUT_PORT_5				(volatile unsigned short *)0xD0000062 

//OUTPUT PORT  
//PORT 0~31 (24V)
//PORT 32~43 (12V) 44~49(12 ۷)
//PORT 50~61 LED(LD)
//PORT 62~70 (24V)
//PORT 71~72 (5V)  Laser Triger



#define PLC_CONTROL					(volatile unsigned short *)0xD000000E //0x6800000E

#define ANALOG_OUTPUT_0				(volatile unsigned short *)0xD0000018 //0x6BFFFE18
#define ANALOG_OUTPUT_1				(volatile unsigned short *)0xD000001A //0x6BFFFE1A
#define ANALOG_OUTPUT_2				(volatile unsigned short *)0xD000001C //0x6BFFFE1C
#define ANALOG_OUTPUT_3				(volatile unsigned short *)0xD000001E //0x6BFFFE1E

#define SERVO_MOTOR_0_PULSE_L		(volatile unsigned short *)0xD0000020 //0x6BFFFE20
#define SERVO_MOTOR_0_PULSE_H		(volatile unsigned short *)0xD0000022 //0x6BFFFE22
#define SERVO_MOTOR_0_CONTROL		(volatile unsigned short *)0xD0000024 //0x6BFFFE24
#define SERVO_MOTOR_0_ENCODER		(volatile unsigned short *)0xD0000026 //0x6BFFFE26
#define SERVO_MOTOR_0_ENCODER_H		(volatile unsigned short *)0xD0000070 //0x6BFFFE26

#define SERVO_MOTOR_1_PULSE_L		(volatile unsigned short *)0xD0000028 //0x6BFFFE28
#define SERVO_MOTOR_1_PULSE_H		(volatile unsigned short *)0xD000002A //0x6BFFFE2A
#define SERVO_MOTOR_1_CONTROL		(volatile unsigned short *)0xD000002C //0x6BFFFE2C
#define SERVO_MOTOR_1_ENCODER		(volatile unsigned short *)0xD000002E //0x6BFFFE2E

//Inner disk  .
#define SERVO_MOTOR_2_PULSE_L		(volatile unsigned short *)0xD0000078 //0x6BFFFE38
#define SERVO_MOTOR_2_PULSE_H		(volatile unsigned short *)0xD000007A //0x6BFFFE3A
#define SERVO_MOTOR_2_CONTROL		(volatile unsigned short *)0xD000007C //0x6BFFFE3C
#define SERVO_MOTOR_2_ENCODER		(volatile unsigned short *)0xD000007E //0x6BFFFE3E

#define SERVO_MOTOR_3_PULSE_L		(volatile unsigned short *)0xD0000030 //0x6BFFFE30
#define SERVO_MOTOR_3_PULSE_H		(volatile unsigned short *)0xD0000032 //0x6BFFFE32
#define SERVO_MOTOR_3_CONTROL		(volatile unsigned short *)0xD0000034 //0x6BFFFE34
#define SERVO_MOTOR_3_ENCODER		(volatile unsigned short *)0xD0000036 //0x6BFFFE36

#define SERVO_MOTOR_4_PULSE_L		(volatile unsigned short *)0xD0000038 //0x6BFFFE38
#define SERVO_MOTOR_4_PULSE_H		(volatile unsigned short *)0xD000003A //0x6BFFFE3A
#define SERVO_MOTOR_4_CONTROL		(volatile unsigned short *)0xD000003C //0x6BFFFE3C
#define SERVO_MOTOR_4_ENCODER		(volatile unsigned short *)0xD000003E //0x6BFFFE3E

#define STEP_MOTOR_0_PULSE			(volatile unsigned short *)0xD0000040 //0xAFFFBF40 //0x6BFFFE40
#define STEP_MOTOR_1_PULSE			(volatile unsigned short *)0xD0000042 //0xAFFFBF42 //0x6BFFFE42
#define STEP_MOTOR_2_PULSE			(volatile unsigned short *)0xD0000044 //0xAFFFBF44 //0x6BFFFE44
#define STEP_MOTOR_3_PULSE			(volatile unsigned short *)0xD0000046 //0xAFFFBF46 //0x6BFFFE46
#define STEP_MOTOR_4_PULSE			(volatile unsigned short *)0xD0000048 //0xAFFFBF48 //0x6BFFFE48
#define STEP_MOTOR_5_PULSE			(volatile unsigned short *)0xD000004A //0xAFFFBF4A //0x6BFFFE4A

#define ENCODER_0					(volatile unsigned short *)0xD0000050 //0x6BFFFE50
#define ENCODER_1					(volatile unsigned short *)0xD0000052 //0x6BFFFE52
#define ENCODER_2					(volatile unsigned short *)0xD0000054 //0x6BFFFE54
#define ENCODER_3					(volatile unsigned short *)0xD0000056 //0x6BFFFE56
#define ENCODER_4					(volatile unsigned short *)0xD0000058 //0x6BFFFE58
#define ENCODER_5					(volatile unsigned short *)0xD000005A //0x6BFFFE5A
#define ENCODER_8					(volatile unsigned short *)0xD000005E //0x6BFFFE5E

//add
#define VERSION_READ_DATA_01		(volatile unsigned short *)0xD000004C
#define VERSION_READ_DATA_02		(volatile unsigned short *)0xD000004E


#define ADD_02_UNKNOWN_NAME			(volatile unsigned short *)0xD0000008
#define ADD_03_UNKNOWN_NAME			(volatile unsigned short *)0xD000000A
#define ADD_04_UNKNOWN_NAME			(volatile unsigned short *)0xD000000C
#define ADD_3D_SENSOR_DISK			(volatile unsigned short *)0xD0000064

extern int INVERTER_1_SPEED_AO_INDEX;
extern int INVERTER_2_SPEED_AO_INDEX;
extern int VF_SPEED_AO_INDEX;
extern int VF_HOPPER_SPPED_AO_INDEX;
extern int PRESSURE_REGULATOR_AO_INDEX;

/*#define INVERTER_1_SPEED_AO_INDEX			0
#define INVERTER_2_SPEED_AO_INDEX			1
#define VF_SPEED_AO_INDEX					2
#define PRESSURE_REGULATOR_AO_INDEX			3*/

#define SOP_PLC_INDEX				33					// PLC system port index


#define SERVO_MCBSP_GATE_SHIFT			12
#define SERVO_MCBSP_GATE_MASK			0x7000

extern near unsigned short InputFilter[PORT_LINE_NUMBER][3];		// address_count * filter count
extern near unsigned short InputPortValue[PORT_LINE_NUMBER];
extern near unsigned short OutputPortValue[PORT_LINE_NUMBER];
extern near unsigned short EncoderValue[11];

typedef struct
{
	unsigned int MachineRev;
	unsigned char VIPMap[MAX_PORT_COUNT];
	unsigned char VOPMap[MAX_PORT_COUNT];
} TPortMapInfo;
extern TPortMapInfo PortMapInfo;


void PORT_ModifyOutPort(unsigned char id, unsigned char on);
void PIO05_PORT_ONOFF();
void PORT_ChangeOutPort(unsigned char id, unsigned char on);


#endif
