#ifndef _RS485_H_
#define _RS485_H_


#include <csl_mcbsp.h>

#define RS485_MAX_BIT_RX	16
#define RS485_MAX_BIT_TX	16

// full duplex ̹Ƿ rx tx status иѴ.
#define RS485_TX_STATUS_NONE		0
#define RS485_TX_STATUS_READY		1
#define RS485_TX_STATUS_SENDING		2
#define RS485_TX_STATUS_SENT		3

#define RS485_RX_STATUS_NONE		0
#define RS485_RX_STATUS_READY		1
#define RS485_RX_STATUS_RECEIVING	2
#define RS485_RX_STATUS_RECEIVED	3


/////////////////////////////////////////////////////////////
//	McBSP ̿ RS485  
/////////////////////////////////////////////////////////////

typedef struct
{
	char *DataBufferAddr;
	int DataBufferSize;
	int DataPosition;	
	unsigned int BitBuffer[RS485_MAX_BIT_RX];
	int BitBufferPosition;
	int StopBitCount;
	int DataBitCount;
	int BitCount;
	int Status;
	int EOT_DataSize;
	char EOT_Type;
	char EOT_Char;
	unsigned int LastReceivedTime;
} TRS485RX;

typedef struct
{
	char *DataBufferAddr;
	int DataBufferSize;
	int DataPosition;	
	unsigned int BitBuffer[RS485_MAX_BIT_TX];
	int BitBufferPosition;
	int StopBitCount;
	int DataBitCount;
	int BitCount;
	int Status;
	int DataLength;
	unsigned int CompleteTime;
} TRS485TX;

typedef struct
{
	TRS485RX RX;
	TRS485TX TX;	
	CSL_McbspHandle McbspHandle;
} TRS485Handle;


#endif
