#include "rs485master.h"
#include "hardware.h"
#include "timer.h"
#include <csl_intc.h>
#include <csl_intcAux.h>
#include "environment.h"
#include "system_setup.h"

// rs485 master

#define	RX485_MASTER_PARITYBITS		  	0
#define	RX485_MASTER_DATABITS		  	8
#define	RX485_MASTER_RxHSTOPBITS	  	1
#define	RX485_MASTER_TxHSTOPBITS	  	1

#define	RX485_MASTER_RX_BIT_COUNT		10
#define	RX485_MASTER_TX_BIT_COUNT		10

TRS485Handle RS485MasterHandle;

#define	RS485_UNIT_KIND_THERMOMETER		0
#define	RS485_UNIT_KIND_PANELMETER		1
#define	RS485_UNIT_KIND_INVERTER		2

#define	COMM_STATUS_IDLE				0
#define	COMM_STATUS_POLLING				1

#define	COMM_FREQ						6500//5000
#define	COMM_RECEIVE_WAITING_TIME		100


#define	RS485_MASTER_BAUDRATE			9600

#define	MODBUS_RTU_HEADER_SIZE			3
#define	MODBUS_RTU_CRC_SIZE				2

#define	RS485_TEST_STATUS_IDLE			0
#define	RS485_TEST_STATUS_POLLING		1
#define	RS485_TEST_STATUS_COMPLETE		2

#define INVERTER_MAXIMUM_HZ             (6000.0/255.0)

//#define CURRENT_OUTPUT 1	//5ȣ  񿡼 ش define ּóҰ

struct
{
  unsigned char	UnitKind[RS485_UNIT_COUNT];
  unsigned char	Status[RS485_UNIT_COUNT];
  unsigned int LastCommTime[RS485_UNIT_COUNT];
  unsigned char	CommAddress[RS485_UNIT_COUNT];
  int CurrentCommUnitIndex;
} RS485MasterUnitControlData;

struct
{
  unsigned char	TXData[RX485_MASTER_TX_BUFFER_SIZE];
  unsigned char	RXData[RX485_MASTER_RX_BUFFER_SIZE];
  int TXLength;
  int RXLength;
} RS485MasterTransferControlData;

//add igchoi
struct
{
	unsigned char InitStat;
	int VoltageConvertRatio[3];
} KM6015ConvertVoltage;

TRS485TestData RS485MasterTestData;

TMonitoringInfo	MonitoringInfo;

TRS485DebugInfo	RS485DebugInfo;

int mc0_current_tx_time = 0;

int	MakeRS485TXPacket(unsigned char	commAddress, int unitKind, unsigned	char *txData);
int	DecodePacket(void);

void   RS485_MasterInit(void)
{
  int unitIndex;


  RS485_Init(&RS485MasterHandle, RS485_MASTER_BAUDRATE,	RX485_MASTER_TxHSTOPBITS, 
                RX485_MASTER_DATABITS + RX485_MASTER_PARITYBITS,RX485_MASTER_TX_BIT_COUNT, 
                RX485_MASTER_RxHSTOPBITS, RX485_MASTER_DATABITS + RX485_MASTER_PARITYBITS, 
                RX485_MASTER_RX_BIT_COUNT, CSL_MCBSP_0, 0);
  RS485_SetAddr(&RS485MasterHandle,	RS485MasterTransferControlData.TXData, RX485_MASTER_TX_BUFFER_SIZE,
	            RS485MasterTransferControlData.RXData, RX485_MASTER_RX_BUFFER_SIZE);



  
  RS485MasterHandle.RX.Status =	RS485_RX_STATUS_READY;


  for (unitIndex = 0; unitIndex	< RS485_UNIT_COUNT;	unitIndex++)
  {
	RS485MasterUnitControlData.Status[unitIndex]        = COMM_STATUS_IDLE;
	RS485MasterUnitControlData.LastCommTime[unitIndex]  = 0;
	RS485DebugInfo.WrongAddressCount[unitIndex]	    = 0;
	RS485DebugInfo.CRCErrorCount[unitIndex]	        = 0;
	RS485DebugInfo.SizeErrorCount[unitIndex]        = 0;
	RS485DebugInfo.ReceiveTOCount[unitIndex]        = 0;
	RS485DebugInfo.TXCount[unitIndex]               = 0;
  }

  for (unitIndex = 0; unitIndex	< SYSTEM_MAX_THERMOMETER_COUNT;	unitIndex++)
  {
	MonitoringInfo.TemperatureData[unitIndex]   = 0;
	MonitoringInfo.HumidityData[unitIndex]      = 0;
  }
  for (unitIndex = 0; unitIndex	< SYSTEM_MAX_PRESSURE_METER_COUNT; unitIndex++)
  {
	MonitoringInfo.Pressure[unitIndex]  = 0;
	MonitoringInfo.DotPos[unitIndex]    = 0;
  }
  for (unitIndex = 0; unitIndex	< SYSTEM_MAX_INVERTER_COUNT; unitIndex++)
  {
	MonitoringInfo.InverterRPM[unitIndex] =	0;
  }

  RS485MasterUnitControlData.UnitKind[0] = RS485_UNIT_KIND_THERMOMETER;
  RS485MasterUnitControlData.UnitKind[1] = RS485_UNIT_KIND_THERMOMETER;
  RS485MasterUnitControlData.UnitKind[2] = RS485_UNIT_KIND_THERMOMETER;
  RS485MasterUnitControlData.UnitKind[3] = RS485_UNIT_KIND_PANELMETER;
  RS485MasterUnitControlData.UnitKind[4] = RS485_UNIT_KIND_PANELMETER;
  RS485MasterUnitControlData.UnitKind[5] = RS485_UNIT_KIND_PANELMETER;
  RS485MasterUnitControlData.UnitKind[6] = RS485_UNIT_KIND_INVERTER;
  RS485MasterUnitControlData.UnitKind[7] = RS485_UNIT_KIND_INVERTER;
  RS485MasterUnitControlData.UnitKind[8] = RS485_UNIT_KIND_INVERTER;

  RS485MasterUnitControlData.CommAddress[0]	= 1;
  RS485MasterUnitControlData.CommAddress[1]	= 2;
  RS485MasterUnitControlData.CommAddress[2]	= 3;
  RS485MasterUnitControlData.CommAddress[3]	= 4;
  RS485MasterUnitControlData.CommAddress[4]	= 5;
  RS485MasterUnitControlData.CommAddress[5]	= 6;
  RS485MasterUnitControlData.CommAddress[6]	= 10;
  RS485MasterUnitControlData.CommAddress[7]	= 11;
  RS485MasterUnitControlData.CommAddress[8]	= 12;
  RS485MasterUnitControlData.CurrentCommUnitIndex =	0;

  RS485MasterTestData.Enabled =	FALSE;
  RS485MasterTestData.Status = COMM_STATUS_IDLE;

  KM6015ConvertVoltage.InitStat = 0;
#ifdef CURRENT_OUTPUT
  KM6015ConvertVoltage.VoltageConvertRatio[0] = 1053;
#else
  KM6015ConvertVoltage.VoltageConvertRatio[0] = 1012;
#endif
  KM6015ConvertVoltage.VoltageConvertRatio[1] = 0;
  KM6015ConvertVoltage.VoltageConvertRatio[2] = 0;
  return;
}



void IsrRS485RxMaster(void)
{
	CSL_intcGlobalDisable(NULL);
	IsrRS485Rx(&RS485MasterHandle);
	CSL_intcGlobalEnable(NULL);
}

void IsrRS485TxMaster(void)
{
	CSL_intcGlobalDisable(NULL);
	IsrRS485Tx(&RS485MasterHandle);
	CSL_intcGlobalEnable(NULL);
}

void RS485_TransmitStart(int length)
{
  SetGPIOVal(GPIO_MCBSP_2_RS485);
  RS485_Enable(&RS485MasterHandle);
  RS485_SetEOT_Time(&RS485MasterHandle);
  RS485MasterHandle.RX.Status =	RS485_RX_STATUS_READY;
  RS485MasterHandle.RX.LastReceivedTime	= Board1MSTmr;
  RS485_TxStart(&RS485MasterHandle,	length);
}


void RS485_TestTransmitStart(unsigned char *data, unsigned short length)
{
  SetGPIOVal(GPIO_MCBSP_2_RS485);
  RS485_SetEOT_Time(&RS485MasterHandle);
  RS485MasterHandle.RX.Status =	RS485_RX_STATUS_READY;
  RS485MasterHandle.RX.LastReceivedTime	= Board1MSTmr;
  RS485_TxStart(&RS485MasterHandle,	length);
}


void RS485_Test(unsigned char *data, int length)
{
  memcpy(RS485MasterTestData.TXData, data, length);	// TO DO: check	length
  RS485MasterTestData.TXLength = length;
  RS485MasterTestData.Status = COMM_STATUS_IDLE;
  RS485MasterTestData.Enabled =	TRUE;
}

void Pending_RS485_Command(unsigned	char *data,	int	length)
{
  RS485_TestTransmitStart(data,	length);
}

void RS485_Master_Loop_Process(void)
{
  if (RS485MasterHandle.RX.Status == RS485_RX_STATUS_RECEIVING)
  {
	if (Board1MSTmr	- RS485MasterHandle.TX.CompleteTime	> COMM_RECEIVE_WAITING_TIME)
	{
	  RS485MasterTransferControlData.RXLength =	RS485MasterHandle.RX.DataPosition;
	  RS485MasterHandle.RX.Status =	RS485_RX_STATUS_RECEIVED;
	  SetGPIOVal(GPIO_MCBSP_2_RS485);
	}
  }

  if (RS485MasterTestData.Enabled)
  {
	if (RS485MasterTestData.Status == RS485_TEST_STATUS_IDLE)
	{
	  if (RS485MasterHandle.TX.Status == RS485_TX_STATUS_READY && RS485MasterHandle.RX.Status != RS485_RX_STATUS_RECEIVING)
	  {
		memcpy(RS485MasterTransferControlData.TXData, RS485MasterTestData.TXData, RS485MasterTestData.TXLength);
		RS485MasterTransferControlData.TXLength	= RS485MasterTestData.TXLength;
		RS485_TransmitStart(RS485MasterTransferControlData.TXLength);
		RS485MasterTestData.Status = RS485_TEST_STATUS_POLLING;
	  }
	}
	else if	(RS485MasterTestData.Status	== RS485_TEST_STATUS_POLLING)
	{
	  if (RS485MasterHandle.RX.Status == RS485_RX_STATUS_RECEIVED)
	  {
		RS485MasterTestData.RXLength = RS485MasterTransferControlData.RXLength;
		memcpy(RS485MasterTestData.RXData, RS485MasterTransferControlData.RXData, RS485MasterTransferControlData.RXLength);
		RS485MasterTestData.Status = RS485_TEST_STATUS_COMPLETE;
		RS485MasterTestData.Enabled	= FALSE;
	  }
	}
  }

  if (RS485MasterUnitControlData.Status[RS485MasterUnitControlData.CurrentCommUnitIndex] ==	COMM_STATUS_IDLE)
  {
	if (Board1MSTmr	- RS485MasterUnitControlData.LastCommTime[RS485MasterUnitControlData.CurrentCommUnitIndex] > COMM_FREQ)
	{
	  if (RS485MasterHandle.TX.Status == RS485_TX_STATUS_READY && RS485MasterHandle.RX.Status != RS485_RX_STATUS_RECEIVING)
	  {
		RS485MasterTransferControlData.TXLength	=
		  MakeRS485TXPacket(RS485MasterUnitControlData.CommAddress[RS485MasterUnitControlData.CurrentCommUnitIndex],
		  RS485MasterUnitControlData.UnitKind[RS485MasterUnitControlData.CurrentCommUnitIndex],
		  RS485MasterTransferControlData.TXData);
		if (RS485MasterTransferControlData.TXLength	> 0)
		{
		  RS485_TransmitStart(RS485MasterTransferControlData.TXLength);
		  RS485MasterUnitControlData.Status[RS485MasterUnitControlData.CurrentCommUnitIndex] = COMM_STATUS_POLLING;
		  RS485DebugInfo.TXCount[RS485MasterUnitControlData.CurrentCommUnitIndex]++;
		}
		else
		{
		  RS485MasterUnitControlData.CurrentCommUnitIndex++;
		  if (RS485MasterUnitControlData.CurrentCommUnitIndex >= RS485_UNIT_COUNT)
		  {
			RS485MasterUnitControlData.CurrentCommUnitIndex	= 0;
		  }
		}
	  }
	}
  }
  else if (RS485MasterUnitControlData.Status[RS485MasterUnitControlData.CurrentCommUnitIndex] == COMM_STATUS_POLLING)
  {
	if (RS485MasterHandle.RX.Status	== RS485_RX_STATUS_RECEIVED)
	{
	  if (DecodePacket())
	  {
		RS485MasterUnitControlData.LastCommTime[RS485MasterUnitControlData.CurrentCommUnitIndex] = Board1MSTmr;
	  }
	  RS485MasterUnitControlData.Status[RS485MasterUnitControlData.CurrentCommUnitIndex] = COMM_STATUS_IDLE;
		
	  RS485MasterUnitControlData.CurrentCommUnitIndex++;
	  if (RS485MasterUnitControlData.CurrentCommUnitIndex >= RS485_UNIT_COUNT)
	  {
		RS485MasterUnitControlData.CurrentCommUnitIndex	= 0;
	  }		
	}
  }
  if((Board1MSTmr > mc0_current_tx_time+5000 )&& (RS485MasterHandle.TX.Status == RS485_TX_STATUS_SENDING))
  {
	mc0_current_tx_time = Board1MSTmr;
  	RS485MasterHandle.TX.Status = RS485_TX_STATUS_READY;
	RS485MasterUnitControlData.Status[RS485MasterUnitControlData.CurrentCommUnitIndex] =	COMM_STATUS_IDLE;
  }
}


int	MakeRS485TXPacket(unsigned char	commAddress, int unitKind, unsigned	char *txData)
{
	int txLength;
	unsigned short crc16;
	txLength = 0;
	
	//Data request to KM6015 
	if(commAddress == 1)	//1 = KM6015
	{
		txLength = 8;
		txData[0] = 0x01;
		txData[1] = 0x04;
		txData[2] = 0x00;	//start address high
		txData[3] = 0x82;	//start address low
		txData[4] = 0x00;	//read byte high
		txData[5] = 0x08;	//read byte low
		txData[6] = 0x51;	//CRC high
		txData[7] = 0xE4;	//CRC Low
		//crc16 = Generate_CRC16(txData, 6);
		//txData[6] = (crc16 >> 8) & 0xFF;
		//txData[7] = crc16 & 0xFF;
	}
	else if(commAddress == 10 || commAddress == 11)	//10 = Inverter1, 11 = Inverter2
	{
		if(commAddress == 10 && InverterParmInfo[0].WriteFlag == 1)
		{
			txLength = 8;
			txData[0] = commAddress;
			txData[1] = 6;
			txData[2] = 0x00;
			txData[3] = 0x04;
			// Ҽ  ìܼ ϴ° ʿϰ .    ʿ .  ϴµ  
			txData[4] = (int)((double)INVERTER_MAXIMUM_HZ*(double)InverterParmInfo[0].Speed) >> 8;
			txData[5] = (int)((double)INVERTER_MAXIMUM_HZ*(double)InverterParmInfo[0].Speed) & 0xFF;
			crc16 = Generate_CRC16(txData, 6);
			txData[6] = (crc16 >> 8) & 0xFF;
			txData[7] = crc16 & 0xFF;

			if(InverterParmInfo[0].WriteRetryCount <2)
			{
				InverterParmInfo[0].WriteRetryCount++;
			}
			else
			{
				InverterParmInfo[0].WriteFlag = 0;
				InverterParmInfo[0].WriteRetryCount = 0;
			}
		}
		else if(commAddress == 11 && InverterParmInfo[1].WriteFlag == 1)
		{
			txLength = 8;
			txData[0] = commAddress;
			txData[1] = 6;
			txData[2] = 0x00;
			txData[3] = 0x04;
			txData[4] = (int)((double)INVERTER_MAXIMUM_HZ*(double)InverterParmInfo[1].Speed) >> 8;
			txData[5] = (int)((double)INVERTER_MAXIMUM_HZ*(double)InverterParmInfo[1].Speed) & 0xFF;
			crc16 = Generate_CRC16(txData, 6);
			txData[6] = (crc16 >> 8) & 0xFF;
			txData[7] = crc16 & 0xFF;

			if(InverterParmInfo[1].WriteRetryCount < 2)
			{
				InverterParmInfo[1].WriteRetryCount++;
			}
			else
			{
				InverterParmInfo[1].WriteFlag = 0;
				InverterParmInfo[1].WriteRetryCount = 0;
			}
		}
		else
		{
			if(MachineSetupData.InverterType == INVERTER_TYPE_G100)
			{
				txLength = 8;
				txData[0] = commAddress;
				txData[1] = 4;	
				txData[2] = 0x03;
				txData[3] = 0x11;						
				txData[4] = 0x00;
				txData[5] = 0x01;
				crc16 = Generate_CRC16(txData, 6);
				txData[6] = (crc16 >> 8) & 0xFF;
				txData[7] = crc16 & 0xFF;
			}
			else
			{
				txLength = 8;
				txData[0] = commAddress;
				txData[1] = 4;
				txData[2] = 0xA1;
				txData[3] = 0x08;
				txData[4] = 0x00;
				txData[5] = 0x01;
				crc16 = Generate_CRC16(txData, 6);
				txData[6] = (crc16 >> 8) & 0xFF;
				txData[7] = crc16 & 0xFF;				
			}			
		}
	}
	else if(commAddress == 12)
	{
		txLength = 8;
		txData[0] = commAddress;
		txData[1] = 4;
		txData[2] = 0xA1;
		txData[3] = 0x08;
		txData[4] = 0x00;
		txData[5] = 0x01;
		crc16 = Generate_CRC16(txData, 6);
		txData[6] = (crc16 >> 8) & 0xFF;
		txData[7] = crc16 & 0xFF;
	}
	return txLength;
}

//add igchoi
void SaveVoltageRatio(unsigned char index, int volt)
{
	int Ratio;

	if((KM6015ConvertVoltage.InitStat < 3) && (index != 0))	//ʱ     1V  KM6015   1V ȯִ  (з¼ Ÿ )
	{
		Ratio = 10000000/volt;						//1V*1000*1000 *10(ݿø)		
		if((Ratio%10) > 5)	Ratio += 10;										//round off
		KM6015ConvertVoltage.VoltageConvertRatio[index] = Ratio/10;
		KM6015ConvertVoltage.InitStat |= index;
	}
}
int ConvertVoltage(unsigned char index, int value)
{
	int Vin, voltage, result;

	Vin = 
	voltage =
	result = 0;
	//(Max Voltage * OutputValue * 1000 / 0xFFFF) (0V(0x0000) ~ 5V(0xFFFF))
	Vin = 5 * value  * 1000 / 0xFFFF;


	//SELMA 1 ~ 4ȣ⿡   Ÿ  ڵ
	if(index < 3)	//index 0 =  / 1 = 1 / 2 = 2 / 3 = µ / 4 = 
	{
		SaveVoltageRatio(index, Vin);

		if(KM6015ConvertVoltage.VoltageConvertRatio[index])
		{
			if(index == 2) // 2   1 ū  1    ϰ ̳° Ȯ
				voltage = KM6015ConvertVoltage.VoltageConvertRatio[index-1] * Vin;
			else
				voltage = KM6015ConvertVoltage.VoltageConvertRatio[index] * Vin;

			voltage *= 0.001;///= 1000;
		}
		else
			voltage = Vin;
			
		//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,9999,KM6015ConvertVoltage.VoltageConvertRatio[1],KM6015ConvertVoltage.VoltageConvertRatio[2]);			
	}
	else
		voltage = Vin;

	//    : Y = 250 - 250 (0 ~ 1000KPa)
	//  1  : Y = -5.065x + 5.065(0 ~ -20.26KPa)
	//	µ  : Y = 20x - 40 ( -20 ~ 60 C)
	//	  : Y = 25x - 25 ( 0 ~ 100%)
	//  Voltage : 0~0xffff ͷκ ȯ Voltage  , KM6015  0V(0x0000) ~ 5V(0xFFFF)
	switch(index)
	{
		case 0:		//
			result = (voltage * 250 - 250000)*0.01;///100;			//  (voltage : x1000 , İ : x1000)
			if((result%10) > 5)	result += 10;				//round off
			result /= 10;									// 
			break;

		case 1:
		case 2:		//1,2
			result = (voltage * (-5065) + 5065000) *0.0001;/// 10000; //  (voltage : x1000 , İ : x1000)  
			if((result%10) > 5)	result -= 10;				//round off
			result /= 10;									// 
			break;

		case 3:		//µ
			result = (voltage * 20 - 40000)*0.1;///10; 			//  (voltage : x1000 , İ : x100)
			break;

		case 4:		//
			result = (voltage * 25 - 25000)*0.1; ///10; 			//  (voltage : x1000 , İ : x100) 	
			break;
	}
	return result;
}
//---------------------------------------------------------------------------
int	DecodePacket(void)
{
  int bValidPacket = 0;
  int dataCount, packetSize;
  unsigned short crc16;
  unsigned char	commAddress;
  short	rpm;
  int tempVal, result;

  if (RS485MasterTransferControlData.RXLength >	2)
  {
	dataCount =	RS485MasterTransferControlData.RXData[2];
	if (dataCount >	RX485_MASTER_RX_BUFFER_SIZE	- (MODBUS_RTU_HEADER_SIZE +	MODBUS_RTU_CRC_SIZE))
	{
	  RS485DebugInfo.SizeErrorCount[RS485MasterUnitControlData.CurrentCommUnitIndex]++;
	  return 0;
	}

	commAddress	= RS485MasterTransferControlData.RXData[0];

	if (RS485MasterUnitControlData.CommAddress[RS485MasterUnitControlData.CurrentCommUnitIndex]	== commAddress)
	{
		bValidPacket = 1;

		//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,11111,commAddress,11111);
		if(commAddress == 1)		// 1 = KM6015 : а, а, µT1 T2 T3,  
		{		
			//KM 6015 CH0 , positive pressure 
			tempVal = ((int)RS485MasterTransferControlData.RXData[3] << 8) | ((int) RS485MasterTransferControlData.RXData[4]);
			result = ConvertVoltage(0, tempVal);
			MonitoringInfo.Pressure[0] = (short)result;

			//KM 6015 CH1, negative pressure Ch1
			tempVal = ((int)RS485MasterTransferControlData.RXData[5] << 8) | ((int) RS485MasterTransferControlData.RXData[6]);
			result = ConvertVoltage(1, tempVal);
			MonitoringInfo.Pressure[1] = (short)result;
			MonitoringInfo.DotPos[1] = 1;

			//KM 6015 CH2, negative pressure Ch2
			tempVal = ((int)RS485MasterTransferControlData.RXData[7] << 8) | ((int) RS485MasterTransferControlData.RXData[8]);
			result = ConvertVoltage(2, tempVal);
			MonitoringInfo.Pressure[2] = (short)result;
			MonitoringInfo.DotPos[2] = 1;

			//KM 6015 CH3, Rack Temperature 1
			tempVal = ((int)RS485MasterTransferControlData.RXData[9] << 8) | ((int) RS485MasterTransferControlData.RXData[10]);
			result = ConvertVoltage(3, tempVal);
			MonitoringInfo.TemperatureData[0] = (short)result;							//° ڸ 
			
			//KM 6015 CH4, Rack Humidity
			tempVal = ((int)RS485MasterTransferControlData.RXData[11] << 8) | ((int) RS485MasterTransferControlData.RXData[12]);
			result = ConvertVoltage(4, tempVal);		
			MonitoringInfo.HumidityData[0] = (short)result;							//° ڸ 
			
			//KM 6015 CH5, Control panel Temperature 2
			tempVal = ((int)RS485MasterTransferControlData.RXData[13] << 8) | ((int) RS485MasterTransferControlData.RXData[14]);
			result = ConvertVoltage(3, tempVal);
			MonitoringInfo.TemperatureData[1] = (short)result;							//° ڸ 
			MonitoringInfo.HumidityData[1] = 0;
			
			//KM 6015 CH6, Ring Blower Temperature 3
			tempVal = ((int)RS485MasterTransferControlData.RXData[15] << 8) | ((int) RS485MasterTransferControlData.RXData[16]);
			result = ConvertVoltage(3, tempVal);
			MonitoringInfo.TemperatureData[2] = (short)result;							//° ڸ 
			MonitoringInfo.HumidityData[2] = 0;
		}
		else if(commAddress == 10 || commAddress == 11) //10 = inverter1, 11 = inverter2
		{
			if(commAddress == 10 &&  InverterParmInfo[0].WriteFlag == 1)
			{
				
			}
			else if(commAddress == 11 && InverterParmInfo[1].WriteFlag == 1)
			{
				
			}
			else
			{
				rpm =	((short)RS485MasterTransferControlData.RXData[3] <<	8) | ((short) RS485MasterTransferControlData.RXData[4]);

				MonitoringInfo.InverterRPM[RS485MasterUnitControlData.CurrentCommUnitIndex - 6] =	rpm;
			}
		}
		else if(commAddress == 12)
		{
			rpm =	((short)RS485MasterTransferControlData.RXData[3] <<	8) | ((short) RS485MasterTransferControlData.RXData[4]);
			MonitoringInfo.InverterRPM[RS485MasterUnitControlData.CurrentCommUnitIndex - 6] =	rpm;
		}
	}
	else
	{
	  RS485DebugInfo.WrongAddressCount[RS485MasterUnitControlData.CurrentCommUnitIndex]++;
	}
  }
  else
  {
	RS485DebugInfo.ReceiveTOCount[RS485MasterUnitControlData.CurrentCommUnitIndex]++;
  }

  return bValidPacket;
}
//---------------------------------------------------------------------------


