#ifndef _SERVO_MOTOR_H_
#define _SERVO_MOTOR_H_

#define SERVO_MOTOR_COUNT					5

#define SERVO_MOTOR_MAX_SPEED_VALUE			25000000

#define MOTOR_STATUS_NONE					0
#define MOTOR_STATUS_OFF					1
#define MOTOR_STATUS_HOLD_ON				2
#define MOTOR_STATUS_RUN					3
#define MOTOR_STATUS_ACC					4
#define MOTOR_STATUS_DEC					5
#define MOTOR_STATUS_RUN_WAITING			6
#define MOTOR_STATUS_HOLD_WAITING			7
#define MOTOR_STATUS_OFF_WAITING			8
#define MOTOR_STATUS_ALARM					9

typedef struct 
{
	int AccTime;
	int DecTime;
	int Direction;
	int PrevSpeed;
	int CurrentSpeed;
	int TargetSpeed;
	unsigned int AccStartTime;
	unsigned int DecStartTime;
	int Status;
	int IsHoldOff;
	int AutoHoldOff;	
	int ServoOnWaitingCount;
	int ServoOffWaitingCount;
	volatile unsigned short *IO_CTRL_ADDR;
	volatile unsigned short *IO_PULSE_ADDR_H;
	volatile unsigned short *IO_PULSE_ADDR_L;
	unsigned char ServoOnPortIndex;
	unsigned char EncoderIndex;
	unsigned short IOCtrlValue;
	unsigned short IOCtrlDirMask;
	unsigned short IOCtrlPulseOnMask;
	unsigned int LastCheckEncoderTime;
	int MidTermMotorRPM;
	short TempEncoderVal;
	char OldAbsEncoderReadValue;
	unsigned int AbsEncoderVal;
	unsigned int LastCheckEncoderValue;
	int MinSpeedValue;
}TServoMotorInfo;
extern int Moter3SpeedChangeOn;
extern TServoMotorInfo ServoMotorInfo[SERVO_MOTOR_COUNT];
//extern int SpeedCheckFlag; //sjm add For RunTime
//extern int LengthCheckFlag; //sjm add For RunTime
//extern int InsEjectorTime;
//extern int DefEjectorTime;
#endif
