#include "slave.h"
#include "com.h"
#include "fa_usb.h"
#include "command.h"
#include "flash.h"
#include "environment.h"
#include "port.h"
#include "machineControl.h"
#include "timer.h"
#include "master.h"
#include "tablet_counter.h"
#include "system_setup.h"
#include "capture.h"
#include "tablet_control.h"
#include "HCB_System_Process.h"
#include "rs485master.h"

unsigned char GlobalUSBBuffer[1024];

#define ECHO_BUFFER_MAX_SIZE		4 * 1024 * 1024

#pragma DATA_SECTION(EchoBuffer, ".sdram");
#pragma DATA_ALIGN(EchoBuffer, 1024);
unsigned char EchoBuffer[ECHO_BUFFER_MAX_SIZE];
#pragma DATA_ALIGN(GlobalUSBRXBuffer, 8);
unsigned char GlobalUSBRXBuffer[1024];
#pragma DATA_ALIGN(DummyUSBRXBuffer, 8);
unsigned char DummyUSBRXBuffer[1024];

TSlaveInfo SlaveInfo_App;

//----------------------------------------------------------
unsigned char *GetRXSmallDataAddress(TUSBDataHeader *rxPacket, unsigned int *bufferMaxSize)
{
	if (rxPacket->RequestKind == CMD_TYPE_APP_REQUEST)
	{
		if (SlaveInfo_App.Status != SLAVE_STATUS_IDLE)
		{
			return NULL;
		}
		else
		{
			switch(rxPacket->Command)
			{
				default:
					*bufferMaxSize = 1024;
					return GlobalUSBRXBuffer;
			}
		}
	}
	else
	{
		return NULL;
	}
}
//----------------------------------------------------------   
unsigned char *GetRXLargeDataAddress(TUSBDataHeader *rxPacket, unsigned int *bufferMaxSize)
{
	if (rxPacket->Command == CMD_ECHO)
	{
		*bufferMaxSize = ECHO_BUFFER_MAX_SIZE;
		return (unsigned char *)EchoBuffer;		
	}
	else if (rxPacket->Command == CMD_DOWNLOAD)
	{
		*bufferMaxSize = DOWNLOAD_MAX_SIZE;
		return (unsigned char *)ProgramBuffer;		
	}
	else
	{
		*bufferMaxSize = 0;
		return NULL;
	}
}
//----------------------------------------------------------

unsigned int OnReceiveRS232Packet(unsigned short command, 
	unsigned int *data, int dataSize_Word, unsigned int *returnData)
{
	int returnDataSize = 0;
	if (command == CMD_ECHO)
	{
		memcpy(returnData, data, dataSize_Word * 4);
		returnDataSize = dataSize_Word;
	}
	return returnDataSize;
}
//----------------------------------------------------------
void Slave_Packet_Interpret_App(unsigned short command,
	unsigned char *smallData, unsigned int smallDataSize, 
	unsigned char *largeData, unsigned int largeDataSize, 
	unsigned char **resultSmallDataAddress, unsigned int *resultSmallDataSize, 
	unsigned char **resultLargeDataAddress, unsigned int *resultLargeDataSize)		// called from main loop
{
	*resultSmallDataAddress = (unsigned char *)GlobalUSBBuffer;
	*resultSmallDataSize = 0;
	*resultLargeDataAddress = NULL;
	*resultLargeDataSize = 0;

	if (command == CMD_INSPECTION_RESULT)
	{
		*resultSmallDataAddress = (unsigned char *) &InspectionResultTable;
		*resultSmallDataSize = sizeof(TInspectionResultTable);

		USBCommTimeout = 0;
	}
	else if (command == CMD_STATUS)
	{
		int statusKind;
		statusKind = *(int *)smallData;
		if (statusKind == HCB_STATUS_KIND_MACHINE)		// machine status
		{
			*resultSmallDataAddress = (unsigned char *) &MachineStatus;
			*resultSmallDataSize = sizeof(TMachineStatus);
		}
		else if (statusKind == HCB_STATUS_KIND_ALARM)	// alarm status
		{
			*resultSmallDataAddress = (unsigned char *) &MachineAlarmState;
			*resultSmallDataSize = sizeof(TMachineAlarmState);
		}
		else if (statusKind == HCB_STATUS_KIND_WARNING)	// warning status
		{
			*resultSmallDataAddress = (unsigned char *) &MachineWarningState;
			*resultSmallDataSize = sizeof(TMachineWarningState);
		}
	}
	else if (command == CMD_MONITORING_DATA)
	{
		*resultSmallDataAddress = (unsigned char *) &MonitoringInfo;
		*resultSmallDataSize = sizeof(TMonitoringInfo);
	}
	else if (command == CMD_PORT_READ)
	{
		memcpy(GlobalUSBBuffer, InputPortValue, sizeof(unsigned short) * 4);
		memcpy(GlobalUSBBuffer + 4 * sizeof(unsigned short), OutputPortValue, sizeof(unsigned short) * 4);
		memcpy(GlobalUSBBuffer + 8 * sizeof(unsigned short), EncoderValue, sizeof(unsigned short) * 10);
		*resultSmallDataSize = sizeof(unsigned short) * 18;
	}
	else if (command == CMD_TABLET_INSPECT_INFO)
	{
		int requestNum;

		requestNum = *(int *)smallData;

		if (requestNum == 1)
		{
			*resultSmallDataAddress = (unsigned char *)&TabletInspectInfo;
			*resultSmallDataSize = sizeof(TTabletInspectInfo);
		}
	}
	else if (command == CMD_TABLET_PROCESS_INFO)
	{
		int requestNum;

		requestNum = *(int *)smallData;

		if (requestNum == 1)
		{
			*resultSmallDataAddress = (unsigned char *)&TabletInfo;
			*resultSmallDataSize = sizeof(TTabletInfo);
		}
	}
	else if (command == CMD_VIBRATOR_INFO)
	{
		*resultSmallDataAddress = (unsigned char *)&VibratorInfo;
		*resultSmallDataSize = sizeof(TVibratorInfo);
	}
	else if (command == CMD_MACHINE_CONTROL)
	{
		MC_DecodeMachineControl(smallData);
	}
	else if (command == CMD_READ_PORT_STATUS)
	{
		*resultSmallDataAddress = (unsigned char *) &PortStatus;
		*resultSmallDataSize = sizeof(TPortStatus);
	}
	else if (command == CMD_IDLE_PROCESS_INFO)
	{
		*resultSmallDataAddress = (unsigned char *) &IdleProcessData;
		*resultSmallDataSize = sizeof(TIdleProcessData);
	}
	else if (command == CMD_MACHINE_CAPTURE)
	{
		TMachineCaptureSetupData *machineCaputreSetupData;		
		machineCaputreSetupData = (TMachineCaptureSetupData *) smallData;
		TabletControl_Capture_Start(machineCaputreSetupData->SuctionDiskSpeed, machineCaputreSetupData->StudiedTabletSensorLength, machineCaputreSetupData->IlluminatorMask,machineCaputreSetupData->TabletSideThick, machineCaputreSetupData->TabletSideThick, machineCaputreSetupData->CaptureOption);
	}
	else if (command == CMD_PORT_TEST)
	{
		int mode;
		int portIndex;
		int value;
		TOPTestData *opTestData;
		mode = *((int *)smallData);
		if (mode == 0)
		{			
			portIndex = *((int *)smallData + 1);
			value = *((int *)smallData + 2);
			PORT_ModifyPhysicalOutPort(portIndex, value);
		}
		else
		{
			opTestData = (TOPTestData *)((int *)smallData + 1);
			if (opTestData->TestCount == 0)
			{
				MC_OPTest_Stop();
			}
			else
			{
				MC_OPTest_Start(opTestData->TestCount, opTestData->OPList, 
                                opTestData->IsPhysicalPort,opTestData->DelayIntervalList, 
                                opTestData->OnIntervalList,opTestData->OffIntervalList);
			}
		}
	}	
	else if (command == CMD_CHECK_SENSOR_INTERVAL)
	{
		int func;
		float tabletLength;
		int suctionDiskSpeed;
		int studiedTabletSensorLength;
		func = *(int *) smallData;
		if (func == 0)
		{
			TabletControl_Stop();
		}
		else if (func == 1)
		{
			tabletLength = *((float *)smallData + 1);
			suctionDiskSpeed = *((int *)smallData + 2);
			studiedTabletSensorLength = *((int *)smallData + 3);
			TabletControl_CheckInerval_Start(suctionDiskSpeed, studiedTabletSensorLength);
		}
	}
	else if (command == CMD_TABLET_TEST)
	{
		int func;
		func = *(int *) smallData;
		if (func == 0)
		{
			TabletControl_Stop();
		}
		else if (func == 1)
		{
			TabletControl_CheckInerval_Start();
		}
	}
	else if (command == CMD_STUDY_READY)
	{
		int suctionDiskSpeed;
		int studiedTabletSensor1Length;
		int studiedTabletSensor2Length;
		int studiedSensorIntervalA;
		int studiedSensorIntervalB;
		int studyOption;

		suctionDiskSpeed = *((int *)smallData);
		studiedTabletSensor1Length = *((int *)smallData + 1);
		studiedTabletSensor2Length = *((int *)smallData + 2);
		studiedSensorIntervalA = *((int *)smallData + 3);
		studiedSensorIntervalB = *((int *)smallData + 4);
		studyOption = *((int *)smallData + 5);
		TabletControl_Study_Start(suctionDiskSpeed, studiedTabletSensor1Length, studiedTabletSensor2Length, 
		                            studiedSensorIntervalA, studiedSensorIntervalB, studyOption);
	}
	else if (command == CMD_STUDY_END)
	{
		TabletControl_Stop();
	}
	else if (command == CMD_TABLET_COUNTER_READY)
	{
		int suctionDiskSpeed;
		int studiedTabletSensor1Length;
		int studiedTabletSensor2Length;
		int studiedSensorIntervalA;
		int studiedSensorIntervalB;
		char defectGenEnabled, defectGenKind, uninsGenEnabled, uninsGenKind;
		unsigned int defectGenMask, uninsGenMask;
		int defectGenMaskCount, defectGenRatio, uninsGenMaskCount, uninsGenRatio;
		suctionDiskSpeed = *((int *) smallData);
		studiedTabletSensor1Length = *((int *) smallData + 1);
		studiedTabletSensor2Length = *((int *) smallData + 2);
		studiedSensorIntervalA = *((int *) smallData + 3);
		studiedSensorIntervalB = *((int *) smallData + 4);
		defectGenEnabled = *((char *) smallData + 20);
		defectGenKind = *((char *) smallData + 21);
		uninsGenEnabled = *((char *) smallData + 22);
		uninsGenKind = *((char *) smallData + 23);
		defectGenMask = *((unsigned int *) smallData + 6);
		defectGenMaskCount = *((int *) smallData + 7);
		defectGenRatio = *((int *) smallData + 8);
		uninsGenMask = *((unsigned int *) smallData + 9);
		uninsGenMaskCount = *((int *) smallData + 10);
		uninsGenRatio = *((int *) smallData + 11);
		TabletControl_Tablet_Counter_Start(suctionDiskSpeed, studiedTabletSensor1Length, studiedTabletSensor2Length, studiedTabletSensor2Length,
			studiedSensorIntervalA, studiedSensorIntervalB, defectGenEnabled, defectGenKind, uninsGenEnabled, uninsGenKind, 
			defectGenMask, defectGenMaskCount, defectGenRatio, uninsGenMask, uninsGenMaskCount, uninsGenRatio);
	}
	else if (command == CMD_INSPECTION_READY)
	{
		THCBInspectionOption *hcbInspectionOption;
		TTabletInspectInfo *tabletInspectInfo;
		hcbInspectionOption = (THCBInspectionOption *) smallData;
		tabletInspectInfo = (TTabletInspectInfo *)((unsigned char *) smallData + sizeof(THCBInspectionOption));
		TabletControl_Inspection_Start(hcbInspectionOption, tabletInspectInfo);
	}
	else if (command == CMD_INSPECTION_END)
	{
		TabletControl_Stop();
	}
	else if (command == CMD_MACHINE_CAPTURE_STOP)
	{
		TabletControl_Stop();
	}
	else if (command == CMD_INSPECTION_RESUME)
	{
		TabletControl_ContinueInspection(smallData);
	}
	else if (command == CMD_UNMANED_OPERATION)
	{
		MC_UnmanedOperation((TUnmanedOperationData *)smallData);
	}
	else if (command == CMD_READ_UNMANED_OPERATION_INFO)
	{
		*resultSmallDataAddress = (unsigned char *)&UnmanedOperationData;
		*resultSmallDataSize = sizeof(TUnmanedOperationData);
	}
	else if (command == CMD_TABLET_COUNTER)
	{
		int func;
		func = *((int *)smallData);
		if (func == 0)
		{
			TabletCounter_Reset();
			SimpleTabletCounter_Reset();
		}
		else if (func == 1)
		{
			TabletCounter_Ready(1);
		}
		else if (func == 2)
		{
			TabletCounter_Sleep();
		}
		else if (func == 5)
		{
			TabletCounter_Ready(0);
		}
		else if (func == 3)
		{			
			*((unsigned int *)GlobalUSBBuffer) = TabletCounter.Counter;
			*resultSmallDataSize = sizeof(unsigned int);
		}
		else if (func == 4)
		{			
			*resultLargeDataAddress = (unsigned char *)&TabletCounter;
			*resultLargeDataSize = sizeof(TTabletCounter);
		}
		else if (func == 6)
		{			
			*resultSmallDataAddress = (unsigned char *)&SimpleTabletCounter;
			*resultSmallDataSize = sizeof(TSimpleTabletCounter);
		}
	}
	else if (command == CMD_TABLET_CAPTURE)
	{
		TCaptureCommandParam_HCB *captureCommandParam;
		captureCommandParam = (TCaptureCommandParam_HCB *)smallData;
		if (captureCommandParam->Action == 0)
		{
			HCB_Capture_Stop();
		}
		else if (captureCommandParam->Action == 1)
		{
			HCB_Capture_Ready(captureCommandParam->FrameTime, captureCommandParam->LEDMask, captureCommandParam->LEDDelay, captureCommandParam->LEDOnTime, captureCommandParam->ShutterDelay);
		}		
		else if (captureCommandParam->Action == 2)
		{
			HCB_Capture_Ready_Multi(captureCommandParam->FrameTime, captureCommandParam->LEDMask, captureCommandParam->LEDDelay, captureCommandParam->LEDOnTime, captureCommandParam->ShutterDelay);
		}		
	}
	else if (command == CMD_TERMINATION_INFO)
	{
		*resultSmallDataAddress = (unsigned char *)&TerminationInfo;
		*resultSmallDataSize = sizeof(TTerminationInfo);
	}
	else if (command == CMD_INVALIDATE_TERMINATION_INFO)
	{
		InvalidateTerminationInfo();
	}
	else if (command == CMD_CAMERA_RESET)
	{
		int action;
		int hcbCamIndex;
		action = *(int *)smallData;
		hcbCamIndex = *((int *)smallData + 1);
		if (hcbCamIndex == 0)
		{
			if (action == 0)
			{
				PORT_ModifyOutPort(OP_3D_CAMERA_1_RESET, 0);
			}
			else
			{
				PORT_ModifyOutPort(OP_3D_CAMERA_1_RESET, 1);
			}
		}
		else
		{
			if (action == 0)
			{
				PORT_ModifyOutPort(OP_3D_CAMERA_2_RESET, 0);
			}
			else
			{
				PORT_ModifyOutPort(OP_3D_CAMERA_2_RESET, 1);
			}
		}
	}
	else if (command == CMD_LED_CHANGE)
	{
		int ledMask = *(unsigned int *)smallData;
		HCB_Capture_LEDChange(ledMask);
	}
	else if (command == CMD_SERVO_MOTOR)
	{	
		int motorIndex;
        int moveSpeed;
        int accTime;
        int decTime;
		int dir;
		unsigned int motorAction;
		motorIndex = *((int *)smallData);
		motorAction = *((unsigned int *)smallData + 1);	
		if (motorAction == 1)
		{
			moveSpeed = *((int *)smallData + 2);
			accTime = *((int *)smallData + 3);
			dir = *((int *)smallData + 4);
			Servo_Motor_Run_Param(motorIndex, accTime, dir, moveSpeed);
		}
		else if (motorAction == 2)
		{
			decTime = *((int *)smallData + 2);
			Servo_Motor_Stop_Param(motorIndex, decTime);
		}
		else if (motorAction == 3)
		{
			Servo_Motor_ServoOn(motorIndex);
		}
		else if (motorAction == 4)
		{
			Servo_Motor_ServoOff(motorIndex);
		}
	}
	else if (command == CMD_ALARM_RESET)
	{
		MC_Alarm_Reset();
	}
	else if (command == CMD_BUZZER_OFF)
	{
		MC_BuzzerControl_Stop();
	}
	else if (command == CMD_SET_MACHINE_MODE)
	{
		int machineControlMode;
		machineControlMode = *(int *)smallData;
		MC_SetMachineControlMode(machineControlMode);
	}
	else if (command == CMD_PORT_SETUP)
	{
		PORT_Setup(smallData);
	}
	else if (command == CMD_PORT_AO_WRITE)
	{
		unsigned short aoIndex = *(unsigned short *)smallData;
		unsigned short aoValue = *((unsigned short *)smallData + 1);
		PORT_AO_Write(aoIndex, aoValue);
	}
	else if (command == CMD_MACHINE_PARAM_SETUP)
	{
		memcpy(&MachineSetupData, smallData, sizeof(TMachineSetupData));
		WriteSystemSetup();
		ApplySystemSetup();
	}
	else if (command == CMD_USER_MACHINE_ENV_SETUP)
	{
		memcpy(&UserMachineEnv, smallData, sizeof(TUserMachineEnv));
		WriteUserEnv();
	}
	else if (command == CMD_DOWNLOAD)
	{
		unsigned int pID;
		int time;
		pID = *(unsigned int *)smallData;
		time = *((int *)smallData + 1);
		WriteToFlash(pID, largeData, largeDataSize, time);
	}
	else if (command == CMD_RESET)
	{
		System_Reset_Trigger_Time = Board1MSTmr;
		System_Reset_SW = TRUE;		
	}
	else if (command == CMD_FLASH_INFO)
	{
		*resultSmallDataAddress = (unsigned char *) GetFileSystem();
		*resultSmallDataSize = sizeof(TFFSystem);
	}
	else if (command == CMD_FLASH_FORMAT)
	{
		FlashFormat();
	}
	else if (command == CMD_MCBSP_TEST)
	{
		int func;
		int dataSize;
		int frequency;
		int spbMask;
		func = *((int *)smallData);
		if (func == 0)
		{
			Master_McBSPTest_Stop();
		}
		else if (func == 1)
		{
			dataSize = *((int *)smallData + 1);
			frequency = *((int *)smallData + 2);
			spbMask = *((int *)smallData + 3);
			Master_McBSPTest_Start(dataSize, frequency, spbMask);
		}
	}
	else if (command == CMD_MCBSP_TEST_RESULT)
	{
		*resultSmallDataAddress = (unsigned char *) &McBSPTestResultData;
		*resultSmallDataSize = sizeof(TMcBSPTestResultData);
	}
	else if (command == CMD_MCBSP_DEBUG_INFO)
	{
		*resultSmallDataAddress = (unsigned char *) &McbspDebugInfo;
		*resultSmallDataSize = sizeof(McbspDebugInfo);
	}
	else if (command == CMD_VERSION_INFO)
	{
		*resultSmallDataAddress = (unsigned char *)&ProgramVersion;
		*resultSmallDataSize = sizeof(TProgramVersion);
	}
	else if (command == CMD_ECHO)
	{
		*resultSmallDataAddress = smallData;
		*resultSmallDataSize = smallDataSize;
		*resultLargeDataAddress = largeData;
		*resultLargeDataSize = largeDataSize;
	}
	else if (command == CMD_RS485_TEST)
	{
		RS485_Test(smallData, smallDataSize);
	}
	else if (command == CMD_RS485_TEST_STATUS)
	{
		*(int *)GlobalUSBBuffer = RS485MasterTestData.Status;
		*((int *)GlobalUSBBuffer + 1) = RS485MasterTestData.RXLength;
		*resultSmallDataAddress = (unsigned char *)GlobalUSBBuffer;
		*resultSmallDataSize = sizeof(int) * 2;
	}
	else if (command == CMD_RS485_TEST_RX_DATA)
	{
		*resultSmallDataAddress = (unsigned char *) RS485MasterTestData.RXData;
		*resultSmallDataSize = RX485_MASTER_RX_BUFFER_SIZE;
	}
	else if (command == CMD_RS485_DEBUG_INFO)
	{
		*resultSmallDataAddress = (unsigned char *) &RS485DebugInfo;
		*resultSmallDataSize = sizeof(TRS485DebugInfo);
	}
	else if (command == CMD_READ_ERROR_LIST)
	{
		int maxCount;
		int getCount;
		maxCount = *(int *) smallData;
		if (maxCount > 16) maxCount = 16;
		getCount = ErrorQueue_Get(GlobalUSBBuffer + sizeof(int), maxCount);
		ErrorQueue_Remove(getCount);
		*(int *)GlobalUSBBuffer = getCount;
		*resultSmallDataAddress = (unsigned char *)GlobalUSBBuffer;
		*resultSmallDataSize = getCount * sizeof(TErrorUnit) + sizeof(int);
	}
	else if (command == CMD_READ_PROGRAM_HEADER)
	{
		*resultSmallDataAddress = (unsigned char *)&HCBProgramHeader;
		*resultSmallDataSize = sizeof(THCBProgramHeader);
	}
	else if (command == CMD_READ_DB_HEADER)
	{
		*resultSmallDataAddress = (unsigned char *)&HCBDBHeader;
		*resultSmallDataSize = sizeof(THCBDBHeader);
	}
	else if (command == CMD_READ_MS_HEADER)
	{
		*resultSmallDataAddress = (unsigned char *)&HCBMachineSpecificHeader;
		*resultSmallDataSize = sizeof(THCBMachineSpecificHeader);
	}
	else if (command == CMD_READ_COMPATIBILITY)
	{
		*resultSmallDataAddress = (unsigned char *)&HCBCompatibility;
		*resultSmallDataSize = sizeof(THCBCompatibility);
	}
	else if (command == CMD_WRITE_MS_HEADER)
	{
		THCBMachineSpecificHeader *hcbMachineSpecificHeader = (THCBMachineSpecificHeader *) smallData;
		WriteHCBMSHeader(hcbMachineSpecificHeader);
	}
	else if (command == CMD_READ_MACHINE_INFO)
	{
		*resultSmallDataAddress = (unsigned char *)&MachineSetupData;
		*resultSmallDataSize = sizeof(TMachineSetupData);
	}
	else if (command == CMD_READ_USER_MACHINE_ENV)
	{
		*resultSmallDataAddress = (unsigned char *)&UserMachineEnv;
		*resultSmallDataSize = sizeof(TUserMachineEnv);
	}
	else if (command == CMD_READ_PORT_MAP_INFO)
	{
		*resultSmallDataAddress = (unsigned char *)&PortMapInfo;
		*resultSmallDataSize = sizeof(TPortMapInfo);
	}
	else if (command == CMD_LONG_WORK)
	{
		Sleep(2000);
	}
	else if (command == CMD_VIRTUAL_INSPECTION_START)
	{
		SimulationInspectionPeriod = *((int *)smallData);
		SimulationInspectionSW = 1;
	}	
	else if (command == CMD_VIRTUAL_INSPECTION_REFRESH)
	{
		SimulationInspectionPeriod = *((int *)smallData);
	}
	else if (command == CMD_VIRTUAL_INSPECTION_END)
	{
		SimultationStopWaiting = 1;
		SimulationInspectionSW = 0;
		SimulationInspectionPeriod = 0;
	}

}
//----------------------------------------------------------
void Slave_Process(void)
{
	if (SlaveInfo_App.Status == SLAVE_STATUS_OCCURED)
	{
		SlaveInfo_App.Status = SLAVE_STATUS_PROCESSING;
		Slave_Packet_Interpret_App(SlaveInfo_App.Command,
			SlaveInfo_App.SmallDataAddress, SlaveInfo_App.SmallDataSize,
			SlaveInfo_App.LargeDataAddress, SlaveInfo_App.LargeDataSize,
			&(SlaveInfo_App.ResultSmallDataAddress), &(SlaveInfo_App.ResultSmallDataSize), 
			&(SlaveInfo_App.ResultLargeDataAddress), &(SlaveInfo_App.ResultLargeDataSize));
		SlaveInfo_App.Status = SLAVE_STATUS_PROCESSING_COMPLETE;
	}
}
//----------------------------------------------------------
int CheckProcessingComplete(void)	
{	// called from system loop
	if (SlaveInfo_App.Status == SLAVE_STATUS_PROCESSING_COMPLETE) return 1;
	else return 0;
}
//----------------------------------------------------------
int OnReceiveUSBPacket_App(unsigned short command, 		
	unsigned char *smallData, unsigned int smallDataSize, 
	unsigned char *largeData, unsigned int largeDataSize)
{	
	if (SlaveInfo_App.Status != SLAVE_STATUS_IDLE)
	{
		return PACKET_RESPONSE_BUSY;
	}
	else
	{
		SlaveInfo_App.Status = SLAVE_STATUS_OCCURED;
		SlaveInfo_App.Command = command;
		SlaveInfo_App.SmallDataAddress = smallData;
		SlaveInfo_App.SmallDataSize = smallDataSize;
		SlaveInfo_App.LargeDataAddress = largeData;
		SlaveInfo_App.LargeDataSize = largeDataSize;
	}
	HARDWARE_Lamp2Toggle();
	return PACKET_RESPONSE_OK;
}
//----------------------------------------------------------
void GetProcessingResult(		
	unsigned char **responseSmallDataAddress, unsigned int *responseSmallDataSize,
	unsigned char **responseLargeDataAddress, unsigned int *responseLargeDataSize)
{	// called from sysetm loop
	*responseSmallDataAddress = SlaveInfo_App.ResultSmallDataAddress;
	*responseSmallDataSize = SlaveInfo_App.ResultSmallDataSize;
	*responseLargeDataAddress = SlaveInfo_App.ResultLargeDataAddress;
	*responseLargeDataSize = SlaveInfo_App.ResultLargeDataSize;
	SlaveInfo_App.Status = SLAVE_STATUS_IDLE;
}
//----------------------------------------------------------
void InitSlave(void)
{
	SlaveInfo_App.Status = SLAVE_STATUS_IDLE;
}
//----------------------------------------------------------
