#ifndef _SLAVE_H_
#define _SLAVE_H_

#include "com.h"

unsigned char *GetRXSmallDataAddress(TUSBDataHeader *rxPacket, unsigned int *bufferMaxSize);
unsigned char *GetRXLargeDataAddress(TUSBDataHeader *rxPacket, unsigned int *bufferMaxSize);
void InitSlave(void);


#define SLAVE_STATUS_IDLE					0
#define SLAVE_STATUS_OCCURED				1
#define SLAVE_STATUS_PROCESSING				2
#define SLAVE_STATUS_PROCESSING_COMPLETE	3


typedef struct 
{
	unsigned short Command;
	unsigned char *SmallDataAddress;
	unsigned int SmallDataSize;
	unsigned char *LargeDataAddress;
	unsigned int LargeDataSize;
	unsigned char *ResultSmallDataAddress;
	unsigned int ResultSmallDataSize;
	unsigned char *ResultLargeDataAddress; 
	unsigned int ResultLargeDataSize;
	int Status;
} TSlaveInfo;

extern TSlaveInfo SlaveInfo_App;

#endif
