#ifndef _STEP_MOTOR_H_
#define _STEP_MOTOR_H_

#include "common.h"

#define STEP_MOTOR_CONTROL_MODE_INTERLOCK		0
#define STEP_MOTOR_CONTROL_MODE_FREE			1


#define STEP_MOTOR_STATE_IDLE					0
#define STEP_MOTOR_STATE_HOME_FIRST_MOVE		1
#define STEP_MOTOR_STATE_HOME_SECOND_MOVE		2
#define STEP_MOTOR_STATE_HOME_REVERSE_MOVE		3
#define STEP_MOTOR_STATE_MOVING					4
#define STEP_MOTOR_STATE_BREAKING				5
#define STEP_MOTOR_STATE_STALL					6
#define STEP_MOTOR_STATE_ERROR					0xFF


typedef struct
{
	char State;
	char Bit;
	char HomeDetected;
	char Direction;		// must be bit value (0 or 1)
	char HomeDir;
	char EncoderPlusDir;
	char EncoderMinusDir;
	char EncoderIndex;
	unsigned char MinusLimitPortIndex;
	unsigned char HomePortIndex;
	unsigned char PlusLimitPortIndex;
	unsigned char EncoderMinusLimitPortIndex;
	unsigned char EncoderPlusLimitPortIndex;
	unsigned short Ctrl;
	volatile unsigned short *ControlAddr;
	int PulseRemain;
	int FeedDelay;

	short FeedAccPulseCount;
	int FeedDelayCount;
	int CurrentFeedAddVal;
	int MaxFeedAddVal;
	int MinFeedAddVal;
	int FeedAccChangeVal;
	int OldEncoderVal;
	int AbsEncoderVal;
	short TempEncoderVal;
	short FeedChangeCount;
	int TargetPos;
	int MotorPulseCount;
	int EncoderPulseCount;
	int GeneratedPulseCount;
	int StartPos;
	int NCPosParamMul;
	int NCPosParamDiv;
	unsigned short PulseCounter;
} TStepMotorData; 

extern TStepMotorData StepMotorData[MAX_STEP_MOTOR_COUNT];
extern int StepMotorControlMode;

#endif
