#include "system_setup.h"
#include "common.h"
#include "servo_motor.h"
#include "environment.h"
#include "timer.h"
#include "port.h"

#pragma DATA_ALIGN(MachineSetupData, 8)
TMachineSetupData MachineSetupData;
#pragma DATA_ALIGN(UserMachineEnv, 8)
TUserMachineEnv UserMachineEnv;

int SafetCircuitMode_AlreadyInit;

//---------------------------------------------------------------------------
void SystemSetup_InitDefaultMachineInfo(void)
{
	int motorIndex;

	MachineSetupData.MachineMode = MACHINE_MODE_INTERLOCK;
	MachineSetupData.MachineType = MACHINE_TYPE_SELMA_BASIC;
	MachineSetupData.PC_Power_Mode = PC_POWER_MODE_AUTO;

	MachineSetupData.EjectorInfo.DefectEjectorDelay     = 20;
	MachineSetupData.EjectorInfo.UnInsEjectorDelay     = 20;
	MachineSetupData.EjectorInfo.GoodEjectorDelay     = 20; 
	MachineSetupData.EjectorInfo.DefectEjectorLength     = 1;
	MachineSetupData.EjectorInfo.UnInsEjectorLength     = 1;
	MachineSetupData.EjectorInfo.GoodEjectorLength    = 1; 
	MachineSetupData.EjectorInfo.EjectorWindStrength    = 100;
	MachineSetupData.VFInfo.ManualModeSensorIndex               = 0;
	MachineSetupData.VFInfo.ManualModeSensorActiveRatio         = 80;
	MachineSetupData.VFInfo.ManualModeLimitSensorIndex          = 1;
	MachineSetupData.VFInfo.ManualModeLimitSensorActiveRatio    = 30;
	MachineSetupData.VFInfo.EmptySensorActiveRatio              = 80;
	MachineSetupData.VFInfo.FullSensorActiveRatio               = 80;
	MachineSetupData.VFInfo.MechanicalMinSpeed                  = 0;
	MachineSetupData.VFInfo.MechanicalMaxSpeed                  = 255;
	MachineSetupData.IPB_BoardCount								= 6;


	MachineSetupData.SensorIntervalA = 0;
	MachineSetupData.SensorIntervalB = 0;

	MachineSetupData.InterlockInfo.DoorInterlockEnabled = 0;

	for (motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		MachineSetupData.ServoMotorData[motorIndex].AccTime     = 5000;
		MachineSetupData.ServoMotorData[motorIndex].DecTime     = 5000;
		MachineSetupData.ServoMotorData[motorIndex].BaseSpeed   = SERVO_MOTOR_MAX_SPEED_VALUE;
		MachineSetupData.ServoMotorData[motorIndex].Dir         = 0;
	}

	MachineSetupData.SafetyCircuitMode = 0;
	MachineSetupData.Qualis_Machine1_CutomOption = 0;
	MachineSetupData.DiskStartDelay = 0;
	SafetCircuitMode_AlreadyInit = 0;
	MachineSetupData.SuctionDiskGearRatio = 10;
	MachineSetupData.HopperEmptyEnable = 0;
}
//---------------------------------------------------------------------------
void SystemSetup_InitDefaultUserMachineEnv(void)
{
	UserMachineEnv.DustBlower1Interval = 60000;
	UserMachineEnv.DustBlower2Interval = 60000;
	UserMachineEnv.DustBlower3Interval = 60000;
	UserMachineEnv.DustBlower4Interval = 60000;
	UserMachineEnv.DustBlower5Interval = 60000;
	UserMachineEnv.DustBlower1Delay    = 0;
	UserMachineEnv.DustBlower2Delay    = 12000;
	UserMachineEnv.DustBlower3Delay    = 24000;
	UserMachineEnv.DustBlower4Delay    = 36000;
	UserMachineEnv.DustBlower5Delay    = 48000;
	UserMachineEnv.DustBlower1BlowTime = 1000;
	UserMachineEnv.DustBlower2BlowTime = 1000;
	UserMachineEnv.DustBlower3BlowTime = 1000;
	UserMachineEnv.DustBlower4BlowTime = 1000;
	UserMachineEnv.DustBlower5BlowTime = 1000;
	UserMachineEnv.Enabled             = 1;
}
//---------------------------------------------------------------------------

void WriteSystemSetup(void)
{
	WriteToFlash(PID_MACHINE_INFO, (unsigned char *)&MachineSetupData, sizeof(TMachineSetupData), 0);
}
//---------------------------------------------------------------------------
void ApplySystemSetup(void)
{
	int servoMotorIndex;
	MC_ApplyMachineInfo(&MachineSetupData);

	ApplyMachineCaptureSetupData(&(MachineSetupData.MachineCaptureInfo));

	for (servoMotorIndex = 0; servoMotorIndex < MAX_SERVO_MOTOR_COUNT; servoMotorIndex++)
	{
		ServoMotorBaseSpeed[servoMotorIndex] = MachineSetupData.ServoMotorData[servoMotorIndex].BaseSpeed;
	}

	ApplyServoMotorSystemSetup(MachineSetupData.ServoMotorData);
	ApplyServoMotorMinSpeedValue();

	TabletControl_ApplyMachineSetup(&MachineSetupData);
  	MC_Pressure_Regulator_Set(MachineSetupData.EjectorInfo.EjectorWindStrength);

	if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		if(!MachineSetupData.InterlockInfo.ACdomesticMode)
		{
			if(MachineSetupData.Qualis_Machine1_CutomOption == 0)
			{
				if(SafetCircuitMode_AlreadyInit)
				{
					PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_SELECT, MachineSetupData.SafetyCircuitMode);
					PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_RESET, 1);	
					SafetyResetFlag = 1;
				}
				else
				{
					SafetCircuitMode_AlreadyInit = 1;
				}
			}	
		}		
	}

	if(MachineSetupData.CompanyID == DOMESTIC_MACHINE3) // SELMA PLUSE TEST
	{
		PRESSURE_REGULATOR_AO_INDEX=1;
		VF_SPEED_AO_INDEX=2;
		VF_HOPPER_SPPED_AO_INDEX = 3;
	}
}
//---------------------------------------------------------------------------
void WriteUserEnv(void)
{
	WriteToFlash(PID_USER_MACHINE_ENV, (unsigned char *)&UserMachineEnv, sizeof(TUserMachineEnv), 0);
}

