#include "tablet_control.h"
#include "timer.h"
#include "port.h"
#include "hardware.h"
#include "machineControl.h"
#include "HCB_System_Process.h"
#include "environment.h"
#include "servo_motor.h" //sjm add For RunTime
#include "common.h" // Use CompanyMachineCode Define
#include "system_setup.h"
#include "capture.h"

#include <csl_intc.h>
#include <csl_intcAux.h>
#define	TABLET_NUMBER_VALID_INTERVAL				600

#define	TABLET_FEEDING_DELAY						30000	// 30 secs

#define	SENSOR_INTERVAL_LIMIT						100		// +- 100 *	50us

#define	INSPECTION_CHECKING_TIME					200000 // 200000 * 50us = 10s
#define	INSPECTION_CHECKING_MIN_TABLET_COUNT		50

#define	CRIT_UNINS_CHECKING_TIME					40000 // 40000 * 50us = 2s
#define	CRIT_UNINS_CHECKING_MIN_TABLET_COUNT		10
#define	CRIT_UNINS_MACHINE_STOP_RATIO				80

#define	CRIT_DEFECT_CHECKING_TIME					40000 // 40000 * 50us = 2s
#define	CRIT_DEFECT_CHECKING_MIN_TABLET_COUNT		10
#define	CRIT_DEFECT_MACHINE_STOP_RATIO				80


#define	SENSOR_STATE_OFF							0
#define	SENSOR_STATE_ON								1
#define  LASER_TRIG_INTERVAL			60//50us *40 = 2ms

#define	MAX_SENSOR_LENGTH_50US						10000		// 500ms

#define	TABLET_VARIANCE_TIME						2000		// +- 100 ms
#define	BLOWER_PADING_DELAY							100			// +- 5ms
#define	BLOWER_CHECKING_DELAY						4000		// 200ms

#define	SENSOR_MIN_TIME								10			// 500us
#define	SENSOR_DETECT_WIDTH							8

#define	INSPECTION_TIMEOUT_PADING_DELAY				150

#define MAX_SD_ENCODER_VALUE						819200.0 // 54rpm  , ѹ  ð 1111ms, 30400 encoder  ޽ð  						
#define DISK_54RPM_PER_US							1112140.0 // 54rpm  Ͱ ѹ ưµ ҿǴ ð, us
#define ENCODER_CONVERSION_VALUE					(float)MAX_SD_ENCODER_VALUE / DISK_54RPM_PER_US
#define SENSOR_LENGTH_MISS_BOUNDARY				50
#define SENSOR_MIN_COUNT							4


//̰˼ .
int	Sensor1Check								= 0;
int Sensor2Check								= 0;
int	Sensor3Check 								= 0;
int test_c_int[2][10000];
int test_c_int_s[10][2000];
int test_c_int_c[10] = {0,0,0,0,0,0,0,0,0,0};
int test_ced =0;
int temp_enc1 = 0;
int temp_enc2 = 0;
int Encoder_return_count=0;
unsigned int lastLaserPrintingTime = 0;


TTabletSensorQueue TabletSensorQueue[3];

#define SUCTION_DISK_INDEX	2

int SPBValidPostionTable[SYSTEM_SPB_MAX_COUNT][SUCTION_DISK_INDEX];

int NextStepFlag = 0;
int InsCompleteForDistributorFlag = 0;
int OutSigOnFlagForInsComp = 0;

struct
{
	char BrightnessDropOccured;
	int	BeforeDisk2TabletCount;
	int	BeforeDefectTabletCount;
	int	BeforeUnInsTabletCount;
	int	BeforeCritTabletCount;
	int	BeforeCritTabletCountD;
	int	BeforeCritUnInsTabletCount;
	int	BeforeCritDefectTabletCount;
	int	InspectionCheckingCounter;
	int	CritUnInsCheckingCounter;
	int	CritDefectCheckingCounter;
	int	IgnoredUninsCount;
	int	IgnoredCritUninsCount;
} StatusCheckingInfo;

#ifdef SELMA
int	CaptureTimingCorrection[200] =
{
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//1	~ 10
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//11 ~ 20
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//21 ~ 30
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//31 ~ 40
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//41 ~ 50
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//51 ~ 60
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//61 ~ 70
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//71 ~ 80
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//81 ~ 90
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//91 ~ 100
	  0,   0,  -3,	 5,	  0,   4,	0,	-1,	  2,  10,			//101 ~	110
	  7,  10,	2,	 5,	  8,   1,	5,	 1,	  5,   3,			//111 ~	120
	  7,   8,	7,	10,	  5,  14,	8,	 4,	 15,   5,			//121 ~	130
	 11,  10,  10,	13,	 11,  10,  10,	15,	 13,  15,			//131 ~	140
	 10,  11,  11,	18,	 15,  15,  17,	15,	 15,  15,			//141 ~	150
	 15,  15,  15,	15,	 15,  15,  15,	15,	 15,  15,			//151 ~	160
	 15,  15,  15,	15,	 15,  15,  15,	15,	 15,  15,			//161 ~	170
	 15,  15,  15,	15,	 15,  15,  15,	15,	 15,  15,			//171 ~	180
	 15,  15,  15,	15,	 15,  15,  15,	15,	 15,  15,			//181 ~	190
	 15,  15,  15,	15,	 15,  15,  15,	15,	 15,  15,			//191 ~	200
};
#endif
#pragma	DATA_ALIGN(TabletInfo, 8);
TTabletInfo	TabletInfo;
#pragma	DATA_ALIGN(TabletInspectInfo, 8);
TTabletInspectInfo TabletInspectInfo;

TTabletControlData TabletControlData;
TTabletCaptureInformation TabletCaptureInformation;		// for mcbsp communication

TSPBProcessingResultData SPBProcessingResultData[SYSTEM_SPB_MAX_COUNT];

#define	SPB_RESULT_HEAP_TABLE_SIZE		512
#define	SPB_RESULT_HEAP_MASK			0x1FF

typedef	struct
{
	int	TabletNumber;
	int	InspectionResult;
	unsigned char	PrintType;
	unsigned char	PrintResult;
	unsigned char	ThickErrorSW1;
	unsigned char	ThickErrorSW2;
	char PositionCompleted[SUCTION_DISK_INDEX];

} TSPBResultHeapUnit;

struct
{
	TSPBResultHeapUnit ResultList[SPB_RESULT_HEAP_TABLE_SIZE];
} SPBResultHeap[SYSTEM_SPB_MAX_COUNT];

#define	NC_CHECK_QUEUE_SIZE				64
#define	NC_CHECK_QUEUE_MASK				63
int	NCCheckQueue[NC_CHECK_QUEUE_SIZE];
int	NCCheckQueueStart;
int	NCCheckQueueEnd;

#pragma	DATA_ALIGN(InspectionResultTable, 8);
TInspectionResultTable InspectionResultTable;

int	CounterSensorInsertRecordIndex;

#define	ILLUMINATION_ACTIVE_COUNT			3 //2 ==> 3			// in Option Camera	system (2D system),	this value must	be 3

struct
{
	int	CaptureIntSPBMask1;
	int	CaptureIntSPBMask2;
	int	IlluminatorDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	IlluminatorMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	IlluminatorTime[SYSTEM_MACHINE_CAPTURE_COUNT];
	unsigned int SensorIntervalA;
	unsigned int SensorIntervalB;
	int  CaptureOption;
} TabletControlSetupData;


THCBInspectionOption InspectionOption;

#define	FRONT_2D_CAMERA_GLOBAL_INDEX			0
#define	BACK_2D_CAMERA_GLOBAL_INDEX			8
#define	FRONT_3D_CAMERA_GLOBAL_INDEX			4
#define	BACK_3D_CAMERA_GLOBAL_INDEX			12

char Front2DCamera_SPBIndex;
char Front3DCamera_SPBIndex;
char Back2DCamera_SPBIndex;
char Back3DCamera_SPBIndex;

struct
{
	char DefectGenEnabled;
	char DefectGenKind;
	char UnInsGenEnabled;
	char UnInsGenKind;
	unsigned int DefectGenMask;
	int	DefectGenMaskCount;
	int	DefectGenMaskIndex;
	int	DefectGenRatio;
	unsigned int UnInsGenMask;
	int	UnInsGenMaskCount;
	int	UnInsGenMaskIndex;
	int	UnInsGenRatio;
} EjectionTestData;

static unsigned	long WellRng512State[16];
static unsigned	int	WellRngIndex = 0;
unsigned long WellRng512(void);

int	MisEjectActFlag		= 0;  	 
int	MisEjectActTmr		= 0;
int MisEjectActSubFlag  = 0;
int MisEjectActSubTmr   = 0; 
int	BlowLengthTime		= 0;
int	ConFlag				= 0;
int	DiskSpeed			= 0;
int	Oldboard50usTmr		= 0;
int	MisEjectorMultiTmr	= 0;
int MisEjectCnt			= 0;
int SumIdx				= 0;
int FirstSumChk			= 0;
int SumExpectedSensorLength	= 0;
 int MisEjecCheckCount	= 0;
int SumIdx2				= 0;
int FirstSumChk2		= 0;
int SumExpectedSensor3Length	= 0;
int	DHoutputDelayTimeFlag 	= 0;
int	DHoutputDelayTime 		= 0;
int	DHoutputSignalTimeFlag 	= 0;
int	DHmachineOnTimeFlag		= 0;
int	DHmachineOnTime			= 0;
int	DHOPOntimeFlag 			= 0;   
int	DHOPOntime 				= 0;
int	DHIPflag 				= 1;
int	DistributorDelayTimer 	= 0;
int	DistributorDelayFlag 	= 0;
int	DisStep 	            = 0;
int LastGoodTabletCount     = 0;
//2й
int goodbloworder           = 1;
int Q_goodbloworder         = 1;
int DisInputCnt1            = 0;
int DisInputCnt2            = 0;
int DisInputCnt3            = 0;
int BasketNum               = 1;

//Q
int	MisEjectActTime			= 0;
int MisEjectUsalActTime     = 0;

int DefectMisEjectDelayTime	= 0;
int UnInsMisEjectDelayTime	= 0;
int DefectMisEjectActTime	= 0;
int UnInsMisEjectActTime	= 0;
int	OldTabletNumber			= 0;
int tablet_sensing_flag = 0;
int sensing_time = 0;
volatile int Disk1current_Encoder_value = 0;
volatile int Disk1last_Encoder_value = 0;
int Disk1last_Encoder_period = 0;
volatile int Disk2current_Encoder_value = 0;
volatile int Disk2last_Encoder_value = 0;
int Disk2last_Encoder_period = 0;
volatile int Disk1Encoder_value_sum;
volatile int Disk2Encoder_value_sum;
int last_capture1_time = 0;
int last_encoder_value = 0;

TDistributorMonitor DistributorMonitor;
TEncoderMonitor EncoderMonitor;


int	EjectTimingModifyTable[200] =
{
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//1	~ 10
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//11 ~ 20
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//21 ~ 30
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//31 ~ 40
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//41 ~ 50
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//51 ~ 60
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//61 ~ 70
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//71 ~ 80
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//81 ~ 90
	  0,   0,	0,	 0,	  0,   0,	0,	 0,	  0,   0,			//91 ~ 100
	  2,   4,   6,	 8,	 10,  12,  14,	16,  18,  20,			//101 ~	110 (105:10, 110:20)
	 22,  24,  26,	28,  30,  30,  30,	30,  30,  30,			//111 ~	120 (115:30, 120:40)
	 30,  30,  30,	30,  30,  30,  30,	30,  30,  30,			//121 ~	130 (125:42, 130:45)
	 30,  30,  30,	30,  30,  30,  30,	30,  30,  30,			//131 ~	140 (140:45)
	 30,  30,  30,	30,  30,  35,  35,	35,  35,  35,			//141 ~	150 (145:30, 150:40)
	 35,  35,  35,  35,  35,  35,  35,  35,  35,  35,			//151 ~	160 (155:30, 160:18)
	 35,  35,  35,  35,  35,  35,  35,  35,  35,  35,			//161 ~	170 (165:27, 170:30)
	 35,  35,  35,  35,  35,  35,  35,  35,  35,  35,			//171 ~	180 (175:35 175 ̻?ȵ)
	 30,  30,  30,	30,  30,  30,  30,	30,  30,  30,			//181 ~	190
	 30,  30,  30,	30,  30,  30,  30,	30,  30,  30,			//191 ~	200
};


void SuctionDisk1SimulationProcess();
void SuctionDisk2SimulationProcess();

void InitTabletControlData(void);

void TabletControl_Init(void)
{
	InitTabletControlData();
	InitTabletTable(1);
	TabletControlData.Func = TABLET_CONTROL_FUNC_NONE;
#ifdef SELMA

	MainControlData.EnabledSensorType = 0; // Intial Sensor(A)
#endif

	TabletControlData.MachineStopMinimalTabletCount	= INSPECTION_CHECKING_MIN_TABLET_COUNT;

	TabletControlData.LastTabletSensor2Time	= 0;

	// init	tablet sensor queue
	TabletSensorQueue[0].Start = TabletSensorQueue[0].End = 0;
	TabletSensorQueue[1].Start = TabletSensorQueue[1].End = 0;
	TabletSensorQueue[2].Start = TabletSensorQueue[2].End = 0;

	NCCheckQueueStart = NCCheckQueueEnd	= 0;
	CounterSensorInsertRecordIndex = 0;

	// Eject NormalMode	Setting
	// ˻	 	InspectionOption ð HCB	 Ƿ
	// ٸ	(̹Կ, н, ׽Ʈ ) ˻϶ ð ݿ ʵ
	// TabletControlData.Func  ɶ	ؼ ̴ϼ

	InspectionOption.EjectMode = 0;
	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;
	TabletControlSetupData.CaptureOption = 0;
	MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 30000;    //й.
	INSPECTION_MACHINE_STOP_DELAY = 60000;    //й.

	DistributorMonitor.DisStep = 0;

}

void TabletControl_Stop(void)
{
	TabletControlData.Func = TABLET_CONTROL_FUNC_NONE;
	TabletControlData.SensorState1 = SENSOR_STATE_OFF;
	TabletControlData.SensorState2 = SENSOR_STATE_OFF;
	TabletControlData.SensorState3 = SENSOR_STATE_OFF;
	TabletControlData.LastTabletSensor2Time	= 0;
	TabletControlSetupData.CaptureOption = 0;
	MC_Ejector_Stop();

	TabletSensorQueue[0].Start = TabletSensorQueue[0].End = 0;
	TabletSensorQueue[1].Start = TabletSensorQueue[1].End = 0;
	TabletSensorQueue[2].Start = TabletSensorQueue[2].End = 0;

	MC_DisableEyeProtection();

	// Eject NormalMode	Setting
	// ˻	 	InspectionOption ð HCB	 Ƿ
	// ٸ	(̹Կ, н, ׽Ʈ ) ˻϶ ð ݿ ʵ
	// TabletControlData.Func  ɶ	ؼ ̴ϼ
	InspectionOption.EjectMode = 0;
	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;
	memset(SPBValidPostionTable, 0x00, sizeof(SPBValidPostionTable));
	PORT_ModifyOutPort(OP_YU_CONTROL, 0); //For ٷ.
}

void InitTabletTable(int startTabletNumber)
{
	int	tabletListIndex, spbIndex, captureIndex;
	memset(TabletInfo, 0x00, sizeof(TabletInfo));
	TabletInfo.CurrentTabletNumber = startTabletNumber;
	TabletInfo.Disk1TabletList[0].TabletNumber = TabletInfo.CurrentTabletNumber;

	TabletSensorQueue[0].Start = TabletSensorQueue[0].End = 0;
	TabletSensorQueue[1].Start = TabletSensorQueue[1].End = 0;
	TabletSensorQueue[2].Start = TabletSensorQueue[2].End = 0;
	TabletSensorQueue[0].List[0].SensorOffCount = TabletControlData.MinSensorLength;
	TabletSensorQueue[1].List[0].SensorOffCount = TabletControlData.MinSensorLength;
	TabletSensorQueue[2].List[0].SensorOffCount = TabletControlData.MinSensorLength;
	TabletControlData.SensorState1 = SENSOR_STATE_OFF;
	TabletControlData.SensorState2 = SENSOR_STATE_OFF;
	TabletControlData.SensorState3 = SENSOR_STATE_OFF;	
	Disk1Encoder_value_sum = 0;
	Disk2Encoder_value_sum = 0;

	Disk1last_Encoder_value = 0;
	Disk1current_Encoder_value = 0;
	Disk2last_Encoder_value = 0;
	Disk2current_Encoder_value = 0;	
	CounterSensorInsertRecordIndex = 0;
	TabletControlSetupData.CaptureOption = 0;
	memset(test_c_int, 0x0, sizeof(test_c_int));
	memset(test_c_int_s, 0x0, sizeof(test_c_int_s));
}

void InitTabletControlData(void)
{
	TabletControlData.SensorState1 = SENSOR_STATE_OFF;
	TabletControlData.SensorState2 = SENSOR_STATE_OFF;
	TabletControlData.SensorState3 = SENSOR_STATE_OFF;
	TabletControlData.BlindBlowOccurred	= 0;
	TabletCaptureInformation.Sensor1TabletNumber = 0;
	TabletCaptureInformation.Sensor2TabletNumber = 0;
	TabletCaptureInformation.Sensor1TabletNumberValid = 0;
	TabletCaptureInformation.Sensor2TabletNumberValid = 0;
}

//=====================================================
#ifdef SELMA
int	TimingCorrection(int suctionDiskSpeed)
{
	int	index;

	index = ServoMotorBaseSpeed[SD1_MOTOR_INDEX] * 100	/ suctionDiskSpeed - 1;

	if (index < 0)
		index = 0;

	return CaptureTimingCorrection[index];
}
#endif

//=====================================================
int	EjectTimingChgTable(int suctionDiskSpeed)
{
	int	idx;

	idx = ServoMotorBaseSpeed[SD1_MOTOR_INDEX] * 100	/ suctionDiskSpeed - 1;

	if (idx < 0)
		idx = 0;

	return EjectTimingModifyTable[idx];
}

//=====================================================
void ApplySuctionDiskSpeed(int suctionDiskSpeed, int sensorIntervalA, int sensorIntervalB, int option)
{
	int	captureIndex;
	int	EjectTime = 0;
	int TabletLen = 0;
	int sensor_deley = 0;

#ifdef SELMA

	int	nVal;
	nVal = TimingCorrection(suctionDiskSpeed);
#endif
	sensor_deley = ((1000- ((float)ServoMotorBaseSpeed[SD1_MOTOR_INDEX]*1000 /(float)suctionDiskSpeed))/1000 * USEC_50_TO_ENCODER *30);
	EjectTime = EjectTimingChgTable(suctionDiskSpeed);

	TabletControlData.MaxSensorLength = MAX_SENSOR_LENGTH_50US * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.MinSensorLength = SENSOR_MIN_TIME	* suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.SensorIntervalA = sensorIntervalA	* suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.SensorMinIntervalA = (sensorIntervalA	- SENSOR_INTERVAL_LIMIT) * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.SensorMaxIntervalA = (sensorIntervalA	+ SENSOR_INTERVAL_LIMIT) * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.SensorIntervalB = sensorIntervalB	* suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.SensorMinIntervalB = (sensorIntervalB	- SENSOR_INTERVAL_LIMIT) * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.SensorMaxIntervalB = (sensorIntervalB	+ SENSOR_INTERVAL_LIMIT) * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];

	TabletControlData.CaptureIntDelay = CAPTURE_INT_DELAY_50US*USEC_50_TO_ENCODER + sensor_deley;
	if (LasercomplexerInfo.Laser_complexer_Enable)
	{
		TabletControlData.LaserTrgEncoderValue	= LasercomplexerInfo.Laser_deley_time * USEC_50_TO_ENCODER + sensor_deley ; // count * 50us , 54RPM (100%)
	}
	else
	{
		TabletControlData.LaserTrgEncoderValue = 0;
	}

	LASER_TRIGER_ENCODER_SET = TabletControlData.LaserTrgEncoderValue;
	TabletControlData.SensorOffStableDelay = SENSOR_OFF_STABLE_DELAY_50US * suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.TabletVarianceTime = TABLET_VARIANCE_TIME	* suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.BlowerPadingDelay	= BLOWER_PADING_DELAY * suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.BlowerCheckingDelay = BLOWER_CHECKING_DELAY	* suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];

	TabletControlData.DefectEjectorEncoderDelay = EjectorSetupData.DefectEjectorDelay*100 + sensor_deley;
	TabletControlData.UnInsEjectorEncoderDelay	= EjectorSetupData.UnInsEjectorDelay*100  + sensor_deley;
	TabletControlData.GoodEjectorEncoderDelay = EjectorSetupData.GoodEjectorDelay*100  + sensor_deley;

	TabletControlData.DefectEjectorDelay = (((DEFECT_EJECTOR_POSITION+TabletControlData.DefectEjectorEncoderDelay) *100 / 78)/50) * suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.UnInsEjectorDelay	= (((UNINS_EJECTOR_POSITION+TabletControlData.UnInsEjectorEncoderDelay)*100 / 78)/50) * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	TabletControlData.GoodEjectorDelay = (((GOOD_EJECTOR_POSITION+TabletControlData.GoodEjectorEncoderDelay)*100 / 78)/50) * suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];

	TabletControlData.MachineStopMinimalTabletCount	= INSPECTION_CHECKING_MIN_TABLET_COUNT * ServoMotorBaseSpeed[SD1_MOTOR_INDEX] / suctionDiskSpeed;
	DefectMisEjectDelayTime	= (120 * suctionDiskSpeed / ServoMotorBaseSpeed[SD2_MOTOR_INDEX]) * 20;	//195, 205
	UnInsMisEjectDelayTime	= (190 * suctionDiskSpeed / ServoMotorBaseSpeed[SD2_MOTOR_INDEX]) * 20;	//127, 135
	DefectMisEjectActTime	= (12000 * suctionDiskSpeed / ServoMotorBaseSpeed[SD2_MOTOR_INDEX]);	//10000
	UnInsMisEjectActTime	= (10700 * suctionDiskSpeed / ServoMotorBaseSpeed[SD2_MOTOR_INDEX]);		//8700
	OldTabletNumber	= 0;

	TabletControlData.Blowinterval	= 0;
	TabletControlData.Blowstart	= 0;
	TabletControlData.Blowlength = 0;

	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;


}

void CalculateExpectedSensorLength(int func, int suctionDiskSpeed, int studiedTabletSensor1Length, int studiedTabletSensor2Length, int studiedTabletSensor3Length)
{
	int captureIndex;
	
	if (func == TABLET_CONTROL_FUNC_CHECK_INTERVAL)
	{
		TabletControlData.ExpectedSensor1Length	= studiedTabletSensor1Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
//		TabletControlData.ExpectedSensor1Length	= studiedTabletSensor1Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
		TabletControlData.ExpectedSensor2Length	= studiedTabletSensor2Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
//		TabletControlData.ExpectedSensor2Length	= studiedTabletSensor2Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
		TabletControlData.ExpectedSensor3Length	= studiedTabletSensor3Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
//		TabletControlData.ExpectedSensor3Length	= studiedTabletSensor3Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	}
	else
	{
		TabletControlData.ExpectedSensor1Length	= studiedTabletSensor1Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
		TabletControlData.ExpectedSensor2Length	= studiedTabletSensor2Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
		TabletControlData.ExpectedSensor3Length	= studiedTabletSensor3Length * suctionDiskSpeed	/ ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
	}

	for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
	{
			TabletControlData.IlluminatorDelay[captureIndex] =(TabletControlSetupData.IlluminatorDelay[captureIndex]  * suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX]);
	}
}
void TabletControl_Capture_Start(int suctionDiskSpeed, int studiedTabletSensorLength, int *illuminatorMask, int TabletSideThick , int	CaptureOption)
{
	int	captureIndex;
	InitTabletTable(1);
	InitTabletControlData();

	TabletControlData.Func = TABLET_CONTROL_FUNC_CAPTURE;
	TabletControlSetupData.CaptureOption = CaptureOption;
	
	TabletControlData.TabletSideThick = TabletSideThick;
	ApplySuctionDiskSpeed(suctionDiskSpeed, TabletControlSetupData.SensorIntervalA, TabletControlSetupData.SensorIntervalB, CaptureOption);
	CalculateExpectedSensorLength(TABLET_CONTROL_FUNC_CAPTURE, suctionDiskSpeed, studiedTabletSensorLength, studiedTabletSensorLength, studiedTabletSensorLength);

	for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
	{
		TabletControlData.IlluminatorMask[captureIndex]	= 0;
	}
	if (MachineStatus.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET && MachineStatus.SuctionDisk2LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
	{
		TabletControlData.IlluminatorMask[0]	= (0x1 << 0) + (0x1 << 1);
		TabletControlData.IlluminatorMask[1]	= (0x1 << 2) + (0x1 << 3) + (0x1 << 4) + (0x1 << 5);
		TabletControlData.IlluminatorMask[3]	= TabletControlSetupData.IlluminatorMask[3];

		TabletControlData.IlluminatorMask[3]	= (0x1 << 6) + (0x1 << 7);
		TabletControlData.IlluminatorMask[4]	= (0x1 << 8) + (0x1 << 9) + (0x1 << 10) + (0x1 << 11);
		TabletControlData.IlluminatorMask[6]	= TabletControlSetupData.IlluminatorMask[6];

	}
	else
	{
		for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
		{
			TabletControlData.IlluminatorMask[captureIndex]	= TabletControlSetupData.IlluminatorMask[captureIndex];
		}
	}


	FirstSumChk	= 0;
	FirstSumChk2	= 0;

	// Eject NormalMode	Setting
	// ˻	 	InspectionOption ð HCB	 Ƿ
	// ٸ	(̹Կ, н, ׽Ʈ ) ˻϶ ð ݿ ʵ
	// TabletControlData.Func  ɶ	ؼ ̴ϼ
	InspectionOption.EjectMode = 0;
	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;

	Sensor1Check	= 0;
	Sensor2Check	= 0;
	Sensor3Check	= 0;

}

void TabletControl_Study_Start(int suctionDiskSpeed, int studiedTabletSensor1Length, int studiedTabletSensor2Length,
                               int	studiedSensorIntervalA, int	studiedSensorIntervalB, int TabletSideThick , int StudyOption)
{
	int	captureIndex;

	// claer tablet	table
	InitTabletTable(1);
	InitTabletControlData();

	TabletControlData.Func = TABLET_CONTROL_FUNC_STUDY;
	TabletControlData.TabletSideThick = TabletSideThick;
	ApplySuctionDiskSpeed(suctionDiskSpeed, studiedSensorIntervalA, studiedSensorIntervalB, StudyOption);
	CalculateExpectedSensorLength(TABLET_CONTROL_FUNC_STUDY, suctionDiskSpeed, studiedTabletSensor1Length, studiedTabletSensor2Length, studiedTabletSensor2Length);

	for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
	{
		TabletControlData.IlluminatorMask[captureIndex]	= 0;
	}

	if (MachineStatus.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET && MachineStatus.SuctionDisk2LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
	{
		TabletControlData.IlluminatorMask[0]	= (0x1 << 0) + (0x1 << 1);
		TabletControlData.IlluminatorMask[1]	= (0x1 << 2) + (0x1 << 3) + (0x1 << 4) + (0x1 << 5);
		TabletControlData.IlluminatorMask[3]	= TabletControlSetupData.IlluminatorMask[3];

		TabletControlData.IlluminatorMask[3]	= (0x1 << 6) + (0x1 << 7);
		TabletControlData.IlluminatorMask[4]	= (0x1 << 8) + (0x1 << 9) + (0x1 << 10) + (0x1 << 11);
		TabletControlData.IlluminatorMask[6]	= TabletControlSetupData.IlluminatorMask[6];

	}
	else
	{
		for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
		{
			TabletControlData.IlluminatorMask[captureIndex]	= TabletControlSetupData.IlluminatorMask[captureIndex];
		}
	}


	InspectionOption.StudiedTabletSensor1Length = studiedTabletSensor1Length;
	InspectionOption.StudiedTabletSensor2Length = studiedTabletSensor2Length;
	InspectionOption.StudiedSensorIntervalA = studiedSensorIntervalA;
	InspectionOption.StudiedSensorIntervalB = studiedSensorIntervalB;

	if (StudyOption == GRADIENT_CAPTURE_MODE)
	{
		TabletControlData.IlluminatorMask[0] = 0x0000;
		TabletControlData.IlluminatorMask[3] = 0x0000;
		TabletControlData.IlluminatorMask[0] = (0x0001 << 0) | (0x0001 << 2);
		TabletControlData.IlluminatorMask[3] = (0x0001 << 7) | (0x0001 << 9);
	}
	else if (StudyOption	== ENGRAVE_CAPTURE_MODE)
	{
		TabletControlData.IlluminatorMask[0] = 0x0000;
		TabletControlData.IlluminatorMask[3] = 0x0000;
		TabletControlData.IlluminatorMask[0] = (0x0001 << 0) | (0x0001 << 1);
		TabletControlData.IlluminatorMask[3] = (0x0001 << 6) | (0x0001 << 7);
	}

	FirstSumChk	= 0;
	FirstSumChk2	= 0;

	// Eject NormalMode	Setting
	// ˻	 	InspectionOption ð HCB	 Ƿ
	// ٸ	(̹Կ, н, ׽Ʈ ) ˻϶ ð ݿ ʵ
	// TabletControlData.Func  ɶ	ؼ ̴ϼ
	InspectionOption.EjectMode = 0;
	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;

	Sensor1Check	= 0;
	Sensor2Check	= 0;
	Sensor3Check	= 0;
}

void TabletControl_Inspection_Start(THCBInspectionOption *hcbInspectionOption, TTabletInspectInfo *tabletInspectInfo)
{
	int	spbIndex;
	int	heapIndex;
	int	tableIndex;
	int	captureIndex;
	int	suctionDiskSpeed;
	int positionIndex;

	// clear tablet	table
	memcpy(&InspectionOption, hcbInspectionOption, sizeof(THCBInspectionOption));
	memcpy(&TabletInspectInfo, tabletInspectInfo, sizeof(TTabletInspectInfo));
	memset(SPBResultHeap, 0x00, sizeof(SPBResultHeap));
	InitTabletTable(TabletInspectInfo.TotalTabletCount + 1);
	InitTabletControlData();

	TabletControlData.InspectionID = InspectionOption.InspectionID;

	StatusCheckingInfo.InspectionCheckingCounter = INSPECTION_CHECKING_TIME;
	StatusCheckingInfo.CritUnInsCheckingCounter	= CRIT_UNINS_CHECKING_TIME;
	StatusCheckingInfo.CritDefectCheckingCounter = CRIT_DEFECT_CHECKING_TIME;
	StatusCheckingInfo.BeforeDisk2TabletCount = TabletInspectInfo.Disk2TabletCount;
	StatusCheckingInfo.BeforeDefectTabletCount = TabletInspectInfo.DefectTabletCount;
	StatusCheckingInfo.BeforeUnInsTabletCount = TabletInspectInfo.UnInsTabletCount;
	StatusCheckingInfo.BeforeCritTabletCount = TabletInspectInfo.TotalTabletCount;
	StatusCheckingInfo.BeforeCritTabletCountD = TabletInspectInfo.TotalTabletCount;
	StatusCheckingInfo.BeforeCritUnInsTabletCount = TabletInspectInfo.UnInsTabletCount;
	StatusCheckingInfo.BeforeCritDefectTabletCount = TabletInspectInfo.DefectTabletCount;
	StatusCheckingInfo.IgnoredUninsCount = 0;
	StatusCheckingInfo.IgnoredCritUninsCount = 0;
	StatusCheckingInfo.BrightnessDropOccured = 0;
	memset(SPBValidPostionTable, 0x00, sizeof(SPBValidPostionTable));
	for (captureIndex = 0 ; captureIndex < SYSTEM_TOTAL_CAMERA_COUNT; captureIndex++)
	{
		if (captureIndex < 8)
		{
			SPBValidPostionTable[InspectionOption.CameraMapInfo_SPB[captureIndex]][0] = 1;
		}
		else
		{
			SPBValidPostionTable[InspectionOption.CameraMapInfo_SPB[captureIndex]][1] = 1;
		}
	}


	if (MachineSetupData.CompanyID == DOMESTIC_MACHINE1||MachineSetupData.CompanyID == DOMESTIC_MACHINE3||MachineSetupData.InterlockInfo.ACdomesticMode) 	//.
	{
		InspectionOption.DHCountCheck[5] = TabletInspectInfo.GoodTabletCount;

		// й Type
		if ((InspectionOption.DHCountCheck[2] == 1) && (InspectionOption.DHSpecialInsCheckbox == 1))
		{
			if (PORT_ReadInPort(IP_DH_CONTROL) == 0)
			{
				InspectionAlarmState.AlarmExist	= 1;
				InspectionAlarmState.DistributorDown	= 1;
			}

			InspectionOption.DHCountCheck[5] = 0;
			DHoutputDelayTimeFlag = 0;
			DHOPOntimeFlag = 0;
			DHmachineOnTimeFlag = 0;
			DHoutputSignalTimeFlag = 0;

			if (TabletInspectInfo.GoodTabletCount == 0)
			{
				DisStep = 0;
				InspectionOption.DHCountCheck[0] = 0;
			}
			else
			{
				switch (DisStep)
				{
				case 0:
					InspectionOption.DHCountCheck[0] = 0;   //1ܰ.
					break;
				case 1:
					InspectionOption.DHCountCheck[0] = 1;   //2ܰ.
					InspectionOption.DHSpecialInsCount[1] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1];
					break;
				case 2:
					InspectionOption.DHCountCheck[0] = 2;   //3ܰ.
					InspectionOption.DHSpecialInsCount[2] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1]
					                                        + InspectionOption.DHSpecialInsCount[2];
					break;
				case 3:
					InspectionOption.DHCountCheck[0] = 3;   //4ܰ.
					InspectionOption.DHSpecialInsCount[3] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1]
					                                        + InspectionOption.DHSpecialInsCount[2]
					                                        + InspectionOption.DHSpecialInsCount[3];
					break;
				case 4:
					InspectionOption.DHCountCheck[0] = 4;   //5ܰ.
					InspectionOption.DHSpecialInsCount[4] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1]
					                                        + InspectionOption.DHSpecialInsCount[2]
					                                        + InspectionOption.DHSpecialInsCount[3]
					                                        + InspectionOption.DHSpecialInsCount[4];
					break;
				case 5:
					InspectionOption.DHCountCheck[0] = 5;   //6ܰ.
					InspectionOption.DHSpecialInsCount[5] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1]
					                                        + InspectionOption.DHSpecialInsCount[2]
					                                        + InspectionOption.DHSpecialInsCount[3]
					                                        + InspectionOption.DHSpecialInsCount[4]
					                                        + InspectionOption.DHSpecialInsCount[5];
					break;
				default:
					InspectionOption.DHCountCheck[0] = 0;
					break;
				}
			}
		}
		//Ѹ й Type
		else if ((InspectionOption.DHCountCheck[3] == 1) && (InspectionOption.DHSpecialInsCheckbox == 1))
		{
			if (PORT_ReadInPort(IP_DH_CONTROL) == 0)
			{
				InspectionAlarmState.AlarmExist	= 1;
				InspectionAlarmState.DistributorDown	= 1;
			}
			else
			{
				if(InspectionOption.DistributorConveyerEnable == 1)
				{
					// Conveyer Run
					DHOPOntime = 0;
					PORT_ChangeOutPort(OP_DH_CONTROL,1);
				}
			}

			DHoutputDelayTimeFlag = 0;
			DHOPOntimeFlag = 0;
			DHmachineOnTimeFlag = 0;
			DHoutputSignalTimeFlag = 0;

			//1.˻  ̾/˻ .
			if (TabletInspectInfo.GoodTabletCount == 0)
			{
				DisStep = 0;
				InspectionOption.DHCountCheck[0] = 0;
				LastGoodTabletCount = 0;
				InspectionOption.DHCountCheck[5] = 0;
			}
			else
			{
				if (InspectionOption.DHSpecialInsCount[2] == 1)	//Lot ̾ ˻.
				{

					
					InspectionOption.DHCountCheck[0] = DisStep;

					if (InspectionOption.DHCountCheck[5] == 0)
					{
						InspectionOption.DHCountCheck[5] = TabletInspectInfo.GoodTabletCount;

						LastGoodTabletCount = TabletInspectInfo.GoodTabletCount;
						/*if(DisStep > 0)
						{
							LastGoodTabletCount = TabletInspectInfo.GoodTabletCount; //   ؼ DHCheck 0ε Step ѹ̻ Ѿ  ;
						}
						else
							LastGoodTabletCount = 0;  */
					}
					else
						LastGoodTabletCount = TabletInspectInfo.GoodTabletCount;

				}
				else
				{
					DisStep = 0;
					InspectionOption.DHCountCheck[0] = 0;
					LastGoodTabletCount = 0;
					InspectionOption.DHCountCheck[5] = TabletInspectInfo.GoodTabletCount;
				}				
			}
		}
		else if((InspectionOption.DHCountCheck[4] == 1) && (InspectionOption.DHSpecialInsCheckbox == 1)) //debug type4 start
		{	
			InsCompleteForDistributorFlag = 0;
			
			MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 1000 * 300; 
			INSPECTION_MACHINE_STOP_DELAY = 1000 * 300;	
						
			if (PORT_ReadInPort(IP_DH_CONTROL) == 0)
			{
				InspectionAlarmState.AlarmExist	= 1;
				InspectionAlarmState.DistributorDown	= 1;
			}

			DHoutputDelayTimeFlag = 0;
			DHmachineOnTimeFlag = 0;
			DHoutputSignalTimeFlag = 0;	

			if (TabletInspectInfo.GoodTabletCount == 0)
			{
				DisStep = 0;
				InspectionOption.DHCountCheck[0] = 0;
				LastGoodTabletCount = 0;
				InspectionOption.DHCountCheck[5] = 0;
			}
			else
			{
				if (InspectionOption.DHSpecialInsCount[2] == 1)	//Lot ̾ ˻ 
				{
					DisStep = TabletInspectInfo.LastDisStep;
					
					InspectionOption.DHCountCheck[0] = DisStep;

					if (InspectionOption.DHCountCheck[5] == 0)
					{
						InspectionOption.DHCountCheck[5] = TabletInspectInfo.GoodTabletCount;
						LastGoodTabletCount = TabletInspectInfo.GoodTabletCount;
					}
					else
						LastGoodTabletCount = TabletInspectInfo.GoodTabletCount;

				}
				else
				{
					DisStep = 0;
					InspectionOption.DHCountCheck[0] = 0;
					LastGoodTabletCount = 0;
					InspectionOption.DHCountCheck[5] = TabletInspectInfo.GoodTabletCount;

					DHoutputDelayTimeFlag = 0;
					DHoutputDelayTime = 0;
					DHmachineOnTimeFlag = 0;				
				}					
			
				if(DisStep >= InspectionOption.DHSpecialInsCount[1] ) 
				{
					DisStep = 0;
					InspectionOption.DHCountCheck[0] = 0;
					LastGoodTabletCount = 0;
					InspectionOption.DHCountCheck[5] = TabletInspectInfo.GoodTabletCount;				

					DHoutputDelayTimeFlag = 0;
					DHoutputDelayTime = 0;
					DHmachineOnTimeFlag = 0;				
				}			
			}				
		}

		DistributorDelayFlag = 0;  //3ܰ迡 4ܰ Ѿ  Timer.

	}

	/* sjm Ȧ¦ ƴ й 1/2  Ǿ ִ.
	   if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1 && InspectionOption.EjectMode == 1) 	//Q, Special Mode.
	{			
	    if(((TabletInspectInfo.GoodTabletCount + 1) /InspectionOption.SPModeGoodTabletCollectCount1) % 2 == 0) 
	    {
	        Q_goodbloworder = 1;
	    }else
	    {
	        Q_goodbloworder = 2;
	    }
	   }*/

	suctionDiskSpeed = InspectionOption.SuctionDiskSpeed;
	DiskSpeed	= InspectionOption.SuctionDiskSpeed;

	TabletControlData.Func = TABLET_CONTROL_FUNC_INSPECTION;
	TabletControlData.TabletSideThick = InspectionOption.TabletSideThick;
	ApplySuctionDiskSpeed(suctionDiskSpeed, InspectionOption.StudiedSensorIntervalA, InspectionOption.StudiedSensorIntervalB, InspectionOption.CaptureMode);
	CalculateExpectedSensorLength(TABLET_CONTROL_FUNC_INSPECTION, InspectionOption.SuctionDiskSpeed, InspectionOption.StudiedTabletSensor1Length, InspectionOption.StudiedTabletSensor2Length, InspectionOption.StudiedTabletSensor3Length);

	for (spbIndex = 0; spbIndex	< MachineSetupData.IPB_BoardCount;	spbIndex++)
	{
		SPBProcessingResultData[spbIndex].CompleteCount	= 0;
	}

	MC_Ejector_Init();

	NCCheckQueueStart = NCCheckQueueEnd	= 0;

	TabletControlData.LastTabletSensor2Time	= Board1MSTmr + TABLET_FEEDING_DELAY;

	/*
	StatusCheckingInfo.InspectionCheckingCounter    = INSPECTION_CHECKING_TIME;
	StatusCheckingInfo.CritUnInsCheckingCounter	    = CRIT_UNINS_CHECKING_TIME;
	StatusCheckingInfo.BeforeDisk2TabletCount       = 0;
	StatusCheckingInfo.BeforeDefectTabletCount      = 0;
	StatusCheckingInfo.BeforeUnInsTabletCount       = 0;
	StatusCheckingInfo.BeforeCritTabletCount        = 0;
	StatusCheckingInfo.BeforeCritUnInsTabletCount   = 0;
	StatusCheckingInfo.IgnoredUninsCount            = 0;
	StatusCheckingInfo.IgnoredCritUninsCount        = 0;
	*/

	for (tableIndex	= 0; tableIndex	< RESULT_TABLE_SIZE; tableIndex++)
	{
		InspectionResultTable.Table[tableIndex].TabletNumber = 0;
		InspectionResultTable.Table[tableIndex].Result = TABLET_RESULT_NONE;
		InspectionResultTable.Table[tableIndex].EjectOnTime = 0;
	}
	InspectionResultTable.CurrentIndex = 0;

	Front2DCamera_SPBIndex = InspectionOption.CameraMapInfo_SPB[FRONT_2D_CAMERA_GLOBAL_INDEX];
	Back2DCamera_SPBIndex = InspectionOption.CameraMapInfo_SPB[BACK_2D_CAMERA_GLOBAL_INDEX];
	Front3DCamera_SPBIndex = InspectionOption.CameraMapInfo_SPB[FRONT_3D_CAMERA_GLOBAL_INDEX];
	Back3DCamera_SPBIndex = InspectionOption.CameraMapInfo_SPB[BACK_3D_CAMERA_GLOBAL_INDEX];

	if (Front2DCamera_SPBIndex < 0 || Front2DCamera_SPBIndex >= MachineSetupData.IPB_BoardCount ||
	        Back2DCamera_SPBIndex	< 0	|| Back2DCamera_SPBIndex >= MachineSetupData.IPB_BoardCount ||
	        Front3DCamera_SPBIndex < 0 || Front3DCamera_SPBIndex >= MachineSetupData.IPB_BoardCount ||
	        Back3DCamera_SPBIndex	< 0	|| Back3DCamera_SPBIndex >= MachineSetupData.IPB_BoardCount)
	{
		Front2DCamera_SPBIndex = 0;
		Back2DCamera_SPBIndex = 0;
		Front3DCamera_SPBIndex = 0;
		Back3DCamera_SPBIndex = 0;
	}

	TabletControlData.BlindBlowOccurred	= 0;

	if (LEDControlSetupData.EyeProtectionModeEnabled)
		MC_EnableEyeProtection();

	for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
	{
		TabletControlData.IlluminatorMask[captureIndex]	= 0;
	}
	if (MachineStatus.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET && MachineStatus.SuctionDisk2LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
	{
		TabletControlData.IlluminatorMask[0]	= (0x1 << 0) + (0x1 << 1);
		TabletControlData.IlluminatorMask[1]	= (0x1 << 2) + (0x1 << 3) + (0x1 << 4) + (0x1 << 5);
		TabletControlData.IlluminatorMask[3]	= TabletControlSetupData.IlluminatorMask[3];

		TabletControlData.IlluminatorMask[3]	= (0x1 << 6) + (0x1 << 7);
		TabletControlData.IlluminatorMask[4]	= (0x1 << 8) + (0x1 << 9) + (0x1 << 10) + (0x1 << 11);
		TabletControlData.IlluminatorMask[6]	= TabletControlSetupData.IlluminatorMask[6];

	}
	else
	{
		for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
		{
			TabletControlData.IlluminatorMask[captureIndex]	= TabletControlSetupData.IlluminatorMask[captureIndex];
		}
	}

	if (InspectionOption.CaptureMode	== GRADIENT_CAPTURE_MODE)
	{
		TabletControlData.IlluminatorMask[0] = 0x0000;
		TabletControlData.IlluminatorMask[3] = 0x0000;
		TabletControlData.IlluminatorMask[0] = (0x0001 << 0) | (0x0001 << 2);
		TabletControlData.IlluminatorMask[3] = (0x0001 << 7) | (0x0001 << 9);
	}
	else if (InspectionOption.CaptureMode == ENGRAVE_CAPTURE_MODE)
	{
		TabletControlData.IlluminatorMask[0] = 0x0000;
		TabletControlData.IlluminatorMask[3] = 0x0000;
		TabletControlData.IlluminatorMask[0] = (0x0001 << 0) | (0x0001 << 1);
		TabletControlData.IlluminatorMask[3] = (0x0001 << 6) | (0x0001 << 7);
	}


	ConFlag	= 0;
	Oldboard50usTmr	= 0;
	MisEjectCnt	= 0;
	MisEjecCheckCount = 0;
	FirstSumChk	= 1;
	SumIdx	= 1;
	FirstSumChk2	= 1;
	SumIdx2	= 1;
	SumExpectedSensorLength = 0;
	SumExpectedSensor3Length = 0;
	MisEjectActFlag	= 0;
	MisEjectActSubFlag = 0;
	MisEjectorMultiTmr	= ( 22254 * suctionDiskSpeed / ServoMotorBaseSpeed[SD2_MOTOR_INDEX] ) * 2;

	if (MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
	{
		TabletInspectInfo.MisejectActiveCount	= 0;
	}
	TabletInspectInfo.MisejectDefectTabletCount = 0;
	TabletInspectInfo.MisejectUnInsTabletCount	= 0;
	TabletInspectInfo.CounterSensorTabletCount = 0;
//	TabletInspectInfo.CounterSensorTabletCount	= TabletInspectInfo.GoodTabletCount;
	MisEjectCnt	= 0;


	// 2й
	if ((MachineSetupData.CompanyID == DOMESTIC_MACHINE1 || MachineSetupData.CompanyID == DOMESTIC_MACHINE3 || MachineSetupData.InterlockInfo.ACdomesticMode) && InspectionOption.EjectMode == 0) 	//.
	{
			if (InspectionOption.DistributorCheck == 1)
			{
				if (InspectionOption.StartType == 0) //0: New, 1:Continue
				{
					TabletInspectInfo.SPGoodTabletDropIndex = 0;
					goodbloworder = 1;
					DisInputCnt1 = 0;
					DisInputCnt2 = 0;
					DisInputCnt3 = 0;
					PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
					PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
				}
				else
				{
					if ((DisInputCnt1 < InspectionOption.DistributorGoodTabletCount1) && (DisInputCnt1 > 0))
					{
						TabletInspectInfo.SPGoodTabletDropIndex = 0;
						goodbloworder = 1;
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
					}
					else if ((DisInputCnt2 < InspectionOption.DistributorGoodTabletCount2) && (DisInputCnt2 > 0))
					{
						TabletInspectInfo.SPGoodTabletDropIndex = 1;
						goodbloworder = 2;
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 1);
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 0);
					}
				}
			}
	}

	if (MachineSetupData.CompanyID == DOMESTIC_MACHINE2 && InspectionOption.EjectMode == 0)	//ѱݸ 3й.
	{
		if (TabletInspectInfo.GoodTabletCount == 0)
		{
			goodbloworder	= 1;
			DisInputCnt1	= 0;
			DisInputCnt2	= 0;
			DisInputCnt3	= 0;
			PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
			PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
		}
		else
		{
			if ((DisInputCnt1 < InspectionOption.DistributorGoodTabletCount1) && (DisInputCnt1 > 0))			// 1ܰ??< 1ܰ Է 
			{
				goodbloworder = 1;
				PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
				PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
			}
			else if ((DisInputCnt2 < InspectionOption.DistributorGoodTabletCount2) && (DisInputCnt2 > 0))	// 2ܰ  < 2ܰ Է 
			{
				goodbloworder = 2;
				PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 1);
				PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 0);
			}else if ((DisInputCnt3 < InspectionOption.DistributorGoodTabletCount3) && (DisInputCnt3 > 0))	// 3ܰ  < 3ܰ Է 
			{
				goodbloworder = 3;
			}else
			{
				goodbloworder = 1;
				PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
				PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
			}
		}
	}

//	ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,333,333,InspectionOption.CaptureMode);

}

void TabletControl_CheckInerval_Start(int suctionDiskSpeed, int	studiedTabletSensorLength)
{
	InitTabletTable(1);

	InitTabletControlData();

	TabletControlData.Func = TABLET_CONTROL_FUNC_CHECK_INTERVAL;

	ApplySuctionDiskSpeed(suctionDiskSpeed, TabletControlSetupData.SensorIntervalA, TabletControlSetupData.SensorIntervalB, 0);
	CalculateExpectedSensorLength(TABLET_CONTROL_FUNC_CHECK_INTERVAL, suctionDiskSpeed, studiedTabletSensorLength, studiedTabletSensorLength, studiedTabletSensorLength);


	// Eject NormalMode	Setting
	// ˻	 	InspectionOption ð HCB	 Ƿ
	// ٸ	(̹Կ, н, ׽Ʈ ) ˻϶ ð ݿ ʵ
	// TabletControlData.Func  ɶ	ؼ ̴ϼ
	InspectionOption.EjectMode = 0;
	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;
	FirstSumChk	= 0;
	FirstSumChk2	= 0;

	Sensor1Check	= 0;
	Sensor2Check	= 0;
	Sensor3Check	= 0;
}

void TabletControl_Tablet_Counter_Start(int	suctionDiskSpeed,
                                        int	studiedTabletSensor1Length, int	studiedTabletSensor2Length, int	studiedTabletSensor3Length, int	studiedSensorIntervalA, int	studiedSensorIntervalB,
                                        char defectGenEnabled, char	defectGenKind, char	uninsGenEnabled, char uninsGenKind,
                                        unsigned int defectGenMask, int	defectGenMaskCount, int	defectGenRatio, unsigned int uninsGenMask, int uninsGenMaskCount, int uninsGenRatio)
{
	int	spbIndex;
	int	heapIndex;
	int	tableIndex;
	int	captureIndex;
	int positionIndex;

	memset(&TabletInspectInfo, 0, sizeof(TTabletInspectInfo));

	InitTabletTable(1);

	InitTabletControlData();

	TabletControlData.Func = TABLET_CONTROL_FUNC_TABLET_COUNTER;

	ApplySuctionDiskSpeed(suctionDiskSpeed, studiedSensorIntervalA, studiedSensorIntervalB, 0);
	CalculateExpectedSensorLength(TABLET_CONTROL_FUNC_CHECK_INTERVAL, suctionDiskSpeed, studiedTabletSensor1Length, studiedTabletSensor2Length, studiedTabletSensor3Length);

	for (spbIndex = 0; spbIndex	< MachineSetupData.IPB_BoardCount;	spbIndex++)
	{
		SPBProcessingResultData[spbIndex].CompleteCount	= 0;
	}

	for (spbIndex = 0; spbIndex	< MachineSetupData.IPB_BoardCount;	spbIndex++)
	{
		for (heapIndex = 0;	heapIndex < SPB_RESULT_HEAP_TABLE_SIZE;	heapIndex++)
		{
			SPBResultHeap[spbIndex].ResultList[heapIndex].TabletNumber = 0;
			SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult = SPB_TABLET_RESULT_NONE;

			for (positionIndex = 0; positionIndex < SUCTION_DISK_INDEX; positionIndex++)
			{
				SPBResultHeap[spbIndex].ResultList[heapIndex].PositionCompleted[positionIndex]	= 0;
			}
		}
	}

	MC_Ejector_Init();

	NCCheckQueueStart = NCCheckQueueEnd	= 0;

	TabletControlData.LastTabletSensor2Time	= Board1MSTmr + TABLET_FEEDING_DELAY;

	StatusCheckingInfo.InspectionCheckingCounter = INSPECTION_CHECKING_TIME;
	StatusCheckingInfo.CritUnInsCheckingCounter	= CRIT_UNINS_CHECKING_TIME;
	StatusCheckingInfo.CritDefectCheckingCounter = CRIT_DEFECT_CHECKING_TIME;
	StatusCheckingInfo.BeforeDisk2TabletCount = 0;
	StatusCheckingInfo.BeforeDefectTabletCount = 0;
	StatusCheckingInfo.BeforeUnInsTabletCount = 0;
	StatusCheckingInfo.BeforeCritTabletCount = 0;
	StatusCheckingInfo.BeforeCritTabletCountD = 0;
	StatusCheckingInfo.BeforeCritUnInsTabletCount = 0;
	StatusCheckingInfo.BeforeCritDefectTabletCount = 0;
	StatusCheckingInfo.IgnoredUninsCount = 0;
	StatusCheckingInfo.IgnoredCritUninsCount = 0;

	for (tableIndex	= 0; tableIndex	< RESULT_TABLE_SIZE; tableIndex++)
	{
		InspectionResultTable.Table[tableIndex].TabletNumber = 0;
		InspectionResultTable.Table[tableIndex].Result = TABLET_RESULT_NONE;
		InspectionResultTable.Table[tableIndex].EjectOnTime = 0;
	}
	InspectionResultTable.CurrentIndex = 0;

	TabletControlData.BlindBlowOccurred	= 0;
	for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
	{
		TabletControlData.IlluminatorMask[captureIndex]	= 0;
	}
	if (MachineStatus.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET && MachineStatus.SuctionDisk2LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
	{
		TabletControlData.IlluminatorMask[0]	= (0x1 << 0) + (0x1 << 1);
		TabletControlData.IlluminatorMask[1]	= (0x1 << 2) + (0x1 << 3) + (0x1 << 4) + (0x1 << 5);
		TabletControlData.IlluminatorMask[3]	= TabletControlSetupData.IlluminatorMask[3];

		TabletControlData.IlluminatorMask[3]	= (0x1 << 6) + (0x1 << 7);
		TabletControlData.IlluminatorMask[4]	= (0x1 << 8) + (0x1 << 9) + (0x1 << 10) + (0x1 << 11);
		TabletControlData.IlluminatorMask[6]	= TabletControlSetupData.IlluminatorMask[6];

	}
	else
	{
		for (captureIndex = 0; captureIndex	< SYSTEM_MACHINE_CAPTURE_COUNT;	captureIndex++)
		{
			TabletControlData.IlluminatorMask[captureIndex]	= TabletControlSetupData.IlluminatorMask[captureIndex];
		}
	}


	EjectionTestData.DefectGenEnabled = defectGenEnabled;
	EjectionTestData.DefectGenKind = defectGenKind;
	EjectionTestData.UnInsGenEnabled = uninsGenEnabled;
	EjectionTestData.UnInsGenKind = uninsGenKind;
	EjectionTestData.DefectGenMask = defectGenMask;
	EjectionTestData.DefectGenMaskCount	= defectGenMaskCount;
	EjectionTestData.DefectGenRatio	= defectGenRatio;
	EjectionTestData.UnInsGenMask = uninsGenMask;
	EjectionTestData.UnInsGenMaskCount = uninsGenMaskCount;
	EjectionTestData.UnInsGenRatio = uninsGenRatio;


	// Eject NormalMode	Setting
	// ˻	 	InspectionOption ð HCB	 Ƿ
	// ٸ	(̹Կ, н, ׽Ʈ ) ˻϶ ð ݿ ʵ
	// TabletControlData.Func  ɶ	ؼ ̴ϼ
	InspectionOption.EjectMode = 0;
	EjectorSetupData.Special_InspectionActive	= InspectionOption.EjectMode;

	FirstSumChk	= 0;
	FirstSumChk2	= 0;

	Sensor1Check	= 0;
	Sensor2Check	= 0;
	Sensor3Check	= 0;
}

void ReadEncoderProcess(void)
{
	CSL_IntcGlobalEnableState 	state;
	int i,j;
	int temp_en_H = 0;
	CSL_intcGlobalDisable(&state);

	if(MachineSetupData.LasercomplexerInfo.Machine_type==MACHINE_TYPE_LIMA_BASIC || MachineSetupData.LasercomplexerInfo.Machine_type==MACHINE_TYPE_LIMA_ADVANCED)
	{
		Disk1current_Encoder_value = *SERVO_MOTOR_0_ENCODER;
		Disk1current_Encoder_value = Disk1current_Encoder_value&0xFFF;
		Disk2current_Encoder_value = *SERVO_MOTOR_1_ENCODER;
		Disk2current_Encoder_value = Disk2current_Encoder_value&0xFFF;	
		

		if(Disk1last_Encoder_value == Disk1current_Encoder_value)
		{
			Disk1current_Encoder_value = *SERVO_MOTOR_0_ENCODER;
			Disk1current_Encoder_value = Disk1current_Encoder_value&0xFFF;	

		}
		if(Disk2last_Encoder_value == Disk2current_Encoder_value)
		{
			Disk2current_Encoder_value = *SERVO_MOTOR_1_ENCODER;
			Disk2current_Encoder_value = Disk2current_Encoder_value&0xFFF;	

		}
	}
	else 
	{
		Disk1current_Encoder_value = *SERVO_MOTOR_0_ENCODER;
		Disk1current_Encoder_value = (Disk1current_Encoder_value*10)&0xFFF;
		Disk2current_Encoder_value = *SERVO_MOTOR_1_ENCODER;
		Disk2current_Encoder_value = (Disk2current_Encoder_value*10)&0xFFF;	
		

		if(Disk1last_Encoder_value == Disk1current_Encoder_value)
		{
			Disk1current_Encoder_value = *SERVO_MOTOR_0_ENCODER;
			Disk1current_Encoder_value = (Disk1current_Encoder_value*10)&0xFFF;	

		}
		if(Disk2last_Encoder_value == Disk2current_Encoder_value)
		{
			Disk2current_Encoder_value = *SERVO_MOTOR_1_ENCODER;
			Disk2current_Encoder_value = (Disk2current_Encoder_value*10)&0xFFF;	

		}
	}
	if(abs(Disk1last_Encoder_value - Disk1current_Encoder_value) > 9)
	{
		if(Disk1last_Encoder_value >= Disk1current_Encoder_value)
		{		
			if(Disk1last_Encoder_value - Disk1current_Encoder_value > (Disk1last_Encoder_period*3+30)) 
			{
				test_c_int_c[0]++;
				Disk1Encoder_value_sum =(Disk1Encoder_value_sum + Disk1last_Encoder_period)& ENCODER_MASK;
			}
			else
			{
				Disk1last_Encoder_period = Disk1last_Encoder_value - Disk1current_Encoder_value;
				Disk1Encoder_value_sum =(Disk1Encoder_value_sum + Disk1last_Encoder_period)& ENCODER_MASK;
			}
		}
		else
		{	
			if(Disk1last_Encoder_value > (Disk1last_Encoder_period+40))
			{			
				test_c_int_c[1]++;
				Disk1Encoder_value_sum = (Disk1Encoder_value_sum + Disk1last_Encoder_period)& ENCODER_MASK;
			}
			else 
			{
				if(((Disk1last_Encoder_value +0xFFF)- Disk1current_Encoder_value) > (Disk1last_Encoder_period*3+30))
				{			
					test_c_int_c[2]++;
					Disk1Encoder_value_sum = (Disk1Encoder_value_sum + Disk1last_Encoder_period)& ENCODER_MASK;
				}
				else
				{
					Disk1last_Encoder_period = (Disk1last_Encoder_value +0xFFF)- Disk1current_Encoder_value;	
					Disk1Encoder_value_sum = (Disk1Encoder_value_sum + Disk1last_Encoder_period)& ENCODER_MASK;
				
				}
			}
		
		}
	}
/*	
	if(Disk1Encoder_value_sum >= last_encoder_value)
	{
		test_c_int[0][test_c_int_c[5]++] = Disk1Encoder_value_sum - last_encoder_value;
	}
	else
	{
		test_c_int[0][test_c_int_c[5]++] = Disk1Encoder_value_sum+ENCODER_MASK - last_encoder_value;
		test_c_int_c[8]++;
	}
	if(test_c_int[0][test_c_int_c[5]] > 1000) test_c_int_c[6]++;
	if(Disk1last_Encoder_period > 1000) test_c_int_c[7]++;
		
	if(test_c_int_c[5] > 20000) test_c_int_c[5] = 0;

	
	last_encoder_value = Disk1Encoder_value_sum;
*/	

	if(abs(Disk2last_Encoder_value - Disk2current_Encoder_value) > 9) 
	{
		if(Disk2current_Encoder_value >= Disk2last_Encoder_value)
		{
			if(Disk2current_Encoder_value - Disk2last_Encoder_value  > (Disk2last_Encoder_period*3+30)) 
			{
				test_c_int_c[3]++;
				Disk2Encoder_value_sum =(Disk2Encoder_value_sum + Disk2last_Encoder_period)& ENCODER_MASK;
			}
			else
			{
				Disk2last_Encoder_period = Disk2current_Encoder_value - Disk2last_Encoder_value;
				Disk2Encoder_value_sum =(Disk2Encoder_value_sum + Disk2last_Encoder_period)& ENCODER_MASK;
				if(Disk2last_Encoder_period > 200)
				{
					test_c_int_s[2][test_c_int_c[6]++] = (Disk2current_Encoder_value)- Disk2last_Encoder_value;
					test_c_int_s[3][test_c_int_c[6]] = board50usTmr;
					if (test_c_int_c[6]>2000) test_c_int_c[6] = 0;
				}					
			}
		}
		else
		{	
			if(Disk2current_Encoder_value > (Disk2last_Encoder_period+40))
			{
				test_c_int_c[4]++;
				Disk2Encoder_value_sum = (Disk2Encoder_value_sum + Disk2last_Encoder_period)& ENCODER_MASK;
			}
			else 
			{
				if(((Disk2current_Encoder_value +0xFFF)- Disk2last_Encoder_value) > (Disk2last_Encoder_period*3+30))
				{
					test_c_int_c[7]++;
					Disk2Encoder_value_sum = (Disk2Encoder_value_sum + Disk2last_Encoder_period)& ENCODER_MASK;
				}
				else
				{
					test_c_int_c[6]++;
					Disk2last_Encoder_period = (Disk2current_Encoder_value +0xFFF)- Disk2last_Encoder_value;	
					Disk2Encoder_value_sum = (Disk2Encoder_value_sum + Disk2last_Encoder_period)& ENCODER_MASK;
					if(Disk2last_Encoder_period > 200)
					{
						test_c_int_s[0][test_c_int_c[5]++] = (Disk2current_Encoder_value +0xFFF)- Disk2last_Encoder_value;
						test_c_int_s[1][test_c_int_c[5]] = board50usTmr;
						if (test_c_int_c[5]>2000) test_c_int_c[5] = 0;
					}					
				
				}

			}
		}
	}
	Disk1last_Encoder_value = Disk1current_Encoder_value;
	Disk2last_Encoder_value = Disk2current_Encoder_value;
	CSL_intcGlobalEnable(&state);
	SuctionDisk1LaserPrintProcess();
}
void TabletControl_Sensor1On(void)
{
	if (TabletControlData.SensorState1 == SENSOR_STATE_OFF)
	{
		TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorOnTime = board50usTmr;
		TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorOffCount = SENSOR_MIN_COUNT;
		TabletControlData.SensorState1 = SENSOR_STATE_ON;		
		TabletControlData.LastSensor1OnTime	= board50usTmr;
		TabletSensorQueue[0].List[TabletSensorQueue[0].End].EncoderOnVaule = Disk1Encoder_value_sum;
		
		if (SuctionDiskProcedureData.State != SD_STATE_RUN)
		{
			TabletSensorQueue[0].List[TabletSensorQueue[0].End].MisFeeding = 1;
		}
		else
		{
			TabletSensorQueue[0].List[TabletSensorQueue[0].End].MisFeeding = 0;
		}
	}
	else 
	{
		TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorOffCount = SENSOR_MIN_COUNT;
/*
		if (board50usTmr - TabletControlData.LastSensor1OnTime > TabletControlData.MaxSensorLength)
		{
			if (MainControlData.State == MAIN_CONTROL_STATE_RUN)
			{
				InspectionAlarmState.Sensor1Error = 1;
				InspectionAlarmState.AlarmExist	= 1;
			}
		}
*/		
	}
}

void TabletControl_Sensor1Off(void)
{
	if (TabletControlData.SensorState1 == SENSOR_STATE_ON)
	{
		if(TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorOffCount <= 0)
		{
			TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorLength = board50usTmr - TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorOnTime-SENSOR_MIN_COUNT;
			if (Disk1Encoder_value_sum  > TabletSensorQueue[0].List[TabletSensorQueue[0].End].EncoderOnVaule)
			{
				TabletSensorQueue[0].List[TabletSensorQueue[0].End].EncoderLength = Disk1Encoder_value_sum  - TabletSensorQueue[0].List[TabletSensorQueue[0].End].EncoderOnVaule;
			}
			else
			{
				TabletSensorQueue[0].List[TabletSensorQueue[0].End].EncoderLength = (Disk1Encoder_value_sum + ENCODER_MASK) - TabletSensorQueue[0].List[TabletSensorQueue[0].End].EncoderOnVaule;
			}
			TabletControlData.SensorState1 = SENSOR_STATE_OFF;
			TabletSensorQueue[0].End = (TabletSensorQueue[0].End + 1) & TABLET_SENSOR_LIST_MASK;
		}
		else
		{
			TabletSensorQueue[0].List[TabletSensorQueue[0].End].SensorOffCount--;
		}
	}
}

void TabletControl_Sensor2On(void)
{
	if (TabletControlData.SensorState2 == SENSOR_STATE_OFF)
	{
		TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorOnTime = board50usTmr;
		TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorOffCount = SENSOR_MIN_COUNT;
		TabletControlData.SensorState2 = SENSOR_STATE_ON;
		TabletControlData.LastSensor2OnTime	= board50usTmr;
		TabletControlData.LastTabletSensor2Time	= Board1MSTmr;
		TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderOnVaule = Disk2Encoder_value_sum;

		if (SuctionDiskProcedureData.State != SD_STATE_RUN)	// misfeeding
		{
			TabletSensorQueue[1].List[TabletSensorQueue[1].End].MisFeeding = 1;
		}
		else
		{
			TabletSensorQueue[1].List[TabletSensorQueue[1].End].MisFeeding = 0;
		}
	}
	else 
	{
		TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorOffCount = SENSOR_MIN_COUNT;
/*		
		if (board50usTmr - TabletControlData.LastSensor2OnTime > TabletControlData.MaxSensorLength)
		{
			if (MainControlData.State == MAIN_CONTROL_STATE_RUN)
			{
				InspectionAlarmState.Sensor2Error = 1;
				InspectionAlarmState.AlarmExist	= 1;
			}
		}
*/		
	}
}
void TabletControl_Sensor2Off(void)
{
	if (TabletControlData.SensorState2 == SENSOR_STATE_ON)
	{
		
		if(TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorOffCount <= 0)
		{
			TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorLength = board50usTmr - TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorOnTime-SENSOR_MIN_COUNT;
			if (Disk2Encoder_value_sum  > TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderOnVaule)
			{
				TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderLength = Disk2Encoder_value_sum  - TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderOnVaule;
			}
			else
			{
				TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderLength = (Disk2Encoder_value_sum + ENCODER_MASK) - TabletSensorQueue[1].List[TabletSensorQueue[1].End].EncoderOnVaule;
			}			
			TabletControlData.SensorState2 = SENSOR_STATE_OFF;
			TabletSensorQueue[1].End = (TabletSensorQueue[1].End + 1) & TABLET_SENSOR_LIST_MASK;
		}
		else
		{
			TabletSensorQueue[1].List[TabletSensorQueue[1].End].SensorOffCount--;
		}
	}
}

void TabletControl_Sensor3On(void)
{
	if (TabletControlData.SensorState3 == SENSOR_STATE_OFF)
	{
		TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorOnTime = board50usTmr;
		TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorOffCount = SENSOR_MIN_COUNT;
		TabletSensorQueue[2].List[TabletSensorQueue[2].End].MisFeeding = 0;
		TabletControlData.SensorState3 = SENSOR_STATE_ON;
	}
	else
	{
		TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorOffCount = SENSOR_MIN_COUNT;
	}
}

void TabletControl_Sensor3Off(void)
{
	if (TabletControlData.SensorState3 == SENSOR_STATE_ON)
	{
		if(TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorOffCount <= 0)
		{		
			TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorLength = board50usTmr - TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorOnTime;
			TabletSensorQueue[2].End = (TabletSensorQueue[2].End + 1) & TABLET_SENSOR_LIST_MASK;
			TabletControlData.SensorState3 = SENSOR_STATE_OFF;
		}
		else
		{
			TabletSensorQueue[2].List[TabletSensorQueue[2].End].SensorOffCount--;

		}		
	}
}


void AdvanceDisk1TabletList(void)
{
	int	captureIndex;

	THCBDisk1TabletUnit	*nextDisk1TabletListUnit;
	// init	next tablet	unit
	TabletInfo.CurrentSensor1ListIndex = (TabletInfo.CurrentSensor1ListIndex + 1) & HCB_TABLET_LIST_MASK;
	TabletInfo.CurrentTabletNumber++;
	if (TabletInfo.CurrentTabletNumber > MAX_TABLET_NUMBER)
	{
		TabletInfo.CurrentTabletNumber = 1;
	}

	nextDisk1TabletListUnit	= &(TabletInfo.Disk1TabletList[TabletInfo.CurrentSensor1ListIndex]);
	nextDisk1TabletListUnit->TabletNumber = TabletInfo.CurrentTabletNumber;
	nextDisk1TabletListUnit->State = TABLET_STATE_READY;
	nextDisk1TabletListUnit->InspectionResult = TABLET_RESULT_NONE;
	nextDisk1TabletListUnit->Sensor1Time = 0;
	nextDisk1TabletListUnit->EstimatedSensor2Time= 0;

	for (captureIndex = 0; captureIndex	< ILLUMINATION_ACTIVE_COUNT; captureIndex++)    //ILLUMINATION_ACTIVE_COUNT  3  ϴ Ȯ ...
	{
		nextDisk1TabletListUnit->IsLEDOn[captureIndex] = 0;
	}
}

void AdvanceDisk2TabletList(void)
{
	int	spbIndex, captureIndex;
	THCBDisk2TabletUnit	*nextDisk2TabletListUnit;

	TabletInfo.CurrentSensor2ListIndex = (TabletInfo.CurrentSensor2ListIndex + 1) & HCB_TABLET_LIST_MASK;
	nextDisk2TabletListUnit	= &(TabletInfo.Disk2TabletList[TabletInfo.CurrentSensor2ListIndex]);

	nextDisk2TabletListUnit->TabletNumber	= 0;
	nextDisk2TabletListUnit->State	= TABLET_STATE_READY;
	nextDisk2TabletListUnit->InspectionResult	= TABLET_RESULT_NONE;
	nextDisk2TabletListUnit->Ejection	= TABLET_EJECTION_NONE;
	nextDisk2TabletListUnit->EjectionCheck	= TABLET_EJECTION_CHECK_NONE;
	nextDisk2TabletListUnit->Sensor1Time = 0;
	nextDisk2TabletListUnit->Sensor1Length= 0;
	nextDisk2TabletListUnit->Sensor2Time = 0;
	nextDisk2TabletListUnit->Sensor2Length= 0;
	nextDisk2TabletListUnit->Sensor3Time = 0;
	nextDisk2TabletListUnit->Sensor3Length= 0;
	nextDisk2TabletListUnit->EstimatedSensor2Time= 0;
	nextDisk2TabletListUnit->EstimatedSensor3Time= 0;
	

	for (spbIndex = 0; spbIndex	< MachineSetupData.IPB_BoardCount;	spbIndex++)
	{
		nextDisk2TabletListUnit->InspectionResult_SPB[spbIndex]	= SPB_TABLET_RESULT_NONE;
	}

	for (captureIndex = 0; captureIndex	< ILLUMINATION_ACTIVE_COUNT; captureIndex++)
	{
		nextDisk2TabletListUnit->IsLEDOn[captureIndex] = 0;
	}
}

void AdvanceCounterTabletList(void)
{
	THCBCounterTabletUnit *nextCounterTabletListUnit;

	TabletInfo.CurrentSensor3ListIndex = (TabletInfo.CurrentSensor3ListIndex + 1) & HCB_TABLET_LIST_MASK;
	nextCounterTabletListUnit = &(TabletInfo.CounterTabletList[TabletInfo.CurrentSensor3ListIndex]);
	nextCounterTabletListUnit->State = TABLET_STATE_READY;
}

void SuctionDisk1SensorCheckProcess(void)
{
	char tabletDetected, misfeedingTabletDetected, expectedTabletCount; //normalTabletDetected,multiTabletDetected
	unsigned int detectedSensorOnTime, detectedSensorLength;
	int SensorEncoderOnValue, SensorEncoderLength;
	int	tabletListIndex, tabletIndex;
	unsigned int tabletSensorOnTime, tabletSensorLength;
	int	prevTabletListIndex;
	int LengthErrorDetected=0;
	unsigned short encoder_value_H = 0,encoder_value_L=0;
	unsigned short temp1 = 0,temp2=0;
	CSL_IntcGlobalEnableState 	state;

	tabletDetected = 0;
	misfeedingTabletDetected = 0;

	if (TabletSensorQueue[0].Start != TabletSensorQueue[0].End)
	{
		if (TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength <= TabletControlData.MinSensorLength)
		{
			TabletSensorQueue[0].Start = (TabletSensorQueue[0].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}
		else if (TabletSensorQueue[0].List[TabletSensorQueue[0].Start].MisFeeding && (TabletControlSetupData.CaptureOption == 0 || TabletControlSetupData.CaptureOption == 2))
		{
			tabletDetected = 1;
			expectedTabletCount	= 1;
			misfeedingTabletDetected = 1;
			SensorEncoderOnValue	= TabletSensorQueue[0].List[TabletSensorQueue[0].Start].EncoderOnVaule;
			SensorEncoderLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].EncoderLength;
			detectedSensorOnTime = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorOnTime;
			detectedSensorLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength;
			TabletSensorQueue[0].Start = (TabletSensorQueue[0].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}
		else if (TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength >= (1.5* TabletControlData.ExpectedSensor1Length) )	 // too large	tablet
		{
			tabletDetected = 1;
			expectedTabletCount	= (((float)TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength / (float)TabletControlData.ExpectedSensor1Length)+0.5);
			SensorEncoderOnValue	= TabletSensorQueue[0].List[TabletSensorQueue[0].Start].EncoderOnVaule;
			SensorEncoderLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].EncoderLength;
			detectedSensorOnTime = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorOnTime;
			detectedSensorLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength;
			TabletSensorQueue[0].Start = (TabletSensorQueue[0].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}		
		else
		{
			tabletDetected = 1;
			expectedTabletCount	= 1;
			SensorEncoderOnValue	= TabletSensorQueue[0].List[TabletSensorQueue[0].Start].EncoderOnVaule;
			SensorEncoderLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].EncoderLength;
			detectedSensorOnTime = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorOnTime;
			detectedSensorLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength;
			TabletSensorQueue[0].Start = (TabletSensorQueue[0].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}
	}

	if (tabletDetected)
	{
		tabletSensorOnTime = detectedSensorOnTime;
		tabletSensorLength = detectedSensorLength / expectedTabletCount;

		for (tabletIndex = 0; tabletIndex < expectedTabletCount; tabletIndex++)
		{
			tabletListIndex	= TabletInfo.CurrentSensor1ListIndex;

			TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Time	= tabletSensorOnTime;
			TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder	= SensorEncoderOnValue;
			TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Length = tabletSensorLength;
			TabletInfo.Disk1TabletList[tabletListIndex].EstimatedSensor2Time = TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Time + TabletControlData.SensorIntervalA;
			TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntEncoder = (SensorEncoderLength/2) + TabletControlData.CaptureIntDelay;
			
			if(LasercomplexerInfo.Laser_Trig_mode)
			{
			 	do
			 	{
					CSL_intcGlobalDisable(&state);
					encoder_value_L = (SENSOR_ENCODER_VALUE_L&0xFFFF);
					encoder_value_H = (SENSOR_ENCODER_VALUE_H&0xF);
					temp1 = (SENSOR_ENCODER_VALUE_L&0xFFFF);
					temp2 = (SENSOR_ENCODER_VALUE_H&0xF);
					CSL_intcGlobalEnable(&state);
			 	}while(encoder_value_L != temp1 || encoder_value_H != temp2);
				
				encoder_value_L = encoder_value_L & 0xFFFF;
				encoder_value_H = encoder_value_H & 0xF;
						
				TabletInfo.Disk1TabletList[tabletListIndex].SensorOnEncoder += encoder_value_L;
				TabletInfo.Disk1TabletList[tabletListIndex].SensorOnEncoder += encoder_value_H<<16;
				
				if(TabletInfo.Disk1TabletList[tabletListIndex].SensorOnEncoder > TabletControlData.LaserTrgEncoderValue) 
				{
					TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoder = TabletInfo.Disk1TabletList[tabletListIndex].SensorOnEncoder - TabletControlData.LaserTrgEncoderValue;
				}
				else
				{
					TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoder = (TabletInfo.Disk1TabletList[tabletListIndex].SensorOnEncoder + 0xFFFFF) - TabletControlData.LaserTrgEncoderValue;
				}
				
				TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoderL = encoder_value_L;
				TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoderH = encoder_value_H;

			}
			
			if (misfeedingTabletDetected)
			{
				TabletInfo.Disk1TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_SENSOR_1_MISFEEDING;
				TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_ERROR;
			}
			else
			{
				if(LasercomplexerInfo.Laser_complexer_Enable)
				{				
					 if(expectedTabletCount > 1)
					{
						TabletInfo.Disk1TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_MULTI_TABLET_SENSOR_2;
						TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_ERROR;								
					}
					else
					{
						if(tabletSensorLength < TabletControlData.ExpectedSensor1Length * 0.5) 
						{
							TabletInfo.Disk1TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_MULTI_TABLET_SENSOR_2;
							TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_ERROR;		
						}
						else if(tabletSensorLength > TabletControlData.ExpectedSensor1Length * 1.3) 
						{
							TabletInfo.Disk1TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_MULTI_TABLET_SENSOR_2;
							TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_ERROR;		
						}
						else
						{
							TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_SENSOR_1_PASSED;
						}
					}
				}
				else 
				{
					TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_SENSOR_1_PASSED;
				}
			}
			AdvanceDisk1TabletList();
			TabletInspectInfo.Disk1TabletCount++;
			tabletSensorOnTime += tabletSensorLength;			
		}

	}
}

//---------------------------------------------------------------------------

void SuctionDisk1LaserPrintProcess(void)
{
	int tabletListIndex;
	unsigned short encoder_value_L=0;
	unsigned short encoder_value_H=0;
	unsigned int ReadEncoder = 0;
	CSL_IntcGlobalEnableState 	state;
	

	tabletListIndex	= TabletInfo.CurrentLaser1ListIndex;
	if (TabletInfo.Disk1TabletList[tabletListIndex].State == TABLET_STATE_ERROR)
	{
		TabletInfo.CurrentLaser1ListIndex	= (TabletInfo.CurrentLaser1ListIndex + 1)	& HCB_TABLET_LIST_MASK;
	}
	else if (TabletInfo.Disk1TabletList[tabletListIndex].State != TABLET_STATE_READY)
	{
		if (TabletControlData.Func & TABLET_CONTROL_FUNC_CAPTURE_REQUIRED && TabletControlData.Func != TABLET_CONTROL_FUNC_STUDY)
		{	
			if(LasercomplexerInfo.Laser_Trig_mode)
			{
				if(Disk1Encoder_value_sum - TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder < 0 ) 
				{
					if ( (TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder - Disk1Encoder_value_sum) > (TabletControlData.LaserTrgEncoderValue - 3000))
					{
						CSL_intcGlobalDisable(&state);
						LASERTRIGER_ENCODER_VALUE_L = TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoder&0xFFFF;
						LASERTRIGER_ENCODER_VALUE_H = (TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoder>>16)&0xF;
						CSL_intcGlobalEnable(&state);
						TabletInfo.CurrentLaser1ListIndex = (TabletInfo.CurrentLaser1ListIndex + 1) & HCB_TABLET_LIST_MASK;
						lastLaserPrintingTime = board50usTmr;
					}
				}
				else 
				{
					if ( (TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder - (Disk1Encoder_value_sum-ENCODER_MASK)) > (TabletControlData.LaserTrgEncoderValue -3000))
					{
						
						CSL_intcGlobalDisable(&state);
						LASERTRIGER_ENCODER_VALUE_L = TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoderL;
						LASERTRIGER_ENCODER_VALUE_H = TabletInfo.Disk1TabletList[tabletListIndex].LaserTriggerEncoderH;
						CSL_intcGlobalEnable(&state);
						TabletInfo.CurrentLaser1ListIndex = (TabletInfo.CurrentLaser1ListIndex + 1) & HCB_TABLET_LIST_MASK;
						lastLaserPrintingTime = board50usTmr;
					}
				}
			}
			else
			{
				if(Disk1Encoder_value_sum > TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder) 
				{
					if ( (Disk1Encoder_value_sum - TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder) > TabletControlData.LaserTrgEncoderValue)
					{
						MC_LASER_Trigger_On(SUCTION_DISK_NUM1 - 1, 2);
						PORT_ChangeOutPort(OP_SD1_LASER_PRINT_TRIG, 1);
						TabletInfo.CurrentLaser1ListIndex = (TabletInfo.CurrentLaser1ListIndex + 1) & HCB_TABLET_LIST_MASK;
						lastLaserPrintingTime = board50usTmr;
					}
				}
				else 
				{
					if (((Disk1Encoder_value_sum + ENCODER_MASK) - TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder) > TabletControlData.LaserTrgEncoderValue)
					{
						MC_LASER_Trigger_On(SUCTION_DISK_NUM1 - 1, 2);
						PORT_ChangeOutPort(OP_SD1_LASER_PRINT_TRIG, 1);
						TabletInfo.CurrentLaser1ListIndex = (TabletInfo.CurrentLaser1ListIndex + 1) & HCB_TABLET_LIST_MASK;
						lastLaserPrintingTime = board50usTmr;
					}
				}
			}
		}
		else
		{
			TabletInfo.CurrentLaser1ListIndex = (TabletInfo.CurrentLaser1ListIndex + 1) & HCB_TABLET_LIST_MASK;
		}
	}
}

//---------------------------------------------------------------------------
void SuctionDisk1CaptureProcess(void)
{
	int	tabletListIndex;

	tabletListIndex	= TabletInfo.CurrentInt1ListIndex;
	if (TabletInfo.Disk1TabletList[tabletListIndex].State == TABLET_STATE_ERROR)
	{
		TabletInfo.CurrentInt1ListIndex	= (TabletInfo.CurrentInt1ListIndex + 1)	& HCB_TABLET_LIST_MASK;
	}
	else if (TabletInfo.Disk1TabletList[tabletListIndex].State == TABLET_STATE_SENSOR_1_PASSED) //TABLET_STATE_LASER_TRIG_1_TRANSFERRED)
	{
		if (TabletControlData.Func & TABLET_CONTROL_FUNC_CAPTURE_REQUIRED)
		{
			if(Disk1Encoder_value_sum > TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder) 
			{
				if ( (Disk1Encoder_value_sum - TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder) > (TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntEncoder ))
				{
					TabletCaptureInformation.Sensor1TabletNumber = TabletInfo.Disk1TabletList[tabletListIndex].TabletNumber;
					TabletCaptureInformation.Sensor1ActivateTime = board50usTmr;
					TabletCaptureInformation.Sensor1TabletNumberValid = 1;
					TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntTime = board50usTmr;
					SendCaptureInt(0);
					TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_CAPTURE_INT_1_TRANSFERRED;
					TabletInfo.CurrentInt1ListIndex	= (TabletInfo.CurrentInt1ListIndex + 1)	& HCB_TABLET_LIST_MASK;				
				}
			}
			else 
			{
				if (((Disk1Encoder_value_sum + ENCODER_MASK) - TabletInfo.Disk1TabletList[tabletListIndex].Disk1Encoder) > (TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntEncoder ))
				{
					TabletCaptureInformation.Sensor1TabletNumber = TabletInfo.Disk1TabletList[tabletListIndex].TabletNumber;
					TabletCaptureInformation.Sensor1ActivateTime = board50usTmr;
					TabletCaptureInformation.Sensor1TabletNumberValid = 1;
					TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntTime = board50usTmr;
					SendCaptureInt(0);
					TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_CAPTURE_INT_1_TRANSFERRED;
					TabletInfo.CurrentInt1ListIndex	= (TabletInfo.CurrentInt1ListIndex + 1)	& HCB_TABLET_LIST_MASK;		
				}
			}
			
			/*	
			if (((int)board50usTmr - TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntTime) > 0)
			{
				TabletCaptureInformation.Sensor1TabletNumber = TabletInfo.Disk1TabletList[tabletListIndex].TabletNumber;
				TabletCaptureInformation.Sensor1ActivateTime = board50usTmr;
				TabletCaptureInformation.Sensor1TabletNumberValid = 1;
				SendCaptureInt(0);
				TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_CAPTURE_INT_1_TRANSFERRED;
				TabletInfo.CurrentInt1ListIndex	= (TabletInfo.CurrentInt1ListIndex + 1)	& HCB_TABLET_LIST_MASK;
			}
			*/
		}
		else
		{
			TabletInfo.CurrentInt1ListIndex	= (TabletInfo.CurrentInt1ListIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
	}
}

//---------------------------------------------------------------------------
void SuctionDisk1IlluminatorProcess(void)
{
	int	pollingTableIndex, captureIndex;
	int	elapsedTime;
	char captureComplete;
	THCBDisk1TabletUnit	*disk1TabletUnit;

	// checking	sensor 1
	pollingTableIndex = TabletInfo.CurrentCapture1ListIndex;
	disk1TabletUnit	= &(TabletInfo.Disk1TabletList[pollingTableIndex]);
	if (disk1TabletUnit->State == TABLET_STATE_ERROR)
	{
		TabletInfo.CurrentCapture1ListIndex	= (TabletInfo.CurrentCapture1ListIndex + 1)	& HCB_TABLET_LIST_MASK;
	}
	else if (disk1TabletUnit->State	== TABLET_STATE_CAPTURE_INT_1_TRANSFERRED)
	{
		elapsedTime	= board50usTmr - disk1TabletUnit->CaptureIntTime;
		captureComplete	= 1;
		for (captureIndex = 0; captureIndex	< ILLUMINATION_ACTIVE_COUNT; captureIndex++)
		{
			if (disk1TabletUnit->IsLEDOn[captureIndex] == 0)
			{
				if (elapsedTime	> (TabletControlData.IlluminatorDelay[captureIndex]))
				{
					HCB_Caputre_LEDOn(TabletControlData.IlluminatorMask[captureIndex], TabletControlSetupData.IlluminatorTime[captureIndex]);
					disk1TabletUnit->IsLEDOn[captureIndex] = 1;
				}
				else
				{
					captureComplete	= 0;
				}
			}
		}
		if (captureComplete)
		{
			disk1TabletUnit->State = TABLET_STATE_CAPTURE_1_COMPLETE;
			TabletInfo.CurrentCapture1ListIndex	= (TabletInfo.CurrentCapture1ListIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
	}
}
//---------------------------------------------------------------------------
void SuctionDisk2SensorCheckProcess(void)
{
	char tabletDetected, misfeedingTabletDetected, expectedTabletCount, normalTabletDetected; //multiTabletDetected
	unsigned int detectedSensorOnTime, detectedSensorLength;
	int	tabletListIndex, prevTabletListIndex, relatedDisk1TabletListIndex, relatedDisk1NextTabletListIndex, tabletIndex;
	unsigned int tabletSensorOnTime, tabletSensorLength;
	unsigned int Checkcount, prevCheckcount, nextcheckcount;
	int SensorEncoderOnValue, SensorEncoderLength;

	//2016.11.03 Add
	int LengthErrorDetected;
	tabletDetected = 0;
	normalTabletDetected = 0;
	misfeedingTabletDetected = 0;
	LengthErrorDetected	= 0;
	SensorEncoderOnValue = 0;
	SensorEncoderLength = 0;

	if (TabletControlSetupData.CaptureOption == 1)
	{
		if (TabletSensorQueue[1].Start != TabletSensorQueue[1].End)
		{
			if (TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength <= TabletControlData.MinSensorLength) //SENSOR_MIN_TIME =  10
			{

				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
			else
			{
				tabletDetected = 1;
				expectedTabletCount	= 1;
				normalTabletDetected = 1;
				SensorEncoderOnValue	= TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderOnVaule;
				SensorEncoderLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderLength;
				detectedSensorOnTime = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime;
				detectedSensorLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength;
				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
		}

		if (tabletDetected)
		{
			tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
			tabletSensorOnTime = detectedSensorOnTime;
			tabletSensorLength = detectedSensorLength;

			TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;
			TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;
			TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder = SensorEncoderOnValue;
			TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntEncoder	= SensorEncoderLength / 2 + TabletControlData.CaptureIntDelay;
			TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].TabletNumber;
			TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Time;
			TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Length;
			TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[tabletListIndex].EstimatedSensor2Time;
			TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time	= tabletSensorOnTime+ TabletControlData.SensorIntervalB;
			TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= tabletSensorOnTime + TabletControlData.DefectEjectorDelay;
			TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= tabletSensorOnTime + TabletControlData.UnInsEjectorDelay;
			TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= tabletSensorOnTime + TabletControlData.GoodEjectorDelay;
			TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorLength    = TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length;
			TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorLength	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length;
			TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorLength	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length;		

			TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_SENSOR_2_PASSED;

			AdvanceDisk2TabletList();
			TabletInspectInfo.Disk2TabletCount++;
		}
	}
	else
	{
		if (TabletSensorQueue[1].Start != TabletSensorQueue[1].End)
		{
			if (TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength <= TabletControlData.MinSensorLength) //SENSOR_MIN_TIME =  10
			{
				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
			else if (TabletSensorQueue[1].List[TabletSensorQueue[1].Start].MisFeeding)
			{
				tabletDetected = 1;
				expectedTabletCount	= 1;
				misfeedingTabletDetected = 1;
				SensorEncoderOnValue	= TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderOnVaule;
				SensorEncoderLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderLength;				
				detectedSensorOnTime = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime;
				detectedSensorLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength;
				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
			else if (TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength >= (1.5 * TabletControlData.ExpectedSensor2Length) )
			{
				tabletDetected = 1;
				LengthErrorDetected	= 1;
				SensorEncoderOnValue	= TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderOnVaule;
				SensorEncoderLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderLength;				
				expectedTabletCount	= (((float)TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength / (float)TabletControlData.ExpectedSensor2Length)+0.5);
				detectedSensorOnTime = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime;
				detectedSensorLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength;
				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
			else if (TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength <= (0.5 * TabletControlData.ExpectedSensor2Length) )
			{
				tabletDetected = 1;
				expectedTabletCount	= 1;
				LengthErrorDetected	= 1;
				SensorEncoderOnValue	= TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderOnVaule;
				SensorEncoderLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderLength;					
				detectedSensorOnTime = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime;
				detectedSensorLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength;
				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
			else
			{
				tabletDetected = 1;
				expectedTabletCount	= 1;
				normalTabletDetected = 1;
				SensorEncoderOnValue	= TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderOnVaule;
				SensorEncoderLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].EncoderLength;					
				detectedSensorOnTime = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime;
				detectedSensorLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength;
				TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
			}
		}

		if (tabletDetected)
		{
			if (misfeedingTabletDetected)     //Disk Run ° ƴ   Ҿ.
			{
				tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= detectedSensorOnTime;
				TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder = SensorEncoderOnValue;
				TabletInfo.Disk2TabletList[tabletListIndex].Disk2EncoderLength = SensorEncoderLength;
				InspectionResultTable.Table[tabletListIndex].EjectOnTime	= detectedSensorOnTime;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= detectedSensorLength;
				TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntEncoder	= TabletInfo.Disk2TabletList[tabletListIndex].Disk2EncoderLength  / 2 + TabletControlData.CaptureIntDelay;
				TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time = TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB;
				if (TabletControlData.Func & TABLET_CONTROL_FUNC_CAPTURE_REQUIRED)
				{
					if (TabletInfo.Disk1TabletList[tabletListIndex].State != TABLET_STATE_READY)
					{
						TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].TabletNumber;
						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time;
					}
					else
					{
						TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber = 0;
						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time = 0;
					}

					TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= detectedSensorOnTime + TabletControlData.DefectEjectorDelay-TabletControlData.ExpectedSensor2Length*2;
					TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= detectedSensorOnTime + TabletControlData.UnInsEjectorDelay-TabletControlData.ExpectedSensor2Length*2;
					TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= detectedSensorOnTime + TabletControlData.GoodEjectorDelay-TabletControlData.ExpectedSensor2Length*2;
					TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorLength    = detectedSensorLength + TabletControlData.ExpectedSensor2Length*5;
					TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorLength	= detectedSensorLength + TabletControlData.ExpectedSensor2Length*5;
					TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorLength	= detectedSensorLength + TabletControlData.ExpectedSensor2Length*5;					
				}
				TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TABLET_RESULT_SENSOR_2_MISFEEDING;    //̰ ó
				TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_ERROR;
				AdvanceDisk2TabletList();
				TabletInspectInfo.Disk2TabletCount++;
			}
			else if (LengthErrorDetected)	//    Ҿ.
			{
				tabletSensorOnTime = detectedSensorOnTime;
				tabletSensorLength = detectedSensorLength / expectedTabletCount;
				SensorEncoderLength = SensorEncoderLength /expectedTabletCount;
				
				for (tabletIndex = 0; tabletIndex < expectedTabletCount; tabletIndex++)
				{
					tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
					prevTabletListIndex	= (tabletListIndex - 1)	& HCB_TABLET_LIST_MASK;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].Sensor1Time;
					TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder = SensorEncoderOnValue;
					TabletInfo.Disk2TabletList[tabletListIndex].Disk2EncoderLength = SensorEncoderLength+2000;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].Sensor1Length;
					TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].TabletNumber;
					TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time = TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;
					InspectionResultTable.Table[tabletListIndex].EjectOnTime	= tabletSensorOnTime;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;
					TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntEncoder	= SensorEncoderLength / 2 + TabletControlData.CaptureIntDelay;
					TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time = TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB;

					TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= tabletSensorOnTime + TabletControlData.DefectEjectorDelay;
					TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= tabletSensorOnTime + TabletControlData.UnInsEjectorDelay;
					TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= tabletSensorOnTime + TabletControlData.GoodEjectorDelay;
					TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorLength    = expectedTabletCount;
					TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorLength	= tabletSensorLength;
					TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorLength	= tabletSensorLength;						
					TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TABLET_RESULT_MULTI_TABLET_SENSOR_2;    // ҷ
					TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_ERROR;
					AdvanceDisk2TabletList();
					TabletInspectInfo.Disk2TabletCount++;
					tabletSensorOnTime += tabletSensorLength;
					SensorEncoderOnValue+= SensorEncoderLength;
				}
			}
			else
			{
				tabletSensorOnTime = detectedSensorOnTime;
				tabletSensorLength = detectedSensorLength;
				tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;
				TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder = SensorEncoderOnValue;
				TabletInfo.Disk2TabletList[tabletListIndex].Disk2EncoderLength = SensorEncoderLength;
				TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].TabletNumber;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].Sensor1Time;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].Sensor1Length;
				TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[(tabletListIndex-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time;	
				TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntEncoder	= SensorEncoderLength / 2 + TabletControlData.CaptureIntDelay;
				TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB;
				TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= tabletSensorOnTime + TabletControlData.DefectEjectorDelay;
				TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= tabletSensorOnTime + TabletControlData.UnInsEjectorDelay;
				TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= tabletSensorOnTime + TabletControlData.GoodEjectorDelay;
				TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorLength    = tabletSensorLength;
				TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorLength	= tabletSensorLength;
				TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorLength	= tabletSensorLength;		
				AdvanceDisk2TabletList();
				TabletInspectInfo.Disk2TabletCount++;
			}
		}
		if (TabletInfo.CurrentSersorCheckCount !=  TabletInfo.CurrentSensor2ListIndex && TabletInfo.Disk1TabletList[(TabletInfo.CurrentSersorCheckCount-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].Sensor1Time !=0)
		{		
			if(TabletControlData.Func & TABLET_CONTROL_FUNC_MATCHING_REQUIRED)
			{
				Checkcount = TabletInfo.CurrentSersorCheckCount;
				tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
				nextcheckcount	= (Checkcount + 1)	& HCB_TABLET_LIST_MASK;
				prevCheckcount	= (Checkcount - 1)	& HCB_TABLET_LIST_MASK;
				if(TabletInfo.Disk2TabletList[Checkcount].State	== TABLET_STATE_ERROR)
				{
					//sensor   üũ . 
					TabletInfo.Disk2TabletList[Checkcount].State = TABLET_STATE_ERROR;
				}
				else
				{
					if((TabletInfo.Disk2TabletList[Checkcount].Sensor2Time - TabletInfo.Disk1TabletList[(Checkcount-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time) < -(TabletControlData.ExpectedSensor2Length*0.5 + SENSOR_LENGTH_MISS_BOUNDARY))
					{
						if (abs(TabletInfo.Disk2TabletList[Checkcount].Sensor2Time - TabletInfo.Disk1TabletList[(Checkcount-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time) > (TabletControlData.ExpectedSensor2Length*0.5 + SENSOR_LENGTH_MISS_BOUNDARY))
						{
							TabletInfo.Disk2TabletList[Checkcount].TabletNumber	= TabletInfo.Disk2TabletList[Checkcount].TabletNumber-1;
							TabletInfo.Disk2TabletList[Checkcount].InspectionResult	= TABLET_RESULT_INSERTED;
							TabletInfo.Disk2TabletList[Checkcount].State	= TABLET_STATE_ERROR;
							TabletInfo.CurrentRelatedDisk1TabletListIndex++;
						}
						else
						{
							//   
							TabletInfo.Disk2TabletList[prevCheckcount].InspectionResult	= TABLET_RESULT_NONE;
							TabletInfo.Disk2TabletList[prevCheckcount].State	= TABLET_STATE_SENSOR_2_PASSED;
						}						
					}
					else if ((TabletInfo.Disk2TabletList[Checkcount].Sensor2Time - TabletInfo.Disk1TabletList[(Checkcount-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time) > (TabletControlData.ExpectedSensor2Length*0.8 + SENSOR_LENGTH_MISS_BOUNDARY))
					{
						if (abs(TabletInfo.Disk2TabletList[Checkcount].Sensor2Time - TabletInfo.Disk1TabletList[(Checkcount-TabletInfo.CurrentRelatedDisk1TabletListIndex)& HCB_TABLET_LIST_MASK].EstimatedSensor2Time) > (TabletControlData.ExpectedSensor2Length*0.8 + SENSOR_LENGTH_MISS_BOUNDARY))
						{

							//ϳ  (ſ ߿)
							AdvanceDisk2TabletList();
							TabletInspectInfo.Disk2TabletCount++;
							TabletInfo.Disk2TabletList[nextcheckcount].Sensor1Time	= TabletInfo.Disk2TabletList[Checkcount].Sensor1Time;
							TabletInfo.Disk2TabletList[nextcheckcount].Sensor1Length = TabletInfo.Disk2TabletList[Checkcount].Sensor1Length;
							TabletInfo.Disk2TabletList[nextcheckcount].Disk2Encoder	= TabletInfo.Disk2TabletList[Checkcount].Disk2Encoder+TabletInfo.Disk2TabletList[Checkcount].Sensor1Length;
							TabletInfo.Disk2TabletList[nextcheckcount].Disk2EncoderLength = TabletInfo.Disk2TabletList[nextcheckcount].Disk2EncoderLength+3000;							
							TabletInfo.Disk2TabletList[nextcheckcount].Sensor2Time = TabletInfo.Disk2TabletList[Checkcount].Sensor2Time;
							TabletInfo.Disk2TabletList[nextcheckcount].TabletNumber	= TabletInfo.Disk2TabletList[Checkcount].TabletNumber+1;
							TabletInfo.Disk2TabletList[nextcheckcount].CaptureIntEncoder = TabletInfo.Disk2TabletList[Checkcount].CaptureIntEncoder;
							TabletInfo.Disk2TabletList[nextcheckcount].Sensor2Length = TabletInfo.Disk2TabletList[Checkcount].Sensor2Length;
							TabletInfo.Disk2TabletList[nextcheckcount].EstimatedSensor2Time	= TabletInfo.Disk2TabletList[Checkcount].EstimatedSensor2Time;
							TabletInfo.Disk2TabletList[nextcheckcount].EstimatedSensor3Time = TabletInfo.Disk2TabletList[Checkcount].EstimatedSensor3Time;
							TabletInfo.Disk2TabletList[nextcheckcount].DefectEjectorTime	= TabletInfo.Disk2TabletList[Checkcount].DefectEjectorTime;
							TabletInfo.Disk2TabletList[nextcheckcount].UnInsEjectorTime	= TabletInfo.Disk2TabletList[Checkcount].UnInsEjectorTime;
							TabletInfo.Disk2TabletList[nextcheckcount].GoodEjectorTime = TabletInfo.Disk2TabletList[Checkcount].GoodEjectorTime;
							TabletInfo.Disk2TabletList[nextcheckcount].DefectEjectorLength    = TabletInfo.Disk2TabletList[Checkcount].DefectEjectorLength;
							TabletInfo.Disk2TabletList[nextcheckcount].UnInsEjectorLength	= TabletInfo.Disk2TabletList[Checkcount].UnInsEjectorLength;
							TabletInfo.Disk2TabletList[nextcheckcount].GoodEjectorLength	= TabletInfo.Disk2TabletList[Checkcount].GoodEjectorLength;						
							TabletInfo.Disk2TabletList[Checkcount].DefectEjectorTime	= TabletInfo.Disk2TabletList[Checkcount].DefectEjectorTime-TabletControlData.ExpectedSensor2Length*0.2;
							TabletInfo.Disk2TabletList[Checkcount].UnInsEjectorTime	= TabletInfo.Disk2TabletList[Checkcount].UnInsEjectorTime-TabletControlData.ExpectedSensor2Length*0.2;
							TabletInfo.Disk2TabletList[Checkcount].GoodEjectorTime = TabletInfo.Disk2TabletList[Checkcount].GoodEjectorTime-TabletControlData.ExpectedSensor2Length*0.2;		
							TabletInfo.Disk2TabletList[Checkcount].InspectionResult	= TABLET_RESULT_DISAPPEARED;
							TabletInfo.Disk2TabletList[Checkcount].State	= TABLET_STATE_ERROR;
						}
						else
						{
							TabletInfo.Disk2TabletList[Checkcount].InspectionResult	= TABLET_RESULT_NONE;
							TabletInfo.Disk2TabletList[Checkcount].State	= TABLET_STATE_SENSOR_2_PASSED;
						}
					}
					else
					{
						TabletInfo.Disk2TabletList[Checkcount].InspectionResult	= TABLET_RESULT_NONE;
						TabletInfo.Disk2TabletList[Checkcount].State	= TABLET_STATE_SENSOR_2_PASSED;
					}
				}
				TabletInfo.CurrentSersorCheckCount = (TabletInfo.CurrentSersorCheckCount + 1) & HCB_TABLET_LIST_MASK;
			}
			else
			{
				TabletInfo.Disk2TabletList[Checkcount].InspectionResult	= TABLET_RESULT_NONE;
				TabletInfo.Disk2TabletList[Checkcount].State	= TABLET_STATE_SENSOR_2_PASSED;
				TabletInfo.CurrentSersorCheckCount = (TabletInfo.CurrentSersorCheckCount + 1) & HCB_TABLET_LIST_MASK;
			}			
		}
	}
}
//---------------------------------------------------------------------------
void SuctionDisk2CaptureProcess(void)
{
	int	tabletListIndex;

	tabletListIndex	= TabletInfo.CurrentInt2ListIndex;
	if (TabletInfo.Disk2TabletList[tabletListIndex].State == TABLET_STATE_ERROR)
	{
		TabletInfo.CurrentInt2ListIndex	= (TabletInfo.CurrentInt2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
	}
	else if (TabletInfo.Disk2TabletList[tabletListIndex].State == TABLET_STATE_SENSOR_2_PASSED)
	{
		if (TabletControlData.Func & TABLET_CONTROL_FUNC_CAPTURE_REQUIRED)
		{
/*			
			if (TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime < board50usTmr)
			{
				TabletCaptureInformation.Sensor2TabletNumber = TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber;
				TabletCaptureInformation.Sensor2ActivateTime = board50usTmr;
				TabletCaptureInformation.Sensor2TabletNumberValid = 1;
				TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime = board50usTmr;
				SendCaptureInt(1);
				TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_CAPTURE_INT_2_TRANSFERRED;
				TabletInfo.CurrentInt2ListIndex	= (TabletInfo.CurrentInt2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
			}
*/
			if(Disk2Encoder_value_sum > TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder) 
			{
				if ( (Disk2Encoder_value_sum - TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder) > TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntEncoder)
				{
					TabletCaptureInformation.Sensor2TabletNumber = TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber;
					TabletCaptureInformation.Sensor2ActivateTime = board50usTmr;
					TabletCaptureInformation.Sensor2TabletNumberValid = 1;
					TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime = board50usTmr;
					SendCaptureInt(1);
					TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_CAPTURE_INT_2_TRANSFERRED;
					TabletInfo.CurrentInt2ListIndex	= (TabletInfo.CurrentInt2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
				}
			}
			else 
			{
				if (((Disk2Encoder_value_sum + ENCODER_MASK) - TabletInfo.Disk2TabletList[tabletListIndex].Disk2Encoder) > TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntEncoder)
				{
					TabletCaptureInformation.Sensor2TabletNumber = TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber;
					TabletCaptureInformation.Sensor2ActivateTime = board50usTmr;
					TabletCaptureInformation.Sensor2TabletNumberValid = 1;
					TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime = board50usTmr;
					SendCaptureInt(1);
					TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_CAPTURE_INT_2_TRANSFERRED;
					TabletInfo.CurrentInt2ListIndex	= (TabletInfo.CurrentInt2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
				}
			}
		}
		else if (TabletControlData.Func	== TABLET_CONTROL_FUNC_TABLET_COUNTER)
		{
			int	defectGen = 0;
			int	uninsGen = 0;
			if (EjectionTestData.DefectGenEnabled)
			{
				if (EjectionTestData.DefectGenKind == 0)
				{
					if (EjectionTestData.DefectGenMask & (0x00000001 << EjectionTestData.DefectGenMaskIndex))
					{
						defectGen = 1;
					}
					EjectionTestData.DefectGenMaskIndex++;
					if (EjectionTestData.DefectGenMaskIndex	>= EjectionTestData.DefectGenMaskCount)
					{
						EjectionTestData.DefectGenMaskIndex	= 0;
					}
				}
				else
				{
					if (WellRng512() % 100 < EjectionTestData.DefectGenRatio)
					{
						defectGen = 1;
					}
				}
			}
			if (EjectionTestData.UnInsGenEnabled)
			{
				if (EjectionTestData.UnInsGenKind == 0)
				{
					if (EjectionTestData.UnInsGenMask &	(0x00000001	<< EjectionTestData.UnInsGenMaskIndex))
					{
						uninsGen = 1;
					}
					EjectionTestData.UnInsGenMaskIndex++;
					if (EjectionTestData.UnInsGenMaskIndex >= EjectionTestData.UnInsGenMaskCount)
					{
						EjectionTestData.UnInsGenMaskIndex = 0;
					}
				}
				else
				{
					if (WellRng512() % 100 < EjectionTestData.UnInsGenRatio)
					{
						uninsGen = 1;
					}
				}
			}
			if (TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult == TABLET_RESULT_NONE)
			{
				if (defectGen)
				{
					TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_DEFECT;
				}
				else if (uninsGen)
				{
					TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE;
				}
				else
				{
					TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_GOOD;
				}
			}
			TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_BLOW_WAITING;
			TabletInfo.CurrentInt2ListIndex	= (TabletInfo.CurrentInt2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
		else	// check interval
		{
			TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_COMPLETE;
			TabletInfo.CurrentInt2ListIndex	= (TabletInfo.CurrentInt2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
	}
}
//---------------------------------------------------------------------------
void SuctionDisk2IlluminatorProcess(void)
{
	int	pollingTableIndex=0, captureIndex=0;
	int	elapsedTime=0;
	char bError=0, bCaptureComplete=0;
	THCBDisk2TabletUnit	*disk2TabletUnit;

	pollingTableIndex = TabletInfo.CurrentCapture2ListIndex;
	disk2TabletUnit	= &(TabletInfo.Disk2TabletList[pollingTableIndex]);
	if (disk2TabletUnit->State == TABLET_STATE_ERROR)
	{
		TabletInfo.CurrentCapture2ListIndex	= (TabletInfo.CurrentCapture2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
	}
	if (disk2TabletUnit->State == TABLET_STATE_CAPTURE_INT_2_TRANSFERRED)
	{
		bError = 0;
		if (TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION)
		{
			if (disk2TabletUnit->InspectionResult != TABLET_RESULT_NONE)
			{
				disk2TabletUnit->State = TABLET_STATE_RESULT_WAITING;
				TabletInfo.CurrentCapture2ListIndex	= (TabletInfo.CurrentCapture2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
				bError = 1;
			}
		}
		if (!bError)
		{
			elapsedTime	= board50usTmr - disk2TabletUnit->CaptureIntTime;
			bCaptureComplete = 1;

			for (captureIndex = 0; captureIndex	< ILLUMINATION_ACTIVE_COUNT; captureIndex++)
			{
				if (disk2TabletUnit->IsLEDOn[captureIndex] == 0)
				{
					if (elapsedTime	> (TabletControlData.IlluminatorDelay[captureIndex + 3]))
					{
						HCB_Caputre_LEDOn(TabletControlData.IlluminatorMask[captureIndex + 3], TabletControlSetupData.IlluminatorTime[captureIndex + 3]);
						disk2TabletUnit->IsLEDOn[captureIndex] = 1;
					}
					else
					{
						bCaptureComplete = 0;
					}
				}
			}

			if (bCaptureComplete)
			{
				if (TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION)
				{
					disk2TabletUnit->State = TABLET_STATE_RESULT_WAITING;
				}
				else
				{
					disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				}
				TabletInfo.CurrentCapture2ListIndex	= (TabletInfo.CurrentCapture2ListIndex + 1)	& HCB_TABLET_LIST_MASK;
			}
		}

	}
}
//---------------------------------------------------------------------------
void InspectionResultCheckingProcess(void)
{
	// 2020-08-21
	// ˻  ҷ ó Ϻ 
	// ׽Ʈ ʿ

	int	spbIndex, heapIndex = 0xFFFF;
	unsigned char	frontPrintVal=0, rearPrintVal=0;
	unsigned char PrintType1=0, PrintType2=0;
	int	goodResultCount=0, noneResultCount=0, defectResultCount=0, uninsResultCount=0;
	int	pollingTableIndex=0;
	THCBDisk2TabletUnit	*prevDisk2TabletUnit=0;
	THCBDisk2TabletUnit	*disk2TabletUnit=0;
	int	thickErrorVal1 = 0, thickErrorVal2 = 0;
	int	DefectCheck2 = 0;
	int allCompleteSW=0;
	int positionIndex=0;
	int defectEjectStartTime=0, defectEjectDelay=0;
	int thicknessErrorSW=0;
	int printErrorSW=0;

	pollingTableIndex = TabletInfo.PollingResultTabletIndex;
	disk2TabletUnit	= &(TabletInfo.Disk2TabletList[pollingTableIndex]);
	prevDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(pollingTableIndex - 1) & HCB_TABLET_LIST_MASK]);
	if (disk2TabletUnit->State == TABLET_STATE_RESULT_WAITING)
	{
		if (disk2TabletUnit->InspectionResult != TABLET_RESULT_NONE)
		{
			if ( ((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY - disk2TabletUnit->UnInsEjectorTime )	< 0)
			{
				disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
			}
			else
			{
				disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT;
				disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
				//TabletInspectInfo.ClosedTabletDefectCount++;
			}							
			TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
		else
		{
			if ((((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY) - disk2TabletUnit->DefectEjectorTime) < 0)
			{
				if (disk2TabletUnit->InspectionResult == TABLET_RESULT_NONE)
				{
					goodResultCount	= 0;
					uninsResultCount = 0;
					noneResultCount	= 0;
					defectResultCount = 0;
					for (spbIndex = 0; spbIndex	< MachineSetupData.IPB_BoardCount;	spbIndex++)
					{
						if (InspectionOption.SPBMask & (0x0001 << spbIndex))
						{
							heapIndex = disk2TabletUnit->TabletNumber & SPB_RESULT_HEAP_MASK;
							if (disk2TabletUnit->TabletNumber == SPBResultHeap[spbIndex].ResultList[heapIndex].TabletNumber)
							{
								allCompleteSW = 1;
								for (positionIndex = 0; positionIndex < SUCTION_DISK_INDEX; positionIndex++)
								{
									if (SPBValidPostionTable[spbIndex][positionIndex])
									{
										if (!SPBResultHeap[spbIndex].ResultList[heapIndex].PositionCompleted[positionIndex])
										{
											allCompleteSW = 0;
											break;
										}
									}
								}

								if (!allCompleteSW)
									continue;

								disk2TabletUnit->InspectionResult_SPB[spbIndex]	= SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult;
							}
						}
						else
						{
							disk2TabletUnit->InspectionResult_SPB[spbIndex]	= SPB_TABLET_RESULT_GOOD;
						}

						if (disk2TabletUnit->InspectionResult_SPB[spbIndex]	== SPB_TABLET_RESULT_GOOD)
						{
							goodResultCount++;
						}
						else if (disk2TabletUnit->InspectionResult_SPB[spbIndex] != SPB_TABLET_RESULT_DEFECT &&
						         disk2TabletUnit->InspectionResult_SPB[spbIndex]	!= SPB_TABLET_RESULT_NONE &&
						         disk2TabletUnit->InspectionResult_SPB[spbIndex]	!= SPB_TABLET_RESULT_PROCESSING)	// unins
						{
							uninsResultCount++;
							disk2TabletUnit->InspectionResult = (TABLET_RESULT_SPB_MASK	| disk2TabletUnit->InspectionResult_SPB[spbIndex]);
							if (disk2TabletUnit->InspectionResult_SPB[spbIndex]	== SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED)
							{
								StatusCheckingInfo.BrightnessDropOccured = 1;
							}
							break;
						}
						else if (disk2TabletUnit->InspectionResult_SPB[spbIndex] == SPB_TABLET_RESULT_DEFECT)
						{
							defectResultCount++;
						}
						else
						{
							noneResultCount++;
						}
					}

					// 2020-12-17
					//  忡  ö; unit result ϵ 
					if (noneResultCount)
						return ;

					if (uninsResultCount > 0)
					{
						// 2020-08-21
						//  Ÿ̹ ̰  Ÿ̹ Ѿٸ Ҿ  ҷ 񿡼 óϵ?
						// ̶ unit  µ 
						// ̷ Ǹ ̰˻  ҷ 񿡼 Ҿ Ǵ Ǵ.. UI   ǥִ°   

						if ( ((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY - disk2TabletUnit->UnInsEjectorTime )	< 0)
						{
							disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
							TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
						}
						else
						{
							disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT;
							disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
							TabletInspectInfo.ClosedTabletDefectCount++;
							TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
						}

						// ̰ΰ ߰   return
						return ;
					}

					//  line code Ǹ unit  ǰ̰ų ҷ 
					// 庰 Ư ҷ   Ȯ(βҷ or ġҷ)
					if ((goodResultCount + defectResultCount) == MachineSetupData.IPB_BoardCount)
					{
						// check thickness result
						thicknessErrorSW = 0;
						heapIndex = disk2TabletUnit->TabletNumber & SPB_RESULT_HEAP_MASK;
						if (SPBResultHeap[Front3DCamera_SPBIndex].ResultList[heapIndex].ThickErrorSW1)
							thickErrorVal1 = 1;
						else if (SPBResultHeap[Front3DCamera_SPBIndex].ResultList[heapIndex].ThickErrorSW2)
							thickErrorVal1 = 2;
						else
							thickErrorVal1 = 0;

						if (SPBResultHeap[Back3DCamera_SPBIndex].ResultList[heapIndex].ThickErrorSW1)
							thickErrorVal2 = 1;
						else if (SPBResultHeap[Back3DCamera_SPBIndex].ResultList[heapIndex].ThickErrorSW2)
							thickErrorVal2 = 2;
						else
							thickErrorVal2 = 0;

						if ((thickErrorVal1 == 1) && (thickErrorVal2 == 1))
						{
							thicknessErrorSW = TABLET_RESULT_DEFECT;
						}
						else if ((thickErrorVal1 == 2) && (thickErrorVal2 == 2))
						{
							thicknessErrorSW = TABLET_RESULT_DEFECT;
						}
						// end check thickness result

						// check print result
						printErrorSW = 0;
						if (InspectionOption.CheckUnPrint && InspectionOption.UnPrintInspectionType)
						{
							heapIndex = disk2TabletUnit->TabletNumber & SPB_RESULT_HEAP_MASK;

							if (Front2DCamera_SPBIndex != Front3DCamera_SPBIndex)
							{
								frontPrintVal = SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].PrintResult | SPBResultHeap[Front3DCamera_SPBIndex].ResultList[heapIndex].PrintResult;
								PrintType1 = SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].PrintType | SPBResultHeap[Front3DCamera_SPBIndex].ResultList[heapIndex].PrintType;
							}
							else
							{
								frontPrintVal = SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].PrintResult;
								PrintType1 = SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].PrintType;
							}

							if (Back2DCamera_SPBIndex != Back3DCamera_SPBIndex)
							{
								rearPrintVal = SPBResultHeap[Back2DCamera_SPBIndex].ResultList[heapIndex].PrintResult | SPBResultHeap[Back3DCamera_SPBIndex].ResultList[heapIndex].PrintResult;
								PrintType2 = SPBResultHeap[Back2DCamera_SPBIndex].ResultList[heapIndex].PrintType | SPBResultHeap[Back3DCamera_SPBIndex].ResultList[heapIndex].PrintType;
							}
							else
							{
								rearPrintVal = SPBResultHeap[Back2DCamera_SPBIndex].ResultList[heapIndex].PrintResult;
								PrintType2 = SPBResultHeap[Back2DCamera_SPBIndex].ResultList[heapIndex].PrintType;
							}

							DefectCheck2 = 0;
							if (InspectionOption.UnPrintInspectionType &	0x100000) // ʿ μ   ϴ 
							{
								if (InspectionOption.UnPrintInspectionType &	0x010000)
								{
									if ((frontPrintVal &	rearPrintVal) == 0x01)
									{
										// ʿ  ִٰ	Ǵ 
										// laser complexer μ   ȵ
										DefectCheck2 = 1;
									}
									else if ((frontPrintVal | rearPrintVal)	== 0x00)
									{
										// 	 	 ʴ 
										DefectCheck2 = 2;
									}
								}

								if (LasercomplexerInfo.Laser_complexer_Enable==1)
								{
									// laser complexer μ  μⰡ  ȵ
									if (DefectCheck2 == 1)
									{
										printErrorSW = TABLET_RESULT_DEFECT;
									}
									else if (DefectCheck2 == 2)
									{
										printErrorSW = TABLET_RESULT_DEFECT_UNPRINT;
/*
						 				if (InspectionOption.LaserStatus)
										{
											if(SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].InspectionResult!=SPB_TABLET_RESULT_GOOD)
											{
												printErrorSW = TABLET_RESULT_DEFECT;
											}
										}
										else
										{
											if((SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].InspectionResult!= SPB_TABLET_RESULT_GOOD || SPBResultHeap[Back2DCamera_SPBIndex].ResultList[heapIndex].InspectionResult != SPB_TABLET_RESULT_GOOD))
											{
												printErrorSW = TABLET_RESULT_DEFECT;
											}
										}
*/
										if((SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].InspectionResult!= SPB_TABLET_RESULT_GOOD || SPBResultHeap[Back2DCamera_SPBIndex].ResultList[heapIndex].InspectionResult != SPB_TABLET_RESULT_GOOD))
										{
											printErrorSW = TABLET_RESULT_DEFECT;
										}
										
										if(printErrorSW == TABLET_RESULT_DEFECT_UNPRINT)
										{
//											ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, 0x0954,rearPrintVal, frontPrintVal, SPBResultHeap[Front2DCamera_SPBIndex].ResultList[heapIndex].InspectionResult);
										}
									}
							}
								else
								{
									if (DefectCheck2)
									{
										printErrorSW = TABLET_RESULT_DEFECT_UNPRINT;
									}
								}
							}
							else if (InspectionOption.UnPrintInspectionType & 0x000010) // ʿ 	μ/	ϴ 	
							{
								// μ Laser complexer  ƴ
								if ((frontPrintVal &	rearPrintVal) != 0x01)
								{
									// 	 Ѱ	 	μⰡ 	ʴ´ٸ
									printErrorSW = TABLET_RESULT_DEFECT_UNPRINT;
								}
							}
							else if (InspectionOption.UnPrintInspectionType & 0x000001) // ʿ δٸ μ/ ϴ  
							{
								if (LasercomplexerInfo.Laser_complexer_Enable)
								{
									// μ Laser complexer  ƴ
									if ((frontPrintVal &	rearPrintVal) != 0x01)
									{
										// 	 Ѱ	 	μⰡ 	ʴ´ٸ
										printErrorSW = TABLET_RESULT_DEFECT_UNPRINT;
									}
									else if (PrintType1 == PrintType2)
									{
										// ʿ  μ/ ġϴ 
										printErrorSW = TABLET_RESULT_DEFECT;
									}
								}
								else
								{
									// μ Laser complexer  ƴ
									if ((frontPrintVal &	rearPrintVal) != 0x01)
									{
										// 	 Ѱ	 	μⰡ ?ʴ´ٸ
										printErrorSW = TABLET_RESULT_DEFECT_UNPRINT;
									}
									else if (PrintType1 == PrintType2)
									{
										// ʿ  μ/ ġϴ 
										printErrorSW = TABLET_RESULT_DEFECT_UNPRINT;
									}
								}
							}
						}

						if (printErrorSW == TABLET_RESULT_DEFECT_UNPRINT && LasercomplexerInfo.Laser_complexer_Enable)
						{
							//  񿡼 μ ҷ 񿡼 óؾϳ  ð ʰ 쿡 ҷ񿡼 óϵ 
							// ش  ο   .  ص   Ͱ.. ϴ 
							if ((((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY) - disk2TabletUnit->GoodEjectorTime) >= 0)
							{
								printErrorSW = TABLET_RESULT_DEFECT;
							}
						}
						// end check print result

						if (LasercomplexerInfo.Laser_complexer_Enable)
						{
							// ipb   μҷ ֿ켱 
							if (printErrorSW)
							{
								disk2TabletUnit->InspectionResult = printErrorSW;
							}
							else
							{
								// μҷ ƴ 
								if (defectResultCount > 0)	// defect
								{
									disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT;
								}
								else
								{
									// print, thick  
									disk2TabletUnit->InspectionResult = TABLET_RESULT_GOOD;
									if (thicknessErrorSW)
									{
										disk2TabletUnit->InspectionResult = thicknessErrorSW;
									}
								}
							}

							disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
							TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
						}
						else
						{
							//  ƴѰ    
							// thick, print errorʹ  ipb  ݿ ҷ̸ unit ҷ 
							if (defectResultCount > 0)	// defect
							{
								disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT;
							}
							else
							{
								// print, thick  
								disk2TabletUnit->InspectionResult = TABLET_RESULT_GOOD;
								if (thicknessErrorSW || printErrorSW)
								{
									// μ ҷ 켱 
									if (printErrorSW)
									{
										disk2TabletUnit->InspectionResult = printErrorSW;
									}
									else
									{
										disk2TabletUnit->InspectionResult = thicknessErrorSW;
									}
								}
							}

							disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
							TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
						}
					}
				}
				else
				{
					if ( ((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY - disk2TabletUnit->UnInsEjectorTime )	< 0)
					{
						disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
//						ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, 0x0954,__LINE__, disk2TabletUnit->InspectionResult , disk2TabletUnit->TabletNumber);
					}
					else
					{
						TabletInspectInfo.SPBProcessingNCTabletCount++;		
						disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT;
						disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
					}					
					TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
				}
			}
			else	// inspection timeout
			{
				disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				disk2TabletUnit->Ejection = TABLET_EJECTION_DEFECT;
				disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT_SPB_PROCESSING_NOT_COMPLETE;

				NCCheckQueueStart = (NCCheckQueueStart + 1)	& NC_CHECK_QUEUE_MASK;
				TabletInspectInfo.SPBProcessingNCTabletCount++;						//INSPECTION_TIMEOUT_PADING_DELAY. ̰˻
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
				InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;

				if (InspectionOption.EjectMode == 0 || InspectionOption.EjectMode == 1)
				{
					DefaultDefectEjectorConfig(pollingTableIndex);
				}

				TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
			}
		}
	}
	else if (disk2TabletUnit->State	== TABLET_STATE_ERROR)
	{
		if ( ((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY - disk2TabletUnit->UnInsEjectorTime )	< 0)
		{
			TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
		else
		{
			TabletInspectInfo.ClosedTabletDefectCount++;
			disk2TabletUnit->InspectionResult = TABLET_RESULT_DEFECT;
			disk2TabletUnit->State = TABLET_STATE_BLOW_WAITING;
			TabletInfo.PollingResultTabletIndex	= (TabletInfo.PollingResultTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
		}			
	}

}
//---------------------------------------------------------------------------

//==========================================================
// Լ : BlowCheckingProcess
//  :  Ʈ, й Ʈ
//   :
//  InspectionOption.EjectMode = 0 : 븻 (ҷ Ҿ )
//  InspectionOption.EjectMode = 1 :  (ǰ Ҿ )
//  MISFEEDING : ũ run° ƴѻ¿ ̼ Ǵ (ex. )
// ſ  ڵ. ̷ ڵϸ  ȵȴ. ߺ ̷ ڵ . 
// ߸ ϸ  Ŀ شڵ  Ұ.
//===========================================================

void BlowCheckingProcess(void)
{
	int	pollingTableIndex;
	THCBDisk2TabletUnit	*prevDisk2TabletUnit, *disk2TabletUnit, *nextDisk2TabletUnit;
	unsigned int unInsEjectStartTime, defectEjectStartTime;
	unsigned int unInsEjectDelay, defectEjectDelay;
	unsigned int goodEjectStartTime, goodEjectDelay;
	int	spbUninsResult;

	pollingTableIndex = TabletInfo.PollingBlowTabletIndex;
	disk2TabletUnit	= &(TabletInfo.Disk2TabletList[pollingTableIndex]);
	prevDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(pollingTableIndex - 1) & HCB_TABLET_LIST_MASK]);
	nextDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(pollingTableIndex + 1) & HCB_TABLET_LIST_MASK]);

	if (disk2TabletUnit->State != TABLET_STATE_READY && ((int)board50usTmr	- (disk2TabletUnit->Sensor2Time	+ TabletControlData.BlowerCheckingDelay) ) > 0)
	{
		//  ó ƾ
		if (disk2TabletUnit->State == TABLET_STATE_ERROR)
		{
			if (disk2TabletUnit->InspectionResult == TABLET_RESULT_SENSOR_2_MISFEEDING)
			{
				TabletInspectInfo.Sensor2MisFeedingTabletCount++;
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);

			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_SENSOR_1_MISFEEDING)
			{
				TabletInspectInfo.Sensor1MisFeedingTabletCount++;
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
				
			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_DISAPPEARED)
			{
				TabletInspectInfo.UnInsTabletCount--;
				TabletInspectInfo.TotalTabletCount--;				
				TabletInspectInfo.DisappearedTabletCount++;
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_INSERTED)
			{
				TabletInspectInfo.InsertedTabletCount++;
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);

			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_CLOSED_UNINS)
			{

			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_CLOSED_DEFECT)
			{

			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_MULTI_TABLET_SENSOR_1)
			{
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
				TabletInspectInfo.Sensor1MultiTabletCount++;
			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_MULTI_TABLET_SENSOR_2)
			{
				TabletInspectInfo.Sensor2MultiTabletCount++;
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
			}
			else
			{
				DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
				TabletInspectInfo.Sensor2MultiTabletCount++;
			}
			//Test 2019.03.20, TABLET_STATE_ERROR
			InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
			InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
			InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;
		} //  ó ƾ 
		else if ((disk2TabletUnit->State == TABLET_STATE_NC_WAITING) || (disk2TabletUnit->State	== TABLET_STATE_COMPLETE))
		{
			TabletInfo.PollingBlowTabletIndex = (TabletInfo.PollingBlowTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
		}
		else if (disk2TabletUnit->State	== TABLET_STATE_BLOW_WAITING)
		{
			if (disk2TabletUnit->InspectionResult == TABLET_RESULT_DEFECT)
			{
				DefaultDefectEjectorConfig(TabletInfo.PollingBlowTabletIndex);
				disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
				InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;
			}
			else if (disk2TabletUnit->InspectionResult	== TABLET_RESULT_DEFECT_UNPRINT)
			{
				if (LasercomplexerInfo.Laser_complexer_Enable)
				{
					AddGoodEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.GoodEjectorLength), disk2TabletUnit->TabletNumber);
					disk2TabletUnit->Ejection = TABLET_EJECTION_GOOD;
					TabletInspectInfo.UnPrintTabletCount++;
				}
				else
				{
					DefaultDefectEjectorConfig(TabletInfo.PollingBlowTabletIndex);
					TabletInspectInfo.UnPrintTabletCount++;
				}
				disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
				InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;
			}
			else if (disk2TabletUnit->InspectionResult	== TABLET_RESULT_DEFECT_FR_MISMATCH)
			{
				DefaultDefectEjectorConfig(TabletInfo.PollingBlowTabletIndex);
				TabletInspectInfo.FRMismatchTabletCount++;
				disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
				InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;
			}
			else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_GOOD)
			{
				if (prevDisk2TabletUnit->Ejection ==TABLET_EJECTION_DEFECT)
				{
					if (disk2TabletUnit->Sensor2Time - prevDisk2TabletUnit->Sensor2Time < prevDisk2TabletUnit->Sensor2Length+EjectorSetupData.DefectEjectorLength*25)
					{
						TabletInspectInfo.ClosedTabletDefectCount++;		
						disk2TabletUnit ->InspectionResult = TABLET_RESULT_CLOSED_DEFECT;
						DefaultDefectEjectorConfig(TabletInfo.PollingBlowTabletIndex);
					}
					else
					{
						DefaultDistributorConfig(TabletInfo.PollingBlowTabletIndex, MachineSetupData.CompanyID);
					}
				}
				else if(prevDisk2TabletUnit->Ejection ==TABLET_EJECTION_UNINSPECT)
				{
					if (disk2TabletUnit->Sensor2Time - prevDisk2TabletUnit->Sensor2Time < prevDisk2TabletUnit->Sensor2Length+EjectorSetupData.UnInsEjectorLength*25)
					{
						TabletInspectInfo.ClosedTabletUninsCount++;		
						disk2TabletUnit->InspectionResult = TABLET_RESULT_CLOSED_UNINS;
						DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
					}
					else
					{
						DefaultDistributorConfig(TabletInfo.PollingBlowTabletIndex, MachineSetupData.CompanyID);
					}					
				}
				else
				{
					DefaultDistributorConfig(TabletInfo.PollingBlowTabletIndex, MachineSetupData.CompanyID);
				}
				disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
				InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;
			}
			else
			{
				if (disk2TabletUnit->InspectionResult == TABLET_RESULT_UNINS_SPB_TIMEOUT)
				{
					DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
					TabletInspectInfo.SPBTOTabletCount++;				// Ÿ	ƿ.

				}
				else if (disk2TabletUnit->InspectionResult == TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE)
				{
					DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
					TabletInspectInfo.SPBProcessingNCTabletCount++;	   //////̰˻
				}
				else
				{
					DefaultUnInsEjectorConfig(TabletInfo.PollingBlowTabletIndex);
					
					if (disk2TabletUnit->InspectionResult &	TABLET_RESULT_SPB_MASK)
					{
						spbUninsResult = (disk2TabletUnit->InspectionResult	& ~TABLET_RESULT_SPB_MASK);
						if (spbUninsResult == SPB_TABLET_RESULT_UNINS_CLOSED_TABLET)
						{
							TabletInspectInfo.ClosedTabletCount++;		//.
						}
						else
						{
							if (spbUninsResult == SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER)
							{
								TabletInspectInfo.WrongNumberTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED)
							{
								TabletInspectInfo.NumberUndefTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY)
							{
								TabletInspectInfo.CaptureNotReadyTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL)
							{
								TabletInspectInfo.BufferFullTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT)
							{
								TabletInspectInfo.CaptureTimoutTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT)
							{
								TabletInspectInfo.ProcessingTimoutTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_CPB_FULL)
							{
								TabletInspectInfo.CPBFullTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR)
							{
								TabletInspectInfo.ProcessingErrorTabletCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_TABLET_POSITION)
							{
								TabletInspectInfo.UnInsTabletPositionCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED)
							{
								TabletInspectInfo.UnInsBrightnessDropCount++;
							}
							else if (spbUninsResult	== SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE)
							{
								TabletInspectInfo.UnInsBrightnessChaseCount++;
								StatusCheckingInfo.IgnoredUninsCount++;
								StatusCheckingInfo.IgnoredCritUninsCount++;
							}
							TabletInspectInfo.SPBUnInsTabletCount++;
						}
					}
				}
				disk2TabletUnit->State = TABLET_STATE_COMPLETE;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].Result = disk2TabletUnit->InspectionResult;
				InspectionResultTable.Table[InspectionResultTable.CurrentIndex].TabletNumber = disk2TabletUnit->TabletNumber;
				InspectionResultTable.CurrentIndex = (InspectionResultTable.CurrentIndex + 1) & RESULT_TABLE_MASK;
			}	// TABLET_STATE_BLOW_WAITING ¿ ̰˱....
		}
	}
}

//---------------------------------------------------------------------------
void CounterSensorCheckProcess(void)
{
	char tabletDetected, misfeedingTabletDetected, expectedTabletCount, normalTabletDetected;
	unsigned int detectedSensorOnTime, detectedSensorLength;
	int	tabletListIndex, tabletIndex;
	unsigned int tabletSensorOnTime, tabletSensorLength;

	int MistabletListIndex;
	int LengthErrorDetected;

	tabletDetected = 0;
	normalTabletDetected = 0;
	misfeedingTabletDetected = 0;
	LengthErrorDetected = 0;

	if (TabletSensorQueue[2].Start != TabletSensorQueue[2].End)
	{
		if (TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorLength <= TabletControlData.MinSensorLength)
		{
			tabletDetected = 1;
			expectedTabletCount	= 1;
			detectedSensorOnTime = TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorOnTime;
			detectedSensorLength = TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorLength;
			TabletSensorQueue[2].Start = (TabletSensorQueue[2].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}		
		else if (TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorLength	>  (1.6 *	TabletControlData.ExpectedSensor2Length) )	// too large tablet
		{
			tabletDetected = 1;
			LengthErrorDetected = 1;
			expectedTabletCount	= TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorLength / TabletControlData.ExpectedSensor3Length;
			detectedSensorOnTime = TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorOnTime;
			detectedSensorLength = TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorLength;
			TabletSensorQueue[2].Start = (TabletSensorQueue[2].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}		
		else
		{
			tabletDetected = 1;
			expectedTabletCount	= 1;
			normalTabletDetected = 1;
			detectedSensorOnTime = TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorOnTime;
			detectedSensorLength = TabletSensorQueue[2].List[TabletSensorQueue[2].Start].SensorLength;
			TabletSensorQueue[2].Start = (TabletSensorQueue[2].Start + 1) & TABLET_SENSOR_LIST_MASK;
		}
	}
	if (tabletDetected)
	{
		tabletSensorOnTime = detectedSensorOnTime;
		tabletSensorLength = detectedSensorLength / expectedTabletCount;
		for (tabletIndex = 0; tabletIndex < expectedTabletCount; tabletIndex++)
		{
			if (TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION || TabletControlData.Func == TABLET_CONTROL_FUNC_TABLET_COUNTER)
			{
				if (SumIdx2 <= 200 && FirstSumChk2 == 1 && normalTabletDetected == 1)
				{
					SumExpectedSensor3Length = SumExpectedSensor3Length + tabletSensorLength;
					if (SumIdx2 == 2 || SumIdx2 == 10 || SumIdx2 == 100 || SumIdx2 == 200)
					{
						TabletControlData.ExpectedSensor3Length = SumExpectedSensor3Length / SumIdx2;
					}
					if (SumIdx2 >= 200)
					{
						SumIdx2	= 0;
						FirstSumChk2 = 0;
						SumExpectedSensor3Length = 0;
					}
					else
					{
						SumIdx2++;
					}
				}

				tabletListIndex	= TabletInfo.CounterCheckListIndex;
				MistabletListIndex = tabletListIndex; //InspectionResultTable.Table[tabletListIndex].TabletNumber - 1;

				//Add
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor3Time	= tabletSensorOnTime;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor3Length	= tabletSensorLength;

				if ((InspectionOption.EjectMode != 1) )
				{
					if (TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION )
					{
						if(TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult != TABLET_RESULT_GOOD )
						{
							if(EjectorSetupData.MisejectActive == 1)
							{
								MisEjectActive();
								//MisEjectInsActive();
								MisEjectActFlag	= 1;
								MisEjectActTmr = 0;
								ConFlag	= 1;
								MisEjectActSubFlag = 0;
								MisEjectCnt++;
								TabletInspectInfo.MisejectActiveCount++;
//								ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,MisEjectActTime,TabletInspectInfo.MisejectActiveCount,TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber);
								if(Oldboard50usTmr)
								{
									if(board50usTmr - Oldboard50usTmr < 10000)
									{
										MisEjecCheckCount++;
										if(MisEjecCheckCount >= 5)
										{
											InspectionAlarmState.AlarmExist	= 1;
											InspectionAlarmState.MisEjecMultiAction	= 1;
										}
									}
									else
									{
										MisEjecCheckCount = 0;
									}
								}	
								Oldboard50usTmr = board50usTmr;
									
/*
								if (MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
								{
									if(MachineSetupData.EjectorInfo.IgnoreMultiMisejectAction == 0)
									{
										if (MisEjectFirstAct == 0)
										{
											MisEjectFirstAct	= 1;
											Oldboard50usTmr	= board50usTmr;
										}
										else if (MisEjectFirstAct == 1)
										{
											if ((board50usTmr - Oldboard50usTmr) < MisEjectorMultiTmr )
											{
												InspectionAlarmState.AlarmExist	= 1;
												InspectionAlarmState.MisEjecMultiAction	= 1;
											}
											else
											{
												Oldboard50usTmr	= board50usTmr;
											}
										}
									}
								}
*/								
							}
							else
							{
								if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
								{
									if (!MisEjectActFlag)
									{
										// Active ʿ  Ѿ ϴ    
										// ѱ° ƺ 
										//if(MisEjectActSubFlag != 2) 
											MisEjectActive();

										MisEjectActSubFlag = 2;
										MisEjectActSubTmr = 0;
									}	
								}
							}
							TabletInspectInfo.CounterSensorTabletCount++;
						}
						else
						{
							TabletInspectInfo.CounterSensorTabletCount++;		// .
							TabletInspectInfo.GoodTabletLostCount++; // ̽  Ȯϴ ǰ 
							if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
							{
								if (!MisEjectActFlag)
								{
									if(MisEjectActSubFlag != 2)
									{
										MisEjectStop();
										MisEjectActSubFlag = 1;
										MisEjectActSubTmr = 0;
									} 
								}
							}
						}

					} //̰˼  .
					else if (TabletControlData.Func == TABLET_CONTROL_FUNC_TABLET_COUNTER)
					{
						TabletInspectInfo.CounterSensorTabletCount++;
					}
				}

				TabletInfo.Disk2TabletList[tabletListIndex].Sensor3Time	= tabletSensorOnTime;
				TabletInfo.Disk2TabletList[tabletListIndex].Sensor3Length	= tabletSensorLength;
				TabletInfo.Disk2TabletList[tabletListIndex].EjectionCheck	= TABLET_EJECTION_CHECK_EXIST;
			}
			else		// study or	check_interval or capture
			{
				tabletListIndex	= TabletInfo.CurrentSensor3ListIndex;
				TabletInfo.CounterTabletList[tabletListIndex].Sensor3Time = tabletSensorOnTime;
				TabletInfo.CounterTabletList[tabletListIndex].Sensor3Length	= tabletSensorLength;
				TabletInfo.Disk2TabletList[tabletListIndex].EjectionCheck = TABLET_EJECTION_CHECK_EXIST;
				AdvanceCounterTabletList();
				TabletInspectInfo.CounterSensorTabletCount++;
			}
			tabletSensorOnTime += tabletSensorLength;
		} //For
	}

	// ...
	tabletListIndex	= TabletInfo.CounterCheckListIndex;
	if (TabletInfo.Disk2TabletList[tabletListIndex].State != TABLET_STATE_READY)
	{
		if (TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION || TabletControlData.Func == TABLET_CONTROL_FUNC_TABLET_COUNTER)
		{
			if ((board50usTmr - TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	> TabletControlData.SensorMaxIntervalB)	&&
			        TabletControlData.SensorState3 == SENSOR_STATE_OFF && TabletSensorQueue[2].Start == TabletSensorQueue[2].End)	// too late? (deletion of a	tablet)
			{				
				TabletInfo.Disk2TabletList[tabletListIndex].EjectionCheck = TABLET_EJECTION_CHECK_EMPTY;
				TabletInfo.CounterCheckListIndex = (TabletInfo.CounterCheckListIndex + 1) & HCB_TABLET_LIST_MASK;				
			}
		}
	}
}
//-------------------------------------------------------------------------
void TabletControl_Process(void)		// per 50us
{
	int i;
	if(ServoMotorInfo[0].Status > 1 || ServoMotorInfo[1].Status > 1)
	{
		ReadEncoderProcess();
	}
	if (TabletControlData.Func != TABLET_CONTROL_FUNC_NONE)
	{
		
		if (MainControlData.EnabledSensorType == 0) // Sensor A
		{
			if (PORT_ReadInPort(IP_DISK_1_CAPTURE_SENSOR))

			{
				TabletControl_Sensor1On();
			}
			else
			{
				TabletControl_Sensor1Off();
			}

			if (PORT_ReadInPort(IP_DISK_2_CAPTURE_SENSOR))
			{
				TabletControl_Sensor2On();
			}
			else
			{
				TabletControl_Sensor2Off();
			}

			if (PORT_ReadInPort(IP_COUNTER_SENSOR_ON))
			{
				TabletControl_Sensor3On();
			}
			else
			{
				TabletControl_Sensor3Off();
			}
		}
		else // Sensor B
		{

			if (PORT_ReadInPort(IP_DISK_1_CAPTURE_SENSOR_B))
			{
				TabletControl_Sensor1On();
			}
			else
			{
				TabletControl_Sensor1Off();
			}
			if (PORT_ReadInPort(IP_DISK_2_CAPTURE_SENSOR_B))
			{
				TabletControl_Sensor2On();
			}
			else
			{
				TabletControl_Sensor2Off();
			}

			if (PORT_ReadInPort(IP_COUNTER_SENSOR_B_ON))
			{
				TabletControl_Sensor3On();
			}
			else
			{
				TabletControl_Sensor3Off();
			}
		}
		// disk1 sensor	check process

		if (SimulationInspectionSW)
		{
			if (Board1MSTmr - beforeIntTime1 > SimulationInspectionPeriod)
			{
				TabletSensorQueue[0].End = (TabletSensorQueue[0].End + 1) & TABLET_SENSOR_LIST_MASK;
				SuctionDisk1SimulationProcess();

				beforeIntTime1 = Board1MSTmr;
			}
			SuctionDisk1CaptureProcess();		// 1-2 pipe	of tablet control

			if (Board1MSTmr - beforeIntTime2 > SimulationInspectionPeriod)
			{
				TabletSensorQueue[1].End = (TabletSensorQueue[1].End + 1) & TABLET_SENSOR_LIST_MASK;
				SuctionDisk2SimulationProcess();

				beforeIntTime2 = Board1MSTmr;
			}
			SuctionDisk2CaptureProcess();		// 2-2 pipe	of tablet control
		}
		else
		{
			SuctionDisk1SensorCheckProcess();	// 1-1 pipe	of tablet control
			SuctionDisk1CaptureProcess();		// 1-2 pipe	of tablet control

			SuctionDisk2SensorCheckProcess();	// 2-1 pipe	of tablet control
			SuctionDisk2CaptureProcess();		// 2-2 pipe	of tablet control
		}

		// counter sensor check	process
		CounterSensorCheckProcess();		// 2-6 pipe	of tablet control
	}

	if (TabletControlData.Func & TABLET_CONTROL_FUNC_CAPTURE_REQUIRED)
	{
		if (TabletCaptureInformation.Sensor1TabletNumberValid)
		{
			if (board50usTmr - TabletCaptureInformation.Sensor1ActivateTime	>= TABLET_NUMBER_VALID_INTERVAL)
			{
				TabletCaptureInformation.Sensor1TabletNumberValid = 0;
			}
		}

		if (TabletCaptureInformation.Sensor2TabletNumberValid)
		{
			if (board50usTmr - TabletCaptureInformation.Sensor2ActivateTime	>= TABLET_NUMBER_VALID_INTERVAL)
			{
				TabletCaptureInformation.Sensor2TabletNumberValid = 0;
			}
		}
		SuctionDisk1IlluminatorProcess();		// 1-3 pipe	of tablet control
		SuctionDisk2IlluminatorProcess();		// 2-3 pipe	of tablet control
	}

	if (TabletControlData.Func & TABLET_CONTROL_FUNC_EJECTION_REQUIRED)
	{
		if(TabletControlData.Func != TABLET_CONTROL_FUNC_EJECTOR_TEST)
		BlowCheckingProcess();						// 2-5 pipe	of tablet control
		// counter sensor check	process
	}
}

//---------------------------------------------------------------------------
void TabletControl_1ms_Process(void)
{
	int	intervalTabletCount;
	int	spbIndex, spbTableIndex, heapIndex;
	int positionIndex;


	
	if (TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION)
	{
		// accumulate inspection result
		for (spbIndex = 0; spbIndex	< MachineSetupData.IPB_BoardCount;	spbIndex++)
		{
			if (SPBProcessingResultData[spbIndex].CompleteCount	> SPB_PROCESSING_RESULT_COUNT)
				continue;
			for (spbTableIndex = 0;	spbTableIndex < SPBProcessingResultData[spbIndex].CompleteCount; spbTableIndex++)
			{
				heapIndex = (SPBProcessingResultData[spbIndex].ProcessedTabletNumber[spbTableIndex]	& SPB_RESULT_HEAP_MASK);

				// TabletNumber	 	 ö  ó̶  ȣ οذ ٸ   ʱȭ ش.
				if (SPBResultHeap[spbIndex].ResultList[heapIndex].TabletNumber != SPBProcessingResultData[spbIndex].ProcessedTabletNumber[spbTableIndex])
				{
					// INITIAL
					SPBResultHeap[spbIndex].ResultList[heapIndex].TabletNumber = SPBProcessingResultData[spbIndex].ProcessedTabletNumber[spbTableIndex];
					SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult = SPB_TABLET_RESULT_NONE;

					for (positionIndex = 0; positionIndex < SUCTION_DISK_INDEX; positionIndex++)
					{
						SPBResultHeap[spbIndex].ResultList[heapIndex].PositionCompleted[positionIndex]	= 0;
					}

					SPBResultHeap[spbIndex].ResultList[heapIndex].PrintResult = 0;
					SPBResultHeap[spbIndex].ResultList[heapIndex].PrintType	= 0;
					SPBResultHeap[spbIndex].ResultList[heapIndex].ThickErrorSW1 = 0;
					SPBResultHeap[spbIndex].ResultList[heapIndex].ThickErrorSW2 = 0;
				}

				// ̹	 	ش SPBκ ö     
				if (SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult == SPB_TABLET_RESULT_NONE)
				{
					SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult = (SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PROCESSING_MASK);
				}
				else if ((SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult != SPB_TABLET_RESULT_NONE)	&&
				         (SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult < SPB_TABLET_RESULT_DEFECT))

				{
					SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult = (SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PROCESSING_MASK);
				}
				//  ϵ  ̰ ¿  ҷ ö 쿡 ҷó
				else if ((SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult != SPB_TABLET_RESULT_NONE)	&&
				         (SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult > SPB_TABLET_RESULT_DEFECT))

				{
					if ((SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PROCESSING_MASK) == SPB_TABLET_RESULT_DEFECT)
						SPBResultHeap[spbIndex].ResultList[heapIndex].InspectionResult = (SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PROCESSING_MASK);
				}

				if ((SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PROCESSING_MASK) > SPB_TABLET_RESULT_PROCESSING)
				{
					if (SPBProcessingResultData[spbIndex].DiskPosition[spbTableIndex])
						SPBResultHeap[spbIndex].ResultList[heapIndex].PositionCompleted[SPBProcessingResultData[spbIndex].DiskPosition[spbTableIndex] - 1] = 1;

					SPBResultHeap[spbIndex].ResultList[heapIndex].PrintResult = ((SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PRINT_IS_MASK) >> SPB_TABLET_RESULT_PRINT_IS_SHIFT);
					SPBResultHeap[spbIndex].ResultList[heapIndex].PrintType	= ((SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_PRINT_TYPE_MASK) >> SPB_TABLET_RESULT_PRINT_TYPE_SHIFT);
					SPBResultHeap[spbIndex].ResultList[heapIndex].ThickErrorSW1 = ((SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_THICKERROR_MASK) >> SPB_TABLET_RESULT_PRINT_THICKERROR_SHIFT);
					SPBResultHeap[spbIndex].ResultList[heapIndex].ThickErrorSW2 = ((SPBProcessingResultData[spbIndex].ProcessingResult[spbTableIndex] & SPB_TABLET_RESULT_FRONT_FACE_MASK) >> SPB_TABLET_RESULT_FRONT_FACE_SHIFT);
				}
			}
		}
		InspectionResultCheckingProcess();		// 2-4 pipe	of tablet control

		if ((MainControlData.State == MAIN_CONTROL_STATE_RUN) && (LaserTestMode==0))
		{
			if (InspectionOption.MachineStopActivated)
			{
				if (StatusCheckingInfo.InspectionCheckingCounter == 0)
				{
					intervalTabletCount	= TabletInspectInfo.Disk2TabletCount - StatusCheckingInfo.BeforeDisk2TabletCount;
					if (intervalTabletCount)
					{
						if (intervalTabletCount	>= TabletControlData.MachineStopMinimalTabletCount)
						{
							if ((TabletInspectInfo.DefectTabletCount - StatusCheckingInfo.BeforeDefectTabletCount) * 100 / intervalTabletCount >= InspectionOption.MachineStopDefectRatio)
							{
								InspectionAlarmState.DPRatioOver = 1;
								InspectionAlarmState.AlarmExist	= 1;
							}
							else if ((TabletInspectInfo.UnInsTabletCount - StatusCheckingInfo.BeforeUnInsTabletCount - StatusCheckingInfo.IgnoredUninsCount) * 100 / intervalTabletCount >= InspectionOption.MachineStopUnInsRatio)
							{
								InspectionAlarmState.UPRatioOver = 1;
								InspectionAlarmState.AlarmExist	= 1;
							}
						}
					}
					StatusCheckingInfo.BeforeDefectTabletCount = TabletInspectInfo.DefectTabletCount;
					StatusCheckingInfo.BeforeUnInsTabletCount = TabletInspectInfo.UnInsTabletCount;
					StatusCheckingInfo.IgnoredUninsCount = 0;
					StatusCheckingInfo.BeforeDisk2TabletCount = TabletInspectInfo.Disk2TabletCount;
					StatusCheckingInfo.InspectionCheckingCounter = INSPECTION_CHECKING_TIME;
				}
				else
				{
					StatusCheckingInfo.InspectionCheckingCounter--;
				}
			}


			if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				if(!MachineSetupData.InterlockInfo.ACdomesticMode)	// 
				{
					if (StatusCheckingInfo.CritDefectCheckingCounter	== 0)
					{
						intervalTabletCount	= TabletInspectInfo.TotalTabletCount - StatusCheckingInfo.BeforeCritTabletCountD;
						if (intervalTabletCount)
						{
							if (intervalTabletCount	> CRIT_DEFECT_CHECKING_MIN_TABLET_COUNT * ServoMotorBaseSpeed[SD1_MOTOR_INDEX] / OperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX])
							{
								if ((TabletInspectInfo.DefectTabletCount	- StatusCheckingInfo.BeforeCritDefectTabletCount) * 100 / intervalTabletCount > CRIT_DEFECT_MACHINE_STOP_RATIO)
								{
									InspectionAlarmState.CritDPRatioOver = 1;
									InspectionAlarmState.AlarmExist	= 1;
								}
							}
						}
					StatusCheckingInfo.BeforeCritDefectTabletCount = TabletInspectInfo.DefectTabletCount;
					StatusCheckingInfo.BeforeCritTabletCountD = TabletInspectInfo.TotalTabletCount;
					StatusCheckingInfo.CritDefectCheckingCounter = CRIT_DEFECT_CHECKING_TIME;
					}
					else
					{
						StatusCheckingInfo.CritDefectCheckingCounter--;
					}
				}
			}


			if (StatusCheckingInfo.CritUnInsCheckingCounter	== 0)
			{
				intervalTabletCount	= TabletInspectInfo.TotalTabletCount - StatusCheckingInfo.BeforeCritTabletCount	- StatusCheckingInfo.IgnoredCritUninsCount;
				if (intervalTabletCount)
				{
					if (intervalTabletCount	> CRIT_UNINS_CHECKING_MIN_TABLET_COUNT * ServoMotorBaseSpeed[SD1_MOTOR_INDEX] / OperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX])
					{
						if ((TabletInspectInfo.UnInsTabletCount	- StatusCheckingInfo.BeforeCritUnInsTabletCount) * 100 / intervalTabletCount > CRIT_UNINS_MACHINE_STOP_RATIO)
						{
							InspectionAlarmState.CritUPRatioOver = 1;
							InspectionAlarmState.AlarmExist	= 1;
						}
					}
				}
				StatusCheckingInfo.BeforeCritUnInsTabletCount = TabletInspectInfo.UnInsTabletCount;
				StatusCheckingInfo.BeforeCritTabletCount = TabletInspectInfo.TotalTabletCount;
				StatusCheckingInfo.IgnoredCritUninsCount = 0;
				StatusCheckingInfo.CritUnInsCheckingCounter	= CRIT_UNINS_CHECKING_TIME;
			}
			else
			{
				StatusCheckingInfo.CritUnInsCheckingCounter--;
			}

			if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				if(MachineSetupData.EjectorInfo.IgnoreMultiMisejectAction == 0)
				{
					if ( InspectionOption.QMachineMisejectActiveLimitCount >= 0 && InspectionOption.QMachineMisejectActiveLimitCount	<= TabletInspectInfo.MisejectActiveCount)
					{
						InspectionAlarmState.MisEjecMultiAction	= 1;
						InspectionAlarmState.AlarmExist	= 1;
					}
				}
			}

			if (InspectionOption.MachineStopTotalCount	>= 0 && InspectionOption.MachineStopTotalCount	<= TabletInspectInfo.GoodTabletCount + TabletInspectInfo.DefectTabletCount + TabletInspectInfo.UnInsTabletCount)
			{
				InspectionAlarmState.TotalFull	= 1;
				InspectionAlarmState.AlarmExist	= 1;
			}

			if (InspectionOption.DesiredGPCount	>= 0 && InspectionOption.DesiredGPCount	<= TabletInspectInfo.GoodTabletCount)
			{
				InspectionAlarmState.GPFull	= 1;
				InspectionAlarmState.AlarmExist	= 1;
			}

			if (InspectionOption.MachineStopDPCount	>= 0 && InspectionOption.MachineStopDPCount	<= TabletInspectInfo.DefectTabletCount)
			{
				InspectionAlarmState.DPFull	= 1;
				InspectionAlarmState.AlarmExist	= 1;
			}
			if (InspectionOption.MachineStopUPCount	>= 0 && InspectionOption.MachineStopUPCount	<= TabletInspectInfo.UnInsTabletCount)
			{
				InspectionAlarmState.UPFull	= 1;
				InspectionAlarmState.AlarmExist	= 1;
			}

			if (StatusCheckingInfo.BrightnessDropOccured)
			{
				InspectionAlarmState.BrightnessDown	= 1;
				InspectionAlarmState.AlarmExist	= 1;
				StatusCheckingInfo.BrightnessDropOccured = 0;
			}

#ifdef SELMA

			if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				if(InspectionOption.DHSpecialInsCheckbox)
				{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 100000;
						INSPECTION_MACHINE_STOP_DELAY = 100000;

					if (InspectionOption.DHCountCheck[0] == 0)
					{
						if ((InspectionOption.DHSpecialInsCount[0] > 0)	&& ((InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
						{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								///	 	  ð ص output ȣ		 Ŀ check	īƮ 1 	ȯ ///
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;						
						}
						
						if (DHoutputSignalTimeFlag)
						{
							PORT_ModifyOutPort(OP_DH_CONTROL, 1);
							DHoutputSignalTimeFlag = 0;
							DHOPOntimeFlag = 1;
							if (InspectionOption.DHSpecialInsCount[1] > 0)
							{
								InspectionOption.DHSpecialInsCount[1] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1];
							}
						}		
						
						if (DHOPOntime > 10000)  // 10, ⼭ ִ	ð 	ٷ   Ѿ  	δ.	// ipȣ	ٽ ö ٸ.
						{
							DHOPOntimeFlag = 0;
							DHOPOntime = 0;
							DHmachineOnTimeFlag	= 1;
							PORT_ModifyOutPort(OP_DH_CONTROL, 0);
							InspectionOption.DHCountCheck[0] = 1;
						}						
					}
					else if (InspectionOption.DHCountCheck[0] == 1)
					{
							if (InspectionOption.DHSpecialInsCount[1] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							else
							{
								if (DHmachineOnTimeFlag)
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;
								}
									
								if ((InspectionOption.DHSpecialInsCount[1] > 0) && ((InspectionOption.DHSpecialInsCount[1] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
								{
									//MC_MainControl_Stop();
									MC_Vibrator_Off();
									MC_BowlFeeder_Stop();
									if (DHOPOntimeFlag == 0)
										DHoutputDelayTimeFlag = 1;
									else
										DHoutputDelayTimeFlag = 0;
								}
								
								if (DHoutputSignalTimeFlag)
								{
									PORT_ModifyOutPort(OP_DH_CONTROL, 1);
									DHoutputSignalTimeFlag = 0;
									DHOPOntimeFlag = 1;
									if (InspectionOption.DHSpecialInsCount[2] > 0)
									{
										InspectionOption.DHSpecialInsCount[2] = InspectionOption.DHSpecialInsCount[1] + InspectionOption.DHSpecialInsCount[2];
									}
								}
								
								if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
								{
									DHOPOntimeFlag = 0;
									DHOPOntime = 0;
									DHmachineOnTimeFlag	= 1;
									PORT_ModifyOutPort(OP_DH_CONTROL, 0);
									InspectionOption.DHCountCheck[0] = 2;
								}							
							}						
					}			
					//else if ((InspectionOption.DHCountCheck[0] == 2)	&& (PORT_ReadInPort(IP_DH_CONTROL)))
					else if (InspectionOption.DHCountCheck[0] == 2)
					{
							if (InspectionOption.DHSpecialInsCount[2] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							else
							{
								if (DHmachineOnTimeFlag)
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;
								}
								if ((InspectionOption.DHSpecialInsCount[2] > 0) && ((InspectionOption.DHSpecialInsCount[2] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
								{
									MC_Vibrator_Off();
									MC_BowlFeeder_Stop();
									if (DHOPOntimeFlag == 0)
										DHoutputDelayTimeFlag = 1;
									else
										DHoutputDelayTimeFlag = 0;
								}
								if (DHoutputSignalTimeFlag)
								{
									PORT_ModifyOutPort(OP_DH_CONTROL, 1);
									DHoutputSignalTimeFlag = 0;
									DHOPOntimeFlag = 1;
									if (InspectionOption.DHSpecialInsCount[3] > 0)
									{
										InspectionOption.DHSpecialInsCount[3] = InspectionOption.DHSpecialInsCount[2] + InspectionOption.DHSpecialInsCount[3];
									}
									else
									{
										InspectionOption.DHCountCheck[0] = 255;
									}
								}
								if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
								{
									DHOPOntimeFlag = 0;
									DHOPOntime = 0;
									DHmachineOnTimeFlag	= 1;
									PORT_ModifyOutPort(OP_DH_CONTROL, 0);
									InspectionOption.DHCountCheck[0] = 3;
								}		
							}
					
					}
					else if (InspectionOption.DHCountCheck[0] == 3)	
					{
						if (InspectionOption.DHSpecialInsCount[3] == 0)
						{
							InspectionOption.DHCountCheck[0] = 255;
						}
						else
						{
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();

								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[3] > 0) && ((InspectionOption.DHSpecialInsCount[3] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[4] > 0)
								{
									InspectionOption.DHSpecialInsCount[4] = InspectionOption.DHSpecialInsCount[3] + InspectionOption.DHSpecialInsCount[4];
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
							}
							if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 4;
							}
						}

					}
					//5	ܰ.	====================================
					else if (InspectionOption.DHCountCheck[0] == 4)
					{
						if (InspectionOption.DHSpecialInsCount[4] == 0)
						{
							InspectionOption.DHCountCheck[0] = 255;
						}
						else
						{
							if (DHmachineOnTimeFlag)
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;
								}
								if ((InspectionOption.DHSpecialInsCount[4] > 0) && ((InspectionOption.DHSpecialInsCount[4] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
								{
									MC_Vibrator_Off();
									MC_BowlFeeder_Stop();
									if (DHOPOntimeFlag == 0)
										DHoutputDelayTimeFlag = 1;
									else
										DHoutputDelayTimeFlag = 0;
								}
								if (DHoutputSignalTimeFlag)
								{
									// output ȣ 	//
									PORT_ModifyOutPort(OP_DH_CONTROL, 1);
									DHoutputSignalTimeFlag = 0;
									DHOPOntimeFlag = 1;
									if (InspectionOption.DHSpecialInsCount[5] > 0)
									{
										InspectionOption.DHSpecialInsCount[5] = InspectionOption.DHSpecialInsCount[4] + InspectionOption.DHSpecialInsCount[5];
									}
									else
									{
										InspectionOption.DHCountCheck[0] = 255;
									}
								}
								if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð ٷ   Ѿ  	δ.
								{
									DHOPOntimeFlag = 0;
									DHOPOntime = 0;
									DHmachineOnTimeFlag	= 1;
									PORT_ModifyOutPort(OP_DH_CONTROL, 0);
									InspectionOption.DHCountCheck[0] = 5;
								}
						}
	
					}
					//6	ܰ.	====================================
					else if (InspectionOption.DHCountCheck[0] == 5)
					{
						if (InspectionOption.DHSpecialInsCount[5] == 0)
						{
							InspectionOption.DHCountCheck[0] = 255;
						}
						else
						{
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();
								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[5] > 0) && ((InspectionOption.DHSpecialInsCount[5] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								//  κ output ȣ 	x  //
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHOPOntimeFlag = 1;
								DHoutputSignalTimeFlag = 0;
								InspectionOption.DHCountCheck[0] = 255;
							}
						}

					}
					// Է ȵ STOP ܰ.  ====================================
					else if (InspectionOption.DHCountCheck[0] == 255)
					{
						//if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
						//{
							DHOPOntimeFlag = 0;
							DHOPOntime = 0;
							PORT_ModifyOutPort(OP_DH_CONTROL, 0);
							MachineStatus.Suspended	= 1;
							MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
							MC_MainControl_Stop();
						//}
					}

				}
				else
				{
					MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 30000;
					INSPECTION_MACHINE_STOP_DELAY = 60000;
				}
			}					
				
						
				

								
			

			if (MachineSetupData.CompanyID == DOMESTIC_MACHINE1||MachineSetupData.CompanyID == DOMESTIC_MACHINE3||MachineSetupData.InterlockInfo.ACdomesticMode) 	//.
			{
				//////	ȭ 	α׷ //////
				///// й input IP60	output OP62	   //////
				///// output ȣ	й ۵	.  input ȣ	 ۵. //////
				///// TEST ϱ	ؼ PORT_ReadInPort(IP_DH_CONTROL)  ð   1	  /////
				///// output ȣ	۵Ű?ؼ  ̸ ־ Ѵ. ̴	test 	˸ ð ֵ   30sec Ŀ ϵ  /////

				/* ============================================ */
				// =============  ȭ й.   ========== //
				/* ============================================ */
				if (InspectionOption.DHCountCheck[1] == 1)   //ȭ й.
				{
					if (InspectionOption.DHSpecialInsCheckbox)
					{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 100000;
						INSPECTION_MACHINE_STOP_DELAY = 100000;
						//1	ܰ.	====================================
						if ((InspectionOption.DHCountCheck[0] == 0) && (PORT_ReadInPort(IP_DH_CONTROL)))
						{
							if ((InspectionOption.DHSpecialInsCount[0] > 0)	&& ((InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								///	 	  ð ص output ȣ		 Ŀ check	īƮ 1 	ȯ ///
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[1] > 0)
								{
									InspectionOption.DHSpecialInsCount[1] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1];
								}
							}
							if (DHOPOntime > 10000)  // 10, ⼭ ִ	ð 	ٷ   Ѿ  	δ.	// ipȣ	ٽ ö ٸ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 1;
							}
						}
						//2	ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 1)	&& (PORT_ReadInPort(IP_DH_CONTROL)))
						{
							if (InspectionOption.DHSpecialInsCount[1] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();
								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[1] > 0) && ((InspectionOption.DHSpecialInsCount[1] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								//MC_MainControl_Stop();
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[2] > 0)
								{
									InspectionOption.DHSpecialInsCount[2] = InspectionOption.DHSpecialInsCount[1] + InspectionOption.DHSpecialInsCount[2];
								}
							}
							if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 2;
							}
						}
						//3	ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 2)	&& (PORT_ReadInPort(IP_DH_CONTROL)))
						{
							if (InspectionOption.DHSpecialInsCount[2] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();
								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[2] > 0) && ((InspectionOption.DHSpecialInsCount[2] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[3] > 0)
								{
									InspectionOption.DHSpecialInsCount[3] = InspectionOption.DHSpecialInsCount[2] + InspectionOption.DHSpecialInsCount[3];
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
							}
							if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 3;
							}
						}
						//4	ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 3)	&& (PORT_ReadInPort(IP_DH_CONTROL)))
						{
							if (InspectionOption.DHSpecialInsCount[3] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();

								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[3] > 0) && ((InspectionOption.DHSpecialInsCount[3] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[4] > 0)
								{
									InspectionOption.DHSpecialInsCount[4] = InspectionOption.DHSpecialInsCount[3] + InspectionOption.DHSpecialInsCount[4];
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
							}
							if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 4;
							}
						}
						//5	ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 4)	&& (PORT_ReadInPort(IP_DH_CONTROL)))
						{
							if (InspectionOption.DHSpecialInsCount[4] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();
								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[4] > 0) && ((InspectionOption.DHSpecialInsCount[4] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								// output ȣ 	//
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[5] > 0)
								{
									InspectionOption.DHSpecialInsCount[5] = InspectionOption.DHSpecialInsCount[4] + InspectionOption.DHSpecialInsCount[5];
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
							}
							if (DHOPOntime > 10000) // 10  // ⼭ ִ?ð ٷ   Ѿ  	δ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 5;
							}
						}
						//6	ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 5)	&& (PORT_ReadInPort(IP_DH_CONTROL)))
						{
							if (InspectionOption.DHSpecialInsCount[5] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							if (DHmachineOnTimeFlag)
							{
								MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
								MC_Vibrator_Auto();
								DHmachineOnTimeFlag	= 0;
							}
							if ((InspectionOption.DHSpecialInsCount[5] > 0) && ((InspectionOption.DHSpecialInsCount[5] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								//  κ output ȣ 	x  //
								PORT_ModifyOutPort(OP_DH_CONTROL, 1);
								DHOPOntimeFlag = 1;
								DHoutputSignalTimeFlag = 0;
								InspectionOption.DHCountCheck[0] = 255;
							}
						}
						// Է ȵ STOP ܰ.  ====================================
						else if (InspectionOption.DHCountCheck[0] == 255)
						{
							if (DHOPOntime > 10000) // 10  // ⼭ ִ	ð 	ٷ   Ѿ  	δ.
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								PORT_ModifyOutPort(OP_DH_CONTROL, 0);
								MachineStatus.Suspended	= 1;
								MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
								MC_MainControl_Stop();
							}
						}
						else if ((InspectionOption.DHCountCheck[0] >= 0)	&& (InspectionOption.DHCountCheck[0] < 255)	&& (!PORT_ReadInPort(IP_DH_CONTROL)))
						{
							///// й ̵	 ip	ȣ 	////
							/*if(InspectionOption.DHSpecialInsCount[1] == 0)
							{
								InspectionOption.DHCountCheck[0] = -1;
							}
							else if(InspectionOption.DHSpecialInsCount[2] == InspectionOption.DHSpecialInsCount[1])
							{
								InspectionOption.DHCountCheck[0] = -1;
							}
							else if(InspectionOption.DHSpecialInsCount[3] == InspectionOption.DHSpecialInsCount[2])
							{
								InspectionOption.DHCountCheck[0] = -1;
							}
							else if(InspectionOption.DHSpecialInsCount[4] == InspectionOption.DHSpecialInsCount[3])
							{
								InspectionOption.DHCountCheck[0] = -1;
							}
							else if(InspectionOption.DHSpecialInsCount[5] == InspectionOption.DHSpecialInsCount[4])
							{
								InspectionOption.DHCountCheck[0] = -1;
							}*/
						}
					}
					else
					{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 30000;
						INSPECTION_MACHINE_STOP_DELAY = 60000;
					}
				}
				/* ============================================ */
				// =============   й.   ========== //
				/* ============================================ */
				else if (InspectionOption.DHCountCheck[2] == 1)
				{
					//1	ܰ.	====================================
					if (InspectionOption.DHSpecialInsCheckbox)
					{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 100000;
						INSPECTION_MACHINE_STOP_DELAY = 100000;
						if ((InspectionOption.DHCountCheck[0] == 0) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
						{
							if (InspectionOption.DHSpecialInsCount[0] == 0)
							{
								InspectionOption.DHCountCheck[0] = 255;
							}
							if ((InspectionOption.DHSpecialInsCount[0] > 0)
							        && ((InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();       //⿡  Servo_Motor_Stop(BF_ID_MOTOR_INDEX); Servo_Motor_ServoOff(BF_OD_MOTOR_INDEX);(XXXX)

								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[1] > 0)
								{
									InspectionOption.DHSpecialInsCount[1] = InspectionOption.DHSpecialInsCount[0] + InspectionOption.DHSpecialInsCount[1];
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[1], 1,100);
							}
							if (DHOPOntime > 10000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								DistributorDelayFlag = 1;
								DistributorDelayTimer = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								//InspectionOption.DHCountCheck[0] = 1;
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHCountCheck[0], 2,101);
								if (InspectionOption.DHSpecialInsCount[1] == 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 1;
								}
								//TabletControlData.Func = TABLET_CONTROL_FUNC_INSPECTION
								//MainControlData.Func   = MAIN_CONTROL_FUNC_NONE;
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[0], InspectionOption.DHSpecialInsCount[1],102);
								DisStep++;
								DHoutputSignalTimeFlag = 0;
							}
						}
						//2 ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 1) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
						{
							if (DHmachineOnTimeFlag)
							{
								if (DistributorDelayTimer > 15000)  //15.
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_OUT_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;

									DistributorDelayTimer = 0;
									DistributorDelayFlag = 0;
									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[1], 999,222);
								}
							}
							if ((InspectionOption.DHSpecialInsCount[1] > 0)
							        && ((InspectionOption.DHSpecialInsCount[1] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[2] > 0)
								{
									InspectionOption.DHSpecialInsCount[2] = InspectionOption.DHSpecialInsCount[1] + InspectionOption.DHSpecialInsCount[2];
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[1], InspectionOption.DHSpecialInsCount[2],201);
							}
							if (DHOPOntime > 10000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								DistributorDelayFlag = 1;
								DistributorDelayTimer = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								//InspectionOption.DHCountCheck[0] = 2;
								if (InspectionOption.DHSpecialInsCount[2] == 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 2;
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[1], InspectionOption.DHSpecialInsCount[2],202);
								DisStep++;
								DHoutputSignalTimeFlag = 0;
							}
						}
						//3	ܰ.	====================================
						else if ((InspectionOption.DHCountCheck[0] == 2) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
						{
							if (DHmachineOnTimeFlag)
							{
								if (DistributorDelayTimer > 15000)  //15.
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;

									DistributorDelayTimer = 0;
									DistributorDelayFlag = 0;
									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, 9999, 999,333);
								}
							}
							if ((InspectionOption.DHSpecialInsCount[2] > 0)
							        && ((InspectionOption.DHSpecialInsCount[2] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[3] > 0)
								{
									InspectionOption.DHSpecialInsCount[3] = InspectionOption.DHSpecialInsCount[2] + InspectionOption.DHSpecialInsCount[3];
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[2], InspectionOption.DHSpecialInsCount[3],301);
							}
							if (DHOPOntime > 5000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								DistributorDelayFlag = 1;
								DistributorDelayTimer = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								//InspectionOption.DHCountCheck[0] = 3;
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[2], InspectionOption.DHSpecialInsCount[3],302);
								if (InspectionOption.DHSpecialInsCount[3] == 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 3;
								}
								DisStep++;
								DHoutputSignalTimeFlag = 0;
							}
						}
						//4	ܰ.  ====================================
						else if ((InspectionOption.DHCountCheck[0] == 3) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
						{
							if (DHmachineOnTimeFlag)
							{
								if (DistributorDelayTimer > 15000)  //15?
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;
									DistributorDelayTimer = 0;
									DistributorDelayFlag = 0;
									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, 9999, 999,444);
								}
							}
							if ((InspectionOption.DHSpecialInsCount[3] > 0)
							        && ((InspectionOption.DHSpecialInsCount[3] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[4] > 0)
								{
									InspectionOption.DHSpecialInsCount[4] = InspectionOption.DHSpecialInsCount[3] + InspectionOption.DHSpecialInsCount[4];
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[3], InspectionOption.DHSpecialInsCount[4],401);
							}
							if (DHOPOntime > 10000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								DistributorDelayFlag = 1;
								DistributorDelayTimer = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								//InspectionOption.DHCountCheck[0] = 4;
								if (InspectionOption.DHSpecialInsCount[4] == 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 4;
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[3], InspectionOption.DHSpecialInsCount[4],402);
								DisStep++;
								DHoutputSignalTimeFlag = 0;
							}
						}
						//5 ܰ.  ====================================
						else if ((InspectionOption.DHCountCheck[0] == 4) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
						{
							if (DHmachineOnTimeFlag)
							{
								if (DistributorDelayTimer > 15000)  //15.
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;

									DistributorDelayTimer = 0;
									DistributorDelayFlag = 0;
									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[4], 999,555);
								}
							}
							if ((InspectionOption.DHSpecialInsCount[4] > 0) && ((InspectionOption.DHSpecialInsCount[4] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
								if (InspectionOption.DHSpecialInsCount[5] > 0)
								{
									InspectionOption.DHSpecialInsCount[5] = InspectionOption.DHSpecialInsCount[4] + InspectionOption.DHSpecialInsCount[5];
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[5], DHoutputSignalTimeFlag,501);
							}
							if (DHOPOntime > 10000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								DistributorDelayFlag = 1;
								DistributorDelayTimer = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								//InspectionOption.DHCountCheck[0] = 5;
								if (InspectionOption.DHSpecialInsCount[5] == 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
								}
								else
								{
									InspectionOption.DHCountCheck[0] = 5;
								}
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHSpecialInsCount[4], InspectionOption.DHSpecialInsCount[5],502);
								DisStep++;
								DHoutputSignalTimeFlag = 0;
							}
						}
						//6  ܰ ====================================
						else if ((InspectionOption.DHCountCheck[0] == 5)	&& (PORT_ReadInPort(IP_DH_CONTROL) == 1))
						{
							if (DHmachineOnTimeFlag)
							{
								if (DistributorDelayTimer > 15000)  //15.
								{
									MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
									MC_Vibrator_Auto();
									DHmachineOnTimeFlag	= 0;

									DistributorDelayTimer = 0;
									DistributorDelayFlag = 0;
									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, 9999, 999,666);
								}
							}
							if ((InspectionOption.DHSpecialInsCount[5] > 0)
							        && ((InspectionOption.DHSpecialInsCount[5] + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount))
							{
								MC_Vibrator_Off();
								MC_BowlFeeder_Stop();
								if (DHOPOntimeFlag == 0)
									DHoutputDelayTimeFlag = 1;
								else
									DHoutputDelayTimeFlag = 0;
							}
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHOPOntimeFlag = 1;
								DHoutputSignalTimeFlag = 0;
							}
							if (DHOPOntime > 5000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHmachineOnTimeFlag	= 1;
								DistributorDelayFlag = 1;
								DistributorDelayTimer = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								InspectionOption.DHCountCheck[0] = 255;
								DisStep = 0;
								DHoutputSignalTimeFlag = 0;
							}
						}
						// Է ȵ STOP ܰ.  ====================================
						else if (InspectionOption.DHCountCheck[0] == 255)
						{
							if (DHoutputSignalTimeFlag)
							{
								PORT_ModifyOutPort(OP_YU_CONTROL, 1);
								DHoutputSignalTimeFlag = 0;
								DHOPOntimeFlag = 1;
							}
							if (DHOPOntime > 5000)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								PORT_ModifyOutPort(OP_YU_CONTROL, 0);
								MachineStatus.Suspended	= 1;
								MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
								MC_MainControl_Stop();
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, InspectionOption.DHCountCheck[0],8,999);
								DisStep = 0;
								DHoutputSignalTimeFlag = 0;
							}
						}
					}
					else
					{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 30000;
						INSPECTION_MACHINE_STOP_DELAY = 60000;
					}
				}
				/* ============================================ */
				// =============  Ѹ й.   ========== //
				// =============  ٷ .   ========== //
				/* ============================================ */
				else if (InspectionOption.DHCountCheck[3] == 1)
				{
					if (InspectionOption.DHSpecialInsCheckbox)
					{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 100000;
						INSPECTION_MACHINE_STOP_DELAY = 100000;
						//1	ܰ.	====================================
						if (DisStep == 0)
						{
							if ((InspectionOption.DHCountCheck[0] == 0) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
							{
								if (InspectionOption.DHSpecialInsCount[0] <= 0 || InspectionOption.DHSpecialInsCount[1] <= 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
									MC_Vibrator_Off();
									MC_BowlFeeder_Stop();
								}
								// (200 * 1) + 400  = 600 .
								if (DHoutputDelayTimeFlag == 0)
								{
									if ((InspectionOption.DHSpecialInsCount[0]*(DisStep + 1) + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount + LastGoodTabletCount)
									{
										MC_Vibrator_Off();
										MC_BowlFeeder_Stop();
										if (DHOPOntimeFlag == 0)
										{
											DHoutputDelayTimeFlag = 1;
										}
										else
										{
											DHoutputDelayTimeFlag = 0;
										}
										//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, DisStep,DHoutputDelayTimeFlag,98);
									}
								}


								if (DHoutputSignalTimeFlag && DHOPOntimeFlag == 0)	//߰ 5  Run Signal  ش....
								{
									if (InspectionOption.DHSpecialInsCount[1] >= 2)
									{
										PORT_ModifyOutPort(OP_YU_CONTROL, 1);
										DHoutputSignalTimeFlag = 0;
										DHOPOntimeFlag = 1;
										DHOPOntime	= 0;

										DisStep++;
										InspectionOption.DHCountCheck[0] = DisStep;
										
									}
									else
									{
										PORT_ModifyOutPort(OP_YU_CONTROL, 0);
										DisStep = 255;
										InspectionOption.DHCountCheck[0] = 255;
									}

									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, DisStep,InspectionOption.DHCountCheck[0],101);
								}

								if (DHOPOntimeFlag == 1)
								{
									if( DHOPOntime > 17000 ) 
									{
										DHOPOntimeFlag = 0;
										DHOPOntime = 0;
										DHmachineOnTimeFlag	= 1;
										DistributorDelayFlag = 1;
										DistributorDelayTimer = 0;
										DHoutputSignalTimeFlag = 0;
									}
								}
							}
							else
							{
								if (PORT_ReadInPort(IP_DH_CONTROL) == 0)
								{
									if (DHOPOntimeFlag == 1)
									{
										if( DHOPOntime > 3000 && PORT_ReadOutPort(OP_YU_CONTROL))
										{
											PORT_ModifyOutPort(OP_YU_CONTROL, 0);
										}
									}

									if(DHOPOntimeFlag == 0 && DHoutputDelayTimeFlag == 0)
									{
										InspectionAlarmState.AlarmExist	= 1;
										InspectionAlarmState.DistributorDown	= 1;
										PORT_ModifyOutPort(OP_YU_CONTROL,0); 
									}
									else
									{
										if( DHOPOntime > 30000 ) 
										{
											InspectionAlarmState.AlarmExist	= 1;
											InspectionAlarmState.DistributorDown	= 1;
											PORT_ModifyOutPort(OP_YU_CONTROL,0); 
										}
									}
								}
							}

						}
						//2ܰ  . ====================================
						else if (DisStep > 0) // && DisStep <= InspectionOption.DHSpecialInsCount[1]
						{
							//й   ŭ .
							// ܰ谡 Է ܰ躸   . InspectionOption.DHSpecialInsCount[1] 2
							if ((InspectionOption.DHCountCheck[0] < InspectionOption.DHSpecialInsCount[1]) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
							{
								if (DHmachineOnTimeFlag)
								{
									if (DistributorDelayTimer > 10000)  //15.
									{
										MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
										MC_Vibrator_Auto();
										DHmachineOnTimeFlag	= 0;
										DistributorDelayTimer = 0;
										DistributorDelayFlag = 0;
									}
								}

								// 2ܰ ʹ 1ܰ迡 ˻ ǰ  Բ  ؾ Ѵ.
								//   *  Step +  ǰ  <  ǰ 
								// , 100,000 * 4 ( Step) = 400,000 .
								if (DHoutputDelayTimeFlag == 0)
								{
									if ((InspectionOption.DHSpecialInsCount[0]*(DisStep + 1) + InspectionOption.DHCountCheck[5]) <= TabletInspectInfo.GoodTabletCount + LastGoodTabletCount)
									{
										MC_Vibrator_Off();
										MC_BowlFeeder_Stop();
										if (DHOPOntimeFlag == 0)
											DHoutputDelayTimeFlag = 1;
										else
											DHoutputDelayTimeFlag = 0;
									}
								}


								if (DHoutputSignalTimeFlag && DHOPOntimeFlag == 0)
								{
									if (InspectionOption.DHSpecialInsCount[1] > DisStep)
									{
										PORT_ModifyOutPort(OP_YU_CONTROL, 1);
										DHoutputSignalTimeFlag = 0;
										DHOPOntimeFlag = 1;
										DHOPOntime	= 0;
										DisStep++;
										InspectionOption.DHCountCheck[0] = DisStep;
									}
									else
									{
										PORT_ModifyOutPort(OP_YU_CONTROL, 0);
										DisStep = 255;
										InspectionOption.DHCountCheck[0] = 255;
									}

									//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, DisStep,InspectionOption.DHCountCheck[0], (100*(InspectionOption.DHCountCheck[0]+1)) + 1);
								}
								if (DHOPOntimeFlag == 1)
								{
									if( DHOPOntime > 17000 ) 
									{
										DHOPOntimeFlag = 0;
										DHOPOntime = 0;
										DHmachineOnTimeFlag	= 1;
										DistributorDelayFlag = 1;
										DistributorDelayTimer = 0;
										DHoutputSignalTimeFlag = 0;
									}
								}
							}
							else if (PORT_ReadInPort(IP_DH_CONTROL) == 0)
							{
								if (DHOPOntimeFlag == 1)
								{
									if( DHOPOntime > 3000 && PORT_ReadOutPort(OP_YU_CONTROL))
									{
										PORT_ModifyOutPort(OP_YU_CONTROL, 0);
									}
								}

								if(DHOPOntimeFlag == 0 && DHoutputDelayTimeFlag == 0)
								{
									InspectionAlarmState.AlarmExist	= 1;
									InspectionAlarmState.DistributorDown	= 1;
									PORT_ModifyOutPort(OP_YU_CONTROL,0); 
								}
								else
								{
									if( DHOPOntime > 30000 ) 
									{
										InspectionAlarmState.AlarmExist	= 1;
										InspectionAlarmState.DistributorDown	= 1;
										PORT_ModifyOutPort(OP_YU_CONTROL,0); 
									}
								}
							}
							//Է й   ?.(йⰡ غ ȵ 쵵.....)
							else if (InspectionOption.DHCountCheck[0] == 255)
							{
								DHOPOntimeFlag = 0;
								DHOPOntime = 0;
								DHoutputSignalTimeFlag = 0;
								MachineStatus.Suspended	= 1;
								MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
								MC_MainControl_Stop();
								DisStep = 0;
								InspectionOption.DHCountCheck[0] = 255;
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE, DisStep,TabletInspectInfo.GoodTabletCount,9999);
							}
						}
					}
					else
					{
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 30000;
						INSPECTION_MACHINE_STOP_DELAY = 60000;
					}
				}				
				else if (InspectionOption.DHCountCheck[4] == 1) //debug type4
				{
					if (InspectionOption.DHSpecialInsCheckbox)
					{																	
						if (DisStep == 0)
						{
							//DHCountCheck[0] = DisStep
							if ((InspectionOption.DHCountCheck[0] == 0) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
							{
							//DHSpecialInsCount[0]  ˻ 
							//DHSpecialInsCount[1] ü ˻  							
								if (InspectionOption.DHSpecialInsCount[0] <= 0 || InspectionOption.DHSpecialInsCount[1] <= 0)
								{
									InspectionOption.DHCountCheck[0] = 255;
									MC_Vibrator_Off();
									MC_BowlFeeder_Stop();
								}
								//InspectionOption.DHCountCheck[5] == GoodTabletCount
								// LastGoodTabletCount = TabletInspectInfo.GoodTabletCount;
								if ((InspectionOption.DHSpecialInsCount[0]*(DisStep + 1) + InspectionOption.DHCountCheck[5]) <= 
								TabletInspectInfo.GoodTabletCount + LastGoodTabletCount)
								{
									MC_Vibrator_Off();
									MC_BowlFeeder_Stop();

									if (InspectionOption.DHSpecialInsCount[1] >= 2)
									{
										MachineSetupData.DistributorCtrl.OutSigOnFlag = 1;	
										
										DisStep++;
										InspectionOption.DHCountCheck[0] = DisStep;												
										DHmachineOnTimeFlag = 1;
										DistributorDelayFlag = 1;
										DistributorDelayTimer = 0;
									}
									else
									{												
										DisStep = 255;
										InspectionOption.DHCountCheck[0] = 255;
									}
								}
													
							}
						}
						else if (DisStep > 0) 
						{
							if ((InspectionOption.DHCountCheck[0] < InspectionOption.DHSpecialInsCount[1]) && (PORT_ReadInPort(IP_DH_CONTROL) == 1))
							{
								if (DHmachineOnTimeFlag)
								{
									if (DistributorDelayTimer > (1000 * MachineSetupData.DistributorCtrl.WaitChangeBarrelTime))  //15.
									{
										MC_BowlFeeder_Run(MainControlData.MotorSpeed[BF_ID_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.MotorSpeed[BF_OD_IN_MOTOR_INDEX], MainControlData.AirKnifeSpeed);
										MC_Vibrator_Auto();
										DHmachineOnTimeFlag	= 0;
										DistributorDelayTimer = 0;
										DistributorDelayFlag = 0;
										NextStepFlag = 0;
									}
								}

								if (NextStepFlag == 0)
								{
								//InspectionOption.DHCountCheck[5] == GoodTabletCount
								// LastGoodTabletCount = TabletInspectInfo.GoodTabletCount;								
									if ((InspectionOption.DHSpecialInsCount[0]*(DisStep + 1) + InspectionOption.DHCountCheck[5]) <= 
									TabletInspectInfo.GoodTabletCount + LastGoodTabletCount)
									{
										MC_Vibrator_Off();
										MC_BowlFeeder_Stop();
										
										if(InspectionOption.DHSpecialInsCount[1] > (DisStep+1))
										{
											MachineSetupData.DistributorCtrl.OutSigOnFlag = 1;	
											DHmachineOnTimeFlag = 1;
											DistributorDelayFlag = 1;
											DisStep++;
											InspectionOption.DHCountCheck[0] = DisStep;
											NextStepFlag = 1;												
										}
										else
										{			
											if(InspectionOption.SendCompleteSigDistributor == 1)
											{
												InsCompleteForDistributorFlag = 1;
											}
											DisStep = 255;
											InspectionOption.DHCountCheck[0] = 255;
											NextStepFlag = 0;
										}											
									}
								}
							}
							else if (InspectionOption.DHCountCheck[0] == 255)
							{
								MachineStatus.Suspended	= 1;
								MachineStatus.SuspendReason	= MACHINE_SUSPEND_REASON_FEEDER_EMPTY;
								MC_MainControl_Stop();
								DisStep = 0;
								InspectionOption.DHCountCheck[0] = 255;
								NextStepFlag = 0;
							}
						}

						DistributorOutSigCtrl();
						DistributorCheckInSig();

						DistributorMonitor.DisStep = DisStep; 
						TabletInspectInfo.LastDisStep = DisStep;
					}
					else
					{
						//MACHINE_STOP_SENSOR_EMPTY_LIMIT	= (MachineSetupData.DistributorCtrl.OutSigStartDelay * 1000 ) + 30000;
						//INSPECTION_MACHINE_STOP_DELAY = (MachineSetupData.DistributorCtrl.OutSigStartDelay * 1000 ) + 60000;
						MACHINE_STOP_SENSOR_EMPTY_LIMIT	= 30000;
						INSPECTION_MACHINE_STOP_DELAY = 60000;						
					}
				}
				////// end //////			
			}
#endif

		}
	}
	else if(TabletControlData.Func == TABLET_CONTROL_FUNC_NONE)
	{
		if(InspectionOption.DHCountCheck[3] == 1 &&InspectionOption.DHSpecialInsCheckbox == 1 && InspectionOption.DistributorConveyerEnable == 1)
		{
			if(PORT_ReadOutPort(OP_DH_CONTROL))
			{
				if(DHOPOntime > 5000) 	
					PORT_ChangeOutPort(OP_DH_CONTROL,0);
				else
					DHOPOntime++;
			}
		}
	}

	if(InsCompleteForDistributorFlag == 1)
	{
		if(OutSigOnFlagForInsComp == 0)
		{
			MachineSetupData.DistributorCtrl.OutSigOnFlag = 1;	

			OutSigOnFlagForInsComp= 1;
		}
		DistributorOutSigCtrl();	
	}
}
//---------------------------------------------------------------------------
void TabletControl_ContinueInspection(TTabletInspectInfo *info)
{
	// PCα׷	Ŀǵ  
	// InspectionOption.EjectMode ̴ϼ 

	memcpy(&TabletInspectInfo, info, sizeof(TTabletInspectInfo));
	StatusCheckingInfo.InspectionCheckingCounter = INSPECTION_CHECKING_TIME;
	StatusCheckingInfo.CritUnInsCheckingCounter	= CRIT_UNINS_CHECKING_TIME;
	StatusCheckingInfo.CritDefectCheckingCounter = CRIT_DEFECT_CHECKING_TIME;
	StatusCheckingInfo.BeforeDisk2TabletCount = TabletInspectInfo.Disk2TabletCount;
	StatusCheckingInfo.BeforeDefectTabletCount = TabletInspectInfo.DefectTabletCount;
	StatusCheckingInfo.BeforeUnInsTabletCount = TabletInspectInfo.UnInsTabletCount;
	StatusCheckingInfo.BeforeCritTabletCount = TabletInspectInfo.TotalTabletCount;
	StatusCheckingInfo.BeforeCritTabletCountD = TabletInspectInfo.TotalTabletCount;
	StatusCheckingInfo.BeforeCritUnInsTabletCount = TabletInspectInfo.UnInsTabletCount;
	StatusCheckingInfo.BeforeCritDefectTabletCount = TabletInspectInfo.DefectTabletCount;
	StatusCheckingInfo.IgnoredUninsCount = 0;
	StatusCheckingInfo.IgnoredCritUninsCount = 0;

	TabletInfo.CurrentTabletNumber = TabletInspectInfo.TotalTabletCount	+ 1;
	TabletInfo.Disk1TabletList[TabletInfo.CurrentSensor1ListIndex].TabletNumber	= TabletInfo.CurrentTabletNumber;
	TabletInfo.Disk2TabletList[TabletInfo.CurrentSensor2ListIndex].TabletNumber	= 0;

	TabletControlData.LastTabletSensor2Time	= Board1MSTmr;
	TabletControlData.Func = TABLET_CONTROL_FUNC_INSPECTION;
}
//---------------------------------------------------------------------------
void TabletControl_ApplyMachineSetup(TMachineSetupData *machineSetupData)
{
	int	captureIndex;

	for (captureIndex	= 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
	{
		TabletControlSetupData.IlluminatorDelay[captureIndex] = machineSetupData->MachineCaptureInfo.IlluminatorDelay[captureIndex];
		TabletControlSetupData.IlluminatorMask[captureIndex] = machineSetupData->MachineCaptureInfo.IlluminatorMask[captureIndex];
		TabletControlSetupData.IlluminatorTime[captureIndex] = machineSetupData->MachineCaptureInfo.IlluminatorTime[captureIndex];
	}

	TabletControlSetupData.SensorIntervalA = machineSetupData->SensorIntervalA;
	TabletControlSetupData.SensorIntervalB = machineSetupData->SensorIntervalB;
	TabletControlSetupData.CaptureIntSPBMask1 = machineSetupData->MachineCaptureInfo.SensorSPBMask[0];
	TabletControlSetupData.CaptureIntSPBMask2 = machineSetupData->MachineCaptureInfo.SensorSPBMask[1];
}
//---------------------------------------------------------------------------
unsigned long WellRng512(void)		// random number generator
{
	unsigned long a, b, c, d;
	a = WellRng512State[WellRngIndex];
	c = WellRng512State[(WellRngIndex + 13)	& 15];
	b = a ^ c ^ (a << 16) ^ (c << 15);
	c = WellRng512State[(WellRngIndex + 9) & 15];
	c ^= (c	>> 11);
	a = WellRng512State[WellRngIndex] = b ^ c;
	d = a ^ ((a	<< 5) & 0xDA442D20UL);
	WellRngIndex = (WellRngIndex + 15) & 15;
	a = WellRng512State[WellRngIndex];
	WellRng512State[WellRngIndex] = a ^ b ^ d ^ (a << 2) ^ (b << 18) ^ (c << 28);
	return WellRng512State[WellRngIndex];
}
//---------------------------------------------------------------------------

void SuctionDisk1SimulationProcess(void)
{
	char tabletDetected, misfeedingTabletDetected, expectedTabletCount; //normalTabletDetected,multiTabletDetected
	unsigned int detectedSensorOnTime, detectedSensorLength;
	int	tabletListIndex, tabletIndex;
	unsigned int tabletSensorOnTime, tabletSensorLength;
	int	prevTabletListIndex;

	tabletDetected = 0;
	misfeedingTabletDetected = 0;

	if (TabletSensorQueue[0].Start != TabletSensorQueue[0].End)
	{
		TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorOnTime = board50usTmr;
		TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength = InspectionOption.StudiedTabletSensor1Length;

		tabletDetected = 1;
		expectedTabletCount	= 1;
		//normalTabletDetected 		= 1;
		detectedSensorOnTime = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorOnTime;
		detectedSensorLength = TabletSensorQueue[0].List[TabletSensorQueue[0].Start].SensorLength;
		TabletSensorQueue[0].Start = (TabletSensorQueue[0].Start + 1) & TABLET_SENSOR_LIST_MASK;
	}

	if (tabletDetected)
	{
		tabletSensorOnTime = detectedSensorOnTime;
		tabletSensorLength = detectedSensorLength / expectedTabletCount;
		for (tabletIndex = 0; tabletIndex < expectedTabletCount; tabletIndex++)
		{
			tabletListIndex	= TabletInfo.CurrentSensor1ListIndex;

			TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Time	= tabletSensorOnTime;
			TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Length = tabletSensorLength;
			TabletInfo.Disk1TabletList[tabletListIndex].EstimatedSensor2Time = TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Time + TabletControlData.SensorIntervalA;
			TabletInfo.Disk1TabletList[tabletListIndex].CaptureIntTime = TabletInfo.Disk1TabletList[tabletListIndex].Sensor1Time + tabletSensorLength	/ 2	+ TabletControlData.CaptureIntDelay;

			if (misfeedingTabletDetected)
			{
				TabletInfo.Disk1TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_SENSOR_1_MISFEEDING;
				TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_ERROR;
			}
			else
			{
				TabletInfo.Disk1TabletList[tabletListIndex].State = TABLET_STATE_SENSOR_1_PASSED;
			}
			AdvanceDisk1TabletList();
			TabletInspectInfo.Disk1TabletCount++;
			tabletSensorOnTime += tabletSensorLength;
		}
	}
}
//---------------------------------------------------------------------------

void SuctionDisk2SimulationProcess(void)
{
	char tabletDetected, misfeedingTabletDetected, expectedTabletCount, normalTabletDetected; //multiTabletDetected
	unsigned int detectedSensorOnTime, detectedSensorLength;
	int	tabletListIndex, prevTabletListIndex, relatedDisk1TabletListIndex, relatedDisk1NextTabletListIndex, tabletIndex;
	char bLateTabletDetected;
	unsigned int tabletSensorOnTime, tabletSensorLength;

	//2016.11.03 Add
	int LengthErrorDetected;

	tabletDetected = 0;
	normalTabletDetected = 0;
	//multiTabletDetected	= 0;
	misfeedingTabletDetected = 0;
	LengthErrorDetected	= 0;


	if (TabletSensorQueue[1].Start != TabletSensorQueue[1].End)
	{
		TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime = board50usTmr + InspectionOption.StudiedSensorIntervalA;
		TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength = InspectionOption.StudiedTabletSensor2Length;

		tabletDetected = 1;
		expectedTabletCount	= 1;
		normalTabletDetected = 1;
		detectedSensorOnTime = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorOnTime;
		detectedSensorLength = TabletSensorQueue[1].List[TabletSensorQueue[1].Start].SensorLength;
		TabletSensorQueue[1].Start = (TabletSensorQueue[1].Start + 1) & TABLET_SENSOR_LIST_MASK;
	}
	if (tabletDetected)
	{
		if (misfeedingTabletDetected)       //misfeedingTabletDetected : OK
		{
			tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
			TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= detectedSensorOnTime;
			TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= detectedSensorLength;
			TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length / 2 + TabletControlData.CaptureIntDelay;

			TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time = TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB; //
			if (TabletControlData.Func & TABLET_CONTROL_FUNC_CAPTURE_REQUIRED)
			{
				relatedDisk1TabletListIndex	= TabletInfo.CurrentRelatedDisk1TabletListIndex;
				if (TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].State != TABLET_STATE_READY)
				{
					TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;
					TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
					TabletInfo.CurrentRelatedDisk1TabletListIndex	= (TabletInfo.CurrentRelatedDisk1TabletListIndex + 1) & HCB_TABLET_LIST_MASK;
				}
				else
				{
					TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber = 0;
					TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time = 0;
				}
				TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= detectedSensorOnTime + TabletControlData.DefectEjectorDelay
				        - (TabletControlData.ExpectedSensor2Length * 3);
				TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= detectedSensorOnTime + TabletControlData.UnInsEjectorDelay
				        - (TabletControlData.ExpectedSensor2Length * 3);
				//Q
				TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= detectedSensorOnTime + TabletControlData.GoodEjectorDelay
				        - (TabletControlData.ExpectedSensor2Length * 3);
			}
			TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TABLET_RESULT_SENSOR_2_MISFEEDING;    //̰ ó
			TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_ERROR;
			AdvanceDisk2TabletList();
			TabletInspectInfo.Disk2TabletCount++;
		}
		else
		{
			tabletSensorOnTime = detectedSensorOnTime;
			tabletSensorLength = detectedSensorLength / expectedTabletCount;

			for (tabletIndex = 0; tabletIndex < expectedTabletCount; tabletIndex++)
			{
				tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
				bLateTabletDetected	= 0;

				if (TabletControlData.Func & TABLET_CONTROL_FUNC_MATCHING_REQUIRED)
				{
					relatedDisk1TabletListIndex	= TabletInfo.CurrentRelatedDisk1TabletListIndex;

					//SensorMinIntervalA   Դٰ ؼ Error ó   ֳ?
					if ((TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].State == TABLET_STATE_READY) ||
					        ((tabletSensorOnTime - TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time)	< TabletControlData.SensorMinIntervalA)) //1, 2  	tablet Ÿ	ּ Interval  
					{																								 //TabletControlData.SensorMinIntervalA	= (sensorIntervalA - SENSOR_INTERVAL_LIMIT(=100)) *	suctionDiskSpeed / ServoMotorBaseSpeed[SD1_MOTOR_INDEX];
						prevTabletListIndex	= (tabletListIndex - 1)	& HCB_TABLET_LIST_MASK;	// tablet	index	

						//Add 2017.12.05
						TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;

						if (TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult == TABLET_RESULT_DISAPPEARED) // Tablet  
						{
							TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult	= TABLET_RESULT_CLOSED_UNINS; // 1 ߰ߵ Ÿ 2 ߰ߵ ʾ	 tabletó
							TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time	= tabletSensorOnTime; //  tablet	 	߰ߵ 2 ð 
							TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Length	= tabletSensorLength; //  tablet	 	߰ߵ tablet ̸ 
							TabletInfo.Disk2TabletList[prevTabletListIndex].DefectEjectorTime	= tabletSensorOnTime + TabletControlData.DefectEjectorDelay; //DefectEjectorDelay Calibration 
							TabletInfo.Disk2TabletList[prevTabletListIndex].UnInsEjectorTime	= tabletSensorOnTime + TabletControlData.UnInsEjectorDelay;  //UnInsEjectorDelay Calibration	
							//Q
							TabletInfo.Disk2TabletList[prevTabletListIndex].GoodEjectorTime = tabletSensorOnTime + TabletControlData.GoodEjectorDelay;
							TabletInfo.Disk2TabletList[prevTabletListIndex].EstimatedSensor3Time = tabletSensorOnTime + TabletControlData.SensorIntervalB;    // tablet   3 ɸ ð	
							bLateTabletDetected	= 1;
						}
						else
						{
							//prevTabletListIndex  sTATE TABLET_STATE_SENSOR_2_PASSED/TABLET_STATE_ERROR .
							TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TABLET_RESULT_INSERTED;	//tablet 
							TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;	// save	detected sensor2 data
							TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;	// save	detected tablet	length
							TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= tabletSensorOnTime + TabletControlData.DefectEjectorDelay;
							//Q.
							TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= tabletSensorOnTime + TabletControlData.GoodEjectorDelay;
							TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= tabletSensorOnTime + TabletControlData.UnInsEjectorDelay;
							TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time = tabletSensorOnTime + TabletControlData.SensorIntervalB;
							TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_ERROR;
						}
					}
					else
					{
						relatedDisk1NextTabletListIndex	= (relatedDisk1TabletListIndex + 1)	& HCB_TABLET_LIST_MASK;

						if (TabletInfo.Disk1TabletList[relatedDisk1NextTabletListIndex].State != TABLET_STATE_READY	&&
						        (int)(tabletSensorOnTime - TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time) >     // SensorTime + TabletControlData.SensorInterval;
						        (int)(TabletInfo.Disk1TabletList[relatedDisk1NextTabletListIndex].EstimatedSensor2Time - tabletSensorOnTime)) // if next estimated time is closer than current estimated time
						{
							prevTabletListIndex	= (tabletListIndex - 1)	& HCB_TABLET_LIST_MASK;

							if (TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult == TABLET_RESULT_INSERTED)
							{
								// 2 tablet  Ȯε	
								// տ Inserted ̸ տ Early  ٲٴ±.
								TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult	= TABLET_RESULT_CLOSED_DEFECT;
								TabletInfo.Disk2TabletList[prevTabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;
								TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time;
								TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Length;
								TabletInfo.Disk2TabletList[prevTabletListIndex].EstimatedSensor2Time = TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
								//Add 2017.12.01
								//2017.12.08 del TabletInfo.Disk2TabletList[tabletListIndex].State 	 = TABLET_STATE_ERROR;
							}
							else
							{
								//2 tablet ߰ߵ	
								//̺κ ü ̹ tabletDetected  ε DISAPPEARED  ֳ ???
								//  Դµ InspectionResult  TABLET_RESULT_DISAPPEARED  ?????
								TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TABLET_RESULT_DISAPPEARED;
								TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;
								TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time;
								TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Length;
								TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
								TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time;
								TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB;

								if (TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult == TABLET_RESULT_DISAPPEARED)
								{
									// tablet	̹߰ߵ 
									//  Դµ տ  ????
									TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time;
									TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        + TabletControlData.DefectEjectorDelay;
									TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        + TabletControlData.UnInsEjectorDelay;
									//Q
									TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        + TabletControlData.GoodEjectorDelay;
								}
								else if (TabletInfo.Disk2TabletList[prevTabletListIndex].State != TABLET_STATE_READY &&
								         ((TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time - TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time)
								          < TabletControlData.TabletVarianceTime))	//2mm  ..
								{
									TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult	= TABLET_RESULT_UNINTENDED_UNINSPECT;
									TabletInfo.Disk2TabletList[prevTabletListIndex].State	= TABLET_STATE_ERROR;
									TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time;


									TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        + TabletControlData.DefectEjectorDelay;
									TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        + TabletControlData.UnInsEjectorDelay;
									//Q
									TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        + TabletControlData.GoodEjectorDelay;
								}
								else
								{
									//տ  δϱ  .....
									TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        - TabletControlData.TabletVarianceTime		//2000
									        + TabletControlData.BlowerPadingDelay		//100
									        + TabletControlData.DefectEjectorDelay;
									TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        - TabletControlData.TabletVarianceTime
									        + TabletControlData.BlowerPadingDelay
									        + TabletControlData.UnInsEjectorDelay;
									//Q
									TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
									        - TabletControlData.TabletVarianceTime
									        + TabletControlData.BlowerPadingDelay
									        + TabletControlData.GoodEjectorDelay;
								}
								TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_ERROR;
								AdvanceDisk2TabletList();
								tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
							}
							TabletInfo.CurrentRelatedDisk1TabletListIndex = (TabletInfo.CurrentRelatedDisk1TabletListIndex + 1)	& HCB_TABLET_LIST_MASK;
							relatedDisk1TabletListIndex	= TabletInfo.CurrentRelatedDisk1TabletListIndex;
						}
						// check second	match
						TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;
						TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime	= tabletSensorOnTime + tabletSensorLength / 2 + TabletControlData.CaptureIntDelay;


						TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= tabletSensorOnTime + TabletControlData.DefectEjectorDelay;
						TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= tabletSensorOnTime + TabletControlData.UnInsEjectorDelay;
						//Q
						TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= tabletSensorOnTime + TabletControlData.GoodEjectorDelay;

						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time = tabletSensorOnTime + TabletControlData.SensorIntervalB;

						TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Length;
						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time = TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
						TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].InspectionResult;
						/*
						if (multiTabletDetected)
						{
							TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_MULTI_TABLET_SENSOR_2;
						}
						*/

						//Add 20170621
						if (LengthErrorDetected == 1	&& TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION)
						{
							TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult = TABLET_RESULT_MULTI_TABLET_SENSOR_2;
						}

						if (TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].State == TABLET_STATE_ERROR)
						{
							TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_ERROR;
						}
						else
						{
							TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_SENSOR_2_PASSED;
							/*
							if (multiTabletDetected)
							{
								TabletInfo.Disk2TabletList[tabletListIndex].State =	TABLET_STATE_ERROR;
							}
							*/

							//Add 20170621
							if (LengthErrorDetected	== 1 && TabletControlData.Func == TABLET_CONTROL_FUNC_INSPECTION)
							{
								TabletInfo.Disk2TabletList[tabletListIndex].State = TABLET_STATE_ERROR;
								LengthErrorDetected	= 0;
								//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_NONE,TabletControlData.ExpectedSensor2Length,
								//					tabletSensorLength,300);
							}
						}
						TabletInfo.CurrentRelatedDisk1TabletListIndex = (TabletInfo.CurrentRelatedDisk1TabletListIndex + 1)	& HCB_TABLET_LIST_MASK;
					}
				}
				else		// study or	check_interval
				{
					if (normalTabletDetected)
					{
						relatedDisk1TabletListIndex	= TabletInfo.CurrentRelatedDisk1TabletListIndex;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;
						TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime	= tabletSensorOnTime + tabletSensorLength / 2 + TabletControlData.CaptureIntDelay;

						TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Length;
						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB;
						TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_SENSOR_2_PASSED;
						TabletInfo.CurrentRelatedDisk1TabletListIndex	= (TabletInfo.CurrentRelatedDisk1TabletListIndex + 1) & HCB_TABLET_LIST_MASK;
					}
					else //multi
					{
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= tabletSensorOnTime;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= tabletSensorLength;
						TabletInfo.Disk2TabletList[tabletListIndex].CaptureIntTime	= tabletSensorOnTime + tabletSensorLength / 2 + TabletControlData.CaptureIntDelay;

						TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor3Time	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time + TabletControlData.SensorIntervalB;
						TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_ERROR;
					}
				}
				if (!bLateTabletDetected)
				{
					AdvanceDisk2TabletList();
				}
				TabletInspectInfo.Disk2TabletCount++;
				tabletSensorOnTime += tabletSensorLength;
			} //For
		}
	}


	// check deletion
	if (TabletControlData.Func & TABLET_CONTROL_FUNC_MATCHING_REQUIRED)
	{
		tabletListIndex	= TabletInfo.CurrentSensor2ListIndex;
		relatedDisk1TabletListIndex	= TabletInfo.CurrentRelatedDisk1TabletListIndex;
		if (TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].State != TABLET_STATE_READY
		        && TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].InspectionResult	!= TABLET_RESULT_SENSOR_1_MISFEEDING)	//1 tablet misfeeding	 	
		{
			if (((board50usTmr - TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time > TabletControlData.SensorMaxIntervalA)) // Interval	MaxIntervalA 	Ŭ 
			        && (TabletControlData.SensorState2 == SENSOR_STATE_OFF) && (TabletSensorQueue[1].Start == TabletSensorQueue[1].End))
			{
				prevTabletListIndex	= (tabletListIndex - 1)	& HCB_TABLET_LIST_MASK;	// 2 ?tablet index 
				if (TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult == TABLET_RESULT_INSERTED)	// tablet	Ǿٸ
				{
					//  tablet ó
					//disk1   tablet  disk2  tablet	 data 
					//⵵ prevTabletListIndex  State   ϴµ ....
					//tabletListIndex  STATE  0 ε ........
					TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult	= TABLET_RESULT_DISAPPEARED;
					TabletInfo.Disk2TabletList[prevTabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;
					TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time;
					TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Length;
					TabletInfo.Disk2TabletList[prevTabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
					TabletInfo.CurrentRelatedDisk1TabletListIndex = (TabletInfo.CurrentRelatedDisk1TabletListIndex + 1)	& HCB_TABLET_LIST_MASK;
					//Add 2017.12.01
					//2017.12.08 del TabletInfo.Disk2TabletList[tabletListIndex].State 		= TABLET_STATE_ERROR;
				}
				else
				{
					//tablet 
					//disk1	  ũ2	 ԽŰ, 2 ǵ	Tablet ̴  н	 Է
					TabletInfo.Disk2TabletList[tabletListIndex].InspectionResult	= TABLET_RESULT_DISAPPEARED;
					TabletInfo.Disk2TabletList[tabletListIndex].TabletNumber	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].TabletNumber;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Time;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor1Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].Sensor1Length;
					TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time;
					TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk2TabletList[tabletListIndex].EstimatedSensor2Time;

					if (TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult == TABLET_RESULT_DISAPPEARED)
					{
						// tablet	 
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time;
						TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.DefectEjectorDelay;
						TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.UnInsEjectorDelay;
						//Q
						TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.GoodEjectorDelay;

					}
					else if (TabletInfo.Disk2TabletList[prevTabletListIndex].State != TABLET_STATE_READY &&
					         ((TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time - TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time)
					          < TabletControlData.TabletVarianceTime))
					{
						// disk2_Ontime	- disk2_pre_Ontime,	 Ÿ  2 ms̸  κҸ ̰ó
						TabletInfo.Disk2TabletList[prevTabletListIndex].State	= TABLET_STATE_ERROR;
						TabletInfo.Disk2TabletList[prevTabletListIndex].InspectionResult	= TABLET_RESULT_UNINTENDED_UNINSPECT;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk2TabletList[prevTabletListIndex].Sensor2Time;
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time
						        - TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.ExpectedSensor2Length;
						TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.DefectEjectorDelay;
						TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.UnInsEjectorDelay;
						//Q?
						TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.GoodEjectorDelay;
					}
					else
					{
						//߰ м	ʿ
						// sjm 2017.11.20  ̷ ʿ䰡 .
						//Sensor2Time   Ǿµ DefectEjectorTime  ״ ص ǳ ?
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time
						        - TabletControlData.TabletVarianceTime  //= 100 ms
						        + TabletControlData.BlowerPadingDelay;	//=  10 ms
						TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Length	= TabletInfo.Disk1TabletList[relatedDisk1TabletListIndex].EstimatedSensor2Time
						        - TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.ExpectedSensor2Length;
						TabletInfo.Disk2TabletList[tabletListIndex].DefectEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.DefectEjectorDelay;
						TabletInfo.Disk2TabletList[tabletListIndex].UnInsEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.UnInsEjectorDelay;
						//Q
						TabletInfo.Disk2TabletList[tabletListIndex].GoodEjectorTime	= TabletInfo.Disk2TabletList[tabletListIndex].Sensor2Time
						        + TabletControlData.GoodEjectorDelay;
					}
					TabletInfo.Disk2TabletList[tabletListIndex].State	= TABLET_STATE_ERROR;
					TabletInfo.CurrentRelatedDisk1TabletListIndex	= (TabletInfo.CurrentRelatedDisk1TabletListIndex + 1) & HCB_TABLET_LIST_MASK;
					AdvanceDisk2TabletList();
				}
			}
		}
	}
}

void DefaultDefectEjectorConfig(int index)
{
	THCBDisk2TabletUnit	*prevDisk2TabletUnit, *disk2TabletUnit, *nextDisk2TabletUnit;
	disk2TabletUnit	= &(TabletInfo.Disk2TabletList[index]);
	prevDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(index - 1) & HCB_TABLET_LIST_MASK]);
	nextDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(index + 1) & HCB_TABLET_LIST_MASK]);

	if(InspectionOption.EjectMode == 0)
	{		
		AddDefectEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.DefectEjectorLength), disk2TabletUnit->TabletNumber,disk2TabletUnit->Sensor2Time);
	}
	disk2TabletUnit->Ejection = TABLET_EJECTION_DEFECT;
	TabletInspectInfo.DefectTabletCount++;
	TabletInspectInfo.TotalTabletCount++;
	TabletInfo.PollingBlowTabletIndex = (TabletInfo.PollingBlowTabletIndex + 1)	& HCB_TABLET_LIST_MASK;	

}

void DefaultUnInsEjectorConfig(int index)
{
	THCBDisk2TabletUnit	*prevDisk2TabletUnit, *disk2TabletUnit, *nextDisk2TabletUnit;
	disk2TabletUnit	= &(TabletInfo.Disk2TabletList[index]);
	prevDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(index - 1) & HCB_TABLET_LIST_MASK]);
	nextDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(index + 1) & HCB_TABLET_LIST_MASK]);

	if (InspectionOption.EjectMode == 1)	//Special Mode
	{
		if (InspectionOption.UnInsBlowCheck == 1)
		{
			AddUninsEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.UnInsEjectorLength), disk2TabletUnit->TabletNumber);
		}
		disk2TabletUnit->Ejection = TABLET_EJECTION_UNINSPECT;
		TabletInspectInfo.UnInsTabletCount++;
		TabletInspectInfo.TotalTabletCount++;
		TabletInfo.PollingBlowTabletIndex = (TabletInfo.PollingBlowTabletIndex + 1)	& HCB_TABLET_LIST_MASK;				
	}
	else if (InspectionOption.EjectMode == 0)
	{
		if ( ((int)board50usTmr	+ INSPECTION_TIMEOUT_PADING_DELAY - disk2TabletUnit->UnInsEjectorTime )	< 0)
		{		
			AddUninsEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.UnInsEjectorLength), disk2TabletUnit->TabletNumber);
			disk2TabletUnit->Ejection = TABLET_EJECTION_UNINSPECT;
			TabletInspectInfo.UnInsTabletCount++;
			TabletInspectInfo.TotalTabletCount++;
			TabletInfo.PollingBlowTabletIndex = (TabletInfo.PollingBlowTabletIndex + 1)	& HCB_TABLET_LIST_MASK;				
		}
		else 
		{
			DefaultDefectEjectorConfig(index);						
		}
	}
}

void DefaultDistributorConfig(int index, int Company)

{
	THCBDisk2TabletUnit	*prevDisk2TabletUnit, *disk2TabletUnit, *nextDisk2TabletUnit;
	disk2TabletUnit	= &(TabletInfo.Disk2TabletList[index]);
	prevDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(index - 1) & HCB_TABLET_LIST_MASK]);
	nextDisk2TabletUnit	= &(TabletInfo.Disk2TabletList[(index + 1) & HCB_TABLET_LIST_MASK]);
	if (Company == INTERNATIONAL_MACHINE1)
	{
		if (InspectionOption.EjectMode == 1) //EjectMode Ȯ ؾ .
		{
			if (Q_goodbloworder == 1)
			{
				DisInputCnt1++;
				if (DisInputCnt1 > InspectionOption.SPModeGoodTabletCollectCount1)
				{
					Q_goodbloworder = 2;
					DisInputCnt1 = 0;
					DisInputCnt2 = 0;
				}
			}
			else if (Q_goodbloworder == 2)
			{
				DisInputCnt2++;
				if (DisInputCnt2 > InspectionOption.SPModeGoodTabletCollectCount2)
				{
					Q_goodbloworder = 1;
					DisInputCnt1 = 0;
					DisInputCnt2 = 0;
				}
			}
			if (Q_goodbloworder == 1) 
			{
				TabletInspectInfo.SPGoodTabletDropIndex = 0;
				AddGoodEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.GoodEjectorLength), disk2TabletUnit->TabletNumber);
				//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,123456789,goodEjectStartTime,goodEjectDelay);
			}
			else if (Q_goodbloworder == 2)
			{
				TabletInspectInfo.SPGoodTabletDropIndex = 1;
				AddUninsEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.UnInsEjectorLength), disk2TabletUnit->TabletNumber);
				//ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG,ERROR_CODE_NONE,23456789,goodEjectStartTime,goodEjectDelay);
			}
		}
	}
	else if (Company == DOMESTIC_MACHINE2)
	{
		if (InspectionOption.EjectMode == 1) 
		{
			AddDefectEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.DefectEjectorLength), disk2TabletUnit->TabletNumber,disk2TabletUnit->Sensor2Time);
		}
		else if (InspectionOption.EjectMode == 0)
		{
			if (InspectionOption.DistributorCheck == 1)
			{
				if (goodbloworder == 1)
				{
					DisInputCnt1++;
					if (DisInputCnt1 >= InspectionOption.DistributorGoodTabletCount1)
					{
						goodbloworder	= 2;
						DisInputCnt1	= 0;
						TabletInspectInfo.SPGoodTabletDropIndex = 1;
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 0);
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 1);
					}
				}
				else if (goodbloworder == 2)
				{
					DisInputCnt2++;
					if (DisInputCnt2 >= InspectionOption.DistributorGoodTabletCount2)
					{
						goodbloworder	= 3;
						DisInputCnt2	= 0;
						TabletInspectInfo.SPGoodTabletDropIndex = 2;
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
					}
				}
				else if (goodbloworder == 3)
				{
					AddGoodEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.GoodEjectorLength), disk2TabletUnit->TabletNumber);
					DisInputCnt3++;
					if (DisInputCnt3 >= InspectionOption.DistributorGoodTabletCount3)
					{
						goodbloworder	= 1;
						DisInputCnt3	= 0;
						TabletInspectInfo.SPGoodTabletDropIndex = 0;
					}
				}
			}
		}
	}
	else
	{
		if (InspectionOption.EjectMode == 1)
		{
			AddDefectEjectorEncoderQueue(disk2TabletUnit->Disk2Encoder,disk2TabletUnit->Disk2EncoderLength+(EJECT_ENCODER_LENGTH*EjectorSetupData.DefectEjectorLength), disk2TabletUnit->TabletNumber,disk2TabletUnit->Sensor2Time);
		}
		else if (InspectionOption.EjectMode == 0)
		{
			if (InspectionOption.DistributorCheck == 1)
			{
				if (goodbloworder == 1)
				{
					DisInputCnt1++;
					if (DisInputCnt1 >= InspectionOption.DistributorGoodTabletCount1)
					{
						goodbloworder	= 2;
						DisInputCnt1	= 0;
						TabletInspectInfo.SPGoodTabletDropIndex = 1;
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 0);
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 1);
					}
				}
				else if (goodbloworder == 2)
				{
					DisInputCnt2++;
					if (DisInputCnt2 >= InspectionOption.DistributorGoodTabletCount2)
					{
						goodbloworder	= 1;
						DisInputCnt2	= 0;
						TabletInspectInfo.SPGoodTabletDropIndex = 0;
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_ON, 1);
						PORT_ModifyOutPort(OP_2DISTRIBUTOR_OFF, 0);
					}
				}
			}
		}
	}
	TabletInspectInfo.GoodTabletCount++;
	TabletInspectInfo.TotalTabletCount++;
	TabletInfo.PollingBlowTabletIndex = (TabletInfo.PollingBlowTabletIndex + 1)	& HCB_TABLET_LIST_MASK;
}

//debug type4
void DistributorOutSigCtrl()
{
	if(MachineSetupData.DistributorCtrl.OutSigOnFlag)
	{
		if(MachineSetupData.DistributorCtrl.OutSigStartDelayFlag == 0)
		{
			MachineSetupData.DistributorCtrl.OutSigStartDelayTime = Board100MSTmr;
			MachineSetupData.DistributorCtrl.OutSigStartDelayFlag = 1;
		}
		
		if((Board100MSTmr - MachineSetupData.DistributorCtrl.OutSigStartDelayTime) > (MachineSetupData.DistributorCtrl.OutSigDelayTime * 10))
		{
			PORT_ModifyOutPort(OP_YU_CONTROL, 1);
			MachineSetupData.DistributorCtrl.OutSigState = OP_YU_CONTROL_ON;
			MachineSetupData.DistributorCtrl.OutSigOnFlag = 0; 
			MachineSetupData.DistributorCtrl.OutSigStartDelayFlag = 0;
			MachineSetupData.DistributorCtrl.OutSigOnTime = Board100MSTmr;
		}
	}
	else
	{
		if(MachineSetupData.DistributorCtrl.OutSigState == OP_YU_CONTROL_ON)
		{
			if((Board100MSTmr - MachineSetupData.DistributorCtrl.OutSigOnTime) > (MachineSetupData.DistributorCtrl.OutSigOnTimeLength * 10))
			{
				PORT_ModifyOutPort(OP_YU_CONTROL, 0);
				MachineSetupData.DistributorCtrl.OutSigState = OP_YU_CONTROL_OFF;	
				InsCompleteForDistributorFlag = 0;
			}			
			else if((Board100MSTmr - MachineSetupData.DistributorCtrl.OutSigOnTime) < 0)
			{				
				MachineSetupData.DistributorCtrl.OutSigOnFlag = 1;					
			}
		}
	}	
}

void DistributorCheckInSig() 
{	
	if (PORT_ReadInPort(IP_DH_CONTROL) == 0)
	{
		if(MachineSetupData.DistributorCtrl.InSigOffFlag == 0)
		{
			MachineSetupData.DistributorCtrl.InSigOffTime = Board100MSTmr;
			MachineSetupData.DistributorCtrl.InSigOffFlag = 1;		
		}		
		else
		{
			if((Board100MSTmr - MachineSetupData.DistributorCtrl.InSigOffTime) > (MachineSetupData.DistributorCtrl.InSigOffTimeLength * 10))
			{
				//End Inspection
				//Error Distributor
				InspectionAlarmState.AlarmExist	= 1;
				InspectionAlarmState.DistributorDown	= 1;
				MachineSetupData.DistributorCtrl.InSigOffFlag = 0;
			}
			else if((Board100MSTmr - MachineSetupData.DistributorCtrl.InSigOffTime) < 0)
			{				
				MachineSetupData.DistributorCtrl.InSigOffFlag = 0;					
			}
		}
	}
	else
	{
		MachineSetupData.DistributorCtrl.InSigOffFlag = 0;
	}
}



 
