#ifndef _TABLET_CONTROL_H_
#define _TABLET_CONTROL_H_

#define TABLET_CONTROL_FUNC_NONE						0x00
#define TABLET_CONTROL_FUNC_CAPTURE						0x11
#define TABLET_CONTROL_FUNC_STUDY						0x12
#define TABLET_CONTROL_FUNC_INSPECTION					0x73
#define TABLET_CONTROL_FUNC_CHECK_INTERVAL				0x04
#define TABLET_CONTROL_FUNC_TABLET_COUNTER				0x65
#define TABLET_CONTROL_FUNC_EJECTOR_TEST				0x41

#define TABLET_CONTROL_FUNC_CAPTURE_REQUIRED			0x10
#define TABLET_CONTROL_FUNC_MATCHING_REQUIRED			0x20
#define TABLET_CONTROL_FUNC_EJECTION_REQUIRED			0x40

#define GRADIENT_CAPTURE_MODE	1
#define ENGRAVE_CAPTURE_MODE	2

//Distributor
#define OP_YU_CONTROL_ON	1
#define OP_YU_CONTROL_OFF	0
#define ENCODER_MASK									0x00FFFFFF

//#define	TABLET_SENSOR_LENGTH_PARAM					(1000 *	20 / (302 *	3.141592))
#define	SENSOR_OFF_STABLE_DELAY_50US				200			// 10ms
#define	TABLET_SENSOR_LIST_COUNT					256
#define	TABLET_SENSOR_LIST_MASK						255

#include "common.h"

typedef struct
{
	char BlindBlowOccurred;		// next 'normal' tablet have to blow up
	unsigned char Func;
	// sensor info
	int SensorState1;
	int SensorState2;
	int SensorState3;
	int LastSensor1OnTime;
	int LastSensor2OnTime;
	int InsertTabletListIndex;
	int InspectionID;
	int MachineStopMinimalTabletCount;
	int MaxSensorLength;
	int SensorIntervalA;	
	int SensorMinIntervalA;
	int SensorMaxIntervalA;
	int SensorIntervalB;
	int SensorMinIntervalB;
	int SensorMaxIntervalB;
	int CaptureIntDelay;
	unsigned int LaserTrgEncoderValue;
	int ExpectedSensor1Length;
	int ExpectedSensor2Length;
	int ExpectedSensor3Length;
	int SensorOffStableDelay;
	int IlluminatorDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int IlluminatorMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int TabletVarianceTime;
	int BlowerPadingDelay;
	int BlowerCheckingDelay;
	int DefectEjectorDelay;
	int UnInsEjectorDelay;
	int MinSensorLength;
	unsigned int LastTabletSensor2Time;
  	int Blowinterval;
	int Blowstart;
	int Blowlength;
	//Q 
	int GoodEjectorDelay;
	int TabletSideThick;
	int TabletSideThick_encoder;
	int DefectEjectorEncoderDelay;
	int UnInsEjectorEncoderDelay;
	int GoodEjectorEncoderDelay;
} TTabletControlData;

extern TTabletControlData TabletControlData;

typedef struct
{
	int Sensor1TabletNumberValid;
	int Sensor2TabletNumberValid;
	int Sensor1TabletNumber;
	int Sensor2TabletNumber;
	unsigned int Sensor1ActivateTime;
	unsigned int Sensor2ActivateTime;
} TTabletCaptureInformation;

typedef	struct
{
	unsigned int SensorOnTime;
	unsigned int SensorLength;
	int EncoderOnVaule;
	int EncoderLength;
	int MisFeeding;
	int SensorOffCount;
} TTabletSensorListUnit;

typedef	struct
{
	TTabletSensorListUnit List[TABLET_SENSOR_LIST_COUNT];
	int	Start;
	int	End;
} TTabletSensorQueue;

extern TTabletCaptureInformation TabletCaptureInformation;		// for mcbsp communication




extern TTabletInfo TabletInfo;
extern TTabletInspectInfo TabletInspectInfo;

extern TSPBProcessingResultData SPBProcessingResultData[SYSTEM_SPB_MAX_COUNT];

extern TInspectionResultTable InspectionResultTable;

extern THCBInspectionOption InspectionOption; //sjm

extern int MisEjectActFlag;
extern int MisEjectActTmr;

extern int MisEjectActSubFlag;
extern int MisEjectActSubTmr;

extern int DHoutputSignalTimeFlag;
extern int DHoutputDelayTimeFlag;
extern int DistributorDelayTimer;
extern int DistributorDelayFlag;

extern int	ConFlag;

extern int DHoutputDelayTimeFlag;
extern int DHoutputDelayTime;

extern int DHmachineOnTimeFlag;
extern int DHmachineOnTime;

extern int DHOPOntimeFlag;
extern int DHOPOntime;

extern int DHIPflag;
volatile extern int Disk1Encoder_value_sum;
volatile extern int Disk2Encoder_value_sum;

extern TTabletSensorQueue TabletSensorQueue[3];
extern TDistributorMonitor	DistributorMonitor;
extern TEncoderMonitor	EncoderMonitor;

//Q
extern int	MisEjectActTime;
extern int MisEjectUsalActTime;
void InitTabletTable(int startTabletNumber);
void SuctionDisk1LaserPrintProcess(void);
void TabletControl_Camera_Sensor1Off(void);
void TabletControl_Camera_Sensor2Off(void);
void DefaultDefectEjectorConfig(int index);
void DefaultUnInsEjectorConfig(int index);
void DefaultDistributorConfig(int index, int Company);
void DistributorOutSigCtrl();
void DistributorCheckInSig();
void ReadEncoderProcess();
#endif
