#include "timer.h"
//#include "kprint.h"
#include "hardware.h"
//#include "define.h"
#include "master.h"
#include "common.h"
#include "environment.h"
#include "system_setup.h"
#include "port.h"

#include "servo_motor.h"//add sjm
#include "tablet_control.h"
#include "machineControl.h"

#include <csl_chip.h>
#include <csl_tmr.h>
#include <csl_tmrAux.h>
#include <csl_intc.h>
#include <csl_intcAux.h>
#include <soc.h>

#define	TIMER_EVENT_TABLE_SIZE_1MS			4
#define	TIMER_EVENT_TABLE_SIZE_1S			4

#define	STATUSLIST_INTERVAL					80	//sjm chg For RunTime 120 => 80	==>	120(2016.11.14)	,	// 60 *	50us
unsigned int statusListInterval				= STATUSLIST_INTERVAL;

volatile unsigned int board50usTmr 			= 0;
unsigned int board1msCounter 				= 19;	// 20 -	1

volatile unsigned int Board1MSTmr 			= 0;
unsigned int Board20msCounter 				= 19;	//	20 - 1

unsigned int Board100msCounter 				= 99;	// 100 - 1
volatile unsigned int Board100MSTmr			= 0;
int	ResetSW	= 0;

int SafetyResetCount = 0;
int SafetyResetFlag = 0;
int ResetButtonChecker = 0;

unsigned int MCBSPTestSW = 0;
int	Timer0OverlapCount;
int	Timer1OverlapCount;
//int OnTimer0;
int	OnTimer50usProcess;
int	OnTimer1msProcess;
int	Timer1msEvent;
int	Timer1msEvent2;
int USBCommTimeout;
int SimulationInspectionSW = 0;
int LaserTriggerSW = 0;
int LaserTestMode = 0;
int SimulationInspectionPeriod = 0;
int SimultationStopWaiting = 0;
int Mcbsp_Start = 0;
unsigned int beforeIntTime1 = 0;
unsigned int beforeIntTime2 = 0;
unsigned int machineStatusUnCheckTime = 0;

void IsrTimer0(void);
//----------------------------------------------------------
void InitTimer(void)
{
	HARDWARE_InitializeTimer0();
//	OnTimer0 = 0;
	OnTimer50usProcess = 0;
	OnTimer1msProcess =	0;
	Timer0OverlapCount = 0;
	Timer1OverlapCount = 0;
	Timer1msEvent =	0;
	Board1MSTmr	= 0;
	Timer1msEvent2 = 0;
	MisEjectActFlag	= 0;  	  //sjm	Add
	MisEjectActTmr	= 0;	  //sjm	Add
	USBCommTimeout = 0;
}
//----------------------------------------------------------
void IsrTimer0(void)
{
	unsigned int irp=0, csr=0, ier=0; //iet1, iet2,	iemr, iemt;
	//int	motorIndex;//add sjm

	if (OnTimer50usProcess)
	{
		//if (!ResetSW) WHDOG	= 1;
		Timer0OverlapCount++;
		board50usTmr++;

		if (board1msCounter)
		{
			board1msCounter--;
		}
		else	// for each	1ms
		{
			Board1MSTmr++;
	 	 	board1msCounter	= 19;
			if (Board100msCounter)
			{
				Board100msCounter--;
			}
			else
			{
				Board100MSTmr++;
				Board100msCounter =	99;
			}

			if (Timer1msEvent)
			{
				Timer1OverlapCount++;
			}
			Timer1msEvent =	1;
	 	}

		if (statusListInterval)
		{
			statusListInterval--;
		}
		else
		{
			StatusListSW = 1;
			statusListInterval = (STATUSLIST_INTERVAL -	1);
		}
	}
	else
	{
//		HARDWARE_Lamp2Toggle();
//		if (!ResetSW) WHDOG	= 1;

		irp = CSL_chipReadReg(CSL_CHIP_IRP);
		csr = CSL_chipReadReg(CSL_CHIP_CSR);			
		ier = CSL_chipReadReg(CSL_CHIP_IER);
		CSL_chipWriteReg(CSL_CHIP_IER,ier|(0x1<<CSL_INTC_VECTID_5)|(0x1<<CSL_INTC_VECTID_8)|(0x1<<CSL_INTC_VECTID_9));
		CSL_chipWriteReg(CSL_CHIP_CSR,csr | 1);		
		board50usTmr++;

		if (board1msCounter)
		{
			board1msCounter--;
		}
		else	// for each	1ms
		{
			Board1MSTmr++;
			board1msCounter	= 19;
			if (Board100msCounter)
			{
				Board100msCounter--;
			}
			else
			{
				Board100MSTmr++;
				Board100msCounter =	99;
			}
			if (Timer1msEvent)
			{
				Timer1OverlapCount++;
			}
			Timer1msEvent =	1;
	 	}


		if (statusListInterval)
		{
			statusListInterval--;
		}
		else
		{
			StatusListSW = 1;
			statusListInterval = (STATUSLIST_INTERVAL -	1);
		}

		OnTimer50usProcess = 1;
		if(Mcbsp_Start)
		{
			MASTER_Process();
		}
		TabletControl_Process();
		HCB_Capture_Process_1ms();
		HCB_LEDControl_Process();
		HCB_TPB_Capture_Process();
		MC_50us_Process();
		Step_Motor_50us_Process();
		TabletControl_1ms_Process();
		PORT_Write_50us();
		PORT_Read();

		OnTimer50usProcess = 0;

		//1msec	 50	usec 	ű.
		if(MisEjectActFlag == 1)
		{
			MisEjectActTmr ++;
			//MisEjectInsActive();
			if(MisEjectActTmr >= MisEjectActTime && ConFlag == 1)	// 120000 (10 ̻) Է ؾ .
			{
				if(MachineSetupData.CompanyID != INTERNATIONAL_MACHINE1)
					MisEjectStop();
				ConFlag				= 0;
			}

			if(MisEjectActTmr >= (MisEjectActTime + 1500)) //13000	
			{
				//MisEjectInsStop();
				MisEjectActFlag		= 0;
				MisEjectActTmr 		= 0;
			}

			MisEjectActSubTmr = 0;
			
		}else if(MisEjectActFlag ==	0)
		{
			MisEjectActTmr = 0;

			if(MisEjectActSubFlag == 1)
			{
				MisEjectActSubTmr ++;
				if(MisEjectActSubTmr >= MisEjectUsalActTime)  // 50usec 1S = 20000
				{
					MisEjectActive();

					MisEjectActSubFlag = 0;
					MisEjectActSubTmr = 0;	
				}
			}
			else if(MisEjectActSubFlag == 2)
			{
				MisEjectActSubTmr ++;
				if(MisEjectActSubTmr >= MisEjectUsalActTime)  // 50usec 1S = 20000
				{
					MisEjectActSubFlag = 0;
					MisEjectActSubTmr = 0;	
				}
			}
			else if(MisEjectActSubFlag == 0)
			{
				MisEjectActSubTmr = 0;
			}
		}
		

		if (Timer1msEvent2	== 1)
		{
			Timer1msEvent2 = 0;
		}
		if (OnTimer1msProcess == 0 && Timer1msEvent	!= 0)
		{
			OnTimer1msProcess =	1;
			Timer1msEvent =	0;

			Encoder_Read();
			PORT_Write();
			MC_TimerProcess();
			MC_Test_Process_1ms();
			
//			TabletControl_1ms_Process();

			if(!SimulationInspectionSW)
			{
				Step_Motor_1ms_Process();
				Servo_Motor_Process_1ms();
			}
			///// DaeHwa /////
			if(DHoutputDelayTimeFlag)
			{
				DHoutputDelayTime++;
				if(DHoutputDelayTime > 5000) /// δ 10~20   
				{
					DHoutputDelayTimeFlag   = 0;
					DHoutputDelayTime       = 0;
					DHoutputSignalTimeFlag  = 1;
				}
			}
			
			if(DHOPOntimeFlag)
			{
				DHOPOntime++;
			}
            //.
			if(DistributorDelayFlag == 1)
				DistributorDelayTimer++;

			if (Board20msCounter ==	0)
			{
				Servo_Motor_Process_20ms();
				Board20msCounter = 19;
			}
			else
			{
				if (Board20msCounter ==	8)
				{
					ME_Process_20ms();
				}
				else if	(Board20msCounter == 16)
				{
					HCB_System_Process_20ms();
				}
				Board20msCounter--;
			}

			if(SafetyResetFlag)
			{
				if(SafetyResetCount >= 100)
				{
					PORT_ModifyOutPort(OP_SAFETY_CIRCUIT_RESET, 0);
					SafetyResetCount = 0;
					SafetyResetFlag = 0;
				}

				SafetyResetCount++;
			}

			OnTimer1msProcess =	0;
		}

		CSL_chipWriteReg(CSL_CHIP_CSR,csr &(~1));
		CSL_chipWriteReg(CSL_CHIP_CSR,csr);	
		CSL_chipWriteReg(CSL_CHIP_IRP,irp);
		CSL_chipWriteReg(CSL_CHIP_IER,ier);
	}
	
}
//----------------------------------------------------------
void Sleep(int miliSeconds)
{
	unsigned int st;
	st = Board1MSTmr;
	while(1)
	{
		if (Board1MSTmr	- st > miliSeconds)
		{
			break;
		}
	}
}
//----------------------------------------------------------

