; ************************************************************************ 
; Global symbols referenced in this file but defined somewhere else.
; Remember that your interrupt service routines need to be referenced here.
; ************************************************************************ 

		.global _vectors
		.global _IsrUSBSlave
		.global _edmaIsr
		.global _IsrMcbspRxMaster
		.global _IsrMcbspTxMaster
		.global _IsrTimer0
		.global _IsrRS485RxMaster
		.global _IsrRS485TxMaster
		.global _boot_start

; ************************************************************************ 
; This is a mcros that instantiates one entry in the inetrrupt service table.
; ************************************************************************ 

VEC_ENTRY .macro addr
  STW 	B0,*--B15
  MVKL 	addr,B0
  MVKH 	addr,B0
  B 	B0
  LDW 	*B15++,B0
  NOP 	2
  NOP
  NOP
  .endm
  
; ************************************************************************ 
; This is a dummy interrupt service routine used to initialize the IST.
; ************************************************************************ 

_vec_dummy:
  B 	B3
  NOP 	5
  
; ************************************************************************ 
; This is the actual interrupt service table (IST). It is properly aligned and
; is located in the subsection .text:vecs. This means if you don't explicitly
; specify this section in your linker command file, it will default and link 
; into the .text section. Remember to set the ISTP register to point to this 
; table. 
; ************************************************************************ 

		.sect ".vectors"
		.align 1024

_vectors:  
_vector0:  
		MVKL	.S2	_boot_start, B0
		MVKH	.S2 _boot_start, B0
		B		.S2	B0
		nop
		nop
		nop
		nop
		nop

_vector1: VEC_ENTRY _vec_dummy
_vector2: VEC_ENTRY _vec_dummy
_vector3: VEC_ENTRY _vec_dummy
_vector4: VEC_ENTRY _vec_dummy
_vector5: VEC_ENTRY _vec_dummy
_vector6: VEC_ENTRY _IsrMcbspRxMaster
_vector7: VEC_ENTRY _IsrMcbspTxMaster
_vector8: VEC_ENTRY _IsrTimer0
_vector9: VEC_ENTRY _IsrUSBSlave
_vector10: VEC_ENTRY _edmaIsr
_vector11: VEC_ENTRY _IsrRS485RxMaster
_vector12: VEC_ENTRY _IsrRS485TxMaster
_vector13: VEC_ENTRY _vec_dummy
_vector14: VEC_ENTRY _vec_dummy
_vector15: VEC_ENTRY _vec_dummy

; ************************************************************************ 
; *******************************End of vecs.asm**************************
; ************************************************************************ 