//---------------------------------------------------------------------------

#ifndef Main_FormH
#define Main_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include "common.h"
#include "Environment.h"
#include <Graphics.hpp>
#include <ComCtrls.hpp> //sjm add

#include<iostream>
#include <string>
#include<map.h>
using namespace std;
#include <vector>
#include <fstream>
#include <time.h>

#define MAIN_MENU_BUTTON_COUNT  18
#define CAPTURE_WAITING_TIME  500

#define MAX_SIDE_WALL_EDGE_DATA_COUNT  200
#define MAX_SIDE_BOTTOM_EDGE_DATA_COUNT  520
#define MAX_SAMPLING_DATA_COUNT  75
#define MAX_SIDE_EDGE_CAMERA_COUNT  12

//---------------------------------------------------------------------------
typedef struct
{
	bool HCBNotConnected;
	bool SPB1NotConnected;
	bool SPB2NotConnected;
	bool SPB3NotConnected;
	bool SPB4NotConnected;
  bool SPB5NotConnected;
  bool SPB6NotConnected;

  bool SPB7NotConnected;
  bool SPB8NotConnected;  	
	bool RegulatorError;
	bool EmergencyOn;
	bool Inverter1Trip;
	bool Inverter2Trip;
  bool Inverter3Trip;
	bool Disk1SuctionLow;
	bool Disk2SuctionLow;
	bool ServoAlarm;
	bool Interlock;
	bool Disk1Stall;
	bool Disk2Stall;
	bool GPFull;
	bool DPFull;
	bool UPFull;
	bool DPRatioOver;
	bool UPRatioOver;
  bool CritDPRatioOver;
	bool CritUPRatioOver;
	bool Sensor1Error;
	bool Sensor2Error;
	bool BrightnessDown;
  bool StepMotorStall[MAX_STEP_MOTOR_COUNT];
  bool TemperatureOver[SYSTEM_MAX_THERMOMETER_COUNT];
	char mes_status;
	char Qjp_object_status;
	char upstream_status;
	char downstream_status;
	char laser_emergency;	
  bool TotalFull;
  bool CheckMisEjector;
  bool MisEjectFull;
  bool EmissionSensorOn;
} TPCAlarmState;
//------------------------------QDLL---------------------------------------------
typedef bool(*OBJ_INIT)(void);
typedef void(*OBJ_TERM)(void);
typedef void(*OBJ_GETPORTTYPE)(void);
typedef void(*OBJ_SETINPORT)(unsigned short);
typedef unsigned short(*OBJ_GETOUTPORT)(void);
typedef void(*OBJ_SETSTATUS)(unsigned short);
typedef unsigned short(*OBJ_GETCOMMAND)(void);
typedef void(*OBJ_SETPRODUCTINFO)(eProductInfo *);
typedef void(*OBJ_SETPARAMINFO)(eParamInfo *);
typedef void(*OBJ_SETALARMINFO)(eAlarmInfo *);
typedef unsigned short(*OBJ_GETOBJSTATUS)(void);
typedef void(*OBJ_ERRORRESET)(unsigned short);
typedef void(*OBJ_SEQCLEAR)(unsigned short);
typedef void(*OBJ_SETEXECOMMAND)(unsigned short);
//---------------------------------------------------------------------------

//-------------------------------AMTec DLL---------------------------------

typedef struct
{
	unsigned int SuctionDiskSpeed;			//(50~170%)  
	unsigned int bowl_feeder_in_speed;		//(50~170%)  
	unsigned int bowl_feeder_out_speed;		//(50~170%)  
} TDiskSpeedInfo;

// DLL Ʈ  
typedef unsigned int (*LASER_OBJ_INIT)(void);
typedef void(*LASER_OBJ_TERM)(void);
typedef void(*LASER_OBJ_RESET)(void);
typedef void(*LASER_Obj_RESETCOUNT)(void);
typedef unsigned int(*LASER_OBJ_GETOBJSTATUS)(void);

// Command  Լ 
typedef void(*LASER_OBJ_SETOBJCOMMAND)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETOBJCOMMAND)(void);

//LASER  Լ 
typedef void(*LASER_OBJ_SETLASERSTATUS)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETLASERSTATUS)(void);
typedef void(*LASER_OBJ_SETLASERCOUNT)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETLASERCOUNT)(void);
typedef void(*LASER_OBJ_SETPRODUCTNAME)(char *);
typedef void(*LASER_OBJ_SETLASERINFO)(TLaserInfo *);
typedef TLaserInfo*(*LASER_OBJ_GETLASERINFO)(void);
typedef void(*LASER_OBJ_SETLASERERROR)(char *);
typedef unsigned int(*LASER_OBJ_GETLASERERROR)(void);
typedef void(*LASER_OBJ_SETLASERRECIPENAME)(char *);
typedef char*(*LASER_OBJ_GETLASERRECIPENAME)(void);

//Machine  Լ 
typedef void(*LASER_OBJ_SETMACHINESTATUS)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETMACHINESTATUS)(void);
typedef void(*LASER_OBJ_SETMACHINECOUNT)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETMACHINECOUNT)(void);
typedef char*(*LASER_OBJ_GETPRODUCTNAME)(void);

typedef void(*LASER_OBJ_SETMACHINEUISTATUS)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETMACHINEUISTATUS)(void);
typedef void(*LASER_OBJ_SETMACHINEDISKSPEED)(TDiskSpeedInfo*);
typedef TDiskSpeedInfo* (*LASER_OBJ_GETMACHINEDISKSPEED)(void);

typedef void(*LASER_OBJ_SETLASERMACHINESTATUS)(unsigned int);
typedef unsigned int(*LASER_OBJ_GETLASERMACHINESTATUS)(void);
typedef unsigned int(*LASER_OBJ_GETLASERMARKTIME)(void);

LASER_OBJ_INIT Laser_obj_Init;
LASER_OBJ_TERM Laser_obj_Termnate;
LASER_OBJ_RESET Laser_obj_Reset;
LASER_Obj_RESETCOUNT Laser_obj_ResetCount;
LASER_OBJ_GETOBJSTATUS Laser_obj_GetObjStatus;

LASER_OBJ_SETOBJCOMMAND Laser_obj_SetObjCommand;
LASER_OBJ_GETOBJCOMMAND Laser_obj_GetObjCommand;

LASER_OBJ_SETLASERSTATUS Laser_obj_SetLaserStatus;
LASER_OBJ_GETLASERSTATUS Laser_obj_GetLaserStatus;
LASER_OBJ_SETLASERCOUNT Laser_obj_SetLaserCount;
LASER_OBJ_GETLASERCOUNT Laser_obj_GetLaserCount;
LASER_OBJ_SETPRODUCTNAME Laser_obj_SetProductName;
LASER_OBJ_SETLASERINFO Laser_obj_SetLaserInfo;
LASER_OBJ_GETLASERINFO Laser_obj_GetLaserInfo;
LASER_OBJ_SETLASERERROR Laser_obj_SetLaserError;
LASER_OBJ_GETLASERERROR Laser_obj_GetLaserError;
LASER_OBJ_SETLASERRECIPENAME Laser_obj_SetLaserRecipeName;
LASER_OBJ_GETLASERRECIPENAME Laser_obj_GetLaserRecipeName;

LASER_OBJ_SETLASERMACHINESTATUS Laser_obj_SetLaserMachineStatus;
LASER_OBJ_GETLASERMACHINESTATUS Laser_obj_GetLaserMachineStatus;

LASER_OBJ_SETMACHINESTATUS Laser_obj_SetMachineStatus;
LASER_OBJ_GETMACHINESTATUS Laser_obj_GetMachineStatus;
LASER_OBJ_SETMACHINECOUNT Laser_obj_SetMachineCount;
LASER_OBJ_GETMACHINECOUNT Laser_obj_GetMachineCount;
LASER_OBJ_GETPRODUCTNAME Laser_obj_GetProductName;

LASER_OBJ_SETMACHINEUISTATUS Laser_obj_SetMachineUIStatus;
LASER_OBJ_GETMACHINEUISTATUS Laser_obj_GetMachineUIStatus;
LASER_OBJ_SETMACHINEDISKSPEED Laser_obj_SetMachineDiskSpeed;
LASER_OBJ_GETMACHINEDISKSPEED Laser_obj_GetMachineDiskSpeed;

LASER_OBJ_GETLASERMARKTIME Laser_obj_GetLaserMarkTime;

//---------------------------------------------------------------------------



class TMainForm : public TTntForm
{
__published:	// IDE-managed Components
	TTimer *StatusTimer;
	TTntPanel *Panel3;
	TTntLabel *Label1;
	TTntLabel *ProductNameLabel;
	TTntLabel *Label3;
	TTntLabel *LOTNameLabel;
	TMainMenu *MainMenu1;
	TMenuItem *ErrorMenuItem;
	TMenuItem *N1;
	TTntPanel *LeftMenuPanel;
	TTntButton *TabletInfoButton;
	TTntButton *MachineSetupButton;
	TTntButton *CalibrationButton;
	TTntButton *ExtractCharacterButton;
	TTntButton *StudyButton;
	TTntButton *InspectionButton;
	TTntButton *LogOutButton;
	TTntPanel *TopStatusPanel;
	TTntPanel *RightMenuPanel;
	TTntButton *MachineTestButton;
	TTntButton *SystemSettingButton;
	TTntButton *UserRegisterButton;
	TTntLabel *UserInfoLabel;
	TTntPanel *ClientPanel;
	TTntLabel *Label5;
	TTntLabel *MachineStatusLabel;
	TTntButton *FirstStudyButton;
	TTntButton *MachineControlButton;
	TTntButton *EnvironmentSettingButton;
	TTntButton *InspectionReportButton;
	TTntButton *AuditTrailButton;
	TTimer *ActivityCheckTimer;
  TImage *Image1;
  TTntButton *CleaningButton;
  TTntButton *ReadyButton;
  TTntButton *CloseButton;
  TTimer *KeyboardStatusCheckTimer;
        TTntLabel *StorageLabel;
        TTntLabel *DiscSpaceLabel;
  TPanel *SimulationButton;
  TPanel *Panel1;
  TButton *DllInitButton;
  TTimer *AcroCiaDllTimer;
  TTimer *AMTecDllTimer;
  TTntPanel *LaserStatusPanel;
  TTntPanel *LaserPreparingStatusPanel;
  TTntPanel *LaserPauseStatusPanel;
  TTntPanel *LaserReadyStatusPanel;
  TTntPanel *TntPanel5;
  TTntPanel *LaserInactiveBtnPanel;
  TTntPanel *LaserActiveBtnPanel;
  TTimer *ThreeDSensorControlTimer;
  TButton *ShowThreeDSensorStatusBtn;
  TTntLabel *SystemInfoLabel;
  TTntLabel *SystemInfo;
  TButton *makePID15Btn;
  TButton *makePID20Btn;
  TTntLabel *Label11;
  TTntLabel *TimeLabel;
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall LogOutButtonClick(TObject *Sender);
	void __fastcall TabletInfoButtonClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall StatusTimerTimer(TObject *Sender);
	void __fastcall SystemSettingButtonClick(TObject *Sender);
	void __fastcall MachineSetupButtonClick(TObject *Sender);
	void __fastcall CalibrationButtonClick(TObject *Sender);
	void __fastcall InspectionButtonClick(TObject *Sender);
	void __fastcall MachineTestButtonClick(TObject *Sender);
	void __fastcall ErrorMenuItemClick(TObject *Sender);
	void __fastcall StudyButtonClick(TObject *Sender);
	void __fastcall ExtractCharacterButtonClick(TObject *Sender);
	void __fastcall FormActivate(TObject *Sender);
	void __fastcall CleaningButtonClick(TObject *Sender);
	void __fastcall ReadyButtonClick(TObject *Sender);
	void __fastcall AlarmPanelClick(TObject *Sender);
	void __fastcall FirstStudyButtonClick(TObject *Sender);
	void __fastcall UserRegisterButtonClick(TObject *Sender);
	void __fastcall MachineControlButtonClick(TObject *Sender);
	void __fastcall ClientPanelDblClick(TObject *Sender);
	void __fastcall InspectionReportButtonClick(TObject *Sender);
	void __fastcall EnvironmentSettingButtonClick(TObject *Sender);
	void __fastcall AuditTrailButtonClick(TObject *Sender);
	void __fastcall ActivityCheckTimerTimer(TObject *Sender);
  void __fastcall KeyboardStatusCheckTimerTimer(TObject *Sender);
  void __fastcall SimulationButtonDblClick(TObject *Sender);
  void __fastcall Panel1DblClick(TObject *Sender);
  void __fastcall PIO05PortStatusCheck(); // ܼ Ŭ  ̴ϼ 
  void __fastcall MakeMESUpdateData();
  void __fastcall DllInitButtonClick(TObject *Sender);
  void __fastcall AcroCiaDllTimerTimer(TObject *Sender);
  void __fastcall AMTecDllTimerTimer(TObject *Sender);
  void __fastcall LaserInactiveBtnPanelClick(TObject *Sender);
  void __fastcall ThreeDSensorControlTimerTimer(TObject *Sender);
  void __fastcall ShowThreeDSensorStatusBtnClick(TObject *Sender);
  void __fastcall TntFormShow(TObject *Sender);
  void __fastcall makePID15BtnClick(TObject *Sender);
  void __fastcall makePID20BtnClick(TObject *Sender);
private:	// User declarations
        TTntForm *ActiveSubForm;
	bool MachineSetupComplete;
	TPCAlarmState OldAlarmState;
  TSPBFPGAVersion MSPBFPGAVersion[SYSTEM_SPB_MAX_COUNT]; //sjm add 
	bool quickStartActivated;
  bool alarmActivated;
	int quickStartOption;
  bool bSPBSystemValid[SYSTEM_SPB_MAX_COUNT];

  bool prevMainMenuBtnState[MAIN_MENU_BUTTON_COUNT];

	void __fastcall RefreshMenu(void);
	void __fastcall DeleteActiveSubMenu(void);
	void __fastcall RefreshProductInfo(void);
	void __fastcall RequestLogIn(void);
  void __fastcall GetDefalutString();
  void __fastcall SetDefaultCameraGain();
  void __fastcall RefreshCameraInfo(int cameraIndex);
  void __fastcall MainMenuBtnLockControl(bool bLock);
  void __fastcall CheckSystemCompatibility(void);

  void __fastcall BackupIniFiles();

  int LastSafetyMode;
  bool LastHeaveyAlarmState;

public:		// User declarations
  __fastcall TMainForm(TComponent* Owner);
  bool BlackOutFlag;
  int IP_ConnectCheckTimer;
  bool InspectFormStatus;
  bool MachineOffFlag;
  
  int __fastcall GetLastSafetyMode();
  void __fastcall SetLastSafetyMode(int newSafeMode);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
extern TUVLaserStatus UVLaser;
//---------------------------------------------------------------------------
#endif
