//---------------------------------------------------------------------------
#ifndef CPBTuning_FormH
#define CPBTuning_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>

#include "Processing.h"
#include <Grids.hpp>
#include "TntForms.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
//---------------------------------------------------------------------------
class TCPBTuningForm : public TTntForm
{
__published:	// IDE-managed Components
    TTntImage *SrcImage;
    TTntGroupBox *GroupBox1;
    TTntEdit *SPBIndexEdit;
    TTntLabel *Label1;
    TTntEdit *CPBIndexEdit;
    TTntLabel *Label2;
    TTntButton *SPBInspectionSetupButton;
    TTntLabel *Label3;
    TTntEdit *ImagePathEdit;
    TTntButton *FindImageFolderButton;
    TTntEdit *ImageIndexEdit;
    TTntLabel *Label4;
    TTntLabel *Label5;
    TTntEdit *CameraIndexEdit;
    TTntButton *SPBVirtualInspectionButton;
    TTntButton *LoadImageButton;
    TTntImage *DestImage;
    TTntGroupBox *GroupBox2;
    TTntButton *ReadProcessingInfoButton;
    TTntButton *CPBSystemSetupButton;
    TTntStringGrid *ProcessingInfoStringGrid;
    TTntButton *ReadDataButton1;
    TTntButton *ReadDataButton2;
    void __fastcall SPBInspectionSetupButtonClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall FindImageFolderButtonClick(TObject *Sender);
    void __fastcall LoadImageButtonClick(TObject *Sender);
    void __fastcall SPBVirtualInspectionButtonClick(TObject *Sender);
    void __fastcall CPBSystemSetupButtonClick(TObject *Sender);
	void __fastcall ReadProcessingInfoButtonClick(TObject *Sender);
    void __fastcall ReadDataButton1Click(TObject *Sender);
    void __fastcall ReadDataButton2Click(TObject *Sender);
private:	// User declarations
	TTabletSetupData tabletSetupData;
	unsigned char BayerImage[CAPTURE_WIDTH * CAPTURE_HEIGHT];
    unsigned char CPBImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT * 5];
    
    bool __fastcall ReadSetupData(TTabletSetupData *tabletSetupData);
    bool __fastcall ReadStudyData(TTabletStudyData *tabletStudyData);
    void __fastcall ImageLoad(int imageIndex, int cameraIndex);
public:		// User declarations
    __fastcall TCPBTuningForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TCPBTuningForm *CPBTuningForm;
//---------------------------------------------------------------------------
#endif
