
//---------------------------------------------------------------------------

#include <vcl.h>
#include "MultiLanguage.h"
#include "Environment.h"
#pragma hdrstop
int LoadFileFlag = 0;
//---------------------------------------------------------------------------
USEFORM("Main_Form.cpp", MainForm);
USEFORM("..\Common_PC\ProductInput_Form.cpp", ProductInputForm);
USEFORM("..\Common_PC\Message_Form.cpp", MessageForm);
USEFORM("..\Common_PC\ProductSearch_Form.cpp", ProductSearchForm);
USEFORM("..\Common_PC\SetPath_Form.cpp", SetPathForm);
USEFORM("TabletSimulation_Form.cpp", TabletSimulationForm);
USEFORM("..\Common_PC\Keyboard_Form.cpp", KeyboardForm);
USEFORM("..\Common_PC\InputText_Dialog.cpp", InputTextDialog);
USEFORM("..\Common_PC\ColorCode_Form.cpp", ColorCodeForm);
USEFORM("..\Common_PC\GradeSetting.cpp", GradeSettingForm);
USEFORM("CPBTuning_Form.cpp", CPBTuningForm);
USEFORM("..\Common_PC\CommControl_Form.cpp", CommControlForm);
USEFORM("..\Common_PC\USBMessage_Form.cpp", USBMessageForm);
USEFORM("..\Common_PC\LogIn_Form.cpp", LogInForm);
USEFORM("..\Common_PC\UserRegister_Form.cpp", UserRegisterForm);
USEFORM("..\Common_PC\VirtualMachine_Form.cpp", VirtualMachineForm);
USEFORM("..\Common_PC\Virtual_CPB_Form.cpp", VirtualCPBForm);
USEFORM("..\Common_PC\Virtual_SPB_Form.cpp", VirtualSPBForm);
USEFORM("..\Common_PC\VirtualImageControl_Form.cpp", VirtualImageControlForm);
USEFORM("..\Common_PC\Setup_Form.cpp", SetupForm);
USEFORM("SecStudy_Form.cpp", SecondStudyFom);
USEFORM("..\Common_PC\Waiting_Form.cpp", WaitingForm); /* TTntForm: File Type */
USEFORM("..\Common_PC\RealSizeImage_Form.cpp", RealSizeImageForm); /* TTntForm: File Type */
USEFORM("..\Common_PC\Camera_Interface\InspectionSetup_Form.cpp", InspectionSetupForm); /* TTntForm: File Type */
USEFORM("..\Common_PC\Camera_Interface\First_Study.cpp", FirstStudy); /* TTntForm: File Type */
USEFORM("..\Common_PC\Camera_Interface\TabletCharacterExtract.cpp", TabletCharacterExtractForm); /* TTntForm: File Type */
USEFORM("..\Common_PC\ThreeDPrintMask_Form.cpp", ThreeDPrintMaskForm);
USEFORM("..\Common_PC\Camera_Interface\InspectionAreaRevision_Form.cpp", InspectionAreaRevisionForm); /* TTntForm: File Type */
USEFORM("..\Common_PC\Camera_Interface\PreviewInspection_Form.cpp", PreviewInspectionForm);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	try
	{
    AnsiString RootPath;
    RootPath = ExtractFileDir(Application->ExeName);

    if(!LoadFromFile(RootPath + "\\TLanguage.dat"))
    {
      ShowMessage("Cannot read Language.dat");
    }
    else
    {
      LoadFileFlag = 1;
      SetDefaultLocaleInfo();
      GetStringData();
      Free_StringStruct();
      LoadFileFlag = 0;
    }

    GlobalProgramID = PROGRAM_ID_200;//PROGRAM_ID_150P;//PROGRAM_ID_200;//
    
		Application->Initialize();
		Application->CreateForm(__classid(TMainForm), &MainForm);
     Application->CreateForm(__classid(TKeyboardForm), &KeyboardForm);
     Application->CreateForm(__classid(TWaitingForm), &WaitingForm);
     Application->CreateForm(__classid(TRealSizeImageForm), &RealSizeImageForm);
     Application->CreateForm(__classid(TTabletSimulationForm), &TabletSimulationForm);
     Application->Run();
    
	}
	catch (Exception &exception)
	{
		Application->ShowException(&exception);
	}
	catch (...)
	{
		try
		{
			throw Exception("");
		}
		catch (Exception &exception)
		{
			Application->ShowException(&exception);
		}
	}
  if(LoadFileFlag)
    Free_StringStruct();
	return 0;
}
//---------------------------------------------------------------------------



