//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SecStudy_Form.h"
#include "Environment.h"
#include "Common_PC.h"
#include "inifiles.hpp"
#include <FileCtrl.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TSecondStudyFom *SecondStudyFom;
//---------------------------------------------------------------------------
__fastcall TSecondStudyFom::TSecondStudyFom(TComponent* Owner)
  : TForm(Owner)
{
#ifdef PC_SIM
	ShowHintByName(this);
#endif
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::Button1Click(TObject *Sender)
{
  AnsiString Dir = ImgPath->Text;
  if (SelectDirectory(Dir, TSelectDirOpts(), 0 ))
  {
    ImgPath->Text = Dir;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::DoProcessing(int imageCount, int cameraIndex)
{
  int InspectionOrStudy = STUDY_MODE;
  int InspectionKind;
  
  ImageLoad(imageCount, cameraIndex);

  switch(cameraIndex)
  {
    case SD1_2D_FRONT_FACE_CAMERA_INDEX:
    case SD2_2D_FRONT_FACE_CAMERA_INDEX:
      InspectionKind = FRONT_FACE;
      ProcessingStartForFrontFace(InspectionOrStudy, cameraIndex, 0);
      break;
    case SD1_3D_FRONT_FACE_CAMERA_INDEX:
    case SD2_3D_FRONT_FACE_CAMERA_INDEX:
      InspectionKind = FRONT_FACE_SPECIAL;
      ProcessingStartForFrontFace_3D(InspectionOrStudy, cameraIndex, 0x01);
      break;
    case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
    case SD2_2D_SIDE_FACE_P45_CAMERA_INDEX:
    case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
    case SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
			InspectionKind = SIDE_FACE_P45;
      ProcessingStartForSideFace_P45(InspectionOrStudy, cameraIndex, 0);
			break;
    case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
    case SD2_2D_SIDE_FACE_00_CAMERA_INDEX:
    case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
    case SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
			InspectionKind = SIDE_FACE_0;
      ProcessingStartForSideFace_0(InspectionOrStudy, cameraIndex, 0);
			break;
		case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
    case SD2_2D_SIDE_FACE_M45_CAMERA_INDEX:
    case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
    case SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
			InspectionKind = SIDE_FACE_M45;
      ProcessingStartForSideFace_M45(InspectionOrStudy, cameraIndex, 0);
			break;
  }

  int x, y;
  Graphics::TBitmap *img1;
  img1 = new Graphics::TBitmap();
  img1->Width = 640;
  img1->Height = 480;
  img1->PixelFormat = pf24bit;
                              
  Byte *ptr;
  for(y = 0 ; y < MAX_IMAGE_HEIGHT; y++)
  {
    ptr = (byte*) img1->ScanLine[y];
    for(x = 0; x < MAX_IMAGE_WIDTH; x++)
    {
        ptr[3*x+0] = ColorSourceImage[(640 * y + x) * 3 + 0];
        ptr[3*x+1] = ColorSourceImage[(640 * y + x) * 3 + 1];
        ptr[3*x+2] = ColorSourceImage[(640 * y + x) * 3 + 2];
    }
  }
  Image1->Picture->Bitmap->Assign(img1);
  Image1->Refresh();
  delete(img1);
}


//---------------------------------------------------------------------------
bool __fastcall TSecondStudyFom::ReadSetupData(TTabletSetupData *tabletSetupData)
{
    AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt";
    if (FileExists(setupDataFileName))
    {
        TFileStream *fileStream  = new TFileStream(setupDataFileName, fmOpenRead);
        if (fileStream)
        {
    	    fileStream->Read(tabletSetupData, sizeof(TTabletSetupData));
    	    delete fileStream;
            return true;
        }
        else
        {
    		return false;
        }
    }
    else
    {
        return false;
    }
}
//---------------------------------------------------------------------------

void __fastcall TSecondStudyFom::ImageLoad(int imageIndex, int cameraIndex)
{
  int x,y;
  int selectedImageNumber;
  selectedImageNumber = imageIndex;
  Graphics::TBitmap *img1;
  img1 = new Graphics::TBitmap();
  Graphics::TBitmap *img2;
  img2 = new Graphics::TBitmap();
  AnsiString fileName;
  fileName = ImgPath->Text + "\\Image" + IntToStr(selectedImageNumber) + "_" + IntToStr(cameraIndex) + ".bmp";

  if(cameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX && cameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX)
  {
    ExtractBayerImage(BayerImage, selectedImageNumber, cameraIndex);
  }
  else
  {
    if (ExtractImage(img1, selectedImageNumber, cameraIndex, TabletSetupData.ImageOffSetSW[cameraIndex - 1], TabletSetupData.referenceImageForOffset[cameraIndex - 1], ProductData.SubSamplingMode))
    {
      img2->Assign(img1);
      img2->Width = img1->Width*2;

			Byte *ptr;
			Byte *tr;
			ExtractBayerImage(BayerImage, selectedImageNumber, cameraIndex);

      for(y = 0 ; y < MAX_IMAGE_HEIGHT; y++)
      {
          ptr = (byte*) img1->ScanLine[y];
          tr = (byte*) img2->ScanLine[y];
          for(x = 0; x < img1->Width*2; x++)
          {
              tr[x] = ptr[x/2];
          }
      }
      Image1->Picture->Bitmap->Assign(img2);
      Image1->Refresh();

      delete(img1);
      delete(img2);
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TSecondStudyFom::Read3DSetupData(TTablet3DSetupData *tablet3DSetupData)
{
	AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt_3D";
    if (FileExists(setupDataFileName))
    {
        TFileStream *fileStream  = new TFileStream(setupDataFileName, fmOpenRead);
        if (fileStream)
        {
    	    fileStream->Read(tablet3DSetupData, sizeof(TTablet3DSetupData));
    	    delete fileStream;
            return true;
        }
        else
        {
    		return false;
        }
    }
    else
    {
        return false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::StudyStartClick(TObject *Sender)
{
  ReadCameraMapData(ProgramPath.Env + "\\SystemInfor.ini", CameraMapInfo);

  int StudyCount;
  StudyCount = StrToInt(Edit1->Text);

  memset(AccStudyData, 0, sizeof(TStudyResultData_SPB) * 4);

  if(StudyCount >= 1 && StudyCount <= 100)
  {
    ProgressBar1->Position = 0;

    for(int cameraIndex = 1; cameraIndex <= SYSTEM_TOTAL_CAMERA_COUNT; cameraIndex++)
    {
      ProgressBar1->Position++;
      Application->ProcessMessages();

      Setup(cameraIndex);

      for(int StdIndex = 1; StdIndex <= StudyCount; StdIndex++)
      {
        if(CameraMapInfo[cameraIndex - 1].CameraInspectPosition != CAMERA_POSITION_DISCONNECT)
        {
          DoProcessing(StdIndex, cameraIndex);
          ProcessingResultAccumulation(cameraIndex - 1);
        }
      }
    }
    StudyResultDisplay();

    ShowMessage("нϷ");
    
    ProgressBar1->Position = 0;
  }
  else
  {
    ShowMessage(" ʰ");
  }
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::SaveImageFilePath()
{
  AnsiString ROOT;
  ROOT = ExtractFileDir(Application->ExeName);

  AnsiString FileName;
  FileName = ROOT + "\\ImagePath.ini";

  TIniFile *inifiles = new TIniFile(FileName);

  if(inifiles)
  {
    inifiles->WriteString("PATH", "PATH", ImgPath->Text);
  }
  
  delete inifiles;
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::LoadImageFilePath()
{
  AnsiString ROOT;
  ROOT = ExtractFileDir(Application->ExeName);

  AnsiString FileName;
  FileName = ROOT + "\\ImagePath.ini";

  TIniFile *inifiles = new TIniFile(FileName);

  if(inifiles)
  {
    ImgPath->Text = inifiles->ReadString("PATH", "PATH", "");
  }
  
  delete inifiles;
}
//---------------------------------------------------------------------------

void __fastcall TSecondStudyFom::FormCreate(TObject *Sender)
{
  this->DoubleBuffered = true;
  LoadImageFilePath();

  if (!ReadSetupData(&TabletSetupData))
  {
    ShowMessageW("Setup Data  о  ϴ.");
  }

  MakeTabletCharacterData(&ProductData, &TabletCharacter, &MachineParams);

  // CPB Data Initial
  CPBCommonVariableInitial();
 
  SideFaceSetUpDataTransForm_For_PCSIM(tempSideData);
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  SaveImageFilePath();  
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::ProcessingResultAccumulation(int globalCamIndex)
{
  int dataIntegrity = 1;

  globalCamIndex = globalCamIndex + 1;

	if (globalCamIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
	{
		if (TabletStudyData.tabletColorB_ForCamera1 < 0 || TabletStudyData.tabletColorB_ForCamera1 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletColorG_ForCamera1 < 0 || TabletStudyData.tabletColorG_ForCamera1 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletColorR_ForCamera1 < 0 || TabletStudyData.tabletColorR_ForCamera1 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletRearColorB_ForCamera1 < 0 || TabletStudyData.tabletRearColorB_ForCamera1 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletRearColorG_ForCamera1 < 0 || TabletStudyData.tabletRearColorG_ForCamera1 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletRearColorR_ForCamera1 < 0 || TabletStudyData.tabletRearColorR_ForCamera1 > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletEngraveColorForCamera1[0] < 0 || TabletStudyData.tabletEngraveColorForCamera1[0] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletEngraveColorForCamera1[1] < 0 || TabletStudyData.tabletEngraveColorForCamera1[1] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletEngraveColorForCamera1[2] < 0 || TabletStudyData.tabletEngraveColorForCamera1[2] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletRearEngraveColorForCamera1[0] < 0 || TabletStudyData.tabletRearEngraveColorForCamera1[0] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletRearEngraveColorForCamera1[1] < 0 || TabletStudyData.tabletRearEngraveColorForCamera1[1] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletRearEngraveColorForCamera1[2] < 0 || TabletStudyData.tabletRearEngraveColorForCamera1[2] > 255) dataIntegrity = 0;
		if (TabletStudyData.Print1_IsOrNotThreshold_ForCamera1 < 0 || TabletStudyData.Print1_IsOrNotThreshold_ForCamera1 > 2999)
		{
			dataIntegrity = 0;
		}
		if (TabletStudyData.Print2_IsOrNotThreshold_ForCamera1 < 0 || TabletStudyData.Print2_IsOrNotThreshold_ForCamera1 > 2999)
		{
			dataIntegrity = 0;
		}
	}
	else if (globalCamIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
	{
		if (TabletStudyData.Print1_IsOrNotThreshold_ForCamera5 < 0 || TabletStudyData.Print1_IsOrNotThreshold_ForCamera5 > 1999)
		{
			dataIntegrity = 0;
		}
		if (TabletStudyData.Print2_IsOrNotThreshold_ForCamera5 < 0 || TabletStudyData.Print2_IsOrNotThreshold_ForCamera5 > 1999)
		{
			dataIntegrity = 0;
		}
		if (TabletStudyData.tabletMaxThickForFirstDisk < 0 || TabletStudyData.tabletMaxThickForFirstDisk > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletCenterThickForFirstDisk < 0 || TabletStudyData.tabletCenterThickForFirstDisk > 255) dataIntegrity = 0;
	}
	else if (globalCamIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
	{
		if (TabletStudyData.tabletColorB_ForCamera9 < 0 || TabletStudyData.tabletColorB_ForCamera9 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletColorG_ForCamera9 < 0 || TabletStudyData.tabletColorG_ForCamera9 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletColorR_ForCamera9 < 0 || TabletStudyData.tabletColorR_ForCamera9 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletRearColorB_ForCamera9 < 0 || TabletStudyData.tabletRearColorB_ForCamera9 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletRearColorG_ForCamera9 < 0 || TabletStudyData.tabletRearColorG_ForCamera9 > 255) dataIntegrity = 0;
		if (TabletStudyData.tabletRearColorR_ForCamera9 < 0 || TabletStudyData.tabletRearColorR_ForCamera9 > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletEngraveColorForCamera9[0] < 0 || TabletStudyData.tabletEngraveColorForCamera9[0] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletEngraveColorForCamera9[1] < 0 || TabletStudyData.tabletEngraveColorForCamera9[1] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletEngraveColorForCamera9[2] < 0 || TabletStudyData.tabletEngraveColorForCamera9[2] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletRearEngraveColorForCamera9[0] < 0 || TabletStudyData.tabletRearEngraveColorForCamera9[0] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletRearEngraveColorForCamera9[1] < 0 || TabletStudyData.tabletRearEngraveColorForCamera9[1] > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletRearEngraveColorForCamera9[2] < 0 || TabletStudyData.tabletRearEngraveColorForCamera9[2] > 255) dataIntegrity = 0;
		if (TabletStudyData.Print1_IsOrNotThreshold_ForCamera9 < 0 || TabletStudyData.Print1_IsOrNotThreshold_ForCamera9 > 2999)
		{
			dataIntegrity = 0;
		}
		if (TabletStudyData.Print2_IsOrNotThreshold_ForCamera9 < 0 || TabletStudyData.Print2_IsOrNotThreshold_ForCamera9 > 2999)
		{
			dataIntegrity = 0;
		}
	}
	else if (globalCamIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX)
	{
		if (TabletStudyData.Print1_IsOrNotThreshold_ForCamera13 < 0 || TabletStudyData.Print1_IsOrNotThreshold_ForCamera13 > 1999)
		{
			dataIntegrity = 0;
		}
		if (TabletStudyData.Print2_IsOrNotThreshold_ForCamera13 < 0 || TabletStudyData.Print2_IsOrNotThreshold_ForCamera13 > 1999)
		{
			dataIntegrity = 0;
		}
		if (TabletStudyData.tabletMaxThickForSecondDisk < 0 || TabletStudyData.tabletMaxThickForSecondDisk > 255) dataIntegrity = 0;
    if (TabletStudyData.tabletCenterThickForSecondDisk < 0 || TabletStudyData.tabletCenterThickForSecondDisk > 255) dataIntegrity = 0;
	}
  else
  {
    // Side Camera
    if (TabletStudyData.SideFaceTabletBColor[globalCamIndex - 1] < 0 || TabletStudyData.SideFaceTabletBColor[globalCamIndex - 1] > 255) dataIntegrity =	0;
    if (TabletStudyData.SideFaceTabletGColor[globalCamIndex - 1] < 0 || TabletStudyData.SideFaceTabletGColor[globalCamIndex - 1] > 255) dataIntegrity =	0;
    if (TabletStudyData.SideFaceTabletRColor[globalCamIndex - 1] < 0 || TabletStudyData.SideFaceTabletRColor[globalCamIndex - 1] > 255) dataIntegrity =	0;
  }

	if (dataIntegrity)
	{
		if (globalCamIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
		{
      if (TabletStudyData.tabletColorB_ForCamera1 || TabletStudyData.tabletColorG_ForCamera1 || TabletStudyData.tabletColorR_ForCamera1)
      {
        AccStudyData[globalCamIndex - 1].ColorB[TabletStudyData.tabletColorB_ForCamera1]++;
        AccStudyData[globalCamIndex - 1].ColorG[TabletStudyData.tabletColorG_ForCamera1]++;
        AccStudyData[globalCamIndex - 1].ColorR[TabletStudyData.tabletColorR_ForCamera1]++;
      }
      if (TabletStudyData.tabletRearColorB_ForCamera1 || TabletStudyData.tabletRearColorG_ForCamera1 || TabletStudyData.tabletRearColorR_ForCamera1)
      {
        AccStudyData[globalCamIndex - 1].RearColorB[TabletStudyData.tabletRearColorB_ForCamera1]++;
        AccStudyData[globalCamIndex - 1].RearColorG[TabletStudyData.tabletRearColorG_ForCamera1]++;
        AccStudyData[globalCamIndex - 1].RearColorR[TabletStudyData.tabletRearColorR_ForCamera1]++;
      }
      if (TabletStudyData.tabletEngraveColorForCamera1[0] || TabletStudyData.tabletEngraveColorForCamera1[1] || TabletStudyData.tabletEngraveColorForCamera1[2])
      {
        AccStudyData[globalCamIndex - 1].TabletPrintColorB[TabletStudyData.tabletEngraveColorForCamera1[0]]++;
        AccStudyData[globalCamIndex - 1].TabletPrintColorG[TabletStudyData.tabletEngraveColorForCamera1[1]]++;
        AccStudyData[globalCamIndex - 1].TabletPrintColorR[TabletStudyData.tabletEngraveColorForCamera1[2]]++;
      }
      if (TabletStudyData.tabletRearEngraveColorForCamera1[0] || TabletStudyData.tabletRearEngraveColorForCamera1[1] || TabletStudyData.tabletRearEngraveColorForCamera1[2])
      {
        AccStudyData[globalCamIndex - 1].TabletRearPrintColorB[TabletStudyData.tabletRearEngraveColorForCamera1[0]]++;
        AccStudyData[globalCamIndex - 1].TabletRearPrintColorG[TabletStudyData.tabletRearEngraveColorForCamera1[1]]++;
        AccStudyData[globalCamIndex - 1].TabletRearPrintColorR[TabletStudyData.tabletRearEngraveColorForCamera1[2]]++;
      }
      
			AccStudyData[globalCamIndex - 1].PrintMatchingValue1[TabletStudyData.Print1_IsOrNotThreshold_ForCamera1]++;
			AccStudyData[globalCamIndex - 1].PrintMatchingValue2[TabletStudyData.Print2_IsOrNotThreshold_ForCamera1]++;

      if(TabletStudyData.TabletEngraveMisMatchCount_Empty_CAM1 != 0)
      {
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatchCount_Empty += TabletStudyData.TabletEngraveMisMatchCount_Empty_CAM1;
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatch_AddCount_Empty++;
      }

      if(TabletStudyData.TabletEngraveMisMatchCount_Remaining_CAM1 != 0)
      {
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatchCount_Remaining += TabletStudyData.TabletEngraveMisMatchCount_Remaining_CAM1;
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatch_AddCount_Remaining++;
      }
		}
		else if (globalCamIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
		{
			AccStudyData[globalCamIndex - 1].PrintMatchingValue1[TabletStudyData.Print1_IsOrNotThreshold_ForCamera5]++;
			AccStudyData[globalCamIndex - 1].PrintMatchingValue2[TabletStudyData.Print2_IsOrNotThreshold_ForCamera5]++;
			AccStudyData[globalCamIndex - 1].ThreeDMaxHeight1[TabletStudyData.tabletMaxThickForFirstDisk]++;
      AccStudyData[globalCamIndex - 1].ThreeDCenterHeight1[TabletStudyData.tabletCenterThickForFirstDisk]++;
		}
		else if (globalCamIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
		{
      if (TabletStudyData.tabletColorB_ForCamera9 || TabletStudyData.tabletColorG_ForCamera9 || TabletStudyData.tabletColorR_ForCamera9)
      {
        AccStudyData[globalCamIndex - 1].ColorB[TabletStudyData.tabletColorB_ForCamera9]++;
        AccStudyData[globalCamIndex - 1].ColorG[TabletStudyData.tabletColorG_ForCamera9]++;
        AccStudyData[globalCamIndex - 1].ColorR[TabletStudyData.tabletColorR_ForCamera9]++;
      }
      if (TabletStudyData.tabletRearColorB_ForCamera9 || TabletStudyData.tabletRearColorG_ForCamera9 || TabletStudyData.tabletRearColorR_ForCamera9)
      {
        AccStudyData[globalCamIndex - 1].RearColorB[TabletStudyData.tabletRearColorB_ForCamera9]++;
        AccStudyData[globalCamIndex - 1].RearColorG[TabletStudyData.tabletRearColorG_ForCamera9]++;
        AccStudyData[globalCamIndex - 1].RearColorR[TabletStudyData.tabletRearColorR_ForCamera9]++;
      }
      if (TabletStudyData.tabletEngraveColorForCamera9[0] || TabletStudyData.tabletEngraveColorForCamera9[1] || TabletStudyData.tabletEngraveColorForCamera9[2])
      {
        AccStudyData[globalCamIndex - 1].TabletPrintColorB[TabletStudyData.tabletEngraveColorForCamera9[0]]++;
        AccStudyData[globalCamIndex - 1].TabletPrintColorG[TabletStudyData.tabletEngraveColorForCamera9[1]]++;
        AccStudyData[globalCamIndex - 1].TabletPrintColorR[TabletStudyData.tabletEngraveColorForCamera9[2]]++;
      }
      if (TabletStudyData.tabletRearEngraveColorForCamera9[0] || TabletStudyData.tabletRearEngraveColorForCamera9[1] || TabletStudyData.tabletRearEngraveColorForCamera9[2])
      {
        AccStudyData[globalCamIndex - 1].TabletRearPrintColorB[TabletStudyData.tabletRearEngraveColorForCamera9[0]]++;
        AccStudyData[globalCamIndex - 1].TabletRearPrintColorG[TabletStudyData.tabletRearEngraveColorForCamera9[1]]++;
        AccStudyData[globalCamIndex - 1].TabletRearPrintColorR[TabletStudyData.tabletRearEngraveColorForCamera9[2]]++;
      }
      
			AccStudyData[globalCamIndex - 1].PrintMatchingValue1[TabletStudyData.Print1_IsOrNotThreshold_ForCamera9]++;
			AccStudyData[globalCamIndex - 1].PrintMatchingValue2[TabletStudyData.Print2_IsOrNotThreshold_ForCamera9]++;

      if(TabletStudyData.TabletEngraveMisMatchCount_Empty_CAM9 != 0)
      {
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatchCount_Empty += TabletStudyData.TabletEngraveMisMatchCount_Empty_CAM9;
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatch_AddCount_Empty++;
      }

      if(TabletStudyData.TabletEngraveMisMatchCount_Remaining_CAM9 != 0)
      {
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatchCount_Remaining += TabletStudyData.TabletEngraveMisMatchCount_Remaining_CAM9;
        AccStudyData[globalCamIndex - 1].AccTabletEngraveMisMatch_AddCount_Remaining++;
      }
		}
		else if (globalCamIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX)
		{
			AccStudyData[globalCamIndex - 1].PrintMatchingValue1[TabletStudyData.Print1_IsOrNotThreshold_ForCamera13]++;
			AccStudyData[globalCamIndex - 1].PrintMatchingValue2[TabletStudyData.Print2_IsOrNotThreshold_ForCamera13]++;
			AccStudyData[globalCamIndex - 1].ThreeDMaxHeight2[TabletStudyData.tabletMaxThickForSecondDisk]++;
			AccStudyData[globalCamIndex - 1].ThreeDCenterHeight2[TabletStudyData.tabletCenterThickForSecondDisk]++;
		}
    else
    {
      // Side Camera
      if (TabletStudyData.SideFaceTabletBColor[globalCamIndex - 1] != 0 ||
          TabletStudyData.SideFaceTabletGColor[globalCamIndex - 1]	!= 0 ||
		      TabletStudyData.SideFaceTabletRColor[globalCamIndex - 1])
	    {
		    AccStudyData[globalCamIndex - 1].ColorB[TabletStudyData.SideFaceTabletBColor[globalCamIndex - 1]]++;
		    AccStudyData[globalCamIndex - 1].ColorG[TabletStudyData.SideFaceTabletGColor[globalCamIndex - 1]]++;
		    AccStudyData[globalCamIndex - 1].ColorR[TabletStudyData.SideFaceTabletRColor[globalCamIndex - 1]]++;
	    }
    }
	}
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::StudyResultDisplay()
{
  int maxCount, maxCountColor, globalCameraIndex;
  TTabletStudyData FinalStudyData;

	globalCameraIndex = SD1_2D_FRONT_FACE_CAMERA_INDEX - 1;

  if (TabletCharacter.tabletLayerCount == 2)
  {
    OneColor->Visible = false;
    TwoColor->Visible = true;
  }
  else
  {
    OneColor->Visible = true;
    TwoColor->Visible = false;
  }

  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].ColorR[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].ColorR[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletColorR_ForCamera1 = maxCountColor;
  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].ColorG[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].ColorG[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletColorG_ForCamera1 = maxCountColor;
  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].ColorB[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].ColorB[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletColorB_ForCamera1 = maxCountColor;

  //  
  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 1; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].TabletPrintColorB[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].TabletPrintColorB[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletEngraveColorForCamera1[0] = maxCountColor;

  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 1; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].TabletPrintColorG[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].TabletPrintColorG[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletEngraveColorForCamera1[1] = maxCountColor;

  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 1; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].TabletPrintColorR[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].TabletPrintColorR[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletEngraveColorForCamera1[2] = maxCountColor;

  if (TabletCharacter.tabletLayerCount == 2)
  {
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 0; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].RearColorR[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].RearColorR[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearColorR_ForCamera1 = maxCountColor;
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 0; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].RearColorG[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].RearColorG[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearColorG_ForCamera1 = maxCountColor;
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 0; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].RearColorB[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].RearColorB[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearColorB_ForCamera1 = maxCountColor;

    //  
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 1; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].TabletRearPrintColorB[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].TabletRearPrintColorB[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearEngraveColorForCamera1[0] = maxCountColor;

    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 1; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].TabletRearPrintColorG[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].TabletRearPrintColorG[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearEngraveColorForCamera1[1] = maxCountColor;

    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 1; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].TabletRearPrintColorR[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].TabletRearPrintColorR[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearEngraveColorForCamera1[2] = maxCountColor;
  }

	globalCameraIndex = SD2_2D_FRONT_FACE_CAMERA_INDEX - 1;

  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].ColorR[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].ColorR[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletColorR_ForCamera9 = maxCountColor;
  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].ColorG[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].ColorG[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletColorG_ForCamera9 = maxCountColor;
  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].ColorB[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].ColorB[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletColorB_ForCamera9 = maxCountColor;

  //  
  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 1; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].TabletPrintColorB[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].TabletPrintColorB[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletEngraveColorForCamera9[0] = maxCountColor;

  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 1; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].TabletPrintColorG[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].TabletPrintColorG[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletEngraveColorForCamera9[1] = maxCountColor;

  maxCount = 0;
  maxCountColor = 0;
  for (int dataIndex = 1; dataIndex < 256; dataIndex++)
  {
    if (maxCount < AccStudyData[globalCameraIndex].TabletPrintColorR[dataIndex])
    {
      maxCount = AccStudyData[globalCameraIndex].TabletPrintColorR[dataIndex];
      maxCountColor = dataIndex;
    }
  }
  FinalStudyData.tabletEngraveColorForCamera9[2] = maxCountColor;

  if (TabletCharacter.tabletLayerCount == 2)
  {
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 0; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].RearColorR[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].RearColorR[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearColorR_ForCamera9 = maxCountColor;
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 0; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].RearColorG[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].RearColorG[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearColorG_ForCamera9 = maxCountColor;
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 0; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].RearColorB[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].RearColorB[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearColorB_ForCamera9 = maxCountColor;

    //  
    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 1; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].TabletRearPrintColorB[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].TabletRearPrintColorB[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearEngraveColorForCamera9[0] = maxCountColor;

    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 1; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].TabletRearPrintColorG[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].TabletRearPrintColorG[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearEngraveColorForCamera9[1] = maxCountColor;

    maxCount = 0;
    maxCountColor = 0;
    for (int dataIndex = 1; dataIndex < 256; dataIndex++)
    {
      if (maxCount < AccStudyData[globalCameraIndex].TabletRearPrintColorR[dataIndex])
      {
        maxCount = AccStudyData[globalCameraIndex].TabletRearPrintColorR[dataIndex];
        maxCountColor = dataIndex;
      }
    }
    FinalStudyData.tabletRearEngraveColorForCamera9[2] = maxCountColor;
  }

  // side
  for(globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    if((globalCameraIndex != SD1_2D_FRONT_FACE_CAMERA_INDEX - 1) &&
        (globalCameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX - 1) &&
        (globalCameraIndex != SD2_2D_FRONT_FACE_CAMERA_INDEX - 1) &&
        (globalCameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX - 1))
    {
      maxCount = 0;
      maxCountColor = 0;
      for (int dataIndex = 0; dataIndex < 256; dataIndex++)
      {
        if (maxCount < AccStudyData[globalCameraIndex].ColorR[dataIndex])
        {
          maxCount = AccStudyData[globalCameraIndex].ColorR[dataIndex];
          maxCountColor = dataIndex;
        }
      }
      FinalStudyData.SideFaceTabletRColor[globalCameraIndex] = maxCountColor;

      maxCount = 0;
      maxCountColor = 0;
      for (int dataIndex = 0; dataIndex < 256; dataIndex++)
      {
        if (maxCount < AccStudyData[globalCameraIndex].ColorG[dataIndex])
        {
          maxCount = AccStudyData[globalCameraIndex].ColorG[dataIndex];
          maxCountColor = dataIndex;
        }
      }
      FinalStudyData.SideFaceTabletGColor[globalCameraIndex] = maxCountColor;

      maxCount = 0;
      maxCountColor = 0;
      for (int dataIndex = 0; dataIndex < 256; dataIndex++)
      {
        if (maxCount < AccStudyData[globalCameraIndex].ColorB[dataIndex])
        {
          maxCount = AccStudyData[globalCameraIndex].ColorB[dataIndex];
          maxCountColor = dataIndex;
        }
      }
      FinalStudyData.SideFaceTabletBColor[globalCameraIndex] = maxCountColor;
    }
  }

	if (ProductData.EngraveType != ENGRAVE_TYPE_PRINT)
	{
    if (ProductData.EngravePos == ENGRAVE_POS_ONESIDE)
    {
      FinalStudyData.Print1_IsOrNotThreshold_ForCamera1 =
        Optimal_Threshold(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 3000, NULL, 1);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera1 =
        Optimal_Threshold(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 3000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera5 =
        Optimal_Threshold(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 2000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera5 =
        Optimal_Threshold(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 2000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera9 =
        Optimal_Threshold(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 3000, NULL, 1);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera9 =
        Optimal_Threshold(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 3000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera13 =
        Optimal_Threshold(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 2000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera13 =
        Optimal_Threshold(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 2000, NULL, 0);
    }
    else
    {
      FinalStudyData.Print1_IsOrNotThreshold_ForCamera1 =
        Optimal_Threshold(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 3000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera1 =
        Optimal_Threshold(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 3000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera5 =
        Optimal_Threshold(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 2000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera5 =
        Optimal_Threshold(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 2000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera9 =
        Optimal_Threshold(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 3000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera9 =
        Optimal_Threshold(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 3000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera13 =
        Optimal_Threshold(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 2000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera13 =
        Optimal_Threshold(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 2000, NULL, 0);
    }
	}
  else if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
  {
    FinalStudyData.Print1_IsOrNotThreshold_ForCamera1 =
      Mean(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 3000);
    FinalStudyData.Print2_IsOrNotThreshold_ForCamera1 =
      Mean(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 3000);

    FinalStudyData.Print1_IsOrNotThreshold_ForCamera9 =
      Mean(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 3000);
    FinalStudyData.Print2_IsOrNotThreshold_ForCamera9 =
      Mean(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 3000);

    if(ProductData.DivisionLineInfo == DIVISION_LINE_NONE)
    {
      FinalStudyData.Print1_IsOrNotThreshold_ForCamera5 =
        Mean(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 2000);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera5 =
        Mean(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 2000);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera13 =
        Mean(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 2000);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera13 =
        Mean(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 2000);
    }
    else
    {
      FinalStudyData.Print1_IsOrNotThreshold_ForCamera5 =
        Optimal_Threshold(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 2000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera5 =
        Optimal_Threshold(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 2000, NULL, 0);

      FinalStudyData.Print1_IsOrNotThreshold_ForCamera13 =
        Optimal_Threshold(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 0, 2000, NULL, 0);
      FinalStudyData.Print2_IsOrNotThreshold_ForCamera13 =
        Optimal_Threshold(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 0, 2000, NULL, 0);
    }
  }
	else
	{
    FinalStudyData.Print1_IsOrNotThreshold_ForCamera1 =
      Mean(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 3000);
    FinalStudyData.Print2_IsOrNotThreshold_ForCamera1 =
      Mean(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 3000);

    FinalStudyData.Print1_IsOrNotThreshold_ForCamera5 =
      Mean(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 2000);
    FinalStudyData.Print2_IsOrNotThreshold_ForCamera5 =
      Mean(AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 2000);

    FinalStudyData.Print1_IsOrNotThreshold_ForCamera9 =
      Mean(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 3000);
    FinalStudyData.Print2_IsOrNotThreshold_ForCamera9 =
      Mean(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 3000);

    FinalStudyData.Print1_IsOrNotThreshold_ForCamera13 =
      Mean(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue1, 1, 2000);
    FinalStudyData.Print2_IsOrNotThreshold_ForCamera13 =
      Mean(AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].PrintMatchingValue2, 1, 2000);
	}

  if (ProductData.EngraveType != ENGRAVE_TYPE_PRINT && ProductData.EngravePos == ENGRAVE_POS_ONESIDE)
  {
    if(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Remaining != 0)
    {
      FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM1 = AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatchCount_Remaining / AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Remaining;
    }
    else
    {
      FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM1 = 10000;
    }

    if(AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Empty != 0)
    {
      FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM1 = AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatchCount_Empty / AccStudyData[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Empty;
    }
    else
    {
      FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM1 = 10000;
    }

    if(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Remaining != 0)
    {
      FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM9 = AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatchCount_Remaining / AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Remaining;
    }
    else
    {
      FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM9 = 10000;
    }

    if(AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Empty != 0)
    {
      FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM9 = AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatchCount_Empty / AccStudyData[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].AccTabletEngraveMisMatch_AddCount_Empty;
    }
    else
    {
      FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM9 = 10000;
    }
  }
  else
  {
    FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM1 = 10000;
    FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM1 = 10000;

    FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM9 = 10000;
    FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM9 = 10000;
  }

	int maxHeightCountA = -1;
	int maxHeightValA = 0;
	int centerHeightCountA = -1;
	int centerHeightValA = 0;

  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxHeightCountA < AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDMaxHeight1[dataIndex])
    {
      maxHeightCountA = AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDMaxHeight1[dataIndex];
      maxHeightValA = dataIndex;
    }

    if (centerHeightCountA < AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDCenterHeight1[dataIndex])
    {
      centerHeightCountA = AccStudyData[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDCenterHeight1[dataIndex];
      centerHeightValA = dataIndex;
    }
  }

	int maxHeightCountB = -1;
	int maxHeightValB = 0;
	int centerHeightCountB = -1;
	int centerHeightValB = 0;

  for (int dataIndex = 0; dataIndex < 256; dataIndex++)
  {
    if (maxHeightCountB < AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDMaxHeight2[dataIndex])
    {
      maxHeightCountB = AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDMaxHeight2[dataIndex];
      maxHeightValB = dataIndex;
    }

    if (centerHeightCountB < AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDCenterHeight2[dataIndex])
    {
      centerHeightCountB = AccStudyData[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ThreeDCenterHeight2[dataIndex];
      centerHeightValB = dataIndex;
    }
  }

	FinalStudyData.tabletMaxThickForFirstDisk = maxHeightValA;
	FinalStudyData.tabletMaxThickForSecondDisk = maxHeightValB;
	FinalStudyData.tabletCenterThickForFirstDisk = centerHeightValA;
	FinalStudyData.tabletCenterThickForSecondDisk = centerHeightValB;

	AnsiString studyFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".stu";
	if (!SaveStudyData(studyFileName, FinalStudyData))
	{
		ShowMessageFA(" ");
	}


  // side
  for(globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    if((globalCameraIndex != SD1_2D_FRONT_FACE_CAMERA_INDEX - 1) &&
        (globalCameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX - 1) &&
        (globalCameraIndex != SD2_2D_FRONT_FACE_CAMERA_INDEX - 1) &&
        (globalCameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX - 1))
    {
      TShape *tempShape = ((TShape *)FindComponent("SideCameraColorShape"+IntToStr(globalCameraIndex + 1)));

      if(tempShape)
      {
        tempShape->Brush->Color = (TColor)((FinalStudyData.SideFaceTabletBColor[globalCameraIndex] << 16) + (FinalStudyData.SideFaceTabletGColor[globalCameraIndex] << 8) + FinalStudyData.SideFaceTabletRColor[globalCameraIndex]);
      }

      TStaticText *tempLabel;

      tempLabel = ((TStaticText *)FindComponent("SideCameraBColorLabel"+IntToStr(globalCameraIndex + 1)));
      if(tempLabel)
      {
        tempLabel->Caption = "B = " + IntToStr(FinalStudyData.SideFaceTabletBColor[globalCameraIndex]);
      }
      tempLabel = ((TStaticText *)FindComponent("SideCameraGColorLabel"+IntToStr(globalCameraIndex + 1)));
      if(tempLabel)
      {
        tempLabel->Caption = "G = " + IntToStr(FinalStudyData.SideFaceTabletGColor[globalCameraIndex]);
      }
      tempLabel = ((TStaticText *)FindComponent("SideCameraRColorLabel"+IntToStr(globalCameraIndex + 1)));
      if(tempLabel)
      {
        tempLabel->Caption = "R = " + IntToStr(FinalStudyData.SideFaceTabletRColor[globalCameraIndex]);
      }
    }
  }
    
  if (TabletCharacter.tabletLayerCount == 2)
  {
    TabletTwoColorFrontShape1->Brush->Color = (TColor)((FinalStudyData.tabletColorB_ForCamera1 << 16) +
      (FinalStudyData.tabletColorG_ForCamera1 << 8) + FinalStudyData.tabletColorR_ForCamera1);

    TabletTwoColorRearShape1->Brush->Color = (TColor)((FinalStudyData.tabletRearColorB_ForCamera1 << 16) +
      (FinalStudyData.tabletRearColorG_ForCamera1 << 8) + FinalStudyData.tabletRearColorR_ForCamera1);

    TabletTwoColorFrontShape2->Brush->Color = (TColor)((FinalStudyData.tabletColorB_ForCamera9 << 16) +
      (FinalStudyData.tabletColorG_ForCamera9 << 8) + FinalStudyData.tabletColorR_ForCamera9);

    TabletTwoColorRearShape2->Brush->Color = (TColor)((FinalStudyData.tabletRearColorB_ForCamera9 << 16) +
      (FinalStudyData.tabletRearColorG_ForCamera9 << 8) + FinalStudyData.tabletRearColorR_ForCamera9);

    TabletTwoColorFrontLabel_Disk1_R->Caption = "R = " + IntToStr(FinalStudyData.tabletColorR_ForCamera1);
    TabletTwoColorFrontLabel_Disk1_G->Caption = "G = " + IntToStr(FinalStudyData.tabletColorG_ForCamera1);
    TabletTwoColorFrontLabel_Disk1_B->Caption = "B = " + IntToStr(FinalStudyData.tabletColorB_ForCamera1);

    TabletTwoColorRearLabel_Disk1_R->Caption = "R = " + IntToStr(FinalStudyData.tabletRearColorR_ForCamera1);
    TabletTwoColorRearLabel_Disk1_G->Caption = "G = " + IntToStr(FinalStudyData.tabletRearColorG_ForCamera1);
    TabletTwoColorRearLabel_Disk1_B->Caption = "B = " + IntToStr(FinalStudyData.tabletRearColorB_ForCamera1);

    TabletTwoColorFrontLabel_Disk2_R->Caption = "R = " + IntToStr(FinalStudyData.tabletColorR_ForCamera9);
    TabletTwoColorFrontLabel_Disk2_G->Caption = "G = " + IntToStr(FinalStudyData.tabletColorG_ForCamera9);
    TabletTwoColorFrontLabel_Disk2_B->Caption = "B = " + IntToStr(FinalStudyData.tabletColorB_ForCamera9);

    TabletTwoColorRearLabel_Disk2_R->Caption = "R = " + IntToStr(FinalStudyData.tabletRearColorR_ForCamera9);
    TabletTwoColorRearLabel_Disk2_G->Caption = "G = " + IntToStr(FinalStudyData.tabletRearColorG_ForCamera9);
    TabletTwoColorRearLabel_Disk2_B->Caption = "B = " + IntToStr(FinalStudyData.tabletRearColorB_ForCamera9);
  }
  else
  {
    TabletOneColorShape1->Brush->Color = (TColor)((FinalStudyData.tabletColorB_ForCamera1 << 16) +
      (FinalStudyData.tabletColorG_ForCamera1 << 8) + FinalStudyData.tabletColorR_ForCamera1);

    TabletOneColorShape2->Brush->Color = (TColor)((FinalStudyData.tabletColorB_ForCamera9 << 16) +
      (FinalStudyData.tabletColorG_ForCamera9 << 8) + FinalStudyData.tabletColorR_ForCamera9);

    TabletEngraveOneColorShape1->Brush->Color = (TColor)((FinalStudyData.tabletEngraveColorForCamera1[0] << 16) +
      (FinalStudyData.tabletEngraveColorForCamera1[1] << 8) + FinalStudyData.tabletEngraveColorForCamera1[2]);

    TabletEngraveOneColorShape2->Brush->Color = (TColor)((FinalStudyData.tabletEngraveColorForCamera9[0] << 16) +
      (FinalStudyData.tabletEngraveColorForCamera9[1] << 8) + FinalStudyData.tabletEngraveColorForCamera9[2]);

    TabletOneColorLabel_Disk1_R->Caption = "R = " + IntToStr(FinalStudyData.tabletColorR_ForCamera1);
    TabletOneColorLabel_Disk1_G->Caption = "G = " + IntToStr(FinalStudyData.tabletColorG_ForCamera1);
    TabletOneColorLabel_Disk1_B->Caption = "B = " + IntToStr(FinalStudyData.tabletColorB_ForCamera1);

    TabletOneColorLabel_Disk2_R->Caption = "R = " + IntToStr(FinalStudyData.tabletColorR_ForCamera9);
    TabletOneColorLabel_Disk2_G->Caption = "G = " + IntToStr(FinalStudyData.tabletColorG_ForCamera9);
    TabletOneColorLabel_Disk2_B->Caption = "B = " + IntToStr(FinalStudyData.tabletColorB_ForCamera9);

    TabletEngraveOneColorLabel_Disk1_R->Caption = "R = " + IntToStr(FinalStudyData.tabletEngraveColorForCamera1[2]);
    TabletEngraveOneColorLabel_Disk1_G->Caption = "G = " + IntToStr(FinalStudyData.tabletEngraveColorForCamera1[1]);
    TabletEngraveOneColorLabel_Disk1_B->Caption = "B = " + IntToStr(FinalStudyData.tabletEngraveColorForCamera1[0]);

    TabletEngraveOneColorLabel_Disk2_R->Caption = "R = " + IntToStr(FinalStudyData.tabletEngraveColorForCamera9[2]);
    TabletEngraveOneColorLabel_Disk2_G->Caption = "G = " + IntToStr(FinalStudyData.tabletEngraveColorForCamera9[1]);
    TabletEngraveOneColorLabel_Disk2_B->Caption = "B = " + IntToStr(FinalStudyData.tabletEngraveColorForCamera9[0]);
  }

  ThresholdLabel_ForCam1_A->Caption = IntToStr(FinalStudyData.Print1_IsOrNotThreshold_ForCamera1);
  ThresholdLabel_ForCam1_B->Caption = IntToStr(FinalStudyData.Print2_IsOrNotThreshold_ForCamera1);

  ThresholdLabel_ForCam2_A->Caption = IntToStr(FinalStudyData.Print1_IsOrNotThreshold_ForCamera5);
  ThresholdLabel_ForCam2_B->Caption = IntToStr(FinalStudyData.Print2_IsOrNotThreshold_ForCamera5);

  ThresholdLabel_ForCam6_A->Caption = IntToStr(FinalStudyData.Print1_IsOrNotThreshold_ForCamera9);
  ThresholdLabel_ForCam6_B->Caption = IntToStr(FinalStudyData.Print2_IsOrNotThreshold_ForCamera9);

  ThresholdLabel_ForCam7_A->Caption = IntToStr(FinalStudyData.Print1_IsOrNotThreshold_ForCamera13);
  ThresholdLabel_ForCam7_B->Caption = IntToStr(FinalStudyData.Print2_IsOrNotThreshold_ForCamera13);

  HeightThresholdLabel_Disc1->Caption = IntToStr(maxHeightValA);
  HeightThresholdLabel_Disc2->Caption = IntToStr(maxHeightValB);

  Cam1Empty->Caption = IntToStr(FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM1);
  Cam1Remaining->Caption = IntToStr(FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM1);

  Cam6Empty->Caption = IntToStr(FinalStudyData.TabletEngraveMisMatchCount_Empty_CAM9);
  Cam6Remaining->Caption = IntToStr(FinalStudyData.TabletEngraveMisMatchCount_Remaining_CAM9);
}
//---------------------------------------------------------------------------
int __fastcall TSecondStudyFom::Optimal_Threshold(unsigned short *histo, int st_gray, int end_gray, int *grayMean, int option)
{
	int opti_threshold;
	int new_opti_threshold;
	int gl;
	int low_mean;
  int low_mean_cnt;
  int high_mean;
  int high_mean_cnt;
  int repeat_cnt;
  int tcnt;
  repeat_cnt = 0;
  tcnt = 0;
  new_opti_threshold = 0;

  // histo[gl]  gl  īõ Ƚ ǹ
  for(gl = st_gray ; gl < end_gray; gl++) // 0 : 1000
  {
    new_opti_threshold += histo[gl]*gl;
    tcnt += histo[gl];
  }
  if(tcnt != 0)
    new_opti_threshold/=tcnt; // ȭ
  else
    new_opti_threshold = 0;

  if(option)
    return new_opti_threshold;
  do
  {
    low_mean = 0;
    high_mean = 0;
    low_mean_cnt = 0;
    high_mean_cnt = 0;
    opti_threshold = new_opti_threshold;
    for(gl= st_gray ; gl < opti_threshold; gl++)
    {
      low_mean += histo[gl]*gl;
      low_mean_cnt+=(histo[gl]);
    }
    for(gl= opti_threshold ; gl < end_gray; gl++)
    {
      high_mean += histo[gl]*gl;
      high_mean_cnt+=(histo[gl]);
    }
    if(low_mean_cnt != 0)
      low_mean/= low_mean_cnt;
    if(high_mean_cnt != 0)
      high_mean/= high_mean_cnt;

    new_opti_threshold = (low_mean + high_mean)/2;
    repeat_cnt++;
  }
  while( abs(new_opti_threshold - opti_threshold) > 2 && repeat_cnt < 10);

  return(new_opti_threshold);
}
//---------------------------------------------------------------------------
int __fastcall TSecondStudyFom::Mean(unsigned short *data, int st_index, int end_index)
{
	int sum = 0;
    int count = 0;
	for (int index = st_index; index < end_index; index++)
    {
		sum += index * data[index];
        count += data[index];
    }
    if (count == 0) return 0;
    else return sum / count;
}
//---------------------------------------------------------------------------
bool __fastcall TSecondStudyFom::SaveStudyData(AnsiString studyFileName, TTabletStudyData &StudyData)
{
	TFileStream *fileStream = new TFileStream(studyFileName, fmCreate);
    if (fileStream)
    {
		fileStream->Write(&StudyData, sizeof(TTabletStudyData));
    	delete fileStream;
        return true;
    }
    else
    {
    	return false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TSecondStudyFom::Setup(int cameraIndex)
{
	if (!ReadSetupData(&TabletSetupData))
  {
    ShowMessage("Setup Data  о  ϴ.");
  }

  if (!Read3DSetupData(&Tablet3DSetupData))
  {
    ShowMessageW("Setup Data  о  ϴ.");
  }

  MakeTabletCharacterData(&ProductData, &TabletCharacter, &MachineParams);
  
  int InspectionOrStudy = STUDY_MODE;
  int InspectionKind;

  switch(cameraIndex)
  {
    case SD1_2D_FRONT_FACE_CAMERA_INDEX:
    case SD2_2D_FRONT_FACE_CAMERA_INDEX:
      InspectionKind = FRONT_FACE;
      break;
    case SD1_3D_FRONT_FACE_CAMERA_INDEX:
    case SD2_3D_FRONT_FACE_CAMERA_INDEX:
      InspectionKind = FRONT_FACE_SPECIAL;
      break;
    case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
    case SD2_2D_SIDE_FACE_P45_CAMERA_INDEX:
    case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
    case SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
			InspectionKind = SIDE_FACE_P45;
			break;
    case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
    case SD2_2D_SIDE_FACE_00_CAMERA_INDEX:
    case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
    case SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
			InspectionKind = SIDE_FACE_0;
			break;
		case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
    case SD2_2D_SIDE_FACE_M45_CAMERA_INDEX:
    case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
    case SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
			InspectionKind = SIDE_FACE_M45;
			break;
  }

  SetSideFaceDataAddress(&tempSideData[0]);

  CPBCommonVariableInitial();

  int SDNum;
  if(cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX || cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
  {
    SDNum = SUCTION_DISK_NUM1;
    FrontFaceSetUpDataTransForm(InspectionKind,SDNum);
    SetUpDataTransFormForThreeD(InspectionKind,SDNum);
  }
  else if(cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX || cameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX)
  {
    SDNum = SUCTION_DISK_NUM2;
    FrontFaceSetUpDataTransForm(InspectionKind,SDNum);
    SetUpDataTransFormForThreeD(InspectionKind,SDNum);
  }
}
//---------------------------------------------------------------------------






